import sys, traceback
from enum import Enum

import numpy as np

from AdvancedWidgets import AdvancedWidget
from CustomWidgets import MyComboBoxObject, MyLineEdit, MyCheckBox, MyComboBoxEnum,MyTextEdit,MyFileSelector
from FormulaWidget import FormulaWidget
from MatrixCreatorWidget import LabelMatrixCreator
from HistogramWidget import HistogramWidget, HistogramTableWidget,HistogramMeasureWidget,HistogramMeasureTableWidget
from HistogramLabelWidget import HistogramLabelWidget, HistogramLabelTableWidget
from StatisticsWidget import StatisticsWidget
from ShapeAnalysisWidget import MeasureInfoSetWidget
from SelectorWidget import SelectorWidget, RangeSelectorWidget,SimpleRangeSelectorWidget,HysteresisSelectorWidget
from ShapeAnalysisDisplayer import ShapeAnalysisDisplayer
from ShapeDisplayer import ShapeDisplayer#,ShapeDisplayer3D
from MeasureDisplayer import measureDisplayer
from FeatureDisplayer import FeatureDisplayer, FeatureTableDisplayer
from DisplayerCentroid import CentroidDisplayer
from VectorialFieldDisplayer import VectorialFieldDisplayer,VectorialFieldTableDisplayer
from TransformationDisplayer import TransformationTableDisplayer,StackTransformationTableDisplayer
from SieveWidget import ComboBoxSieveWithButton

from DictionaryCustomObject import dictCustomObject
import UsefullDisplay as display
import UsefullVariables as vrb
import UsefullFunctions as fct

import PyIPSDKBase


from PyQt5 import QtWidgets as qt

# If an InputType is also an OutputType, they must be in both enum AND MUST have the same name and value
class InputType(Enum):
    IMAGE = "Image"
    SCALAR = "Scalar"
    SCALAR_CHOICE = "Scalar_Choice"
    BOOLEAN = "Boolean"
    ENUM = "Enumerate"
    STRING = "String"
    STRING_EDIT = "String_Edit"
    FOLDER_FILE = "Folder_File"
    ADVANCED = "Advanced"
    KERNEL_2D = "Kernel_2D"
    FORMULA = "Formula"
    MEASURE_INFO_SET = "Measure_Info_Set"
    SELECTOR = "Selector"
    HISTOGRAM = "Histogram"
    SHAPE_ANALYSIS = "ShapeAnalysis"
    SIEVE = "Sieve"
    SHAPES = "Shapes"
    STATISTICS = "Statistics"
    CENTROID = "Centroid"
    MEASURE = "Measure"
    FEATURE = "Feature"
    TRANSFORMATION = "Transformation"
    STACKTRANSFORMATION = "StackTransformation"
    MACHINE_LEARNING_SMART_SEGMENTATION = "Machine_Learning_Smart_Segmentation"
    MACHINE_LEARNING_SMART_CLASSIFICATION = "Machine_Learning_Smart_Classification"
    MACHINE_LEARNING_SUPER_PIXELS = "Machine_Learning_Super_Pixels"

    @staticmethod
    def stringToType(string):
        for elem in InputType:
            if string == elem.value:
                return elem

    @staticmethod
    def typeToClass(inputType):
        widgetClass = None
        if inputType in comboBoxTypes:
            widgetClass = MyComboBoxObject
        elif inputType == InputType.SCALAR:
            widgetClass = MyLineEdit
        elif inputType == InputType.SCALAR_CHOICE:
            widgetClass = MyLineEdit
        elif inputType == InputType.BOOLEAN:
            widgetClass = MyCheckBox
        elif inputType == InputType.ENUM:
            widgetClass = MyComboBoxEnum
        elif inputType == InputType.STRING:
            widgetClass = MyLineEdit
        elif inputType == InputType.STRING_EDIT:
            widgetClass = MyTextEdit
        elif inputType == InputType.FOLDER_FILE:
            widgetClass = MyFileSelector
        elif inputType == InputType.ADVANCED:
            widgetClass = AdvancedWidget
        elif inputType == InputType.KERNEL_2D:
            widgetClass = LabelMatrixCreator
        elif inputType == InputType.FORMULA:
            widgetClass = FormulaWidget
        elif inputType == InputType.MEASURE_INFO_SET:
            widgetClass = MeasureInfoSetWidget
        elif inputType == InputType.SELECTOR:
            widgetClass = SelectorWidget
        elif inputType == InputType.SIEVE:
            widgetClass = ComboBoxSieveWithButton
        else:
            print('ERROR: Could not convert InputType : ' + str(inputType) + ' to widgetClass', file=sys.stderr)
        return widgetClass


comboBoxTypes = [
    InputType.IMAGE, InputType.IMAGE.value,
    InputType.HISTOGRAM, InputType.HISTOGRAM.value,
    InputType.SHAPE_ANALYSIS, InputType.SHAPE_ANALYSIS.value,
    InputType.SHAPES, InputType.SHAPES.value,
    InputType.STATISTICS, InputType.STATISTICS.value,
    InputType.CENTROID, InputType.CENTROID.value,
    InputType.MEASURE, InputType.MEASURE.value,
    InputType.FEATURE, InputType.FEATURE.value,
    InputType.TRANSFORMATION, InputType.TRANSFORMATION.value,
    InputType.STACKTRANSFORMATION, InputType.STACKTRANSFORMATION.value
]


class OutputType(Enum):
    IMAGE = "Image"
    SHAPE_ANALYSIS = "ShapeAnalysis"
    HISTOGRAM = "Histogram"
    HISTOGRAM_MEASURE = "HistogramMeasure"
    HISTOGRAM_LABEL = "HistogramLabel"
    STATISTICS = "Statistics"
    SHAPES = "Shapes"
    CENTROID = "Centroid"
    MEASURE = "Measure"
    FEATURE = "Feature"
    VECTORIAL_FILED = "VectorialField"
    TRANSFORMATION = "Transformation"
    STACKTRANSFORMATION = "StackTransformation"

    # statisticsWidget = StatisticsWidget()

    @staticmethod
    def stringToType(string):
        for elem in OutputType:
            if string == elem.value:
                return elem

    @staticmethod
    def typeToPrefix(type):
        if type in (OutputType.IMAGE, OutputType.IMAGE.value):
            return 'img'
        elif type in (OutputType.HISTOGRAM, OutputType.HISTOGRAM.value):
            return 'hist'
        elif type in (OutputType.HISTOGRAM_MEASURE, OutputType.HISTOGRAM_MEASURE.value):
            return 'hist_measure'
        elif type in (OutputType.HISTOGRAM_LABEL, OutputType.HISTOGRAM_LABEL.value):
            return 'hist_label'
        elif type in (OutputType.STATISTICS, OutputType.STATISTICS.value):
            return 'stats'
        elif type in (OutputType.SHAPE_ANALYSIS, OutputType.SHAPE_ANALYSIS.value):
            return 'shapesAnalysis'
        elif type in (OutputType.SHAPES, OutputType.SHAPES.value):
            return 'shapes'
        elif type in (OutputType.MEASURE, OutputType.MEASURE.value):
            return 'value'
        elif type in (OutputType.FEATURE, OutputType.FEATURE.value):
            return 'feature'
        elif type in (OutputType.CENTROID, OutputType.CENTROID.value):
            return 'centroid'
        else:
            return type.lower()

    @staticmethod
    def displayer(xmlElement, object, valueSpoiler,currentWidget):
        try:
            type = xmlElement.tag
            if type == OutputType.HISTOGRAM or type == OutputType.HISTOGRAM.value:
                return HistogramWidget(object,xmlElement=xmlElement)
            elif type == OutputType.HISTOGRAM_MEASURE or type == OutputType.HISTOGRAM_MEASURE.value:
                return HistogramMeasureWidget(object,xmlElement=xmlElement)
            elif type == OutputType.HISTOGRAM_LABEL or type == OutputType.HISTOGRAM_LABEL.value:
                return HistogramLabelWidget(object,xmlElement=xmlElement)
            elif type == OutputType.SHAPE_ANALYSIS or type == OutputType.SHAPE_ANALYSIS.value:
                return ShapeAnalysisDisplayer(xmlElement, object)
            elif type == OutputType.SHAPES or type == OutputType.SHAPES.value:
                if object.objectType == "2D":
                    return ShapeDisplayer(mainWindow=valueSpoiler.mainWindow, object=object)
            elif type in [OutputType.FEATURE, OutputType.FEATURE.value]:
                return FeatureDisplayer(xmlElement, object, valueSpoiler, valueSpoiler.mainWindow,currentWidget)
            elif type in [OutputType.VECTORIAL_FILED, OutputType.VECTORIAL_FILED.value]:
                return VectorialFieldDisplayer(object)
            else:
                return None
        except:
            traceback.print_exc(file=sys.stderr)
            return None

    @staticmethod
    def valueTableDisplayer(xmlElement, object, valueSpoiler, currentWidget):

        try:
            type = xmlElement.tag
            if type == OutputType.HISTOGRAM or type == OutputType.HISTOGRAM.value:
                return HistogramTableWidget(object)
            elif type == OutputType.HISTOGRAM_MEASURE or type == OutputType.HISTOGRAM_MEASURE.value:
                return HistogramMeasureTableWidget(object)
            elif type == OutputType.HISTOGRAM_LABEL or type == OutputType.HISTOGRAM_LABEL.value:
                return HistogramLabelTableWidget(object)
            elif type == OutputType.STATISTICS or type == OutputType.STATISTICS.value:
                return StatisticsWidget.getInstance(object, valueSpoiler)
            elif type in [OutputType.MEASURE, OutputType.MEASURE.value]:
                displayer,ddict = measureDisplayer(xmlElement, object, valueSpoiler, valueSpoiler.mainWindow, currentWidget)
                return displayer
            elif type in [OutputType.FEATURE, OutputType.FEATURE.value]:
                return FeatureTableDisplayer(xmlElement, object, valueSpoiler, valueSpoiler.mainWindow)
            elif type in [OutputType.CENTROID, OutputType.CENTROID.value]:
                return CentroidDisplayer(object)
            elif type in [OutputType.VECTORIAL_FILED, OutputType.VECTORIAL_FILED.value]:
                return VectorialFieldTableDisplayer(object)
            elif type in [OutputType.TRANSFORMATION, OutputType.TRANSFORMATION.value]:
                return TransformationTableDisplayer(object)
            elif type in [OutputType.STACKTRANSFORMATION, OutputType.STACKTRANSFORMATION.value]:
                return StackTransformationTableDisplayer(object)
            else:
                return None
        except:
            traceback.print_exc(file=sys.stderr)
            return None

class ImageConstraint(Enum):
    MESH = "Mesh"
    ANY = "Any"
    TWO_DIMENSIONS = "2D"
    THREE_DIMENSIONS = "3D"
    SEQUENCE = "Seq"
    THREE_DIMENSIONS_OR_SEQUENCE = "3D_Or_Seq"
    COLOR = "Color"
    BUFFER_TYPE_BINARY = "Buffer_Type_Binary"
    BUFFER_TYPE_LABEL = "Buffer_Type_Label"
    BUFFER_TYPE_BINARY_OR_LABEL = "Buffer_Type_Binary_Or_Label"
    BUFFER_TYPE_REAL = "Buffer_Type_Real"
    BUFFER_TYPE_INT_OR_REAL = "Buffer_Type_Int_Or_Real"
    BUFFER_TYPE_UINT = "Buffer_Type_UInt"
    BUFFER_TYPE_INT = "Buffer_Type_Int"
    BUFFER_TYPE_NOTBINARY = "Buffer_Type_Not_Binary"
    GREY = 'Grey'

class ShapeConstraints(Enum):
    TWO_DIMENSIONS = "2D,MultiSlice"
    THREE_DIMENSIONS = "3D"

class ScalarConstraint(Enum):
    REAL = "Real"
    NATURAL = "Natural"
    RELATIVE = "Relative"
    ANY = "ANY"

class MeasureInfoSetConstraint(Enum):
    TWO_DIMENSIONS = "2D"
    THREE_DIMENSIONS = "3D"

class CentroidConstraints(Enum):
    CLUSTER_CENTER = 'ClusterCenter'
    KKMEANS_CENTROID = 'KKMeansCentroids'

class FeatureConstraints(Enum):
    SPHERE = 'HoughSpheres3d'

class SelectorType(Enum):
    RANGE = 'RangeSelector'
    SIMPLERANGE = 'SimpleRangeSelector'
    HYSTERESIS = 'Hysteresis'
    ROI = 'ROISelector'

    @staticmethod
    def selectorWidget(selectorType):
        if selectorType == SelectorType.RANGE or selectorType == SelectorType.RANGE.value:
            return RangeSelectorWidget
        elif selectorType == SelectorType.HYSTERESIS or selectorType == SelectorType.HYSTERESIS.value:
            return HysteresisSelectorWidget
        elif selectorType == SelectorType.SIMPLERANGE or selectorType == SelectorType.SIMPLERANGE.value:
            return SimpleRangeSelectorWidget
        else:
            print('ERROR: No selector widget for ' + str(selectorType))

class FunctionDimension(Enum):
    BOTH = 'Both'
    TWO_DIMENSIONS = '2D'
    THREE_DIMENSIONS = '3D'

class MachineLearningConstraint(Enum):
    SMART_SEGMENTATION = "Smart_Segmentation"
    SMART_CLASSIFICATION = "Smart_Classification"
    SMART_SUPER_PIXELS = "Smart_Super_Pixels"

class IPSDKType(Enum):

    HISTOGRAM = PyIPSDKBase.HistogramData
    HISTOGRAMPLANINDEXED = PyIPSDKBase.PlanIndexedHistogramData
    SHAPEANALYSIS = PyIPSDKBase.MeasureSet
    SHAPEANALYSIS_MULTISLICE = PyIPSDKBase.PlanIndexedMeasureSet
    SHAPESEGMENTATION_SHAPES_2D = PyIPSDKBase.Shape2dColl
    SHAPESEGMENTATION_SHAPES_3D = PyIPSDKBase.Shape3dColl
    MESH = PyIPSDKBase.StdMesh3d
