import os, sys

import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import ScriptFunction
import ScriptFunction as Sfct
import WidgetTypes
from SpoilerWidget import SpoilersContainer, Spoiler
import UsefullWidgets as wgt
from DictionaryCustomObject import dictCustomObject
from ShapeAnalysisDisplayer import ShapeAnalysisDisplayer

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

# import ElementIDManager as idManager
import UsefullVariables as vrb
import UsefullTexts as txt

import PyIPSDK



import traceback

import uuid
import pickle

class WidgetLabelValue(qt.QScrollArea):
    def __init__(self, xmlAllValues=None, mainWindow=None):
        qt.QScrollArea.__init__(self)

        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.xmlAllValues = xmlAllValues

        self.centralWidget = ValuesSpoilersContainer(self.xmlAllValues, mainWindow=mainWindow)

        self.setWidget(self.centralWidget)

        # self.layout.setContentsMargins(5,5,20,5)

    def resizeEvent(self, event):
        #self.centralWidget = qt.QWidget()
        #self.centralWidget.setLayout(self.layout)
        self.centralWidget.setFixedWidth(max(1,self.width() * 100 / 100 - 20*vrb.ratio))
        self.setWidget(self.centralWidget)

    def addValue(self, outputDict, ipsdkObject, functionXmlElement,id=None):

        return self.centralWidget.addValue(outputDict, ipsdkObject, functionXmlElement,id=id)

    def numIDToValue(self, numID, typeElem):
        return self.centralWidget.numIDToValue(numID, typeElem)


class ValuesSpoilersContainer(SpoilersContainer):

    SignalCurrentValueChanged = pyqtSignal()

    def __init__(self, xmlElement, mainWindow=None):
        super().__init__()
        self.onlyOne = False

        self.xmlElement = xmlElement
        self.currentValue = None

        self.spoilers = {}

        for outType in WidgetTypes.OutputType:
            if outType != WidgetTypes.OutputType.IMAGE:
                spoiler = ValuesSpoiler(self.xmlElement, outType, mainWindow=mainWindow)
                self.addSpoiler(spoiler)
                self.spoilers[outType.value] = spoiler
                spoiler.SignalWidgetChanged.connect(self.emitSignalCurrentValueChanged)

        self.SignalWidgetChanged.connect(self.emitSignalCurrentValueChanged)

        self.changeHeight()

    def emitSignalCurrentValueChanged(self):
        self.SignalCurrentValueChanged.emit()

    def addValue(self, outputDict, ipsdkObject, functionXmlElement,id=None):

        type = outputDict["Type"]
        return self.spoilers[type].addValue(outputDict, ipsdkObject, functionXmlElement,id=id)

    def changeCurrentValue(self):
        if self.currentWidget is None:
            self.currentValue = None
        else:
            # currentValue is of type LabelValue
            self.currentValue = self.currentWidget.xmlElement

    def numIDToValue(self, numID, typeElem):
        spoiler = self.spoilers[typeElem]
        valuesContainer = spoiler.widget
        for i in range(len(valuesContainer.layout)):
            item = valuesContainer.layout.itemAt(i)
            if item is not None:
                widget = item.widget()
                if Dfct.childText(widget.xmlElement, 'ElementID') == numID:
                    value = widget.object
                    return value


class ValuesSpoiler(Spoiler):
    SignalWidgetChanged = pyqtSignal()
    signalLabelDeletePosition = pyqtSignal()
    SignalNameHasChanged = pyqtSignal()
    SignalLabelOverwritten = pyqtSignal()

    def __init__(self, xmlElement, type, mainWindow=None):
        # Contient tous les éléments
        self.xmlElement = xmlElement
        self.type = type
        self.mainWindow = mainWindow

        self.groupBoxValues = LabelValuesContainer(parent=self)

        super().__init__(widget=self.groupBoxValues, title=type.value)

        # spoilersContainer.SignalWidgetChanged.connect(self.emitSignalWidgetChanged)
        font = self.doubleLabelHeader.label.font()
        font.setBold(True)
        self.doubleLabelHeader.label.setFont(font)
        self.doubleLabelHeader.labelCollapse.setFont(font)
        # spoilersContainer.SignalHeightChanged.connect(self.changeHeight)


    def emitSignalWidgetChanged(self):
        self.SignalWidgetChanged.emit()

    def unselectAll(self):
        layout = self.widget.layout
        nbWidget = layout.count()
        for i in range(nbWidget):
            item = layout.itemAt(i)
            if item is not None:
                labelValue = item.widget()
                try:
                    labelValue.setSelected(False)
                except:
                    pass

    def detectSelectedOjects(self,rectangle):

        layout = self.widget.layout
        nbWidget = layout.count()
        for i in range(nbWidget):
            item = layout.itemAt(i)
            if item is not None:
                labelValue = item.widget()
                # rectangleLabelValue = QtCore.QRect(self.parent.mapFromGlobal(self.mapToGlobal(self.buttonCalibration.pos())), self.buttonCalibration.size())
                rectangleLabelValue = QtCore.QRect(labelValue.pos(), labelValue.size())
                labelValue.setSelected(rectangleLabelValue.intersects(rectangle))

    def addValue(self, outputDict, ipsdkObject, functionXmlElement,id=None):

        if id is None:
            id = str(uuid.uuid4()).replace('-','')

        name = outputDict['Name']
        type = outputDict['Type']
        xmlElementLabel = None
        label = None

        if name == '' or name is None or name == 'None':
            # Default name
            try:
                defaultStart = dictCustomObject[ipsdkObject.subType]['Name'] + '_'
            except:
                defaultStart = type + '_'
            maxi = -1
            for xmlValue in self.xmlElement:
                valueName = Dfct.childText(xmlValue, 'Name')
                if defaultStart in valueName:
                    valueName = valueName.split(defaultStart)
                    maxi = max(maxi, int(valueName[1]))
            name = defaultStart + str(maxi + 1)

        layout = self.widget.layout
        nbWidget = layout.count()
        for i in range(nbWidget):
            item = layout.itemAt(i)
            if item is not None:
                labelValue = item.widget()
                itemXmlElement = labelValue.xmlElement
                if Dfct.childText(itemXmlElement, 'Name') == name:
                    xmlElementLabel = itemXmlElement
                    label = labelValue

        xmlElementNewLabel = xmlet.SubElement(self.xmlElement, type)
        Dfct.SubElement(xmlElementNewLabel, "Name").text = name
        # Dfct.SubElement(xmlElementNewLabel, "ElementID").text = str(idManager.maxElementID(self.xmlElement) + 1)
        Dfct.SubElement(xmlElementNewLabel, "ElementID").text = id
        # Dfct.SubElement(xmlElementNewLabel, "ReferenceID").text = id
        xmlElementNewLabel.append(functionXmlElement)

        if xmlElementLabel is None:
            Dfct.SubElement(xmlElementNewLabel, "Position").text = str(layout.count())
        else:
            # if the label already exists, we delete it before creating a new one.
            Dfct.SubElement(xmlElementNewLabel, "Position").text = Dfct.SubElement(xmlElementLabel, "Position").text
            label.object = None
            self.deleteLabel(label, actualize=False)

        if type == WidgetTypes.OutputType.SHAPES.value:
            Dfct.SubElement(xmlElementNewLabel, "ObjectType").text = ipsdkObject.objectType
        elif type == WidgetTypes.OutputType.CENTROID.value:
            Dfct.SubElement(xmlElementNewLabel, "ObjectType").text = ipsdkObject.subType

        # create the label
        label = LabelValue(ipsdkObject, xmlElementNewLabel, valueSpoiler=self)
        label.signalLabelDelete.connect(self.deleteLabel)
        label.SignalNameHasChanged.connect(self.emitSignalNameHasChanged)
        self.widget.layout.insertWidget(int(Dfct.SubElement(xmlElementNewLabel, "Position").text), label)

        # vrb.mainWindow.widgetLabelImage.layout.addWidget(label)

        self.widget.changeHeight()
        self.changeHeight()

        # typeToDisplay = [WidgetTypes.OutputType.HISTOGRAM.value, WidgetTypes.OutputType.STATISTICS.value, WidgetTypes.OutputType.SHAPE_ANALYSIS.value, WidgetTypes.OutputType.FEATURE.value,
        #             WidgetTypes.OutputType.MEASURE.value]

        try:
            file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
            settingsElement = file.getroot()
            display3DShapesElement = Dfct.SubElement(settingsElement, "Display3DShapes")
            display3DShapes = display3DShapesElement.text
        except:
            display3DShapes = "True"

        try:
            displayValue = True
            if type == WidgetTypes.OutputType.SHAPES.value and ipsdkObject.objectType=="3D" and display3DShapes!="True":
                displayValue = False
            if type == WidgetTypes.OutputType.MEASURE.value and dictCustomObject[ipsdkObject.subType]["Object"] in ["ListPixelsPath","ListVoxelsPath"]:
                displayValue = False
        except:
            displayValue = True

        # if type in typeToDisplay or (type == WidgetTypes.OutputType.SHAPES.value and (ipsdkObject.objectType == "2D" or (ipsdkObject.objectType=="3D" and display3DShapes=="True"))):
        if displayValue:
            if label.objectDisplayer is not None:
                label.showValue(1)
            else:
                if label.objectTableDisplayer is not None:
                    label.showTableDisplayer(1)
        self.SignalNameHasChanged.emit()

        label.name = name
        outputDict['Name'] = name
        vrb.dictElements[id] = [outputDict,ipsdkObject,functionXmlElement,label]

        return label, name

    def deleteLabel(self, widget, actualize = True):

        layout = self.widget.layout
        nbWidget = layout.count()
        for i in range(nbWidget+1):
            item = layout.itemAt(i)
            if item is not None:
                if item.widget() == widget:
                    if widget.objectDisplayer is not None:
                        widget.objectDisplayer.stopDisplay()
                    if widget.objectTableDisplayer is not None:
                        widget.objectTableDisplayer.stopDisplay()
                    item.widget().deleteLater()
                    layout.removeItem(item)
        # self.widget.setLayout(layout)

        #widgetPosition = int(Dfct.childText(widget.xmlElement, "Position"))
        Dfct.SubElement(widget.xmlElement, "Position").text = '-1'
        if actualize:
            self.actualizePosition()
            #self.signalLabelDeletePosition.emit(widgetPosition)
            self.signalLabelDeletePosition.emit()
        else:
            self.SignalLabelOverwritten.emit()

        self.widget.changeHeight()
        self.changeHeight()

        # idManager.actualizeAllElements(self.xmlElement)

    def actualizePosition(self):

        for num in range(self.widget.layout.count()):
            item=self.widget.layout.itemAt(num)
            if item is not None:
                widget = item.widget()
                position = Dfct.SubElement(widget.xmlElement, "Position")
                position.text = str(num)


    def emitSignalNameHasChanged(self):
        self.SignalNameHasChanged.emit()


class LabelValuesContainer(qt.QGroupBox):
    def __init__(self,parent=None):
        super().__init__()

        self.parent = parent

        self.rubberBand = qt.QRubberBand(qt.QRubberBand.Rectangle, self)
        self.origin = None

        self.margins = [0, 0, 0, 5]
        self.spacing = 0
        self.layout = qt.QVBoxLayout()
        self.layout.setAlignment(Qt.AlignTop)
        self.layout.setContentsMargins(*self.margins)
        self.layout.setSpacing(self.spacing)
        self.setLayout(self.layout)
        self.setStyleSheet("QGroupBox {border: 0px transparent;}")

    def changeHeight(self):
        nbWidget = self.layout.count()
        totalHeight = self.margins[1] + self.margins[3]
        totalHeight += (nbWidget-1) * self.spacing
        for i in range(nbWidget):
            item = self.layout.itemAt(i)
            if item is not None:
                totalHeight += item.widget().height()
        totalHeight = max(1,totalHeight)
        self.setFixedHeight(totalHeight)

    def resizeEvent(self, event):
        self.changeHeight()

    def mousePressEvent(self, event):
        self.origin = event.pos()
        if not self.rubberBand:
            self.rubberBand = qt.QRubberBand(qt.QRubberBand.Rectangle, self)
        self.rubberBand.setGeometry(QtCore.QRect(self.origin, QtCore.QSize()))
        self.rubberBand.show()

    def mouseMoveEvent(self, event):
        try:
            rectangle = QtCore.QRect(self.origin, event.pos()).normalized()
            self.rubberBand.setGeometry(rectangle)
            self.parent.detectSelectedOjects(rectangle)
        except:
            pass

    def mouseReleaseEvent(self, event):

        self.rubberBand.hide()

class LabelValue(qt.QGroupBox):

    signalLabelDelete = pyqtSignal(qt.QGroupBox)
    SignalNameHasChanged = pyqtSignal()

    def __init__(self, object, xmlElement, valueSpoiler=None):
        qt.QGroupBox.__init__(self)

        self.isSelected = False

        self.xmlElement = xmlElement

        self.valueSpoiler = valueSpoiler
        self.object = object
        self.object.xmlElement = xmlElement
        self.name = Dfct.childText(self.xmlElement, "Name")

        if self.valueSpoiler.type in [WidgetTypes.OutputType.SHAPE_ANALYSIS,WidgetTypes.OutputType.SHAPE_ANALYSIS.value]:
            self.nameImage = ""
            try:
                for num in range(vrb.mainWindow.widgetLabelImage.layout.count()):
                    item = vrb.mainWindow.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        if label.image == self.object.imageLabel:
                            self.nameImage = label.name
            except:
                traceback.print_exc(file=sys.stderr)

        self.labelHeight = 22*vrb.ratio

        self.customContextMenu = wgt.CustomContextMenu(self)
        self.customContextMenu.addAction('Properties', self.showProperties)
        self.customContextMenu.addAction('Generate Function Script', self.generateFunctionScript)
        self.customContextMenu.addAction('Generate Complete Script', self.generateCompleteScript)
        self.customContextMenu.addAction('Save as...', self.saveOjectIPSDK)

        self.contextMenuSelected = wgt.CustomContextMenuReference(self)
        self.contextMenuSelected.addAction('Delete', self.deleteSelectedLabel)
        if self.valueSpoiler.type == WidgetTypes.OutputType.SHAPE_ANALYSIS or self.valueSpoiler.type == WidgetTypes.OutputType.SHAPE_ANALYSIS.value:
            self.contextMenuSelected.addAction('Generate multi analysis', self.generateMultiAnalysis)

        self.scriptWindow = ScriptFunction.ScriptWindow(valueSpoiler.mainWindow, xmlElement=self.xmlElement)
        self.propertiesWindow = wgt.PropertiesWindow(self.xmlElement)

        self.labelButtonDisplay = wgt.SwitchingLabel(wgt.LabelImage(vrb.folderImages + '/eye_close.png'), wgt.LabelImage(vrb.folderImages + '/eye_open.png'))
        self.labelButtonDisplay.setFixedSize(20*vrb.ratio, 20*vrb.ratio)
        self.labelButtonDisplay.setToolTip(txt.dictToolTips["Display"])

        self.labelButtonTableDisplay = wgt.SwitchingLabel(wgt.LabelImage(vrb.folderImages + '/tableau_close.png'), wgt.LabelImage(vrb.folderImages + '/tableau.png'))
        self.labelButtonTableDisplay.setFixedSize(20*vrb.ratio, 20*vrb.ratio)
        self.labelButtonTableDisplay.setToolTip(txt.dictToolTips["Table"])

        self.labelButtonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=0)
        self.labelButtonSave.setFixedSize(20*vrb.ratio, 20*vrb.ratio)
        self.labelButtonSave.setToolTip(txt.dictToolTips["Save_Only"])

        self.editableLabelName = wgt.EditableLabel('')
        self.labelName = self.editableLabelName.label
        self.labelName.setContentsMargins(5, 0, 0, 0)
        if Dfct.childText(self.xmlElement, "Name") is not None:
            self.labelName.setText(Dfct.childText(self.xmlElement, "Name"))

        self.labelDelete = wgt.LabelDelete()
        self.labelDelete.setFixedSize(self.labelHeight, self.labelHeight)

        self.objectDisplayer = WidgetTypes.OutputType.displayer(self.xmlElement, self.object, self.valueSpoiler, self)
        self.objectTableDisplayer = WidgetTypes.OutputType.valueTableDisplayer(self.xmlElement, self.object, self.valueSpoiler, self)

        type = self.xmlElement.tag

        self.layout = qt.QGridLayout()
        if self.objectDisplayer is not None:
            self.layout.addWidget(self.labelButtonDisplay, 0, self.layout.columnCount())
        if self.objectTableDisplayer is not None:
            self.layout.addWidget(self.labelButtonTableDisplay, 0, self.layout.columnCount())

        if type == WidgetTypes.OutputType.SHAPES or type == WidgetTypes.OutputType.SHAPES.value:
            if self.object.objectType == "3D":
                self.layout.addWidget(self.labelButtonSave, 0, self.layout.columnCount())

        self.layout.addWidget(self.editableLabelName, 0, self.layout.columnCount())
        self.layout.addWidget(self.labelDelete, 0, self.layout.columnCount(), Qt.AlignRight)
        self.setLayout(self.layout)

        self.setFixedHeight(self.labelHeight)
        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setSizeConstraint(1)
        self.layout.setHorizontalSpacing(1)

        self.setStyleSheet('QGroupBox {border: 1px solid gray;}')

        # delete
        self.labelDelete.mousePressEvent = self.showConfirmWidget
        self.customContextMenu.signalDelete.connect(self.showConfirmWidget)
        # left click
        self.labelButtonDisplay.SignalWidgetSwitched.connect(self.showValue)
        self.labelButtonTableDisplay.SignalWidgetSwitched.connect(self.showTableDisplayer)
        self.labelButtonSave.clicked.connect(self.saveObject)
        # right click
        self.labelName.setContextMenuPolicy(Qt.CustomContextMenu)
        # self.labelName.customContextMenuRequested.connect(self.customContextMenu.showMenu)
        self.labelName.customContextMenuRequested.connect(self.showMenu)
        # text changed
        self.editableLabelName.SignalLabelTextChanged.connect(self.nameHasChanged)
        # displayer close event
        if self.xmlElement.tag == WidgetTypes.OutputType.STATISTICS.value:
            if (0, 0, 0) in PyIPSDK.toPyDict(self.object):
                if self.objectDisplayer is not None:
                    self.objectDisplayer.closeEvent = self.closeEventObjectDisplayer
                if self.objectTableDisplayer is not None:
                    self.objectTableDisplayer.closeEvent = self.closeEventTableDisplayer
        else:
            if self.objectDisplayer is not None:
                self.objectDisplayer.closeEvent = self.closeEventObjectDisplayer
            if self.objectTableDisplayer is not None:
                self.objectTableDisplayer.closeEvent = self.closeEventTableDisplayer

    def resizeEvent(self, event):
        self.editableLabelName.setFixedHeight(self.labelHeight)

    def showMenu(self,position):

        if self.isSelected:
            labelsSelected = self.getLabelsSelected()
            if len(labelsSelected) > 1:
                self.contextMenuSelected.showMenu(position)
            else:
                self.customContextMenu.showMenu(position)
        else:
            self.customContextMenu.showMenu(position)

    def getLabelsSelected(self):

        labelsSelected = []

        layout = self.valueSpoiler.widget.layout
        nbWidget = layout.count()
        for i in range(nbWidget):
            item = layout.itemAt(i)
            if item is not None:
                labelValue = item.widget()
                try:
                    if labelValue.isSelected:
                        labelsSelected.append(labelValue)
                except:
                    pass

        return labelsSelected

    def deleteSelectedLabel(self):

        labelsToDelete = self.getLabelsSelected()

        if len(labelsToDelete) == 1:
            self.showConfirmWidget(None)
        elif len(labelsToDelete) != 0:
            messageBox = wgt.MessageBox('Are you sure you want to delete these ' + str(len(labelsToDelete)) + ' measures', '', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No],icon=qt.QMessageBox.Warning)
            res = messageBox.exec()
            if res == qt.QMessageBox.Yes:
                for labelValue in labelsToDelete:
                    labelValue.emitSignalLabelDelete()

    def generateMultiAnalysis(self):

        labelsSelected = self.getLabelsSelected()
        verifyAnalysis = True
        for labelValue in labelsSelected:
            if type(labelValue.object) != WidgetTypes.IPSDKType.SHAPEANALYSIS.value:
                verifyAnalysis = False
        if verifyAnalysis == False:
            self.messageBox = wgt.MessageBox("You can't merge multi slice analysis", '', buttons=[qt.QMessageBox.Ok], icon=qt.QMessageBox.Warning, windowTitle="Error")
            self.messageBox.exec()
        else:
            analysisToRemove = []
            for analysis in vrb.mergedAnalysis:
                if analysis.isVisible() == False:
                    analysisToRemove.append(analysis)
            for analysis in analysisToRemove:
                vrb.mergedAnalysis.remove(analysis)

            displayerAnalysis = ShapeAnalysisDisplayer(None,labelsSelected)
            vrb.mergedAnalysis.append(displayerAnalysis)
            displayerAnalysis.show()

    def mousePressEvent(self, event):

        modifierPressed = qt.QApplication.keyboardModifiers()

        if event.button() == QtCore.Qt.LeftButton:
            try:
                if (modifierPressed & Qt.ControlModifier) == Qt.ControlModifier:
                    self.changeSelected()
                else:
                    self.valueSpoiler.unselectAll()
            except:
                self.setSelected(False)

        self.valueSpoiler.groupBoxValues.origin =self.valueSpoiler.groupBoxValues.mapFromGlobal(self.mapToGlobal(event.pos()))
        if not self.valueSpoiler.groupBoxValues.rubberBand:
            self.valueSpoiler.groupBoxValues.rubberBand = qt.QRubberBand(qt.QRubberBand.Rectangle, self.valueSpoiler.groupBoxValues)
        self.valueSpoiler.groupBoxValues.rubberBand.setGeometry(QtCore.QRect(self.valueSpoiler.groupBoxValues.origin, QtCore.QSize()))
        self.valueSpoiler.groupBoxValues.rubberBand.show()

    def mouseMoveEvent(self, event):

        try:
            eventPos = self.valueSpoiler.groupBoxValues.mapFromGlobal(self.mapToGlobal(event.pos()))
            rectangle = QtCore.QRect(self.valueSpoiler.groupBoxValues.origin, eventPos).normalized()

            self.valueSpoiler.groupBoxValues.rubberBand.setGeometry(rectangle)

            self.valueSpoiler.detectSelectedOjects(rectangle)
        except:
            pass

    def mouseReleaseEvent(self, event):

        self.valueSpoiler.groupBoxValues.rubberBand.hide()

    def setSelected(self,boolValue):

        if boolValue:
            self.setStyleSheet("QGroupBox {background-color: rgb(98,98,98);border: 1px solid gray;}")
        else:
            self.setStyleSheet('QGroupBox {border: 1px solid gray;}')
        self.isSelected = boolValue

    def changeSelected(self):

        self.setSelected(not self.isSelected)

    def saveOjectIPSDK(self):

        try:
            # filename = qt.QFileDialog.getSaveFileName(self, "Save as", vrb.folderDefault, "TIF " + 'Image' + " (*.tif)")
            filename = qt.QFileDialog.getSaveFileName(self, "Save object as", vrb.folderDefault + "/","Binary format(*.bin);;XML format (*.xml)")

            if filename[0] is not None and filename[0] != '':
                vrb.mainWindow.groupBoxProcessing.setText('Saving...\nPlease wait.')
                vrb.mainWindow.toggleGroupBoxProcessing(True)

                nameSplit = filename[0].split(".")
                extension = nameSplit[len(nameSplit) - 1]

                if extension in ["xml", "Xml", "XML"]:
                    PyIPSDK.writeToXmlFile(filename[0], self.object)
                elif extension in ["bin","Bin,BIN"]:
                    PyIPSDK.writeToBinaryFile(filename[0], self.object)

                vrb.mainWindow.toggleGroupBoxProcessing(False)
        except:
            traceback.print_exc(file=sys.stderr)
            vrb.mainWindow.toggleGroupBoxProcessing(False)

    def showConfirmWidget(self, event=None):

        modifierPressed = qt.QApplication.keyboardModifiers()

        if event is None or event.button() == QtCore.Qt.LeftButton:
            try:
                if (modifierPressed & Qt.ControlModifier) == Qt.ControlModifier:
                    self.emitSignalLabelDelete()
                else:
                    messageBox = wgt.MessageBox('Are you sure you want to delete the measure: ' + str(Dfct.childText(self.xmlElement, "Name")), '', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No], icon=qt.QMessageBox.Warning)
                    res = messageBox.exec()
                    if res == qt.QMessageBox.Yes:
                        self.emitSignalLabelDelete()
            except:
                messageBox = wgt.MessageBox('Are you sure you want to delete the measure: ' + str(Dfct.childText(self.xmlElement, "Name")), '', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No],icon=qt.QMessageBox.Warning)
                res = messageBox.exec()
                if res == qt.QMessageBox.Yes:
                    self.emitSignalLabelDelete()

    def emitSignalLabelDelete(self):
        self.signalLabelDelete.emit(self)

    def showTableDisplayer(self, state):
        if state == 0:
            try:
                self.objectTableDisplayer.stopDisplay(int(Dfct.childText(self.xmlElement, "Position")))
            except:
                self.objectTableDisplayer.stopDisplay()
        else:
            self.labelButtonTableDisplay.setState(1)
            self.objectTableDisplayer.display(self.xmlElement)


    def closeEventTableDisplayer(self, event: QtGui.QCloseEvent) -> None:
        self.labelButtonTableDisplay.setState(0)

        try:
            if isinstance(self.objectTableDisplayer.object, wgt.Measure):
                if self.objectTableDisplayer.object.subType == 'HoughLines':
                    vrb.currentHoughLine = None
                if self.objectTableDisplayer.object.subType == 'HoughCircles2d':
                    vrb.currentHoughCircle = None
                if self.objectTableDisplayer.object.subType == 'HoughSpheres3d':
                    vrb.currentHoughSphere = None
            if PyIPSDK.Pixels2d == type(self.objectTableDisplayer.object):
                vrb.currentHarrisCorner2d = None
            if PyIPSDK.PlanIndexedPixels2d == type(self.objectTableDisplayer.object):
                vrb.currentHarrisCorner2d = None
            if PyIPSDK.Voxels3d == type(self.objectTableDisplayer.object):
                vrb.currentHarrisCorner3d = None

            vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)
        except:
            pass

    def showValue(self, state):

        try:
            if state == 0:
                try:
                    self.objectDisplayer.stopDisplay(int(Dfct.childText(self.xmlElement, "Position")))
                except:
                    self.objectDisplayer.stopDisplay()
            else:
                self.labelButtonDisplay.setState(1)
                self.objectDisplayer.display(self.xmlElement)
        except:
            traceback.print_exc(file=sys.stderr)

    def saveObject(self):

        type = self.xmlElement.tag
        if type == WidgetTypes.OutputType.SHAPES or type == WidgetTypes.OutputType.SHAPES.value:
            if self.object.objectType == "3D":

                defaultFolder = Dfct.childText(vrb.userPathElement, "SaveStl")
                if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
                    defaultFolder = ""

                filename = qt.QFileDialog.getSaveFileName(self, "Save shape as", defaultFolder + "/", "Binary (*.stl);;ASCII (*.stl)")

                if filename[0] != None and filename[0] != '':
                    try:
                        vrb.mainWindow.groupBoxProcessing.setText('Saving shapes...\nPlease wait.')
                        vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(False)
                        vrb.mainWindow.groupBoxProcessing.progressBar.setVisible(False)
                        vrb.mainWindow.toggleGroupBoxProcessing(True)
                        qt.QApplication.processEvents()
                        if filename[1] == 'Binary (*.stl)':
                            PyIPSDK.saveToStLBinary(filename[0], self.object.getColl(), True)
                        elif filename[1] == 'ASCII (*.stl)':
                            basename = os.path.basename(filename[0])
                            basename = basename.split(".")[0]
                            PyIPSDK.saveToStLAscii(filename[0], self.object.getColl(), True,basename)
                        vrb.mainWindow.toggleGroupBoxProcessing(False)
                        Dfct.SubElement(vrb.userPathElement, "SaveStl").text = os.path.dirname(filename[0])
                        Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")
                    except:
                        import traceback
                        traceback.print_exc(file=sys.stderr)

    def closeEventObjectDisplayer(self, event: QtGui.QCloseEvent) -> None:
        self.labelButtonDisplay.setState(0)

        if self.objectDisplayer == vrb.currentShapeAnalysisDisplayer:
            vrb.barycenterX = None
            vrb.barycenterY = None
            vrb.barycenterZ = None
            vrb.currentShapeAnalysisDisplayer = None
            vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)

    def nameHasChanged(self):
        Dfct.SubElement(self.xmlElement, 'Name').text = self.labelName.text()
        try:
            self.objectDisplayer.loadStatistics()
        except:
            pass
        self.SignalNameHasChanged.emit()

    def showProperties(self):
        if self.object is not None:
            self.propertiesWindow.displayProperties()

    def generateFunctionScript(self):
        script = Sfct.functionScript(self.xmlElement, self.valueSpoiler.xmlElement)
        self.scriptWindow.setText(script)
        self.scriptWindow.pushButtonEditMacro.setVisible(False)
        self.scriptWindow.close()
        self.scriptWindow.show()

    def generateCompleteScript(self):
        script = Sfct.completeScript(self.xmlElement, self.valueSpoiler.xmlElement)
        self.scriptWindow.setText(script)
        self.scriptWindow.pushButtonEditMacro.setVisible(True)
        self.scriptWindow.close()
        self.scriptWindow.show()