import os
import sys, traceback

from PyQt5 import QtCore, QtWidgets as qt
from PyQt5 import QtGui
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication

import UsefullVariables as vrb
import UsefullTexts as txt
import DatabaseFunction as Dfct
import UsefullFunctions as fct
import DrawFunctions as DWfct
# from FunctionsDictionary import dictAllFunctions,dictFolderNames
import UsefullWidgets as wgt
from FunctionsDictionary import dictAllFunctions
import ScriptFunction
from TextEditor import TextEditor
from HighlightTextEditor import PythonHighlighter
from UsefullWidgets import Measure

from processFunction._ProcessFunction import xmlToParamList, addToText

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLBinarization as bin

from ImageViewer import customBlending

import xml.etree.ElementTree as xmlet

import numpy as np
import shutil

import PyIPSDK
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLFeatureDetection as fd
import PyIPSDK.IPSDKIPLStats as stats
import PyIPSDK.IPSDKIPLClassification as classif
import PyIPSDK.IPSDKIPLRegistration as registration
import PyIPSDK.IPSDKIPLMachineLearning as ml

import PyIPSDK.IPSDKUI as ui

try:
    import matplotlib
    matplotlib.use('QT5Agg')
    import matplotlib.pylab as plt
    from matplotlib.backends.qt_compat import QtCore, QtWidgets#, is_pyqt5
    from matplotlib.backends.backend_qt5agg import FigureCanvas, NavigationToolbar2QT as NavigationToolbar
    from matplotlib.figure import Figure
except:
    pass

class WidgetBatch(qt.QWidget):

    def __init__(self, functionWidget):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.errorWindow = wgt.PopUpWindow()

        self.functionWidget = functionWidget

        self.listFolderSelectors = []

        self.outputImage = None

        self.groupBoxInputs = qt.QGroupBox()
        self.groupBoxInputs.setTitle("Inputs")
        self.groupBoxInputs.setStyleSheet('QGroupBox:title {left: 20px ;padding-left: 10px;padding-right: 10px; padding-top: -12px; color:rgb(6, 115, 186)}  QGroupBox {font: bold; border: 1px solid gray; margin-top: 12 px}')
        self.layoutInputs = qt.QVBoxLayout()
        self.groupBoxInputs.setLayout(self.layoutInputs)

        self.groupBoxOutputs = qt.QGroupBox()
        self.groupBoxOutputs.setTitle("Outputs")
        self.groupBoxOutputs.setStyleSheet('QGroupBox:title {left: 20px ;padding-left: 10px;padding-right: 10px; padding-top: -12px; color:rgb(6, 115, 186)}  QGroupBox {font: bold; border: 1px solid gray; margin-top: 12 px}')
        self.layoutOutputs = qt.QVBoxLayout()
        self.groupBoxOutputs.setLayout(self.layoutOutputs)

        self.outputFolderSelector = wgt.FolderSelector(name ="Output folder")
        self.layoutOutputs.addWidget(self.outputFolderSelector)

        self.buttonText = wgt.PushButtonImage(vrb.folderImages + "/text.png")
        self.buttonText.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)
        self.buttonValidate = wgt.PushButtonImage(vrb.folderImages + "/Validate.png")
        self.buttonValidate.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.editBatcchScriptWindow= EditBatcchScriptWindow()

        self.generateWidgets()

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.groupBoxInputs,0,0,1,2)
        self.layout.addWidget(self.groupBoxOutputs,1,0,1,2)
        self.layout.addWidget(self.buttonText,2,0,Qt.AlignRight)
        self.layout.addWidget(self.buttonValidate,2,1)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(25*vrb.ratio, 25*vrb.ratio, 25*vrb.ratio, 25*vrb.ratio)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        # self.setFixedSize(400*vrb.ratio,400*vrb.ratio)

        self.buttonText.clicked.connect(self.showText)
        self.buttonValidate.clicked.connect(self.applyBatch)

        title = Dfct.childText(self.functionWidget.xmlFunctionDescription, "Name")
        self.setWindowTitle("Batch Settings - " + title)

    def createText(self,process=True):

        try:
            file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
            settingsElement = file.getroot()
            mergeAnalysisFormatElement = Dfct.SubElement(settingsElement, "MergeAnalysisFormat")
            mergeAnalysisFormat = mergeAnalysisFormatElement.text
            if mergeAnalysisFormat is None or mergeAnalysisFormat == "":
                mergeAnalysisFormat = "xls"
        except:
            mergeAnalysisFormat = "csv"

        try:
            file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
            settingsElement = file.getroot()
            batchAnalysisFormatElement = Dfct.SubElement(settingsElement, "BatchAnalysisFormat")
            batchAnalysisFormat = batchAnalysisFormatElement.text
            if batchAnalysisFormat is None or mergeAnalysisFormat == "":
                batchAnalysisFormat = "csv"
        except:
            mergeAnalysisFormat = "csv"

        #find first image in working folder
        i=0
        while not os.path.isfile(self.listFolderSelectors[0].lineEditFile.text() + '/' + os.listdir(self.listFolderSelectors[0].lineEditFile.text())[i]):
            i+=1
        # read image to get sizes and see if needs multislice processing
        image = fct.readImage(self.listFolderSelectors[0].lineEditFile.text() + '/' + os.listdir(self.listFolderSelectors[0].lineEditFile.text())[i])
        vrb.sizeZ_imageBatch = str(image.getSizeZ())
        vrb.sizeC_imageBatch = str(image.getSizeC())
        vrb.sizeT_imageBatch = str(image.getSizeT())
        vrb.bufferType_imageBatch = str(image.getBufferType())

        vrb.batch = True
        vrb.batchNumImage = 0

        textBatch = ""
        allID = []

        try:
            xmlFunctionCall = self.functionWidget.xmlParametersProcess
            functionName = Dfct.childText(xmlFunctionCall, 'Name')

            vrb.batchNumImage = 0
            vrb.listBatchImages = []
            for num in range(len(self.listFolderSelectors)):
                if num !=0:
                    folderSelector = self.listFolderSelectors[num]
                    vrb.listBatchImages.append(folderSelector.checkBox.isChecked())

            vrb.batchNumImage = 0

            if functionName == "MacroFunction":
                textFunctionImport = dictAllFunctions[functionName](xmlFunctionCall, outImage=self.outputImage,process=True, synchrone=True)
            else:
                textFunctionImport = dictAllFunctions[functionName](xmlFunctionCall, outImage=self.outputImage,process=True)
            textFunction,textImports = ScriptFunction.separateImports(textFunctionImport)

            vrb.batch = False

            textBatch = ""
            numList = []

            textBatch += "import os\n"
            textBatch += "import sys, traceback\n"
            textBatch += "import UsefullFunctions as fct\n"
            textBatch += "from MeasureDisplayer import measureDisplayer\n"
            textBatch += "import PyIPSDK\n"
            textBatch += textImports + "\n"

            for num in range(len(self.listFolderSelectors)):
                if num == 0:
                    textBatch += "filenameFolder ='" + self.listFolderSelectors[0].lineEditFile.text()+"'\n"
                    textBatch += "listFilenameFolder = os.listdir(filenameFolder)\n"
                else:
                    if self.listFolderSelectors[num].checkBox.isChecked() and self.listFolderSelectors[num].lineEditFile.text()!="" and os.path.exists(self.listFolderSelectors[num].lineEditFile.text()):
                        textBatch += "filenameFolder_"+str(num)+" ='" + self.listFolderSelectors[num].lineEditFile.text() + "'\n"
                        textBatch += "listFilenameFolder_" + str(num) + "= os.listdir(filenameFolder_"+str(num)+")\n"
                        numList.append(num)

            textBatch+= "filenameFolderResult = '"+self.outputFolderSelector.lineEditFile.text() +"'\n"
            textBatch+= "if not os.path.exists(filenameFolderResult):\n"
            textBatch+= "\tos.makedirs(filenameFolderResult)\n"

            for outputNum in range(len(self.listOutputGroupBox)):
                output = self.listOutputGroupBox[outputNum]
                if output.nameType == "Analysis" and output.checkBoxMerge.isChecked():
                    textBatch += "listAnalysis_"+str(outputNum)+" = []\n"
                if output.nameType == "Measure" and output.checkBoxMerge.isChecked():
                    textBatch += "listMeasure_"+str(outputNum)+" = []\n"

            #textBatch = self.addProcessText(textBatch,"nbFiles = 0\nfor file in listFilenameFolder:\n\tif os.path.isfile(filenameFolder + '/' + file):\n\t\tnbFiles+=1\n")

            textBatch = self.addProcessText(textBatch,"numberImages = 0\n",process)
            textBatch = self.addProcessText(textBatch,"vrb.batchNbTotalImages = 0\n",process)
            textBatch = self.addProcessText(textBatch,"vrb.batchNbFailedImages = 0\n",process)
            textBatch = self.addProcessText(textBatch,"for numImage in range(len(listFilenameFolder)):\n",process)
            textBatch = self.addProcessText(textBatch,"\tif os.path.isfile(filenameFolder + '/' + listFilenameFolder[numImage]):\n",process)
            textBatch = self.addProcessText(textBatch,"\t\tnumberImages+=1\n",process)

            textBatch= self.addProcessText(textBatch,"currentNumImage = 1\n",process)
            textBatch+="for numImage in range(len(listFilenameFolder)):\n"
            textBatch+= "\ttry:\n"

            textBatch = self.addProcessText(textBatch, "\t\tvrb.batchImageIsVerified = False\n",process)
            textBatch= self.addProcessText(textBatch,"\t\tif os.path.isfile(filenameFolder + '/' + listFilenameFolder[numImage]):\n",not process)
            textBatch= self.addProcessText(textBatch,"\t\tif os.path.isfile(filenameFolder + '/' + listFilenameFolder[numImage]) and vrb.continueProcess:\n",process)

            textBatch = self.addProcessText(textBatch,"\t\t\tvrb.mainWindow.groupBoxProcessing.setText('Processing batch ('+str(currentNumImage)+'/'+str(numberImages)+')')\n",process)
            textBatch = self.addProcessText(textBatch,"\t\t\tqt.QApplication.processEvents()\n",process)
            textBatch = self.addProcessText(textBatch,"\t\t\tcurrentNumImage += 1\n",process)

            textBatch+="\t\t\tID_ImageBatch_0_ID = fct.readImage(filenameFolder + '/' + listFilenameFolder[numImage])\n"
            textBatch = self.addProcessText(textBatch, "\t\t\tvrb.batchImageIsVerified = True\n",process)
            textBatch = self.addProcessText(textBatch, "\t\t\tvrb.batchNbTotalImages += 1\n", process)

            for numFolder in numList:
                textBatch+="\t\t\tID_ImageBatch_"+ str(numFolder) +"_ID = fct.readImage(filenameFolder_"+str(numFolder)+" + '/' + listFilenameFolder_"+ str(numFolder) +"[numImage])\n"

            textSplit = textFunction.split("\n")
            for line in textSplit:
                textBatch+="\t\t\t"+line+"\n"

            if len(self.listOutputGroupBox) == 1:
                output = self.listOutputGroupBox[0]
                textOutput = output.lineEdit.text()
                if textOutput is None or textOutput == "":
                    textOutput = output.lineEdit.placeholderText()
                if functionName == "MacroFunction":
                    textBatch += "\t\t\toutputs=outputs[0]\n"
                if output.nameType == "Image":
                    textBatch += "\t\t\tPyIPSDK.saveTiffImageFile(filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.tif'), outputs)\n"
                elif output.nameType == "Histogram":
                    textBatch += "\t\t\tPyIPSDK.writeToXmlFile(filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.xml'), outputs)\n"
                elif output.nameType == "Analysis":
                    if batchAnalysisFormat == "xml":
                        textBatch += "\t\t\tPyIPSDK.writeToXmlFile(filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.xml'), outputs)\n"
                    else:
                        textBatch += "\t\t\tdictResult = fct.analysisToDict(outputs)\n"
                    if batchAnalysisFormat == "csv":
                        textBatch += "\t\t\tfct.dictToCsvFile(dictResult,filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.csv'))\n"
                    elif batchAnalysisFormat == "xls":
                        textBatch += "\t\t\tfct.dictToXlsFile(dictResult,filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.xls'))\n"

                    if output.nameType == "Analysis" and output.checkBoxMerge.isChecked():
                        textBatch += "\t\t\toutputs.nameImage = listFilenameFolder[numImage]\n"
                        textBatch += "\t\t\tlistAnalysis_0.append(outputs)\n"
                elif output.nameType == "Measure":
                    textBatch += "\t\t\tdisplayer, ddict = measureDisplayer(None, outputs, None, None, None)\n"
                    textBatch += "\t\t\tfct.saveDictToFile(ddict, filenameFolderResult + '/" + textOutput + "' + listFilenameFolder[numImage])\n"
                    if output.checkBoxMerge.isChecked():
                        textBatch += "\t\t\tlistMeasure_0.append(ddict)\n"
                else:
                    textBatch += "\t\t\tfct.saveMeasureXls(filenameFolderResult + '/" + textOutput + "' + listFilenameFolder[numImage],outputs)\n"

            else:
                for outputNum in range(len(self.listOutputGroupBox)):
                    output = self.listOutputGroupBox[outputNum]
                    textOutput = output.lineEdit.text()
                    if textOutput is None or textOutput == "":
                        textOutput = output.lineEdit.placeholderText()
                    if output.nameType == "Image":
                        textBatch += "\t\t\tPyIPSDK.saveTiffImageFile(filenameFolderResult + '/"+ textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.tif'), outputs["+str(outputNum)+"])\n"
                    elif output.nameType == "Histogram":
                        textBatch += "\t\t\tPyIPSDK.writeToXmlFile(filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.xml'),outputs["+str(outputNum)+"])\n"
                    elif output.nameType == "Analysis":
                        if batchAnalysisFormat == "xml":
                            textBatch += "\t\t\tPyIPSDK.writeToXmlFile(filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.xml'), outputs["+str(outputNum)+"])\n"
                        else:
                            textBatch += "\t\t\tdictResult = fct.analysisToDict(outputs["+str(outputNum)+"])\n"
                        if batchAnalysisFormat == "csv":
                            textBatch += "\t\t\tfct.dictToCsvFile(dictResult,filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.csv'))\n"
                        elif batchAnalysisFormat == "xls":
                            textBatch += "\t\t\tfct.dictToXlsFile(dictResult,filenameFolderResult + '/" + textOutput + "' + fct.changeExtension(listFilenameFolder[numImage],'.xls'))\n"
                        if output.nameType == "Analysis" and output.checkBoxMerge.isChecked():
                            textBatch += "\t\t\toutputs[" + str(outputNum) + "].nameImage = listFilenameFolder[numImage]\n"
                            textBatch += "\t\t\tlistAnalysis_"+str(outputNum)+".append(outputs["+str(outputNum)+"])\n"
                    elif output.nameType == "Measure":
                        # textBatch += "\t\t\tfct.saveMeasureXls(filenameFolderResult + '/" + textOutput + "' + listFilenameFolder[numImage], outputs["+str(outputNum)+"])\n"
                        textBatch += "\t\t\tdisplayer, ddict = measureDisplayer(None, outputs, None, None, None)\n"
                        textBatch += "\t\t\tfct.saveDictToFile(ddict, filenameFolderResult + '/" + textOutput + "' + listFilenameFolder[numImage])\n"
                        if output.checkBoxMerge.isChecked():
                            textBatch += "\t\t\tlistMeasure_" + str(outputNum) + ".append(outputs[" + str(outputNum) + "])\n"
                    else:
                        textBatch += "\t\t\tfct.saveMeasureXls(filenameFolderResult + '/" + textOutput + "' + listFilenameFolder[numImage],outputs)\n"

            textBatch+= "\texcept:\n"
            textBatch = self.addProcessText(textBatch, "\t\tif vrb.batchImageIsVerified:\n", process)
            textBatch = self.addProcessText(textBatch, "\t\t\tvrb.batchNbFailedImages += 1\n", process)
            textBatch+= "\t\ttraceback.print_exc(file=sys.stderr)\n"

            for outputNum in range(len(self.listOutputGroupBox)):
                output = self.listOutputGroupBox[outputNum]
                if output.nameType == "Analysis" and output.checkBoxMerge.isChecked():
                    textBatch += "dictResult = fct.listAnalysisToDict(listAnalysis_"+str(outputNum)+")\n"
                    if mergeAnalysisFormat == "csv":
                        textBatch += "fct.dictToCsvFile(dictResult,filenameFolderResult + '/Merge_Analysis_"+str(outputNum)+".csv')\n"
                    elif mergeAnalysisFormat == "xls":
                        textBatch += "fct.dictToXlsFile(dictResult,filenameFolderResult + '/Merge_Analysis_"+str(outputNum)+".xls')\n"
                if output.nameType == "Measure" and output.checkBoxMerge.isChecked():
                    textBatch += "fct.saveListMeasureXls(filenameFolderResult + '/Measures.xls' , listMeasure_"+str(outputNum) + ",listFilenameFolder)\n"

            allID = []
            textSplit = textFunction.split('ID_')
            for i in range(1, len(textSplit)):
                newID = textSplit[i].split('_ID')[0]
                if newID not in allID:
                    allID.append(newID)

            vrb.batch = False

        except:
            traceback.print_exc(file=sys.stderr)

        vrb.sizeZ_imageBatch = "1"
        vrb.sizeC_imageBatch = "1"
        vrb.sizeT_imageBatch = "1"

        return textBatch,allID

    def addProcessText(self,text,textToAdd,process):

        if process:
            text+=textToAdd

        return text

    def applyBatch(self):

        vrb.mainWindow.toggleGroupBoxProcessing(True)
        vrb.mainWindow.groupBoxProcessing.setText('Processing batch\n')
        vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(True)
        vrb.continueProcess = True

        self.close()

        try:
            textBatch,allID = self.createText(process=True)

            for id in allID:
                text = "ID_" + id + "_ID = vrb.mainWindow.idToVariable(id)"
                exec(text)

            exec(textBatch)

            vrb.continueProcess = True
            vrb.mainWindow.toggleGroupBoxProcessing(False)
            vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(False)
            self.show()

            messageBox = wgt.MessageBox("Batch processed successfully.<div>The results are available in the folder : <style>a:link { color: rgb(52, 152, 219); }</style><a href='"+
                                        self.outputFolderSelector.lineEditFile.text()+"'>"+self.outputFolderSelector.lineEditFile.text()+"</a><div>Number of images successfully proceded ("+str(vrb.batchNbTotalImages-vrb.batchNbFailedImages)
                                        + "/" + str(vrb.batchNbTotalImages) + ")", '', buttons=[qt.QMessageBox.Ok], windowTitle="Batch results")
            messageBox.setTextFormat(Qt.RichText)

            messageBox.exec()

        except Exception as e:
            self.errorWindow = wgt.PopUpWindow()
            self.errorWindow.setMessageAndShow(str(e),"batch")
            traceback.print_exc(file=sys.stderr)

            vrb.continueProcess = True
            vrb.mainWindow.toggleGroupBoxProcessing(False)
            vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(False)
            self.show()

    def showText(self):

        try:
            textBatch, allID = self.createText(process=False)

            textBatch = textBatch.replace("ID_","")
            textBatch = textBatch.replace("_ID","")

            textRows = textBatch.split("\n")
            newText = ""
            for row in textRows:
                if (row.startswith("import ") or row.startswith("from ") or row.startswith("importlib.")
                        or "\timport " in row or "\tfrom " in row or "\timportlib." in row):
                    newRow = row.replace("\t","")
                    newText+=newRow+"\n"
                    textBatch = textBatch.replace(row+"\n","")

            newText+=textBatch

            #
            # allImports = []
            #
            # textSplit = textBatch.split("\n")
            # for row in textSplit:
            #     splitImport = row.split("import ")
            #     if len(splitImport) > 1:
            #
            #         if "import "+splitImport[1] not in allImports:
            #             allImports.append("import "+splitImport[1])
            #
            # for importValue in allImports:
            #
            #     if importValue != "import PyIPSDK" and importValue != "import PyIPSDK\n":
            #         textBatch = textBatch.replace(importValue+"\n", "")
            #         textBatch = textBatch.replace(importValue, "")
            #
            # textBatch = textBatch.replace("import PyIPSDK\n", "")
            # textBatch = textBatch.replace("import PyIPSDK", "")
            #
            # for importValue in allImports:
            #     textBatch = importValue + "\n" + textBatch

            self.editBatcchScriptWindow.loadScriptText(newText)
            self.editBatcchScriptWindow.show()

        except:
            traceback.print_exc(file=sys.stderr)

    def generateWidgets(self):

        dictConverter = {}
        dictConverter["ShapeAnalysis"] = "Analysis"

        self.listFolderSelectors = []
        self.listOutputGroupBox = []
        firstImage = True

        xmlFunctionDescription = self.functionWidget.xmlFunctionDescription

        paramsDict = {}
        for param in Dfct.SubElement(xmlFunctionDescription, 'Parameters'):
            numParam = int(param.tag.split("_")[1])
            paramsDict[numParam] = param

        for i in range(len(paramsDict)):
            element = paramsDict[i]
            if Dfct.childText(element,"Type") == "Image":
                folderSelector = wgt.FolderSelector(name = Dfct.childText(element,"Name"),optional = not firstImage)
                self.layoutInputs.addWidget(folderSelector)
                if firstImage:
                    folderSelector.lineEditFile.textChanged.connect(self.changeOutputFolder)
                firstImage = False
                self.listFolderSelectors.append(folderSelector)

        outputsDict = {}
        for output in Dfct.SubElement(xmlFunctionDescription, 'Outputs'):
            numOutput = int(output.tag.split("_")[1])
            outputsDict[numOutput] = output

        for i in range(len(outputsDict)):
            element = outputsDict[i]
            elementType = Dfct.childText(element,"Type")
            if elementType in dictConverter:
                nameType = dictConverter[elementType]
            else:
                nameType = elementType

            if len(outputsDict) > 1:
                text = "Name output "+str(i+1) + " (" + nameType + ")"
                placeholderText = "Result_"+str(i+1)+ "_"
                self.outputImage = []
                for i in range(len(outputsDict)):
                    self.outputImage.append("ID_Output_"+str(i)+"_ID")
            else:
                text = "Name output (" + nameType + ")"
                placeholderText = "Result_"
                self.outputImage = "ID_Output_0_ID"

            outputGroupBox = OutputGroupBox(text,placeholderText,nameType)
            self.layoutOutputs.addWidget(outputGroupBox)
            self.listOutputGroupBox.append(outputGroupBox)

    def changeOutputFolder(self):

        if self.outputFolderSelector.lineEditFile.text() == "":
            self.outputFolderSelector.lineEditFile.setText(self.listFolderSelectors[0].lineEditFile.text()+"/Results")

class OutputGroupBox(qt.QGroupBox):
    def __init__(self,name,placeholderText,nameType):
        qt.QGroupBox.__init__(self)

        self.nameType = nameType
        self.listObjects = []

        self.label = qt.QLabel(name)
        self.lineEdit = qt.QLineEdit()
        self.lineEdit.setPlaceholderText(placeholderText)

        if self.nameType == "Analysis" or self.nameType == "Measure":
            self.checkBoxMerge = qt.QCheckBox("Merge")
            self.checkBoxMerge.setChecked(True)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.label,0,0)
        self.layout.addWidget(self.lineEdit,0,1)
        if self.nameType == "Analysis" or self.nameType == "Measure":
            self.layout.addWidget(self.checkBoxMerge,0,2)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setHorizontalSpacing(15*vrb.ratio)

        self.setStyleSheet("QGroupBox {border: 0px transparent; }")

class EditBatcchScriptWindow(qt.QWidget):


    def __init__(self):
        qt.QWidget.__init__(self)

        self.textEditScript = TextEditor()
        # self.highlight = PythonHighlighter(self.textEditScript.document())
        self.textEditScript.setReadOnly(False)

        ###
        # font = QtGui.QFont()
        # font.setFamily("Courier")
        # font.setStyleHint(QtGui.QFont.Monospace)
        # font.setFixedPitch(True)
        # font.setPointSize(10)
        # self.textEditScript.setFont(font)
        # metrics = QtGui.QFontMetrics(font)
        # self.textEditScript.setTabStopWidth(4*metrics.width(' '))
        ###

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.textEditScript, 0, 0)
        self.setLayout(self.layout)

        self.setMinimumSize(500*vrb.ratio, 500*vrb.ratio)

        self.setWindowTitle("Batch")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

    def loadScriptText(self,text):

        text.replace('    ','\t')
        self.textEditScript.setText(text)