import sys, traceback
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation

import sys

from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
import UsefullWidgets as wgt
from RangeSlider import RangeSlider

import DatabaseFunction as Dfct

import UsefullFunctions as fct

import PyIPSDK
import UsefullVariables as vrb


import PyIPSDK
import UsefullVariables as vrb
import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from ConversionIPSDK import dictConversion

import UsefullDisplay as display

class VectorialFieldDisplayer:
    def __init__(self,object):
        super(VectorialFieldDisplayer, self).__init__()

        self.object = object

    def display(self, xmlElement, boolShow=True):

        widgetImage = vrb.mainWindow.widgetImage
        widgetImage.elementIPSDK.add(self)
        widgetImage.actualizeScene()

    def stopDisplay(self):

        widgetImage = vrb.mainWindow.widgetImage
        try:
            widgetImage.elementIPSDK.remove(self)
        except:
            import traceback
            traceback.print_exc(file=sys.stderr)
        widgetImage.actualizeScene()

    def close(self):
        self.stopDisplay()

class VectorialFieldTableDisplayer(display.TableWidgetWindow):

    def __init__(self, vectorialFiled):
        super().__init__()

        self.vectorialFiled = vectorialFiled.value

        ddict = {}
        ddict["X"] = []
        ddict["Y"] = []
        ddict["Dx"] = []
        ddict["Dy"] = []

        listX = []
        listY = []
        for x in self.vectorialFiled:
            for y in self.vectorialFiled[x]:
                if x not in listX:
                    listX.append(x)
                if y not in listY:
                    listY.append(y)

        listX = sorted(listX)
        listY = sorted(listY)

        for x in listX:
            for y in listY:
                ddict["X"].append(x)
                ddict["Y"].append(y)
                ddict["Dx"].append(fct.numberCalibration(self.vectorialFiled[x][y][0]))
                ddict["Dy"].append(fct.numberCalibration(self.vectorialFiled[x][y][1]))

        self.tableWidget.ddict = ddict
        self.tableWidget.loadDictionary()

        self.resize(400*vrb.ratio,150*vrb.ratio)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

    def display(self, xmlElement, boolShow=True):
        self.setWindowTitle(Dfct.childText(xmlElement, 'Name'))

        if boolShow:
            if self.isMaximized():
                self.showMaximized()
            else:
                self.showNormal()
            self.window().raise_()
            self.window().activateWindow()

    def stopDisplay(self):
        self.close()
