import os, sys
from pathlib import Path
from enum import Enum
import xml.etree.ElementTree as xmlet
import shutil
import PyIPSDK
from datetime import datetime

import stat

try:
    from vimba import *
except:
    pass

import reportlab

import json

currentVersion = "4.1.0.3"

###########################################

def enable_write_permission_recursive(path):
    """
    Change the mode of all the content of a directory
    """

    directories = sorted(os.listdir(path),key=str.casefold)
    for curItem in directories:
        curItemFullPath = os.path.join(path, curItem)
        if os.path.isdir(curItemFullPath):
            enable_write_permission_recursive(curItemFullPath)
        elif os.path.isfile(curItemFullPath):
            os.chmod(curItemFullPath, 0o755)

def SubElement(element,text):

    toReturn=None
    for child in element:
        if child.tag==text:
            toReturn=child
    if toReturn is None:
        toReturn = xmlet.SubElement(element, text)
    return toReturn

#############################################

from PyQt5.QtWidgets import QApplication
app = QApplication(sys.argv)

#tests affichages
# app.setAttribute(2, True)  # Qt.AA_EnableHighDpiScaling
# app.setAttribute(11, True) # Qt.AA_UseHighDpiPixmaps

screen = app.screens()[0]
physicalSize = screen.physicalSize()
availableSize = screen.size()

#calcul dpi (pour adapter mieux aux différentes résolutions)
dpi = screen.logicalDotsPerInch()
scale_factor = dpi / 96

dictElements = {}
dictMacros = {}

languageVariable = "english"

pixelSizeRef = 0.248
pixelSize = ((physicalSize.width()/availableSize.width())+(physicalSize.height()/availableSize.height()))/2

ratio = pixelSizeRef/pixelSize
# ratio = scale_factor #test pour affichages

modeProcess = "ProcessingImages"

breakScenario = False

previousImages = []
numberPreviousImages = 5

smartSegmentationPreviousImages = []
smartSegmentationPreviousImagesLiveUpdate = []
smartSegmentationNumberPreviousImages = 5

smartSegmentationSuperPixelsElements = []
smartSegmentationSuperPixelsNumberPreviousElements = 5

widgetImportImageLabel = None

allowChangeRoiImage = True

allowChangeName = True

paramMacro = False

randomColorMin = 10
randomColorMax = 255

graphicUserMode = False
currentUserButtonMode = None
graphicUserFunction = None
applyGraphicElement = None
currentMacroWidget = None
ignoreBackgroundOverlay = False

# frame0 = None
# frame1 = None

batch = False
batchNumImage = 0
batchNbTotalImages = 0
batchNbFailedImages = 0
batchImageIsVerified = False

# sizes to detect multislices for batchs processing
sizeZ_imageBatch = "1"
sizeC_imageBatch = "1"
sizeT_imageBatch = "1"
bufferType_imageBatch = "eIBT_UInt8"

has3DImage = False
hasSequenceImage = False

mainWindow = None

numMacro = 0

widgetCamera = []
updateCamera = True

nbCameras = 0
try:
    with Vimba.get_instance() as vimba:
        cams = vimba.get_all_cameras()
        nbCameras = len(cams)
        if nbCameras > 0:
            with cams[0] as cam0:
                cameraMaxSizeX = cam0.WidthMax.get()*cam0.BinningHorizontal.get()
                cameraMaxSizeY = cam0.HeightMax.get()*cam0.BinningVertical.get()

except:
    nbCameras = 0
    cameraMaxSizeX = 2064
    cameraMaxSizeY = 1544

shapeFilteringMode = "Create_Image"

widgetIDS = None
hasIDS = False
hasCamera = False
captureNum = 1

versionItk = ""
imageJVersion = ""
hasPluginInra = True

previewError = False
previewException = ["Connected Component 2D","Connected Component 3D","Keep big shape 2D","Keep big shape 3D","Remove Border 2D","Remove Border 3D","Remove small shape 2D","Remove small shapes 3D",
                    "Seeded Watershed 2D","Seeded Watershed 3D","Watershed Binary Separation 2D","Watershed Binary Separation 3D","Watershed Grey Separation 2D","Watershed Grey Separation 3D"]

measureException = ["Barycenter X","Barycenter Y","Barycenter Z","Relative Size","Image Ratio","OBB Center X","OBB Center Y","OBB Center Z"]

advancedParamMacro = False

mergedAnalysis = []
barycenterX = None
barycenterY = None
barycenterZ = None
currentShapeAnalysisDisplayer = None
currentHoughLine = None
currentHoughCircle = None
currentHoughSphere = None
currentHarrisCorner2d = None
currentHarrisCorner3d = None

continueProcess = True

isDigisens = False
isORS = False

unitTestMode = False
currentFunction = None

model = None

polygonIn3D = False

maskNumbers=['0','1','2','3','4','5','6','7','8','9']

extensionImages = ["tiff","tif","TIF","TIFF","Tif","Tiff","jpg","JPG","jpeg", "JPEG","PNG","png","BMP","bmp","raw","im6", "IM6","czi","CZI","dcm","DCM","nii","NII","txm","TXM","am","AM"]
extensionImagesOpen = [["tiff","tif","TIF","TIFF","Tif","Tiff"],
                       ["jpg","JPG","jpeg", "JPEG"],
                       ["PNG","png"],
                       ["BMP","bmp"],
                       ["raw"],
                       ["im6", "IM6"],
                       ["czi","CZI"],
                       ["dcm","DCM"],
                       ["nii","NII"],
                       ["txm","TXM"],
                       ["am","AM"]]
extensionMesh = ["stl","Stl","STL"]

maskCharacters = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z",
                  "A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","0","1","2","3","4","5","6","7","8","9","_"]

firstCharacterMacro = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z",
                       "A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","_"]

colorsVector = ["Red","Green","Blue"]

DEFAULT_SIZE = 25*ratio

bufferListBinaryLabel = [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32, PyIPSDK.eIBT_Binary]

dictColor = {}
dictColor[0] = [115,0,59]
dictColor[1] = [14,103,224]
dictColor[2] = [0,200,0]
dictColor[3] = [200,0,0]
dictColor[4] = [255,85,255]
dictColor[5] = [255,131,0]
dictColor[6] = [255,220,0]
dictColor[7] = [183,251,255]
dictColor[8] = [0,255,210]
dictColor[9] = [127,56,200]
dictColor[10] = [56,142,95]
dictColor[11] = [78,150,220]

dir_path = os.path.dirname(os.path.realpath(__file__))

folderExplorer = os.path.dirname(dir_path)

# OS specific path to user's Reactivip directory
folderReference = str(Path.home())
if os.name == 'nt':
    folderReference = os.path.join(folderReference, "AppData/Roaming")
    if not os.path.exists(folderReference):
        os.makedirs(folderReference)
elif os.name == "posix":
    folderReference = os.path.join(folderReference, ".local")
    if not os.path.exists(folderReference):
        os.makedirs(folderReference)
else:
    print("Unsupported operating system")

folderReference = os.path.join(folderReference, "ReactivIP")
if not os.path.exists(folderReference):
    os.makedirs(folderReference)

folderReference = os.path.join(folderReference, "Explorer")
if not os.path.exists(folderReference):
    os.makedirs(folderReference)

# Copy each directory of folderExplorer to folderReference
dirList = sorted(os.listdir(folderExplorer),key=str.casefold)
for content in dirList:
    curSrcPath = os.path.join(folderExplorer, content)
    curDstPath = os.path.join(folderReference, content)
    if not os.path.exists(curDstPath) and os.path.isdir(curSrcPath) and os.path.basename(curSrcPath) not in ["Interface","Styles",".svn"]:
        shutil.copytree(curSrcPath, curDstPath)

# enable_write_permission_recursive(folderReference)

folderFunctions = folderReference + "/Functions"

folderImages = folderExplorer + "/Interface/Images"
folderFonts = folderExplorer + "/Interface/Fonts"

folderStyles = folderExplorer + "/Styles"

folderInformation = folderReference + "/Information"
if not os.path.exists(folderInformation):
    os.makedirs(folderInformation)

folderLog = folderReference + "/Log"
if not os.path.exists(folderLog):
    os.makedirs(folderLog)

date = datetime.now()
dateFormated = date.strftime("%Y_%m_%d_%H_%M_%S")

currentFolderLog = folderLog + "/" + dateFormated
if not os.path.exists(currentFolderLog):
    os.makedirs(currentFolderLog)

nbMaxLogFolder = 20
logDirs = sorted(
    [d for d in os.listdir(folderLog) if os.path.isdir(os.path.join(folderLog, d))],
    key=lambda x: os.path.getmtime(os.path.join(folderLog, x))
)
if len(logDirs) > nbMaxLogFolder:
    for oldDir in logDirs[:-nbMaxLogFolder]:
        oldPath = os.path.join(folderLog, oldDir)
        try:
            shutil.rmtree(oldPath)
        except:
            pass

folderSessions = folderReference + "/Sessions"
if not os.path.exists(folderSessions):
    os.makedirs(folderSessions)
folderSessionsBackup = folderSessions + "/_Backup"
if not os.path.exists(folderSessionsBackup):
    os.makedirs(folderSessionsBackup)

currentFolderSessionBackup = folderSessionsBackup + "/" + dateFormated
if not os.path.exists(currentFolderSessionBackup):
    os.makedirs(currentFolderSessionBackup)

try:
    file = xmlet.parse(folderInformation + "/Settings.mho")
    settingsElement = file.getroot()
    fontMachineLearningElement = SubElement(settingsElement, "FontMachineLearning")
    fontSizeMachineLearning = int(fontMachineLearningElement.text)
except:
    fontSizeMachineLearning = 10

folderShapeAnalysis = folderReference + "/Shape_Analysis"

folderMacroInterface = folderReference + "/Macro_Interface"
if not os.path.exists(folderMacroInterface):
    os.makedirs(folderMacroInterface)

# folderMacroInterfacePythonFile = folderMacroInterface + "/Python_File"
# if not os.path.exists(folderMacroInterfacePythonFile):
#     os.makedirs(folderMacroInterfacePythonFile)
#
# folderMacroInterfaceData = folderMacroInterface + "/Data"
# if not os.path.exists(folderMacroInterfaceData):
#     os.makedirs(folderMacroInterfaceData)

folder3DViewer = folderReference + "/3D_Viewer"
if not os.path.exists(folder3DViewer):
    os.makedirs(folder3DViewer)

folderMovieMaker = folder3DViewer + "/MovieMaker"
if not os.path.exists(folderMovieMaker):
    os.makedirs(folderMovieMaker)

folderMachineLearning = folderReference + "/Machine_Learning"
if not os.path.exists(folderMachineLearning):
    os.makedirs(folderMachineLearning)

folderPixelClassification = folderReference + "/Machine_Learning/Pixel_Classification"
if not os.path.exists(folderPixelClassification):
    os.makedirs(folderPixelClassification)

folderShapeClassification = folderReference + "/Machine_Learning/Shape_Classification"
if not os.path.exists(folderShapeClassification):
    os.makedirs(folderShapeClassification)

folderSuperPixelSegmentation = folderReference + "/Machine_Learning/Super_Pixel_Segmentation"
if not os.path.exists(folderSuperPixelSegmentation):
    os.makedirs(folderSuperPixelSegmentation)

folderUserData = folderReference + '/UserData'

folderSettingsRF = folderUserData + '/SettingsRF'
if not os.path.exists(folderSettingsRF):
    os.makedirs(folderSettingsRF)

folderMacroData = folderUserData + '/Macro_Data'
if not os.path.exists(folderMacroData):
    os.makedirs(folderMacroData)

folderSettingsCamera = folderUserData + '/SettingsCamera'
if not os.path.exists(folderSettingsCamera):
    os.makedirs(folderSettingsCamera)

try:
    programDataReactivIP = os.path.dirname(os.path.dirname(PyIPSDK.getIPSDKDefaultDirectory(PyIPSDK.eDefaultExternalDirectory.eDED_CommonConfig)))
    folderBenchmark = programDataReactivIP + '/Benchmark'
    if not os.path.exists(folderBenchmark):
        shutil.copytree(folderExplorer+"/UserData/Benchmark", folderBenchmark)
except:
    pass

#enable_write_permission_recursive(folderReference)

rootDir = os.path.dirname(folderExplorer)
if os.path.basename(rootDir) == "python":
    rootDir = os.path.dirname(rootDir)
outputBinDir = os.path.join(rootDir, "Output")
bDevMode = os.path.exists(outputBinDir)
rootDocDir = rootDir
if bDevMode:
    rootDocDir = rootDir + '/Output'

folderDoc = rootDocDir + '/doc/public/IPSDKIPL/html'
if not os.path.exists(folderDoc):
    folderDoc = rootDocDir + '/doc/public/IPSDKIPL/html'
# if folderDoc.startswith('..') or folderDoc.startswith('.'):
#     folderDoc = folderReference + folderDoc

folderDocCore = rootDocDir + '/doc/public/IPSDKCore/html'
if not os.path.exists(folderDoc):
    folderDocCore = rootDocDir + '/doc/public/IPSDKCore/html'

folderDocEssential = rootDocDir + '/doc/public/Essential'

with open(folderDocEssential + "/dictLinks.json", "r") as file_json:
    dictLinks = json.load(file_json)

folderDefault = folderReference + '/..'

hasImage = False
sessionIsSaved = True

currentDataLabelToMeasure = None
linePoint = None

lineMeasureColor = [240,204,0]
polygonColor = [39, 98, 150]

calibrationTextColor = [243,25,25]
calibrationBackgroundColor = [244,244,244]

mergeColor = [0,0,220]
split2DColor = [30,30,30]
split3DColor = [0, 220, 0]
addColor = [178, 115, 0]
deleteColor = [220,0,0]
keepColor = [0,220,0]

try:
    file = xmlet.parse(folderInformation + "/UserPath.mho")
    userPathElement = file.getroot()
except:
    userPathElement = xmlet.Element('UserPath')

try:
    file = xmlet.parse(folderInformation + "/RightPanel.mho")
    rightPanelElement = file.getroot()
except:
    rightPanelElement = xmlet.Element('RightPanel')

try:
    file = xmlet.parse(folderInformation + "/RightPanelMacro.mho")
    rightPanelMacroElement = file.getroot()
except:
    rightPanelMacroElement = xmlet.Element('RightPanelMacro')

try:
    isRunTime = PyIPSDK.isRunTimeLicense()
except:
    isRunTime = False

maskValue = 0

try:
    # file = xmlet.parse(folderInformation + "/DocMeasure.mho")
    file = xmlet.parse(folderExplorer + "/Information/DocMeasure.mho")
    docMeasureElement = file.getroot()
except:
    docMeasureElement = xmlet.Element('DocMeasure')

try:
    # file = xmlet.parse(folderInformation + "/DocMeasure.mho")
    file = xmlet.parse(folderExplorer + "/Information/DocFunctions.mho")
    docFunctionsElement = file.getroot()
except:
    docFunctionsElement = xmlet.Element('DocFunctions')

try:
    file = xmlet.parse(folderInformation + "/Settings.mho")
    settingsElement = file.getroot()
except:
    settingsElement = xmlet.Element('Settings')
try:
    for child in settingsElement:
        if child.tag=="RatioDimensions":
            elementRatioDimension=child
    ratioDimension = float(elementRatioDimension.text)
except:
    ratioDimension = 1
if ratioDimension <0.5:
    ratioDimension = 0.5
ratio *= ratioDimension


movieMakerNbFrames = 301
movieMakerFrameTime = 0.1

meshReductionRatio = 0.9
meshNbMinFaces = 100000
meshNbMaxFaces = 400000

debugMode = False

sievesComboBox = []

def printDebug(text):
    if debugMode:
        print(text, file=sys.stderr)

class EulerAngles():

    def __init__(self):

        self.angles = (0,0,0)
        self.direction = [None,None,None]

class Histogram():

    def __init__(self):

        self.xValues = []
        self.barsetValues = []
        self.tick_label = []
        self.legendSpacing = 1
        self.cumul = False
        self.title = None
        self.xLegend = None
        self.yLegend = None
