import os
import traceback
import sys
import UsefullVariables as vrb
import DatabaseFunction as Dfct
import WidgetTypes

import joblib

# from CustomWidgets import MyComboBoxObject, MyLineEdit, MyCheckBox, MyComboBoxEnum, CheckableWidget
from CustomWidgets import MyLineEdit, CheckableWidget
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication
import PyQt5.QtWidgets as qt
from PyQt5 import QtGui
from PyQt5 import QtCore

from FormulaWidget import FormulaWidget
from MatrixCreatorWidget import LabelMatrixCreator
import xml.etree.ElementTree as xmlet

import UsefullFunctions as fct

def checkConstraintsElement(xmlElement, constraints, type):

    if type == WidgetTypes.InputType.IMAGE and Dfct.childText(xmlElement, 'ObjectType') == "Mesh":
        if constraints is not None and constraints.__contains__(WidgetTypes.ImageConstraint.MESH.value):
            return True
        else:
            return False

    if constraints is None:
        return True
    if type == WidgetTypes.InputType.IMAGE:
        if constraints.__contains__(WidgetTypes.ImageConstraint.ANY.value):
            return True
        caracteristics = []
        # color
        if Dfct.childText(xmlElement, 'C') != '1':
            caracteristics.append(WidgetTypes.ImageConstraint.COLOR.value)
        else:
            caracteristics.append(WidgetTypes.ImageConstraint.GREY.value)
        # dimensions
        if Dfct.childText(xmlElement, 'Z') == '1':
            caracteristics.append(WidgetTypes.ImageConstraint.TWO_DIMENSIONS.value)
        else:
            caracteristics.append(WidgetTypes.ImageConstraint.THREE_DIMENSIONS.value)
            caracteristics.append(WidgetTypes.ImageConstraint.THREE_DIMENSIONS_OR_SEQUENCE.value)

        if Dfct.childText(xmlElement, 'T') != '1':
            caracteristics.append(WidgetTypes.ImageConstraint.SEQUENCE.value)
            caracteristics.append(WidgetTypes.ImageConstraint.THREE_DIMENSIONS_OR_SEQUENCE.value)

        typeText = Dfct.childText(xmlElement, 'BufferType')
        if typeText == 'eIBT_Binary':
            caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_BINARY.value)
            caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL.value)
        else:
            caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_NOTBINARY.value)
            if typeText in ['eIBT_Label8','eIBT_Label16', 'eIBT_Label32']:
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_LABEL.value)
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL.value)
            elif typeText == 'eIBT_Real32':
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_REAL.value)
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_INT_OR_REAL.value)
            elif typeText in ['eIBT_UInt8','eIBT_UInt16', 'eIBT_UInt32']:
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_UINT.value)
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_INT.value)
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_INT_OR_REAL.value)
            elif typeText in ['eIBT_Int8','eIBT_Int16', 'eIBT_Int32']:
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_INT.value)
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_INT_OR_REAL.value)
            else:
                caracteristics.append(WidgetTypes.ImageConstraint.BUFFER_TYPE_INT_OR_REAL.value)

        for constraint in constraints:
            if not (caracteristics.__contains__(constraint)):
                return False

    elif type == WidgetTypes.InputType.SHAPES:
        if Dfct.childText(xmlElement, 'ObjectType') in constraints:
            return True
        else:
            return False

    elif type == WidgetTypes.InputType.CENTROID:
        if Dfct.childText(xmlElement, 'ObjectType') in constraints:
            return True
        else:
            return False

    return True


def generateOutputWidget(outputNode):

    textLabel = Dfct.childText(outputNode, 'Name')
    if Dfct.childText(outputNode, 'Mandatory') == 'True':
        pass  # TODO : Decide what to do
    # Label
    label = qt.QLabel(textLabel)
    # widget
    widget = None
    type = WidgetTypes.OutputType.stringToType(Dfct.childText(outputNode, 'Type'))
    widget = MyLineEdit(outputNode, type)

    widget.valueType = type.value

    return label, widget, type


def generateParamWidget(paramNode):
    name = Dfct.childText(paramNode, 'Name')
    type = WidgetTypes.InputType.stringToType(Dfct.childText(paramNode, 'Type'))
    defaultValue = Dfct.childText(paramNode, 'Default')

    if type == WidgetTypes.InputType.SCALAR_CHOICE:

        if defaultValue is not None:
            defaultValueSplit = defaultValue.split(",")
        else:
            defaultValueSplit = []

        nameSplit = name.split(",")
        label = qt.QComboBox()
        for i in range(len(nameSplit)):
            if len(defaultValueSplit) != 0:
                label.addItem(nameSplit[i],[defaultValueSplit[i],""])
            else:
                label.addItem(nameSplit[i],["",""])
        label.setFixedWidth(100*vrb.ratio)
        label.setEditable(True)
        label.lineEdit().setAlignment(QtCore.Qt.AlignCenter)
        label.lineEdit().setReadOnly(True)
    else:
        label = qt.QLabel(name)

    constraints = Dfct.childText(paramNode, 'Constraints')
    if constraints is not None:
        constraints = constraints.split(',')
    # widget
    widget = WidgetTypes.InputType.typeToClass(type)(paramNode, type)
    if type == WidgetTypes.InputType.SIEVE:
        vrb.sievesComboBox.append(widget)
        fct.updateSievesComboBox()
    widget.valueType = type.value
    if type == WidgetTypes.InputType.ADVANCED:
        widget.setTitle(name)
        label = None

    if type == WidgetTypes.InputType.SCALAR_CHOICE:
        widget.choice = label
        label.currentIndexChanged.connect(widget.changeChoiceValue)
        widget.textChanged.connect(widget.updateValues)
        widget.setPlaceholderText(label.currentData()[0])

    if Dfct.childText(paramNode, 'Mandatory') != 'True':
        # TODO : Decide what to do
        widget = CheckableWidget(widget)
        label.setStyleSheet('QLabel {color:grey;}')

    return label, widget, constraints, type, defaultValue


def loadXmlElements(parameters, xmlAllElements, positionSelectedLabel, listComboBoxesIndex):

    try:
        # clear and get all comboBoxes containing images list
        for paramWidget in parameters.values():
            widgetType = paramWidget['Type']
            try:
                comboBox = paramWidget['Widget'].widget
            except:
                comboBox = paramWidget['Widget']
            if widgetType in WidgetTypes.comboBoxTypes:
                if positionSelectedLabel == -1:
                    posComboBox = max(0, comboBox.currentIndex())
                comboBox.clear()
                pos = 0
                relativePos = -1
                for _ in xmlAllElements:
                    for child in xmlAllElements:
                        if child.tag == comboBox.type.value:
                            try:
                                if int(Dfct.childText(child, 'Position')) == pos:
                                    nameImage = Dfct.childText(child, 'Name')
                                    if checkConstraintsElement(child, paramWidget['Constraints'], widgetType):
                                        comboBox.addItem(nameImage.split('.')[0], child)
                                        relativePos += 1
                                        if widgetType == WidgetTypes.InputType.IMAGE:
                                            if int(Dfct.childText(child, 'Position')) == positionSelectedLabel:
                                                comboBox.setCurrentIndex(relativePos)
                                    pos += 1
                            except:
                                traceback.print_exc(file=sys.stderr)
                if positionSelectedLabel == -1:
                    comboBox.setCurrentIndex(posComboBox)
                if widgetType == WidgetTypes.InputType.IMAGE:
                    if comboBox.currentData() is not None:
                        position = int(Dfct.childText(comboBox.currentData(), 'Position'))
                        listComboBoxesIndex.add(position)

            if widgetType == WidgetTypes.InputType.ADVANCED:
                comboBox.loadXmlElements(xmlAllElements, positionSelectedLabel, listComboBoxesIndex)

            if widgetType == WidgetTypes.InputType.ENUM and paramWidget['Constraints'] in [[WidgetTypes.MachineLearningConstraint.SMART_SEGMENTATION.value],[WidgetTypes.MachineLearningConstraint.SMART_CLASSIFICATION.value],
                                                                                           [WidgetTypes.MachineLearningConstraint.SMART_SUPER_PIXELS.value]]:
                previousIndex = comboBox.currentIndex()
                if previousIndex == -1:
                    previousIndex = 0
                comboBox.clear()
                if paramWidget['Constraints'] == [WidgetTypes.MachineLearningConstraint.SMART_SEGMENTATION.value]:
                    folderMachineLearning = vrb.folderPixelClassification
                elif paramWidget['Constraints'] == [WidgetTypes.MachineLearningConstraint.SMART_CLASSIFICATION.value]:
                    folderMachineLearning = vrb.folderShapeClassification
                elif paramWidget['Constraints'] == [WidgetTypes.MachineLearningConstraint.SMART_SUPER_PIXELS.value]:
                    folderMachineLearning = vrb.folderSuperPixelSegmentation
                for modelName in sorted(os.listdir(folderMachineLearning), key=str.casefold):
                    folderModel = folderMachineLearning + "/" + modelName
                    if os.path.isdir(folderModel):
                        if (paramWidget['Constraints'] == [WidgetTypes.MachineLearningConstraint.SMART_SEGMENTATION.value] and
                                os.path.exists(folderModel + "/ModelIPSDK.bin")):
                            comboBox.addItem(modelName, modelName)
                        elif os.path.exists(folderModel + "/Model"):
                            comboBox.addItem(modelName, modelName)
                        else:
                            print("No file " + folderModel + "/ModelIPSDK.bin found")

                if paramWidget["DefaultValue"] is None:
                    comboBox.setCurrentIndex(previousIndex)
                else:
                    index = comboBox.findText(paramWidget["DefaultValue"])
                    if index == -1:
                        index = 0
                    comboBox.setCurrentIndex(index)

    except:
        traceback.print_exc(file=sys.stderr)



