import os
import sys,traceback

import shutil

try:
    import cv2
except:
    pass

try:
    import czifile
    import tifffile
except:
    pass
    # print("[INFO] Could not import czfile and/or tifffile")

try:
    import nibabel
except:
    pass
    # print("[INFO] Could not import nibabel")

import WidgetTypes

import numpy as np
import time
import datetime
import PyQt5.QtWidgets as qt
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication
from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5.QtWidgets import QApplication

import PyIPSDK.IPSDKIPLStats as stats
import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filterIP
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
# import PyIPSDK.IPSDKUI as ui
import PyIPSDK.IPSDKFunctionsMachineLearning as fctML

import numpy
import random

import re

import xml.etree.ElementTree as xmlet

import subprocess

try:
    import xlwt
except:
    pass

try:
    import csv
except:
    pass

try:
    import pydicom as dicom
except:
    pass

import traceback

import UsefullVariables as vrb
import DatabaseFunction as Dfct

try:
    from LutsWidget import getLutArray
except:
    pass

from DictionaryCustomObject import dictCustomObject

from PIL import Image, ImageDraw, ImageFont

try:
    from vimba import *
except:
    pass

import napari

try:
    import olefile
except:
    pass

# Class copied from UsefullWidgets to avoid circular import
class MessageBox(qt.QMessageBox):
    def __init__(self, title, description, buttons=(qt.QMessageBox.Close, qt.QMessageBox.No), defaultButton=qt.QMessageBox.No, icon=qt.QMessageBox.NoIcon,windowTitle = "Explorer"):
        # https://doc.qt.io/qt-5/qmessagebox.html
        super(MessageBox, self).__init__()

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.setText(title)
        self.setInformativeText(description)
        standardButtons = buttons[0]
        for button in buttons:
            standardButtons |= button
        self.setStandardButtons(standardButtons)
        if defaultButton in buttons:
            self.setDefaultButton(defaultButton)

        self.setIcon(icon)
        self.setWindowTitle(windowTitle)
        style = getStyleSheet()
        self.setStyleSheet(style)


def computesMultisliceSizes(image):
    '''A function that computes Z,C,T sizes of an image.
       Mainly used for the process functions to determine multislice process.'''

    numID = getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")

    sizeZ = vrb.sizeZ_imageBatch
    sizeC = vrb.sizeC_imageBatch
    sizeT = vrb.sizeT_imageBatch
    bufferType = vrb.bufferType_imageBatch

    #if allElements is empty we keep batch sizes for processing
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeZ = Dfct.childText(child, "Z")
            sizeC = Dfct.childText(child, "C")
            sizeT = Dfct.childText(child, "T")
            bufferType = Dfct.childText(child,"BufferType")

    return sizeZ, sizeC, sizeT, bufferType


def isInteger(real):
    return abs(real - round(real)) < sys.float_info.epsilon * 10

def convertValue (value,number):

    try:
        value = float(value)
        value = int(value*number)/number
        if int(value) == value:
            value = int(value)
    except:
        value = "?"

    return value

def numberCalibration(value,numberMeaningful=None):

    try:
        if numberMeaningful is None:
            try:
                file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
                settingsElement = file.getroot()
                decimalSeparatorElement = Dfct.SubElement(settingsElement, "NumberOfDigits")
                numberMeaningful = int(float(decimalSeparatorElement.text))
            except:
                numberMeaningful = 3

        if float(value) > 0:
            if float(value)<0.000001:
                value = 0
            else:
                value = float(value) + 0.000001
        elif float(value) < 0:
            if float(value)>-0.000001:
                value = 0
            else:
                value = float(value) - 0.000001
        else:
            value = float(value)

        textValue = str(value)

        if "e-" in textValue:
            try:
                nbZeros = int(textValue.split("e-")[1])
                mainNumber = textValue.split("e-")[0]
                if mainNumber[0] == "-":
                    outValue = "-0."
                    mainNumber = mainNumber[1:]
                else:
                    outValue = "0."
                for i in range(nbZeros-1):
                    outValue += "0"

                for i in range(4):
                    try:
                        if mainNumber[i] != ".":
                            outValue+=mainNumber[i]
                    except:
                        pass

                while len(outValue)>numberMeaningful and outValue[len(outValue)-1]=="0":
                    outValue = outValue[:-1]

            except:
                outValue = "0"

        else:

            numberAdded = 0
            firstValue = False
            hasPoint = False
            newValue = ""
            for caracter in textValue:
                if caracter not in ["0",".","-"]:
                    firstValue = True
                    numberAdded+=1
                else:
                    if caracter == "0" and firstValue:
                        numberAdded+=1
                if caracter == ".":
                    hasPoint = True
                if caracter != "." or numberAdded < numberMeaningful:
                    newValue+=caracter
                if numberAdded >= numberMeaningful and hasPoint:
                    break

            if hasPoint:
                hasValue = False
                outValue = ""
                hasPoint = "." in newValue
                for i in range(len(newValue)-1,-1,-1):
                    if newValue[i] not in ["0","."] or hasValue or hasPoint == False:
                        outValue = newValue[i] + outValue
                        hasValue = True
                    if newValue[i] == ".":
                        hasValue = True
            else:
                outValue = newValue

    except:
        outValue = str(value)

    return outValue


def adjustedNumberCalibration(number, mode='max', numberMeaningful=None):

    if numberMeaningful is None:
        try:
            file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
            settingsElement = file.getroot()
            decimalSeparatorElement = Dfct.SubElement(settingsElement, "NumberOfDigits")
            numberMeaningful = int(float(decimalSeparatorElement.text))
        except:
            numberMeaningful = 3

    if abs(number) >1 :
        epsilonRef = max(1/(10**(numberMeaningful+1)),0.00001)
    else:
        epsilonRef = 0.0000001
    epsilon = 0.1

    value = number
    valueBefore = number
    nbIter = 0

    if mode == 'max':
        while epsilon>epsilonRef:
            while float(numberCalibration(value,numberMeaningful=numberMeaningful))<number:
                nbIter+=1
                valueBefore = value
                value+=epsilon
            valueRes = value
            value = valueBefore
            epsilon = epsilon/10

    if mode == 'min':
        while epsilon>epsilonRef:
            while float(numberCalibration(value,numberMeaningful=numberMeaningful))>number:
                nbIter+=1
                valueBefore = value
                value-=epsilon
            valueRes = value
            value = valueBefore
            epsilon = epsilon/10

    result = numberCalibration(valueRes,numberMeaningful=numberMeaningful)

    return result

def numberToScientific(number, sig=3):
    # sig : nombre de chiffres significatifs
    if number == 0:
        return str(0)

    if abs(number) >= 1:
        try:
            exposant = int(np.log10(abs(number)))
        except:
            exposant = 1
    else:
        try:
            exposant = int(np.log10(abs(number))) - 1
        except:
            exposant = 1

    number = number / pow(10, exposant)
    number = convertValue(number, pow(10, sig-1))

    if -sig < exposant < sig:

        if exposant == 0:
            number = str(number)
        else:
            number = str(number).replace('.', '')
            if exposant <=-1:
                number = "0." + (abs(exposant)-1)*"0" + str(number)
            else:
                if len(number) > exposant + 1:
                    number = number[:exposant+1] + '.' + number[exposant+1:]
                else:
                    number0 = exposant + 1 - len(number)
                    number = number + '0' * number0

    else:
        number = str(number) + 'e' + str(exposant)
    return number


def unionLClosing(image,nbAngle,size):

    outImage = None
    size = min(size,30)

    for i in range(nbAngle):

        angle = np.pi*i/nbAngle
        inSE = PyIPSDK.linearSEXYInfo(angle,size)
        if outImage is None:
            outImage = morpho.closing2dImg(image, inSE)
        else:
            closingImage = morpho.closing2dImg(image, inSE)
            outImage = arithm.minImgImg(outImage, closingImage)

    return outImage

def fractionToFloat(text):
    textSplit = text.split('/')
    if len(textSplit) == 1:
        return float(textSplit[0])
    else:
        return float(textSplit[0]) / float(textSplit[1])

def imageToDisplay(image,widgetLabelImage,mode = 'Linear',widgetContrast = None,lutToApply = None):

    # if image.getSizeC()>1 and image.getColorGeometryType() != PyIPSDK.eCGT_Rgb:

    if image.getSizeC()>1:

        image = convertToRgbImage(image,widgetLabelImage)

    if mode == "Exponential":
        image = util.convertImg(image,PyIPSDK.eIBT_Real32)
        image = arithm.multiplyScalarImg(image,1/widgetLabelImage.valueMax)
        if image.getSizeZ() == 1:
            image = arithm.formula2dImg("exp(I1)",InOptImg1=image)
        else:
            image = arithm.formula3dImg("exp(I1)",InOptImg3d1=image)
    elif mode == "Logarithm":
        image = util.convertImg(image,PyIPSDK.eIBT_Real32)
        if image.getSizeZ() == 1:
            image = arithm.formula2dImg("if(I1<1,0,log(I1))", InOptImg1=image)
        else:
            image = arithm.formula3dImg("if(I1<1,0,log(I1))", InOptImg3d1=image)
    elif mode == "Inverted":

        # print("minmax",widgetLabelImage.valueMin,widgetLabelImage.valueMax,widgetLabelImage.valueMinRef)

        if image.getSizeZ() == 1:
            image = arithm.formula2dImg(str(widgetLabelImage.valueMaxRef)+"-(I1-"+str(widgetLabelImage.valueMinRef)+")", InOptImg1=image)
        else:
            image = arithm.formula3dImg(str(widgetLabelImage.valueMaxRef)+"-(I1-"+str(widgetLabelImage.valueMinRef)+")", InOptImg3d1=image)

    try:
        outImage = lutToColor(image, widgetLabelImage.groupBoxLut,mode=mode,widgetContrast = widgetContrast,widgetLabelImage=widgetLabelImage,lutToApply = lutToApply)

    except:

        try:
            widgetLabelImage.valueMax
        except:
            widgetLabelImage.valueMin, widgetLabelImage.valueMax = getMinMaxValue(widgetLabelImage)
            widgetLabelImage.valueMinMask = None
        valueMax = correctValueWithMode(widgetLabelImage.valueMax,mode,widgetLabelImage.valueMax)
        valueMin = correctValueWithMode(widgetLabelImage.valueMin,mode,widgetLabelImage.valueMax)

        if valueMax - valueMin != 0:
            outImage = util.convertImg(image, PyIPSDK.eIBT_Real32)
            outImage = arithm.addScalarImg(outImage, -valueMin)
            outImage = arithm.multiplyScalarImg(outImage, 255 / (valueMax - valueMin))
        else:
            outImage = util.copyImg(image)
        outImage = util.convertImg(outImage, PyIPSDK.eIBT_UInt8)
        if widgetContrast is not None:
            outImage = applyWidgetContrast(outImage,widgetContrast)

    return outImage

def lutToColor(image,groupBoxLut,mode = "Linear",widgetContrast =None,widgetLabelImage = None,lutToApply = None):

    try:
        mask = None
        if groupBoxLut.comboBoxLut.currentData()["Name"] not in ["Random","Custom"]:
            if image.getBufferType() != PyIPSDK.eIBT_Binary:
                valueMax = float(groupBoxLut.parent.valueMax)
                valueMax = correctValueWithMode(valueMax,mode,groupBoxLut.parent.valueMax)
                if groupBoxLut.checkBoxBackground.isChecked():
                    if groupBoxLut.parent.valueMinMask is None:
                        groupBoxLut.parent.valueMinMask = getValueMinMask(groupBoxLut.parent.image)
                    # valueMin = float(groupBoxLut.parent.valueMinMask)
                    valueMin = float(groupBoxLut.parent.valueMin)
                    valueMin = correctValueWithMode(valueMin, mode,groupBoxLut.parent.valueMax)

                    valueMaxRef = float(groupBoxLut.parent.valueMaxRef)
                    valueMaxRef = correctValueWithMode(valueMaxRef, mode, groupBoxLut.parent.valueMaxRef)

                    maskWithMin = bin.thresholdImg(image,valueMin,valueMaxRef)
                    maskMin = bin.thresholdImg(image,valueMin,valueMin)
                    mask = logic.bitwiseXOrImgImg(maskWithMin,maskMin)

                else:
                    valueMin = float(groupBoxLut.parent.valueMin)
                    valueMin = correctValueWithMode(valueMin, mode,groupBoxLut.parent.valueMax)
                if valueMax - valueMin != 0:
                    image = util.convertImg(image, PyIPSDK.eIBT_Real32)
                    image = arithm.addScalarImg(image, -valueMin)
                    image = arithm.multiplyScalarImg(image, 255 / (valueMax - valueMin))
            else:
                image = util.convertImg(image, PyIPSDK.eIBT_UInt8)
                image = arithm.multiplyScalarImg(image,255)
            image = util.convertImg(image, PyIPSDK.eIBT_UInt8)
            if widgetContrast is not None:
                image = applyWidgetContrast(image,widgetContrast)

        if groupBoxLut.comboBoxLut.currentData()["Name"] != "Classic":

            colorGeometry = PyIPSDK.ColorGeometry()
            colorGeometry.initRgb()
            volumeGeometry = PyIPSDK.VolumeGeometry()
            if image.getSizeZ() == 1:
                volumeGeometry.init2d()
            else:
                volumeGeometry.init3d(image.getSizeZ())
            temporalGeometry = PyIPSDK.TemporalGeometry()
            temporalGeometry.initSingle()
            geometry = PyIPSDK.geometry(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)
            outImage = PyIPSDK.createImage(geometry)

            # if image.getSizeZ() == 1:
            #     outImage = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
            # else:
            #     outImage = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY(),image.getSizeZ())

            if groupBoxLut.lutArrayPreview is None:
                if lutToApply is None:
                    currentLut = groupBoxLut.currentLut
                else:
                    currentLut = lutToApply
                if groupBoxLut.comboBoxLut.currentData()["Name"] == "Random":

                    random.seed(5)
                    for i in range(1,groupBoxLut.comboBoxLut.nbDefineLabel+1):
                        try:
                            for j in range(3):
                                if i in vrb.dictColor:
                                    currentLut[j][i] = vrb.dictColor[i][j]
                                else:
                                    currentLut[j][i] = random.randint(vrb.randomColorMin, vrb.randomColorMax)
                        except:
                            pass

                    try:
                        file = xmlet.parse(vrb.folderInformation + "/UserLabels.mho")
                        xmlElement = file.getroot()
                    except:
                        xmlElement = xmlet.Element('UserLabels')
                    nbDefineLabel = len(xmlElement)

                    groupBoxLut.comboBoxLut.nbDefineLabel = nbDefineLabel
                    for i in range(1,nbDefineLabel+1):
                        try:
                            child = Dfct.SubElement(xmlElement, "Label_" + str(i))
                            color = Dfct.childText(child, "Color")
                            color = color.split(",")
                            for j in range(len(color)):
                                currentLut[j][i] = float(color[j])
                        except:
                            pass

                    if widgetLabelImage is not None:
                        try:
                            dictLabels = fctML.readSmartSegmentation(widgetLabelImage.image)
                            for i in dictLabels:
                                colorText = dictLabels[i]["Color"]
                                colorTextSplit = colorText.split(",")
                                for j in range(len(colorTextSplit)):
                                    if i == 0:
                                        currentLut[j][i] = 0
                                    else:
                                        currentLut[j][i] = float(colorTextSplit[j])
                        except:
                            pass

            else:
                currentLut = groupBoxLut.lutArrayPreview

            for c in range(0, 3):
                if image.getSizeZ() == 1:
                    plan = PyIPSDK.extractPlan(0, c, 0, outImage)
                    lut = PyIPSDK.createIntensityLUT(0, 1, currentLut[c])
                    lutImage = itrans.lutTransform2dImg(image, lut)
                    if mask is not None:
                        lutImage = arithm.multiplyImgImg(lutImage,mask)
                    lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                    util.copyImg(lutImage, plan)
                else:
                    volume = PyIPSDK.extractVolume(c, 0, outImage)
                    lut = PyIPSDK.createIntensityLUT(0, 1, currentLut[c])
                    lutImage = itrans.lutTransform3dImg(image, lut)
                    if mask is not None:
                        lutImage = arithm.multiplyImgImg(lutImage,mask)
                    lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                    util.copyImg(lutImage, volume)

        else:
            outImage = image

    except:

        colorGeometry = PyIPSDK.ColorGeometry()
        colorGeometry.init(PyIPSDK.eCGT_Rgb)
        volumeGeometry = PyIPSDK.VolumeGeometry()
        if image.getSizeZ() == 1:
            volumeGeometry.init2d()
        else:
            volumeGeometry.init3d(image.getSizeZ())
        temporalGeometry = PyIPSDK.TemporalGeometry()
        temporalGeometry.initSingle()
        geometry = PyIPSDK.geometry(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)
        outImage = PyIPSDK.createImage(geometry)

        # outImage = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())

        for c in range(0, 3):
            if image.getSizeZ()==1:
                plan = PyIPSDK.extractPlan(0, c, 0, outImage)
                lut = PyIPSDK.createIntensityLUT(0, 1, groupBoxLut[c])
                lutImage = itrans.lutTransform2dImg(image, lut)
                lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                util.copyImg(lutImage, plan)
            else:
                volume = PyIPSDK.extractVolume(0, c, 0, outImage)
                lut = PyIPSDK.createIntensityLUT(0, 1, groupBoxLut[c])
                lutImage = itrans.lutTransform2dImg(image, lut)
                lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                util.copyImg(lutImage, volume)

        return outImage

    return outImage

def applyLut(image,lutArray):
    try:
        outImage = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
        # util.eraseImg(outImage, 0)

        for c in range(0, 3):
            plan = PyIPSDK.extractPlan(0, c, 0, outImage)
            lut = PyIPSDK.createIntensityLUT(0, 1, lutArray[c])
            lutImage = itrans.lutTransform2dImg(image, lut)
            lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
            util.copyImg(lutImage, plan)

        return outImage
    except:
        traceback.print_exc(file=sys.stderr)

def applyWidgetContrast(image, widgetContrast):

    contrastValue = widgetContrast.widgetSettings.sliderContrast.value()
    if contrastValue != 50:
        contrastValue = (contrastValue - 50) / 10
        if contrastValue < 0:
            image = arithm.multiplyScalarImg(image, 1 / (-contrastValue + 1))
        else:
            image = arithm.multiplyScalarImg(image, contrastValue + 1)
    brightnessValue = widgetContrast.widgetSettings.sliderBrightness.value()
    if brightnessValue != 50:
        brightnessValue = (brightnessValue - 50)*255/50
        image = arithm.addScalarImg(image, brightnessValue)
    image = util.convertImg(image, PyIPSDK.eImageBufferType.eIBT_UInt8)

    return image

def correctValueWithMode(value,mode,valueMax):

    outValue = value
    if mode == "Exponential":
        outValue = np.exp(outValue/valueMax)
    elif mode == "Logarithm":
        if outValue < 1:
            outValue = 0
        else:
            outValue = np.log(outValue)

    return outValue

def getMinMaxValue(image,compute=False):

    valueMin = None
    valueMax = None
    text = image.getUserPropertiesStr()

    try:
        ddict = readElement(text)
        if ddict != {} and compute == False:
            try:
                valueMin = ddict["MinValue"]
                valueMax = ddict["MaxValue"]
            except:
                pass
    except:
        ddict = {}

    if valueMin is None or valueMax is None:
        if image.getSizeZ() == 1 and image.getSizeC() == 1 and image.getSizeT() == 1:
            imageMeasures = glbmsr.statsMsr2d(image)
            valueMin = imageMeasures.min
            valueMax = imageMeasures.max

        else:
            planIndexedStatsMsrResult = glbmsr.multiSlice_statsMsr2d(image)
            planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)
            valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]
            valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]
            for z in range(image.getSizeZ()):
                for c in range(image.getSizeC()):
                    for t in range(image.getSizeT()):
                        valueMin = min(valueMin, planIndexedStatsMsrResultDict[(z, c, t)]["Min"])
                        valueMax = max(valueMax, planIndexedStatsMsrResultDict[(z, c, t)]["Max"])

        ddict["MinValue"] = valueMin
        ddict["MaxValue"] = valueMax

        newText = writeElement(ddict)
        # image.setUserPropertiesStr(newText)

    return valueMin,valueMax

def getValueMinMask(image):

    mask = bin.thresholdImg(image, 0, 0)
    mask = logic.logicalNotImg(mask)

    if image.getSizeZ() == 1 and image.getSizeC() == 1 and image.getSizeT() == 1:

        measureMask = glbmsr.statsMsr2d(mask).max
        if measureMask > 0:
            imageMeasuresMasked = glbmsr.statsMaskMsr2d(image, mask)
            valueMinMask = imageMeasuresMasked.min
        else:
            valueMinMask = 0
    else:

        planIndexedStatsMsrResultMasked = glbmsr.multiSlice_statsMaskMsr2d(image, mask)
        planIndexedStatsMsrResultDictMasked = PyIPSDK.toPyDict(planIndexedStatsMsrResultMasked)
        valueMinMask = planIndexedStatsMsrResultDictMasked[(0, 0, 0)]["Min"]
        for z in range(image.getSizeZ()):
            for c in range(image.getSizeC()):
                for t in range(image.getSizeT()):
                    valueMinMask = min(valueMinMask, planIndexedStatsMsrResultDictMasked[(z, c, t)]["Min"])

    return valueMinMask


def getMultiResolutionImage(image,minimumSize = 2000):

    if image.isDiskImage():
        multiresImage = {}
        multiresImage[0] = image
    else:
        interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
        if image.getBufferType() not in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32, PyIPSDK.eIBT_Binary]:
            interp = PyIPSDK.eZoomInterpolationMethod.eZIM_Linear

        multiresImage = {}
        multiresImage[0] = image
        i = 0
        while multiresImage[i].getSizeX() > minimumSize and multiresImage[i].getSizeY() > minimumSize:
            newImage = gtrans.zoom2dImg(multiresImage[i],0.5,0.5, interp)
            i+=1
            multiresImage[i] = newImage

        multiresImage["maxZoom"] = i

    return multiresImage


def createListNameForCompleter(name):
    avoidName = ["2D", "2d", "3D", "3d"]

    nameSplit = name.split(" ")
    nameList = []
    for i in range(len(nameSplit)):
        nameToAdd = ""
        if nameSplit[i] not in avoidName:
            nameToAdd += nameSplit[i]
            for j in range(len(nameSplit)):
                if j != i:
                    nameToAdd += " " + nameSplit[j]
            nameList.append(nameToAdd)

    if name == "Patch-based bilateral filter 2D":
        nameList.append("NLM 2D")
        nameList.append("Non Local Mean 2D")
    if name == "Patch-based bilateral filter 3D":
        nameList.append("NLM 3D")
        nameList.append("Non Local Mean 3D")

    return nameList

def getStyleSheet(filename = vrb.folderStyles + '/custom.txt') :

    style = ""
    with open(filename) as file:
        for line in file:
            style += line

    valueToReplace =[]
    styleSplit = style.split("ratio(")
    for i in range(len(styleSplit)):
        if i!=0:
            value = styleSplit[i].split(")")[0]
            if value not in valueToReplace:
                valueToReplace.append(value)
    for value in valueToReplace:
        style = style.replace("ratio("+value+")",str(int(int(value)*vrb.ratio)))

    style += "\nQCheckBox::indicator:checked{image:url("+vrb.folderExplorer.replace("\\","/")+"/Interface/Images/checkbox.png);}"
    style += "\nQCheckBox::indicator:indeterminate{image:url("+vrb.folderExplorer.replace("\\","/")+"/Interface/Images/checkbox_intermediate.png);}"

    return style


def convertToXlsFile(tableWidget,filename,title="Infoset",header=True):

    changePoint = False
    offset = 0

    try:
        file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
        settingsElement = file.getroot()
        decimalSeparatorElement = Dfct.SubElement(settingsElement, "DecimalSeparator")
        if decimalSeparatorElement.text == ",":
            changePoint = True
    except:
        pass

    try:

        if filename.endswith(".xls") == False:
            filename+=".xls"

        book = xlwt.Workbook(encoding="utf-8")
        sheet1 = book.add_sheet(title, cell_overwrite_ok=True)

        if header:
            offset = 1
            for j in range(tableWidget.colorCount()):
                horizontalHeaderItem = tableWidget.horizontalHeaderItem(j)
                if horizontalHeaderItem is not None:
                    text = horizontalHeaderItem.text()
                    text = convertTextToXls(text)
                    sheet1.write(0, j, text)

        for i in range(tableWidget.rowCount()):
            for j in range(tableWidget.colorCount()):
                item = tableWidget.item(i,j)
                if item is not None:

                    text = item.text()
                    if changePoint:
                        text = text.replace(".",",")

                    sheet1.write(i+offset,j,text)#,style)

        book.save(filename)
    except Exception as e:
        traceback.print_exc(file=sys.stderr)
        print (e)

def convertToCsvFile(tableWidget,filename,header = True):

    try:

        if filename.endswith(".csv") == False:
            filename+=".csv"

        csvWritter = csv.writer(open(filename, 'w', newline=''), delimiter=',', quotechar=',', quoting=csv.QUOTE_MINIMAL)

        if header:
            textRow = ""
            for j in range(tableWidget.colorCount()):
                horizontalHeaderItem = tableWidget.horizontalHeaderItem(j)
                if horizontalHeaderItem is not None:
                    text = horizontalHeaderItem.text()
                    text = convertTextToCsv(text)
                    textRow+=text + ";"
                else:
                    textRow+=";"
            if textRow != "":
                textRow = textRow[:-1]
            csvWritter.writerow([textRow])

        for i in range(tableWidget.rowCount()):
            textRow = ""
            for j in range(tableWidget.colorCount()):
                item = tableWidget.item(i, j)
                if item is not None:
                    textRow += item.text() + ";"
                else:
                    textRow+=";"
            if textRow != "":
                textRow = textRow[:-1]

            csvWritter.writerow([textRow])
    except Exception as e:
        traceback.print_exc(file=sys.stderr)
        pass

def createPolygonImage(roiElement,image,buffer = PyIPSDK.eIBT_Binary,value=1):

    try:
        imagePolygon = Image.new('L', (image.getSizeX(), image.getSizeY()), 0)
    except:
        imagePolygon = Image.new('L', (image.shape[1], image.shape[0]), 0)

    polygon = []
    allPointsElement = Dfct.SubElement(roiElement, "AllPoints")
    nbPoints = 0
    for numChild in allPointsElement:
        for child in allPointsElement:
            if child.tag == "Point":
                if Dfct.childText(child, "Num") == str(nbPoints):
                    pointX = Dfct.childText(child, "PointX")
                    pointY = Dfct.childText(child, "PointY")
                    polygon.append(int(float(pointX)))
                    polygon.append(int(float(pointY)))
                    nbPoints += 1
    if len(polygon) > 4:
        ImageDraw.Draw(imagePolygon).polygon(polygon, outline=value, fill=value)

    imagePolygon = 1 * np.array(imagePolygon)
    imagePolygon = PyIPSDK.fromArray(imagePolygon)

    imagePolygon = util.convertImg(imagePolygon, buffer)

    return imagePolygon,polygon

def getDictImage(inputFilename):

    # Recuperation d'une liste d'images rangees depuis un nom de dossier

    maskNumbers = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
    # maskExtension = ["tif", "tiff"]
    maskExtension = ["tif", "tiff","jpg", "JPG", "jpeg", "JPEG", "PNG", "png", "BMP", "bmp","dcm","DCM", "nii", "NII"]

    numbers = set()
    ddict = {}

    for file in os.listdir(inputFilename):
        print(file)

    for file in os.listdir(inputFilename):
        extension = file.split('.')[len(file.split('.')) - 1]
        extension = extension.lower()
        if extension in maskExtension:
            number = ""
            ind = 0
            for character in file:
                if character in maskNumbers and ind == 0:
                    number += character
                if (character == "." or character == ",") and number != "" and ind == 0:
                    number += "."
                if character not in maskNumbers and character != "." and character != "," and number != "":
                    ind = 1
            try:
                number = float(number)
            except:
                number = 0
            numbers.add(number)
            if number not in ddict:
                ddict[number] = [inputFilename + "/" + file]
            else:
                ddict[number].append(inputFilename + "/" + file)

    numbers = sorted(numbers)

    listImages = []

    for number in numbers:
        currentList = ddict[number]
        currentList = sorted(currentList)
        for currentFile in currentList:
            listImages.append(currentFile)

    return listImages

def listToHistogram(inList,minValue = None, maxValue = None, binWidth = None, nbValues = None):

    try:
        array = np.asarray(inList)
        histogram = {}

        if minValue is None:
            histogram["Min"] = np.min(array)
        else:
            histogram["Min"] = minValue
        if maxValue is None:
            histogram["Max"] = np.max(array)
        else:
            histogram["Max"] = maxValue
        if histogram["Max"] == histogram["Min"]:
            histogram["BinWidth"] = 1
        else:
            if binWidth is None:
                if nbValues is None:
                    nbValues = 100
                histogram["BinWidth"] = (histogram["Max"] - histogram["Min"])/max(nbValues,1)
            else:
                histogram["BinWidth"] = binWidth
                nbValues = int((histogram["Max"] - histogram["Min"])/histogram["BinWidth"])
        histogram["Frequencies"] = np.zeros((nbValues))
        for value in inList:
            try:
                index = (value - histogram["Min"])/histogram["BinWidth"]
                index = min(int(index),nbValues-1)
                histogram["Frequencies"][index]+=1
            except:
                pass


    except:
        traceback.print_exc(file=sys.stderr)

    return histogram

def writeLogs(title,error):

    if vrb.unitTestMode == False or ("must be str, not NoneType" not in str(error) and "is not initialized" not in str(error)):

        date = str(datetime.datetime.now())
        date = date.split(".")[0]
        date = date.replace("-", "_")
        date = date.replace(":", "_")
        date = date.replace(" ", "_")

        f = open(vrb.currentFolderLog + "/" + date + "_" + title + ".txt", "w+")
        f.write(str(error))
        f.close()

def textRemplacement(text):

    text = text.replace("=", " ")
    text = text.replace(",", " ")
    text = text.replace("(", " ")
    text = text.replace(")", " ")
    text = text.replace("\n", " ")
    text = text.replace("\t", " ")
    text = text.replace("!", " ")
    text = text.replace("&", " ")
    text = text.replace("|", " ")

    return text

def clearLayout(layout):

    while layout.count() != 0:
        item = layout.itemAt(0)
        if item is not None:
            item.widget().deleteLater()
            layout.removeItem(item)

def invertDictName(ddict,name):
    output = None
    for tag in ddict:
        try:
            if ddict[tag] == name:
                output = tag
        except:
            pass

    return output

def findUserName(key):

    userName = None
    found = False
    for category in os.listdir(vrb.folderShapeAnalysis):
        for module in os.listdir(vrb.folderShapeAnalysis + "/" + category):
            for measure in os.listdir(vrb.folderShapeAnalysis + "/" + category + "/" + module):
                if measure.split(".")[0] == key:
                    xmlElement = xmlet.parse(vrb.folderShapeAnalysis + "/" + category + "/" + module+"/"+measure).getroot()
                    userName = Dfct.childText(xmlElement,"UserName")
                    found = True

    if userName is None:
        userName = key

    return userName, found

def lutImageFromArray(array,vertical = True):

    image = []
    keys = sorted(array.keys())
    factor = 255 / keys[len(keys) - 1]
    for i in range(len(keys) - 1):
        for num in range(int(factor * keys[i + 1]) - int(factor * (keys[i]))):
            ratio = num / (int(factor * keys[i + 1]) - int(factor * (keys[i])))
            if vertical:
                image.append([[int(array[keys[i + 1]][0] * ratio + array[keys[i]][0] * (1 - ratio)),
                               int(array[keys[i + 1]][1] * ratio + array[keys[i]][1] * (1 - ratio)),
                               int(array[keys[i + 1]][2] * ratio + array[keys[i]][2] * (1 - ratio))]])
            else:
                ind = len(keys) - i - 2
                image.append([int(array[keys[ind ]][0] * ratio + array[keys[ind+1]][0] * (1 - ratio)),
                               int(array[keys[ind ]][1] * ratio + array[keys[ind+1]][1] * (1 - ratio)),
                               int(array[keys[ind ]][2] * ratio + array[keys[ind+1]][2] * (1 - ratio))])
    if vertical:
        image.append([[array[keys[len(keys) - 1]][0], array[keys[len(keys) - 1]][1], array[keys[len(keys) - 1]][2]]])
    else:
        image.append([array[keys[0]][0], array[keys[0]][1], array[keys[0]][2]])
        image = [image]

    return image

def get_size(bytes, suffix="B"):

    """
    Scale bytes to its proper format
    e.g:
        1253656 => '1.20MB'
        1253656678 => '1.17GB'
    """
    factor = 1024
    for unit in ["", "K", "M", "G", "T", "P"]:
        if bytes < factor:
            return f"{bytes:.2f}{unit}{suffix}"
        bytes /= factor

def applyImageContrast(image,minValue,maxValue):

    minValue = float(minValue)
    maxValue = float(maxValue)

    if maxValue - minValue != 0:
        image = util.convertImg(image, PyIPSDK.eIBT_Real32)
        image = arithm.addScalarImg(image, -minValue)
        image = arithm.multiplyScalarImg(image, 255 / (maxValue - minValue))
    outImage = util.convertImg(image, PyIPSDK.eIBT_UInt8)

    return outImage


def getImageJVersion():

    res = ""

    try:
        try:
            file = xmlet.parse(vrb.folderBenchmark + "/imageJ.mho")
            imageJElement = file.getroot()
        except:
            imageJElement = xmlet.Element('imageJ')

        pathImageJ = Dfct.childText(imageJElement, "Path")

        if pathImageJ is not None and pathImageJ != "":

            pathImageJ = os.path.dirname(pathImageJ)

            fileTime = open(pathImageJ + "/README.md", "r")
            textTime = fileTime.read()

            version = textTime.split("<version>")
            numVersion = None

            for i in range(1, len(version)):
                try:
                    int(version[i][0])
                    numVersion = version[i].split("</version>")[0]
                except Exception as e:
                    pass

            if len(numVersion) <= 10:
                res = numVersion

            fileTime.close()

    except:
        pass

    return res

def getItkVersion():

    res = ""

    try:
        forlderIPSDK = os.path.dirname(vrb.folderExplorer)

        folderSitePackages = forlderIPSDK + "/Miniconda/Lib/site-packages/"

        itkRefs = ["itk-", "itk_core-"]

        for fileName in os.listdir(folderSitePackages):
            for itkRef in itkRefs:
                if itkRef in fileName:
                    version = fileName.split(itkRef)[1]
                    version = version.split(".dist-info")[0]

        i = 0
        while (i < len(version) and version[i] in ["0","1","2","3","4","5","6","7","8","9","."]):
            res += version[i]
            i+=1

        if len(res) > 10:
            res = ""

        if res != "" and res[len(res)-1] == ".":
            res = res[:-1]

    except:
        pass

    return res

def launchWithoutConsole(command):
    """Launches 'command' windowless and waits until finished"""
    startupinfo = subprocess.STARTUPINFO()
    # startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
    # startupinfo.dwFlags |= subprocess.CREATE_NEW_CONSOLE
    startupinfo.dwFlags |= subprocess.CREATE_NEW_PROCESS_GROUP
    return subprocess.Popen(command, startupinfo=startupinfo).wait()

def readImage(url, multi=False, name="" , sequence = False, disk = False):

    if multi:
        try:
            if disk == False:

                imagesList = getDictImage(url)

                refImage = urlToPythonImage(imagesList[0])
                if sequence == False:
                    if refImage.getSizeC() == 1:
                        geometry = PyIPSDK.geometry3d(refImage.getBufferType(), refImage.getSizeX(), refImage.getSizeY(), len(imagesList))
                    else:
                        colorGeometryType = refImage.getColorGeometryType()
                        colorGeometry = PyIPSDK.ColorGeometry()
                        if colorGeometryType == PyIPSDK.eCGT_User:
                            colorGeometry.initUser(refImage.getSizeC())
                        else:
                            colorGeometry.init(colorGeometryType)
                        volumeGeometry = PyIPSDK.VolumeGeometry()
                        volumeGeometry.init3d(len(imagesList))
                        temporalGeometry = PyIPSDK.TemporalGeometry()
                        temporalGeometry.initSingle()
                        geometry = PyIPSDK.geometry(refImage.getBufferType(), refImage.getSizeX(), refImage.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)
                else:
                    colorGeometry = PyIPSDK.ColorGeometry()
                    if refImage.getSizeC() == 1:
                        colorGeometryType = PyIPSDK.eCGT_Grey
                        colorGeometry.init(colorGeometryType)
                    else:
                        colorGeometryType = refImage.getColorGeometryType()
                        if colorGeometryType == PyIPSDK.eCGT_User:
                            colorGeometry.initUser(refImage.getSizeC())
                        else:
                            colorGeometry.init(colorGeometryType)

                    volumeGeometry = PyIPSDK.VolumeGeometry()
                    if refImage.getSizeZ() == 1:
                        volumeGeometry.init2d()
                    else:
                        volumeGeometry.init3d(refImage.getSizeZ())
                    temporalGeometry = PyIPSDK.TemporalGeometry()
                    temporalGeometry.initSequence(len(imagesList))
                    geometry = PyIPSDK.geometry(refImage.getBufferType(), refImage.getSizeX(), refImage.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)

                imageIP = PyIPSDK.createImage(geometry)

                for i in range(len(imagesList)):
                    if vrb.mainWindow is not None:
                        vrb.mainWindow.groupBoxProcessing.setText('Adding image (' + str(i + 1) + '/' + str(len(imagesList)) + ')\n' + name)
                    qt.QApplication.processEvents()
                    if i != 0:
                        refImage = urlToPythonImage(imagesList[i])
                    if sequence == False:
                        if refImage.getSizeC() == 1:
                            outPlan = PyIPSDK.extractPlan(i, 0, 0, imageIP)
                        else:
                            outPlan = PyIPSDK.extractColor(i, 0, imageIP)
                    else:
                        if refImage.getSizeC() == 1 and refImage.getSizeZ() == 1:
                            outPlan = PyIPSDK.extractPlan(0, 0, i, imageIP)
                        elif refImage.getSizeC() == 1 and refImage.getSizeZ() > 1:
                            outPlan = PyIPSDK.extractVolume(0, i, imageIP)
                        elif refImage.getSizeC() > 1 and refImage.getSizeZ() == 1:
                            outPlan = PyIPSDK.extractColor(0, i, imageIP)
                        else:
                            outPlan = PyIPSDK.extractColorVolume(i, imageIP)

                    util.copyImg(refImage, outPlan)
            else:
                imageIP = PyIPSDK.openTiffImageFiles(url)

            # if sequence:
            #     imageIP = util.copyImg(imageIP)

        except:
            traceback.print_exc(file=sys.stderr)

    else:
        imageIP = urlToPythonImage(url, disk = disk)

    if imageIP is not None:
        basename = os.path.basename(url)
        name, file_extension = os.path.splitext(basename)
        imageIP.name = name

    return imageIP

def urlToPythonImage(url, disk = False):

    urlSplit = url.split('.')
    extension = urlSplit[len(urlSplit) - 1]

    try:

        if extension in ["tif", "tiff", "TIF", "TIFF","Tif","Tiff"]:
            if disk == False:
                imageIP = PyIPSDK.loadTiffImageFile(url)
            # if(imageIP.getColorGeometryType() == PyIPSDK.eCGT_Rgba):
            #     imageIP = color.colorConvertImg(imageIP, PyIPSDK.eCGT_Rgb)
            else:
                imageIP = PyIPSDK.openTiffImageFile(url, PyIPSDK.eTDM_Volume, PyIPSDK.eTBM_Default)
        elif extension in ["im6", "IM6"]:
            imageIP = PyIPSDK.loadIm6ImageFile(url)
            imageIP = util.copyImg(imageIP)
        elif extension.lower() in ["jpg","jpeg", "png", "bmp"]:
            imageIP = openImageOpenCV(url)
        elif extension in ["czi", "CZI"]:
            imageIP = openImageCzi(url)
        elif extension.lower() in ["txm"]:
            imageIP = openImageTxm(url)
        elif extension.lower() in ["am"]:
            imageIP = openImageAm(url)
        elif extension in ["dcm", "DCM"]:
            imageIP = openImageDcm(url)
        elif extension in ["nii", "NII"]:
            imageIP = openImageNii(url)
        else:
            imageIP = openImageOpenCV(url)
    except:
        traceback.print_exc(file=sys.stderr)

        imageIP = openImageOpenCV(url)

    return imageIP

def openImageDcm(url):

    ds = dicom.dcmread(url)
    image = PyIPSDK.fromArray(ds.pixel_array)

    return image
def openImageTxm(file_path):
    # Vérifier si le fichier est bien un fichier OLE
    if not olefile.isOleFile(file_path):
        print(f"{file_path} n'est pas un fichier OLE compatible.")
        return

    # Ouvrir le fichier OLE
    with olefile.OleFileIO(file_path) as ole:
        # Accéder à la section 'ImageInfo' pour lire les métadonnées
        try:
            if not ole.exists('ImageInfo'):
                print("ImageInfo section introuvable dans le fichier.")
                return

            width = read_int_from_stream(ole, 'ImageInfo/ImageWidth')
            height = read_int_from_stream(ole, 'ImageInfo/ImageHeight')
            data_type = read_int_from_stream(ole, 'ImageInfo/DataType')
            number_of_images = read_int_from_stream(ole, 'ImageInfo/NoOfImages')

            # Afficher les métadonnées
            print(f"Largeur: {width}")
            print(f"Hauteur: {height}")
            print(f"Nombre d'images: {number_of_images}")
            print(f"Type de données: {data_type}")

        except Exception as e:
            print(f"Erreur lors de la lecture des métadonnées: {e}")

        # Créer un tableau 3D pour stocker le volume
        if data_type == 10:  # FLOAT_TYPE
            volume = np.zeros((number_of_images, height, width), dtype=np.float32)
        elif data_type == 5:  # INT16_TYPE
            volume = np.zeros((number_of_images, height, width), dtype=np.uint16)
        elif data_type == 3:  # UCHAR_TYPE
            volume = np.zeros((number_of_images, height, width), dtype=np.uint8)
        else:
            print(f"Type de données inconnu: {data_type}")
            return

        # Lire les images et les insérer dans le volume
        for image_number in range(1, number_of_images + 1):
            image_data = read_image_data(ole, width, height, image_number, data_type)
            if image_data is not None:
                volume[image_number - 1, :, :] = image_data

        image3d = PyIPSDK.fromArray(volume)

        return image3d
def openImageAm(file_path):

    with open(file_path, 'rb') as f:
        # Read the header until "# Data section follows"
        header = b""
        while b"# Data section follows" not in header:
            line = f.readline()
            header += line

        # Decode the header as UTF-8 and ignore any errors
        header_str = header.decode('utf-8', errors='ignore')

        # Extract the dimensions from the header
        dims = re.search(r'define Lattice (\d+) (\d+) (\d+)', header_str)
        if dims:
            dims = [int(d) for d in dims.groups()]

            if len(dims) == 2:
                sx = dims[1]
                dims[1] = dims[0]
                dims[0] = sx
            else:
                sx = dims[2]
                dims[2] = dims[0]
                dims[0] = sx
        else:
            raise ValueError("Dimensions not found in the file header.")

        # Extract the data type information
        data_type_match = re.search(r'Lattice { (\w+) (\w+)', header_str)
        if data_type_match:
            base_type, data_format = data_type_match.groups()
        else:
            raise ValueError("Data type not found in the file header.")

        # print("base_type =", base_type)
        # print("data_format =", data_format)

        # Handle 'data' format or typical 'scalar' formats
        if base_type == 'float':
            dtype = np.float32  # Float scalar
        if base_type == 'ushort':
            dtype = np.uint16  # Ushort scalar
        elif base_type == 'double':
            dtype = np.float64  # Double scalar
        elif base_type == 'int':
            dtype = np.int32  # 32-bit integer scalar
        elif base_type == 'byte':
            dtype = np.uint8  # Byte scalar
        else:
            raise ValueError(f"Unsupported data type combination: {base_type} {data_format}")

        # Calculate the expected number of elements
        expected_size = np.prod(dims)

        # Read the actual data part as binary
        raw_data = f.read()

        # Convert the raw data to a NumPy array
        data = np.frombuffer(raw_data, dtype=dtype)

        # Handle extra bytes: truncate if the buffer is too long
        if data.size > expected_size:
            # Skip the extra bytes at the beginning
            excess_elements = data.size - expected_size
            data = data[excess_elements:]

        # Reshape the data according to the extracted dimensions
        data = data.reshape(dims)

        output = PyIPSDK.fromArray(data)

    return output

def read_int_from_stream(ole, stream_name):
    with ole.openstream(stream_name) as stream:
        return int.from_bytes(stream.read(4), byteorder='little')


def read_float_from_stream(ole, stream_name):
    with ole.openstream(stream_name) as stream:
        return np.frombuffer(stream.read(4), dtype=np.float32)[0]


def read_image_data(ole, width, height, image_number, data_type):
    try:
        # Nom du répertoire ImageData
        image_data_dir = f"ImageData{((image_number - 1) // 100) + 1}"
        image_name = f"Image{image_number}"

        if not ole.exists(f"{image_data_dir}/{image_name}"):
            print(f"{image_data_dir}/{image_name} non trouvé.")
            return None

        # Lire les données d'image
        with ole.openstream(f"{image_data_dir}/{image_name}") as stream:
            if data_type == 10:  # FLOAT_TYPE
                data = np.frombuffer(stream.read(width * height * 4), dtype=np.float32)
            elif data_type == 5:  # INT16_TYPE (modifié pour être UInt16)
                data = np.frombuffer(stream.read(width * height * 2), dtype=np.uint16)
            elif data_type == 3:  # UCHAR_TYPE
                data = np.frombuffer(stream.read(width * height), dtype=np.uint8)
            else:
                print(f"Type de données inconnu: {data_type}")
                return None

            # Reshape et inverser les lignes pour correspondre à l'orientation originale
            image_data = data.reshape((height, width))[::-1]

            return image_data

    except Exception as e:
        print(f"Erreur lors de la lecture des données d'image: {e}")
        return None

def openImageCzi(url):

    image = czifile.imread(url,max_workers=1)
    metadata = czifile.CziFile(url)

    axes = metadata.axes
    shape = metadata.shape
    shape, axes = tifffile.squeeze_axes(shape, axes, '')
    image = image.reshape(shape)

    dictMetadata = {}
    for i in range(len(axes)):
        dictMetadata[axes[i]] = shape[i]

    if "0" not in dictMetadata or dictMetadata["0"] == 1:
        imageIP = PyIPSDK.fromArray(image)
    else:
        if dictMetadata["0"] == 3:
            b, g, r = cv2.split(image)
        if dictMetadata["0"] == 4:
            b, g, r, a = cv2.split(image)

        allChannels = [PyIPSDK.fromArray(r), PyIPSDK.fromArray(g), PyIPSDK.fromArray(b)]
        if "Z" not in dictMetadata or dictMetadata["Z"] == 1:
            geometry = PyIPSDK.geometryRgb2d(allChannels[0].getBufferType(), dictMetadata["X"], dictMetadata["Y"])
        else:
            geometry = PyIPSDK.geometryRgb3d(allChannels[0].getBufferType(), dictMetadata["X"], dictMetadata["Y"],dictMetadata["Z"])
        imageIP = PyIPSDK.createImage(geometry)
        util.eraseImg(imageIP, 0)
        for c in range(3):
            if "Z" not in dictMetadata or dictMetadata["Z"] == 1:
                plan = PyIPSDK.extractPlan(0, c, 0, imageIP)
                util.copyImg(allChannels[c], plan)
            else:
                volume = PyIPSDK.extractPlan( c, 0, imageIP)
                util.copyImg(allChannels[c], volume)

    return imageIP

def openImageNii(url):
    # img_nii = nibabel.load("E:/Data/NiiFiles/SIGMA_Anatomical_Brain_Atlas.nii")
    img_nii = nibabel.load(url)

    # Get data from nibabel image object (returns numpy memmap object)
    img_nii_data = img_nii.get_fdata()

    # Convert to numpy ndarray (dtype: uint16)
    img_nii_data_arr = np.asarray(img_nii_data)

    # Convert to an IPSDK image
    if len(img_nii_data_arr.shape) > 2:
        image = PyIPSDK.fromArray(np.swapaxes(img_nii_data_arr.astype(np.float32), 0, 2))
    else:
        image = PyIPSDK.fromArray(img_nii_data_arr.astype(np.float32))

    return image
def pilImageToIPSDKImage(pilImg):
    cv2Img = np.array(pilImg)
    r, g, b, t = cv2.split(cv2Img)

    allChannels = [PyIPSDK.fromArray(r), PyIPSDK.fromArray(g), PyIPSDK.fromArray(b)]

    imageIP = PyIPSDK.createImageRgb(allChannels[0].getBufferType(), cv2Img.shape[1], cv2Img.shape[0])
    util.eraseImg(imageIP, 0)

    for c in range(3):
        plan = PyIPSDK.extractPlan(0, c, 0, imageIP)
        util.copyImg(allChannels[c], plan)

    return imageIP

def IPSDKImageToPilImage(image):

    # convert ipsdk image to pillow image
    if image.getColorGeometryType() == PyIPSDK.eCGT_Grey:
        pilGreyImg = Image.fromarray(image.array)
        pilRgbImg = Image.new("RGBA", pilGreyImg.size)
        pilRgbImg.paste(pilGreyImg)
    else:  # if rgb image
        array = cv2.merge([image.array[0], image.array[1], image.array[2]])
        pilImg = Image.fromarray(array)
        pilRgbImg = Image.new("RGBA", pilImg.size)
        pilRgbImg.paste(pilImg)

    return pilRgbImg

def openImageOpenCV(url):

    image = cv2.imread(url, -1)
    if image is None:
        stream = open(url, "rb")
        bytes = bytearray(stream.read())
        numpyarray = np.asarray(bytes, dtype=np.uint8)
        image = cv2.imdecode(numpyarray, cv2.IMREAD_UNCHANGED)

    imageIP = numpyImageToIPSDKImage(image)

    return imageIP

def numpyImageToIPSDKImage(image,invertChannels = True):

    if len(image.shape) >= 3:
        if image.shape[2] >= 3:
            if image.shape[2] == 3:
                if invertChannels:
                    b, g, r = cv2.split(image)
                else:
                    r, g, b = cv2.split(image)
            if image.shape[2] == 4:
                if invertChannels:
                    b, g, r, a = cv2.split(image)
                else:
                    r, g, b, a = cv2.split(image)

            allChannels = [PyIPSDK.fromArray(r), PyIPSDK.fromArray(g), PyIPSDK.fromArray(b)]

            imageIP = PyIPSDK.createImageRgb(allChannels[0].getBufferType(), image.shape[1], image.shape[0])
            util.eraseImg(imageIP, 0)
            for c in range(3):
                plan = PyIPSDK.extractPlan(0, c, 0, imageIP)
                util.copyImg(allChannels[c], plan)
        else:
            imageIP = PyIPSDK.fromArray(image)
    else:
        imageIP = PyIPSDK.fromArray(image)

    return imageIP

def IPSDKImageToQImg(image):

    if image.getSizeC() == 1:
        imgFormat = QtGui.QImage.Format_Grayscale8
        qimg = QtGui.QImage(image.array, image.getSizeX(), image.getSizeY(), image.getSizeX(), imgFormat)

    if image.getSizeC() == 3:
        imgFormat = QtGui.QImage.Format_RGB888
        qimg = QtGui.QImage(image.getSizeX(), image.getSizeY(), imgFormat)
        for v in range(image.getSizeY()):
            ptr = qimg.scanLine(v)
            ptr.setsize(qimg.bytesPerLine())
            lineArr = numpy.asarray(ptr)
            for c in range(3):
                lineArr[c::3][:image.getSizeX()] = image.array[c][v][0:image.getSizeX()]

    return qimg

def IPSDKImageToPixmap(image):

    qImg = IPSDKImageToQImg(image)
    pixmapImage = QtGui.QPixmap.fromImage(qImg)

    return pixmapImage

def getRoiImage(image,roiSizeX, roiSizeY,usefulSizeX, usefulSizeY,realStartPointX,realStartPointY):


    if image is not  None:
        if image[0].isDiskImage():
            factor = max(roiSizeX/usefulSizeX,roiSizeY/usefulSizeY)
            factor = max(int(factor),1)
            start2 = time.time()
            # roiImage = image[0].loadPlan(0, 0, 0, int(roiSizeX/factor), int(roiSizeY/factor), int(realStartPointX), int(realStartPointY), factor, factor)
            # roiImage = image[0].loadPlan(0, 0, 0, int(roiSizeX/factor), int(roiSizeY/factor), int(realStartPointX), int(realStartPointY), 1, factor)
            roiImage = loadPlanImageDisk(image[0], int(roiSizeX/factor), int(roiSizeY/factor), int(realStartPointX), int(realStartPointY), factor, factor)
            interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour

            newRoiSizeX = roiImage.getSizeX()
            newRoiSizeY = roiImage.getSizeY()

            roiImage = gtrans.zoom2dImg(roiImage, usefulSizeX / round(newRoiSizeX), usefulSizeY / round(newRoiSizeY), interp)

        else:

            ratio = min(roiSizeX / usefulSizeX, roiSizeY, usefulSizeY)
            zoomLvl = int(numpy.log(ratio) / numpy.log(2))
            zoomLvl = max(0, zoomLvl)
            zoomLvl = min(zoomLvl, image["maxZoom"])
            factorResize = 2 ** zoomLvl

            newRoiSizeX = min(roiSizeX / factorResize, image[zoomLvl].getSizeX())
            newRoiSizeY = min(roiSizeY / factorResize, image[zoomLvl].getSizeY())

            newRealStartPointX = min(image[zoomLvl].getSizeX() - round(newRoiSizeX), realStartPointX / factorResize)
            newRealStartPointY = min(image[zoomLvl].getSizeY() - round(newRoiSizeY), realStartPointY / factorResize)

            roiImage = util.getROI2dImg(image[zoomLvl], round(newRealStartPointX), round(newRealStartPointY), round(newRoiSizeX), round(newRoiSizeY))
            interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
            if roiImage.getBufferType() not in vrb.bufferListBinaryLabel:
                # interp = PyIPSDK.eZoomInterpolationMethod.eZIM_Linear
                interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
            roiImage = gtrans.zoom2dImg(roiImage, usefulSizeX / round(newRoiSizeX), usefulSizeY / round(newRoiSizeY), interp)
    else:
        roiImage = None

    return roiImage

def createImageFromCrop(imageOverlay,image,offsetX,offsetY,offsetZ):

    outImage = PyIPSDK.createImage(image,imageOverlay.getBufferType())
    util.eraseImg(outImage, 0)

    if image.getSizeZ()>1:
        util.putROI3dImg(outImage, imageOverlay, int(offsetX), int(offsetY),int(offsetZ), outImage)
    else:
        util.putROI2dImg(outImage, imageOverlay, int(offsetX), int(offsetY), outImage)

    return outImage


def getImagePlan(image, widgetImage):

    if image.getSizeC() != 1:
        colorGeometryType = image.getColorGeometryType()
        colorGeometry = PyIPSDK.ColorGeometry()
        if colorGeometryType == PyIPSDK.eCGT_User:
            colorGeometry.initUser(image.getSizeC())
        else:
            colorGeometry.init(colorGeometryType)
        volumeGeometry = PyIPSDK.VolumeGeometry()
        volumeGeometry.init2d()
        temporalGeometry = PyIPSDK.TemporalGeometry()
        temporalGeometry.initSingle()

    if widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
        value = widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()
        if image.getSizeC() == 1:
            planArray = numpy.ascontiguousarray(image.array[:, :, value])
            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeY(), image.getSizeZ())
        else:
            planArray = numpy.ascontiguousarray(image.array[:, :, :, value])
            # geometry = PyIPSDK.geometryRgb2d(image.getBufferType(), image.getSizeY(), image.getSizeZ())
            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeY(), image.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)

    if widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
        value = widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value()
        if image.getSizeC() == 1:
            planArray = numpy.ascontiguousarray(image.array[:, value, :])
            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeX(), image.getSizeZ())
        else:
            planArray = numpy.ascontiguousarray(image.array[:, :, value, :])
            # geometry = PyIPSDK.geometryRgb2d(image.getBufferType(), image.getSizeX(), image.getSizeZ())
            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeX(), image.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)

    if widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
        value = widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value()
        if image.getSizeC() == 1:
            planArray = numpy.ascontiguousarray(image.array[value, :, :])
            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeX(), image.getSizeY())
        else:
            planArray = numpy.ascontiguousarray(image.array[:, value, :, :])
            # geometry = PyIPSDK.geometryRgb2d(image.getBufferType(), image.getSizeX(), image.getSizeY())
            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeX(), image.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)

    imageVisualization = PyIPSDK.fromArray(planArray, geometry)
    imageVisualization = util.copyImg(imageVisualization)

    return imageVisualization

def clearDirectory(folder):

    for filename in os.listdir(folder):
        file_path = os.path.join(folder, filename)
        try:
            if os.path.isfile(file_path) or os.path.islink(file_path):
                os.unlink(file_path)
            elif os.path.isdir(file_path):
                shutil.rmtree(file_path)
        except Exception as e:
            print('Failed to delete %s. Reason: %s' % (file_path, e))

def getModelName(folder):

    i = 1
    modelName = folder + "/" + "Model "+str(i)
    while os.path.exists(modelName):
        i+=1
        modelName = folder + "/" + "Model "+str(i)

    outputModel =  "Model "+str(i)

    return outputModel

def showWidget(widget):

    if widget.isMaximized():
        widget.showMaximized()
    else:
        widget.showNormal()
    widget.window().raise_()
    widget.window().activateWindow()

def correctArrayValues(array):

    if array is not None:
        array = np.nan_to_num(array)
        array[array>10**100] = 0
        array[array<-10**100] = 0

    return array

def writeWithZeros(number,length=3):

    result = str(number)
    while len(result) <length:
        result = "0"+result

    return result

def getNumId(element,name="Image"):

    try:
        try:
            numID = element.split("ID_"+name+"_")[1]
            numID = numID.split("_ID")[0]
        except:
            numID = element.split("ID_ImageBatch_")[1]
            numID = numID.split("_ID")[0]
    except:
        numID = 0

    return numID

def updateListAttributs(value,listAttributs,elementID):

    dictAttibut = value.__dict__
    for attr in dictAttibut:
        if dictAttibut[attr] is not None:
            for tag in vrb.dictElements:
                if vrb.dictElements[tag][1] == dictAttibut[attr]:
                    listAttributs.append([elementID, attr, tag])
        else:
            listAttributs.append([elementID, attr, None])

def customLightness(image):

    outImage = None

    for c in range(image.getSizeC()):
        if image.getSizeZ() == 1:
            subImage = PyIPSDK.extractPlan(0,c,0,image)
        else:
            subImage = PyIPSDK.extractVolume(c,0,image)
        if outImage is None:
            outImage = util.copyImg(subImage)
        else:
            subImage = util.copyImg(subImage)
            outImage = arithm.addImgImg(outImage,subImage)

    outImage = arithm.multiplyScalarImg(outImage,1/image.getSizeC())
    outImage = util.convertImg(outImage,image.getBufferType())

    return outImage

def convertToRgbImage(image,widgetLabelImage):

    colorVector = widgetLabelImage.colorVector

    colorGeometry = PyIPSDK.ColorGeometry()
    colorGeometry.initRgb()
    volumeGeometry = PyIPSDK.VolumeGeometry()
    if image.getSizeZ() == 1:
        volumeGeometry.init2d()
    else:
        volumeGeometry.init3d(image.getSizeZ())
    temporalGeometry = PyIPSDK.TemporalGeometry()
    temporalGeometry.initSingle()
    # geometry = PyIPSDK.geometry(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)
    geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeX(), image.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)
    outImage = PyIPSDK.createImage(geometry)

    for c in range(3):

        if image.getSizeZ() == 1:
            plan = PyIPSDK.extractPlan(0, c, 0, outImage)
            if colorVector[c] < image.getSizeC():
                planRef = PyIPSDK.extractPlan(0, colorVector[c], 0, image)
                planRef = util.copyImg(planRef)
            else:
                planRef = PyIPSDK.extractPlan(0,0, 0, image)
                planRef = util.copyImg(planRef)
                util.eraseImg(planRef,0)
            util.copyImg(planRef,plan)
        else:
            volume = PyIPSDK.extractVolume(c, 0, outImage)
            if colorVector[c] < image.getSizeC():
                volumeRef = PyIPSDK.extractVolume(colorVector[c], 0, image)
                volumeRef = util.copyImg(volumeRef)
            else:
                volumeRef = PyIPSDK.extractVolume(0, 0, image)
                volumeRef = util.copyImg(volumeRef)
                util.eraseImg(volumeRef,0)
            util.copyImg(volumeRef,volume)

    return outImage

def changeExtension(text,extension):

    filename, file_extension = os.path.splitext(text)
    outText = text.replace(file_extension,extension)
    return outText

def analysisToDict(analysis):

    allMeasures = []
    for msr in analysis.getMeasureInfoSet().getMeasureInfoColl():
        key = msr.key()
        userName, isFound = findUserName(key)
        if "->" not in userName and "___" not in userName and userName not in ["Ref_Barycenter_X", "Ref_Barycenter_Y", "Ref_Barycenter_Z"]:
            allMeasures.append((key, userName))

    dictResult = {}
    dictResult["Index"] = {}
    dictResult["Index"]["Values"] = []
    index = 1
    firstValue = True
    for callName, userName in allMeasures:
        values = analysis.getMeasure(callName).getMeasureResult().getColl(0)

        if analysis.getMeasure(callName).getMsrUnitStr() != "" and analysis.getMeasure(callName).getMsrUnitStr() is not None:
            unit = " (" + analysis.getMeasure(callName).getMsrUnitStr() + ")"
            unit = unit.replace('^2', '²')
            unit = unit.replace('^3', '³')
        else:
            unit = ""

        if userName not in dictResult:
            dictResult[userName] = {}
            dictResult[userName]["Unit"] = unit
            dictResult[userName]["Values"] = []
        for numValue in range(len(values)):
            if numValue!=0:
                dictResult[userName]["Values"].append(values[numValue])
                if firstValue:
                    dictResult["Index"]["Values"].append(index)
                    index+=1
        firstValue = False

    return dictResult


def listAnalysisToDict(listAnalysis):

    allMeasures = []
    for msr in listAnalysis[0].getMeasureInfoSet().getMeasureInfoColl():
        key = msr.key()
        userName, isFound = findUserName(key)
        if "->" not in userName and "___" not in userName and userName not in ["Ref_Barycenter_X", "Ref_Barycenter_Y", "Ref_Barycenter_Z"]:
            allMeasures.append((key, userName))

    dictResult = {}
    dictResult["Index"] = {}
    dictResult["Index"]["Values"] = []
    dictResult["NameImage"] = {}
    dictResult["NameImage"]["Values"] = []
    index = 1

    for analysis in listAnalysis:
        firstValue = True
        for callName, userName in allMeasures:
            values = analysis.getMeasure(callName).getMeasureResult().getColl(0)

            if analysis.getMeasure(callName).getMsrUnitStr() != "" and analysis.getMeasure(callName).getMsrUnitStr() is not None:
                unit = " (" + analysis.getMeasure(callName).getMsrUnitStr() + ")"
                unit = unit.replace('^2', '²')
                unit = unit.replace('^3', '³')
            else:
                unit = ""

            if userName not in dictResult:
                dictResult[userName] = {}
                dictResult[userName]["Unit"] = unit
                dictResult[userName]["Values"] = []
            for numValue in range(len(values)):
                if numValue!=0:
                    dictResult[userName]["Values"].append(values[numValue])
                    if firstValue:
                        dictResult["Index"]["Values"].append(index)
                        index+=1
                        dictResult["NameImage"]["Values"].append(analysis.nameImage)
            firstValue = False

    return dictResult

def dictToXlsFile(ddict,filename,title="Infoset_Merge"):

    changePoint = False
    try:
        file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
        settingsElement = file.getroot()
        decimalSeparatorElement = Dfct.SubElement(settingsElement, "DecimalSeparator")
        if decimalSeparatorElement.text == ",":
            changePoint = True
    except:
        pass

    try:
        if filename.endswith(".xls") == False:
            filename+=".xls"

        book = xlwt.Workbook(encoding="utf-8")
        sheet1 = book.add_sheet(title, cell_overwrite_ok=True)

        column=0

        if "Index" in ddict:
            sheet1.write(0, 0, "Index")
            for i in range(len(ddict["Index"]["Values"])):
                sheet1.write(i+1, 0, str(ddict["Index"]["Values"][i]))
            column += 1

        for textDict in ddict:
            if textDict not in ["Index","NameImage","Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:
                try:
                    name = textDict + ddict[textDict]["Unit"]
                except:
                    name = textDict

                sheet1.write(0, column, name)

                if "Values" in ddict[textDict]:
                    for i in range(len(ddict[textDict]["Values"])):
                        text = str(ddict[textDict]["Values"][i])
                        if changePoint:
                        	text = text.replace(".", ",")
                        # converts the str to float or int if possible
                        if isInt(text):
                            text = int(text)
                        elif isFloat(text):
                            text = float(text)
                        sheet1.write(i + 1, column, text)
                    column+=1
                else:
                    for i in range(len(ddict[textDict])):
                        text = str(ddict[textDict][i])
                        if changePoint:
                            text = text.replace(".", ",")
                        # converts the str to float or int if possible
                        if isInt(text):
                            text = int(text)
                        elif isFloat(text):
                            text = float(text)
                        sheet1.write(i + 1, column, text)
                    column+=1

        if "NameImage" in ddict:
            sheet1.write(0, column, "NameImage")
            for i in range(len(ddict["NameImage"]["Values"])):
                sheet1.write(i + 1, column, str(ddict["NameImage"]["Values"][i]))

        book.save(filename)
    except Exception as e:
        traceback.print_exc(file=sys.stderr)
        print (e)


def dictToCsvFile(ddict,filename):
    try:
        if filename.endswith(".csv") == False:
            filename+=".csv"

        csvWritter = csv.writer(open(filename, 'w', newline=''), delimiter=',', quotechar=',', quoting=csv.QUOTE_MINIMAL)

        nbRow = 0
        for textDict in ddict:
            if textDict != "Name":
                if "Values" in ddict[textDict]:
                    nbRow = len(ddict[textDict]["Values"])
                else:
                    nbRow = len(ddict[textDict])


        textRow = ""
        if "Index" in ddict:
            textRow+= "Index;"
        for textDict in ddict:
            if textDict not in ["Index","NumImage","Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:
                textRow += textDict + ";"
        if "NameImage" in ddict:
            textRow+= "NameImage;"
        textRow = textRow[:-1]
        csvWritter.writerow([textRow])

        if "Values" in ddict[textDict]:
            for i in range(nbRow):
                textRow = ""
                if "Index" in ddict:
                    textRow += str(ddict["Index"]["Values"][i])+";"
                for textDict in ddict:
                    if textDict not in ["Index", "NameImage","Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:
                        textRow += str(ddict[textDict]["Values"][i]) + ";"
                if "NameImage" in ddict:
                    textRow += str(ddict["NameImage"]["Values"][i])+";"
                csvWritter.writerow([textRow])
        else:
            for i in range(nbRow):
                textRow = ""
                if "Index" in ddict:
                    textRow += str(ddict["Index"][i])+";"
                for textDict in ddict:
                    if textDict not in ["Index", "NameImage","Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:
                        textRow += str(ddict[textDict][i]) + ";"
                if "NameImage" in ddict:
                    textRow += str(ddict["NameImage"][i])+";"
                csvWritter.writerow([textRow])

    except Exception as e:
        traceback.print_exc(file=sys.stderr)


def convertDictForSaveAnalysis(ddict):

    newDict = {}
    for ind in ddict:
        newDict[ddict[ind]["UserName"]] = {}
        newDict[ddict[ind]["UserName"]]["Values"] = []
        for val in ddict[ind]["Values"]:
            newDict[ddict[ind]["UserName"]]["Values"].append(val)
        newDict[ddict[ind]["UserName"]] ["Unit"]= ddict[ind]["Unit"]

    return newDict

def generateColorImage(im, ov, alpha):
    # The user can define the color of the n first labels (optional)
    # In the example, the first 3 labels are blue, green and red
    colorUser = {}
    colorUser[1] = [0, 0, 255]
    colorUser[2] = [0, 255, 0]
    colorUser[3] = [255, 0, 0]

    # Convert the input image if necessary
    im_UInt8 = im
    if (im.getBufferType() != PyIPSDK.eIBT_UInt8):
        range_UInt8 = PyIPSDK.createRange(0, 255)
        im_normalized = itrans.normalizeImg(im, range_UInt8)
        im_UInt8 = util.convertImg(im_normalized, PyIPSDK.eIBT_UInt8)

    # Create the ouput image geometry

    geometry = None
    bIs2d = im.getVolumeGeometryType() == PyIPSDK.eVGT_2d
    if bIs2d:
        geometry = PyIPSDK.geometryRgb2d(PyIPSDK.eIBT_UInt8, im.getSizeX(), im.getSizeY())
    else:
        geometry = PyIPSDK.geometryRgb3d(PyIPSDK.eIBT_UInt8, im.getSizeX(), im.getSizeY(), im.getSizeZ())

    # Create the output color image
    imColor = None
    if im.getColorGeometryType() == PyIPSDK.eCGT_Grey:
        imColor = PyIPSDK.createImage(geometry)

        if bIs2d:
            # Copy the channels
            for c in range(0, 3):
                plan = PyIPSDK.extractPlan(0, c, 0, imColor)
                util.copyImg(im_UInt8, plan)
        else:
            # Copy the channels
            for c in range(0, 3):
                plan = PyIPSDK.extractVolume(c, 0, imColor)
                util.copyImg(im_UInt8, plan)
    else:
        imColor = im_UInt8

    # Count the number of labels
    statsRes = None
    if bIs2d:
        statsRes = glbmsr.statsMsr2d(ov)
    else:
        statsRes = glbmsr.statsMsr3d(ov)
    nbLabels = statsRes.max

    # Create 3 random LUTs (one per channel)
    randValues = np.random.rand(3, int(nbLabels + 1)) * 255
    for i in colorUser:
        if i <= nbLabels:
            for c in range(3):
                randValues[c][i] = colorUser[i][c]

    lutR = PyIPSDK.createIntensityLUT(0, 1, randValues[0, :])
    lutG = PyIPSDK.createIntensityLUT(0, 1, randValues[1, :])
    lutB = PyIPSDK.createIntensityLUT(0, 1, randValues[2, :])
    colorLut = [lutR, lutG, lutB]

    # Convert the label image to a color image
    overlayImage = PyIPSDK.createImage(imColor.getGeometry())
    if bIs2d:
        for c in range(0, 3):
            plan = PyIPSDK.extractPlan(0, c, 0, overlayImage)
            itrans.lutTransform2dImg(ov, colorLut[c], plan)
    else:
        for c in range(0, 3):
            plan = PyIPSDK.extractVolume(c, 0, overlayImage)
            itrans.lutTransform3dImg(ov, colorLut[c], plan)

    # Blending
    blend = arithm.blendImgImg(imColor, overlayImage, alpha)
    blend = itrans.normalizeImg(blend, PyIPSDK.createRange(0, 255))
    blend = util.convertImg(blend, PyIPSDK.eIBT_UInt8)

    mask = bin.lightThresholdImg(ov, 1)

    maskImage = None
    binaryGeometry = None
    bIs2d = im.getVolumeGeometryType() == PyIPSDK.eVGT_2d
    if bIs2d:
        binaryGeometry = PyIPSDK.geometryRgb2d(PyIPSDK.eIBT_Binary, im.getSizeX(), im.getSizeY())
    else:
        binaryGeometry = PyIPSDK.geometryRgb3d(PyIPSDK.eIBT_Binary, im.getSizeX(), im.getSizeY(), im.getSizeZ())
    maskImage = PyIPSDK.createImage(binaryGeometry)

    if bIs2d:
        for c in range(0, 3):
            plan = PyIPSDK.extractPlan(0, c, 0, maskImage)
            util.copyImg(mask, plan)
    else:
        for c in range(0, 3):
            plan = PyIPSDK.extractVolume(c, 0, maskImage)
            util.copyImg(mask, plan)
    logic.maskImgImg(blend, imColor, maskImage, blend)

    overlayImage = logic.maskImg(overlayImage, maskImage)

    return blend,overlayImage

def convertBufferText(buffer):

    bufferText = str(buffer)
    if buffer == PyIPSDK.eIBT_UInt8:
        bufferText = "UInt8"
    elif buffer == PyIPSDK.eIBT_Int8:
        bufferText = "Int8"
    elif buffer == PyIPSDK.eIBT_UInt16:
        bufferText = "UInt16"
    elif buffer == PyIPSDK.eIBT_Int16:
        bufferText = "Int16"
    elif buffer == PyIPSDK.eIBT_UInt32:
        bufferText = "UInt32"
    elif buffer == PyIPSDK.eIBT_Int32:
        bufferText = "Int32"
    elif buffer == PyIPSDK.eIBT_Real32:
        bufferText = "Real32"
    elif buffer == PyIPSDK.eIBT_Binary:
        bufferText = "Binary"
    elif buffer == PyIPSDK.eIBT_Label8:
        bufferText = "Label8"
    elif buffer == PyIPSDK.eIBT_Label16:
        bufferText = "Label16"
    elif buffer == PyIPSDK.eIBT_Label32:
        bufferText = "Label32"

    return bufferText

def getImageFrequencies(image,valueMin,valueMax):

    try:
        if image.getBufferType() == PyIPSDK.eIBT_Real32:
            if valueMax != valueMin:
                binValue = (valueMax - valueMin) / 1000
            else:
                binValue = 1

            histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(valueMin, valueMax, binValue)
        else:
            histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(valueMin, valueMax, max(1, int((valueMax - valueMin) / 1000)))

        if image.getSizeZ() == 1:
            histogramMsr2dResult = glbmsr.histogramMsr2d(image, histogramMsrParams)
        else:
            histogramMsr2dResult = glbmsr.histogramMsr3d(image, histogramMsrParams)
        frequencies = histogramMsr2dResult.frequencies
    except:
        frequencies = None

    return frequencies

def getHistogramMinValue(histogram):

    minValue = None
    z=0
    c=0
    while (z, c, 0) in histogram:
        while (z,c,0) in histogram:
            if minValue is None:
                minValue = histogram[(z,c,0)]["Min"]
            else:
                minValue = min(minValue,histogram[(z,c,0)]["Min"])
            z+=1
        z=0
        c+=1

    return minValue


def getHistogramMaxValue(histogram):
    maxValue = None
    z = 0
    c = 0
    while (z, c, 0) in histogram:
        while (z, c, 0) in histogram:
            if maxValue is None:
                maxValue = histogram[(z, c, 0)]["Max"]
            else:
                maxValue = max(maxValue, histogram[(z, c, 0)]["Max"])
            z += 1
        z = 0
        c += 1

    return maxValue

def getHistogramBinValue(histogram):
    binValue = None
    z = 0
    c = 0
    while (z, c, 0) in histogram:
        while (z, c, 0) in histogram:
            if binValue is None:
                binValue = histogram[(z, c, 0)]["BinWidth"]
            else:
                binValue = max(binValue, histogram[(z, c, 0)]["BinWidth"])
            z += 1
        z = 0
        c += 1

    return binValue

def convertTextToCsv(text):

    newText = ""
    maskCharacters = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
                      "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
                      "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_",";","(",")",".",","]

    for ch in text:
        if ch in maskCharacters:
            newText+=ch
        else:
            if ch == "²":
                newText+="^2"
            if ch ==  "³":
                newText+= "^3"

    return newText

def convertTextToXls(text):
    newText = ""

    for ch in text:
        if ch not in ["▼","▲"]:
            newText+=ch

    return newText

def saveMeasureXls(filename,measure):

    dictResult = {}

    if dictCustomObject[measure.subType]["Object"] in ["ListPixels","ListPixelsPath"]:

        dictAllPixels = PyIPSDK.toPyDict(measure.value)

        dictResult["Index"] = {}
        dictResult["Index"]["Values"] = []
        dictResult["X Coordinate"] = {}
        dictResult["X Coordinate"]["Values"] = []
        dictResult["Y Coordinate"] = {}
        dictResult["Y Coordinate"]["Values"] = []
        if (0, 0, 0) not in dictAllPixels:
            dictPixels = dictAllPixels["Coll"]
            for i in range(len(dictPixels)):
                dictResult["Index"]["Values"].append(str(i + 1))
                dictResult["X Coordinate"]["Values"].append(str(int(dictPixels[i]["X"])))
                dictResult["Y Coordinate"]["Values"].append(str(int(dictPixels[i]["Y"])))
        else:
            if (1, 0, 0) in dictAllPixels:
                dictResult["Z Coordinate"] = {}
                dictResult["Z Coordinate"]["Values"] = []
            z = 0
            nbRow = 0
            while (z, 0, 0) in dictAllPixels:
                dictPixels = dictAllPixels[(z, 0, 0)]["Coll"]
                nbRow += len(dictPixels)
                z += 1
            z = 0
            rowIndex = 0
            while (z, 0, 0) in dictAllPixels:
                dictPixels = dictAllPixels[(z, 0, 0)]["Coll"]
                for i in range(len(dictPixels)):
                    dictResult["Index"]["Values"].append(str(rowIndex + 1))
                    dictResult["X Coordinate"]["Values"].append( str(int(dictPixels[i]["X"])))
                    dictResult["Y Coordinate"]["Values"].append( str(int(dictPixels[i]["Y"])))
                    if (1, 0, 0) in dictAllPixels:
                        dictResult["Z Coordinate"]["Values"].append(str(z))
                    rowIndex += 1
                z += 1

    elif dictCustomObject[measure.subType]["Object"] in ["ListVoxels","ListVoxelsPath"]:

        dictAllPixels = PyIPSDK.toPyDict(measure.value)
        if (0, 0, 0) in dictAllPixels:
            dictPixels = dictAllPixels[(0, 0, 0)]["Coll"]
        else:
            dictPixels = dictAllPixels["Coll"]

        dictResult["Index"] = {}
        dictResult["Index"]["Values"] = []
        dictResult["X Coordinate"] = {}
        dictResult["X Coordinate"]["Values"] = []
        dictResult["Y Coordinate"] = {}
        dictResult["Y Coordinate"]["Values"] = []
        dictResult["Z Coordinate"] = {}
        dictResult["Z Coordinate"]["Values"] = []
        for i in range(len(dictPixels)):
            dictResult["Index"]["Values"].append(str(i + 1))
            dictResult["X Coordinate"]["Values"].append(str(int(dictPixels[i]["X"])))
            dictResult["Y Coordinate"]["Values"].append(str(int(dictPixels[i]["Y"])))
            dictResult["Z Coordinate"]["Values"].append(str(int(dictPixels[i]["Z"])))


    elif dictCustomObject[measure.subType]["Object"] == "Scalar":

        dictResult["Scalar"] = {}
        dictResult["Scalar"]["Values"] = []
        dictResult["Scalar"]["Values"].append(str(measure.value))

    elif dictCustomObject[measure.subType]["Object"] == "Projection":

        dictAllValues = PyIPSDK.toPyDict(measure.value)

        dictValues = dictAllValues["Coll"]

        # dictResult["Index"] = {}
        # dictResult["Index"]["Values"] = []

        if measure.subType == 'XProjection':
            projectionAxis = 'X'
        else:
            projectionAxis = 'Y'

        if measure.projectionType == PyIPSDK.eProjStatType.ePST_Max:
            projectionType = "Max"
        elif measure.projectionType == PyIPSDK.eProjStatType.ePST_Mean:
            projectionType = "Mean"
        elif measure.projectionType == PyIPSDK.eProjStatType.ePST_Median:
            projectionType = "Median"
        elif measure.projectionType == PyIPSDK.eProjStatType.ePST_Min:
            projectionType = "Min"
        elif measure.projectionType == PyIPSDK.eProjStatType.ePST_StdDev:
            projectionType = "StdDev"
        elif measure.projectionType == PyIPSDK.eProjStatType.ePST_Sum:
            projectionType = "Sum"
        else:
            projectionType = "Variance"

        dictResult[projectionAxis] = {}
        dictResult[projectionAxis]["Values"] = []
        dictResult[projectionType] = {}
        dictResult[projectionType]["Values"] = []

        for i in range(len(dictValues)):
            dictResult[projectionAxis]["Values"].append(str(i))
            dictResult[projectionType]["Values"].append(str(dictValues[i]))


    elif dictCustomObject[measure.subType]["Object"] in ["AreaPercent", "VolumePercent"]:

        dictAllValues = PyIPSDK.toPyDict(measure.value)
        dictValues = dictAllValues["Coll"]


        dictResult["Index"] = {}
        dictResult["Index"]["Values"] = []


        dictResult["Area percent"] = {}
        dictResult["Area percent"]["Values"] = []


        for i in range(len(dictValues)):
            dictResult["Index"]["Values"].append(str(i))
            dictResult["Area percent"]["Values"].append(str(dictValues[i]))

    else:
        ddict = measure.value
        if isinstance(ddict, list):

            for textDict in ddict[0]:
                dictResult[textDict] = {}
                dictResult[textDict]["Values"] = []

            for i in range(1, len(ddict)):
                j=0
                for textDict in ddict[0]:
                    dictResult[textDict]["Values"].append(ddict[i][j])
                    j=j+1

        else:
            for textDict in ddict:
                dictResult[textDict] = {}
                dictResult[textDict]["Values"] = []
                dictValues = ddict[textDict]

                if isinstance(ddict, (frozenset, list, set, tuple)):
                    dictResult[textDict]["Values"] = dictValues
                else:
                    dictResult[textDict]["Values"] = [dictValues]

    try:
        file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
        settingsElement = file.getroot()
        mergeAnalysisFormatElement = Dfct.SubElement(settingsElement, "MergeAnalysisFormat")
        mergeAnalysisFormat = mergeAnalysisFormatElement.text
    except:
        mergeAnalysisFormat = "csv"

    if mergeAnalysisFormat == "" or mergeAnalysisFormat is None:
        mergeAnalysisFormat = "csv"

    if mergeAnalysisFormat == "csv":
        dictToCsvFile(dictResult,changeExtension(filename,".csv"))
    elif mergeAnalysisFormat == "xls":
        dictToXlsFile(dictResult,changeExtension(filename,".xls"))

def saveDictToFile(dictResult, filename):

    try:
        file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
        settingsElement = file.getroot()
        mergeAnalysisFormatElement = Dfct.SubElement(settingsElement, "MergeAnalysisFormat")
        mergeAnalysisFormat = mergeAnalysisFormatElement.text
    except:
        mergeAnalysisFormat = "csv"

    if mergeAnalysisFormat == "" or mergeAnalysisFormat is None:
        mergeAnalysisFormat = "csv"

    if mergeAnalysisFormat == "csv":
        dictToCsvFile(dictResult,changeExtension(filename,".csv"))
    elif mergeAnalysisFormat == "xls":
        dictToXlsFile(dictResult,changeExtension(filename,".xls"))


def saveListMeasureXls(filenameToSave,listMeasure,listFilenameFolder,title="Infoset_Merge"):
    '''A function to merge batch results and save to xls format.
       Attributes:
       listMeasure : A list of dictionnaries to convert to xls,
       listFilenameFolder : A list of the batch filenames,
       filenameToSave : The path of the merge file.
    '''

    listFilenames = [file for file in listFilenameFolder if "." in file]  #remove the folder Result from the list if exist and files/folder with no extension

    # get settings decimal separator infos
    changePoint = False
    try:
        file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
        settingsElement = file.getroot()
        decimalSeparatorElement = Dfct.SubElement(settingsElement, "DecimalSeparator")
        if decimalSeparatorElement.text == ",":
            changePoint = True
    except:
        pass

    try:
        if filenameToSave.endswith(".xls") == False:
            filenameToSave += ".xls"

        book = xlwt.Workbook(encoding="utf-8")
        sheet1 = book.add_sheet(title, cell_overwrite_ok=True)

        column = 0
        sheet1.write(0, 0, "Image")

        # write the title names of each column in the sheet
        for textDict in listMeasure[0]:
            column+=1
            sheet1.write(0, column, str(textDict))

        currentRow = 0
        # for each dict in listMeasure
        for i in range(len(listMeasure)):

            ddict = listMeasure[i]

            column = 1
            # for each key in dict
            for textDict in ddict:
                rows=currentRow
                for j in range(len(ddict[textDict])):
                    text = str(ddict[textDict][j])
                    if changePoint:
                        text = text.replace(".", ",")
                    sheet1.write(rows+1, 0, str(listFilenames[i]))  # write num of image
                    # converts the str to float or int if possible
                    if isInt(text):
                        text = int(text)
                    elif isFloat(text):
                        text = float(text)
                    sheet1.write(rows+1, column, text)
                    rows+=1
                column += 1
            currentRow = rows

        book.save(filenameToSave)

    except Exception as e:
        traceback.print_exc(file=sys.stderr)
        print(e)


def isInt(text):
    """A function that tests if a text is an integer.
       Used for saving xls files and avoid str inside xls files"""
    return text.lstrip("+-").isdigit()

def isFloat(text):
    """A function that tests if a text is a float.
       Used for saving xls files and avoid str inside xls files"""
    text = text.replace(",", ".")
    text = text.lstrip("+-")
    if '.' in text:
        left, right = text.split('.', 1)
        return (left.isdigit() or left == '') and (right.isdigit() or right == '')
    return False

def lineEditValue(lineEdit):

    if lineEdit.text() != "":
        return lineEdit.text()
    else:
        return lineEdit.placeholderText()

def setLineEditValue(lineEdit,text):

    if text is not None:
        lineEdit.setText(text)

def displayCamera():

    while vrb.updateCamera:
        stopDisplay = True
        for widget in vrb.widgetCamera:
            if widget.isVisible() and not widget.groupBoxSettings.pushButtonLecure.activate:
                stopDisplay = False
        if stopDisplay:
            break
        displayCameraImage()
        if not vrb.updateCamera:
            vrb.updateCamera = True
        else:
            break


def displayCameraImage():

    with Vimba.get_instance() as vimba:
        cams = vimba.get_all_cameras()

        if vrb.nbCameras == 1:

            with cams[0] as cam0:

                if vrb.widgetCamera[0].isVisible():
                    try:
                        vrb.widgetCamera[0].verifyCameraSettings(cam0)
                    except Exception as e:
                        messageBox = MessageBox(str(e), '', buttons=[qt.QMessageBox.Ok], icon=qt.QMessageBox.Warning, windowTitle="Error camera settings")
                        messageBox.exec()
                        traceback.print_exc(file=sys.stderr)
                        vrb.widgetCamera[0].groupBoxSettings.pushButtonLecure.setActivation(True)
                    try:
                        cam0.start_streaming(vrb.widgetCamera[0].frame_handler)
                    except:
                        pass

                while vrb.updateCamera:

                    stopDisplay = True
                    if not vrb.widgetCamera[0].isVisible():
                        try:
                            cam0.stop_streaming()
                        except:
                            pass
                    else:
                        stopDisplay = False
                    if stopDisplay:
                        break

                    stopDisplay = True
                    if not vrb.widgetCamera[0].groupBoxSettings.pushButtonLecure.activate:
                        vrb.widgetCamera[0].createCameraImage(cam0)
                        stopDisplay = False
                    if stopDisplay:
                        break

        elif vrb.nbCameras == 2:

            with cams[0] as cam0:
                with cams[1] as cam1:

                    if vrb.widgetCamera[0].isVisible():
                        try:
                            vrb.widgetCamera[0].verifyCameraSettings(cam0)
                        except:
                            traceback.print_exc(file=sys.stderr)
                            vrb.widgetCamera[0].groupBoxSettings.pushButtonLecure.setActivation(True)
                        try:
                            cam0.start_streaming(vrb.widgetCamera[0].frame_handler)
                        except:
                            pass
                    if vrb.widgetCamera[1].isVisible():
                        try:
                            vrb.widgetCamera[1].verifyCameraSettings(cam1)
                        except:
                            traceback.print_exc(file=sys.stderr)
                            vrb.widgetCamera[1].groupBoxSettings.pushButtonLecure.setActivation(True)
                        try:
                            cam1.start_streaming(vrb.widgetCamera[1].frame_handler)
                        except:
                            pass

                    while vrb.updateCamera:

                        stopDisplay = True
                        if not vrb.widgetCamera[0].isVisible():
                            try:
                                cam0.stop_streaming()
                            except:
                                pass
                        else:
                            stopDisplay = False
                        if not vrb.widgetCamera[1].isVisible():
                            try:
                                cam1.stop_streaming()
                            except:
                                pass
                        else:
                            stopDisplay = False
                        if stopDisplay:
                            break

                        stopDisplay = True
                        if not vrb.widgetCamera[0].groupBoxSettings.pushButtonLecure.activate:
                            vrb.widgetCamera[0].createCameraImage(cam0)
                            stopDisplay = False
                        if not vrb.widgetCamera[1].groupBoxSettings.pushButtonLecure.activate:
                            vrb.widgetCamera[1].createCameraImage(cam1)
                            stopDisplay = False
                        if stopDisplay:
                            break

def extractZPlan(image,widgetImage):

    if image.getSizeC() != 1:
        colorGeometryType = image.getColorGeometryType()
        colorGeometry = PyIPSDK.ColorGeometry()
        if colorGeometryType == PyIPSDK.eCGT_User:
            colorGeometry.initUser(image.getSizeC())
        else:
            colorGeometry.init(colorGeometryType)
        volumeGeometry = PyIPSDK.VolumeGeometry()
        volumeGeometry.init2d()
        temporalGeometry = PyIPSDK.TemporalGeometry()
        temporalGeometry.initSingle()

    if image.getSizeT() > 1:
        valueSequence = widgetImage.imageViewerStandAlone.sliderAxis.sliderSequence.slider.value()
        if image.getSizeZ() == 1:
            if image.getSizeC() == 1:
                imageProcess = PyIPSDK.extractPlan(0, 0, valueSequence, image)
            else:
                imageProcess = PyIPSDK.extractColor(0, valueSequence, image)
        else:
            if image.getSizeC() == 1:
                imageProcess = PyIPSDK.extractVolume(0, valueSequence, image)
            else:
                imageProcess = PyIPSDK.extractColorVolume(valueSequence, image)
        image = util.copyImg(imageProcess)

    if widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
        if image.getSizeC() == 1:
            planArray = np.ascontiguousarray(image.array[:, :, widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeY(), image.getSizeZ())
        else:
            planArray = np.ascontiguousarray(image.array[:, :, :, widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeY(), image.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)
    if widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
        if image.getSizeC() == 1:
            planArray = np.ascontiguousarray(image.array[:, widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(), :])
            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeX(), image.getSizeZ())
        else:
            planArray = np.ascontiguousarray(image.array[:, :, widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(), :])
            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeX(), image.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)
    if widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
        if image.getSizeC() == 1:
            planArray = np.ascontiguousarray(image.array[widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), :, :])
            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeX(), image.getSizeY())
        else:
            planArray = np.ascontiguousarray(image.array[:, widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), :, :])
            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeX(), image.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)

    outImage = PyIPSDK.fromArray(planArray, geometry)
    outImage = util.copyImg(outImage)

    return outImage

def zoomDiskAndNormalImage(image,factorX,factorY,interp=PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour):

    if image.isDiskImage():

        strideX = max(1,int(1/factorX))
        strideY = max(1,int(1/factorY))

        newFactorX = 1/strideX
        newFactorY = 1/strideY

        sizeX = image.getSizeX()
        sizeY = image.getSizeY()

        #outImage = image.loadPlan(0, 0, 0, int(sizeX*newFactorX), int(sizeY*newFactorY), 0, 0,strideX, strideY)
        outImage = loadPlanImageDisk(image,int(sizeX*newFactorX), int(sizeY*newFactorY), 0, 0,strideX, strideY)
    else:
        outImage = gtrans.zoom2dImg(image, factorX, factorY, interp)

    return outImage

# def loadPlanImageDiskGrey(image,sizeX,sizeY,offsetX,offsetY,strideX,strideY,cValue = 0, zValue = 0, tValue = 0):
#
#     if cValue is None:
#         cValue = 0
#     imageLine = image.loadPlan(zValue, cValue, tValue, image.getSizeX(),sizeY,0,offsetY,1,strideY)
#     cropImage = util.getROI2dImg(imageLine,offsetX,0,sizeX*strideX,sizeY)
#     outImage = gtrans.zoom2dImg(cropImage,1/strideX,1,PyIPSDK.eZoomInterpolationMethod.eZIM_Linear)
#
#     return outImage
#
#
# def loadPlanImageDisk(image,sizeX,sizeY,offsetX,offsetY,strideX,strideY, zValue = 0,cValue = None, tValue = 0):
#
#     if image.getSizeC() == 1 or cValue is not None:
#         if cValue is None:
#             cValue = 0
#         outImage = loadPlanImageDiskGrey(image,sizeX,sizeY,offsetX,offsetY,strideX,strideY, zValue = zValue, cValue=cValue, tValue = tValue)
#         # outImage = image.loadPlan(zValue, cValue, tValue, sizeX,sizeY,offsetX,offsetY, 1, 1)
#     else:
#         colorGeometryType = image.getColorGeometryType()
#         colorGeometry = PyIPSDK.ColorGeometry()
#         if colorGeometryType == PyIPSDK.eCGT_User:
#             colorGeometry.initUser(image.getSizeC())
#         else:
#             colorGeometry.init(colorGeometryType)
#         volumeGeometry = PyIPSDK.VolumeGeometry()
#         volumeGeometry.init2d()
#         temporalGeometry = PyIPSDK.TemporalGeometry()
#         temporalGeometry.initSingle()
#         geometry = PyIPSDK.geometry(image.getBufferType(), sizeX, sizeY, volumeGeometry, colorGeometry, temporalGeometry)
#         outImage = PyIPSDK.createImage(geometry)
#         for c in range(image.getSizeC()):
#             plan = loadPlanImageDiskGrey(image, sizeX, sizeY, offsetX, offsetY, strideX, strideY, zValue = zValue, cValue=c, tValue = tValue)
#             # plan = image.loadPlan(0, c, 0, sizeX, sizeY, offsetX, offsetY, 1, 1)
#             outPlan = PyIPSDK.extractPlan(0,c,0,outImage)
#             util.copyImg(plan,outPlan)
#
#     return outImage

def loadPlanImageDisk(image,sizeX,sizeY,offsetX,offsetY,strideX,strideY, zValue = 0,cValue = None, tValue = 0):

    if image.getSizeZ() == 1:
        zValue = 0
    if image.getSizeT() == 1:
        tValue = 0

    if image.getSizeC() == 1 or cValue is not None:
        if cValue is None:
            cValue = 0
        imageLine = image.loadPlan(zValue, cValue, tValue, image.getSizeX(),sizeY,0,offsetY,1,strideY)
    else:
        imageLine = image.loadColorPlan(zValue, tValue, image.getSizeX(),sizeY,0,offsetY,1,strideY)

    cropImage = util.getROI2dImg(imageLine,offsetX,0,sizeX*strideX,sizeY)
    outImage = gtrans.zoom2dImg(cropImage,1/strideX,1,PyIPSDK.eZoomInterpolationMethod.eZIM_Linear)

    return outImage


def getPixelValue(image,posX,posY,cValue=None):

    if image.isDiskImage():

        if cValue is None:
            cValue = 0
        pixelValue = image.readPixel(posX,posY,0,cValue,0)
        if image.getBufferType() != PyIPSDK.eIBT_Real32:
            pixelValue = int(pixelValue)

    else:
        if cValue is None:
            pixelValue = image.array[posY][posX]
        else:
            pixelValue = image.array[cValue][posY][posX]

    return pixelValue

def convertToMemoryImage(image):

    outImage = PyIPSDK.createImage(image)
    util.copyImg(image,outImage)

    return outImage

def writeElement(element,text = ""):

    if type(element) == type({}):
        text += writeDict(element,text)
    elif type(element) == type([]):
        text += writeVector(element,text)
    elif type(element) == type(()):
        text += writeTuple(element, text)
    elif type(element) == numpy.ndarray:
        text += writeVector(element, text)
    elif type(element) == vrb.EulerAngles:
        text += writeElement(element.angles, text)
    else:
        text += writeValue(element,text)

    return text

def writeDict(element,text):

    text += "{"
    for tag in element:
        text += writeElement(tag)
        text += ":"
        text += writeElement(element[tag])
        text += ";"
    text = text[:-1]
    text += "}"

    return text

def writeVector(element, text):

    text += "["
    for value in element:
        text += writeElement(value)
        text += ","
    text = text[:-1]
    text += "]"

    return text

def writeTuple(element, text):

    listElement = list(element)
    textVector = writeVector(listElement,text)
    text += "<" + textVector + ">"

    return text


def writeValue(element,text):

    if type(element) == type('a'):
        text += "(S|" + str(element) + ")"
    elif type(element) == type(1):
        text += "(I|" + str(element) + ")"
    elif type(element) == type(0.1):
        text += "(F|" + str(element) + ")"
    elif type(element) == numpy.float64:
        text += "(F|" + str(element) + ")"
    elif type(element) == type(None):
        text += "(N|None)"
    elif type(element) == type(True):
        text += "(B|"+str(element)+")"
    else:
        try:
            element = float(element)
            text += "(F|" + str(element) + ")"
        except:
            print("Error element",type(element),element)
            text += "(N|None)"
        # text += "(F|" + str(element) + ")"

    return text

def readElement(text):

    if text != "":
        if text[0] == "{":
            element = readDict(text[1:-1])
        elif text[0] == "[":
            element = readVector(text[1:-1])
        elif text[0] == "<":
            element = readTuple(text[1:-1])
        else:
            element = readValue(text[1:-1])
    else:
        element = {}

    return element

def readDict(text):

    element = {}
    textSplit = []
    iter = 0

    currentText = ""
    currentVector = []
    nbCh = 0
    for ch in text:
        nbCh += 1
        if nbCh == len(text):
            currentText += ch
            currentVector.append(currentText)
            textSplit.append(currentVector)
        elif ch == ":" and iter == 0:
            currentVector.append(currentText)
            currentText = ""
        elif ch == ";" and iter == 0:
            currentVector.append(currentText)
            textSplit.append(currentVector)
            currentText = ""
            currentVector = []
        else:
            currentText += ch
            if ch == "{":
                iter += 1
            if ch == "}":
                iter -= 1

    for textElement in textSplit:
        element[readElement(textElement[0])] = readElement(textElement[1])

    return element

def readVector(text):

    element = []
    textSplit = []
    iter = 0

    currentText = ""
    nbCh = 0
    for ch in text:
        nbCh += 1
        if nbCh == len(text):
            currentText += ch
            textSplit.append(currentText)
        elif ch == "," and iter == 0:
            textSplit.append(currentText)
            currentText = ""
        else:
            currentText += ch
            if ch == "[":
                iter += 1
            if ch == "]":
                iter -= 1

    for textElement in textSplit:
        element.append(readElement(textElement))

    return element

def readTuple(text):

    elementList = readVector(text[1:-1])
    element = tuple(elementList)

    return element

def readValue(text):

    if text[0] == "S":
        element = text[2:]
    elif text[0] == "I":
        element = int(text[2:])
    elif text[0] == "F":
        element = float(text[2:])
    elif text[0] == "N":
        element = None
    elif text[0] == "B":
        if text[2:] == "True":
            element = True
        else:
            element = False

    return element

def blendValues(val1,val2,ratio):

    if type(val1) == type({}):
        output = {}
        for tag in val1:
            if tag in val2:
                output[tag] = blendValues(val1[tag],val2[tag],ratio)
            else:
                output[tag] = blendValues(val1[tag],val1[tag],ratio)
        for tag in val2:
            if tag not in val1:
                output[tag] = blendValues(val2[tag], val2[tag], ratio)

    elif type(val1) == type(()):
        output = ()
        for i in range(len(val1)):
            # output.append(blendValues(val1[i],val2[i],ratio))
            output += (blendValues(val1[i],val2[i],ratio),)
    elif type(val1) == type([]):
        output = []
        for i in range(len(val1)):
            output.append(blendValues(val1[i],val2[i],ratio))
    elif type(val1) in [type(""),type(True)] :
        if ratio <1:
            output = val1
        else:
            output = val2
    elif type(val1) == vrb.EulerAngles:
        output = vrb.EulerAngles()
        # output.angles = (blendAngles(val1.angles[0],val2.angles[0],ratio,180),blendAngles(val1.angles[1],val2.angles[1],ratio,180),blendAngles(val1.angles[2],val2.angles[2],ratio,180))
        output.angles = blendEulerAngles(val1, val2, ratio)
        # print(output.angles)
    elif val1 is None:
        output = None
    else:
        try:
            output = val1*(1-ratio)+val2*ratio
        except:
            output = None
            traceback.print_exc(file=sys.stderr)


    return output

def blendEulerAngles(val1,val2,ratio):

    if val2.direction[0] is not None:
        angleX = val1.angles[0] + ratio*val2.direction[0]
        angleY = val1.angles[1]
        angleZ = val1.angles[2]
    elif val2.direction[1] is not None:
        angleX = val1.angles[0]
        angleY = val1.angles[1] + ratio * val2.direction[1]
        angleZ = val1.angles[2]
    elif val2.direction[2] is not None:
        angleX = val1.angles[0]
        angleY = val1.angles[1]
        angleZ = val1.angles[2] + ratio * val2.direction[2]
    else:
        angleX = blendAngles(val1.angles[0], val2.angles[0], ratio, 180)
        angleY = blendAngles(val1.angles[1], val2.angles[1], ratio, 180)
        angleZ = blendAngles(val1.angles[2], val2.angles[2], ratio, 180)

    return (angleX,angleY,angleZ)

def blendAngles(angle1,angle2,ratio,range):

    diff = abs(angle1-angle2)
    if abs(angle1-angle2-2*range)<diff:
        angle2 += 2*range
    if abs(angle1-angle2+2*range)<diff:
        angle2 -= 2*range

    angle = angle1*(1-ratio)+angle2*ratio
    if angle < -range:
        angle += 2*range
    if angle > range:
        angle -= 2*range

    return angle

def createDefaultExperimentalClippingPlanes(label):

    if label is not None and label.layer is not None:
        if label.objectType == "Image":
            startX = 0
            startY = 0
            startZ = 0
            endX = label.image.getSizeX() - 1
            endY = label.image.getSizeY() - 1
            endZ = label.image.getSizeZ() - 1
        elif label.objectType == "Mesh":
            startX = int(label.startValues[2]) - 1
            startY = int(label.startValues[1]) - 1
            startZ = int(label.startValues[0]) - 1
            endX = round(label.endValues[2])
            endY = round(label.endValues[1])
            endZ = round(label.endValues[0])

        if label.objectType == "Image":
            calibration = label.image.getGeometricCalibration()
            originX = calibration.getXOrigin()
            originY = calibration.getYOrigin()
            originZ = calibration.getZOrigin()
        else:
            calibration = label.mesh.calibration
            originX = calibration.getXOrigin()
            originY = calibration.getYOrigin()
            originZ = calibration.getZOrigin()


        planeX_start = {
            'position': (startX+originX, startX+originX, startX+originX),
            'normal': (0, 0, 1),
            'enabled': True
        }
        planeX_end = {
            'position': (endX+originX, endX+originX, endX+originX),
            'normal': (0, 0, -1),
            'enabled': True
        }
        planeY_start = {
            'position': (startY+originY, startY+originY, startY+originY),
            'normal': (0, 1, 0),
            'enabled': True
        }
        planeY_end = {
            'position': (endY+originY, endY+originY, endY+originY),
            'normal': (0, -1, 0),
            'enabled': True
        }
        planeZ_start = {
            'position': (startZ+originZ, startZ+originZ, startZ+originZ),
            'normal': (1, 0, 0),
            'enabled': True
        }
        planeZ_end = {
            'position': (endZ+originZ, endZ+originZ, endZ+originZ),
            'normal': (-1, 0, 0),
            'enabled': True
        }

        clippingPlanes = [planeX_start, planeX_end, planeY_start, planeY_end, planeZ_start,planeZ_end]

    else:

        clippingPlanes = []

    return clippingPlanes

def compareColorMapNapari(arr1,arr2):

    try:
        allCompare = True
        arr1 = arr1.colors
        arr2 = arr2.colors
        if len(arr1) != len(arr2):
            allCompare = False
            return allCompare
        for i in range(len(arr1)):
            for j in range(4):
                if arr1[i][j] != arr2[i][j]:
                    allCompare = False
    except:
        allCompare = False
        print("except lut")
        traceback.print_exc(file=sys.stderr)

    return allCompare

def compareExperimentalClippingPlanes(arr1,arr2):

    if len(arr1) == 0:
        allCompare = False
    else:
        allCompare = True
        for i in range(len(arr1)):
            if (arr1[i].position[0] != arr2[i]["position"][0] or arr1[i].position[1] != arr2[i]["position"][1] or arr1[i].position[2] != arr2[i]["position"][2] or
                    arr1[i].normal[0] != arr2[i]["normal"][0] or arr1[i].normal[0] != arr2[i]["normal"][0] or arr1[i].normal[0] != arr2[i]["normal"][0] or
                    arr1[i].enabled != arr2[i]["enabled"]):
                allCompare = False

    return allCompare


def createSurfaceForNapari(shapes,ratio = 0.9, minFaces = 1000):

    vrb.mainWindow.groupBoxProcessing.setText('creating surface from mesh...\nPlease wait.')
    vrb.mainWindow.toggleGroupBoxProcessing(True)
    vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(False)
    vrb.mainWindow.groupBoxProcessing.progressBar.setVisible(False)

    nbFaces = 0

    if type(shapes) == WidgetTypes.IPSDKType.MESH.value:
        if ratio != 0:
            mesh_s = PyIPSDK.simplify(shapes, ratio, minFaces, False)
            allVertex, allFaces, allValues = PyIPSDK.createStLMeshArrays(mesh_s)
        else:
            allVertex, allFaces, allValues = PyIPSDK.createStLMeshArrays(shapes)
            nbFaces = len(allFaces)
    else:
        coll = shapes.getColl()
        allVertex = None
        allFaces = None
        allValues = None
        nbFaces = 0

        if ratio != 0:
            listMesh = PyIPSDK.simplify(shapes, ratio, minFaces, False)
            for i in range(len(listMesh)):
                vertices, faces, values = PyIPSDK.createMeshArrays(listMesh[i], i+1)
                if allVertex is None:
                    allVertex = vertices
                    allFaces = faces
                    allValues = values
                else:
                    offset = len(allVertex)
                    offsetArray = np.array([offset, offset, offset])
                    faces = np.add(faces,offsetArray)

                    allVertex = np.concatenate((allVertex,vertices))
                    allFaces = np.concatenate((allFaces,faces))
                    allValues = np.concatenate((allValues,values))

        else:
            for i in range(1, len(coll)):
                if shapes.getColl()[i] is not None:

                    vertices, faces, values = PyIPSDK.createShapeArrays(shapes.getColl()[i], i)

                    currentNbFaces = len(faces)
                    nbFaces += currentNbFaces

                    if allVertex is None:
                        allVertex = vertices
                        allFaces = faces
                        allValues = values
                    else:
                        offset = len(allVertex)
                        offsetArray = np.array([offset, offset, offset])
                        faces = np.add(faces,offsetArray)

                        allVertex = np.concatenate((allVertex,vertices))
                        allFaces = np.concatenate((allFaces,faces))
                        allValues = np.concatenate((allValues,values))

    vrb.mainWindow.toggleGroupBoxProcessing(False)

    return allVertex,allFaces,allValues,nbFaces

def calibrationIncrustationImg(inImg, calibrationScale, calibrationUnit, pos,
                               sizePercentage, textPos, textWidth,
                               textColor, backgroundColor, bBackgroundEnabled):


    if inImg.getBufferType() not in [PyIPSDK.eImageBufferType.eIBT_Label8,
                                     PyIPSDK.eImageBufferType.eIBT_Label16,
                                     PyIPSDK.eImageBufferType.eIBT_Label32]:
        img = util.copyImg(inImg)
    else:
        img = imageLabelToColor(inImg)


    # convert ipsdk image to pillow image
    if img.getColorGeometryType() == PyIPSDK.eCGT_Grey:
        pilGreyImg = Image.fromarray(img.array)
        pilRgbImg = Image.new("RGBA", pilGreyImg.size)
        pilRgbImg.paste(pilGreyImg)
    else:  # if rgb image
        array = cv2.merge([img.array[0], img.array[1], img.array[2]])
        pilImg = Image.fromarray(array)
        pilRgbImg = Image.new("RGBA", pilImg.size)
        pilRgbImg.paste(pilImg)

    valueCalibration = calibrationScale
    sizeX = inImg.getSizeX()
    sizeY = inImg.getSizeY()
    ratioX = sizeX / 1000
    ratioY = sizeY / 1000

    # length of the line depending on the size percentage given
    length = sizeX / 2 * int(sizePercentage) / 100  # pixel length
    umLength = length * valueCalibration  # micrometers length

    # approximated length
    exposant = int(np.log(umLength) / np.log(10))
    a = umLength / pow(10, exposant)
    b = round(a)
    umLength = b * pow(10, exposant)
    length = umLength * (1 / valueCalibration)

    # init of variables
    objectSpacing = 15 * ratioX
    rectangleSpacingX = 3 * ratioX
    rectangleSpacingY = 3 * ratioY
    textColor = (
    int(vrb.calibrationTextColor[0]), int(vrb.calibrationTextColor[1]), int(vrb.calibrationTextColor[2]), 255)
    backgroundColor = (int(vrb.calibrationBackgroundColor[0]), int(vrb.calibrationBackgroundColor[1]),
                       int(vrb.calibrationBackgroundColor[2]), 255)
    width = 1
    startY = 0

    # compute rectangle height according to the width of text chosen in combobox
    # Width = Large
    if (textWidth == "Large"):
        rectangleHeight = sizeY * 10 / 100
        width = int(width + sizeX * 0.3 / 100)
    # Width = Medium
    elif (textWidth == "Medium"):
        rectangleHeight = sizeY * 8 / 100
        width = int(width + sizeX * 0.2 / 100)
    # Width = Small
    else:
        rectangleHeight = sizeY * 6 / 100
        width = int(width + sizeX * 0.15 / 100)

    # create text calibration to draw
    text = str(int(length * valueCalibration)) + " " + calibrationUnit

    # get text length
    draw = ImageDraw.Draw(pilRgbImg)
    font = ImageFont.truetype(vrb.folderFonts + "/arial.ttf",int(rectangleHeight/2))
    textLength = draw.textlength(text, font=font)

    # compute rectangle length depending on objects inside the rectangle
    if (textPos == "Up" or textPos == "Bottom"):
        rectangleLength = objectSpacing + length + objectSpacing
    else:
        rectangleLength = objectSpacing + textLength + objectSpacing + length + objectSpacing

    # computes coordinates of the calibration box depending on the position
    #TOP LEFT
    if(pos == "Top left"):
        startRectangleX = rectangleSpacingX
        startRectangleY = rectangleSpacingY
        endRectangleX = rectangleLength
        endRectangleY = rectangleSpacingY + rectangleHeight
    #TOP RIGHT
    elif(pos == "Top right"):
        startRectangleX=sizeX-rectangleLength-rectangleSpacingX
        startRectangleY=rectangleSpacingY
        endRectangleX = sizeX-rectangleSpacingX
        endRectangleY=rectangleSpacingY+rectangleHeight
    #BOTTOM LEFT
    elif(pos == "Bottom left"):
        startRectangleX = rectangleSpacingX
        startRectangleY = sizeY-rectangleHeight
        endRectangleX = rectangleSpacingX+rectangleLength
        endRectangleY = sizeY-rectangleSpacingY
    #BOTTOM RIGHT
    else:
        startRectangleX = sizeX - rectangleSpacingX - rectangleLength
        startRectangleY = sizeY - rectangleSpacingY -rectangleHeight
        endRectangleX = sizeX - rectangleSpacingX
        endRectangleY = sizeY - rectangleSpacingY

    # Computes coordinates of the text and the calibration line (depends on the position of the calibration box)
    # TEXT LEFT
    if (textPos == "Left"):
        # text coords
        textX = startRectangleX + objectSpacing + (textLength/2)
        textY = startRectangleY + rectangleHeight / 2
        # start and end of line coords
        startX = textX + (textLength/2) + objectSpacing
        startY = startRectangleY + rectangleHeight / 2
        endX = startX + length
        endY = startY
    # TEXT RIGHT
    elif (textPos == "Right"):
        # start and end of line coords
        startX = startRectangleX + objectSpacing
        startY = startRectangleY + rectangleHeight / 2
        endX = startX + length
        endY = startY
        # text coords
        textX = endX + objectSpacing + (textLength/2)
        textY = startRectangleY + rectangleHeight / 2
    # TEXT UP
    elif(textPos == "Up"):
        # start and end of line coords
        startX = startRectangleX + objectSpacing
        startY = endRectangleY-rectangleHeight/2.6
        endX = startX + length
        endY = startY
        # text coords
        textX = startRectangleX + rectangleLength / 2
        textY = startRectangleY + ((startY-startRectangleY)/2)
    # TEXT BOTTOM
    else:
        # start and end of line coords
        startX = startRectangleX + objectSpacing
        startY = startRectangleY+rectangleHeight/2.6
        endX = startX + length
        endY = startY
        # text coords
        textX = startRectangleX+rectangleLength /2
        textY = endRectangleY - ((endRectangleY-startY)/2)

    # to add a background color to the calibration box
    if (bBackgroundEnabled):
        draw.rectangle([(startRectangleX, startRectangleY),
                        (endRectangleX, endRectangleY)],
                       outline='black',
                       fill=backgroundColor,
                       width=width)

    # draw the line calibration + the small lines on the borders of the line calibration
    draw.line([(startX,startY),(endX,endY)], fill=textColor, width=width)
    draw.line([(startX,startY-rectangleHeight/6),(startX,startY+rectangleHeight/6)], fill=textColor, width=width)
    draw.line([(endX,endY-rectangleHeight/6),(endX,endY+rectangleHeight/6)], fill=textColor, width=width)

    # draw text of calibration on image
    draw.text((textX,textY), text, fill=textColor, width=width, anchor="mm", font=font)

    ipsdkImg = pilImageToIPSDKImage(pilRgbImg)

    return ipsdkImg

def imageLabelToColor(image,split=False):

    random.seed(5)

    _, nbLabels = getMinMaxValue(image)

    if image.getBufferType() in [PyIPSDK.eIBT_Label8, PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:
        maxNumber = 10000000

    nbLabels = min(nbLabels + 1, maxNumber)
    lutArray = []
    lutArray.append([0])
    lutArray.append([0])
    lutArray.append([0])
    for i in range(1, int(nbLabels) + 1):
        for c in range(3):
            if i < 10:
                lutArray[c].append(vrb.dictColor[i][c])
            else:
                lutArray[c].append(random.randint(vrb.randomColorMin, vrb.randomColorMax))

    dictLabels = fctML.readSmartSegmentation(image)
    for i in dictLabels:
        colorText = dictLabels[i]["Color"]
        colorTextSplit = colorText.split(",")
        for j in range(len(colorTextSplit)):
            if i == 0:
                lutArray[j][i] = 0
            else:
                lutArray[j][i] = float(colorTextSplit[j])

    if split:
        outImage = []
        for c in range(0, 3):
            if image.getSizeZ() == 1:
                lut = PyIPSDK.createIntensityLUT(0, 1, lutArray[c])
                lutImage = itrans.lutTransform2dImg(image, lut)
                lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                outImage.append(lutImage)
            else:
                lut = PyIPSDK.createIntensityLUT(0, 1, lutArray[c])
                lutImage = itrans.lutTransform3dImg(image, lut)
                lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                outImage.append(lutImage)
    else:
        colorGeometry = PyIPSDK.ColorGeometry()
        colorGeometry.initRgb()
        volumeGeometry = PyIPSDK.VolumeGeometry()
        if image.getSizeZ() == 1:
            volumeGeometry.init2d()
        else:
            volumeGeometry.init3d(image.getSizeZ())
        temporalGeometry = image.getGeometry().getTemporalGeometry()
        geometry = PyIPSDK.geometry(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)
        outImage = PyIPSDK.createImage(geometry)

        for c in range(0, 3):
            if image.getSizeZ() == 1:
                if image.getTemporalGeometryType() == PyIPSDK.eTGT_Single:
                    plan = PyIPSDK.extractPlan(0, c, 0, outImage)
                else:
                    plan = PyIPSDK.extractTemporal(0, c, outImage)

                lut = PyIPSDK.createIntensityLUT(0, 1, lutArray[c])
                lutImage = itrans.lutTransform2dImg(image, lut)
                lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                util.copyImg(lutImage, plan)
            else:
                if image.getTemporalGeometryType() == PyIPSDK.eTGT_Single:
                    volume = PyIPSDK.extractVolume(c, 0, outImage)
                else:
                    volume = PyIPSDK.extractTemporalVolume(c, outImage)

                lut = PyIPSDK.createIntensityLUT(0, 1, lutArray[c])
                lutImage = itrans.lutTransform3dImg(image, lut)
                lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
                util.copyImg(lutImage, volume)

    return outImage

def splitColorImage(image):

    outImage = []
    for c in range(3):
        if image.getSizeZ() == 1:
            plan = PyIPSDK.extractPlan(0, c, 0, image)
            plan = util.copyImg(plan)
            outImage.append(plan)
        else:
            volume = PyIPSDK.extractVolume(c, 0, image)
            volume = util.copyImg(volume)
            outImage.append(volume)

    return outImage

def createLabelLutNapari(nbLabels):

    random.seed(5)

    lutArray = []
    if nbLabels == 1:
        lutArray = [[0,0,0,1],[0,0,1,1]]
    else:
        try:
            file = xmlet.parse(vrb.folderInformation + "/UserLabels.mho")
            xmlElement = file.getroot()
        except:
            xmlElement = xmlet.Element('UserLabels')
        nbDefineLabel = len(xmlElement)
        dictUser = {}
        for i in range(1, nbDefineLabel + 1):
            try:
                child = Dfct.SubElement(xmlElement, "Label_" + str(i))
                color = Dfct.childText(child, "Color")
                color = color.split(",")
                dictUser[i-1] = [float(color[0]),float(color[1]),float(color[2])]
            except:
                pass

        for i in range(1, int(nbLabels)+1):
            lutArray.append([])
            for c in range(3):
                if i < nbDefineLabel:
                    lutArray[i-1].append(dictUser[i][c]/255)
                elif i < 10:
                    lutArray[i-1].append(vrb.dictColor[i][c]/255)
                else:
                    lutArray[i-1].append(random.randint(vrb.randomColorMin, vrb.randomColorMax)/255)
            lutArray[i-1].append(1)

    colormap = napari.utils.Colormap(lutArray)

    return colormap

def computeSieve(sieveName,listValues):

    sieve = []
    try:
        file = xmlet.parse(vrb.folderInformation + "/UserSieves.mho")
        xmlElement = file.getroot()
        for child in xmlElement:
            name = Dfct.childText(child, "Name")
            if name == sieveName:
                type = Dfct.getValueElementComboBox(child, "Type")
                mini = Dfct.getValueElementLineEdit(child, "Min")
                maxi = Dfct.getValueElementLineEdit(child, "Max")
                binChecked = Dfct.getValueElementCheckBox(child, "BinChecked")
                binValue = Dfct.getValueElementLineEdit(child, "BinValue",typeValue="float")
                nbClassesChecked = Dfct.getValueElementCheckBox(child, "NbClassesChecked")
                nbClassesValue = Dfct.getValueElementLineEdit(child, "NbClassesValue")
                raisonChecked = Dfct.getValueElementCheckBox(child, "RaisonChecked")
                raisonValue = Dfct.getValueElementLineEdit(child, "RaisonValue",typeValue="float")
                nbClassesGeometricChecked = Dfct.getValueElementCheckBox(child, "NbClassesGeometricChecked")
                nbClassesGeometricValue = Dfct.getValueElementLineEdit(child, "NbClassesGeometricValue")
                sieveElement = Dfct.SubElement(child,"Sieve")
                sieveValueText = Dfct.childText(sieveElement,"Value")
                if sieveValueText is not None:
                    sieveValue = []
                    # sieveValueText = sieveValueText[1:-1]
                    sieveValueTextSplit = sieveValueText.split(',')
                    for v in sieveValueTextSplit:
                        val = float(v)
                        if abs(val-round(val))<0.000001:
                            val = round(val)
                        sieveValue.append(val)

                if type in [1,3]:
                    mini = min(listValues)
                    maxi = max(listValues)

                if type == 4:
                    sieve = sieveValue
                else:
                    if abs(round(mini) - mini) < 0.00001 and abs(round(maxi) - maxi) < 0.00001:
                        isInterger = True
                        mini = round(mini)
                        maxi = round(maxi)
                    else:
                        isInterger = False
                    if maxi > mini:
                        if type in [0,1]:
                            if nbClassesChecked:
                                binValue = (maxi-mini) / nbClassesValue
                            if abs(round(binValue) - binValue) > 0.00001:
                                isInterger = False
                            else:
                                binValue = round(binValue)
                            if binValue > 0:
                                value = mini
                                while value < maxi:
                                    if isInterger:
                                        sieve.append(round(value))
                                    else:
                                        sieve.append(round(value * 10) / 10)
                                    value += binValue
                                sieve.append(maxi)
                        if type in [2,3] and mini>0:
                            if nbClassesGeometricChecked:
                                raisonValue = (maxi / mini) ** (1 / (nbClassesGeometricValue - 1))
                            if raisonValue > 1:
                                value = mini
                                while value < maxi:
                                    sieve.append(round(value))
                                    value *= raisonValue
                                sieve.append(maxi)
    except:
        traceback.print_exc(file=sys.stderr)
        sieve = []

    return sieve

def getOffset(image):

    try:
        calib = image.getGeometricCalibration()
    except:
        calib = PyIPSDK.createGeometricCalibration3d(1, 1, 1, 'px')

    offsetX, offsetY, offsetZ = calib.getXOriginUncalibrated(), calib.getYOriginUncalibrated(), calib.getZOriginUncalibrated()

    return offsetX,offsetY,offsetZ

def createDictFromColl(coll,nameIndex,nameValue,start = 1, offset = 0):

    ddict = {}
    ddict[nameIndex] = []
    ddict[nameValue] = []

    for i in range(start, len(coll)):
        ddict[nameIndex].append(i+offset)
        ddict[nameValue].append(coll[i])

    return ddict

def createDictFromMultislice(multiSlice,value="Value"):

    ddict = {}

    maxZ = 0
    maxC = 0
    maxT = 0
    for z, c, t in multiSlice.keys():
        maxZ = max(maxZ, z)
        maxC = max(maxC, c)
        maxT = max(maxT, t)

    if maxZ > 0:
        ddict["Z"] = []
    if maxC > 0:
        ddict["C"] = []
    if maxT > 0:
        ddict["T"] = []
    ddict[value] = []

    for z, c, t in multiSlice.keys():
        if maxZ > 0:
            ddict["Z"].append(int(z))
        if maxC > 0:
            ddict["C"].append(int(c))
        if maxT > 0:
            ddict["T"].append(int(t))

        ddict[value].append(multiSlice[(z, c, t)][value])

    return ddict

def adjustDictForMeasure(ddict):

    if ddict is not None:
        for tag in ddict:
            if isinstance(ddict[tag], list) == False and isinstance(ddict[tag], np.ndarray) == False:
                ddict[tag] = [ddict[tag]]

    return ddict

# def colorFromValueInLut(lut,ratio):
#
#     maxValue = 0
#     for value in lut["Array"]:
#         maxValue = max(maxValue,value)
#         ratio = ratio*maxValue
#
#     previousColor = 0
#     colorAfter = 0


def getColorFromLut(lut, ratio):

    ratio = 1-ratio

    if ratio < 0 or ratio > 1:
        raise ValueError("Le ratio doit être compris entre 0 et 1.")

    indices = np.array(sorted(lut["Array"].keys()))
    colors = np.array([lut["Array"][i] for i in indices])

    scaledRatio = ratio * (indices[-1] - indices[0]) + indices[0]

    lowerIdx = np.searchsorted(indices, scaledRatio, side="right") - 1
    upperIdx = lowerIdx + 1

    if lowerIdx < 0:
        return colors[0]
    if upperIdx >= len(indices):
        return colors[-1]
    if indices[lowerIdx] == scaledRatio:
        return colors[lowerIdx]

    lowerValue = indices[lowerIdx]
    upperValue = indices[upperIdx]

    t = (scaledRatio - lowerValue) / (upperValue - lowerValue)
    interpolatedColor = (1 - t) * colors[lowerIdx] + t * colors[upperIdx]

    color = interpolatedColor.astype(int).tolist()

    return color[0],color[1],color[2]

def computeHistogramWithSieve(listValues,tamis,title = None, xLegend = None,yLegend = None,sizeText = None):

    histogram = vrb.Histogram()
    histogram.tamis = tamis

    tickLabelNum = 0
    for i in range(len(tamis) - 1):
        histogram.xValues.append(i)
        histogram.barsetValues.append(0)

        # histogram.tick_label_table.append("[ " + str(tamis[i])+" , " + str(tamis[i + 1]) + " ]")
        #
        # if int((i/(len(tamis) - 2))*11) >= tickLabelNum:
        #     histogram.tick_label.append(str(round(((tamis[i] + tamis[i + 1]) / 2) * 10) / 10))
        #     tickLabelNum+=1
        # else:
        #     histogram.tick_label.append("")

    for value in listValues:
        for i in range(len(tamis) - 1):
            if histogram.cumul == False:
                if i < len(tamis) - 2:
                    if value >= tamis[i] and value < tamis[i + 1]:
                        histogram.barsetValues[i] += 1
                else:
                    if value >= tamis[i] and value <= tamis[i + 1]:
                        histogram.barsetValues[i] += 1
            else:
                if i < len(tamis) - 2:
                    if value < tamis[i + 1]:
                        histogram.barsetValues[i] += 1
                else:
                    if value <= tamis[i + 1]:
                        histogram.barsetValues[i] += 1

    histogram.title = title
    histogram.xLegend = xLegend
    histogram.yLegend = yLegend
    histogram.sizeText = sizeText

    return histogram

def updateSievesComboBox():

    try:
        file = xmlet.parse(vrb.folderInformation + "/UserSieves.mho")
        element = file.getroot()
    except:
        element = xmlet.Element('UserSieves')

    for comboBox in vrb.sievesComboBox:

        comboBox.comboBoxSieve.clear()
        for child in element:
            name = Dfct.childText(child, "Name")
            comboBox.comboBoxSieve.addItem(name)

def greyImageToColorImage(image):

    imageColor = PyIPSDK.createImageRgb(image.getBufferType(), image.getSizeX(), image.getSizeY())
    for c in range(3):
        plan = PyIPSDK.extractPlan(0, c, 0, imageColor)
        util.copyImg(image, plan)

    return imageColor

def integrateColorCalibration(image,imageOverlay,lutVector,minValue,maxValue,position = "Top left",size = 50, direction = "Vertical",textColor = [0,0,0],backgroundColor = [255,255,255]):

    sizeLutVector = len(lutVector)

    imageTransformed = vrb.mainWindow.widgetImage.transformImage(image, imageOverlay, None, None, None, extractImage=True)
    if imageTransformed.getSizeC() == 1:
        imageTransformed = greyImageToColorImage(imageTransformed)

    if direction == "Horizontal":
        sizeX = int(image.getSizeX()*size/100)
        sizeY = int(sizeX/8)
    elif direction == "Vertical":
        sizeY = int(image.getSizeY()*size/100)
        sizeX = int(sizeY/8)
    imageRectangle = PyIPSDK.createImageRgb(PyIPSDK.eIBT_UInt8, sizeX, sizeY)
    for c in range(3):
        imageChannel = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, sizeX, sizeY)
        util.eraseImg(imageChannel, backgroundColor[c])
        plan = PyIPSDK.extractPlan(0, c, 0, imageRectangle)
        util.copyImg(imageChannel, plan)

    if direction == "Horizontal":
        imageLutUnitary = PyIPSDK.createImageRgb(PyIPSDK.eIBT_UInt8, sizeLutVector, 1)
        for c in range(3):
            plan = PyIPSDK.extractPlan(0, c, 0, imageLutUnitary)
            planCopy = util.copyImg(plan)
            for i in range(sizeLutVector):
                planCopy.array[0,sizeLutVector-1-i] = lutVector[i][0][c]
            util.copyImg(planCopy,plan)
    elif direction == "Vertical":
        imageLutUnitary = PyIPSDK.createImageRgb(PyIPSDK.eIBT_UInt8, 1, sizeLutVector)
        for c in range(3):
            plan = PyIPSDK.extractPlan(0, c, 0, imageLutUnitary)
            planCopy = util.copyImg(plan)
            for i in range(sizeLutVector):
                planCopy.array[i,0] = lutVector[i][0][c]
            util.copyImg(planCopy,plan)

    imageLut = PyIPSDK.createImageRgb(PyIPSDK.eIBT_UInt8, int(sizeX*0.8), int(sizeY*0.8))
    gtrans.zoom2dImg(imageLutUnitary, PyIPSDK.eZoomInterpolationMethod.eZIM_Linear, imageLut)

    util.putROI2dImg(imageRectangle,imageLut,int(sizeX*0.1),int(sizeY*0.1))

    factor = 700/min(sizeX,sizeY)

    imageRectangleZoomed = gtrans.zoom2dImg(imageRectangle, factor, factor, PyIPSDK.eZoomInterpolationMethod.eZIM_Linear)
    newSizeX = int(sizeX*factor)
    newSizeY = int(sizeY*factor)

    pilImage = IPSDKImageToPilImage(imageRectangleZoomed)

    draw = ImageDraw.Draw(pilImage)
    if direction == "Horizontal":
       textXMin =  0.05*newSizeX
       textYMin = 0.5*newSizeY
       textXMax =  0.95*newSizeX
       textYMax = 0.5*newSizeY
       sizeRectangle = newSizeY*0.8
    elif direction == "Vertical":
       textXMin = 0.5*newSizeX
       textYMin = 0.95*newSizeY
       textXMax = 0.5*newSizeX
       textYMax = 0.05*newSizeY
       sizeRectangle = newSizeX*0.8

    font = ImageFont.truetype(vrb.folderFonts + "/arial.ttf",int(sizeRectangle/3))

    draw.text((textXMin,textYMin), str(minValue), fill=textColor, width=1, anchor="mm", font=font)
    draw.text((textXMax,textYMax), str(maxValue), fill=textColor, width=1, anchor="mm", font=font)

    imageRectangleZoomed = pilImageToIPSDKImage(pilImage)

    gtrans.zoom2dImg(imageRectangleZoomed, PyIPSDK.eZoomInterpolationMethod.eZIM_VolumeWeightedMean, imageRectangle)

    if position == "Top left":
        offsetX = 0
        offsetY = 0
    elif position == "Bottom left":
        offsetX = 0
        offsetY = image.getSizeY()-sizeY
    if position == "Top right":
        offsetX = image.getSizeX()-sizeX
        offsetY = 0
    elif position == "Bottom right":
        offsetX = image.getSizeX()-sizeX
        offsetY = image.getSizeY()-sizeY

    util.putROI2dImg(imageTransformed,imageRectangle,offsetX,offsetY)

    return imageTransformed

if __name__ == '__main__':

    print(adjustedNumberCalibration(12.21856))
    print(adjustedNumberCalibration(12.21856,mode = "min"))
    print(adjustedNumberCalibration(0,mode = "min"))
    print(adjustedNumberCalibration(0.999999))
    print(adjustedNumberCalibration(0.999999,mode = "min"))
    # adjustedNumberCalibration(87725635336.625)
    # adjustedNumberCalibration(87725635336.625,mode = "min")
    # adjustedNumberCalibration(0.001221856)
    # adjustedNumberCalibration(0.001221856,mode = "min")

    # lutMagma = {}
    # lutMagma['Name'] = "Magma"
    # lutMagma['Type'] = "Interp"
    # lutMagma["Array"] = {}
    # lutMagma["Array"][10] = [0, 0, 255]
    # lutMagma["Array"][0] = [255, 0, 0]
    # lutMagma["Array"][5] = [0, 255, 0]

    # lutJet = {}
    # lutJet['Name'] = "Jet"
    # lutJet['Type'] = "Interp"
    # lutJet["Array"] = {}
    # lutJet["Array"][0] = [255, 0, 0]
    # lutJet["Array"][1] = [255, 128, 0]
    # lutJet["Array"][2] = [255, 255, 0]
    # lutJet["Array"][3] = [128, 255, 0]
    # lutJet["Array"][4] = [0, 255, 0]
    # lutJet["Array"][5] = [0, 255, 128]
    # lutJet["Array"][8] = [0, 0, 255]

    # lutClassic = {}
    # lutClassic['Name'] = "Classic"
    # lutClassic['Type'] = "Interp"
    # lutClassic["Array"] = {}
    # lutClassic["Array"][0] = [255, 255, 255]
    # lutClassic["Array"][255] = [0, 0, 0]
    #
    # # ratio = 0.001
    # ratio = 0.99
    # color = getColorFromLut(lutClassic, ratio)
    # print("Couleur interpolée pour le ratio {} :".format(ratio), color)

    # sieve = computeSieve("Length",[1,3,10])
    #
    # print(sieve)

#
#     # element = {}
#     # element[1] = 'a'
#     # element[2] = 5
#     #
#     # ddict2 = {}
#     # ddict2["5"] = 5
#     # ddict2["ok"] = [16]
#     # element["dict"] = ddict2
#     #
#     # element["la"] = [5,"6",[1,2,3]]
#     #
#     # print(element)
#     # text = writeElement(element)
#     # print(text)
#     # output = readElement(text)
#     # print(output)
#
#     # element = [1,[2,3]]
#     #
#     # text = writeElement(element)
#     # print(text)
#     # output = readElement(text)
#     # print(output)
#
#     # values = blendValues([1,2,3],[5,0,8],0.2)
#     # values = blendValues("a","b",1)
#
#     ddict1 = {}
#     ddict1["a"] = [1,2,3]
#     ddict1["b"] = 6
#     ddict1["c"] = 0
#     ddict1["d"] = "z"
#     #
#     # ddict2 = {}
#     # ddict2["a"] = [5,0,8]
#     # ddict2["b"] = 4
#     # ddict2["d"] = "c"
#     #
#     # values = blendValues(ddict1,ddict2,0.2)
#
#     # list1 = (1,2,3)
#     # list2 = (5,0,8)
#     #
#     # values = blendValues(list1,list2,0.2)
#     #
#     #
#     # print(values)
#
#     text = writeElement(ddict1)
#
#     print(text)
#
#     ddict = readElement(text)
#
#     print(ddict)