import time
start = time.time()

import PyIPSDK
import sys
import os
from PyQt5.QtGui import QPixmap, QIcon
from PyQt5.QtCore import QCoreApplication
from PyQt5.QtWidgets import QApplication, QSplashScreen
from UsefullVariables import folderImages
from MainWindow import MainWindow

from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
from CustomWidgets import MyComboBoxObject

import PyQt5.QtWidgets as qt

import UsefullVariables as vrb

vrb.unitTestMode = True

# import shutil
# try:
#     shutil.rmtree(vrb.folderReference + "/Log")
# except:
#     pass

import xlwt

print (vrb.folderReference + "/Log")

exceptionFunctions = ["Anisotropic diffusion 2D","Anisotropic diffusion 3D","Patch-based bilateral filter 2D","Patch-based bilateral filter 3D","Normalized Cross-Correlation 2D","Normalized Cross-Correlation 3D"
                      ,"Locate Pixels 2D","Locate Voxels 3D"]

# exceptionFunctions = ["Normalized Cross-Correlation 3D","Locate Voxels 3D"]

def functionTest():

    book = xlwt.Workbook(encoding="utf-8")
    sheet1 = book.add_sheet("UnitTest", cell_overwrite_ok=True)

    for file in sorted(os.listdir(folderUnitTest),key=str.casefold):
        url = [folderUnitTest + "/" + file]
        centralWidget.addLabelsFromUrls(url)

    nbFunction = 0
    for i in range(centralWidget.categorySpoilersContainer.layout.count()):
        # item = centralWidget.categorySpoilersContainer.layout.itemAtPosition(i,0)
        item = centralWidget.categorySpoilersContainer.layout.itemAt(i)
        if item is not None:
            spoilerCategory = item.widget()
            spoilerCategory.emitSignalSetSpoilerExpand(None)
            qt.QApplication.processEvents()
            if "Macro" not in spoilerCategory.title:
                print ("######## ",spoilerCategory.title)
                for j in range(spoilerCategory.widget.layout.count()):
                    # time.sleep(10)
                    # itemChild = spoilerCategory.widget.layout.itemAtPosition(j, 0)
                    itemChild = spoilerCategory.widget.layout.itemAt(j)
                    if itemChild is not None:
                        sploiler = itemChild.widget()
                        if sploiler.title not in exceptionFunctions:
                            sploiler.emitSignalSetSpoilerExpand(None)
                            qt.QApplication.processEvents()
                            vrb.currentFunction = sploiler.title
                            startFunction = time.time()
                            spoilerFunction(sploiler.widget)
                            timeFunction = time.time()-startFunction
                            print(sploiler.title, "   ", timeFunction)
                            sheet1.write(nbFunction, 0, sploiler.title)
                            sheet1.write(nbFunction, 1, timeFunction)
                            nbFunction+=1

    # book.save("F:/UnitTest.xls")
    print ("End : "+str(time.time()-start))

def spoilerFunction(widget):

    nbOutput = 0

    for nb in widget.parameters:
        if widget.parameters[nb]["Type"] == InputType.IMAGE and type(widget.parameters[nb]["Widget"]) == MyComboBoxObject:
            widget.parameters[nb]["Widget"].setCurrentIndex(0)
    for nb in widget.outputs:
        if widget.outputs[nb]["Type"] == OutputType.IMAGE:
            widget.outputs[nb]["Widget"].setText("outImage_"+str(nbOutput))
            nbOutput+=1

    widget.emitSignalProcess()
    #centralWidget.terminateThread()

# folderUnitTest = os.path.dirname(vrb.folderExplorer) + "/images"
folderUnitTest = "D:/UnitTestImages"

app = QCoreApplication.instance()
if app is None:
    app = QApplication([])

sys._excepthook = sys.excepthook
def exception_hook(exctype, value, traceback):
    print(exctype, value, traceback)
    sys._excepthook(exctype, value, traceback)
    sys.exit(1)
sys.excepthook = exception_hook

foo = MainWindow(app=app)

centralWidget = foo.centralWidget

# centralWidget.groupMenu.buttonTest = qt.QPushButton("Test")
# centralWidget.groupMenu.buttonTest.setFixedSize(50, 36)
# centralWidget.groupMenu.layoutBar1.addWidget(centralWidget.groupMenu.buttonTest, 0, 2)
#
# centralWidget.groupMenu.buttonTest.clicked.connect(functionTest)

foo.show()

functionTest()

app.exec_()
