import sys
import random
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet
import UsefullFunctions as fct

import PyIPSDK

import UsefullVariables as vrb

import UsefullDisplay as display
from ConversionIPSDK import dictConversion

class TransformationTableDisplayer(display.TableWidgetWindow):

    def __init__(self, transformation):
        super().__init__()

        self.displayNumberOfElement = False

        self.transformation = transformation

        nameTransformation = dictConversion[str(self.transformation.motionModel)]["UserName"]

        ddict = {}
        ddict["Transformation"] = nameTransformation

        if nameTransformation == "Translation":
            ddict["Tx"] = fct.numberCalibration(self.transformation.params[0])
            ddict["Ty"] = fct.numberCalibration(self.transformation.params[1])
        if nameTransformation == "Rigid":
            ddict["Theta"] = fct.numberCalibration(self.transformation.params[0])
            ddict["Tx"] = fct.numberCalibration(self.transformation.params[1])
            ddict["Ty"] = fct.numberCalibration(self.transformation.params[2])
        if nameTransformation == "Similarity":
            ddict["Scale"] = fct.numberCalibration(self.transformation.params[0])
            ddict["Theta"] = fct.numberCalibration(self.transformation.params[1])
            ddict["Tx"] = fct.numberCalibration(self.transformation.params[2])
            ddict["Ty"] = fct.numberCalibration(self.transformation.params[3])
        if nameTransformation == "Homography":
            ddict["Axx"] = fct.numberCalibration(self.transformation.params[0])
            ddict["Axy"] = fct.numberCalibration(self.transformation.params[1])
            ddict["Axw"] = fct.numberCalibration(self.transformation.params[2])
            ddict["Ayx"] = fct.numberCalibration(self.transformation.params[3])
            ddict["Ayy"] = fct.numberCalibration(self.transformation.params[4])
            ddict["Ayw"] = fct.numberCalibration(self.transformation.params[5])
            ddict["Azx"] = fct.numberCalibration(self.transformation.params[6])
            ddict["Azy"] = fct.numberCalibration(self.transformation.params[7])
            ddict["Azz"] = fct.numberCalibration(self.transformation.params[8])

        self.tableWidget.ddict = ddict
        self.tableWidget.loadDictionary()

        self.resize(400*vrb.ratio,150*vrb.ratio)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

class StackTransformationTableDisplayer(display.TableWidgetWindow):

    def __init__(self, stackTransformation):
        super().__init__()

        self.stackTransformation = stackTransformation

        ddict = {}
        ddict["Plan"] = []
        ddict["Tx"] = []
        ddict["Ty"] = []

        coll = self.stackTransformation.coll
        for numPlan in range(len(coll)):
            ddict["Plan"].append(numPlan)
            ddict["Tx"].append(fct.numberCalibration(coll[numPlan].params[0]))
            ddict["Ty"].append(fct.numberCalibration(coll[numPlan].params[1]))

        self.tableWidget.ddict = ddict
        self.tableWidget.loadDictionary()

        self.resize(400*vrb.ratio,150*vrb.ratio)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

    def display(self, xmlElement, boolShow=True):
        self.setWindowTitle(Dfct.childText(xmlElement, 'Name'))

        if boolShow:
            if self.isMaximized():
                self.showMaximized()
            else:
                self.showNormal()
            self.window().raise_()
            self.window().activateWindow()

    def stopDisplay(self):
        self.close()