dictExamples = {}

dictExamples["Add lut to image"] = """import PyIPSDK
import PyIPSDK.IPSDKIPLBasicMorphology as morpho

def My_function( inImg1 ):

	output = morpho.distanceMap2dImg(inImg1)
	
	#Define lut name (Magma,Jet,Inverted,...)
	output.lut = 'Magma'
	
	#Ignore the background or not
	output.background = False

	return output"""

dictExamples["Get values in analysis measurement"] = """import PyIPSDK
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis

def My_function( inLabelImg2d,inGreyImg ):

    # Create the infoset
    inMeasureInfoSet2d = PyIPSDK.createMeasureInfoSet2d()
    PyIPSDK.createMeasureInfo(inMeasureInfoSet2d, "Area2dMsr")
    
    #Perform the analysis
    outMeasureSet = shapeanalysis.labelAnalysis2d(inGreyImg, inLabelImg2d, inMeasureInfoSet2d)
    
    # retrieve measure results
    outArea2dMsr = outMeasureSet.getMeasure("Area2dMsr")
    
    # retrieve measure values
    outArea2dValues = outArea2dMsr.getMeasureResult().getColl(0)
    print("First label area with holes measurement equal " + str(outArea2dValues[1]))"""

dictExamples["Display a table"] = """from UsefullWidgets import Measure

def My_function(image):
	
	#Compute the measure
	value = {}
	value["Index"] = [1,2,3,4,5]
	value["Area"] = [11,2.5,0,3.1,5]
	value["Perimeter"] = [5.2,3,6,11,8.3]
	
	#Define the type of measure
	measure = Measure()
	measure.subType = "Dict"
	measure.value = value

	#Choose type "Measure" in Outputs
	return measure"""

dictExamples["Display a graph"] = """from UsefullWidgets import Measure

def My_function(image):
	
	#yAxis
	yAxis = [2,5,10,20,18,17,17]
	
	#xAxis (optionnal)
	xAxis = [0,5,10,15,20,30,50]
	#if not define xAxis will be [0,1,2,3,...]
	
	#Other informations (optionnals)
	xLabel = "label for x axis"
	yLabel = "label for y axis"
	title = "my title"

	#Define the type of measure
	measure = Measure()
	measure.subType = "LineProfile"
	measure.value = yAxis
	#Optionnals
	measure.xAxis = xAxis
	measure.xLabel = xLabel
	measure.yLabel = yLabel
	measure.title = title

	#Choose type "Measure" in Outputs
	return measure
"""

dictExamples["Apply an interactive threshold"] = """import PyIPSDK
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKUI as ui

def My_function( inImg, minValue, maxValue):

	# Apply interactive threshold
	# minValue, maxValue and title are optionnals
	
	res = ui.interactiveThreshold(inImg,minValue=minValue,maxValue=maxValue,title = "Interactive threshold")
	if res.bValidated:
		# Continue the process if the user validate the threshold result
		# img2 if the thresholded image
		img2 = res.thresholdedImg
		img3 = advmorpho.watershedBinarySeparation2dImg(img2, 4, PyIPSDK.eWatershedSeparationMode.eWSM_SplitLabel)

	else:
		# If the threshold if canceled, return None
		img3 = None	

	return img3"""

dictExamples["Apply an interactive threshold"] = """import UsefullVariables as vrb
import time
import PyQt5.QtWidgets as qt
import PyIPSDK.IPSDKIPLUtility as util

def My_function(image):
	
	#Print some text
	vrb.mainWindow.groupBoxProcessing.setText('Start process')
	
	#Display the progress bar and choose the number of steps
	vrb.mainWindow.groupBoxProcessing.progressBar.setVisible(True)
	vrb.mainWindow.groupBoxProcessing.progressBar.setRange(0,3)
	vrb.mainWindow.groupBoxProcessing.progressBar.setValue(0)
	
	#Update the interface
	qt.QApplication.processEvents()
	
	#Step 1
	img1 = util.copyImg(image)
	time.sleep(2)
	vrb.mainWindow.groupBoxProcessing.setText('Step 1')
	vrb.mainWindow.groupBoxProcessing.progressBar.setValue(1)
	qt.QApplication.processEvents()
	
	#Step 2
	img2 = util.copyImg(img1)
	time.sleep(2)
	vrb.mainWindow.groupBoxProcessing.setText('Step 2')
	vrb.mainWindow.groupBoxProcessing.progressBar.setValue(2)
	qt.QApplication.processEvents()
	
	#Step 3
	outImage = util.copyImg(img2)
	time.sleep(2)
	vrb.mainWindow.groupBoxProcessing.setText('Step 3')
	vrb.mainWindow.groupBoxProcessing.progressBar.setValue(3)
	qt.QApplication.processEvents()
		
	return outImage
"""

dictExamples["Change a pixel value in image"] = """import PyIPSDK.IPSDKIPLUtility as util

def My_function(image):
	
	# Copy the image to avoid modifying the input image
	outImage = util.copyImg(image)
	
	# Get the array of the output image
	array = outImage.array
	
	#Define your coordinate
	x = 10
	y = 100
	
	# Print the pixel value (Be careful the order is y then x)
	print(array[y,x])
	
	# Change the value
	array[y,x] = 0
		
	return outImage
"""