import fnmatch

def findRegisterLicenceExe(inPath):
    import os
    pattern = "RegisterIPSDKLicense_*"
    result = []
    for root, dirs, files in os.walk(inPath):
        for name in files:
            if fnmatch.fnmatch(name, pattern):
                result.append(os.path.join(root, name))
    return result

def findReleaseDir(inPath):
    import os
    pattern = "Release_*"
    result = []
    for root, dirs, files in os.walk(inPath):
        for name in dirs:
            if fnmatch.fnmatch(name, pattern):
                result.append(os.path.join(root, name))
    return result[0]

def main():
    try:

        import PyIPSDK
        import sys
        from PyQt5.QtGui import QPixmap,QIcon
        from PyQt5.QtCore import QCoreApplication
        from PyQt5.QtWidgets import QApplication, QSplashScreen
        from UsefullVariables import folderImages,folderInformation,currentVersion,folderExplorer,folderReference
        from DatabaseFunction import saveXmlElement
        import os
        from shutil import copyfile

        import xml.etree.ElementTree as xmlet

        app = QCoreApplication.instance()
        if app is None:
            app = QApplication([])

        sys._excepthook = sys.excepthook

        def exception_hook(exctype, value, traceback):
            print(exctype, value, traceback)
            sys._excepthook(exctype, value, traceback)
            sys.exit(1)

        sys.excepthook = exception_hook

        pixmap = QPixmap(folderImages + '/Explorer_Logo_Bleu.png')
        from PyQt5.QtCore import Qt
        pixmap = pixmap.scaled(600,600,aspectRatioMode=Qt.KeepAspectRatio,transformMode=Qt.SmoothTransformation)
        splashScreen = QSplashScreen(pixmap)
        splashScreen.setFixedSize(600,600)
        splashScreen.show()
        app.processEvents()

        app.setWindowIcon(QIcon(folderImages + "/Explorer_Logo_Bleu.png"))
        #foo.setStyleSheet(style)

        try:
            file = xmlet.parse(folderInformation + "/Version.mho")
            xmlElement = file.getroot()
        except:
            xmlElement = xmlet.Element('Version')

        if xmlElement.text != currentVersion:
            import scriptsCreation._GenerateAllFunctions

            for fileName in os.listdir(folderExplorer+"/Functions/Macro/"):
                try:
                    copyfile(folderExplorer+"/Functions/Macro/"+fileName, folderReference+"/Functions/Macro/"+fileName)
                except:
                    pass

            xmlElement.text = currentVersion
            saveXmlElement(xmlElement, folderInformation + "/Version.mho")

        #if __name__ == '__main__':

        # app = QCoreApplication.instance()
        # if app is None:
        #     app = QApplication([])
        #
        # sys._excepthook = sys.excepthook

        # def exception_hook(exctype, value, traceback):
        #     print(exctype, value, traceback)
        #     sys._excepthook(exctype, value, traceback)
        #     sys.exit(1)
        #
        # sys.excepthook = exception_hook

        # pixmap = QPixmap(folderImages + '/Explorer_Logo_Bleu.png')
        # from PyQt5.QtCore import Qt
        # pixmap = pixmap.scaled(600,600,aspectRatioMode=Qt.KeepAspectRatio,transformMode=Qt.SmoothTransformation)
        # splashScreen = QSplashScreen(pixmap)
        # splashScreen.setFixedSize(600,600)
        # splashScreen.show()
        # app.processEvents()
        #
        # app.setWindowIcon(QIcon(folderImages + "/Explorer_Logo_Bleu.png"))
        # #foo.setStyleSheet(style)

        from MainWindow import MainWindow
        foo = MainWindow(app=app)

        if os.name == 'nt':
            try:
                foo.setWindowFlag(Qt.WindowStaysOnTopHint)
            except:
                foo.setWindowFlags(Qt.WindowStaysOnTopHint)

            foo.show()

            try:
                foo.setWindowFlag(foo.windowFlags() & ~Qt.WindowStaysOnTopHint)
            except:
                foo.setWindowFlags(foo.windowFlags() & ~Qt.WindowStaysOnTopHint)

        foo.show()

        splashScreen.finish(foo)

        app.exec_()

    except:

        try:
            import PyIPSDK
        except:
            import os
            import subprocess

            dir_path = os.path.dirname(os.path.realpath(__file__))
            folderExplorer = os.path.dirname(dir_path)
            folderParent = os.path.dirname(folderExplorer)

            # Manage toolkit/standalone case
            if os.path.basename(folderParent) == "python":
                folderParent = os.path.dirname(folderParent)

            # Dev or installer version
            if os.path.exists(folderParent + "/bin"):
                releasePath = findReleaseDir(folderParent + "/bin")
            elif os.path.exists(folderParent + "/Output"):
                releasePath = findReleaseDir(folderParent + "/Output")
            else:
                raise RuntimeError("Unable to find binaries in the directory " + folderParent)

            registerLicenceExePath = findRegisterLicenceExe(releasePath)
            #registerLicenceExePath = findRegisterLicenceExe(folderParent + "/Output/Release_msvc15_x64")
            subprocess.check_call(registerLicenceExePath)

        try:
            import PyIPSDK
            import sys
            from PyQt5.QtGui import QPixmap, QIcon
            from PyQt5.QtCore import QCoreApplication
            from PyQt5.QtWidgets import QApplication, QSplashScreen
            from UsefullVariables import folderImages, folderInformation, currentVersion, folderExplorer, folderReference
            from DatabaseFunction import saveXmlElement
            import os
            from shutil import copyfile

            import xml.etree.ElementTree as xmlet

            #if __name__ == '__main__':

            app = QCoreApplication.instance()
            if app is None:
                app = QApplication([])

            sys._excepthook = sys.excepthook


            def exception_hook(exctype, value, traceback):
                print(exctype, value, traceback)
                sys._excepthook(exctype, value, traceback)
                sys.exit(1)


            sys.excepthook = exception_hook

            pixmap = QPixmap(folderImages + '/Explorer_Logo_Bleu.png')
            from PyQt5.QtCore import Qt

            pixmap = pixmap.scaled(600, 600, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
            splashScreen = QSplashScreen(pixmap)
            splashScreen.setFixedSize(600, 600)
            splashScreen.show()
            app.processEvents()

            app.setWindowIcon(QIcon(folderImages + "/Explorer_Logo_Bleu.png"))
            # foo.setStyleSheet(style)

            try:
                file = xmlet.parse(folderInformation + "/Version.mho")
                xmlElement = file.getroot()
            except:
                xmlElement = xmlet.Element('Version')

            if xmlElement.text != currentVersion:
                import scriptsCreation._GenerateAllFunctions

                for fileName in os.listdir(folderExplorer + "/Functions/Macro/"):
                    try:
                        copyfile(folderExplorer + "/Functions/Macro/" + fileName,
                                 folderReference + "/Functions/Macro/" + fileName)
                    except:
                        pass

                xmlElement.text = currentVersion
                saveXmlElement(xmlElement, folderInformation + "/Version.mho")

            from MainWindow import MainWindow
            foo = MainWindow(app=app)

            if os.name == 'nt':
                try:
                    foo.setWindowFlag(Qt.WindowStaysOnTopHint)
                except:
                    foo.setWindowFlags(Qt.WindowStaysOnTopHint)

                foo.show()

                try:
                    foo.setWindowFlag(foo.windowFlags() & ~Qt.WindowStaysOnTopHint)
                except:
                    foo.setWindowFlags(foo.windowFlags() & ~Qt.WindowStaysOnTopHint)

            foo.show()

            splashScreen.finish(foo)

            app.exec_()

        except:
            import traceback
            traceback.print_exc(file=sys.stderr)

if __name__ == '__main__':
    main()