import sys
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import UsefullVariables as vrb
import UsefullWidgets as wgt

class SpoilersContainer(qt.QGroupBox):
    """
    Class that can be used to store spoilers
    Only one spoiler can be opened at a time
    """
    SignalWidgetChanged = pyqtSignal()
    SignalHeightChanged = pyqtSignal()

    def __init__(self):
        qt.QGroupBox.__init__(self)

        self.currentWidget = None
        self.onlyOne = True

        self.margins = 5
        self.spacing = 0

        # self.layout = qt.QGridLayout()
        self.layout = qt.QVBoxLayout()

        self.layout.setAlignment(Qt.AlignTop)
        self.setLayout(self.layout)
        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(self.margins, self.margins, self.margins, self.margins)
        self.layout.setSpacing(self.spacing)
        # self.layout.setVerticalSpacing(self.spacing)
        self.setStyleSheet("QGroupBox {border: 0px transparent; }")
        self.changeHeight()

    def addSpoiler(self, spoiler,num = None):
        # self.layout.addWidget(spoiler, self.layout.rowCount(), 0)
        if type(num) == int:
            self.layout.insertWidget(num,spoiler)
        else:
            self.layout.addWidget(spoiler, self.layout.count())
        spoiler.SignalSpoilerExpandClicked.connect(self.changeCurrentWidget)
        spoiler.SignalSetSpoilerExpand.connect(self.setCurrentWidget)
        spoiler.SignalHeightChanged.connect(self.changeHeight)

    def changeCurrentWidget(self, widget):

        if self.onlyOne and self.currentWidget is not None:
            try:
                self.currentWidget.expand()
            except:
                pass
        if self.currentWidget == widget:
            self.currentWidget = None
        else:
            self.currentWidget = widget
            self.currentWidget.expand()

        self.changeHeight()

        self.SignalWidgetChanged.emit()

    def setCurrentWidget(self, widget):

        if self.currentWidget != widget:
            if self.onlyOne and self.currentWidget is not None:
                self.currentWidget.expand()
            self.currentWidget = widget
            if self.currentWidget is not None:
                self.currentWidget.expand()
            self.changeHeight()

            self.SignalWidgetChanged.emit()

    def changeHeight(self):
        totalHeight = 2 * self.margins
        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                if item.widget().shouldBeDisplayed:
                    totalHeight += item.widget().height() + self.spacing
        self.setFixedHeight(totalHeight - self.spacing)
        self.SignalHeightChanged.emit()


class Spoiler(qt.QGroupBox):
    """
    Spoiler that contains a single widget
    Its SignalSpoilerExpandClicked must be caught to expand or hide the widget
    """

    SignalSpoilerExpandClicked = pyqtSignal(qt.QGroupBox)
    SignalSetSpoilerExpand = pyqtSignal(qt.QGroupBox)
    SignalHeightChanged = pyqtSignal()

    def __init__(self, widget=None, title=None, parent=None, favorite=None):
        qt.QGroupBox.__init__(self)

        self.widget = widget
        self.widget.spoiler = self
        self.parent = parent
        self.title = title
        self.margins = 0
        self.spacing = 5

        self.isExpanded = False
        self.shouldBeDisplayed = True

        # header
        self.doubleLabelHeader = wgt.DoubleLabelSpoiler(self.title, favorite=favorite)

        # layout
        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.doubleLabelHeader, 0, 0, Qt.AlignTop)
        self.layout.addWidget(self.widget, 1, 0, Qt.AlignTop)
        self.widget.setVisible(False)

        self.setLayout(self.layout)
        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(self.margins, self.margins, self.margins, self.margins)
        self.layout.setVerticalSpacing(self.spacing)
        self.doubleLabelHeader.label.mousePressEvent = self.emitSignalHeaderClicked
        self.doubleLabelHeader.labelCollapse.mousePressEvent = self.emitSignalHeaderClicked

        self.setStyleSheet("QGroupBox {border: 0px transparent; }")
        self.setFixedHeight(self.doubleLabelHeader.height())

    def expand(self, forceEvent=None):

        try:
            if forceEvent == 'Close':
                self.widget.setVisible(False)
            elif forceEvent == 'Open':
                self.widget.setVisible(True)
            else:
                self.widget.setVisible(not(self.widget.isVisible()))

            self.isExpanded = self.widget.isVisible()

            self.doubleLabelHeader.labelCollapse.setText(('▼', '▲')[self.widget.isVisible()])

            self.changeHeight()

        except:
            pass

    def changeHeight(self):
        if self.widget.isVisible():
            self.setFixedHeight(self.doubleLabelHeader.height() + 2 * self.margins + self.spacing + self.widget.height())
        else:
            self.setFixedHeight(self.doubleLabelHeader.height() + 2 * self.margins)
        self.SignalHeightChanged.emit()

    def emitSignalHeaderClicked(self, event):
        self.SignalSpoilerExpandClicked.emit(self)

    def emitSignalSetSpoilerExpand(self, event):
        self.SignalSetSpoilerExpand.emit(self)

# class DoubleLabelSpoiler(qt.QGroupBox):
#     def __init__(self, title, initial=False):
#         qt.QGroupBox.__init__(self)
#
#         self.margins = 0
#         self.sizeWidget = 25*vrb.ratio
#
#         self.label = qt.QLabel(title)
#         self.label.setFixedHeight(self.sizeWidget)
#         self.label.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
#         self.label.setContentsMargins(5,0,0,0)
#         self.labelCollapse = qt.QLabel(("▼", "▲")[initial])
#         self.labelCollapse.setFixedHeight(self.sizeWidget)
#         self.labelCollapse.setAlignment(Qt.AlignRight | Qt.AlignVCenter)
#         self.labelCollapse.setContentsMargins(0,0,5,0)
#
#         font = QtGui.QFont()
#         font.setPixelSize(10*vrb.ratio)
#         self.label.setFont(font)
#         self.labelCollapse.setFont(font)
#
#         self.layout = qt.QGridLayout()
#         self.layout.addWidget(self.label, 0, 0)
#         self.layout.addWidget(self.labelCollapse, 0, 1)
#
#         self.setLayout(self.layout)
#         self.layout.setContentsMargins(self.margins,self.margins,self.margins,self.margins)
#         self.layout.setHorizontalSpacing(0)
#
#         # self.setStyleSheet("QGroupBox {border: 0px transparent; }")
#         self.setFixedHeight(self.sizeWidget)
#         self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

