import sys


def addToText(text, newText, isEqual):
    if isEqual:
        text += newText
    return text

def structuringElement2D(parameter, paramName=None, process=True):
    if paramName is None:
        paramName = "structuringElement"
    typeStructuringElem = parameter[0]
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    text = addToText(text, '###import numpy as np\n', not process)
    if typeStructuringElem == 'Circular':
        text += paramName + '= PyIPSDK.circularSEXYInfo(' + str(parameter[1]) + ')\n'
    elif typeStructuringElem == 'Linear':
        text += paramName + ' = PyIPSDK.linearSEXYInfo(' + str(parameter[1]) + '* np.pi / 180' + ', ' + str(parameter[2]) + ')\n'
    elif typeStructuringElem == 'SemiLinear':
        text += paramName + ' = PyIPSDK.halfLinearSEXYInfo(' + str(parameter[1]) + '* np.pi / 180' + ', ' + str(parameter[2]) + ')\n'
    elif typeStructuringElem == 'Rectangular':
        text += paramName + ' = PyIPSDK.rectangularSEXYInfo(' + str(parameter[1]) + ', ' + str(parameter[2]) + ')\n'
    elif typeStructuringElem == 'Square':
        text += paramName + ' = PyIPSDK.squareSEXYInfo(' + str(parameter[1]) + ')\n'
    else:
        print("ERROR : Arguments do not fit", file=sys.stderr)

    return [text, paramName]

def structuringElement3D(parameter, paramName=None, process=True):
    if paramName is None:
        paramName = "structuringElement"
    typeStructuringElem = parameter[0]
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    text = addToText(text, '###import numpy as np\n', not process)
    if typeStructuringElem == 'Spherical':
        text += paramName + '= PyIPSDK.sphericalSEXYZInfo(' + str(parameter[1]) + ')\n'
    elif typeStructuringElem == 'Linear':
        text += paramName + ' = PyIPSDK.linearSEXYZInfo(' + str(parameter[1]) + ' * np.pi / 180, ' + str(parameter[2]) + ' * np.pi / 180, ' + str(parameter[3]) + ')\n'
    elif typeStructuringElem == 'Half-Linear':
        text += paramName + ' = PyIPSDK.halfLinearSEXYZInfo(' + str(parameter[1]) + ' * np.pi / 180, ' + str(parameter[2]) + ' * np.pi / 180, ' + str(parameter[3]) + ')\n'
    elif typeStructuringElem == 'Rectangular':
        text += paramName + ' = PyIPSDK.rectangularSEXYZInfo(' + str(parameter[1]) + ', ' + str(parameter[2]) + ', ' + str(parameter[3]) + ')\n'
    elif typeStructuringElem == 'Cubic':
        text += paramName + ' = PyIPSDK.cubicSEXYZInfo(' + str(parameter[1]) + ')\n'
    else:
        print("ERROR : Arguments do not fit", file=sys.stderr)

    return [text, paramName]

def scalePolicy2D(parameter, paramName=None, process=True):
    if paramName is None:
        paramName = "scalePolicy"
    typeStructuringElem = parameter[0]
    text = ''
    text = addToText(text, '###import PyIPSDK\n', not process)
    if typeStructuringElem == 'Default':
        text += paramName + '= PyIPSDK.eDFTScalePolicy.eDFTSP_Default\n'
        return [text, paramName]
    elif typeStructuringElem == 'Unitary':
        text += paramName + '= PyIPSDK.eDFTScalePolicy.eDFTSP_Unitary\n'
        return [text, paramName]
    elif typeStructuringElem == 'Custom':
        text += paramName + '= PyIPSDK.eDFTScalePolicy.eDFTSP_Custom\n'
        return [text,paramName,str(parameter[1]),str(parameter[2])]
    else:
        print("ERROR : Arguments do not fit", file=sys.stderr)

def scalePolicy3D(parameter, paramName=None, process=True):
    if paramName is None:
        paramName = "scalePolicy"
    typeStructuringElem = parameter[0]
    text = ''
    text = addToText(text, '###import PyIPSDK\n', not process)
    if typeStructuringElem == 'Default':
        text += paramName + '= PyIPSDK.eDFTScalePolicy.eDFTSP_Default\n'
        return [text, paramName]
    elif typeStructuringElem == 'Unitary':
        text += paramName + '= PyIPSDK.eDFTScalePolicy.eDFTSP_Unitary\n'
        return [text, paramName]
    elif typeStructuringElem == 'Custom':
        text += paramName + '= PyIPSDK.eDFTScalePolicy.eDFTSP_Custom\n'
        return [text,paramName,str(parameter[1]),str(parameter[2]),str(parameter[3])]
    else:
        print("ERROR : Arguments do not fit", file=sys.stderr)

dictSpecialToScript = {}
dictSpecialToScript['StructuringElement2D'] = structuringElement2D
dictSpecialToScript['StructuringElement3D'] = structuringElement3D
dictSpecialToScript['ScalePolicy2D'] = scalePolicy2D
dictSpecialToScript['ScalePolicy3D'] = scalePolicy3D