from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import UsefullVariables as vrb

import numpy as np

class SimpleHorizontalSliderLabel(qt.QGroupBox):

    SignalSliderEvent = QtCore.pyqtSignal()
    SignalReleasedEvent = QtCore.pyqtSignal()

    def __init__(self,**kwargs):

        qt.QGroupBox.__init__(self)

        if 'label' in kwargs:
            label=kwargs.pop('label')
        else:
            label=''
        if 'minimum' in kwargs:
            self.minimum=kwargs.pop('minimum')
        else:
            self.minimum=0
        if 'maximum' in kwargs:
            self.maximum=kwargs.pop('maximum')
        else:
            self.maximum=255
        if 'defaultValue' in kwargs:
            defaultValue=kwargs.pop('defaultValue')
            if defaultValue<self.minimum:
                defaultValue=self.minimum
            if defaultValue>self.maximum:
                defaultValue = self.maximum
        else:
            defaultValue=self.minimum
        if "ratio" in kwargs:
            self.ratio = kwargs.pop('ratio')
        else:
            self.ratio = 1
        if "titleSize" in kwargs:
            self.titleSize = kwargs.pop('titleSize')
        else:
            self.titleSize = 120*vrb.ratio
        if 'auto' in kwargs:
            self.auto=kwargs.pop('auto')
        else:
            self.auto=False
        if 'logarithmique' in kwargs:
            self.logarithmique=kwargs.pop('logarithmique')
        else:
            self.logarithmique=False
        if 'logarithmiqueCoeff' in kwargs:
            self.logarithmiqueCoeff=kwargs.pop('logarithmiqueCoeff')
        else:
            self.logarithmiqueCoeff=1
        if 'precision' in kwargs:
            self.precision=kwargs.pop('precision')
        else:
            self.precision=2
        if 'widthLabel' in kwargs:
            self.widthLabel=kwargs.pop('widthLabel')
        else:
            self.widthLabel=20*vrb.ratio

        self.title=qt.QLabel(label)
        # self.title.setStyleSheet("background-color: lightblue; color: black;")
        self.title.setAlignment(QtCore.Qt.AlignCenter)
        self.slider = qt.QSlider(QtCore.Qt.Horizontal)
        self.slider.setRange(self.minimum,self.maximum)
        self.slider.setValue(defaultValue)

        self.slider.mousePressed = False

        # if defaultValue == int(defaultValue) and self.ratio == 1 and self.logarithmique == False:
        #     valueLineEdit = int (defaultValue)
        # else:
        #     if self.logarithmique == False:
        #         valueLineEdit = defaultValue / self.ratio
        #     else:
        #         if defaultValue == self.minimum:
        #             valueLineEdit = defaultValue / self.ratio
        #         else:
        #             valueLineEdit = self.minimum + (np.exp(defaultValue-self.minimum)/np.exp(self.maximum-self.minimum)) * (self.maximum-self.minimum)
        #             valueLineEdit = valueLineEdit / self.ratio
        #
        # self.lineEditSliderValue = qt.QLabel(str(valueLineEdit))

        self.lineEditSliderValue = qt.QLabel()
        self.lineEditSliderValue.setAlignment(Qt.AlignCenter)
        self.lineEditSliderValue.setFixedWidth(self.widthLabel*vrb.ratio)

        if self.auto:
            self.buttonAuto = qt.QPushButton("Auto")
            self.buttonAuto.setFixedSize(35*vrb.ratio,25*vrb.ratio)


        self.layout = qt.QGridLayout()
        self.setLayout(self.layout)
        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setSizeConstraint(1)
        self.layout.setHorizontalSpacing(0)

        self.layout.addWidget(self.title, 0, 0)
        self.layout.addWidget(self.lineEditSliderValue, 0, 1)
        self.layout.addWidget(self.slider, 0, 2,Qt.AlignLeft)
        if self.auto:
            self.layout.addWidget(self.buttonAuto, 0, 3,Qt.AlignCenter)

        self.slider.valueChanged.connect(self.changeLineEdit)
        self.slider.sliderPressed.connect(self.sliderPressEvent)
        self.slider.sliderReleased.connect(self.sliderReleaseEvent)
        self.changeLineEdit()

    def resizeEvent(self, event):

        self.title.setFixedSize(self.titleSize,self.size().height()*100/100)
        if self.auto == False:
            self.slider.setFixedSize(max(1,self.size().width() -self.titleSize - self.widthLabel*vrb.ratio), self.size().height() * 100/ 100)
        else:
            self.slider.setFixedSize(max(1,self.size().width() -self.titleSize - self.widthLabel*vrb.ratio-40*vrb.ratio), self.size().height() * 100/ 100)
        self.lineEditSliderValue.setFixedSize(self.widthLabel*vrb.ratio, self.size().height() * 100 / 100)

    def changeLineEdit(self):


        if self.logarithmique:
            ratio = (self.slider.value()-self.minimum)/(self.maximum-self.minimum)
            ratio = (np.exp(ratio * self.logarithmiqueCoeff) - 1) / (np.exp(1 * self.logarithmiqueCoeff) - 1)
            value = self.minimum + ratio * (self.maximum-self.minimum)
        else:
            value = self.slider.value()
        value = int(value*10**self.precision/self.ratio)/10**self.precision
        if value == int(value):
            value = int(value)
        self.lineEditSliderValue.setText(str(value))

    def sliderPressEvent(self):

        self.slider.mousePressed = True

    def sliderReleaseEvent(self):

        self.slider.mousePressed = False

    # def mouseRelease(self):
    #
    #     if self.parent is not None:
    #         self.parent.mousePressed = False
    #         self.SignalReleasedEvent.emit()
    #
    # def mouseMoved(self):
    #
    #     if self.parent is not None:
    #         self.parent.mousePressed = True

class SimpleHorizontalSliderLineEdit(qt.QWidget):

    SignalSliderEvent = QtCore.pyqtSignal()

    def __init__(self,**kwargs):

        qt.QWidget.__init__(self)

        if 'label' in kwargs:
            label=kwargs.pop('label')
        else:
            label=''
        if 'minimum' in kwargs:
            self.minimum=kwargs.pop('minimum')
        else:
            self.minimum=0
        if 'maximum' in kwargs:
            self.maximum=kwargs.pop('maximum')
        else:
            self.maximum=255
        if 'defaultValue' in kwargs:
            defaultValue=kwargs.pop('defaultValue')
            if defaultValue<self.minimum:
                defaultValue=self.minimum
            if defaultValue>self.maximum:
                defaultValue = self.maximum
        else:
            defaultValue=self.minimum

        self.title=qt.QLabel(label)
        self.title.setAlignment(QtCore.Qt.AlignCenter)
        self.slider = qt.QSlider(QtCore.Qt.Horizontal)
        self.slider.setRange(self.minimum,self.maximum)
        self.slider.setValue(defaultValue)
        self.lineEditSliderValue = qt.QLineEdit(str(defaultValue))

        self.layout = qt.QGridLayout()
        self.setLayout(self.layout)
        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setSizeConstraint(1)

        self.layout.addWidget(self.title, 0, 0)
        self.layout.addWidget(self.slider, 0, 1)
        self.layout.addWidget(self.lineEditSliderValue, 0, 2)

        self.lineEditSliderValue.textChanged.connect(self.userChangeValue)
        self.slider.valueChanged.connect(self.changeLineEdit)

    def resizeEvent(self, event):

        self.title.setFixedSize(60*vrb.ratio,self.size().height()*90/100)
        self.slider.setFixedSize(max(1,self.size().width() -110*vrb.ratio), self.size().height() * 90 / 100)
        self.lineEditSliderValue.setFixedSize(30*vrb.ratio, self.size().height() * 90 / 100)

    def userChangeValue(self):

        if self.lineEditSliderValue.text()!='':
            newValue = int(self.lineEditSliderValue.text())
            newValue=max(self.minimum,newValue)
            newValue=min(newValue,self.maximum)
            self.lineEditSliderValue.setText(str(newValue))
            self.slider.setValue(newValue)

        self.SignalSliderEvent.emit()

    def changeLineEdit(self):
        self.lineEditSliderValue.setText(str(self.slider.value()))


if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    foo = SimpleHorizontalSliderLabel(ratio=255)
    foo.show()

    app.exec_()
