import sys
import os

from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication
import PyQt5.QtWidgets as qt
from PyQt5 import QtGui

import WidgetTypes
import UsefullWidgets as wgt
import UsefullVariables as vrb
import UsefullFunctionsForWidget as fctWidget

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet


class MyTreeWidgetItem(qt.QTreeWidgetItem):

    def __init__(self, widget):
        super(MyTreeWidgetItem, self).__init__()
        self.widget = widget

        self.checkBox = self.widget.checkBox

        self.widget.SignalStateChanged.connect(self.checkBoxChanged)

    def checkBoxChanged(self):

        for nb in range(self.childCount()):
            # All children at the same state
            childCheckBox = self.child(nb).checkBox
            if self.child(nb).widget.isEnabled():
                childCheckBox.setCheckState(self.checkBox.checkState())
            else:
                childCheckBox.setCheckState(0)
        for nb in range(self.childCount()):
            self.child(nb).checkBoxChanged()

        if self.parent() is not None:
            self.parent().checkChildrenState()

    def checkChildrenState(self):
        allTrue = True
        allFalse = True
        for nb2 in range(self.childCount()):
            if self.child(nb2).widget.isEnabled():
                if self.child(nb2).checkBox.checkState() == 0:
                    allTrue = False
                elif self.child(nb2).checkBox.checkState() == 1:
                    allFalse = False
                    allTrue = False
                elif self.child(nb2).checkBox.checkState() == 2:
                    allFalse = False
        if allTrue and not allFalse:
            self.checkBox.setCheckState(2)
        elif not allTrue and allFalse:
            self.checkBox.setCheckState(0)
        else:
            self.checkBox.setCheckState(1)
        if self.parent() is not None:
            self.parent().checkChildrenState()

    def saveMeasure(self):
        self.widget.xmlElement.set('CheckState', str(self.checkBox.checkState()))
        for nb in range(self.childCount()):
            self.child(nb).saveMeasure()


class MeasureLabel(qt.QGroupBox):
    SignalStateChanged = pyqtSignal()

    def __init__(self, xmlElement, name, triState=False):
        super().__init__()
        self.xmlElement = xmlElement
        self.checkBox = qt.QCheckBox()
        self.checkBox.setTristate(triState)
        # self.checkBox.setFixedSize(11*vrb.ratio,11*vrb.ratio)
        self.checkBox.setFixedSize(11*vrb.ratio,11*vrb.ratio)
        self.label = qt.QLabel(name)
        self.label.setFixedHeight(15*vrb.ratio)
        self.label.setAlignment(Qt.AlignTop)
        self.label.setStyleSheet('QLabel {background-color: transparent;}')

        self.layout = qt.QGridLayout()
        self.layout.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
        self.layout.addWidget(self.checkBox, 0, 0)
        self.layout.addWidget(self.label, 0, 1)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)
        self.checkBox.clicked.connect(self.correctState)
        self.label.mousePressEvent = self.emitClicked

    def correctState(self):

        if self.checkBox.checkState() == 1:
            self.checkBox.setCheckState(2)
        self.SignalStateChanged.emit()

        try:
            self.treeWidget.setCurrentItem(self.item)
        except:
            pass

    def emitClicked(self,event):

        self.SignalStateChanged.emit()

        try:
            self.treeWidget.setCurrentItem(self.item)
        except:
            import traceback
            traceback.print_exc(file=sys.stderr)
            pass


class CustomTreeWidgetItem(MyTreeWidgetItem):

    def __init__(self, xmlElement, isButton=True, parentItem=None,checkMeasure=False):
        self.isButton = isButton
        if self.isButton:
            self.widget = PlusButton(xmlElement, parentItem)
        else:
            self.widget = CustomMeasureLabel(xmlElement, self,checkMeasure=checkMeasure)
            self.widget.item = self
        super(CustomTreeWidgetItem, self).__init__(self.widget)

    def saveMeasure(self):
        self.widget.xmlElement.set('CheckState', str(self.checkBox.checkState()))


class CustomMeasureLabel(MeasureLabel):
    SignalDeleteClicked = pyqtSignal(MeasureLabel)
    SignalEditClicked = pyqtSignal(xmlet.Element)

    def __init__(self, xmlElement, treeItem,checkMeasure=False):
        super(CustomMeasureLabel, self).__init__(xmlElement, Dfct.childText(xmlElement, 'UserName'), triState=False)
        self.treeItem = treeItem

        if checkMeasure:
            self.checkBox.setCheckState(2)
        else:
            self.checkBox.setCheckState(int(xmlElement.get('CheckState')))

        # self.labelButtonEdit = wgt.LabelEdit()
        # self.labelButtonEdit.setFixedSize(15,15)
        # font = QtGui.QFont()
        # font.setPixelSize(12)
        # self.labelButtonEdit.setFont(font)
        #
        # self.labelButtonDelete = wgt.LabelDelete()

        self.labelButtonEdit = wgt.PushButtonImage(vrb.folderImages + "/Edit_3.png", margins=1)
        self.labelButtonEdit.setFixedSize(13*vrb.ratio, 13*vrb.ratio)
        self.labelButtonEdit.setStyleSheet('PushButtonImage {background-color: transparent;border: 0px transparent;}')
        self.labelButtonEdit.setToolTip("Edit this measure")

        self.labelButtonDelete = wgt.PushButtonImage(vrb.folderImages + "/Delete.png", margins=1)
        self.labelButtonDelete.setFixedSize(13*vrb.ratio, 13*vrb.ratio)
        self.labelButtonDelete.setStyleSheet('PushButtonImage {background-color: transparent;border: 0px transparent;}')
        self.labelButtonDelete.setToolTip("Delete this measure")

        self.layout.addWidget(self.labelButtonEdit, 0, self.layout.count(), Qt.AlignRight)
        self.layout.addWidget(self.labelButtonDelete, 0, self.layout.count(), Qt.AlignRight)
        self.layout.setContentsMargins(0, 0, 0, 0)

        self.labelButtonDelete.clicked.connect(self.emitSignalDeleteClicked)
        self.labelButtonEdit.clicked.connect(self.emitSignalEditClicked)

    def emitSignalDeleteClicked(self):
        self.SignalDeleteClicked.emit(self)

    def emitSignalEditClicked(self):
        self.labelButtonEdit.setEnabled(False)
        self.SignalEditClicked.emit(self.xmlElement)


class PlusButton(qt.QWidget):
    SignalStateChanged = pyqtSignal()

    def __init__(self, xmlElement, parentItem):
        super().__init__()
        self.xmlElement = xmlElement
        self.checkBox = FakeCheckBox(parentItem)
        self.pushButtonPlus = wgt.PushButtonImage(vrb.folderImages + "/Add_3.png", margins=0)
        self.pushButtonPlus.setStyleSheet('PushButtonImage {background-color: transparent;border: 0px transparent;}')
        self.pushButtonPlus.setFixedSize(20*vrb.ratio,15*vrb.ratio)
        self.pushButtonPlus.xmlElement = self.xmlElement

        self.layout = qt.QGridLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.layout.addWidget(self.pushButtonPlus, 0, 1)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)


class FakeCheckBox:
    def __init__(self, parentItem):
        self.parentItem = parentItem

    def checkState(self):
        nbChild = self.parentItem.childCount()
        if nbChild == 1:
            # The + button is the only child
            return self.parentItem.widget.checkBox.checkState()
        for nb in range(self.parentItem.childCount()):
            siblingItem = self.parentItem.child(nb)
            if siblingItem.widget.checkBox != self:
                if siblingItem.widget.checkBox.checkState() == 0:
                    return 0
        return 2

    def setCheckState(self, _):
        pass
