import sys,traceback
import os
import webbrowser

import PyQt5.QtCore as QtCore
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication
import PyQt5.QtWidgets as qt
from PyQt5 import QtGui

import WidgetTypes
import UsefullVariables as vrb
import UsefullFunctionsForWidget as fctWidget
import UsefullFunctions as fct
import UsefullWidgets as wgt
from CustomShapeAnalysisWidget import CustomShapeAnalysisWidget
from ShapeAnalysisTreeItemsWidgets import MyTreeWidgetItem, MeasureLabel, CustomTreeWidgetItem

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from FilterWidget import FilterWidget
from SieveWidget import ComboBoxSieveWithButton

from ConversionIPSDK import dictConversion

import PyIPSDK
import PyIPSDK.IPSDKUI as ui
import PyIPSDK.IPSDKFunctionsMachineLearning as fctML

import random as random

import numpy as np

import time

class ShapeAnalysisDisplayer(qt.QWidget):

    def __init__(self, xmlElement, infoset):
        super(ShapeAnalysisDisplayer, self).__init__()

        self.xmlElement = xmlElement
        try:
            self.xmlAllMeasures = extractXmlAllMeasuresFromElement(self.xmlElement)
        except:
            self.xmlAllMeasures = None
        self.dictResults = {}

        # infoset.xmlElement = self.xmlAllMeasures

        self.infoSet = infoset

        if type(self.infoSet) == WidgetTypes.IPSDKType.SHAPEANALYSIS.value:
            self.filterWidget = FilterWidget(infoSet=self.infoSet)
            self.buttonFilter = wgt.PushButtonImage(vrb.folderImages + "/Filter.png", margins=2)
            self.buttonFilter.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
            self.buttonFilter.setToolTip("Open filter edition")

        self.buttonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=2)
        self.buttonSave.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonSave.setToolTip("Save analysis")
        emptyLabel1 = qt.QLabel()
        emptyLabel1.setFixedWidth(20*vrb.ratio)
        self.buttonHistogram = wgt.PushButtonImage(vrb.folderImages + "/Histogram_2.png", margins=2)
        self.buttonHistogram.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonHistogram.setToolTip("Display the histogram of a measure")
        self.buttonHistogram.setEnabled(False)
        self.comboBoxSieve = ComboBoxSieveWithButton(None,None)
        self.comboBoxSieve.setFixedWidth(150*vrb.ratio)
        vrb.sievesComboBox.append(self.comboBoxSieve)
        fct.updateSievesComboBox()

        emptyLabel2 = qt.QLabel()
        emptyLabel2.setFixedWidth(20*vrb.ratio)

        font = QtGui.QFont()
        font.setPixelSize(12*vrb.ratio)
        self.labelNumberElement = qt.QLabel()
        self.labelNumberElement.setFont(font)
        self.labelNumberElement.setAlignment(Qt.AlignHCenter)
        self.labelNumberElement.setFixedWidth(250*vrb.ratio)

        self.bottomTableWidget = UsefulInfoTableWidget()
        self.tableWidget = MeasureInfoTable(self.bottomTableWidget,self)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.buttonSave, 0, 0)
        if type(self.infoSet) == WidgetTypes.IPSDKType.SHAPEANALYSIS.value:
            self.layout.addWidget(self.buttonFilter, 0, 1)
            self.layout.addWidget(emptyLabel1, 0, 2)
            self.layout.addWidget(self.buttonHistogram, 0, 3)
            self.layout.addWidget(self.comboBoxSieve, 0, 4)
            self.layout.addWidget(emptyLabel2, 0, 5)
            self.layout.addWidget(self.labelNumberElement, 0, 6,Qt.AlignLeft)
            self.layout.addWidget(self.tableWidget, 1, 0,1,7)
            self.layout.addWidget(self.bottomTableWidget, 2, 0,1,7,Qt.AlignTop)
        else:
            self.layout.addWidget(self.buttonHistogram, 0, 1)
            self.layout.addWidget(self.comboBoxSieve, 0, 2)
            self.layout.addWidget(emptyLabel2, 0, 3)
            self.layout.addWidget(self.labelNumberElement, 0, 4, Qt.AlignLeft)
            self.layout.addWidget(self.tableWidget, 1, 0, 1, 5)
            self.layout.addWidget(self.bottomTableWidget, 2, 0, 1, 5, Qt.AlignTop)
        self.setLayout(self.layout)

        self.layout.setVerticalSpacing(20)
        self.layout.setSizeConstraint(1)

        self.dictResults = self.createDict()
        self.tableWidget.loadDict()
        self.buttonSave.clicked.connect(self.saveFileResult)
        if type(self.infoSet) == WidgetTypes.IPSDKType.SHAPEANALYSIS.value:
            self.buttonFilter.clicked.connect(self.openFilterWidget)
        self.buttonHistogram.clicked.connect(self.tableWidget.showHistogram)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.resize(600*vrb.ratio,800*vrb.ratio)

        self.setWindowTitle(Dfct.childText(xmlElement,"Name"))

    def resizeEvent(self, a0: QtGui.QResizeEvent):

        # self.labelNumberElement.setFixedWidth(max(1,self.width()-110 * vrb.ratio))

        self.bottomTableWidget.setFixedHeight(200*vrb.ratio)
        self.tableWidget.setFixedHeight(max(1,self.height()-300*vrb.ratio))

    def createDict(self):

        if type(self.infoSet) == WidgetTypes.IPSDKType.SHAPEANALYSIS.value:
            dictResults = self.createDictFromInfoset()
        elif type(self.infoSet) == WidgetTypes.IPSDKType.SHAPEANALYSIS_MULTISLICE.value:
            dictResults = self.createDictFromInfosetMultiSlice()
        else:
            dictResults = self.createDictFromListInfoset()

        return dictResults

    def createDictFromListInfoset(self):

        listLabelInfoset = self.infoSet
        nameList = []
        for labelInfoset in listLabelInfoset:
            try:
                if labelInfoset.nameImage != "":
                    name = labelInfoset.nameImage
                else:
                    name = labelInfoset.name
            except:
                name = labelInfoset.name
            nameList.append(name)

        allKeys = []
        for labelInfoset in listLabelInfoset:
            keysInfoset = []
            for msr in labelInfoset.object.getMeasureInfoSet().getMeasureInfoColl():
                key = msr.key()
                if "->" not in key and "___" not in key:
                    keysInfoset.append(key)
            allKeys.append(keysInfoset)

        sharedKeys = []
        for key in allKeys[0]:
            keepKey = True
            for numInfoset in range(len(listLabelInfoset)):
                if key not in allKeys[numInfoset]:
                    keepKey = False
            if keepKey:
                sharedKeys.append(key)

        dictResults = {}
        indexOffset = 0
        nameFirstColumn = "Index"

        for imageNum in range(len(listLabelInfoset)):
            infoSet = listLabelInfoset[imageNum].object

            indexNum = 0
            nbShapes = infoSet.getNbEntities()

            ind = range(1, nbShapes)
            indNames = []
            nameImage = []
            for i in ind:
                indNames.append(str(i + indexOffset))
                nameImage.append(nameList[imageNum])

            if imageNum == 0:
                dictResults[0] = {}
                dictResults[0]["CallName"] = nameFirstColumn
                dictResults[0]["UserName"] = nameFirstColumn
                dictResults[0]["Values"] = indNames
                dictResults[0]["Unit"] = ""
            else:
                dictResults[0]["Values"] = dictResults[0]["Values"] + indNames

            indexOffset += nbShapes - 1

            if imageNum == 0:
                allMeasures = []
                for key in sharedKeys:
                    userName, isFound = fct.findUserName(key)
                    allMeasures.append((key, userName))

            for callName, userName in allMeasures:

                if "->" not in userName and "___" not in userName:
                    try:
                        valuesInfosetColl = infoSet.getMeasure(callName).getMeasureResult()
                        nbColorPlan = valuesInfosetColl.getNbColorPlans()

                        for colorPlan in range(nbColorPlan):
                            valuesInfoset = infoSet.getMeasure(callName).getMeasureResult().getColl(colorPlan)
                            values = []
                            for valueIndex in range(1, len(valuesInfoset)):
                                values.append(valuesInfoset[valueIndex])

                            indexNum += 1

                            if nbColorPlan == 1:
                                newUserName = userName
                            elif nbColorPlan == 3:
                                newUserName = userName + " (" + vrb.colorsVector[colorPlan] + ")"
                            else:
                                newUserName = userName + " (Channel " + str(colorPlan) + ")"

                            if imageNum == 0:
                                dictResults[indexNum] = {}
                                dictResults[indexNum]["CallName"] = callName
                                dictResults[indexNum]["UserName"] = newUserName
                                dictResults[indexNum]["Values"] = values

                                if infoSet.getMeasure(callName).getMsrUnitStr() != "" and infoSet.getMeasure(callName).getMsrUnitStr() is not None:
                                    unit = " (" + infoSet.getMeasure(callName).getMsrUnitStr() + ")"
                                    unit = unit.replace('^2', '²')
                                    unit = unit.replace('^3', '³')
                                else:
                                    unit = ""
                                dictResults[indexNum]["Unit"] = unit
                            else:
                                dictResults[indexNum]["Values"] = dictResults[indexNum]["Values"] + values

                    except:
                        pass

            if imageNum == 0:
                dictResults[indexNum + 1] = {}
                dictResults[indexNum + 1]["CallName"] = "Name image"
                dictResults[indexNum + 1]["UserName"] = "Name image"
                dictResults[indexNum + 1]["Values"] = nameImage
                dictResults[indexNum + 1]["Unit"] = ""
            else:
                dictResults[indexNum + 1]["Values"] = dictResults[indexNum + 1]["Values"] + nameImage

        return dictResults

    def createDictFromInfosetMultiSlice(self):

        xmlAllMeasures = self.xmlAllMeasures
        infoSet_MultiSlice = self.infoSet

        dictResults = {}
        indexOffset = 0

        dictAnalysis = PyIPSDK.toPyDict(infoSet_MultiSlice)

        nameFirstColumn = "Index"

        sizeZ = 0
        sizeT = 0
        for z, c, t in dictAnalysis:
            sizeZ = max(sizeZ, z)
            sizeT = max(sizeT, t)
        sizeZ += 1
        sizeT += 1

        for planNum in range(sizeZ):
            for sequenceNum in range(sizeT):

                try:
                    infoSet = dictAnalysis[(planNum, 0, sequenceNum)]
                    indexNum = 1
                    nbShapes = infoSet.getNbEntities()

                    ind = range(1, nbShapes)
                    indNames = []
                    numPlan = []
                    numSequence = []
                    for i in ind:
                        indNames.append(str(i+indexOffset))
                        if sizeZ > 1:
                            numPlan.append(planNum)
                        if sizeT>1:
                            numSequence.append(sequenceNum)

                    if planNum == 0 and sequenceNum == 0:
                        dictResults[0] = {}
                        dictResults[0]["CallName"] = nameFirstColumn
                        dictResults[0]["UserName"] = nameFirstColumn
                        dictResults[0]["Values"] = indNames
                        dictResults[0]["Unit"] = ""

                        dictResults[1] = {}
                        dictResults[1]["CallName"] = "Ref_Barycenter_Z"
                        dictResults[1]["UserName"] = "Ref_Barycenter_Z"
                        dictResults[1]["Values"] = numPlan
                        dictResults[1]["Unit"] = ""

                    else:
                        dictResults[0]["Values"] = dictResults[0]["Values"] + indNames
                        dictResults[1]["Values"] = dictResults[1]["Values"] + numPlan

                    indexOffset+=nbShapes-1

                    if planNum == 0 and sequenceNum == 0:
                        if xmlAllMeasures is not None:
                            generator = measureIterator(xmlAllMeasures)
                            allMeasures = []
                            for callName, userName in generator:
                                allMeasures.append((callName, userName))
                            allMeasures.append(("Ref_Barycenter_X", "Ref_Barycenter_X"))
                            allMeasures.append(("Ref_Barycenter_Y", "Ref_Barycenter_Y"))
                        else:
                            allMeasures = []
                            for msr in infoSet.getMeasureInfoSet().getMeasureInfoColl():
                                key = msr.key()
                                userName, isFound = fct.findUserName(key)
                                allMeasures.append((key, userName))

                    for callName, userName in allMeasures:

                        if "->" not in userName and "___" not in userName:
                            try:
                                valuesInfosetColl = infoSet.getMeasure(callName).getMeasureResult()
                                nbColorPlan = valuesInfosetColl.getNbColorPlans()

                                for colorPlan in range(nbColorPlan):
                                    valuesInfoset = infoSet.getMeasure(callName).getMeasureResult().getColl(colorPlan)
                                    values = []
                                    for valueIndex in range(1, len(valuesInfoset)):
                                        values.append(valuesInfoset[valueIndex])

                                    indexNum += 1

                                    if nbColorPlan == 1:
                                        newUserName = userName
                                    elif nbColorPlan == 3:
                                        newUserName = userName + " (" + vrb.colorsVector[colorPlan] + ")"
                                    else:
                                        newUserName = userName + " (Channel " + str(colorPlan) + ")"

                                    if planNum == 0 and sequenceNum == 0:
                                        dictResults[indexNum] = {}
                                        dictResults[indexNum]["CallName"] = callName
                                        dictResults[indexNum]["UserName"] = newUserName
                                        dictResults[indexNum]["Values"] = values

                                        if infoSet.getMeasure(callName).getMsrUnitStr() != "" and infoSet.getMeasure(callName).getMsrUnitStr() is not None:
                                            unit = " (" + infoSet.getMeasure(callName).getMsrUnitStr() + ")"
                                            unit = unit.replace('^2', '²')
                                            unit = unit.replace('^3', '³')
                                        else:
                                            unit = ""
                                        dictResults[indexNum]["Unit"] = unit
                                    else:
                                        dictResults[indexNum]["Values"] = dictResults[indexNum]["Values"] + values

                            except:
                                pass

                    if sizeZ > 1:
                        if planNum == 0 and sequenceNum == 0:
                            dictResults[indexNum+1] = {}
                            dictResults[indexNum+1]["CallName"] = "Num plan"
                            dictResults[indexNum+1]["UserName"] = "Num plan"
                            dictResults[indexNum+1]["Values"] = numPlan
                            dictResults[indexNum+1]["Unit"] = ""
                        else:
                            dictResults[indexNum+1]["Values"] = dictResults[indexNum+1]["Values"] + numPlan
                        indexNum+=1

                    if sizeT > 1:
                        if planNum == 0 and sequenceNum == 0:
                            dictResults[indexNum+1] = {}
                            dictResults[indexNum+1]["CallName"] = "Num sequence"
                            dictResults[indexNum+1]["UserName"] = "Num sequence"
                            dictResults[indexNum+1]["Values"] = numSequence
                            dictResults[indexNum+1]["Unit"] = ""
                        else:
                            dictResults[indexNum+1]["Values"] = dictResults[indexNum+1]["Values"] + numSequence

                except:
                    traceback.print_exc(file=sys.stderr)

        return dictResults

    def createDictFromInfoset(self):

        xmlAllMeasures = self.xmlAllMeasures
        infoSet = self.infoSet

        dictResults = {}
        indexNum = 0

        nbShapes = infoSet.getNbEntities()

        try:
            file = xmlet.parse(vrb.folderInformation + "/UserLabels.mho")
            xmlElement = file.getroot()
        except:
            xmlElement = xmlet.Element('UserLabels')

        nameFirstColumn = "Index"

        dictLabels = {}
        try:
            imageLabel = infoSet.imageLabel
            dictLabels = fctML.readSmartSegmentation(imageLabel)
            if dictLabels != {}:
                nameFirstColumn = "Name"
        except:
            pass
        if dictLabels == {}:
            nbDefineLabel = len(xmlElement)
            if nbShapes -1 <= nbDefineLabel:
                nameFirstColumn = "Name"

        ind = range(1, nbShapes)
        indNames = []
        for i in ind:
            if nameFirstColumn == "Index":
                indName = str(i)
            else:
                if dictLabels != {}:
                    try:
                        indName = dictLabels[i]["Name"]
                    except:
                        indName = "Label " + str(i)
                else:
                    childLabel = Dfct.SubElement(xmlElement, "Label_" + str(i))
                    indName = Dfct.childText(childLabel, "Name")
                    if indName is None:
                        indName = "Label "+str(i)
            indNames.append(indName)

        dictResults[0] = {}
        dictResults[0]["CallName"] = nameFirstColumn
        dictResults[0]["UserName"] = nameFirstColumn
        dictResults[0]["Values"] = indNames
        dictResults[0]["Unit"] = ""

        if xmlAllMeasures is not None:
            generator = measureIterator(xmlAllMeasures)
            allMeasures = []
            for callName, userName in generator:
                allMeasures.append((callName,userName))
            allMeasures.append(("Ref_Barycenter_X","Ref_Barycenter_X"))
            allMeasures.append(("Ref_Barycenter_Y","Ref_Barycenter_Y"))
            allMeasures.append(("Ref_Barycenter_Z","Ref_Barycenter_Z"))
        else:
            allMeasures = []
            for msr in infoSet.getMeasureInfoSet().getMeasureInfoColl():
                key = msr.key()
                userName,isFound = fct.findUserName(key)
                allMeasures.append((key,userName))

        for callName, userName in allMeasures:

            if "->" not in userName and "___" not in userName:
                try:
                    valuesInfosetColl = infoSet.getMeasure(callName).getMeasureResult()
                    nbColorPlan = valuesInfosetColl.getNbColorPlans()

                    for colorPlan in range(nbColorPlan):

                        valuesInfoset = infoSet.getMeasure(callName).getMeasureResult().getColl(colorPlan)
                        values = []
                        for valueIndex in range(1,len(valuesInfoset)):
                            values.append(valuesInfoset[valueIndex])

                        indexNum += 1

                        if nbColorPlan == 1:
                            newUserName = userName
                        elif nbColorPlan == 3:
                            newUserName = userName + " (" + vrb.colorsVector[colorPlan] + ")"
                        else:
                            newUserName = userName + " (Channel " + str(colorPlan) + ")"

                        dictResults[indexNum]={}
                        dictResults[indexNum]["CallName"] = callName
                        dictResults[indexNum]["UserName"] = newUserName
                        dictResults[indexNum]["Values"] = values

                        if infoSet.getMeasure(callName).getMsrUnitStr() != "" and infoSet.getMeasure(callName).getMsrUnitStr() is not None:
                            unit = " (" + infoSet.getMeasure(callName).getMsrUnitStr() + ")"
                            unit = unit.replace('^2', '²')
                            unit = unit.replace('^3', '³')
                        else:
                            unit = ""

                        dictResults[indexNum]["Unit"] = unit

                except:
                    pass
                    # traceback.print_exc(file=sys.stderr)

        return dictResults

    def openFilterWidget(self):

        self.filterWidget.show()
        self.filterWidget.measureSelection.rangeSlider.setValues(self.filterWidget.measureSelection.rangeSlider.currentValueMin, self.filterWidget.measureSelection.rangeSlider.currentValueMax)

    def display(self, xmlElement, boolShow=True):
        if boolShow:
            if self.isMaximized():
                self.showMaximized()
            else:
                self.showNormal()
            self.window().raise_()
            self.window().activateWindow()

        # try:
        #     self.tableWidget.setColumnWidth(1,100*vrb.ratio)
        # except:
        #     pass

        try:
            self.tableWidget.loadDict()
        except:
            pass

        # self.tableWidget.usefulInfoTableWidget.setColumnWidth(1, self.tableWidget.columnWidth(1))

    def stopDisplay(self):
        self.close()

    def saveFileResult(self):

        dictToSave = fct.convertDictForSaveAnalysis(self.dictResults)

        filename = qt.QFileDialog.getSaveFileName(self, "Save file as", "","(*.xls);;(*.csv)")
        if filename[1] == "(*.xls)":
            fct.dictToXlsFile(dictToSave,filename[0])
            # fct.convertToXlsFile(self.tableWidget,filename[0])
        if filename[1] == "(*.csv)":
            fct.dictToCsvFile(dictToSave,filename[0])
            # fct.convertToCsvFile(self.tableWidget,filename[0])

class MeasureInfoTable(qt.QTableWidget):
    def __init__(self, usefulInfoTableWidget,parent):
        super(MeasureInfoTable, self).__init__()

        self.parent=parent
        self.currentColumnIndex = None
        self.order = True
        self.resizeInfoTable = True

        self.usefulInfoTableWidget = usefulInfoTableWidget
        # self.horizontalHeader().setVisible(True)
        self.verticalHeader().setVisible(False)

        self.setAlternatingRowColors(True)
        self.horizontalScrollBar().setVisible(False)
        self.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)

        self.horizontalHeader().sectionResized.connect(self.resizeUsefulInfoColumns)

        self.usefulInfoTableWidget.horizontalScrollBar().valueChanged.connect(self.horizontalScrollBar().setValue)
        # self.itemPressed.connect(self.cellClicked)
        self.horizontalHeader().sectionClicked.connect(self.cellHeaderClicked)

        # self.horizontalHeader().setSectionResizeMode(qt.QHeaderView.ResizeToContents)
        self.horizontalHeader().setStretchLastSection(True)

        self.itemPressed.connect(self.cellClick)

    def resizeEvent(self, event):

        self.resizeInfoTable = False

        sizeFirstColumn = 70*vrb.ratio

        self.setColumnWidth(0,sizeFirstColumn-1)
        self.setColumnWidth(0,sizeFirstColumn)

        nbColumn = self.columnCount()
        if nbColumn > 1:
            sizeColumn = (self.width()-sizeFirstColumn-10*vrb.ratio)/(nbColumn-1)
            sizeColumn = max(sizeColumn,120*vrb.ratio)
            for i in range(1,nbColumn):
                self.setColumnWidth(i, sizeColumn-1)
                self.setColumnWidth(i, sizeColumn)

        self.resizeInfoTable = True

        self.resizeUsefulInfoColumns()

        qt.QApplication.processEvents()

    # def showEvent(self, a0: QtGui.QShowEvent) -> None:
    #     # used to change resize mode once the content is already beautifully displayed
    #     self.horizontalHeader().setSectionResizeMode(qt.QHeaderView.ResizeToContents)
    #     super().showEvent(a0)
    #     self.horizontalHeader().setSectionResizeMode(qt.QHeaderView.Interactive)
    #     self.setColumnWidth(0,60)

    # def resizeUsefulInfoColumns(self, column: int, oldWidth: int, newWidth: int):
    def resizeUsefulInfoColumns(self):

        if self.resizeInfoTable:
            for i in range(self.columnCount()):
                width = self.columnWidth(i)
                self.usefulInfoTableWidget.setColumnWidth(i,width)

    def cellClick(self,cellItem):

        try:
            dictResults = self.parent.dictResults
            infoset = self.parent.infoSet

            if type(infoset) == WidgetTypes.IPSDKType.SHAPEANALYSIS.value or type(infoset) == WidgetTypes.IPSDKType.SHAPEANALYSIS_MULTISLICE.value:

                try:
                    currentInfoset = vrb.mainWindow.widgetImage.imageOverlayLabel.image.infoSet
                    image = vrb.mainWindow.widgetImage.imageOverlay
                except:
                    currentInfoset = vrb.mainWindow.currentLabel.image.infoSet
                    image = vrb.mainWindow.widgetImage.image

                if currentInfoset == infoset:

                    if image.hasGeometricCalibration():
                        calib = image.getGeometricCalibration()
                        xScale = calib.getXScale()
                        yScale = calib.getYScale()
                        zScale = calib.getZScale()
                    else:
                        xScale = 1
                        yScale = 1
                        zScale = 1

                    try:
                        index = int(self.item(cellItem.row(),0).text())-1
                        for num in dictResults:
                            if dictResults[num]["CallName"] == "Ref_Barycenter_X":
                                valuesX = dictResults[num]["Values"]
                                vrb.barycenterX = valuesX[index] / xScale
                            if dictResults[num]["CallName"] == "Ref_Barycenter_Y":
                                valuesY = dictResults[num]["Values"]
                                vrb.barycenterY = valuesY[index] / yScale
                            if dictResults[num]["CallName"] == "Ref_Barycenter_Z":
                                try:
                                    valuesZ = dictResults[num]["Values"]
                                    vrb.barycenterZ = valuesZ[index] / zScale

                                except:
                                    traceback.print_exc(file=sys.stderr)

                        try:
                            image = vrb.mainWindow.currentLabel.image
                            if image.getSizeZ() > 1:
                                if vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                                    vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.setValue(vrb.barycenterX)
                                if vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                                    vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.setValue(vrb.barycenterY)
                                if vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                                    vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.setValue(vrb.barycenterZ)
                        except:
                            pass

                    except:
                        pass
                    vrb.currentShapeAnalysisDisplayer = self.parent

                    vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)

        except:
            traceback.print_exc(file=sys.stderr)

        self.verifHistogram()

    def loadDict(self):

        try:

            dictResults = self.parent.dictResults

            self.usefulInfoTableWidget.initTable()
            random.seed()

            nbMeasures=0
            for idx in dictResults:
                if dictResults[idx]["CallName"] not in ["Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:
                    nbMeasures+=1
            nbShapes = len(dictResults[0]["Values"])

            try:
                file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
                settingsElement = file.getroot()
            except:
                settingsElement = xmlet.Element('Settings')
            try:
                for child in settingsElement:
                    if child.tag == "NbShapes":
                        elementNbShapes = child
                nbShapesToDisplay = int(elementNbShapes.text)
            except:
                nbShapesToDisplay = 100

            if nbShapesToDisplay < nbShapes:
                self.parent.labelNumberElement.setText("Number of labels : "+str(nbShapes) + " (only "+str(nbShapesToDisplay) + " displayed)")
            else:
                self.parent.labelNumberElement.setText("Number of labels : " + str(nbShapes))

            nbShapesToDisplay = min(nbShapesToDisplay,nbShapes)

            self.setRowCount(nbShapesToDisplay)  # header
            # self.setRowCount(nbShapes)  # header
            self.setColumnCount(nbMeasures)

            if self.currentColumnIndex is None:
                self.currentColumnIndex = 0

            if self.order:
                prefix = " ▼"
            else:
                prefix = " ▲"

            if self.currentColumnIndex is None or self.currentColumnIndex == 0:
                ind = range(nbShapes)
            else:
                try:
                    values = dictResults[self.currentColumnIndex]["Values"]
                    values = np.asarray(values)
                    ind = np.argsort(values)
                    # ind+=1
                except:
                    traceback.print_exc(file=sys.stderr)
                    ind = range(nbShapes)

            ind = [int(i) for i in ind]
            if self.order == False:
                ind = ind[::-1]

            if len(ind)>nbShapesToDisplay:
                ind = ind[:nbShapesToDisplay]

            numCol = 0

            for indexCol in range(len(dictResults)):

                try:
                    if dictResults[indexCol]["CallName"] not in ["Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:

                        values = dictResults[indexCol]["Values"]

                        userName = dictResults[indexCol]["UserName"]
                        if "Unit" in dictResults[indexCol]:
                            userName += dictResults[indexCol]["Unit"]
                        if numCol == self.currentColumnIndex:
                            userName += prefix

                        cell = qt.QTableWidgetItem(userName)
                        self.setHorizontalHeaderItem(numCol, cell)

                        columnColor = randomPastelColor(numCol)
                        columnColorDarker = columnColor.darker(120)
                        cell.setBackground(columnColor)

                        row = 0
                        valuesApprox = []

                        for i in ind:

                            try:
                                if isinstance(values[i], type(True)):
                                    cell = qt.QTableWidgetItem(str(values[i]))
                                    cell.setTextAlignment(Qt.AlignRight)
                                    valuesApprox.append(values[i])
                                else:
                                    cell = qt.QTableWidgetItem(fct.numberCalibration(values[i]))
                                    cell.setTextAlignment(Qt.AlignRight)
                                    valuesApprox.append(float(fct.numberCalibration(values[i])))
                            except:
                                cell = qt.QTableWidgetItem(str(values[i]))
                                cell.setTextAlignment(Qt.AlignRight)
                                valuesApprox.append(values[i])
                            cell.setBackground((columnColor, columnColorDarker)[row % 2 == 0])
                            self.setItem(row, numCol, cell)
                            row += 1

                        if numCol!=0:
                            # self.usefulInfoTableWidget.addRecapColumn(valuesApprox, columnColor)
                            self.usefulInfoTableWidget.addRecapColumn(values, columnColor)

                        numCol+=1

                except:
                    traceback.print_exc(file=sys.stderr)

            self.usefulInfoTableWidget.setColumnWidth(0, self.columnWidth(0))

        except:
            traceback.print_exc(file=sys.stderr)

        self.resizeUsefulInfoColumns()

    def cellHeaderClicked(self,numCol):

        if numCol == self.currentColumnIndex:
            self.order = not self.order
        else:
            self.currentColumnIndex = numCol

        self.loadDict()
        self.selectColumn(numCol)

        self.verifHistogram()

    def verifHistogram(self):

        try:
            numColumnSelected = self.selectedIndexes()[0].column()
            name = self.parent.dictResults[numColumnSelected]["CallName"]
            self.parent.buttonHistogram.setEnabled(name != "Index")
        except:
            pass

    def showHistogram(self):

        try:

            numColumnSelected = self.selectedIndexes()[0].column()
            dictResults = self.parent.dictResults
            nameMsr = ""
            currentNum = 0
            numMsr = 0
            for idx in self.parent.dictResults:
                if dictResults[idx]["CallName"] not in ["Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:
                    if numMsr == numColumnSelected:
                        nameMsr = dictResults[idx]["CallName"]
                        currentNum = idx
                    numMsr+=1

            if type(self.parent.infoSet) == WidgetTypes.IPSDKType.SHAPEANALYSIS.value:

                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'HistogramOfMeasure'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
                paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
                typeNode = Dfct.SubElement(paramNode0, 'Type')
                typeNode.text = "ShapeAnalysis"
                valueNode = Dfct.SubElement(paramNode0, 'Value')
                valueNode.text = Dfct.childText(self.parent.xmlElement, 'ElementID')
                valueNode.set('isElementID', str(True))

                paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                typeNode = Dfct.SubElement(paramNode1, 'Type')
                typeNode.text = "Enumerate"
                valueNode = Dfct.SubElement(paramNode1, 'Value')
                valueNode.text = nameMsr

                paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
                typeNode = Dfct.SubElement(paramNode2, 'Type')
                typeNode.text = "Sieve"
                valueNode = Dfct.SubElement(paramNode2, 'Value')
                valueNode.text = self.parent.comboBoxSieve.comboBoxSieve.currentText()

                outputsNode = Dfct.SubElement(functionXmlElement, 'Outputs')
                outputNode0 = Dfct.SubElement(outputsNode, 'Output_0')
                typeNode = Dfct.SubElement(outputNode0, 'Type')
                typeNode.text = "HistogramMeasure"
                valueNode = Dfct.SubElement(outputNode0, 'Value')

            elif type(self.parent.infoSet) == WidgetTypes.IPSDKType.SHAPEANALYSIS_MULTISLICE.value:

                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'HistogramOfMeasureMultiSlice'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
                paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
                typeNode = Dfct.SubElement(paramNode0, 'Type')
                typeNode.text = "ShapeAnalysis"
                valueNode = Dfct.SubElement(paramNode0, 'Value')
                valueNode.text = Dfct.childText(self.parent.xmlElement, 'ElementID')
                valueNode.set('isElementID', str(True))

                paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                typeNode = Dfct.SubElement(paramNode1, 'Type')
                typeNode.text = "Enumerate"
                valueNode = Dfct.SubElement(paramNode1, 'Value')
                valueNode.text = nameMsr

                paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
                typeNode = Dfct.SubElement(paramNode2, 'Type')
                typeNode.text = "Sieve"
                valueNode = Dfct.SubElement(paramNode2, 'Value')
                valueNode.text = self.parent.comboBoxSieve.comboBoxSieve.currentText()

                outputsNode = Dfct.SubElement(functionXmlElement, 'Outputs')
                outputNode0 = Dfct.SubElement(outputsNode, 'Output_0')
                typeNode = Dfct.SubElement(outputNode0, 'Type')
                typeNode.text = "HistogramMeasure"
                valueNode = Dfct.SubElement(outputNode0, 'Value')

            else:
                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'HistogramOfMeasureFromList'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')

                paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
                typeNode = Dfct.SubElement(paramNode0, 'Type')
                typeNode.text = "String"
                valueNode = Dfct.SubElement(paramNode0, 'Value')
                valueNode.text = str(dictResults[currentNum]["Values"])
                # valueNode.text = str(dictResults[currentNum]["Values"])

                paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                typeNode = Dfct.SubElement(paramNode1, 'Type')
                typeNode.text = "Sieve"
                valueNode = Dfct.SubElement(paramNode1, 'Value')
                valueNode.text = self.parent.comboBoxSieve.comboBoxSieve.currentText()

                outputsNode = Dfct.SubElement(functionXmlElement, 'Outputs')
                outputNode0 = Dfct.SubElement(outputsNode, 'Output_0')
                typeNode = Dfct.SubElement(outputNode0, 'Type')
                typeNode.text = "Histogram"
                valueNode = Dfct.SubElement(outputNode0, 'Value')

            # vrb.mainWindow.applyProcessAsync(None, xmlFunctionCall=functionXmlElement)
            try:
                vrb.allowChangeName = False
                vrb.mainWindow.applyProcessSync(None, xmlFunctionCall=functionXmlElement)
                vrb.allowChangeName = True
            except:
                vrb.allowChangeName = True
        except:
            import traceback
            traceback.print_exc(file=sys.stderr)


class UsefulInfoTableWidget(qt.QTableWidget):
    def __init__(self):
        super(UsefulInfoTableWidget, self).__init__()

        self.horizontalHeader().setVisible(False)
        self.verticalHeader().setVisible(False)
        self.setAlternatingRowColors(True)

        self.initTable()

    def initTable(self):

        self.clear()
        self.setRowCount(5)
        self.setColumnCount(1)
        self.setItem(0, 0, qt.QTableWidgetItem('Min'))
        self.setItem(1, 0, qt.QTableWidgetItem('Max'))
        self.setItem(2, 0, qt.QTableWidgetItem('Mean'))
        self.setItem(3, 0, qt.QTableWidgetItem('Deviation'))
        self.setItem(4, 0, qt.QTableWidgetItem('Sum'))
        self.setMaximumHeight(self.rowHeight(0) * self.rowCount() + self.horizontalScrollBar().height())
        self.horizontalHeader().setStretchLastSection(True)

    def addRecapColumn(self, values, color):
        colorDarker = color.darker(120)
        # values = values[1:]
        col = self.columnCount()
        self.setColumnCount(col + 1)
        mini = min(values)
        maxi = max(values)
        total = sum(values)
        avg = total / len(values)
        dev = np.std(values)

        if isinstance(mini, type(True)):
            # if it is boolean
            avg = fct.numberCalibration(avg *100) + '%'
        else:
            avg = fct.numberCalibration(avg)

        cell = qt.QTableWidgetItem(fct.numberCalibration(mini))
        cell.setTextAlignment(Qt.AlignRight)
        self.setItem(0, col, cell)
        cell = qt.QTableWidgetItem(fct.numberCalibration(maxi))
        cell.setTextAlignment(Qt.AlignRight)
        self.setItem(1, col, cell)
        cell = qt.QTableWidgetItem(fct.numberCalibration(avg))
        cell.setTextAlignment(Qt.AlignRight)
        self.setItem(2, col, cell)
        cell = qt.QTableWidgetItem(fct.numberCalibration(dev))
        cell.setTextAlignment(Qt.AlignRight)
        self.setItem(3, col, cell)
        cell = qt.QTableWidgetItem(fct.numberCalibration(total))
        cell.setTextAlignment(Qt.AlignRight)
        self.setItem(4, col, cell)

        for row in range(5):
            self.item(row, col).setBackground((colorDarker, color)[row % 2 == 0])


def measureIterator(xmlAllMeasures):
    # iterator through all checked measures
    for child in xmlAllMeasures:
        if child.tag == 'Custom':
            # Custom measures
            for child2 in child:
                if child2.tag == 'Arithmetic':
                    prefix = "Custom_A_"
                elif child2.tag == 'Logic':
                    prefix = "Custom_L_"
                for measureNode in Dfct.childIterator(child2, 'Measure'):
                    if measureNode.get('CheckState') == '2':
                        ipsdkCallName = prefix + Dfct.childText(measureNode, 'UserName').replace(" ","")
                        userName = Dfct.childText(measureNode, 'UserName')
                        yield ipsdkCallName, userName
        else:
            # Classic measures
            for measureNode in Dfct.childIterator(child, 'Measure'):
                if measureNode.get('CheckState') == '2':
                    ipsdkCallName = Dfct.childText(Dfct.SubElement(measureNode, "Object"), 'Name')
                    userName = Dfct.childText(measureNode, 'UserName')
                    yield ipsdkCallName, userName

def measureIteratorByType(xmlAllMeasures,type):
    # iterator through all checked measures
    for child in xmlAllMeasures:
        if child.tag == type:
            for measureNode in Dfct.childIterator(child, 'Measure'):
                if measureNode.get('CheckState') == '2':
                    ipsdkCallName = Dfct.childText(Dfct.SubElement(measureNode, "Object"), 'Name')
                    userName = Dfct.childText(measureNode, 'UserName')
                    yield ipsdkCallName, userName


def randomPastelColor(i):
    colors = [55,194,100]
    s = 90
    l = 90
    return QtGui.QColor.fromHsl(colors[i%len(colors)], s * 255 / 100, l * 255 / 100, 100)
    #return QtGui.QColor.fromHsl(random.randint(0, 359), s * 255 / 100, l * 255 / 100, 100)

def extractXmlAllMeasuresFromElement(xmlElement):
    parametersNode = Dfct.SubElement(Dfct.SubElement(xmlElement, 'FunctionCall'), 'Parameters')
    for param in parametersNode:
        valueNode = Dfct.SubElement(param, 'Value')
        for elem in valueNode:
            if elem.tag == 'AllMeasures':
                return elem
    return None