import sys

from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication, QStringListModel
import PyQt5.QtGui as qtGui
import PyQt5.QtCore as QtCore
import PyQt5.QtWidgets as qt

import WidgetTypes

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from ConversionIPSDK import dictConversion

import UsefullVariables as vrb
import UsefullWidgets as wgt

###################
#Search function
###################

dictCompleter = {}


class SearchBox(qt.QGroupBox):
    def __init__(self):
        super(SearchBox, self).__init__()

        self.lineEditSearch = SearchLineEdit()
        self.setFixedWidth(300*vrb.ratio)
        self.pushButtonOpen = wgt.PushButtonImage(vrb.folderImages + "/Lens.png", margins=2)
        self.pushButtonOpen.setFixedSize(20*vrb.ratio,20*vrb.ratio)
        self.pushButtonOpen.setToolTip("Search function")

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.lineEditSearch, 0, 0)
        self.layout.addWidget(self.pushButtonOpen, 0, 1)
        self.setLayout(self.layout)
        self.layout.setContentsMargins(0, 0, 0, 0)
        self.setFixedHeight(30*vrb.ratio)

        self.pushButtonOpen.clicked.connect(self.openFunction)
        self.lineEditSearch.returnPressed.connect(self.openFunction)  # Enter
        self.lineEditSearch.completer.activated.connect(self.openFunction)  # (clic on popup or enter on a selected item)

    def openFunction(self):
        if self.lineEditSearch.text() in dictCompleter:
            spoilersPath = dictCompleter[self.lineEditSearch.text()]

            spoilersPath[0].emitSignalSetSpoilerExpand(None)
            spoilersPath[1].shouldBeDisplayed = True
            spoilersPath[1].setVisible(True)
            spoilersPath[1].emitSignalSetSpoilerExpand(None)

            # for spoiler in spoilersPath:
            #     spoiler.emitSignalSetSpoilerExpand(None)

    def resetWordList(self):
        self.lineEditSearch.resetModel()

class SearchLineEdit(qt.QLineEdit):

    def __init__(self):
        super(SearchLineEdit, self).__init__()
        self.model = qtGui.QStandardItemModel(self)
        self.fillModel()
        self.completer = qt.QCompleter()
        self.completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.completer.setModel(self.model)
        self.setCompleter(self.completer)

    def addWord(self, word):
        item = qtGui.QStandardItem(word)
        self.model.appendRow(item)

    def fillModel(self):

        prioTag = ['Threshold']
        for tag in prioTag:
            if tag in dictCompleter:
                self.addWord(tag)
        for tag in dictCompleter:
            if tag not in prioTag:
                self.addWord(tag)

    def resetModel(self):
        self.model.clear()
        self.fillModel()

###################
#Search measure
###################

dictCompleterMeasure = {}

class SearchBoxMeasure(qt.QGroupBox):
    def __init__(self):
        super(SearchBoxMeasure, self).__init__()

        self.lineEditSearchMeasure = SearchLineEditMeasure()
        self.setFixedWidth(300*vrb.ratio)
        self.pushButtonOpen = wgt.PushButtonImage(vrb.folderImages + "/Lens.png", margins=2)
        self.pushButtonOpen.setFixedSize(20*vrb.ratio,20*vrb.ratio)
        self.pushButtonOpen.setToolTip("Search measure")

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.lineEditSearchMeasure, 0, 0)
        self.layout.addWidget(self.pushButtonOpen, 0, 1)
        self.setLayout(self.layout)
        self.layout.setContentsMargins(0, 0, 0, 0)
        self.setFixedHeight(30*vrb.ratio)

        self.pushButtonOpen.clicked.connect(self.openMeasure)
        self.lineEditSearchMeasure.returnPressed.connect(self.openMeasure)  # Enter
        self.lineEditSearchMeasure.completer.activated.connect(self.openMeasure)  # (clic on popup or enter on a selected item)

        self.setFixedSize(110*vrb.ratio,25*vrb.ratio)

    # def openMeasure(self):
    #
    #     print(self.lineEditSearchMeasure.text())

    def resetWordList(self):
        self.lineEditSearchMeasure.resetModel()

class SearchLineEditMeasure(qt.QLineEdit):

    def __init__(self):
        super(SearchLineEditMeasure, self).__init__()
        self.model = qtGui.QStandardItemModel(self)
        self.fillModel()
        self.completer = qt.QCompleter()
        self.completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.completer.setModel(self.model)
        self.setCompleter(self.completer)
        self.setFixedSize(80*vrb.ratio,20*vrb.ratio)

    def addWord(self, word):
        item = qtGui.QStandardItem(word)
        self.model.appendRow(item)

    def fillModel(self):
        prioTag = []
        for tag in prioTag:
            if tag in dictCompleterMeasure:
                self.addWord(tag)
        for tag in dictCompleterMeasure:
            if tag not in prioTag:
                self.addWord(tag)

    def resetModel(self):
        self.model.clear()
        self.fillModel()


if __name__ == '__main__':
    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    foo = SearchBox()
    foo.setFixedHeight(300*vrb.ratio)
    foo.show()
    app.exec_()
