import fnmatch

def findRegisterLicenceExe(inPath):
    pattern = "RegisterIPSDKLicense_*"
    result = []
    for root, dirs, files in os.walk(inPath):
        for name in files:
            if fnmatch.fnmatch(name, pattern):
                result.append(os.path.join(root, name))
    return result

try:
    import PyIPSDK
    from ORSModel.ors import Channel, Managed
    from MainWindow import MainWindow

    import os
    import sys

    from PyQt5.QtCore import Qt,QCoreApplication
    from PyQt5.QtGui import QPixmap, QIcon
    from PyQt5.QtWidgets import QApplication, QSplashScreen

    import xml.etree.ElementTree as xmlet
    import DatabaseFunction as Dfct

    import PyIPSDK

    import UsefullVariables as vrb
    vrb.isORS = True

    if __name__ == '__main__':

        app = QCoreApplication.instance()
        if app is None:
            app = QApplication([])

        sys._excepthook = sys.excepthook

        def exception_hook(exctype, value, traceback):
            print(exctype, value, traceback)
            sys._excepthook(exctype, value, traceback)
            sys.exit(1)

        sys.excepthook = exception_hook

        pixmap = QPixmap(vrb.folderImages + '/Explorer_Logo_Bleu.png')
        from PyQt5.QtCore import Qt

        pixmap = pixmap.scaled(600, 600, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
        splashScreen = QSplashScreen(pixmap)
        splashScreen.setFixedSize(600, 600)
        splashScreen.show()
        app.processEvents()

        app.setWindowIcon(QIcon(vrb.folderImages + "/Explorer_Logo_Bleu.png"))

        foo = MainWindow(app=app)

        objList = Managed.getAllInstancesOf(Channel.getClassNameStatic())

        for obj in objList:

            if obj.getTitle() != "Grey Channel2 UBYTE":
                outputDict = {}
                outputDict["Name"] = obj.getTitle()
                outputDict["Type"] = "Image"

                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'LoadImage'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
                paramNode = Dfct.SubElement(paramsNode, 'Parameter_0')
                Dfct.SubElement(paramNode, 'Value').text = Dfct.convertTextToAscii("None")
                paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                Dfct.SubElement(paramNode1, 'Value').text = "False"

                IPSDK_spacingDx = obj.getXSpacing()
                IPSDK_spacingDy = obj.getYSpacing()
                IPSDK_spacingDz = obj.getZSpacing()
                Img = PyIPSDK.fromArray(obj.getNDArray(0))
                calib = PyIPSDK.createGeometricCalibration3d(IPSDK_spacingDx, IPSDK_spacingDy, IPSDK_spacingDz, 'um')
                Img.setGeometricCalibration(calib)

                foo.centralWidget.addResult(Img, outputDict, functionXmlElement)

        try:
            if os.name == 'nt':
                try:
                    foo.setWindowFlag(Qt.WindowStaysOnTopHint)
                except:
                    foo.setWindowFlags(Qt.WindowStaysOnTopHint)

                foo.show()

                try:
                    foo.setWindowFlag(foo.windowFlags() & ~Qt.WindowStaysOnTopHint)
                except:
                    foo.setWindowFlags(foo.windowFlags() & ~Qt.WindowStaysOnTopHint)
        except:
            pass

        foo.show()

        splashScreen.finish(foo)

        app.exec_()

except:
    try:
        import PyIPSDK
    except:
        import os
        import subprocess
        import UsefullVariables as vrb

        folderParent = os.path.dirname(vrb.folderExplorer)

        registerLicenceExePath = findRegisterLicenceExe(folderParent + "/bin/Release_msvc15_x64")
        subprocess.check_call(registerLicenceExePath)
