from PyQt5.QtCore import pyqtSignal, QPointF, Qt, QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import UsefullTexts as txt
import UsefullVariables as vrb

class MenuBar(qt.QMenuBar):

    def __init__(self):

        qt.QMenuBar.__init__(self)

        menuFile = self.addMenu(txt.dictLanguage[vrb.languageVariable]["File"])
        self.menuSaveExplorerSession = menuFile.addMenu(txt.dictLanguage[vrb.languageVariable]["Save Explorer session"])
        self.actionSaveExplorerSessionProcessOnly = self.menuSaveExplorerSession.addAction(txt.dictLanguage[vrb.languageVariable]["Process only"])
        self.actionSaveExplorerSessionProcessAndInputImages = self.menuSaveExplorerSession.addAction(txt.dictLanguage[vrb.languageVariable]["Process and input images"])
        self.actionSaveExplorerSessionAllElements = self.menuSaveExplorerSession.addAction(txt.dictLanguage[vrb.languageVariable]["All elements"])
        self.actionLoadExplorerSession = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Load Explorer session"])
        self.actionLoad = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Load image"])
        self.actionLoadImageDisk = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Open disk image"])
        self.actionLoad.setShortcut(QtGui.QKeySequence("Ctrl+O"))
        self.actionLoadMulti = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Load multi image as volume"])
        self.actionLoadMultiAsSequence = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Load multi image as sequence"])
        self.actionLoadStl = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Load STL"])
        self.actionSave = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Save image"])
        self.actionSaveAsMultiSlices = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Save image as multiSlices"])
        self.actionClearAll = menuFile.addAction(txt.dictLanguage[vrb.languageVariable]["Delete all images"])

        menuSettings = self.addMenu(txt.dictLanguage[vrb.languageVariable]["Settings"])
        self.actionColorPreference = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Graphics"])
        # self.actionColorPreference = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Color Preferences"])
        self.actionPostProcessPreference = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Post process"])
        menuLuts = menuSettings.addMenu(txt.dictLanguage[vrb.languageVariable]["LUT preferences"])
        self.actionAddLut = menuLuts.addAction(txt.dictLanguage[vrb.languageVariable]["Add new LUT"])
        self.actionManageLut = menuLuts.addAction(txt.dictLanguage[vrb.languageVariable]["Manage LUT"])
        self.actionLabelPreference = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Label preferences"])
        menuSieve = menuSettings.addMenu(txt.dictLanguage[vrb.languageVariable]["Sieves"])
        self.actionSievesPreference = menuSieve.addAction(txt.dictLanguage[vrb.languageVariable]["Sieves preferences"])
        self.actionImportSieves = menuSieve.addAction(txt.dictLanguage[vrb.languageVariable]["Import sieves"])
        self.actionZStackFocusPreferences = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Z Stack Focus preferences"])
        # self.actionViewer3D = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Viewer 3D"])
        self.actionDisplayThumbails = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Display thumbnails"])
        self.actionDisplayThumbails.setCheckable(True)
        self.actionDisplayThumbails.setChecked(True)
        self.actionSettingsDiskImages = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Disk images preferences"])
        self.actionInterfacePreferences = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Interface preferences"])

        menuSettings = self.addMenu(txt.dictLanguage[vrb.languageVariable]["Functions"])
        menuModules = menuSettings.addMenu(txt.dictLanguage[vrb.languageVariable]["Modules"])
        self.actionAddModule = menuModules.addAction(txt.dictLanguage[vrb.languageVariable]["Add module"])
        self.actionDeleteModule = menuModules.addAction(txt.dictLanguage[vrb.languageVariable]["Delete module"])
        menuMacro = menuSettings.addMenu(txt.dictLanguage[vrb.languageVariable]["Macro"])
        if vrb.isRunTime == False:
            self.actionNewMacro = menuMacro.addAction(txt.dictLanguage[vrb.languageVariable]["Create new macro"])
        self.actionImportMacro = menuMacro.addAction(txt.dictLanguage[vrb.languageVariable]["Import macro"])
        self.actionExportMacro = menuMacro.addAction(txt.dictLanguage[vrb.languageVariable]["Export macro"])
        menuMacroInterface = menuSettings.addMenu(txt.dictLanguage[vrb.languageVariable]["Macro Interface"])
        self.actionImportMacroInterface = menuMacroInterface.addAction(txt.dictLanguage[vrb.languageVariable]["Import macro interface"])
        self.actionExportMacroInterface = menuMacroInterface.addAction(txt.dictLanguage[vrb.languageVariable]["Export macro interface"])
        self.actionDeleteMacroInterface = menuMacroInterface.addAction(txt.dictLanguage[vrb.languageVariable]["Delete macro interface"])
        # self.actionReinitializeMacro = menuMacroInterface.addAction(txt.dictLanguage[vrb.languageVariable]["Reinitialize"])
        self.actionBenchmark = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Benchmark"])
        menuMachineLearning = menuSettings.addMenu(txt.dictLanguage[vrb.languageVariable]["Machine learning"])
        menuMachineLearningImport = menuMachineLearning.addMenu(txt.dictLanguage[vrb.languageVariable]["Import model"])
        self.actionMachineLearningImportSegmentation = menuMachineLearningImport.addAction(txt.dictLanguage[vrb.languageVariable]["Smart segmentation"])
        self.actionMachineLearningImportClassification = menuMachineLearningImport.addAction(txt.dictLanguage[vrb.languageVariable]["Smart classification"])
        self.actionMachineLearningImportSuperPixelSegmentation = menuMachineLearningImport.addAction(txt.dictLanguage[vrb.languageVariable]["Super Pixel Segmentation"])
        menuMachineLearningExport = menuMachineLearning.addMenu(txt.dictLanguage[vrb.languageVariable]["Export model"])
        self.actionMachineLearningExportSegmentation = menuMachineLearningExport.addAction(txt.dictLanguage[vrb.languageVariable]["Smart segmentation"])
        self.actionMachineLearningExportClassification = menuMachineLearningExport.addAction(txt.dictLanguage[vrb.languageVariable]["Smart classification"])
        self.actionMachineLearningExportSuperPixelSegmentation = menuMachineLearningExport.addAction(txt.dictLanguage[vrb.languageVariable]["Super Pixel Segmentation"])
        self.actionUpdateFunctions = menuSettings.addAction(txt.dictLanguage[vrb.languageVariable]["Update functions"])

        menuHelp = self.addMenu(txt.dictLanguage[vrb.languageVariable]["Help"])
        self.actionAbout = menuHelp.addAction(txt.dictLanguage[vrb.languageVariable]["About Explorer"])
        self.actionDocumentation = menuHelp.addAction(txt.dictLanguage[vrb.languageVariable]["Documentation"])

        self.setFixedHeight(max(20, 25 * vrb.ratio))

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    foo = MenuBar()
    foo.setFixedSize(1800, 1000)
    foo.show()

    app.exec_()
