import sys

from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication, QStringListModel
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore,QtGui

import WidgetTypes
from UsefullWidgets import NumberLineEdit

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from DictionaryCustomObject import dictCustomObject

import UsefullVariables as vrb
import UsefullWidgets as wgt
import UsefullFunctions as fct
import UsefullDisplay as display

import numpy as np

import PyIPSDK

def measureDisplayer(xmlElement, object, valueSpoiler, mainWindow,currentWidget):

    if dictCustomObject[object.subType]["Object"] == "AreaPercent":
        if PyIPSDK.PlanIndexedDoubles == type(object.value):
            dictRes = PyIPSDK.toPyDict(object.value)

            ddict = {}
            ddict["z"] = object.value.getMaxSizeZ()
            ddict["t"] = object.value.getMaxSizeT()
            for z in range(object.value.getMaxSizeZ()):
                for t in range(object.value.getMaxSizeT()):
                    ddict["("+str(z)+",0,"+str(t)+")"] = fct.createDictFromColl(dictRes[(z,0,t)]["Coll"], "Label", "Area percent")

            displayer = display.TableWidgetWindowWithSliders(ddict)

        else:

            ddict = fct.createDictFromColl(object.value.coll, "Label", "Area percent")

            displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "VolumePercent":
        if PyIPSDK.PlanIndexedDoubles == type(object.value):
            dictRes = PyIPSDK.toPyDict(object.value)

            ddict = {}
            ddict["t"] = object.value.getMaxSizeT()
            for t in range(object.value.getMaxSizeT()):
                ddict["(0,0,"+str(t)+")"] = fct.createDictFromColl(dictRes[(0,0,t)]["Coll"], "Label", "Volume percent")

            displayer = display.TableWidgetWindowWithSliders(ddict)

        else:

            ddict = fct.createDictFromColl(object.value.coll, "Label", "Volume percent")

            displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "Scalar":
        try:
            value = "Value"
            if object.subType == "Pearson":
                value = "CorrCoeff"
            elif object.subType == "NCC":
                value = "Result"

            if np.isscalar(object.value):
                if value == "Value": # Not Pearson or NCC
                    algoXML = Dfct.SubElement(xmlElement, "FunctionCall")
                    algoParamsXML = Dfct.SubElement(algoXML, "Parameters")
                    for elt in algoParamsXML.iter():
                        if "Parameter_" in elt.tag and value == "Value": # We test value == "Value" to use the name of the first image
                            paramID = Dfct.SubElement(elt, "Value").text
                            imageName = vrb.dictElements[paramID][3].name
                            value = imageName

                ddict = {"Name":[value],"Value":[str(object.value)]}

            else:
                multiSlice = PyIPSDK.toPyDict(object.value)
                ddict = fct.createDictFromMultislice(multiSlice,value=value)

        except:
            try:
                name = object.name
            except:
                name = dictCustomObject[object.subType]["Name"]
            ddict = {"Name":[name],"Value":[str(object.value)]}

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "GaussianNoise":

        ddict = {"Name":[dictCustomObject[object.subType]["Name"]],"PixCount":[str(object.value.pixCount)],
                  "Sigma":[str(object.value.sigma)],"Sum":[str(object.value.sum)]}

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "Paraboloid":

        ddict = {"Name": [dictCustomObject[object.subType]["Name"]], "X2Coef": [str(object.value.x2Coef)],
                 "Y2Coef": [str(object.value.y2Coef)], "XYCoef": [str(object.value.xYCoef)],
                 "XCoef": [str(object.value.xCoef)],"YCoef": [str(object.value.yCoef)],
                 "Constant": [str(object.value.constant)]}

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "Similarity":
        ddict = {"Name": [dictCustomObject[object.subType]["Name"]], "PixCount": [str(object.value.pixCount)],
                 "SSD": [str(object.value.sSD)], "MSE": [str(object.value.mSE)], "PSNR": [str(object.value.pSNR)]}

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "Counting":

        ddict = fct.createDictFromColl(object.value,"Category","Number",start=0,offset=1)

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "List":

        ddict = fct.createDictFromColl(object.value,"Index","Value",start=0,offset=1)

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "Dict":

        ddict = object.value
        displayer = display.TableWidgetWindow(object.value)

    elif dictCustomObject[object.subType]["Object"] == "Table":

        ddict = {}

        for i in range(len(object.value)):
            for j in range(len(object.value[i])):
                if i == 0:
                    ddict[object.value[i][j]] = []
                else:
                    ddict[object.value[0][j]].append(object.value[i][j])

        displayer = display.TableWidgetWindow(ddict,allowSort=True,headerHorizontal=True)

    elif dictCustomObject[object.subType]["Object"] == "Projection":

        coll = object.value.coll

        if dictCustomObject[object.subType]["Name"] == "XProjection":
            prefix = "X"
        else:
            prefix = "Y"

        legend = []
        for i in range(len(coll)):
            legend.append(i)

        projType = ""
        try:
            if object.projectionType == PyIPSDK.eProjStatType.ePST_Max:
                projType = "Max"
            if object.projectionType == PyIPSDK.eProjStatType.ePST_Mean:
                projType = "Mean"
            if object.projectionType == PyIPSDK.eProjStatType.ePST_Median:
                projType = "Median"
            if object.projectionType == PyIPSDK.eProjStatType.ePST_Min:
                projType = "Min"
            if object.projectionType == PyIPSDK.eProjStatType.ePST_StdDev:
                projType = "StdDev"
            if object.projectionType == PyIPSDK.eProjStatType.ePST_Sum:
                projType = "Sum"
            if object.projectionType == PyIPSDK.eProjStatType.ePST_Variance:
                projType = "Variance"
        except:
            pass

        widgetProfile = display.WidgetProfile()
        widgetProfile.drawLineProfile(coll,legend,title=prefix + " Projection",xlabel=prefix,yLabel=projType)

        return widgetProfile, dictCustomObject

    elif dictCustomObject[object.subType]["Object"] == "LineProfile":

        yAxis = object.value

        try:
            xAxis = object.xAxis
        except:
            xAxis = []
            for i in range(len(yAxis)):
                xAxis.append(i)

        try:
            xLabel = object.xLabel
        except:
            xLabel = ""

        try:
            yLabel = object.yLabel
        except:
            yLabel = ""

        try:
            title = object.title
        except:
            title = ""

        widgetProfile = display.WidgetProfile()
        widgetProfile.drawLineProfile(yAxis, xAxis, title=title, xlabel=xLabel, yLabel=yLabel)

        return widgetProfile, dictCustomObject

    elif dictCustomObject[object.subType]["Object"] in ["ListPixels","ListPixelsPath"]:

        ddict = {"Index": [],"X Coordinate": [],"Y Coordinate": []}

        dictAllPixels = PyIPSDK.toPyDict(object.value)

        if (0, 0, 0) not in dictAllPixels:
            dictPixels = dictAllPixels["Coll"]
            for i in range(len(dictPixels)):
                ddict["Index"].append(i+1)
                ddict["X Coordinate"].append(str(int(dictPixels[i]["X"])))
                ddict["Y Coordinate"].append(str(int(dictPixels[i]["Y"])))

        else:
            if object.value.getMaxSizeZ()>1:
                ddict["Z Coordinate"] = []
            if object.value.getMaxSizeZ()>1:
                ddict["T Coordinate"] = []
            rowIndex = 0
            for z in range(object.value.getMaxSizeZ()):
                for t in range(object.value.getMaxSizeT()):
                    dictPixels = dictAllPixels[(z, 0, t)]["Coll"]
                    for i in range(len(dictPixels)):
                        ddict["Index"].append(rowIndex + 1)
                        ddict["X Coordinate"].append(str(int(dictPixels[i]["X"])))
                        ddict["Y Coordinate"].append(str(int(dictPixels[i]["Y"])))
                        if "Z Coordinate" in ddict:
                            ddict["Z Coordinate"].append(str(z))
                        if "T Coordinate" in ddict:
                            ddict["T Coordinate"].append(str(t))
                        rowIndex += 1

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] in ["ListVoxels", "ListVoxelsPath"]:

        ddict = {"Index": [],"X Coordinate": [],"Y Coordinate": [],"Z Coordinate": []}

        dictAllPixels = PyIPSDK.toPyDict(object.value)

        if (0, 0, 0) not in dictAllPixels:
            dictPixels = dictAllPixels["Coll"]
            for i in range(len(dictPixels)):
                ddict["Index"].append(i+1)
                ddict["X Coordinate"].append(str(int(dictPixels[i]["X"])))
                ddict["Y Coordinate"].append(str(int(dictPixels[i]["Y"])))
                ddict["Z Coordinate"].append(str(int(dictPixels[i]["Z"])))
        else:
            if object.value.getMaxSizeZ()>1:
                ddict["T Coordinate"] = []
            rowIndex = 0
            for z in range(object.value.getMaxSizeZ()):
                for t in range(object.value.getMaxSizeT()):
                    dictPixels = dictAllPixels[(z, 0, t)]["Coll"]
                    for i in range(len(dictPixels)):
                        ddict["Index"].append(rowIndex + 1)
                        ddict["X Coordinate"].append(str(int(dictPixels[i]["X"])))
                        ddict["Y Coordinate"].append(str(int(dictPixels[i]["Y"])))
                        ddict["Z Coordinate"].append(str(int(dictPixels[i]["Z"])))
                        if "T Coordinate" in ddict:
                            ddict["T Coordinate"].append(str(t))
                        rowIndex += 1

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "StatsByCategory":

        ddict = {"Category": [],"PixCount": [],"Sum": [],"Mean": [],"Min": [],"Max": [],"StdDev": []}
        for i in range(len(object.value)):
            ddict["Category"].append(str(i+1))
            ddict["PixCount"].append(str(int(object.value[i].pixCount)))
            ddict["Sum"].append(str(int(object.value[i].sum)))
            ddict["Mean"].append(str(int(object.value[i].mean)))
            ddict["Min"].append(str(int(object.value[i].min)))
            ddict["Max"].append(str(int(object.value[i].max)))
            ddict["StdDev"].append(str(int(object.value[i].stdDev)))

        displayer = display.TableWidgetWindow(ddict)

    elif dictCustomObject[object.subType]["Object"] == "Analysis_With_Stats":
        ddict = object.value
        displayer = display.TableWidgetWindow(ddict=object.value,
                                              title=currentWidget.editableLabelName.label.text(), stats=True)

    else:
        ddict = {}
        displayer = None

    return displayer,ddict
