import time

import os

import sys, traceback
from shutil import copyfile
from pathlib import Path

#For napari viewer copy to clipboard
# from io import BytesIO
# import win32clipboard

from PyQt5.QtCore import Qt, QCoreApplication, pyqtSignal
from PyQt5 import QtGui, QtCore
import PyQt5.QtWidgets as qt
import platform

try:
    import PyIPSDK
except:
    try:
        import PyIPSDK
    except:
        import PyIPSDK

import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLFeatureDetection as fd
import PyIPSDK.IPSDKIPLStats as stats
import PyIPSDK.IPSDKIPLClassification as classif
import PyIPSDK.IPSDKIPLRegistration as registration
import PyIPSDK.IPSDKIPLMachineLearning as ml

# import PyIPSDKBase

import PyIPSDK.IPSDKUI as ui
import PyIPSDK.IPSDKFunctionsMachineLearning as fctML
import PyIPSDK.IPSDKCamera as Cam

import WidgetTypes
from CustomWidgets import MyComboBoxObject
from ImageViewer import WidgetImage
from WidgetLabelImage import WidgetLabelImage
from WidgetLabelValue import WidgetLabelValue
from InterfaceCategory import CategoryScrollArea, CategorySpoilersContainer,CategorySpoiler
from FunctionsDictionary import dictAllFunctions,dictFolderNames
import SearchBox as searchBox
from GroupMenu import GroupMenu
from WidgetContrast import WidgetContrast
from MenuBar import MenuBar
from AboutWidget import AboutWidget
from LutsWidget import GroupBoxLut, getLutArray
from MacroWidgets import EditScriptWindow
from Benchmark import BenchmarkWidget
from LutsWidget import WidgetNewLut,LutManager
from LabelWidget import WidgetLabels
from SieveWidget import SieveWidget
from WidgetBatch import WidgetBatch
from WidgetCamera import WidgetCameraToDisplay,WidgetCamera
from MovieMakerWidget import MovieMakerWithMenu


import vtk
vtk.vtkObject.GlobalWarningDisplayOff()

import webbrowser

import napari
import warnings
warnings.filterwarnings("ignore", category=UserWarning, module="pydantic")
from napari_animation import Animation
# from napari.qt import QtViewer
# from napari._qt.qthreading import thread_worker
# import vispy
# from vispy.scene import ArcballCamera, PanZoomCamera, FlyCamera
# from dask import delayed
# import dask.array as da
import numpy as np
import gc
#from sklearn.externals import joblib
import joblib
import importlib
import math

import importlib.util

pi = np.pi
try:
    import cv2
except:
    print("WARNING : Can't import OpenCV, only 'tiff' and 'raw' format will be supported")
    # traceback.print_exc(file=sys.stderr)
from PIL import Image, ImageFont, ImageDraw

try:
    from pyueye import ueye
except:
    pass

try:
    from vimba import *
except:
    print("[Warning] the vimba package is not installed. Impossible to use a camera")

import zipfile

from datetime import datetime

import moduleRandomForest.UsefullMachineLearning as mlFct
import DrawFunctions as DWfct
import DatabaseFunction as Dfct
import UsefullVariables as vrb
import UsefullFunctions as fct
import UsefullWidgets as wgt
from UsefullWidgets import PopUpWindow, GroupBoxSelectionDimension, GroupBoxProcessing, Measure, MessageBox, WidgetDeleleAll, RawWidget
import UsefullDisplay as display

import xml.etree.ElementTree as xmlet

from GraphicElements import GraphicElements

import SettingsWidget

import subprocess
import shutil

import moduleRandomForest.ModuleRF_Segmentation
import moduleRandomForest.ModuleRF_Classification
import moduleRandomForest.ModuleRF_SuperPixels

from Viewer3dSettingsWidget import Viewer3dSettingsWidget,Viewer3dSettingsScrollArea

for file in os.listdir(vrb.folderFunctions):
    sys.path.insert(0, vrb.folderFunctions+"/"+file)

import json
import pickle

# macroPath = vrb.folderFunctions+"/Macro"
# sys.path.insert(0, macroPath)

class MainWindow(qt.QWidget):

    def __init__(self, parent=None, app=None):
        qt.QWidget.__init__(self)

        # self.thread().setPriority(QtCore.QThread.TimeCriticalPriority)

        self.parent = parent
        self.app = app
        self.verif = True

        try:
            if self.app is not None:
                self.clipboard = self.app.clipboard()
            else:
                self.clipboard = app.clipboard()
        except:
            pass

        self.margins = 0

        self.menuBar = MenuBar()
        self.centralWidget = CentralWidget(parent=self)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.menuBar, 0, 0, QtCore.Qt.AlignTop | QtCore.Qt.AlignLeft)
        self.layout.addWidget(self.centralWidget)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(self.margins, self.margins, self.margins, self.margins)
        # self.setMinimumSize(1024*vrb.ratio, 815*vrb.ratio)
        self.setMinimumSize(1024, 815)
        self.resize(int(1310*vrb.ratio),int(815*vrb.ratio))
        # self.resize(1310, 815)

        self.setWindowTitle('IPSDK Explorer')
        style = fct.getStyleSheet()
        self.setStyleSheet(style)


    def closeEvent(self, event: QtGui.QCloseEvent) -> None:

        try:
            file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
            settingsElement = file.getroot()
            warningMessageExplorerClosedElement = Dfct.SubElement(settingsElement, "WarningMessageExplorerClosed")
            warningMessageExplorerClosed = warningMessageExplorerClosedElement.text
        except:
            warningMessageExplorerClosed = "True"

        if warningMessageExplorerClosed is None:
            warningMessageExplorerClosed = "True"

        if vrb.hasImage and self.verif and warningMessageExplorerClosed == "True" and vrb.sessionIsSaved == False:
            messageBox = MessageBox('Are you sure you want to close Explorer?', 'Your session has been modified\nUnsaved images will be lost.', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No], icon=qt.QMessageBox.Warning)
            res = messageBox.exec()
            if res == qt.QMessageBox.Yes:

                for num in range(self.centralWidget.widgetLabelImage.layout.count()):
                    try:
                        item = self.centralWidget.widgetLabelImage.layout.itemAt(num)
                        if item is not None:
                            label = item.widget()
                            label.image.clear()
                    except:
                        pass

                event.accept()

                self.app.closeAllWindows()

            else:
                event.ignore()

        else:

            for num in range(self.centralWidget.widgetLabelImage.layout.count()):
                try:
                    item = self.centralWidget.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        label.imag.clear()
                except:
                    pass
            # #delete TMP-Files from Viewer:
            # import shutil
            # for f in self.centralWidget.tmp_folder_list:
            #     #print('remove: ' +  str(os.path.dirname(filename)))
            #     #try:
            #     shutil.rmtree(f)
            #     #except:
            #     #    pass

            self.app.closeAllWindows()

class ThreadProcess(QtCore.QThread):

    SignalFinishProcess = pyqtSignal()
    # SignalActualizeProgressBar = pyqtSignal(int)
    SignalActualizeTime = pyqtSignal()

    def __init__(self, mainWindow=None):
        QtCore.QThread.__init__(self)

        # self.setPriority(6)

        self.mainWindow = mainWindow

        self.textFunction = None
        self.xmlFunctionCall = None
        self.outputsDict = None
        self.allID = None
        self.functionWidget = None

        self.outputs = None
        self.error = None

    def emitSignalActualizeProgressBar(self,ratio):

        self.SignalActualizeProgressBar.emit(ratio)
        self.mainWindow.actualizeProgressBar(ratio)

    def emitSignalActualizeTime(self):

        self.SignalActualizeTime.emit()

    def run(self):

        try:
            error = None
            for id in self.allID:
                text = "ID_" + id + "_ID = self.mainWindow.idToVariable(id)"
                exec(text)

            vrb.printDebug("----------------")
            vrb.printDebug(self.textFunction)
            vrb.printDebug("----------------")

            _locals = locals()
            startTime = time.time()

            try:
                print('Text functions')
                print(self.textFunction)
                exec(self.textFunction, globals(), _locals)
            except Exception as e:
                error = e
                traceback.print_exc(file=sys.stderr)

            execTime = time.time() - startTime
            Dfct.SubElement(self.xmlFunctionCall, 'ExecutionTime').text = str(execTime)
            try:
                outputs = _locals['outputs']
            except:
                outputs = None
            try:
                if _locals['error'] is not None:
                    error = _locals['error']
            except:
                pass

            self.outputs = outputs
            self.error = error

            self.SignalFinishProcess.emit()

        except Exception as e:
            traceback.print_exc(file=sys.stderr)
            self.SignalFinishProcess.emit()

class CentralWidget(qt.QWidget):

    SignalCurrentElementChanged = pyqtSignal()

    def __init__(self, parent=None):

        qt.QWidget.__init__(self)

        self.initDone = False

        # try:
        #     from IDS import WidgetIDS
        #     vrb.widgetIDS = WidgetIDS()
        #     try:
        #         vrb.widgetIDS.loadXmlElement()
        #     except:
        #         traceback.print_exc(file=sys.stderr)
        # except:
        #     traceback.print_exc(file=sys.stderr)
        #     pass

        self.widgetCameraToDisplay = WidgetCameraToDisplay()
        for cameraNum in range(vrb.nbCameras):
            vrb.widgetCamera.append(WidgetCamera(cameraNum=cameraNum))

        self.timeRef = None
        vrb.mainWindow = self
        self.parent = parent

        self.rightPanelShown = True

        self.viewerNapari = napari.Viewer(show=False,ndisplay=3)

        self.viewerNapari.camera.perspective = 60

        import os
        os.environ['NAPARI_ASYNC'] = '1'

        self.movieMakerWithMenu = MovieMakerWithMenu()
        self.movieMaker = self.movieMakerWithMenu.movieMakerScrollArea.centralWidget

        self.widgetNewLut = WidgetNewLut()
        self.lutManager = LutManager()

        self.widgetLabels = WidgetLabels()
        self.sieveWidget = SieveWidget()

        self.benchmarkWidget = BenchmarkWidget()

        self.machineLearningSettingsWidget = wgt.MachineLearningSettingsWidget()
        self.moduleRF_Segmentation = moduleRandomForest.ModuleRF_Segmentation.MainWidget()
        self.moduleRF_Classification = moduleRandomForest.ModuleRF_Classification.MainWidget()
        self.moduleRF_SuperPixels = moduleRandomForest.ModuleRF_SuperPixels.MainWidget()
        self.currentModuleMachineLearning = None

        self.threadProcess = ThreadProcess(mainWindow=self)
        #self.eic = PyIPSDK.createElementInfosCounter()
        self.tmp_folder_list = []

        self.margins = 0
        self.image = None
        self.currentLabel = None
        self.currentXmlElement = None

        self.currentSelector = None

        self.labelCropped = None

        self.addingResult = False
        self.updatingComboBox = False

        self.imagePreview = None

        self.measuresTableWidget = None

        self.xmlElement = xmlet.Element('IPSDK')
        allElements = Dfct.SubElement(self.xmlElement, 'AllElements')

        self.widgetLabelImage = WidgetLabelImage(allElements, mainWindow=self)
        self.widgetLabelValue = WidgetLabelValue(allElements, mainWindow=self)

        self.tabWidgetLeft = qt.QTabWidget()
        self.tabWidgetLeft.addTab(self.widgetLabelImage, 'Images')
        self.tabWidgetLeft.addTab(self.widgetLabelValue, 'Values')

        self.groupBoxButtonsArrow = qt.QGroupBox()
        self.layoutButtonsArrow = qt.QHBoxLayout()
        self.buttonArrowDown = wgt.PushButtonImage(vrb.folderImages + "/Arrow_Down.png", margins=2)
        self.buttonArrowDown.setFixedSize(int(15*vrb.ratio),int(15*vrb.ratio))
        self.buttonArrowUp = wgt.PushButtonImage(vrb.folderImages + "/Arrow_Up.png", margins=2)
        self.buttonArrowUp.setFixedSize(int(15*vrb.ratio),int(15*vrb.ratio))
        self.layoutButtonsArrow.addWidget(self.buttonArrowDown)
        self.layoutButtonsArrow.addWidget(self.buttonArrowUp)
        self.groupBoxButtonsArrow.setLayout(self.layoutButtonsArrow)
        self.layoutButtonsArrow.setContentsMargins(0, 0, 0, 0)
        self.groupBoxButtonsArrow.setStyleSheet("QGroupBox {border: 0px transparent;}")

        self.buttonArrowDown.clicked.connect(self.downImage)
        self.buttonArrowUp.clicked.connect(self.upImage)

        self.widgetImage = WidgetImage(parent=self,with3D=True)
        self.imageViewer = self.widgetImage.imageViewer
        self.viewerNapariQt = self.widgetImage.imageViewer3D

        self.popUpWindowError = PopUpWindow()

        self.rawWidget = RawWidget(mainWindow=self)

        #long loading time

        self.categoryScrollArea = CategoryScrollArea()
        self.categorySpoilersContainer = self.categoryScrollArea.centralWidget

        self.searchBox = searchBox.SearchBox()

        self.groupBoxSelectionDimension = GroupBoxSelectionDimension()
        self.groupBoxSelectionDimension.buttonGroup.buttonClicked.connect(self.changeDisplayedFunctions)

        self.viewer3dSettingsScrollArea = Viewer3dSettingsScrollArea()
        self.viewer3dSettingsWidget = self.viewer3dSettingsScrollArea.centralWidget
        self.viewer3dSettingsScrollArea.setVisible(False)

        self.checkBoxFavorite = qt.QCheckBox("Favorite")
        self.checkBoxFavorite.setFixedSize(int(60*vrb.ratio),int(20*vrb.ratio))
        self.checkBoxFavorite.stateChanged.connect(self.changeDisplayedFunctions)

        self.labelHide = wgt.LabelImage(vrb.folderImages + '/TriangleRight.png')
        self.labelHide.setFixedSize(int(20*vrb.ratio),int(20*vrb.ratio))
        self.labelHide.mousePressEvent = self.hideRightPanel

        self.groupBoxRight = qt.QGroupBox()
        rightPanelLayout = qt.QGridLayout()
        rightPanelLayout.addWidget(self.groupBoxSelectionDimension, 0, 0,Qt.AlignLeft)
        rightPanelLayout.addWidget(self.checkBoxFavorite, 0, 1,Qt.AlignRight)
        rightPanelLayout.addWidget(self.labelHide, 0, 2)
        rightPanelLayout.addWidget(self.categoryScrollArea, 1, 0,1,3)
        rightPanelLayout.addWidget(self.searchBox, 2, 0,1,3, Qt.AlignBottom)
        rightPanelLayout.setContentsMargins(0, 0, 5, 0)
        self.groupBoxRight.setLayout(rightPanelLayout)

        self.labelShow = wgt.LabelImage(vrb.folderImages + '/TriangleLeft.png')
        self.labelShow.setFixedSize(int(20 * vrb.ratio), int(20 * vrb.ratio))
        self.labelShow.mousePressEvent = self.showRightPanel

        self.groupBoxRightHide = qt.QGroupBox()
        rightPanelHideLayout = qt.QGridLayout()
        rightPanelHideLayout.addWidget(self.labelShow, 0, 1,Qt.AlignRight | Qt.AlignTop)
        rightPanelHideLayout.setContentsMargins(0, 5, 5, 0)
        self.groupBoxRightHide.setLayout(rightPanelHideLayout)
        self.groupBoxRightHide.setVisible(False)

        self.groupBoxProcessing = GroupBoxProcessing()

        self.graphicElements = GraphicElements(mainWindow=self)

        self.aboutWidget = AboutWidget()

        self.widgetDeleteAll = WidgetDeleleAll(widgetLabelImage=self.widgetLabelImage)

        self.groupMenu = GroupMenu(mainWindow=self)
        self.groupContrast = self.groupMenu.groupContrast

        self.colorWidget = SettingsWidget.ColorWidget()
        self.postProcessWidget = SettingsWidget.PostProcessSettingsWidget()
        self.folder3DWidget = SettingsWidget.Folder3DWidget()
        self.zStackFocusWidget = SettingsWidget.ZStackFocusWidget()
        self.interfacePreferencesWidget = SettingsWidget.InterfacePreferencesWidget()
        self.diskImagesPreferencesWidget = SettingsWidget.DiskImagesPreferencesWidget()

        self.widgetAddModule = SettingsWidget.WidgetAddModule()
        self.widgetDeleteModule = SettingsWidget.WidgetDeleteModule()

        self.widgetContrast = WidgetContrast()
        self.widgetContrast.setValues(50, 50)

        self.groupBoxImageViewerAndMovieMaker = qt.QGroupBox()
        layoutImageViewerAndMovieMaker = qt.QGridLayout()
        self.groupBoxImageViewerAndMovieMaker.setLayout(layoutImageViewerAndMovieMaker)
        layoutImageViewerAndMovieMaker.setContentsMargins(0,0,0,int(10*vrb.ratio))
        layoutImageViewerAndMovieMaker.setVerticalSpacing(int(10*vrb.ratio))
        layoutImageViewerAndMovieMaker.addWidget(self.widgetImage,0,0)
        layoutImageViewerAndMovieMaker.addWidget(self.groupBoxProcessing,0,0)
        layoutImageViewerAndMovieMaker.addWidget(self.movieMakerWithMenu,1,0)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.groupMenu, 0, 0, 1, 3)
        self.layout.addWidget(self.tabWidgetLeft, 1, 0)
        self.layout.addWidget(self.groupBoxButtonsArrow, 1, 0,Qt.AlignRight | Qt.AlignTop)
        self.layout.addWidget(self.viewer3dSettingsScrollArea, 2, 0)
        self.layout.addWidget(self.groupBoxImageViewerAndMovieMaker, 1, 1,2,1)
        self.layout.addWidget(self.groupBoxRight, 1, 2,2,1, Qt.AlignTop)
        self.layout.addWidget(self.groupBoxRightHide, 1, 2,2,1, Qt.AlignTop)

        self.groupBoxProcessing.setVisible(False)

        self.setLayout(self.layout)
        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(self.margins, self.margins, self.margins, self.margins)
        # self.setMinimumSize(1024*vrb.ratio, 780*vrb.ratio)
        self.setMinimumSize(1024, 780)
        # self.resize(1310*vrb.ratio, 780*vrb.ratio)
        self.resize(1310, 780)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.groupMenu.groupContrast.buttonBrigthness.clicked.connect(self.showContrastWindow)
        self.groupMenu.groupMeasure.buttonDelete.clicked.connect(self.graphicElements.deleteAllLineMeasure)
        self.groupMenu.groupBoxZone.buttonScissors.clicked.connect(self.buttonCropImage)
        self.groupMenu.groupUser.buttonOpen.clicked.connect(self.importImages)
        self.groupMenu.groupUser.buttonOpen_Multi.clicked.connect(self.importMultiImages)
        self.groupMenu.groupUser.buttonOpen_Raw.clicked.connect(self.rawWidget.show)
        self.groupMenu.groupUser.buttonOpen_Disk_Image.clicked.connect(self.importImagesDisk)
        self.groupMenu.groupUser.buttonOpen_Multi_Disk.clicked.connect(self.importMultiImagesDisk)
        self.groupMenu.groupUser.buttonSave.clicked.connect(self.saveImages)
        self.groupMenu.groupPostProcess.buttonRefresh.clicked.connect(self.postProcess)
        self.groupMenu.groupMove.buttonHome.clicked.connect(self.resetView)
        self.groupMenu.buttonScreen.clicked.connect(self.getImageOnScreen)

        self.groupMenu.groupMeasure.buttonMeasuresTable.clicked.connect(self.showMeasuresTable)


        if vrb.isRunTime == False:
            self.groupMenu.buttonEditMacro.clicked.connect(self.createNewMacro)
        self.groupMenu.groupPostProcess.buttonBack.clicked.connect(self.beforeProcess)

        # if vrb.isORS == False and vrb.isDigisens == False and PyIPSDK.are3dProcessesSupported():
        #     self.groupMenu.button3DViewer.clicked.connect(self.open3DViewer)

        self.groupMenu.groupBoxCamera.buttonLive.clicked.connect(self.displayCamera)
        self.groupMenu.groupBoxCamera.buttonCamera.clicked.connect(self.acquireImage)

        if vrb.isRunTime == False:
            self.groupMenu.buttonMachineLearning.clicked.connect(self.launchMachineLearning)
            
        self.groupMenu.buttonMovieMaker.clicked.connect(self.displayMovieMaker)

        self.imageViewer.signalNewImage.connect(self.addLabelsFromUrls)

        self.widgetLabelImage.signalLabelDeletePosition.connect(self.labelDeleted)
        self.widgetLabelImage.signalDoubleClickLabel.connect(self.changeCurrentXmlElementFromDoubleClick)
        self.widgetLabelImage.SignalNameHasChanged.connect(self.updateCurrentFunction)
        self.widgetImage.SignalRefreshPreview.connect(self.computePreview)
        self.widgetImage.imageViewerStandAloneNormal.SignalExtractImage.connect(self.extractImage)
        self.widgetImage.imageViewerStandAloneX.SignalExtractImage.connect(self.extractImage)
        self.widgetImage.imageViewerStandAloneY.SignalExtractImage.connect(self.extractImage)
        self.widgetImage.imageViewerStandAloneZ.SignalExtractImage.connect(self.extractImage)
        self.widgetImage.SignalPlanChanged.connect(self.updateLineProfile)
        self.widgetImage.SignalOverlayChanged.connect(self.setPostProcessVisible)
        # self.widgetImage.rangeSlider.signalValueChanged.connect(self.viewer3dSettingsWidget.viewerNapariThreshold)


        self.widgetContrast.signalValueChanged.connect(self.widgetImage.actualizeScene)

        self.categorySpoilersContainer.SignalCurrentFunctionChanged.connect(self.updateCurrentFunction)

        self.graphicElements.SignalComputePreview.connect(self.computePreview)

        self.parent.menuBar.actionAbout.triggered.connect(self.showAbout)
        self.parent.menuBar.actionDocumentation.triggered.connect(self.showDocMainPage)
        self.parent.menuBar.actionSaveExplorerSessionProcessOnly.triggered.connect(self.saveExplorerSessionProcessOnly)
        self.parent.menuBar.actionSaveExplorerSessionProcessAndInputImages.triggered.connect(self.saveExplorerSessionProcessAndInputImages)
        self.parent.menuBar.actionSaveExplorerSessionAllElements.triggered.connect(self.saveExplorerSessionComplete)
        self.parent.menuBar.actionLoadExplorerSession.triggered.connect(self.loadExplorerSession)
        self.parent.menuBar.actionLoad.triggered.connect(self.importImages)
        self.parent.menuBar.actionLoadImageDisk.triggered.connect(self.importImagesDisk)
        self.parent.menuBar.actionLoadMulti.triggered.connect(self.importMultiImages)
        self.parent.menuBar.actionLoadMultiAsSequence.triggered.connect(self.importMultiImagesAsSequence)
        self.parent.menuBar.actionLoadStl.triggered.connect(self.importStl)
        self.parent.menuBar.actionSave.triggered.connect(self.saveImages)
        self.parent.menuBar.actionSaveAsMultiSlices.triggered.connect(self.saveImageMultislices)
        self.parent.menuBar.actionClearAll.triggered.connect(self.widgetDeleteAll.showWidget)
        self.widgetDeleteAll.buttonYes.clicked.connect(self.clearAllImages)
        self.parent.menuBar.actionDisplayThumbails.triggered.connect(self.displayThumbails)
        # self.parent.menuBar.actionViewer3D.triggered.connect(self.showViewer3DPreference)
        self.parent.menuBar.actionColorPreference.triggered.connect(self.showColorPreference)
        self.parent.menuBar.actionPostProcessPreference.triggered.connect(self.showPostProcessPreference)
        self.parent.menuBar.actionAddModule.triggered.connect(self.showAddModule)
        self.parent.menuBar.actionDeleteModule.triggered.connect(self.showDeleteModule)
        self.parent.menuBar.actionZStackFocusPreferences.triggered.connect(self.showZStackFocusWidget)
        self.parent.menuBar.actionSettingsDiskImages.triggered.connect(self.showDiskImagesPreferences)
        self.parent.menuBar.actionInterfacePreferences.triggered.connect(self.showInterfacePreferences)
        if vrb.isRunTime == False:
            self.parent.menuBar.actionNewMacro.triggered.connect(self.createNewMacro)
        self.parent.menuBar.actionImportMacro.triggered.connect(self.importMacro)
        self.parent.menuBar.actionExportMacro.triggered.connect(self.exportMacro)
        self.parent.menuBar.actionImportMacroInterface.triggered.connect(self.importMacroInterface)
        self.parent.menuBar.actionExportMacroInterface.triggered.connect(self.exportMacroInterface)
        self.parent.menuBar.actionDeleteMacroInterface.triggered.connect(self.deleteMacroInterface)
        # self.parent.menuBar.actionReinitializeMacro.triggered.connect(self.reinitializeMacroInterface)
        self.parent.menuBar.actionBenchmark.triggered.connect(self.openBenchmark)
        self.parent.menuBar.actionLabelPreference.triggered.connect(self.openLabelPreferences)
        self.parent.menuBar.actionSievesPreference.triggered.connect(self.openSievePreferences)
        self.parent.menuBar.actionImportSieves.triggered.connect(self.importSieves)
        self.parent.menuBar.actionAddLut.triggered.connect(self.addNewLut)
        self.parent.menuBar.actionManageLut.triggered.connect(self.manageLut)
        self.parent.menuBar.actionMachineLearningImportSegmentation.triggered.connect(self.importModelSegmentation)
        self.parent.menuBar.actionMachineLearningImportClassification.triggered.connect(self.importModelClassification)
        self.parent.menuBar.actionMachineLearningImportSuperPixelSegmentation.triggered.connect(self.importModelSuperPixelSegmentation)
        self.parent.menuBar.actionMachineLearningExportSegmentation.triggered.connect(self.exportModelSegmentation)
        self.parent.menuBar.actionMachineLearningExportClassification.triggered.connect(self.exportModelClassification)
        self.parent.menuBar.actionMachineLearningExportSuperPixelSegmentation.triggered.connect(self.exportModelSuperPixelSegmentation)
        self.parent.menuBar.actionUpdateFunctions.triggered.connect(self.updateAllFunctions)

        self.imageViewer.setContextMenuPolicy(Qt.CustomContextMenu)
        self.viewerNapariQt.setContextMenuPolicy(Qt.CustomContextMenu)
        self.imageViewer.customContextMenuRequested.connect(self.rightMenu)
        self.viewerNapariQt.customContextMenuRequested.connect(self.rightMenu)

        self.groupBoxProcessing.buttonStop.clicked.connect(self.terminateThread)

        # Signaux à remettre chaque fois que le thread est redéfini
        self.threadProcess.SignalFinishProcess.connect(self.finishProcess)
        # self.threadProcess.SignalActualizeProgressBar.connect(self.actualizeProgressBar)
        self.threadProcess.SignalActualizeTime.connect(self.actualizeTime)

        self.tabWidgetLeft.currentChanged.connect(self.verifTabWidgetLeft)

        if PyIPSDK.areModulesHiddenInExplorer() == True:
            self.groupBoxRight.setVisible(False)
        else:
            if PyIPSDK.are3dProcessesSupported() == False:
                self.groupBoxSelectionDimension.radioButton2D.setChecked(True)
                self.groupBoxSelectionDimension.setVisible(False)
                self.changeDisplayedFunctions()

        self.actualizeFunctionFilter()
        # self.actualizeFunctionMachineLearning()
        self.loadRightPanel()
        self.loadMacroUser()
        self.widgetImage.changeModeViewer("2D")
        self.initDone = True

        self.viewerNapari.camera.events.angles.connect(self.cameraChanged)
        self.viewerNapari.camera.events.zoom.connect(self.cameraChanged)
        self.viewerNapari.camera.events.center.connect(self.cameraChanged)
        # self.viewerNapariQt.canvas.events.mouse_move.connect(self.cameraChanged)

        self.viewerNapariQt.dragEnterEvent = self.dragEnterEventNapari
        self.viewerNapariQt.dragMoveEvent = self.dragMoveEventNapari
        self.viewerNapariQt.dropEvent = self.dropEventNapari

        self.viewerNapari.camera.perspective = 60

    # handle ctrl+c event on napari
    @napari.Viewer.bind_key('Control-C')
    def copyToClipboardKeyboardEvent(self):
        vrb.mainWindow.copyToClipBoard()


    def resizeEvent(self, event):
        self.groupMenu.setFixedWidth(self.width())
        heightMenu = 115*vrb.ratio
        tabWidth = 200*vrb.ratio
        if self.groupMenu.buttonMovieMaker.activate:
            heightMovieMaker = 195*vrb.ratio
        else:
            heightMovieMaker = 0

        if PyIPSDK.areModulesHiddenInExplorer() == True:
            rightWidth = 0
        else:
            if self.rightPanelShown:
                rightWidth = 390*vrb.ratio
                self.groupBoxRight.setFixedSize(int(rightWidth), max(1, int(self.height() * 100 / 100 - heightMenu)))
            else:
                rightWidth = 30 * vrb.ratio
                self.groupBoxRightHide.setFixedSize(int(30*vrb.ratio), max(1,int(self.height() * 100 / 100 - heightMenu)))
        if self.widgetImage.modeViewer == "2D" or self.tabWidgetLeft.currentIndex()==1:
            self.tabWidgetLeft.setFixedSize(int(tabWidth), max(1,int(self.height() * 100 / 100 - heightMenu)))
        else:
            self.tabWidgetLeft.setFixedSize(int(tabWidth), max(1,int(self.height() * 50 / 100 - heightMenu)))
        self.viewer3dSettingsScrollArea.setFixedSize(int(tabWidth), max(1,int(self.height() * 50 / 100 - 25*vrb.ratio)))

        self.groupBoxImageViewerAndMovieMaker.setFixedSize(max(1, int(self.width() * 100 / 100 - tabWidth - rightWidth - 10 * vrb.ratio)), max(1, int(self.height() * 100 / 100 - heightMenu)))
        self.widgetImage.setFixedSize(max(1,int(self.width() * 100 / 100 - tabWidth - rightWidth - 10*vrb.ratio)), max(1,int(self.height() * 100 / 100 - heightMenu - heightMovieMaker)))
        self.groupBoxProcessing.setFixedSize(max(1,int(self.width() * 100 / 100 - tabWidth - rightWidth - 10*vrb.ratio)), max(1,int(self.height() * 100 / 100 - heightMenu - heightMovieMaker)))
        self.movieMakerWithMenu.setFixedSize(max(1,int(self.width() * 100 / 100 - tabWidth - rightWidth - 10*vrb.ratio)),max(1,int(heightMovieMaker-30*vrb.ratio)))


    # Shows a table of all measures drawn in the current image
    def showMeasuresTable(self):

        # get xml infos
        graphicXmlElementElement = Dfct.SubElement(self.currentXmlElement, "GraphicXmlElement")
        allLineMeasureElement = Dfct.SubElement(graphicXmlElementElement, "AllLineMeasures")

        # get calibration of the image to calibrate the measures values
        try:
            calibration = vrb.mainWindow.currentLabel.image.getGeometricCalibration()
            xScale = calibration.getXScale()
            yScale = calibration.getYScale()
            if vrb.mainWindow.currentLabel.image.getSizeZ() > 1:
                zScale = calibration.getZScale()
            unit = calibration.getUnitStr()
        except:
            xScale = 1
            yScale = 1
            unit = "px"

        # create arrays of coordinates for first point and last point of a measure
        # if in 3D, 2 points will give the current plane depending on the axis
        # if in 2D, the current axis is Z=0
        pointsX1 = []
        pointsX2 = []
        pointsY1 = []
        pointsY2 = []
        pointsZ1 = []
        pointsZ2 = []
        # arrays of lengths of the measures
        lengths = []
        for child in allLineMeasureElement:
            if self.currentLabel.image.getSizeZ() > 1:
                axis = Dfct.childText(child, "Axis") # name of the axis
                plan = int(Dfct.childText(child, "AxisValue")) # value of the current plan
            else:
                axis = "Z"
                plan = 0

            # get the first point and the last point coordinates of the line measure
            allPointsElement = Dfct.SubElement(child, "AllPoints")
            pointsX = []
            pointsY = []
            pointsZ = []
            for child2 in allPointsElement:  # child2 = Point
                for child3 in child2:
                    if child3.tag == "PointX":
                        pointX = float(child3.text)
                        # append the point inside a list depending on the current axis
                        if axis == "Z":
                            pointsX.append(pointX)
                        elif axis == "Y":
                            pointsX.append(pointX)
                        elif axis == "X":
                            pointsY.append(pointX)
                    elif child3.tag == "PointY":
                        pointY = float(child3.text)
                        # append the point inside a list depending on the current axis
                        if axis == "Z":
                            pointsY.append(pointY)
                        elif axis == "Y":
                            pointsZ.append(pointY)
                        elif axis == "X":
                            pointsZ.append(pointY)

                    # append the current plan value depending on the current axis
                    if axis == "Z":
                        pointsZ.append(plan)
                    elif axis == "Y":
                        pointsY.append(plan)
                    elif axis == "X":
                        pointsX.append(plan)

            pointsX1.append(pointsX[0])
            pointsX2.append(pointsX[1])
            pointsY1.append(pointsY[0])
            pointsY2.append(pointsY[1])
            pointsZ1.append(pointsZ[0])
            pointsZ2.append(pointsZ[1])

            if axis == "Z":
                length = math.sqrt(pow((pointsX[1]*xScale-pointsX[0]*xScale),2)+pow((pointsY[1]*yScale-pointsY[0]*yScale),2))
            elif axis == "Y":
                length = math.sqrt(pow((pointsX[1]*xScale-pointsX[0]*xScale),2)+pow((pointsZ[1]*zScale-pointsZ[0]*zScale),2))
            elif axis == "X":
                length = math.sqrt(pow((pointsY[1]*yScale-pointsY[0]*yScale),2)+pow((pointsZ[1]*zScale-pointsZ[0]*zScale),2))
            lengths.append(length)

        # create the dictionnary for the table
        try:
            ddict = {}
            ddict["Index"] = []
            for i in range(len(allLineMeasureElement)):
                ddict["Index"].append(i)

            ddict["Lengths (" + str(unit) + ")"] = lengths

            ddict["X1"] = pointsX1
            ddict["Y1"] = pointsY1
            ddict["Z1"] = pointsZ1
            ddict["X2"] = pointsX2
            ddict["Y2"] = pointsY2
            ddict["Z2"] = pointsZ2

            table = display.TableWidgetWindow(ddict, stats=True)
            table.setWindowTitle("Measures list")

            fct.showWidget(table)
        except:
            traceback.print_exc(file=sys.stderr)


    def cameraChanged(self, event=None):

        if napari.__version__.startswith('0.4'):
            try:
                if self.viewer3dSettingsWidget.viewerSettings.radioButtonCameraNormal.isChecked():
                    view_direction = np.asarray(self.viewerNapari.camera.view_direction)

                    for num in range(self.widgetLabelImage.layout.count()):
                        item = self.widgetLabelImage.layout.itemAt(num)
                        if item is not None:
                            label = item.widget()
                            if label.visual is not None:
                                label.visual.node.shading_filter.light_dir = -view_direction[::-1]
                else:
                    cameraCenter = self.viewerNapariQt.canvas.camera._view.camera.center

                    for num in range(self.widgetLabelImage.layout.count()):
                        item = self.widgetLabelImage.layout.itemAt(num)
                        if item is not None:
                            label = item.widget()
                            if label.objectType == "Mesh" and label.hasNapari:
                                view_direction = np.asarray([label.meshCenter[0]-cameraCenter[0],
                                                  label.meshCenter[1]-cameraCenter[1],
                                                  label.meshCenter[2]-cameraCenter[2]])
                                if label.visual is not None:
                                    label.visual.node.shading_filter.light_dir = -view_direction
            except:
                traceback.print_exc(file=sys.stderr)
        # elif napari.__version__.startswith('0.5'):
        else:
            try:
                if self.viewer3dSettingsWidget.viewerSettings.radioButtonCameraNormal.isChecked():
                    view_direction = np.asarray(self.viewerNapari.camera.view_direction)

                    for num in range(self.widgetLabelImage.layout.count()):
                        item = self.widgetLabelImage.layout.itemAt(num)
                        if item is not None:
                            label = item.widget()
                            if label.visual is not None:
                                label.visual.node.shading_filter.light_dir = view_direction[::-1]

                if self.viewer3dSettingsWidget.viewerSettings.radioButtonCameraFly.isChecked():

                    cameraCenter = self.viewerNapariQt.canvas.camera._view.camera.center

                    for num in range(self.widgetLabelImage.layout.count()):
                        item = self.widgetLabelImage.layout.itemAt(num)
                        if item is not None:
                            label = item.widget()
                            if label.objectType == "Mesh" and label.hasNapari:
                                view_direction = np.asarray([label.meshCenter[0] - cameraCenter[0],
                                                             label.meshCenter[1] - cameraCenter[1],
                                                             label.meshCenter[2] - cameraCenter[2]])
                                if label.visual is not None:
                                    label.visual.node.shading_filter.light_dir = view_direction
                            elif label.objectType == "Image" and label.hasNapari:
                                view_direction = np.asarray([label.image.getSizeX() - cameraCenter[0],
                                                             label.image.getSizeY() - cameraCenter[1],
                                                             label.image.getSizeZ() - cameraCenter[2]])
                                if label.visual is not None:
                                    label.visual.node.shading_filter.light_dir = view_direction

            except:
                traceback.print_exc(file=sys.stderr)

    def downImage(self):

        try:
            if self.currentLabel is not None:
                currentNum = None
                for num in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        if label == self.currentLabel:
                            currentNum = num
                if currentNum is not None:
                    itemAfter = self.widgetLabelImage.layout.itemAt(currentNum+1)
                    if itemAfter is not None:
                        labelAfter = itemAfter.widget()
                        self.widgetLabelImage.layout.insertWidget(currentNum,labelAfter)
                        self.widgetLabelImage.layout.insertWidget(currentNum+1,self.currentLabel)

            self.updateNapariLayers()

        except:
            traceback.print_exc(file=sys.stderr)

    def upImage(self):

        try:
            if self.currentLabel is not None:
                currentNum = None
                for num in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        if label == self.currentLabel:
                            currentNum = num
                if currentNum is not None:
                    itemBefore = self.widgetLabelImage.layout.itemAt(currentNum-1)
                    if itemBefore is not None:
                        labelBefore = itemBefore.widget()
                        self.widgetLabelImage.layout.insertWidget(currentNum,labelBefore)
                        self.widgetLabelImage.layout.insertWidget(currentNum-1,self.currentLabel)

            self.updateNapariLayers()

        except:
            traceback.print_exc(file=sys.stderr)

    def updateNapariLayers(self):

        try:
            listIndex = []
            for num in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        if label.hasNapari:
                            if len(label.linkedLayers) != 0:
                                for layer in label.linkedLayers:
                                    idx = self.getIndexNapari(layer)
                                    listIndex.append(idx)
                            else:
                                idx = self.getIndexNapari(label.layer)
                                listIndex.append(idx)
            if len(listIndex) != 0:
                self.viewerNapari.layers.move_multiple(listIndex)

        except:
            traceback.print_exc(file=sys.stderr)

    def getIndexNapari(self,layer):

        idx = -1
        for i in range(len(self.viewerNapari.layers)):
            if self.viewerNapari.layers[i] == layer:
                idx = i

        return idx

    def saveBackupSession(self,nameFunction=""):

        saveSessions = Dfct.readElementFromSettings("SaveBackupSessions")

        if saveSessions == "True":
            date = datetime.now()
            dateFormated = date.strftime("%Y_%m_%d_%H_%M_%S")
            filename = os.path.join(vrb.currentFolderSessionBackup,dateFormated + "_" + nameFunction + ".zip")
            self.saveExplorerSession(save="processOnly",filename=filename,backup = True)

    def saveExplorerSessionProcessOnly(self):

        self.saveExplorerSession(save="processOnly")

    def saveExplorerSessionProcessAndInputImages(self):

        self.saveExplorerSession(save="processAndInputImages")

    def saveExplorerSessionComplete(self):

        self.saveExplorerSession(save="complete")

    def saveExplorerSession(self,save="complete",filename = None,backup=False):

        try:
            if filename is None:
                filename = qt.QFileDialog.getSaveFileName(self, "Save session", vrb.folderSessions + "/", "session file (*.zip)")
                filename = filename[0]
            if filename != None and filename != '':

                if os.path.exists(filename):
                    os.remove(filename)

                self.groupBoxProcessing.setText('Saving session...\nPlease wait.')
                self.groupBoxProcessing.buttonStop.setVisible(False)
                self.groupBoxProcessing.progressBar.setVisible(False)
                self.toggleGroupBoxProcessing(True)

                nameFolder, file_extension = os.path.splitext(filename)
                os.makedirs(nameFolder)

                listAttributs = []
                listAllOtherElements = []
                allElements = Dfct.SubElement(self.xmlElement,"AllElements")

                # Dfct.saveXmlElement(allElements, "C:/dev/allElement.mho", forceSave=True)
                for child in allElements:

                    saved = True
                    elementID = Dfct.childText(child,"ElementID")

                    # print("dict element = ", vrb.dictElements)
                    # print("element ID = ", elementID)

                    # Checks if the element exists inside the dictionnary
                    if elementID in vrb.dictElements:
                        currentElement = vrb.dictElements[elementID]
                    else:
                        continue

                    currentDict = currentElement[0]

                    if save == "complete":
                        try:
                            if currentDict['Type'] == "Image":
                                PyIPSDK.saveTiffImageFile(nameFolder + '/' + elementID + ".tif", currentElement[1])
                                fct.updateListAttributs(currentElement[1], listAttributs,elementID)
                            elif currentDict['Type'] == "Mesh":
                                PyIPSDK.writeToBinaryFile(nameFolder + '/' + elementID + ".bin", currentElement[1])
                            else:
                                try:
                                    if hasattr(currentElement[1], 'value'):
                                        try:
                                            PyIPSDK.writeToBinaryFile(nameFolder + '/' + elementID + ".bin",currentElement[1].value)
                                            attribut_value = currentElement[1].value
                                            del currentElement[1].value

                                            with open(nameFolder + '/' + elementID + ".pkl", "wb") as fichier:
                                                pickle.dump(currentElement[1], fichier)

                                            currentElement[1].value = attribut_value
                                        except:
                                            with open(nameFolder + '/' + elementID + ".pkl", "wb") as fichier:
                                                pickle.dump(currentElement[1], fichier)
                                    else:
                                        PyIPSDK.writeToBinaryFile(nameFolder + '/' + elementID + ".bin",currentElement[1])
                                        fct.updateListAttributs(currentElement[1],listAttributs,elementID)
                                except:
                                    traceback.print_exc(file=sys.stderr)
                                    saved = False
                                if saved:
                                    listAllOtherElements.append(elementID)

                            if saved:
                                with open(nameFolder + '/' + elementID + '.json', 'w') as file_json:
                                    json.dump(currentDict, file_json)
                        except:
                            pass

                    elif save in ["processOnly","processAndInputImages"]:
                        if save == "processAndInputImages":

                            xmlFunctionCall = vrb.dictElements[elementID][2]

                            if currentDict['Type'] == "Image" and Dfct.childText(xmlFunctionCall,"Name") == "LoadImage":
                                PyIPSDK.saveTiffImageFile(nameFolder + '/' + elementID + ".tif", currentElement[1])
                        if currentDict['Type'] not in ["Image","Mesh"]:
                            listAllOtherElements.append(elementID)
                        with open(nameFolder + '/' + elementID + '.json', 'w') as file_json:
                            json.dump(currentDict, file_json)

                listImagesAndMesh = []
                for num in range(self.widgetLabelImage.layout.count()):
                    try:
                        item = self.widgetLabelImage.layout.itemAt(num)
                        if item is not None:
                            label = item.widget()
                            element = label.xmlElement
                            listImagesAndMesh.append(Dfct.childText(element,"ElementID"))
                    except:
                        pass

                with open(nameFolder + '/listImagesAndMesh.json', 'w') as file_json:
                    json.dump(listImagesAndMesh, file_json)
                with open(nameFolder + '/listAllOtherElements.json', 'w') as file_json:
                    json.dump(listAllOtherElements, file_json)
                if save == "complete":
                    with open(nameFolder + '/listAttributs.json', 'w') as file_json:
                        json.dump(listAttributs, file_json)

                Dfct.saveXmlElement(self.xmlElement,nameFolder + "/xmlElement.mho")

                shutil.make_archive(nameFolder, 'zip', nameFolder)

                shutil.rmtree(nameFolder)

                if backup == False:
                    vrb.sessionIsSaved = True

                self.toggleGroupBoxProcessing(False)

        except:
            self.toggleGroupBoxProcessing(False)
            traceback.print_exc(file=sys.stderr)
            try:
                if os.path.exists(nameFolder):
                    os.remove(nameFolder)
            except:
                pass

    def loadExplorerSession(self):

        if vrb.hasImage:
            messageBox = MessageBox('Your session is already initialized', 'Please restart the application\nbefore loading a session', buttons=[qt.QMessageBox.Ok], icon=qt.QMessageBox.Warning)
            res = messageBox.exec()
            return

        vrb.mainWindow.toggleGroupBoxProcessing(True)
        vrb.mainWindow.groupBoxProcessing.setText('Loading Explorer session...\nPlease wait.')
        vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(False)
        vrb.mainWindow.groupBoxProcessing.progressBar.setVisible(False)
        qt.QApplication.processEvents()

        sessionName = qt.QFileDialog.getOpenFileName(self, "Select your session file", vrb.folderSessions + "/", "Session" + " (*.zip)")
        sessionName = sessionName[0]

        if sessionName != [] and sessionName != '' and sessionName != None:

            sessionDir = os.path.dirname(sessionName)
            sessionBaseName = os.path.splitext(os.path.basename(sessionName))[0]
            tempDir = os.path.join(sessionDir, sessionBaseName)

        try:
            with zipfile.ZipFile(sessionName, 'r') as zip_ref:
                zip_ref.extractall(tempDir)

            fileXmlElement = xmlet.parse(os.path.join(tempDir, "xmlElement.mho"))
            self.xmlElement = fileXmlElement.getroot()
            allElements = Dfct.SubElement(self.xmlElement,'AllElements')
            with open(os.path.join(tempDir, "listImagesAndMesh.json"), 'r', encoding='utf-8') as file:
                listImagesAndMesh = json.load(file)
            with open(os.path.join(tempDir, "listAllOtherElements.json"), 'r', encoding='utf-8') as file:
                listAllOtherElements = json.load(file)
            if os.path.exists(os.path.join(tempDir, "listAttributs.json")):
                with open(os.path.join(tempDir, "listAttributs.json"), 'r', encoding='utf-8') as file:
                    listAttributs = json.load(file)
                load = "complete"
            else:
                load = "processOnly"

            dictElements = {}
            if load == "processOnly":
                dictElements = self.computeAllElements(allElements,tempDir)

            for elementID in listImagesAndMesh:
                with open(os.path.join(tempDir, elementID + ".json"), 'r', encoding='utf-8') as file:
                    element = json.load(file)
                    if element["Type"] == "Image":
                        if elementID in dictElements:
                            image = dictElements[elementID]
                        else:
                            image = PyIPSDK.loadTiffImageFile(os.path.join(tempDir, elementID + ".tif"))
                        label, name = self.addResult(image,element,id=elementID)
                    elif element["Type"] == "Mesh":
                        if elementID in dictElements:
                            mesh = dictElements[elementID]
                        else:
                            mesh,_ = PyIPSDK.readFromBinaryFile(os.path.join(tempDir, elementID + ".bin"))
                        label, name = self.addResult(mesh,element,id=elementID)
                    for child in allElements:
                        if Dfct.childText(child, "ElementID") == elementID:
                            label.xmlElement = child

            for elementID in listAllOtherElements:
                with open(os.path.join(tempDir, elementID + ".json"), 'r', encoding='utf-8') as file:
                    element = json.load(file)
                    if elementID in dictElements:
                        objectValue = dictElements[elementID]
                    else:
                        if os.path.exists(os.path.join(tempDir, elementID + ".pkl")):
                            with open(os.path.join(tempDir, elementID + ".pkl"),"rb") as file:
                                    objectValue = pickle.load(file)
                            if os.path.exists(os.path.join(tempDir, elementID + ".bin")):
                                value, _ = PyIPSDK.readFromBinaryFile(os.path.join(tempDir, elementID + ".bin"))
                                objectValue.value = value
                        elif os.path.exists(os.path.join(tempDir, elementID + ".bin")):
                            objectValue, _ = PyIPSDK.readFromBinaryFile(os.path.join(tempDir, elementID + ".bin"))

                    functionXmlElement = None

                    for child in allElements:
                        if Dfct.childText(child, "ElementID") == elementID:
                            functionXmlElement = Dfct.SubElement(child,'FunctionCall')

                    if functionXmlElement is None:
                        functionXmlElement = xmlet.Element('FunctionCall')

                    label, name = self.addResult(objectValue, element,functionXmlElement=functionXmlElement, id=elementID)
                    for child in allElements:
                        if Dfct.childText(child, "ElementID") == elementID:
                            label.xmlElement = child

            if load == "complete":
                for attribut in listAttributs:
                    if attribut[2] is not None:
                        setattr(vrb.dictElements[attribut[0]][1],attribut[1],vrb.dictElements[attribut[2]][1])
                    else:
                        setattr(vrb.dictElements[attribut[0]][1],attribut[1],None)

            self.widgetLabelImage.xmlElement = allElements
            self.widgetLabelValue.xmlAllValues = allElements
            self.widgetLabelValue.centralWidget.xmlElement = allElements
            for outType in WidgetTypes.OutputType:
                if outType != WidgetTypes.OutputType.IMAGE:
                    self.widgetLabelValue.centralWidget.spoilers[outType.value].xmlElement = allElements

            self.changeCurrentXmlElement(self.widgetLabelImage.layout.itemAt(self.widgetLabelImage.layout.count()-1).widget())

            vrb.mainWindow.toggleGroupBoxProcessing(False)

        except:
            traceback.print_exc(file=sys.stderr)
            vrb.mainWindow.toggleGroupBoxProcessing(False)

        try:
            shutil.rmtree(tempDir)
        except:
            pass

    def computeAllElements(self,allElements,tempDir):

        dictElements = {}

        for child in allElements:
            elementID = Dfct.childText(child, "ElementID")
            xmlFunctionCall = Dfct.SubElement(child, "FunctionCall")
            functionName = Dfct.childText(xmlFunctionCall, 'Name')

            textFunction = dictAllFunctions[functionName](xmlFunctionCall)

            if functionName == "LoadImage":

                if os.path.exists(os.path.join(tempDir, elementID + ".tif")):
                    image = PyIPSDK.loadTiffImageFile(os.path.join(tempDir, elementID + ".tif"))
                    globals()["ID_Image_" + elementID + "_ID"] = image
                    dictElements[elementID] = image

                else:
                    _locals = locals()
                    exec(textFunction, globals(), _locals)
                    globals()["ID_Image_" + elementID + "_ID"] = _locals['outImage']
                    dictElements[elementID] = _locals['outImage']

            else:
                if elementID not in dictElements:
                    associatedID = Dfct.SubElement(child, "AssociatedID").text
                    associatedID = associatedID.split(",")

                    _locals = locals()
                    exec(textFunction, globals(), _locals)
                    outputs = _locals['outputs']
                    if len(associatedID)==1:
                        globals()["ID_Image_" + associatedID[0] + "_ID"] = outputs
                        dictElements[associatedID[0]] =outputs
                    else:
                        for i in range(len(associatedID)):
                            print(textFunction)
                            globals()["ID_Image_" + associatedID[i] + "_ID"] = outputs[i]
                            dictElements[associatedID[i]] =outputs[i]

        return dictElements

    def dragEnterEventNapari(self, event):

        if event.mimeData().hasUrls:
            event.accept()
        else:
            event.ignore()

    def dragMoveEventNapari(self, event):

        if event.mimeData().hasUrls:
            event.accept()
        else:
            event.ignore()

    def dropEventNapari(self, event):

        if event.mimeData().hasUrls:
            urls = event.mimeData().urls()
            self.addLabelsFromUrls(urls)
            self.resetView()

    def displayMovieMaker(self):

        self.groupMenu.buttonMovieMaker.changeActivation()
        self.movieMakerWithMenu.setVisible(self.groupMenu.buttonMovieMaker.activate)
        self.movieMakerWithMenu.movieMakerScrollArea.centralWidget.sliderPlay.splitter.moveSplitter(0, 1)

        self.resizeEvent(None)


    def updateAllFunctions(self):

        vrb.mainWindow.toggleGroupBoxProcessing(True)
        vrb.mainWindow.groupBoxProcessing.setText('Updating functions...\n')
        vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(False)
        vrb.mainWindow.groupBoxProcessing.progressBar.setVisible(False)
        qt.QApplication.processEvents()

        import scriptsCreation._GenerateAllFunctions

        vrb.mainWindow.toggleGroupBoxProcessing(False)

        messageBox = wgt.MessageBox('Functions updated, please restart Explorer to apply the modifications', '', buttons=[qt.QMessageBox.Ok], windowTitle="Updated functions")
        messageBox.exec()

    def getImageOnScreen(self):

        vrb.mainWindow.toggleGroupBoxProcessing(True)
        vrb.mainWindow.groupBoxProcessing.setText('Converting image on the screen\n')
        vrb.mainWindow.groupBoxProcessing.buttonStop.setVisible(False)
        vrb.mainWindow.groupBoxProcessing.progressBar.setVisible(False)
        qt.QApplication.processEvents()

        if self.widgetImage.modeViewer == "2D":

            try:

                image = self.currentLabel.image
                imageViewer = self.imageViewer
                sizeX = image.getSizeX()
                sizeY = image.getSizeY()
                if self.widgetImage.imageOverlayLabel is not None and self.widgetImage.imageOverlayLabel.image is not None:
                    imageOverlay = self.widgetImage.imageOverlayLabel.image
                else:
                    imageOverlay = None

                outImage = self.widgetImage.transformImage(image,imageOverlay = imageOverlay,extractImage=True)
                # convert IPSDK image into PIL image
                if outImage.getColorGeometryType() == PyIPSDK.eCGT_Grey:
                    pilGreyImg = Image.fromarray(outImage.array)
                    pilRgbImg = Image.new("RGBA", pilGreyImg.size)
                    pilRgbImg.paste(pilGreyImg)
                else: #if rgb image
                    array = cv2.merge([outImage.array[0], outImage.array[1], outImage.array[2]])
                    pilImg = Image.fromarray(array)
                    pilRgbImg = Image.new("RGBA", pilImg.size)
                    pilRgbImg.paste(pilImg)

                #Dfct.saveXmlElement(self.xmlElement, "C:/Temp/Settings.mho", forceSave=True)

                try:
                    file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
                    settingsElement = file.getroot()
                except:
                    pass

                defaultLineMeasureColor = vrb.lineMeasureColor

                draw = ImageDraw.Draw(pilRgbImg)

                graphicXmlElementElement = Dfct.SubElement(self.currentXmlElement, "GraphicXmlElement")
                allLineMeasureElement = Dfct.SubElement(graphicXmlElementElement, "AllLineMeasures")
                for child in allLineMeasureElement:

                    # get the position x, position y and the text of the measure to copy on the image
                    textMeasurePosXElement = Dfct.SubElement(child, "TextMeasurePosX")
                    textMeasurePosX = float(textMeasurePosXElement.text)
                    textMeasurePosYElement = Dfct.SubElement(child, "TextMeasurePosY")
                    textMeasurePosY = float(textMeasurePosYElement.text)
                    textMeasureElement = Dfct.SubElement(child, "TextMeasure")
                    textMeasure = str(textMeasureElement.text)

                    vectorDirectorX = float(Dfct.childText(child, "VectorDirectorX"))
                    vectorDirectorY = float(Dfct.childText(child, "VectorDirectorY"))
                    pointSize = float(Dfct.childText(child, "PointSize"))

                    colorLineMeasureElement = Dfct.SubElement(child, "ColorLineMeasure")
                    if colorLineMeasureElement.text is not None:
                        colorLineMeasure = (colorLineMeasureElement.text).split(',')
                    else:
                        colorLineMeasure = None

                    # get the first point and the last point coordinates of the line measure
                    allPointsElement = Dfct.SubElement(child, "AllPoints")
                    pointsList = []
                    for child2 in allPointsElement: # child2 = Point
                        for child3 in child2:
                            if child3.tag == "PointX":
                                pointX = float(child3.text)
                                pointsList.append(pointX)
                            elif child3.tag == "PointY":
                                pointY = float(child3.text)
                                pointsList.append(pointY)

                    ratio = ((sizeX + sizeY) / 2)/400
                    pointSize = pointSize * ratio
                    font = ImageFont.truetype(vrb.folderFonts + "/arial.ttf", size=int(12*ratio))

                    # draw the line measure and the text of the measure
                    if colorLineMeasure is None:
                        colorMeasure = defaultLineMeasureColor
                    else:
                        colorMeasure = colorLineMeasure

                    # get text length
                    textLength = draw.textlength(textMeasure, font=font)
                    textBbox = draw.textbbox((textMeasurePosX,textMeasurePosY),textMeasure, font=font, anchor="mm")
                    textHeight = textBbox[3]-textBbox[1]

                    draw.line([(pointsList[0]-(pointSize/4)*vectorDirectorX, pointsList[1]-(pointSize/4)*vectorDirectorY), (pointsList[0]+(pointSize/4)*vectorDirectorX, pointsList[1]+(pointSize/4)*vectorDirectorY)], fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), width=int(1*ratio))
                    draw.line([(pointsList[2]-(pointSize/4)*vectorDirectorX, pointsList[3]-(pointSize/4)*vectorDirectorY), (pointsList[2]+(pointSize/4)*vectorDirectorX, pointsList[3]+(pointSize/4)*vectorDirectorY)], fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), width=int(1*ratio))
                    draw.line([(pointsList[0], pointsList[1]), (pointsList[2], pointsList[3])], fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), width=int(1*ratio))
                    
                    #differenceX = pointsList[2]-textMeasurePosX

                    distP1Text = math.sqrt(pow((textMeasurePosX-pointsList[0]), 2)+pow((textMeasurePosY-pointsList[1]),2))
                    distP2Text = math.sqrt(pow((textMeasurePosX-pointsList[2]), 2)+pow((textMeasurePosY-pointsList[3]),2))

                    # check which point is the farthest from the text position
                    if distP1Text > distP2Text:
                        differenceX = pointsList[2]-textMeasurePosX
                        differenceY = pointsList[3]-textMeasurePosY
                    else:
                        differenceX = pointsList[0]-textMeasurePosX
                        differenceY = pointsList[1]-textMeasurePosY

                    #print("text pos = ", textMeasurePosX, ", ", textMeasurePosY)
                    # print("difference = ", differenceX, ", ", differenceY)
                    #print("textlength = ", textLength/2, ", ", textHeight/2)

                    # draw.text((textMeasurePosX+differenceX, textMeasurePosY+differenceY), textMeasure, fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), anchor="mm", font=font)
                    #draw.text((textMeasurePosX+(textLength/2), textMeasurePosY+differenceY*2), textMeasure, fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), anchor="mm", font=font)
                    draw.text((textMeasurePosX+differenceX+(textLength/2), textMeasurePosY+differenceY*2+(textHeight/2)), textMeasure, fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), anchor="mm", font=font)
                    #draw.text((textMeasurePosX, (textMeasurePosY+(10*vrb.ratio))), textMeasure, fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), anchor="la", font=font)

                    #draw.text((textMeasurePosX, textMeasurePosY), textMeasure, fill=(int(colorMeasure[0]), int(colorMeasure[1]), int(colorMeasure[2])), anchor="mm", font=font)


                # convert PIL image into IPSDK Image
                outImage = fct.pilImageToIPSDKImage(pilRgbImg)

                outputDict = {}
                outputDict["Name"] = ""
                outputDict["Type"] = "Image"

                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'CopyImageOnScreen'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')

                label, realOutputName = self.addResult(outImage, outputDict, functionXmlElement)

                xmlElement = label.xmlElement
                Dfct.SubElement(xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')

            except:
                try:
                    nbMaxThread = PyIPSDK.getDefaultNbMaxThreads()
                    PyIPSDK.setNbMaxThreads(nbMaxThread)
                except:
                    pass
                traceback.print_exc(file=sys.stderr)

        else:
            try:
                screenshot = self.viewerNapariQt.screenshot()

                pilImg = Image.fromarray(screenshot)
                pilRgbImg = Image.new("RGBA", pilImg.size)
                pilRgbImg.paste(pilImg)

                # convert PIL image into IPSDK Image
                outImage = fct.pilImageToIPSDKImage(pilRgbImg)

                outputDict = {}
                outputDict["Name"] = ""
                outputDict["Type"] = "Image"

                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'CopyImageOnScreen'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')

                label, realOutputName = self.addResult(outImage, outputDict, functionXmlElement)
            except:
                traceback.print_exc(file=sys.stderr)

        vrb.mainWindow.toggleGroupBoxProcessing(False)
        vrb.mainWindow.groupBoxProcessing.setText('')

    # context menu that appears when right clicking on the viewer
    def rightMenu(self, pos):

        menu = qt.QMenu()

        # Add menu options
        copyOption = menu.addAction('Copy to clipboard')

        # Menu option events
        copyOption.triggered.connect(vrb.mainWindow.copyToClipBoard)

        if self.groupMenu.currentModeViewer == "2D":
            menu.exec_(self.imageViewer.mapToGlobal(pos))
        else:
            menu.exec_(self.viewerNapariQt.mapToGlobal(pos))

    # Copy the current image to clipboard
    def copyToClipBoard(self):

        self.toggleGroupBoxProcessing(True)
        self.groupBoxProcessing.setText('Copy to clipboard\n')
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)
        qt.QApplication.processEvents()

        if self.widgetImage.modeViewer == '2D':
            pixmap = QtGui.QImage(self.imageViewer.scene.width(), self.imageViewer.scene.height(), QtGui.QImage.Format_ARGB32_Premultiplied)
            painter = QtGui.QPainter()
            painter.begin(pixmap)
            # painter.setRenderHint(QtGui.QPainter.Antialiasing, True)
            self.imageViewer.scene.render(painter)
            painter.end()

            if self.parent != None:
                try:
                    vrb.mainWindow.parent.clipboard.setImage(pixmap)
                except:
                    traceback.print_exc(file=sys.stderr)
        else:
            try:
                screenshot = self.viewerNapariQt.screenshot()
                screenshotNp = screenshot[:,:,0:3]
                imageIP = fct.numpyImageToIPSDKImage(screenshotNp,invertChannels=False)
                qImg = fct.IPSDKImageToQImg(imageIP)
                vrb.mainWindow.parent.clipboard.setImage(qImg)
            except:
                traceback.print_exc(file=sys.stderr)

        self.toggleGroupBoxProcessing(False)
        self.groupBoxProcessing.setText('')


    def importMacroInterface(self):

        try:
            try:
                file = xmlet.parse(vrb.folderInformation + "/folderMacroInterface.mho")
                self.folderMacroInterfaceElement = file.getroot()
            except:
                self.folderMacroInterfaceElement = xmlet.Element('folderMacroInterface')

            path = Dfct.childText(self.folderMacroInterfaceElement, "Path")
            if path is not None:
                # defaultFolder = os.path.dirname(path)
                defaultFolder = path
            else:
                defaultFolder = "C:/"

            macroName = qt.QFileDialog.getOpenFileName(self, "Select your macro file", defaultFolder, "Macro" + " (*.zip)")

            macroName = macroName[0]

            if macroName != [] and macroName != '' and macroName != None:

                basename = os.path.basename(macroName)
                basename = basename.split('.')[0]

                folderMacro = vrb.folderMacroInterface+"/"+basename

                if os.path.exists(folderMacro):
                    messageBox = MessageBox('The macro interface ' + basename + ' already exists, do you want to replace it',"",
                                            buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No],
                                            icon=qt.QMessageBox.Warning)
                    res = messageBox.exec()
                    if res == qt.QMessageBox.No:
                        return
                    else:
                        shutil.rmtree(folderMacro, ignore_errors=True)

                with zipfile.ZipFile(macroName, 'r') as zip_ref:
                    listOfFilenames = zip_ref.namelist()
                    if os.path.splitext(listOfFilenames[0])[1] == "":
                        for filename in listOfFilenames:
                            zip_ref.extract(filename, vrb.folderMacroInterface)
                    else:
                        if not os.path.exists(folderMacro):
                            os.makedirs(folderMacro)
                            for filename in listOfFilenames:
                                zip_ref.extract(filename, folderMacro)

                dirname = os.path.dirname(macroName)

                Dfct.SubElement(self.folderMacroInterfaceElement, "Path").text = dirname
                Dfct.saveXmlElement(self.folderMacroInterfaceElement, vrb.folderInformation + "/folderMacroInterface.mho")

                messageBox = wgt.MessageBox('Macro "'+basename+'" successfully imported.\nPlease restart Explorer to update the interface', '', buttons=[qt.QMessageBox.Ok], windowTitle="Macro import")
                messageBox.exec()
        except:
            traceback.print_exc(file=sys.stderr)

    def exportMacroInterface(self):

        try:
            try:
                file = xmlet.parse(vrb.folderInformation + "/folderMacroInterfaceExport.mho")
                self.folderMacroInterfaceExportElement = file.getroot()
            except:
                self.folderMacroInterfaceExportElement = xmlet.Element('folderMacroInterfaceExport')

            path = Dfct.childText(self.folderMacroInterfaceExportElement, "Path")
            if path is not None:
                defaultFolder = path
            else:
                defaultFolder = "C:/"

            filenameMacro = qt.QFileDialog.getExistingDirectory(self, "Select your macro interface folder", vrb.folderMacroInterface)
            filenameExport = qt.QFileDialog.getExistingDirectory(self, "Select the folder to export your macro", defaultFolder)

            if filenameExport != '' and filenameExport != None:
                Dfct.SubElement(self.folderMacroInterfaceExportElement, "Path").text = filenameExport
                Dfct.saveXmlElement(self.folderMacroInterfaceExportElement, vrb.folderInformation + "/folderMacroInterfaceExport.mho")

                basename = os.path.basename(filenameMacro)
                zf = zipfile.ZipFile(filenameExport + "/" + basename + ".zip", "w")

                for dirname, subdirs, files in os.walk(filenameMacro):
                    if os.path.basename(dirname) != "__pycache__":
                        parentDir = os.path.basename(dirname)
                        zf.write(dirname,os.path.basename(dirname))
                        for filename in files:
                            zf.write(os.path.join(dirname, filename),os.path.join(parentDir,filename))
                zf.close()

        except:
            traceback.print_exc(file=sys.stderr)

    def deleteMacroInterface(self):

        try:
            filenameMacro = qt.QFileDialog.getExistingDirectory(self, "Select the macro you want to remove", vrb.folderMacroInterface)
            if filenameMacro != '' and filenameMacro != None:
                shutil.rmtree(filenameMacro)

                messageBox = wgt.MessageBox('Macro "'+os.path.basename(filenameMacro)+'" successfully removed.\nPlease restart Explorer to update the interface', '', buttons=[qt.QMessageBox.Ok], windowTitle="Macro import")
                messageBox.exec()
        except:
            traceback.print_exc(file=sys.stderr)

    # def reinitializeMacroInterface(self):
    #
    #     messageBox = wgt.MessageBox('All the macro interface will be removed.\nDo you want to continue?', '', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No], icon=qt.QMessageBox.Warning)
    #     res = messageBox.exec()
    #     if res == qt.QMessageBox.Yes:
    #         shutil.rmtree(vrb.folderMacroInterface)
    #
    #         messageBox = wgt.MessageBox('Macro successfully reinitialized.\nPlease restart Explorer to update the interface', '', buttons=[qt.QMessageBox.Ok], windowTitle="Macro import")
    #         messageBox.exec()

    def loadMacroUser(self):

        for filenameFolder in os.listdir(vrb.folderMacroInterface):
            pathFolder = os.path.join(vrb.folderMacroInterface, filenameFolder)
            try:
                for filename in os.listdir(pathFolder):
                    if filename.endswith(".py"):

                        nameFile = pathFolder.replace("\\","/")+"/"+filename

                        textImport = "try:\n"
                        textImport += "\tspec = importlib.util.spec_from_file_location('','"+nameFile+"')\n"
                        textImport += "\tfoo = importlib.util.module_from_spec(spec)\n"
                        textImport += "\tspec.loader.exec_module(foo)\n"
                        textImport += "except:\n"
                        textImport += "\tprint('error with the macro : "+filename+"')\n"
                        textImport += "\ttraceback.print_exc(file=sys.stderr)"

                        exec(textImport)
            except:
                pass

    def exportModel(self,folderName):

        try:
            try:
                file = xmlet.parse(vrb.folderInformation + "/folderModelMachineLearning.mho")
                self.folderModelMachineLearningElement = file.getroot()
            except:
                self.folderModelMachineLearningElement = xmlet.Element('folderModelMachineLearning')

            path = Dfct.childText(self.folderModelMachineLearningElement, "Path")
            if path is not None:
                defaultFolder = path
            else:
                defaultFolder = "C:/"

            filename = qt.QFileDialog.getExistingDirectory(self, "Select the folder corresponding to your model", folderName)
            basename = os.path.basename(filename)
            filenameExport = qt.QFileDialog.getExistingDirectory(self, "Select the folder to export your model", defaultFolder)

            if filename != "" and filename != None and filenameExport != "" and filenameExport != None:
                shutil.make_archive(filenameExport + "/" + basename, 'zip', filename)

            if filenameExport != '' and filenameExport != None:
                Dfct.SubElement(self.folderModelMachineLearningElement, "Path").text = filenameExport
                Dfct.saveXmlElement(self.folderModelMachineLearningElement, vrb.folderInformation + "/folderModelMachineLearning.mho")
        except:
            pass

    def exportModelSegmentation(self):

        self.exportModel(vrb.folderPixelClassification)

    def exportModelClassification(self):

        self.exportModel(vrb.folderShapeClassification)

    def exportModelSuperPixelSegmentation(self):

        self.exportModel(vrb.folderSuperPixelSegmentation)

    def importModel(self,modelName):

        try:
            try:
                file = xmlet.parse(vrb.folderInformation + "/folderModelMachineLearning.mho")
                self.folderModelMachineLearningElement = file.getroot()
            except:
                self.folderModelMachineLearningElement = xmlet.Element('folderModelMachineLearning')

            path = Dfct.childText(self.folderModelMachineLearningElement, "Path")
            if path is not None:
                # defaultFolder = os.path.dirname(path)
                defaultFolder = path
            else:
                defaultFolder = "C:/"

            filename = qt.QFileDialog.getOpenFileName(self, "Select your model file", defaultFolder, "Model" + " (*.zip)")
            basename = os.path.basename(filename[0])
            basename = basename.split(".")[0]

            with zipfile.ZipFile(filename[0], 'r') as zip_ref:
                zip_ref.extractall(modelName + "/" + basename)

            if filename[0] != [] and filename[0] != '' and filename[0] != None:
                Dfct.SubElement(self.folderModelMachineLearningElement, "Path").text = filename[0]
                Dfct.saveXmlElement(self.folderModelMachineLearningElement, vrb.folderInformation + "/folderModelMachineLearning.mho")
        except:
            pass

        try:
            # self.actualizeFunctionMachineLearning()
            self.updateCurrentFunction()
        except:
            pass

    def importModelSegmentation(self):

        self.importModel(vrb.folderPixelClassification)

    def importModelClassification(self):

        self.importModel(vrb.folderShapeClassification)

    def importModelSuperPixelSegmentation(self):

        self.importModel(vrb.folderSuperPixelSegmentation)

    def loadRightPanel(self):

        if vrb.rightPanelElement.text == "False":
            self.hideRightPanel(None)
        else:
            self.showRightPanel(None)

    def hideRightPanel(self,event):

        self.groupBoxRight.setVisible(False)
        self.groupBoxRightHide.setVisible(True)
        self.rightPanelShown = False
        self.resizeEvent(None)

        vrb.rightPanelElement.text = "False"
        Dfct.saveXmlElement(vrb.rightPanelElement, vrb.folderInformation + "/RightPanel.mho")

    def showRightPanel(self,event):

        self.groupBoxRight.setVisible(True)
        self.groupBoxRightHide.setVisible(False)
        self.rightPanelShown = True
        self.resizeEvent(None)

        vrb.rightPanelElement.text = "True"
        Dfct.saveXmlElement(vrb.rightPanelElement, vrb.folderInformation + "/RightPanel.mho")


    def launchMachineLearning(self):

        if self.currentModuleMachineLearning is None:

            self.resetModuleRFSegmentation()
            self.resetModuleRFClassification()
            self.resetModuleRFSuperPixels()

            self.machineLearningSettingsWidget.loading()
            fct.showWidget(self.machineLearningSettingsWidget)

        else:
            fct.showWidget(self.currentModuleMachineLearning)


    def resetModuleRFSegmentation(self):

        self.moduleRF_Segmentation = moduleRandomForest.ModuleRF_Segmentation.MainWidget()

    def resetModuleRFClassification(self):

        self.moduleRF_Classification = moduleRandomForest.ModuleRF_Classification.MainWidget()

    def resetModuleRFSuperPixels(self):

        self.moduleRF_SuperPixels = moduleRandomForest.ModuleRF_SuperPixels.MainWidget()

    def displayCamera(self):

        if vrb.nbCameras == 1:
            fct.showWidget(vrb.widgetCamera[0])
            vrb.widgetCamera[0].groupBoxSettings.updateValue()
            vrb.updateCamera = True
            fct.displayCamera()
        else:
            fct.showWidget(self.widgetCameraToDisplay)

    # def acquireImage(self):
    #
    #     for cameraNum in range(vrb.nbCameras):
    #         image = Camera.acquireImage(cameraNum)
    #         if image is None:
    #             image = Camera.acquireImage(cameraNum)
    #
    #         if image is not None:
    #             vrb.mainWindow.addImageFromCamera(image, "Capture_" + str(vrb.captureNum))
    #             vrb.captureNum += 1

    def acquireImage(self):

        for cameraNum in range(vrb.nbCameras):
            image = Cam.acquireImage(cameraNum)
            if image is not None:
                vrb.mainWindow.addImageFromCamera(image, "Capture_" + str(vrb.captureNum))
                vrb.captureNum += 1

    def addImageFromCamera(self,image,name = ""):

        self.toggleGroupBoxProcessing(True)
        self.groupBoxProcessing.setText('Exporting image\n')
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)

        functionXmlElement = xmlet.Element('FunctionCall')
        Dfct.SubElement(functionXmlElement, 'Name').text = 'ExportImage'

        label, name = self.widgetLabelImage.addNewImage(name, image, functionXmlElement=functionXmlElement)
        Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')
        self.changeCurrentXmlElement(label)

        self.updateCurrentFunction()
        self.toggleGroupBoxProcessing(False)

    def openLabelPreferences(self):

        self.widgetLabels.show()

    def openSievePreferences(self):

        fct.showWidget(self.sieveWidget)

    def importSieves(self):

        try:

            defaultFolder = "C:/"

            filename = qt.QFileDialog.getOpenFileName(self, "Select your file to import sieves", defaultFolder, "" + " (*.mho)")

            shutil.copyfile(filename[0], vrb.folderInformation + "/UserSieves.mho")

            file = xmlet.parse(vrb.folderInformation + "/UserSieves.mho")
            self.sieveWidget.xmlElement = file.getroot()

            self.sieveWidget.loadXmlElement()

            messageBox = wgt.MessageBox('Sieves successfully imported', '',buttons=[qt.QMessageBox.Ok], windowTitle="Sieve import")
            messageBox.exec()

        except:
            pass


    def addNewLut(self):

        self.widgetNewLut.scrollAreaSeeds.initSeeds()
        self.widgetNewLut.lineEditName.setText("")
        self.widgetNewLut.show()
        self.lutManager.close()

    def manageLut(self):

        self.lutManager.loadLuts()
        self.lutManager.show()

    def actualizeLuts(self):
    
        for num in range(self.widgetLabelImage.layout.count()):
            try:
                item = self.widgetLabelImage.layout.itemAt(num)
                if item is not None:
                    label = item.widget()
                    label.groupBoxLut.addCustomLuts()
            except:
                traceback.print_exc(file=sys.stderr)

        try:
            self.viewer3dSettingsWidget.orthoslicesSettings.addCustomLuts()
        except:
            traceback.print_exc(file=sys.stderr)



    def actualizeFunctionMachineLearning(self):

        pass

        # try:
        #     for i in range(1, self.categorySpoilersContainer.layout.count() + 1):
        #         # item = centralWidget.categorySpoilersContainer.layout.itemAtPosition(i,0)
        #         item = self.categorySpoilersContainer.layout.itemAt(i)
        #         if item is not None:
        #             spoilerCategory = item.widget()
        #             for j in range(spoilerCategory.widget.layout.count() + 1):
        #                 itemChild = spoilerCategory.widget.layout.itemAt(j)
        #                 if itemChild is not None:
        #                     spoiler = itemChild.widget()
        #                     if spoiler.title in ["Smart Segmentation","Smart Segmentation With Probabilities","Smart Classification","Super Pixel Segmentation"]:
        #                         widget = spoiler.widget
        #                         if spoiler.title in ["Smart Segmentation","Smart Segmentation With Probabilities"]:
        #                             numWidget = 1
        #                             folderMachineLearning = vrb.folderPixelClassification
        #                         elif spoiler.title == "Smart Classification":
        #                             numWidget = 2
        #                             folderMachineLearning = vrb.folderShapeClassification
        #                         elif spoiler.title == "Super Pixel Segmentation":
        #                             numWidget = 1
        #                             folderMachineLearning = vrb.folderSuperPixelSegmentation
        #                         comboBoxMachineLearning = widget.parameters[numWidget]["Widget"]
        #                         comboBoxMachineLearning.clear()
        #                         for modelName in sorted(os.listdir(folderMachineLearning),key=str.casefold):
        #                             folderModel = folderMachineLearning + "/" + modelName
        #                             if os.path.isdir(folderModel):
        #                                 try:
        #                                     file = xmlet.parse(folderModel + "/Settings.mho")
        #                                     xmlElement = file.getroot()
        #                                     model = joblib.load(folderModel + "/Model")
        #                                     # comboBoxMachineLearning.addItem(modelName,[xmlElement,model])
        #                                     comboBoxMachineLearning.addItem(modelName,modelName)
        #                                 except:
        #                                     pass
        # except:
        #     traceback.print_exc(file=sys.stderr)

    def actualizeFunctionFilter(self):

        try:
            for i in range(1, self.categorySpoilersContainer.layout.count() + 1):
                # item = centralWidget.categorySpoilersContainer.layout.itemAtPosition(i,0)
                item = self.categorySpoilersContainer.layout.itemAt(i)
                if item is not None:
                    spoilerCategory = item.widget()
                    for j in range( spoilerCategory.widget.layout.count() + 1):
                        itemChild = spoilerCategory.widget.layout.itemAt(j)
                        if itemChild is not None:
                            spoiler = itemChild.widget()
                            if spoiler.title in ["Shape filtering 2D","Shape filtering 3D"]:
                                widget = spoiler.widget
                                advancedWidget = widget.parameters[2]["Widget"]
                                groupBoxParam = advancedWidget.comboBoxEnum.itemData(0)

                                groupBoxParam["Parameters"][1]["Widget"].setStyleSheet("QTextEdit{background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #3d3d3d, stop: 0 #343434,"
                                                                  " stop: 1 #3d3d3d);padding: 1px;border-style: solid; border: 1px solid #1e1e1e;}")

                                comboBoxFilter = groupBoxParam["Parameters"][0]["Widget"]
                                comboBoxFilter.clear()
                                try:
                                    file = xmlet.parse(vrb.folderInformation + "/UserFilters.mho")
                                    filterElement = file.getroot()
                                    for child in filterElement:
                                        comboBoxFilter.addItem(Dfct.childText(child,"Name"),Dfct.childText(child,"Formula"))
                                except:
                                    pass

        except:
            pass

    def openBenchmark(self):

        self.benchmarkWidget.show()
        self.benchmarkWidget.verifImageJ()

    def importMacro(self):

        try:
            file = xmlet.parse(vrb.folderInformation + "/folderPythonScript.mho")
            self.folderPythonScriptElement = file.getroot()
        except:
            self.folderPythonScriptElement = xmlet.Element('folderPythonScript')

        path = Dfct.childText(self.folderPythonScriptElement, "Path")
        if path is not None:
            defaultFolder = os.path.dirname(path)
        else:
            defaultFolder = "C:/Program Files/"
        filenameExe = qt.QFileDialog.getOpenFileName(self, "Select your macro file", defaultFolder, "Script" + " (*.py *.pyw *.mho)")

        if filenameExe[0] != [] and filenameExe[0] != '' and filenameExe[0] != None:
            Dfct.SubElement(self.folderPythonScriptElement, "Path").text = filenameExe[0]
            Dfct.saveXmlElement(self.folderPythonScriptElement, vrb.folderInformation + "/folderPythonScript.mho")

            basename = os.path.splitext(filenameExe[0])[0]
            if os.path.exists(basename+".mho") and (os.path.exists(basename+".py") or os.path.exists(basename+".pyw")):
                fileElement = xmlet.parse(basename+".mho")
                xmlElement = fileElement.getroot()

                name = Dfct.childText(xmlElement, "PythonName")
                pythonNameSplit = name.split("/")
                moduleName = pythonNameSplit[0]
                nameMacro = Dfct.childText(xmlElement, "Name")
                # nameMacroNoSpace = nameMacro.replace(" ","")
                nameMacroNoSpace = nameMacro

                self.addModule(moduleName)

                copyfile(basename+".mho",vrb.folderFunctions+"/"+moduleName+"/"+nameMacroNoSpace+".mho")
                copyfile(basename+".py",vrb.folderFunctions+"/"+moduleName+"/"+nameMacroNoSpace+".py")

                self.reloadAllFunctionsSpoilers(moduleName)

                for i in range(self.categorySpoilersContainer.layout.count() + 1):
                    item = self.categorySpoilersContainer.layout.itemAt(i)
                    if item is not None:
                        spoilerCategory = item.widget()
                        if spoilerCategory.isVisible():
                            nameFunction = fct.invertDictName(dictFolderNames, spoilerCategory.title)
                            if nameFunction is None:
                                nameFunction = spoilerCategory.title
                            if nameFunction == moduleName:
                                spoilerCategory.emitSignalSetSpoilerExpand(None)
                                for j in range(spoilerCategory.widget.layout.count() + 1):
                                    itemChild = spoilerCategory.widget.layout.itemAt(j)
                                    if itemChild is not None:
                                        sploiler = itemChild.widget()
                                        if sploiler.title == nameMacro:
                                            sploiler.emitSignalSetSpoilerExpand(None)

    def exportMacro(self):

        try:
            try:
                file = xmlet.parse(vrb.folderInformation + "/folderMacroExport.mho")
                self.folderMacroExportElement = file.getroot()
            except:
                self.folderMacroExportElement = xmlet.Element('folderMacroExport')

            path = Dfct.childText(self.folderMacroExportElement, "Path")
            if path is not None:
                defaultFolder = path
            else:
                defaultFolder = "C:/"

            filename = qt.QFileDialog.getOpenFileNames(self, "Select your macro file", vrb.folderFunctions, "(*.py)")
            filenameExport = qt.QFileDialog.getExistingDirectory(self, "Select the folder to export your macro", defaultFolder)

            if filenameExport != '' and filenameExport != None:
                Dfct.SubElement(self.folderMacroExportElement, "Path").text = filenameExport
                Dfct.saveXmlElement(self.folderMacroExportElement, vrb.folderInformation + "/folderMacroExport.mho")

                basename = os.path.basename(filename[0][0])

                copyfile(filename[0][0], filenameExport + "/" + basename)
                copyfile(fct.changeExtension(filename[0][0],".mho"), fct.changeExtension(filenameExport + "/" + basename,".mho"))

        except:
            traceback.print_exc(file=sys.stderr)

    def createNewMacro(self):

        self.editScriptWindow = EditScriptWindow(xmlElement=None,allowImport=True)
        self.editScriptWindow.groupParameters.actualizeInterface()
        self.editScriptWindow.show()
        # self.editScriptWindow.window().setWindowModality(Qt.ApplicationModal)
        self.editScriptWindow.textHasChanged = False

    def showDeleteModule(self):

        self.widgetDeleteModule.display()

    def showAddModule(self):

        self.widgetAddModule.show()

    def addModule(self,moduleName):

        stop = False
        folderNewModule = vrb.folderFunctions + "/" + moduleName
        if not os.path.exists(folderNewModule):
            os.makedirs(folderNewModule)
            for i in range(self.categorySpoilersContainer.layout.count() + 1):
                item = self.categorySpoilersContainer.layout.itemAt(i)
                if item is not None and stop == False:
                    spoilerCategory = item.widget()
                    if spoilerCategory.isVisible():
                        nameFunction = fct.invertDictName(dictFolderNames,spoilerCategory.title)
                        if nameFunction is None:
                            nameFunction = spoilerCategory.title
                        if moduleName.lower()<nameFunction.lower():
                            spoiler = CategorySpoiler(folderNewModule)
                            self.categorySpoilersContainer.addSpoiler(spoiler,num = i)
                            spoiler.SignalWidgetChanged.connect(self.categorySpoilersContainer.emitSignalCurrentFunctionChanged)
                            self.categorySpoilersContainer.changeHeight()
                            stop = True

    def showViewer3DPreference(self):

        self.folder3DWidget.show()

    def showColorPreference(self):

        self.colorWidget.show()

    def showPostProcessPreference(self):

        self.postProcessWidget.show()

    def changeButtonColor(self):

        self.pushButtonShowColor.setStyleSheet('QPushButton {background-color: rgb(' + str(self.color[0]) + ',' + str(self.color[1]) + ',' + str(self.color[2]) + ');}')

    def showZStackFocusWidget(self):

        self.zStackFocusWidget.show()

    def showInterfacePreferences(self):

        self.interfacePreferencesWidget.show()

    def showDiskImagesPreferences(self):

        self.diskImagesPreferencesWidget.show()

    def displayThumbails(self):

        if self.widgetLabelImage.miniatureVisible != self.parent.menuBar.actionDisplayThumbails.isChecked():
            self.widgetLabelImage.miniatureVisible = self.parent.menuBar.actionDisplayThumbails.isChecked()
            for num in range(self.widgetLabelImage.layout.count()):
                item = self.widgetLabelImage.layout.itemAt(num)
                if item is not None:
                    if item.widget().objectType == "Image":
                        item.widget().setVisibleMiniature(self.widgetLabelImage.miniatureVisible)
            self.widgetLabelImage.resizeEvent(None)

    def displayThumbailsAndRefresh(self):

        self.widgetLabelImage.miniatureVisible = self.parent.menuBar.actionDisplayThumbails.isChecked()
        for num in range(self.widgetLabelImage.layout.count()):
            item = self.widgetLabelImage.layout.itemAt(num)
            if item is not None:
                if item.widget().objectType == "Image":
                    item.widget().setVisibleMiniature(self.widgetLabelImage.miniatureVisible)
        self.widgetLabelImage.resizeEvent(None)

    def verifTabWidgetLeft(self,index):

        if index == 1:
            for spoilerName in self.widgetLabelValue.centralWidget.spoilers:
                spoiler = self.widgetLabelValue.centralWidget.spoilers[spoilerName]
                if spoiler.isExpanded:
                    spoiler.expand(forceEvent='Open')

        self.changeModeViewer()

    def changeModeViewer(self):

        if self.initDone:
            try:
                if self.widgetImage.modeViewer == "2D" or self.tabWidgetLeft.currentIndex()==1:
                    self.viewer3dSettingsScrollArea.setVisible(False)
                    self.parent.menuBar.actionDisplayThumbails.setChecked(True)
                    self.displayThumbails()
                    self.groupMenu.buttonMovieMaker.setEnabled(False)
                    self.groupMenu.buttonMovieMaker.setActivation(False)
                else:
                    self.viewer3dSettingsScrollArea.setVisible(True)
                    self.parent.menuBar.actionDisplayThumbails.setChecked(False)
                    self.displayThumbails()
                    self.groupMenu.buttonMovieMaker.setEnabled(True)
                self.displayButtonEye()
            except:
                traceback.print_exc(file=sys.stderr)

            self.resizeEvent(None)

    def displayButtonEye(self):

        for num in range(self.widgetLabelImage.layout.count()):
            item = self.widgetLabelImage.layout.itemAt(num)
            if item is not None:
                label = item.widget()
                if self.widgetImage.modeViewer == "2D":
                    label.buttonEye.setVisible(False)
                    if label.objectType != "Mesh":
                        label.buttonOrthoslices.setVisible(False)
                else:
                    if label.objectType == "Image" and label.image.isDiskImage():
                        label.buttonEye.setVisible(False)
                        if label.objectType != "Mesh":
                            label.buttonOrthoslices.setVisible(False)
                    else:
                        label.buttonEye.setVisible(True)
                        if label.objectType != "Mesh":
                            label.buttonOrthoslices.setVisible(True)

                        if self.widgetImage.modeViewer == "4Views":
                            if label.objectType != "Mesh" and not label.hasNapari:
                                label.setButtonEyeActivation(False)
                                label.setButtonOrthosliceActivation(label == self.currentLabel)
                        if self.widgetImage.modeViewer == "3D" and not label.hasNapari:
                            label.setButtonEyeActivation(label == self.currentLabel)

        # self.viewer3dSettingsWidget.loadSettings()

    # def displayButtonEye(self):
    #
    #     for num in range(self.widgetLabelImage.layout.count()):
    #         item = self.widgetLabelImage.layout.itemAt(num)
    #         if item is not None:
    #             label = item.widget()
    #             if self.widgetImage.modeViewer == "2D":
    #                 label.buttonEye.setVisible(False)
    #             else:
    #                 if label.objectType == "Image" and label.image.isDiskImage():
    #                     label.buttonEye.setVisible(False)
    #                 else:
    #                     label.buttonEye.setVisible(True)
    #                     label.buttonEye.setActivation(not label == self.currentLabel)
    #
    #                     if label.buttonEye.activate == False:
    #                         if not label.hasNapari:
    #                             label.addToNapari()
    #                             if label == self.currentLabel:
    #                                 self.viewer3dSettingsWidget.loadSettings()
    #                         if label.layer.visible is not True:
    #                             label.layer.visible = True
    #                         # self.viewer3dSettingsWidget.updateVisualization()
    #                     else:
    #                         if label.hasNapari:
    #                             if label.layer.visible is not False:
    #                                 label.layer.visible = False
    #                         # self.viewer3dSettingsWidget.updateVisualization()

    def resetView(self):

        # used to reset the camera to the center of the current volume in napari
        try:
            if self.currentLabel.objectType == "Image":
                if self.currentLabel.image.hasGeometricCalibration():
                    calibration = self.currentLabel.image.getGeometricCalibration()
                    calibX = calibration.getXScale()
                    calibY = calibration.getYScale()
                    calibZ = calibration.getZScale()
                    originX = calibration.getXOriginUncalibrated()
                    originY = calibration.getYOriginUncalibrated()
                    originZ = calibration.getZOriginUncalibrated()
                else:
                    calibX = 1
                    calibY = 1
                    calibZ = 1
                    originX = 0
                    originY = 0
                    originZ = 0

                sizeX = self.currentLabel.image.getSizeX()
                sizeY = self.currentLabel.image.getSizeY()
                sizeZ = self.currentLabel.image.getSizeZ()

            elif self.currentLabel.objectType == "Mesh":
                sizeX = self.currentLabel.endValues[0] - self.currentLabel.startValues[0]
                sizeY = self.currentLabel.endValues[1] - self.currentLabel.startValues[1]
                sizeZ = self.currentLabel.endValues[2] - self.currentLabel.startValues[2]

                try:
                    calibX = self.currentLabel.mesh.calibration.getXScale()
                    calibY = self.currentLabel.mesh.calibration.getYScale()
                    calibZ = self.currentLabel.mesh.calibration.getZScale()
                    originX = self.currentLabel.mesh.calibration.getXOriginUncalibrated()
                    originY = self.currentLabel.mesh.calibration.getYOriginUncalibrated()
                    originZ = self.currentLabel.mesh.calibration.getZOriginUncalibrated()
                except:
                    calibX = 1
                    calibY = 1
                    calibZ = 1
                    originX = 0
                    originY = 0
                    originZ = 0


            if len(self.currentLabel.layer.scale) != 3:
                scaleX = self.currentLabel.layer.scale[3]
                scaleY = self.currentLabel.layer.scale[2]
                scaleZ = self.currentLabel.layer.scale[1]
            else:
                scaleX = self.currentLabel.layer.scale[2]
                scaleY = self.currentLabel.layer.scale[1]
                scaleZ = self.currentLabel.layer.scale[0]


            if self.currentLabel.layer is not None:
                # get current label bounding box in world coordinates
                extent = np.array(self.currentLabel.layer.extent.world)
            else:
                # get bounding box of all layers
                extent = self.viewerNapari._sliced_extent_world_augmented

            # defines the borders margin
            margin = 0.05  # we leave 5% of empty space around the volume
            scale_factor = 1 - margin  # the scene will occupy 95% of the screen


            if self.viewer3dSettingsWidget.viewerSettings.radioButtonCameraNormal.isChecked():

                # Resets the camera model and recompute the view
                self.viewerNapari.camera.reset()
                self.viewerNapari.reset_view()

                # resets the camera center depending on the center of the full volume/mesh
                if self.currentLabel.objectType == "Image":
                    self.viewerNapari.camera.center = (
                        (originZ+(self.currentLabel.image.getSizeZ()/2)) * scaleZ,
                        (originY+(self.currentLabel.image.getSizeY()/2)) * scaleY,
                        (originX+(self.currentLabel.image.getSizeX()/2)) * scaleX)
                elif self.currentLabel.objectType == "Mesh":
                    self.viewerNapari.camera.center = (
                        (originZ + self.currentLabel.meshCenter[0]) * scaleZ,
                        (originY + self.currentLabel.meshCenter[1]) * scaleY,
                        (originX + self.currentLabel.meshCenter[2]) * scaleX)


                # Compute scene size
                scene_size = extent[1] - extent[0]
                # Adapt grid_size if necessary
                grid_size = [1] * len(scene_size)  # Only one layer, so grid size is 1
                size = np.multiply(scene_size, grid_size)

                if np.max(size) == 0: # if the scene is empty
                    # apply a default zoom
                    self.viewerNapari.camera.zoom = scale_factor * np.min(self.viewerNapari._canvas_size)
                else:
                    scale = np.array(size[-2:])
                    scale[np.isclose(scale, 0)] = 1  # null sizes fix

                    # applies a zoom by dividing the canvas sizes by the scene dimensions and keeping the min value
                    self.viewerNapari.camera.zoom = (scale_factor * np.min(
                        np.array(self.viewerNapari._canvas_size) / scale)
                    )

            else:
                # No resets of the camera model to avoid losing informations
                self.viewerNapari.reset_view()
                self.viewer3dSettingsWidget.changeCameraMode()


        except:
            traceback.print_exc(file=sys.stderr)

        self.resetImageViewer()

    def resetImageViewer(self):

        try:
            import gc
            gc.collect()
        except:
            pass

        self.imageViewer.zoomFactor = 1
        self.imageViewer.currentZoom = 1
        self.imageViewer.realStartPointX = 0
        self.imageViewer.realStartPointY = 0

        self.imageViewer.getRoiImage()

    def showAbout(self):

        self.aboutWidget.show()

    def showDocMainPage(self):

        webbrowser.open_new_tab(vrb.folderDocEssential + "/index.html")

    def actualizeTime(self):

        if self.timeRef is not None:
            timeProcess = time.time() - self.timeRef
            self.groupBoxProcessing.setText('Processing...\nPlease wait.\nTime : '+str(int(10*timeProcess)/10) + "s\n")
            qt.QApplication.processEvents()

    def importImages(self):

        defaultFolder = Dfct.childText(vrb.userPathElement, "ImportImages")
        if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
            defaultFolder = os.path.dirname(vrb.folderExplorer) + "/images"
            if not os.path.exists(defaultFolder):
                defaultFolder = os.path.dirname(vrb.folderExplorer)+"/data/Explorer/images"

        # create filter for QFileDialog for each extensions
        filters = []
        for group in vrb.extensionImagesOpen: # create filter name for each extension
            ext_label = group[0].upper()  # get name (ex: "TIFF")
            patterns = " ".join([f"*.{ext}" for ext in group])
            filters.append(f"{ext_label} files ({patterns})")
        # Add a global filter with all extensions
        filters.insert(len(vrb.extensionImagesOpen), f"All Image Files (*.*)")
        filter_str = ";;".join(filters)

        filename = qt.QFileDialog.getOpenFileNames(self, "Select your images", defaultFolder, filter_str)
        if filename[0] != [] and filename[0] != '' and filename[0] != None:
            self.addLabelsFromUrls(filename[0])
            Dfct.SubElement(vrb.userPathElement, "ImportImages").text = os.path.dirname(filename[0][0])
            Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")

    def importImagesDisk(self):

        defaultFolder = Dfct.childText(vrb.userPathElement, "ImportImages")
        if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
            defaultFolder = os.path.dirname(vrb.folderExplorer) + "/images"
            if not os.path.exists(defaultFolder):
                defaultFolder = os.path.dirname(vrb.folderExplorer)+"/data/Explorer/images"

        # strExt = "(" + " ".join(["*." + curExtension for curExtension in vrb.extensionImages]) + ")"

        filename = qt.QFileDialog.getOpenFileNames(self, "Select your images", defaultFolder, "(*.tiff *.tif *.TIF *.TIFF *.Tif *.Tiff)")
        if filename[0] != [] and filename[0] != '' and filename[0] != None:
            self.addLabelsFromUrls(filename[0], disk = True)
            Dfct.SubElement(vrb.userPathElement, "ImportImages").text = os.path.dirname(filename[0][0])
            Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")

    def importMultiImages(self):

        defaultFolder = Dfct.childText(vrb.userPathElement, "ImportImages")
        if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
            defaultFolder = os.path.dirname(vrb.folderExplorer) + "/images"
            if not os.path.exists(defaultFolder):
                defaultFolder = os.path.dirname(vrb.folderExplorer)+"/data/Explorer/images"

        filename = qt.QFileDialog.getExistingDirectory(self, "Select the folder containing your images", defaultFolder)
        if filename != "" and filename != None:
            self.addLabelsFromUrls(filename, multi=True)
            Dfct.SubElement(vrb.userPathElement, "ImportImages").text = os.path.dirname(filename)
            Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")

    def importMultiImagesDisk(self):

        defaultFolder = Dfct.childText(vrb.userPathElement, "ImportImages")
        if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
            defaultFolder = os.path.dirname(vrb.folderExplorer) + "/images"
            if not os.path.exists(defaultFolder):
                defaultFolder = os.path.dirname(vrb.folderExplorer)+"/data/Explorer/images"

        filename = qt.QFileDialog.getExistingDirectory(self, "Select the folder containing your images", defaultFolder)
        if filename != "" and filename != None:
            self.addLabelsFromUrls(filename, multi=True,disk=True)
            Dfct.SubElement(vrb.userPathElement, "ImportImages").text = os.path.dirname(filename)
            Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")

    def importMultiImagesAsSequence(self):

        defaultFolder = Dfct.childText(vrb.userPathElement, "ImportImages")
        if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
            defaultFolder = os.path.dirname(vrb.folderExplorer) + "/images"
            if not os.path.exists(defaultFolder):
                defaultFolder = os.path.dirname(vrb.folderExplorer)+"/data/Explorer/images"

        filename = qt.QFileDialog.getExistingDirectory(self, "Select the folder containing your images", defaultFolder)
        if filename != "" and filename != None:
            self.addLabelsFromUrls(filename, multi=True, sequence = True)
            Dfct.SubElement(vrb.userPathElement, "ImportImages").text = os.path.dirname(filename)
            Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")

    def importStl(self):

        defaultFolder = Dfct.childText(vrb.userPathElement, "ImportStl")
        if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
            defaultFolder = os.path.dirname(vrb.folderExplorer) + "/images"
            if not os.path.exists(defaultFolder):
                defaultFolder = os.path.dirname(vrb.folderExplorer)+"/data/Explorer/images"

        filename = qt.QFileDialog.getOpenFileNames(self, "Select your images", defaultFolder, "Images" + " (*.stl *.STL *.Stl)")
        if filename[0] != [] and filename[0] != '' and filename[0] != None:
            self.addLabelsFromUrls(filename[0])
            Dfct.SubElement(vrb.userPathElement, "ImportStl").text = os.path.dirname(filename[0][0])
            Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")

    def saveImages(self):

        try:
            if self.widgetImage.image != None:
                defaultFolder = Dfct.childText(vrb.userPathElement, "ImportImages")
                if defaultFolder is None or defaultFolder == "" or os.path.exists(defaultFolder) == False:
                    defaultFolder = os.path.dirname(vrb.folderExplorer) + "/images"
                    if not os.path.exists(defaultFolder):
                        defaultFolder = os.path.dirname(vrb.folderExplorer) + "/data/Explorer/images"

                filename = qt.QFileDialog.getSaveFileName(self, "Save image as", defaultFolder + "/", "TIF Image (*.tif *.tiff);;RAW Image(*.raw)")
                if filename[0] != None and filename[0] != '':
                    self.groupBoxProcessing.setText('Saving...\nPlease wait.')
                    self.groupBoxProcessing.buttonStop.setVisible(False)
                    self.groupBoxProcessing.progressBar.setVisible(False)
                    self.toggleGroupBoxProcessing(True)

                    if platform.system() == 'Linux' and "." not in filename[0]: #fix of the save of images in Linux
                        if "raw" in filename[1]:
                            extension = "raw"
                        else:
                            extension = "tif"

                        filenameSaved = filename[0]+"."+extension
                    else:
                        nameSplit = filename[0].split(".")
                        extension = nameSplit[len(nameSplit) - 1]

                        filenameSaved = filename[0]

                    if extension in ["tif","TIF","Tif","tiff","TIFF","Tiff"]:
                        PyIPSDK.saveTiffImageFile(filenameSaved, self.widgetImage.image)
                    elif extension in ["raw","RAW","Raw"]:
                        PyIPSDK.saveRawImageFile(filenameSaved, self.widgetImage.image)

                    self.toggleGroupBoxProcessing(False)
                    # Dfct.SubElement(vrb.userPathElement, "ImportImages").text = os.path.dirname(filename[0])
                    Dfct.SubElement(vrb.userPathElement, "ImportImages").text = os.path.dirname(filenameSaved)
                    Dfct.saveXmlElement(vrb.userPathElement, vrb.folderInformation + "/UserPath.mho")
        except Exception as e:
            self.toggleGroupBoxProcessing(False)
            messageBox = MessageBox(str(e), '', buttons=[qt.QMessageBox.Ok], icon=qt.QMessageBox.Warning, windowTitle="Error while saving image")
            messageBox.exec()
            traceback.print_exc(file=sys.stderr)

    def saveImageMultislices(self):

        try:
            if self.currentLabel.image.getSizeZ()>1:
                self.currentLabel.saveImageMultislices()
        except:
            pass

    def postProcess(self):

        try:

            self.groupBoxProcessing.setText('Post processing...\nPlease wait.')
            self.groupBoxProcessing.buttonStop.setVisible(False)
            self.groupBoxProcessing.progressBar.setVisible(False)
            self.toggleGroupBoxProcessing(True)

            self.graphicElements.currentAddLabel = None
            self.graphicElements.currentSplitLabel = None

            if self.widgetImage.imageOverlayLabel is not None and self.widgetImage.imageOverlayLabel.image is not None:
                image = self.widgetImage.imageOverlayLabel.image
                currentLabel = self.widgetImage.imageOverlayLabel
            else:
                image = self.currentLabel.image
                currentLabel = self.currentLabel

            outImage = util.copyImg(image)

            if vrb.numberPreviousImages > 0:
                if len(vrb.previousImages) == vrb.numberPreviousImages:
                    vrb.previousImages.remove(vrb.previousImages[0])
                vrb.previousImages.append(outImage)
            self.groupMenu.groupPostProcess.buttonBack.setEnabled(len(vrb.previousImages) >= 1)

            graphicXmlElement = Dfct.SubElement(self.currentLabel.xmlElement, "GraphicXmlElement")

            if image is not None and image.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:

                outImage = itrans.compactIndexImg(outImage)

                ### Keep labels

                labelToKeep = []
                allKeepLabelsElement = Dfct.SubElement(graphicXmlElement, "AllKeepLabels")
                for child in allKeepLabelsElement:
                    if child.tag == "Label":
                        allPointsElement = Dfct.SubElement(child, "AllPoints")
                        pointElement = Dfct.SubElement(allPointsElement, "Point")
                        pointX = Dfct.childText(pointElement, "PointX")
                        pointY = Dfct.childText(pointElement, "PointY")
                        if outImage.getSizeZ() == 1:
                            valueLabel = outImage.array[int(float(pointY))][int(float(pointX))]
                        else:
                            if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                                valueLabel = outImage.array[int(float(pointY)), int(float(pointX)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()]
                            if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                                valueLabel = outImage.array[int(float(pointY)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(), int(float(pointX))]
                            if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                                valueLabel = outImage.array[self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), int(float(pointY)), int(float(pointX))]
                        if valueLabel != 0:
                            labelToKeep.append(valueLabel)

                if len(labelToKeep) != 0:
                    maskLabels = None
                    for label in labelToKeep:
                        label = int(label)
                        if label != 0:
                            if maskLabels == None:
                                maskLabels = bin.thresholdImg(outImage, label, label)
                            else:
                                maskToAdd = bin.thresholdImg(outImage, label, label)
                                maskLabels = arithm.addImgImg(maskLabels, maskToAdd)

                    if maskLabels is not None:
                        maskLabels = util.convertImg(maskLabels,PyIPSDK.eIBT_Binary)
                        outImage = logic.maskImg(outImage,maskLabels)

                    allMergeLabelsElement = Dfct.SubElement(graphicXmlElement, "AllMergeLabels")
                    Dfct.clearElement(allMergeLabelsElement)
                    allAddLabelsElement = Dfct.SubElement(graphicXmlElement, "AllAddLabels")
                    Dfct.clearElement(allAddLabelsElement)
                    allSplitLabelsElement = Dfct.SubElement(graphicXmlElement, "AllSplitLabels")
                    Dfct.clearElement(allSplitLabelsElement)
                    allDeleteLabelsElement = Dfct.SubElement(graphicXmlElement, "AllDeleteLabels")
                    Dfct.clearElement(allDeleteLabelsElement)
                    Dfct.clearElement(allKeepLabelsElement)

                else:
                    ### Merge labels

                    labelToMerge = []
                    allMergeLabelsElement = Dfct.SubElement(graphicXmlElement, "AllMergeLabels")
                    for child in allMergeLabelsElement:
                        if child.tag == "Label":
                            allPointsElement = Dfct.SubElement(child, "AllPoints")
                            pointElement = Dfct.SubElement(allPointsElement, "Point")
                            pointX = Dfct.childText(pointElement, "PointX")
                            pointY = Dfct.childText(pointElement, "PointY")
                            if outImage.getSizeZ() == 1:
                                labelToMerge.append(outImage.array[int(float(pointY))][int(float(pointX))])
                            else:
                                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                                    labelToMerge.append(outImage.array[int(float(pointY)), int(float(pointX)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
                                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                                    labelToMerge.append(outImage.array[int(float(pointY)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(), int(float(pointX))])
                                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                                    labelToMerge.append(outImage.array[self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), int(float(pointY)), int(float(pointX))])

                    maskLabels = None
                    for label in labelToMerge:
                        label = int(label)
                        if label != 0:
                            if maskLabels == None:
                                maskLabels = bin.thresholdImg(outImage, label, label)
                            else:
                                maskToAdd = bin.thresholdImg(outImage, label, label)
                                maskLabels = arithm.addImgImg(maskLabels, maskToAdd)

                    if maskLabels != None:
                        invertMask = bin.thresholdImg(maskLabels, 0, 0)
                        outImage = arithm.multiplyImgImg(outImage, invertMask)

                        if outImage.getSizeZ() == 1:
                            inSE = PyIPSDK.circularSEXYInfo(2)
                            maskLabels = morpho.closing2dImg(maskLabels, inSE)
                            maskLabels = util.convertImg(maskLabels, PyIPSDK.eIBT_Binary)
                            maskLabels = advmorpho.connectedComponent2dImg(maskLabels)
                            maskBefore = bin.thresholdImg(maskLabels, 1, max(1, glbmsr.statsMsr2d(maskLabels).max))
                            maskLabels = arithm.addScalarImg(maskLabels, glbmsr.statsMsr2d(outImage).max + 1)
                            maskLabels = arithm.multiplyImgImg(maskLabels, maskBefore)
                            inSE = PyIPSDK.circularSEXYInfo(2)
                            maskCorrection = morpho.dilate2dImg(outImage, inSE)
                        else:
                            inSE = PyIPSDK.sphericalSEXYZInfo(2)
                            maskLabels = morpho.closing3dImg(maskLabels, inSE)
                            maskLabels = util.convertImg(maskLabels, PyIPSDK.eIBT_Binary)
                            maskLabels = advmorpho.connectedComponent3dImg(maskLabels)
                            maskBefore = bin.thresholdImg(maskLabels, 1, max(1, glbmsr.statsMsr3d(maskLabels).max))
                            maskLabels = arithm.addScalarImg(maskLabels, glbmsr.statsMsr3d(outImage).max + 1)
                            maskLabels = arithm.multiplyImgImg(maskLabels, maskBefore)
                            inSE = PyIPSDK.sphericalSEXYZInfo(2)
                            maskCorrection = morpho.dilate3dImg(outImage, inSE)

                        maskCorrection = bin.thresholdImg(maskCorrection, 0, 0)
                        maskLabels = arithm.multiplyImgImg(maskLabels, maskCorrection)

                        outImage = arithm.addImgImg(outImage, maskLabels)

                        outImage = util.convertImg(outImage, image.getBufferType())
                        outImage = itrans.compactIndexImg(outImage)

                    Dfct.clearElement(allMergeLabelsElement)

                    if outImage.getSizeZ() > 1:

                        newLabelValue = 1
                        labelToSplit = []
                        allSplitLabels3DElement = Dfct.SubElement(graphicXmlElement, "AllSplitLabels3D")
                        if len(allSplitLabels3DElement)>0:
                            imageLabel = PyIPSDK.createImage(outImage)
                            for child in allSplitLabels3DElement:
                                if child.tag == "Label":
                                    allPointsElement = Dfct.SubElement(child, "AllPoints")
                                    pointElement = Dfct.SubElement(allPointsElement, "Point")
                                    pointX = Dfct.childText(pointElement, "PointX")
                                    pointY = Dfct.childText(pointElement, "PointY")
                                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                                        labelToSplit.append(outImage.array[int(float(pointY)), int(float(pointX)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
                                        imageLabel.array[int(float(pointY)), int(float(pointX)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()] = newLabelValue
                                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                                        labelToSplit.append(outImage.array[int(float(pointY)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(), int(float(pointX))])
                                        imageLabel.array[int(float(pointY)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(), int(float(pointX))] = newLabelValue
                                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                                        labelToSplit.append(outImage.array[self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), int(float(pointY)), int(float(pointX))])
                                        imageLabel.array[self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), int(float(pointY)), int(float(pointX))] = newLabelValue
                                    newLabelValue += 1

                            surface = PyIPSDK.createImage(outImage)
                            for valueLabel in labelToSplit:
                                surface.array[outImage.array == valueLabel]=1
                                outImage.array[outImage.array == valueLabel]=0

                            mask = util.convertImg(surface,PyIPSDK.eIBT_Binary)

                            #seeds =  util.convertImg(imageLabel,PyIPSDK.eIBT_Binary)
                            # surface, outDistWeight3d = advmorpho.seededDistanceMap3dImg(mask, seeds)

                            surface = morpho.distanceMap3dImg(mask)
                            surface = itrans.invert3dImg(surface)

                            imageRef = advmorpho.seededWatershed3dImg(surface, imageLabel,PyIPSDK.eWatershedOutputMode.eWOM_Basins)

                            imageRef = logic.maskImg(imageRef,mask)
                            imageRef = itrans.compactIndexImg(imageRef)
                            mask = bin.lightThresholdImg(imageRef,1)

                            outImage = itrans.compactIndexImg(outImage)

                            nbLabels = glbmsr.statsMsr3d(outImage).max + 1
                            imageRef = arithm.addScalarImg(imageRef,nbLabels)
                            imageRef = arithm.multiplyImgImg(imageRef,mask)
                            outImage = arithm.addImgImg(outImage,imageRef)

                            outImage = util.convertImg(outImage,image.getBufferType())

                            Dfct.clearElement(allSplitLabels3DElement)

                    if outImage.getSizeZ() == 1:

                        ### Create labels

                        imagePolygon = Image.new('L', (outImage.getSizeX(), outImage.getSizeY()), 0)

                        allAddLabelsElement = Dfct.SubElement(graphicXmlElement, "AllAddLabels")
                        for child in allAddLabelsElement:
                            polygon = []
                            if child.tag == "Label":
                                allPointsElement = Dfct.SubElement(child, "AllPoints")
                                nbPoints = 0
                                for numChild in allPointsElement:
                                    for child in allPointsElement:
                                        if child.tag == "Point":
                                            if Dfct.childText(child, "Num") == str(nbPoints):
                                                pointX = Dfct.childText(child, "PointX")
                                                pointY = Dfct.childText(child, "PointY")
                                                polygon.append(int(float(pointX)))
                                                polygon.append(int(float(pointY)))
                                                nbPoints += 1
                                if len(polygon) > 4:
                                    ImageDraw.Draw(imagePolygon).polygon(polygon, outline=1, fill=1)

                        imagePolygon = 1 * np.array(imagePolygon)
                        imagePolygon = PyIPSDK.fromArray(imagePolygon)

                        maskLabels = bin.thresholdImg(outImage, 1, max(1, glbmsr.statsMsr2d(outImage).max))
                        maskLabels = arithm.addImgImg(maskLabels, imagePolygon)
                        maskLabels = bin.thresholdImg(maskLabels, 1, max(1, glbmsr.statsMsr2d(maskLabels).max))
                        outImage = advmorpho.connectedComponent2dImg(maskLabels)

                        Dfct.clearElement(allAddLabelsElement)

                        ### Split labels

                        imageLines = Image.new('L', (outImage.getSizeX(), outImage.getSizeY()), 0)

                        allSplitLabelsElement = Dfct.SubElement(graphicXmlElement, "AllSplitLabels")
                        for child in allSplitLabelsElement:
                            polygon = []
                            if child.tag == "Label":
                                allPointsElement = Dfct.SubElement(child, "AllPoints")
                                nbPoints = 0
                                for numChild in allPointsElement:
                                    for child in allPointsElement:
                                        if child.tag == "Point":
                                            if Dfct.childText(child, "Num") == str(nbPoints):
                                                pointX = Dfct.childText(child, "PointX")
                                                pointY = Dfct.childText(child, "PointY")
                                                polygon.append(int(float(pointX)))
                                                polygon.append(int(float(pointY)))
                                                nbPoints += 1
                                ImageDraw.Draw(imageLines).line(polygon, width=3, fill=1)

                        imageLines = 1 * np.array(imageLines)
                        imageLines = PyIPSDK.fromArray(imageLines)

                        # structuringElement = PyIPSDK.circularSEXYInfo(1)
                        # erodedImage = morpho.erode2dImg(outImage, structuringElement)
                        #
                        # imageContour = arithm.subtractImgImg(outImage, erodedImage)
                        # imageContour = bin.lightThresholdImg(imageContour,1)
                        #
                        # imageLines = arithm.addImgImg(imageLines,imageContour)
                        imageLines = bin.thresholdImg(imageLines,0,0)

                        maskLabels = bin.lightThresholdImg(outImage,1)
                        imageBinary = arithm.multiplyImgImg(imageLines,maskLabels)
                        imageBinary = util.convertImg(imageBinary,PyIPSDK.eIBT_Binary)

                        outImage = advmorpho.connectedComponent2dImg(imageBinary)

                        outImage = advmorpho.seededWatershed2dImg(outImage, outImage, PyIPSDK.eWatershedOutputMode.eWOM_Basins)
                        outImage = logic.maskImg(outImage, maskLabels)

                        Dfct.clearElement(allSplitLabelsElement)

                    ### Delete labels

                    labelToDelete = []
                    allDeleteLabelsElement = Dfct.SubElement(graphicXmlElement, "AllDeleteLabels")
                    for child in allDeleteLabelsElement:
                        if child.tag == "Label":
                            allPointsElement = Dfct.SubElement(child, "AllPoints")
                            pointElement = Dfct.SubElement(allPointsElement, "Point")
                            pointX = Dfct.childText(pointElement, "PointX")
                            pointY = Dfct.childText(pointElement, "PointY")
                            if outImage.getSizeZ() == 1:
                                labelToDelete.append(outImage.array[int(float(pointY))][int(float(pointX))])
                            else:
                                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                                    labelToDelete.append(outImage.array[int(float(pointY)), int(float(pointX)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
                                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                                    labelToDelete.append(outImage.array[int(float(pointY)), self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(), int(float(pointX))])
                                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                                    labelToDelete.append(outImage.array[self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), int(float(pointY)), int(float(pointX))])

                    if outImage.getSizeZ() == 1:
                        nbLabels = glbmsr.statsMsr2d(outImage).max
                    else:
                        nbLabels = glbmsr.statsMsr3d(outImage).max
                    lutArray = []
                    for i in range(int(nbLabels) + 1):
                        if i not in labelToDelete:
                            lutArray.append(i)
                        else:
                            lutArray.append(0)
                    lut = PyIPSDK.createIntensityLUT(0, 1, lutArray)
                    if outImage.getSizeZ() == 1:
                        outImage = itrans.lutTransform2dImg(outImage, lut)
                    else:
                        outImage = itrans.lutTransform3dImg(outImage, lut)
                    outImage = itrans.compactIndexImg(outImage)

                    Dfct.clearElement(allDeleteLabelsElement)

                if outImage is not None:
                    outImage = util.convertImg(outImage, image.getBufferType())
                    util.copyImg(outImage, image)

                    currentLabel.initImage(compute=True)
                    #currentLabel.groupBoxLut = GroupBoxLut(labelImage=currentLabel.image, parent=currentLabel)
                    currentLabel.groupBoxLut.SignalLutChanged.connect(currentLabel.labelImageMiniature.changeImage)
                    currentLabel.labelImageMiniature.initImage(image)
                    currentLabel.labelImageMiniature.changeImage()

                    self.widgetImage.actualizeScene()
                    self.widgetImage.updateImageViewer()

            self.imageViewer.setFocus()

            # fix of update of labels modifications on overlay image
            self.imageViewer.getRoiImage()

            self.toggleGroupBoxProcessing(False)

        except:
            self.toggleGroupBoxProcessing(False)
            traceback.print_exc(file=sys.stderr)

    def beforeProcess(self):

        if self.widgetImage.imageOverlayLabel is not None and self.widgetImage.imageOverlayLabel.image is not None:
            image = self.widgetImage.imageOverlayLabel.image
            currentLabel = self.widgetImage.imageOverlayLabel
        else:
            image = self.currentLabel.image
            currentLabel = self.currentLabel

        if len(vrb.previousImages) != 0:
            outImage = vrb.previousImages[len(vrb.previousImages)-1]

        if outImage is not None:

            vrb.previousImages.remove(outImage)

            outImage = util.convertImg(outImage, image.getBufferType())
            util.copyImg(outImage, image)

            currentLabel.initImage(compute=True)
            # currentLabel.groupBoxLut = GroupBoxLut(labelImage=currentLabel.image, parent=currentLabel)
            currentLabel.groupBoxLut.SignalLutChanged.connect(currentLabel.labelImageMiniature.changeImage)
            currentLabel.labelImageMiniature.initImage(image)
            currentLabel.labelImageMiniature.changeImage()

            self.widgetImage.actualizeScene()

            self.groupMenu.groupPostProcess.buttonBack.setEnabled(len(vrb.previousImages)>=1)

    def changeDisplayedFunctions(self):
        # newDimension = (WidgetTypes.FunctionDimension.TWO_DIMENSIONS, WidgetTypes.FunctionDimension.THREE_DIMENSIONS, WidgetTypes.FunctionDimension.BOTH)[self.groupBoxSelectionDimension.buttonGroup.checkedId()]
        searchBox.dictCompleter = {}
        self.categorySpoilersContainer.changeDisplayedFunctions()
        self.searchBox.resetWordList()

    def showContrastWindow(self):
        self.widgetContrast.window().setWindowModality(Qt.ApplicationModal)
        self.widgetContrast.show()
        self.widgetContrast.widgetSettings.applySliderValues()

    def updateLineProfile(self):

        for lineProfile in self.graphicElements.allLineProfiles:
            if lineProfile.widget == self.currentLabel:
                self.graphicElements.drawLineProfile(lineProfile)

    def reloadAllFunctionsSpoilers(self,moduleName):

        self.groupBoxProcessing.setText('Reloading the functions...\nPlease wait.')
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)
        self.toggleGroupBoxProcessing(True)
        try:
            self.connectSignalsFromCurrentFunction(disconnect=True)
        except:
            pass

        for i in range(self.categorySpoilersContainer.layout.count() + 1):
            item = self.categorySpoilersContainer.layout.itemAt(i)
            if item is not None:
                spoilerCategory = item.widget()
                nameFunction = fct.invertDictName(dictFolderNames, spoilerCategory.title)
                if nameFunction is None:
                    nameFunction = spoilerCategory.title
                if nameFunction == moduleName:
                    spoilerCategory.widget.initSpoiler()

        self.changeDisplayedFunctions()
        self.toggleGroupBoxProcessing(False)

    def updateCurrentFunction(self):

        if not self.addingResult:

            self.receivedSignalSelector(self.currentSelector, False, 0)
            try:
                # In case currentFunction is not None
                self.connectSignalsFromCurrentFunction(disconnect=True)
            except:
                pass

            self.categorySpoilersContainer.changeCurrentFunction()
            try:
                self.categoryScrollArea.ensureWidgetVisible(self.categorySpoilersContainer.currentFunction)
            except:
                self.categorySpoilersContainer.currentFunction = None
            self.graphicElements.stopPreviewMode()
            self.connectSignalsFromCurrentFunction()

        self.updateComboBoxes()

    def updateFunctionSelectedImages(self):
        if not self.updatingComboBox:
            self.updatingComboBox = True
            self.updateComboBoxes(-2)
            self.updatingComboBox = False

    def connectSignalsFromCurrentFunction(self, disconnect=False):
        if not disconnect:
            if self.categorySpoilersContainer.currentFunction is not None:
                self.categorySpoilersContainer.currentFunction.SignalBatch.connect(self.applyBatch)
                self.categorySpoilersContainer.currentFunction.SignalProcess.connect(self.applyProcess)
                self.categorySpoilersContainer.currentFunction.SignalSelector.connect(self.receivedSignalSelector)
                self.categorySpoilersContainer.currentFunction.SignalSelectionComboBoxChanged.connect(self.updateFunctionSelectedImages)
                self.categorySpoilersContainer.currentFunction.SignalPreviewClicked.connect(self.graphicElements.setPreviewMode)
                self.categorySpoilersContainer.currentFunction.SignalPreviewRefresh.connect(self.computePreview)
                #self.categorySpoilersContainer.currentFunction.SignalReloadFunctionsSpoiler.connect(self.reloadAllFunctionsSpoilers)
        else:
            if self.categorySpoilersContainer.currentFunction is not None:
                self.categorySpoilersContainer.currentFunction.SignalBatch.disconnect(self.applyBatch)
                self.categorySpoilersContainer.currentFunction.SignalProcess.disconnect(self.applyProcess)
                self.categorySpoilersContainer.currentFunction.SignalSelector.disconnect(self.receivedSignalSelector)
                self.categorySpoilersContainer.currentFunction.SignalSelectionComboBoxChanged.disconnect(self.updateFunctionSelectedImages)
                self.categorySpoilersContainer.currentFunction.SignalPreviewClicked.disconnect(self.graphicElements.setPreviewMode)
                self.categorySpoilersContainer.currentFunction.SignalPreviewRefresh.disconnect(self.computePreview)
                #self.categorySpoilersContainer.currentFunction.SignalReloadFunctionsSpoiler.disconnect(self.reloadAllFunctionsSpoilers)

    def updateComboBoxes(self, posCurrent=-1, targetWidget=None):

        """
        :param posCurrent: -1 = the comboBox current index will take position of currentLabel
                           -2 = the comboBox current index will remain on its position
        :param targetWidget: widget where the comboBoxes will be updated
        :return:
        """
        self.updatingComboBox = True
        if targetWidget is None:
            targetWidget = self.categorySpoilersContainer.currentFunction
        listComboBoxesIndex = set()
        if self.categorySpoilersContainer.currentFunction is not None:
            if posCurrent != -2:
                posCurrent = -1
                if self.currentLabel is not None and not self.addingResult:
                    posCurrent = int(Dfct.childText(self.currentLabel.xmlElement, 'Position'))
            else:
                posCurrent = -1

            targetWidget.loadXmlElements(Dfct.SubElement(self.xmlElement, 'AllElements'), posCurrent, listComboBoxesIndex)

        # # selected images in green
        # for num in range(self.widgetLabelImage.layout.count()):
        #     item = self.widgetLabelImage.layout.itemAt(num)
        #     if item is not None:
        #         label = item.widget()
        #         if num in listComboBoxesIndex:
        #             label.editableLabelName.setStyleSheet('QLabel {background-color: transparent;}')
        #             # label.editableLabelName.setStyleSheet('QLabel {background-color: rgb(190, 238, 197);}')
        #             # label.editableLabelName.setStyleSheet('QLabel {background-color: rgb(50, 125, 50);}')
        #         else:
        #             label.editableLabelName.setStyleSheet('QLabel {background-color: transparent;}')
        # self.updatingComboBox = False

    def receivedSignalSelector(self, selector, start, validate):

        try:
            if selector is not None:
                if start:
                    if self.categorySpoilersContainer.currentFunction is not None:

                        functionWidget = self.categorySpoilersContainer.currentFunction
                        functionWidget.createXmlElement()
                        xmlFunctionCall = functionWidget.xmlParametersProcess
                        nameFunction = Dfct.childText(xmlFunctionCall,"Name")

                        if nameFunction in ["TopHat2d","TopHat3d"]:
                            parametersElement = Dfct.SubElement(xmlFunctionCall,"Parameters")
                            param1 = Dfct.SubElement(parametersElement,"Parameter_1")
                            structuringElement = Dfct.xmlToStructuringElement(param1)
                            modeElement = Dfct.SubElement(parametersElement,"Parameter_2")
                            modeValue = Dfct.childText(modeElement,"Value")

                        label = None
                        comboBoxXml = self.categorySpoilersContainer.currentFunction.parameters[0]['Widget'].currentData()
                        elementID = Dfct.childText(comboBoxXml, 'ElementID')
                        for i in range(len(self.widgetLabelImage.layout)):
                            item = self.widgetLabelImage.layout.itemAt(i)
                            if item is not None:
                                widget = item.widget()
                                if Dfct.childText(widget.xmlElement, 'ElementID') == elementID:
                                    label = widget
                        if label is not None:
                            self.changeCurrentXmlElement(label)
                    # self.widgetImage.changeMode('threshold')

                    vrb.allowChangeRoiImage = False

                    rangeSlider = self.widgetImage.rangeSlider
                    rangeSlider.isLockedMin = False
                    rangeSlider.isLockedMax = False
                    rangeSlider.groupSlider.groupBoxStart.setMaximumWidth(int(5000*vrb.ratio))
                    rangeSlider.groupSlider.groupBoxEnd.setMaximumWidth(int(5000*vrb.ratio))
                    self.currentSelector = selector
                    self.widgetImage.changeMode('threshold')

                    if nameFunction in ["TopHat2d","TopHat3d"]:

                        rangeSlider.groupSlider.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')
                        rangeSlider.groupSlider.groupBoxMiddle.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
                        rangeSlider.groupSlider.groupBoxEnd.setStyleSheet('QWidget {background-color: transparent;}')

                        self.widgetImage.thresholdMode = "topHat"

                        if modeValue == "Light":
                            image = self.currentLabel.image
                            if nameFunction == "TopHat2d":
                                imageOpened = morpho.opening2dImg(image, structuringElement, PyIPSDK.eBEP_Disable)
                            elif nameFunction == "TopHat3d":
                                imageOpened = morpho.opening3dImg(image, structuringElement, PyIPSDK.eBEP_Disable)
                            imageThreshold = arithm.subtractImgImg(image,imageOpened)
                        elif modeValue == "Dark":
                            image = self.currentLabel.image
                            if nameFunction == "TopHat2d":
                                imageClosed = morpho.closing2dImg(image, structuringElement, PyIPSDK.eBEP_Disable)
                            elif nameFunction == "TopHat3d":
                                imageClosed = morpho.closing3dImg(image, structuringElement, PyIPSDK.eBEP_Disable)
                            imageThreshold = arithm.subtractImgImg(imageClosed,image)

                        # imageThresholdMultiRes = fct.getMultiResolutionImage(imageThreshold)
                        self.widgetImage.setImageThreshold(imageThreshold)

                        valueMin = 0
                        if imageThreshold.getSizeZ() == 1:
                            valueMax = glbmsr.statsMsr2d(imageThreshold).max
                        else:
                            valueMax = glbmsr.statsMsr3d(imageThreshold).max
                        if valueMax == round(valueMax):
                            valueMax = round(valueMax)
                        rangeSlider.setMinMaxValues(valueMin, valueMax)

                        rangeSlider.type = self.currentLabel.image.getBufferType()

                        currentValueMin = selector.groupBoxSelector.lineEdit.text()
                        currentValueMax = valueMax

                        if currentValueMin != '':
                            currentValueMin = float(currentValueMin)
                        else:
                            currentValueMin = rangeSlider.minValue
                        currentValueMin = max(currentValueMin,0)

                        currentValueMin = float(fct.numberCalibration(currentValueMin))
                        currentValueMax = float(fct.numberCalibration(currentValueMax))

                        rangeSlider.isFixedMin = True
                        rangeSlider.currentValueMin = currentValueMin
                        rangeSlider.setValueMin(currentValueMin)

                        rangeSlider.isFixedMax = True
                        rangeSlider.currentValueMax = currentValueMax
                        rangeSlider.setValueMax(currentValueMax)

                        rangeSlider.setValues(rangeSlider.currentValueMin, rangeSlider.currentValueMax)

                        rangeSlider.isLockedMax = True
                        rangeSlider.groupSlider.groupBoxEnd.setMaximumWidth(0)

                        frequencies = fct.getImageFrequencies(imageThreshold,valueMin,valueMax)
                        self.widgetImage.thresholWidget.rangeSlider.groupSlider.getHistogram(frequencies)

                    elif nameFunction in ["ThresholdImg","HysteresisThreshold2dImg","HysteresisThreshold3dImg"]:

                        if nameFunction == "ThresholdImg":
                            self.widgetImage.thresholdMode = "classic"
                            rangeSlider.groupSlider.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')
                            rangeSlider.groupSlider.groupBoxMiddle.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
                            rangeSlider.groupSlider.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')
                        elif nameFunction in ["HysteresisThreshold2dImg","HysteresisThreshold3dImg"]:
                            rangeSlider.groupSlider.groupBoxMiddle.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
                            if selector.groupBoxSelector.comboBoxType.currentIndex() == 0:
                                rangeSlider.groupSlider.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')
                                rangeSlider.groupSlider.groupBoxEnd.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,192);}')
                                self.widgetImage.thresholdMode = "hysteresisLight"
                            elif selector.groupBoxSelector.comboBoxType.currentIndex() == 1:
                                rangeSlider.groupSlider.groupBoxStart.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,192);}')
                                rangeSlider.groupSlider.groupBoxEnd.setStyleSheet('QWidget {background-color: transparent;}')
                                self.widgetImage.thresholdMode = "hysteresisDark"

                        valueMin = float(self.currentLabel.valueMinRef)
                        valueMax = float(self.currentLabel.valueMaxRef)

                        if valueMin == round(valueMin):
                            valueMin = round(valueMin)
                        if valueMax == round(valueMax):
                            valueMax = round(valueMax)
                        rangeSlider.setMinMaxValues(valueMin, valueMax)

                        if nameFunction != "ThresholdImg" or selector.groupBoxSelector.checkBoxMin.isChecked():
                            currentValueMin = selector.groupBoxSelector.lineEditMin.text()
                        else:
                            currentValueMin = valueMin
                            rangeSlider.isFixedMin = True
                            rangeSlider.isLockedMin = True
                            rangeSlider.groupSlider.groupBoxStart.setMaximumWidth(0)
                        rangeSlider.type = self.currentLabel.image.getBufferType()
                        if currentValueMin != '':
                            currentValueMin = float(currentValueMin)
                        else:
                            currentValueMin = rangeSlider.minValue
                        currentValueMin = max(currentValueMin,rangeSlider.minValue)
                        currentValueMin = max(currentValueMin,self.currentLabel.valueMinRef)
                        # currentValueMin = max(currentValueMin,self.currentLabel.valueMin)

                        # currentValueMax = selector.groupBoxSelector.lineEditMax.text()
                        if nameFunction != "ThresholdImg" or selector.groupBoxSelector.checkBoxMax.isChecked():
                            currentValueMax = selector.groupBoxSelector.lineEditMax.text()
                        else:
                            currentValueMax = valueMax
                            rangeSlider.isFixedMax = True
                            rangeSlider.isLockedMax = True
                            rangeSlider.groupSlider.groupBoxEnd.setMaximumWidth(0)
                        if currentValueMax != '':
                            currentValueMax = float(currentValueMax)
                        else:
                            currentValueMax = rangeSlider.maxValue
                        currentValueMax = min(currentValueMax,rangeSlider.maxValue)
                        currentValueMax = min(currentValueMax,self.currentLabel.valueMaxRef)
                        # currentValueMax = min(currentValueMax,self.currentLabel.valueMax)
                        currentValueMax = max(currentValueMax,rangeSlider.minValue)

                        currentValueMin = min(currentValueMin,currentValueMax)

                        currentValueMin = float(fct.numberCalibration(currentValueMin))

                        currentValueMax = float(fct.numberCalibration(currentValueMax))

                        rangeSlider.isFixedMin = True
                        rangeSlider.currentValueMin = currentValueMin
                        rangeSlider.setValueMin(currentValueMin)

                        rangeSlider.isFixedMax = True
                        rangeSlider.currentValueMax = currentValueMax
                        rangeSlider.setValueMax(currentValueMax)

                        rangeSlider.setValues(rangeSlider.currentValueMin, rangeSlider.currentValueMax)

                        try:
                            if self.currentLabel.frequencies is not None:
                                self.widgetImage.thresholWidget.rangeSlider.groupSlider.getHistogram(self.currentLabel.frequencies)
                        except:
                            traceback.print_exc(file=sys.stderr)

                    # self.widgetImage.rangeSlider.setValues(valueMin, valueMax)
                else:
                    self.widgetImage.imageViewer.setImageThreshold(None)
                    rangeSlider = self.widgetImage.rangeSlider
                    rangeSlider.isLockedMin = False
                    rangeSlider.isLockedMax = False
                    rangeSlider.groupSlider.groupBoxStart.setMaximumWidth(int(5000*vrb.ratio))
                    rangeSlider.groupSlider.groupBoxEnd.setMaximumWidth(int(5000*vrb.ratio))
                    if validate:
                        minValue = rangeSlider.currentValueMin
                        maxValue = rangeSlider.currentValueMax
                        if selector.groupBoxSelector.selectorType in ["Range","Hysteresis"]:
                            selector.groupBoxSelector.lineEditMin.setText(fct.numberCalibration(minValue))
                            selector.groupBoxSelector.lineEditMax.setText(fct.numberCalibration(maxValue))
                            self.widgetImage.rangeSlider.groupSlider.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')
                            self.widgetImage.rangeSlider.groupSlider.groupBoxMiddle.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
                            self.widgetImage.rangeSlider.groupSlider.groupBoxEnd.setStyleSheet('QWidget {background-color: transparent;}')
                        elif selector.groupBoxSelector.selectorType == "Simple":
                            selector.groupBoxSelector.lineEdit.setText(fct.numberCalibration(minValue))
                    self.widgetImage.changeMode('classic')
                    self.currentSelector = None
                    if self.categorySpoilersContainer.currentFunction is not None:
                        self.categorySpoilersContainer.currentFunction.enableAllParameters()
                    selector.stackedWidget.setCurrentWidget(selector.groupBoxSelector)

        except:
            traceback.print_exc(file=sys.stderr)
            vrb.allowChangeRoiImage = True

            self.widgetImage.rangeSlider.groupSlider.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')
            self.widgetImage.rangeSlider.groupSlider.groupBoxMiddle.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
            self.widgetImage.rangeSlider.groupSlider.groupBoxEnd.setStyleSheet('QWidget {background-color: transparent;}')

        vrb.allowChangeRoiImage = True

        self.widgetImage.getRoiImage()

    def computePreview(self):

        if self.graphicElements.previewMode:

            self.groupBoxProcessing.setText('Processing preview...\nPlease wait.')
            self.groupBoxProcessing.buttonStop.setVisible(False)
            self.groupBoxProcessing.progressBar.setVisible(False)
            self.toggleGroupBoxProcessing(True)
            if self.categorySpoilersContainer is not None and self.categorySpoilersContainer.currentFunction is not None:
                self.graphicElements.previewColor = vrb.dictColor[2]
                functionWidget = self.categorySpoilersContainer.currentFunction
                functionWidget.createXmlElement()
                xmlFunctionCall = functionWidget.xmlParametersProcess
                functionName = Dfct.childText(xmlFunctionCall, 'Name')
                if functionName in dictAllFunctions:
                    try:
                        try:
                            textFunction = dictAllFunctions[functionName](xmlFunctionCall,preview=True)
                        except:
                            textFunction = dictAllFunctions[functionName](xmlFunctionCall)
                        allID = []
                        textSplit = textFunction.split('ID_')
                        for i in range(1, len(textSplit)):
                            newID = textSplit[i].split('_ID')[0]
                            if newID not in allID:
                                allID.append(newID)
                        for id in allID:
                            text = "ID_" + id + "_ID = self.idToROI(id)"
                            exec(text)

                        _locals = locals()

                        # print (textFunction)

                        exec(textFunction, globals(), _locals)


                        outputs = _locals['outputs']
                        try:
                            # If len(outputs) == 1 on le change en vecteur
                            len(outputs)
                        except:
                            outputs = [outputs]

                        outputsElement = Dfct.SubElement(xmlFunctionCall, 'Outputs')
                        self.imagePreview = None
                        for i in range(len(outputsElement)):
                            outputElement = Dfct.SubElement(outputsElement, "Parameter_" + str(i))
                            if Dfct.childText(outputElement, 'Type') == "Image":
                                self.imagePreview = outputs[i]
                                break

                        if self.imagePreview is not None:
                            if self.imagePreview.getSizeZ() > 1:
                                self.imagePreview = self.widgetImage.imageViewerStandAloneNormal.getImagePlan(self.imagePreview, middleValue=True)
                            if self.imagePreview.getSizeC() == 1:
                                if self.imagePreview.getSizeZ() > 1:
                                    stats = glbmsr.statsMsr3d(self.imagePreview)
                                else:
                                    stats = glbmsr.statsMsr2d(self.imagePreview)
                                self.imagePreview.valueMin = stats.min
                                self.imagePreview.valueMax = stats.max
                            else:
                                self.imagePreview.valueMin = 0
                                self.imagePreview.valueMax = 1
                            self.widgetImage.previewMinX, self.widgetImage.previewMinY, self.widgetImage.previewSizeX, self.widgetImage.previewSizeY = DWfct.boundingBoxPolygon(self.graphicElements.previewRectangle)
                            vrb.previewError = False
                            self.imageViewer.getRoiImage(changeRoiImage=False)

                    except Exception as e:
                        print(traceback.format_exc())
                        self.imagePreview = None
                        self.graphicElements.previewColor = vrb.dictColor[3]
                        vrb.previewError = True
                        self.imageViewer.getRoiImage(changeRoiImage=False)
            self.toggleGroupBoxProcessing(False)

    def verifProcess(self, functionWidget):

        continueProcess = True
        for nb in functionWidget.parameters:
            if type(functionWidget.parameters[nb]["Widget"]) == MyComboBoxObject:
                if functionWidget.parameters[nb]["Widget"].count() == 0:
                    continueProcess = False
                    error = functionWidget.parameters[nb]["Label"].text() + " is not initialized"
                    break

        if continueProcess == False:

            try:
                title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
            except:
                if vrb.currentFunction is None:
                    title = "Error script"
                else:
                    title = vrb.currentFunction + " Error script"

            fct.writeLogs(title,error)

            try:
                title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
                self.popUpWindowError.setMessageAndShow(error, title)
                traceback.print_exc(file=sys.stderr)
            except:
                traceback.print_exc(file=sys.stderr)

        return continueProcess

    def applyBatch(self,functionWidget):

        functionWidget.createXmlElement()
        xmlFunctionCall = functionWidget.xmlParametersProcess

        self.widgetBatch = WidgetBatch(functionWidget)
        self.widgetBatch.show()

    def applyProcess(self,functionWidget):

        vrb.batch = False
        vrb.paramMacro = False

        if vrb.isDigisens or vrb.unitTestMode:
            self.applyProcessSync(functionWidget)
        else:
            functionWidget.createXmlElement()
            xmlFunctionCall = functionWidget.xmlParametersProcess
            functionName = Dfct.childText(xmlFunctionCall, 'Name')

            if functionName == "MacroFunction":
                self.applyProcessSync(functionWidget)
            else:
                # self.applyProcessSync(functionWidget)
                self.applyProcessAsync(functionWidget)

    def applyProcessAsync(self, functionWidget,xmlFunctionCall = None,widgetFilter =None):

        self.groupBoxProcessing.progressBar.setRange(0, 100)
        self.groupBoxProcessing.progressBar.setValue(0)
        self.groupBoxProcessing.progressBar.setVisible(True)
        self.groupBoxProcessing.progressBar.setRange(0, 0)

        self.threadProcess = ThreadProcess(mainWindow=self)
        self.threadProcess.SignalFinishProcess.connect(self.finishProcess)
        #self.threadProcess.SignalActualizeProgressBar.connect(self.actualizeProgressBar)
        self.threadProcess.SignalActualizeTime.connect(self.actualizeTime)

        if xmlFunctionCall is None:
            continueProcess = self.verifProcess(functionWidget)
        else:
            continueProcess = True

        if continueProcess:
            self.groupBoxProcessing.setText('Processing...\nPlease wait.')
            self.groupBoxProcessing.buttonStop.setVisible(True)
            # self.groupBoxProcessing.progressBar.setVisible(True)
            self.toggleGroupBoxProcessing(True)
            try:
                self.receivedSignalSelector(self.currentSelector, False, 1)
                if xmlFunctionCall is None:
                    functionWidget.createXmlElement()
                    xmlFunctionCall = functionWidget.xmlParametersProcess

                functionName = Dfct.childText(xmlFunctionCall, 'Name')
                if not (functionName in dictAllFunctions):
                    # Function is not present in the dictionary
                    try:
                        title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
                        self.popUpWindowError.setMessageAndShow(str('INTERNAL ERROR: function ' + functionName + ' not found.'), title)
                    except:
                        pass
                else:
                    outputsDict = {}
                    for output in Dfct.SubElement(xmlFunctionCall, 'Outputs'):
                        numOutput = int(output.tag.split("_")[1])
                        outputsDict[numOutput] = {}
                        outputsDict[numOutput]['Name'] = Dfct.childText(output, 'Value')
                        outputsDict[numOutput]['Type'] = Dfct.childText(output, 'Type')
                    try:
                        textFunction = dictAllFunctions[functionName](xmlFunctionCall)
                        allID = []
                        textSplit = textFunction.split('ID_')
                        for i in range(1, len(textSplit)):
                            newID = textSplit[i].split('_ID')[0]
                            if newID not in allID:
                                allID.append(newID)

                        textFunction = self.transformText(textFunction)

                        self.threadProcess.textFunction = textFunction
                        self.threadProcess.xmlFunctionCall = xmlFunctionCall
                        self.threadProcess.outputsDict = outputsDict
                        self.threadProcess.allID = allID
                        self.threadProcess.functionWidget = functionWidget
                        self.widgetFilter = widgetFilter

                        self.threadProcess.start()
                        #self.threadProcess.start(priority=QtCore.QThread.TimeCriticalPriority)
                        # self.threadProcess.start(priority=QtCore.QThread.InheritPriority)
                        # self.threadProcess.start(priority=QtCore.QThread.IdlePriority)

                    except:
                        self.toggleGroupBoxProcessing(False)
                        try:
                            if widgetFilter is not None:
                                widgetFilter.buttonPreview.setEnabled(True)
                                widgetFilter.buttonCompute.setEnabled(True)
                        except:
                            pass
                        traceback.print_exc(file=sys.stderr)

            except:
                pass

    def applyProcessSync(self, functionWidget,xmlFunctionCall=None):

        # self.groupBoxProcessing.progressBar.setRange(0, 100)
        # self.groupBoxProcessing.progressBar.setValue(0)
        #
        # self.threadProcess = ThreadProcess(mainWindow=self)
        # self.threadProcess.SignalFinishProcess.connect(self.finishProcess)
        # #self.threadProcess.SignalActualizeProgressBar.connect(self.actualizeProgressBar)
        # self.threadProcess.SignalActualizeTime.connect(self.actualizeTime)

        if xmlFunctionCall is None:
            continueProcess = self.verifProcess(functionWidget)
        else:
            continueProcess = True

        if continueProcess:
            self.groupBoxProcessing.setText('Processing...\nPlease wait.')
            self.groupBoxProcessing.buttonStop.setVisible(False)
            #self.groupBoxProcessing.progressBar.setVisible(True)
            self.toggleGroupBoxProcessing(True)
            try:
                self.receivedSignalSelector(self.currentSelector, False, 1)
                if xmlFunctionCall is None:
                    functionWidget.createXmlElement()
                    xmlFunctionCall = functionWidget.xmlParametersProcess
                functionName = Dfct.childText(xmlFunctionCall, 'Name')
                if not (functionName in dictAllFunctions):
                    try:
                        # Function is not present in the dictionary
                        title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
                        self.popUpWindowError.setMessageAndShow(str('INTERNAL ERROR: function ' + functionName + ' not found.'), title)
                    except:
                        pass
                else:
                    outputsDict = {}
                    for output in Dfct.SubElement(xmlFunctionCall, 'Outputs'):
                        numOutput = int(output.tag.split("_")[1])
                        outputsDict[numOutput] = {}
                        outputsDict[numOutput]['Name'] = Dfct.childText(output, 'Value')
                        outputsDict[numOutput]['Type'] = Dfct.childText(output, 'Type')
                    try:
                        if functionName == "MacroFunction":
                            textFunction = dictAllFunctions["MacroFunction"](xmlFunctionCall,synchrone = True,forExec=True)
                        else:
                            textFunction = dictAllFunctions[functionName](xmlFunctionCall)
                        allID = []
                        textSplit = textFunction.split('ID_')
                        for i in range(1, len(textSplit)):
                            newID = textSplit[i].split('_ID')[0]
                            if newID not in allID:
                                allID.append(newID)

                        for id in allID:
                            text = "ID_" + id + "_ID = self.idToVariable(id)"
                            exec(text)

                        vrb.printDebug("----------------")
                        vrb.printDebug(textFunction)
                        vrb.printDebug("----------------")

                        _locals = locals()
                        startTime = time.time()

                        # if functionName == "MacroFunction":
                        #     textFunction = self.transformTextSynchron(textFunction)

                        try:

                            print('##### Function #########')
                            print(textFunction)
                            print('##### After Function #########')

                            exec(textFunction, globals(), _locals)

                        except Exception as e:
                            try:
                                exc_type, exc_value, exc_traceback = sys.exc_info()
                                tb_details = traceback.extract_tb(exc_traceback)
                                lastFrame = tb_details[len(tb_details)-1]

                                path = Path(lastFrame.filename)
                                base_folder = path.parent.name
                                file_name,extension = os.path.splitext(path.name)

                                macroName = base_folder + "/" + file_name

                                if str(exc_type) in ["<class 'SyntaxError'>","<class 'IndentationError'>"]:

                                    lineNumber =str(exc_value).split("line ")[1]
                                    lineNumber =lineNumber.split(")")[0]
                                    macroFolder = Dfct.childText(xmlFunctionCall, 'PythonName').split("/")[0]
                                    macroName = str(exc_value).split('(')[1]
                                    macroName = macroName.split(".py")[0]
                                    macroName = macroFolder + "/" + macroName

                                    textError = "<p>Error in macro <a href='" + macroName + " " + lineNumber + "'>" + macroName + "</a>, line " + lineNumber + "<br><br>"
                                    textError += str(exc_value) + "</p>"

                                else:

                                    textError = "<p>Error in macro <a href='" + macroName + " " + str(lastFrame.lineno) + "'>" + macroName + "</a>, line " + str(lastFrame.lineno) + ", in " + str(lastFrame.name) + "<br><br>"
                                    textError += str(lastFrame.line) + "<br><br>"
                                    textError += str(exc_value)+ "</p>"

                                try:
                                    if functionWidget is None:
                                        title = Dfct.childText(self.threadProcess.functionWidget.xmlFunctionDescription, 'Name')
                                    else:
                                        title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
                                    fct.writeLogs(title, e)

                                    self.showError(textError, functionWidget=functionWidget)
                                except:
                                    traceback.print_exc(file=sys.stderr)

                            except:
                                traceback.print_exc(file=sys.stderr)

                                try:
                                    if functionWidget is None:
                                        title = Dfct.childText(self.threadProcess.functionWidget.xmlFunctionDescription, 'Name')
                                    else:
                                        title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
                                    fct.writeLogs(title, e)
                                except:
                                    pass

                                self.showError(e, functionWidget=functionWidget)

                        # except Exception as e:
                        #     try:
                        #         traceback.print_exc(file=sys.stderr)
                        #     except:
                        #         pass

                            # self.showError(e,functionWidget=functionWidget)

                        execTime = time.time() - startTime
                        Dfct.SubElement(xmlFunctionCall, 'ExecutionTime').text = str(execTime)
                        try:
                            outputs = _locals['outputs']
                        except:
                            outputs = None

                        vrb.printDebug('Outputs: ' + str(outputs))

                        outputs = outputs

                        try:
                            # If len(outputs) == 1 on le change en vecteur
                            len(outputs)
                        except:
                            outputs = [outputs]
                        if outputs is not None:
                            outputsNode = Dfct.SubElement(xmlFunctionCall, 'Outputs')
                            # Process outputs
                            associatedLabels = []
                            for nb, output in enumerate(outputs, 0):
                                # output est l'objet IPSDK (image,histogramme,...)
                                if output is not None:
                                    if nb in outputsDict:
                                        label, realOutputName = self.addResult(output, outputsDict[nb], Dfct.copyXmlElement(xmlFunctionCall))
                                    else:
                                        currentOutput = {}
                                        currentOutput["Type"] = WidgetTypes.InputType.IMAGE.value
                                        currentOutput["Name"] = ""
                                        label, realOutputName = self.addResult(output, currentOutput, Dfct.copyXmlElement(xmlFunctionCall))

                                    try:
                                        if vrb.allowChangeName:
                                            self.categorySpoilersContainer.currentFunction.outputs[nb]['Widget'].setText(realOutputName)
                                    except:
                                        pass
                                    # Dfct.SubElement(Dfct.SubElement(outputsNode, 'Output_' + str(nb)), 'Value').text = realOutputName
                                    associatedLabels.append(label)

                            for label in associatedLabels:
                                xmlElement = label.xmlElement
                                textAssociated = ''
                                for labelBis in associatedLabels:
                                    textAssociated += Dfct.childText(labelBis.xmlElement, 'ElementID') + ','
                                Dfct.SubElement(xmlElement, 'AssociatedID').text = textAssociated[:-1]

                    except Exception as e:

                        traceback.print_exc(file=sys.stderr)

                        self.addingResult = False

                        try:
                            title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
                        except:
                            if vrb.currentFunction is None:
                                title = "Error script"
                            else:
                                title = vrb.currentFunction + " Error script"

                        fct.writeLogs(title, e)

                        self.showError(e,functionWidget)


                    self.toggleGroupBoxProcessing(False)

            except:
                traceback.print_exc(file=sys.stderr)

        self.toggleGroupBoxProcessing(False)

        try:
            nameFunction =Dfct.SubElement(xmlFunctionCall, 'Name').text
            self.saveBackupSession(nameFunction)
        except:
            pass

    def finishProcess(self):

        if vrb.continueProcess and self.threadProcess.error is None:

            try:
                outputs = self.threadProcess.outputs
                try:
                    # If len(outputs) == 1 on le change en vecteur
                    len(outputs)
                except:
                    outputs = [outputs]
                if outputs is not None:
                    outputsNode = Dfct.SubElement(self.threadProcess.xmlFunctionCall, 'Outputs')
                    # Process outputs
                    associatedLabels = []
                    for nb, output in enumerate(outputs, 0):
                        # output est l'objet IPSDK (image,histogramme,...)
                        if output is not None:
                            if nb in self.threadProcess.outputsDict:
                                label, realOutputName = self.addResult(output, self.threadProcess.outputsDict[nb], Dfct.copyXmlElement(self.threadProcess.xmlFunctionCall))
                            else:
                                currentOutput = {}
                                currentOutput["Type"] = WidgetTypes.InputType.IMAGE.value
                                currentOutput["Name"] = ""
                                label, realOutputName = self.addResult(output, currentOutput, Dfct.copyXmlElement(self.threadProcess.xmlFunctionCall))
                            try:
                                if vrb.allowChangeName:
                                    self.categorySpoilersContainer.currentFunction.outputs[nb]['Widget'].setText(realOutputName)
                            except:
                                pass
                            # Dfct.SubElement(Dfct.SubElement(outputsNode, 'Output_' + str(nb)), 'Value').text = realOutputName
                            associatedLabels.append(label)

                    for label in associatedLabels:
                        xmlElement = label.xmlElement
                        textAssociated = ''
                        for labelBis in associatedLabels:
                            textAssociated += Dfct.childText(labelBis.xmlElement, 'ElementID') + ','
                        Dfct.SubElement(xmlElement, 'AssociatedID').text = textAssociated[:-1]

            except Exception as e:

                traceback.print_exc(file=sys.stderr)

                try:
                    title = Dfct.childText(self.threadProcess.functionWidget.xmlFunctionDescription, 'Name')
                except:
                    if vrb.currentFunction is None:
                        title = "Error script"
                    else:
                        title = vrb.currentFunction + " Error script"

                fct.writeLogs(title,e)

                self.showError(e)

        else:
            if vrb.continueProcess:

                try:
                    title = Dfct.childText(self.threadProcess.functionWidget.xmlFunctionDescription, 'Name')
                except:
                    if vrb.currentFunction is None:
                        title = "Error script"
                    else:
                        title = vrb.currentFunction + " Error script"

                try:
                    fct.writeLogs(title,self.threadProcess.error)
                except:
                    pass

                self.showError(self.threadProcess.error)

        vrb.continueProcess = True
        self.toggleGroupBoxProcessing(False)
        try:
            if self.widgetFilter is not None:
                self.widgetFilter.buttonPreview.setEnabled(True)
                self.widgetFilter.buttonCompute.setEnabled(True)
        except:
            pass

        try:
            nameFunction =Dfct.SubElement(self.threadProcess.functionWidget.xmlFunctionDescription, 'Name').text
            self.saveBackupSession(nameFunction)
        except:
            traceback.print_exc(file=sys.stderr)


    def showError(self, e,functionWidget = None):

        try:
            if functionWidget is None:
                title = Dfct.childText(self.threadProcess.functionWidget.xmlFunctionDescription, 'Name')
            else:
                title = Dfct.childText(functionWidget.xmlFunctionDescription, 'Name')
            if "must be str, not NoneType" in str(e):
                e = "Please verify that all your parameters are initialized"
            self.popUpWindowError.setMessageAndShow(str(e), title)

            # traceback.print_exc(file=sys.stderr)
        except:
            # print("error window error")
            # traceback.print_exc(file=sys.stderr)
            pass

    def terminateThread(self):

        vrb.continueProcess = False
        self.groupBoxProcessing.labelLeft.setText('Stopping...\nPlease wait.')
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)

    def transformTextSynchron(self,text):

        text = text.replace("    ", "\t")

        newText = ""
        newText += "self.timeRef = time.time()\n"
        newText += "self.timePrevious = time.time()\n"

        modules = ["arithm.", "advmorpho.", "morpho.", "color.", "filtering.", "util.", "bin.", "logic.", "glbmsr.", "gtrans.", "shapeanalysis.", "shapesegmentation.", "itrans.", "fd.", "stats.", "classif."]

        textSplit = text.split("\n")
        for line in textSplit:
            hasFunction = False
            currentModule = None
            for module in modules:
                if module in line:
                    currentModule = module
                    hasFunction = True
            newText += line + "\n"
            if hasFunction:
                lineBeforeModule = line.split(currentModule)[0]
                indentSplit = lineBeforeModule.split("\t")
                indent = ""
                for i in range(len(indentSplit) - 1):
                    indent += "\t"
                newText += indent + "if time.time() - vrb.mainWindow.timePrevious > 0.1:\n"
                newText += indent + "\tvrb.mainWindow.actualizeTime()\n"
                newText += indent + "\tvrb.mainWindow.timePrevious = time.time()\n"
                # newText += indent + "try:\n"
                # newText += indent + "\tself.emitSignalActualizeTime()\n"
                # newText += indent + "except:\n"
                # newText += indent + "\tpass\n"

        # print (newText)

        return newText

    def transformText(self, text):

        allImports = []

        newText = ""
        newText += "self.mainWindow.timeRef = time.time()\n"
        newText += "error = None\n"
        newText += "import UsefullVariables as vrb\n"

        modules = ["arithm.", "advmorpho.", "morpho.", "color.", "filtering.", "util.", "bin.", "logic.", "glbmsr.", "gtrans.", "shapeanalysis.", "shapesegmentation.", "itrans.", "fd.", "stats.", "classif.","ml."]

        exceptions = ['gblmsr','glbmsr','shapeanalysis.create']

        text = text.replace("    ", "\t")

        textSplit = text.split("\n")
        for line_ in textSplit:

            startLine = False

            line = ""
            stop = False
            for ch in line_:
                if stop == False:
                    if ch == "#":
                        stop = True
                    else:
                        line+= ch

            if str.startswith(line, "import "):
                allImports.append(line)

            if str.startswith(line,"def "):
                if str.endswith(line,"):"):

                    startLine = True

                    line = line.replace("):",",self):")

                    correctedLine = ""
                    stop = False
                    for ch in line:
                        if ch == "=":
                            stop = True
                        elif ch in [",",")"]:
                            stop = False
                            correctedLine += ch
                        else:
                            if stop == False:
                                correctedLine+= ch
                    line = correctedLine

            hasFunction = False
            continueProcess = True
            for exception in exceptions:
                if exception in line:
                    continueProcess = False
            for module in modules:
                if module in line and hasFunction == False and continueProcess:
                    indentSplit = line.split("\t")
                    indent = ""
                    for i in range(len(indentSplit) - 1):
                        indent += "\t"

                    variables = line.split(module)[0]
                    afterModule = line.split(module)[1]
                    function = afterModule.split("(")[0]
                    afterFunction = afterModule.split(")")
                    afterFunction = afterFunction[-1:][0]

                    if len(afterFunction) == 0:
                        newText += indent + "processor = " + module + afterModule.replace(function, function + "_async") + "\n"
                    else:
                        line = indent + "processor = " + module + afterModule.replace(function, function + "_async")
                        line = line[:-len(afterFunction)]
                        newText += line + "\n"
                    newText += indent + "while processor.getStatus() != PyIPSDK.eES_Completed and vrb.continueProcess:\n"

                    newText += indent + "\ttry:\n"
                    newText += indent + "\t\tself.emitSignalActualizeTime()\n"
                    newText += indent + "\texcept:\n"
                    newText += indent + "\t\tpass\n"

                    # newText += indent + "\ttry:\n"
                    # newText += indent + "\t\tself.mainWindow.eic.update()\n"
                    # newText += indent + "\t\tsum = self.mainWindow.eic.getNbPending()+self.mainWindow.eic.getNbNotReleased()+self.mainWindow.eic.getNbProcessed()\n"
                    # newText += indent + "\t\tif sum > 0:\n"
                    # newText += indent + "\t\t\tratio = int(100*self.mainWindow.eic.getNbProcessed()/sum)\n"
                    # newText += indent + "\t\t\tprint(ratio)\n"
                    # # newText += indent + "\t\t\tif ratio <=100:\n"
                    # # newText += indent + "\t\t\t\tself.emitSignalActualizeProgressBar(ratio)\n"
                    # newText += indent + "\texcept:\n"
                    # newText += indent + "\t\tpass\n"

                    newText += indent + "\ttime.sleep(0.01)\n"
                    newText += indent + "if vrb.continueProcess==False:\n"
                    newText += indent + "\tprocessor.requestCancellation()\n"
                    newText += indent + "\tprocessor.waitForCompletion()\n"
                    newText += indent + "elif processor.getActionResult().getResult()==PyIPSDK.eER_Failed:\n"
                    newText += indent + "\terror = processor.getActionResult().getMsg()\n"
                    newText += indent + "\tprocessor.requestCancellation()\n"
                    newText += indent + "\tprocessor.waitForCompletion()\n"
                    newText += indent + "else:\n"

                    if "pixelClassificationRFWithProbabilitiesImg" in afterModule:
                        newText += "\t" + variables + module + "getAsyncProcessorOutputTuple(processor)" + afterFunction + "\n"
                    else:
                        if afterModule.startswith("multiSlice")==False:
                            newText += "\t" + variables + module + "getAsyncProcessorOutput(processor)" + afterFunction + "\n"
                        else:
                            newText += indent + "\ttry:\n"
                            newText += "\t\t" + variables + module + "getAsyncProcessorMultiSliceOutput(processor)" + afterFunction + "\n"
                            newText += indent + "\texcept:\n"
                            newText += "\t\t" + variables + module + "getAsyncProcessorOutput(processor)" + afterFunction + "\n"

                    hasFunction = True
            if hasFunction == False:
                newText += line + "\n"

            if startLine:
                for importLine in allImports:
                    newText+= "\t" + importLine + "\n"

        # newText = newText.replace("__ = classif.getAsyncProcessorOutput(processor)", "__,__ = classif.getAsyncProcessorOutput(processor)")

        # print (newText)

        return newText

    def idToVariable(self, id):

        outVariable = None

        textSplit = id.split('_')
        typeElem = textSplit[0]
        numID = textSplit[1]
        if typeElem == WidgetTypes.InputType.IMAGE.value:
            outVariable = self.widgetLabelImage.numIDToImage(numID)
        elif typeElem in WidgetTypes.comboBoxTypes:
            outVariable = self.widgetLabelValue.numIDToValue(numID, typeElem)

        #print (outVariable)

        return outVariable

    def idToROI(self, id):
        textSplit = id.split('_')
        typeElem = textSplit[0]
        numID = textSplit[1]
        if typeElem == WidgetTypes.InputType.IMAGE.value:
            image = self.widgetLabelImage.numIDToImage(numID)
            if image.getVolumeGeometryType() == PyIPSDK.eVGT_2d:
                x, y, sizeX, sizeY = DWfct.boundingBoxPolygon(self.graphicElements.previewRectangle)
                outVariable = util.getROI2dImg(image, x, y, sizeX, sizeY)
            else:
                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                    y, z, sizeY, sizeZ = DWfct.boundingBoxPolygon(self.graphicElements.previewRectangle)
                    halfSizeX = int(self.widgetImage.lineEditPreviewAxis.text())
                    x = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value() - halfSizeX
                    x = max(0, x)
                    sizeX = 2 * halfSizeX + 1
                    x = min(image.getSizeX() - sizeX, x)
                elif self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                    x, z, sizeX, sizeZ = DWfct.boundingBoxPolygon(self.graphicElements.previewRectangle)
                    halfSizeY = int(self.widgetImage.lineEditPreviewAxis.text())
                    y = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value() - halfSizeY
                    y = max(0, y)
                    sizeY = 2 * halfSizeY + 1
                    y = min(image.getSizeY() - sizeY, y)
                elif self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                    x, y, sizeX, sizeY = DWfct.boundingBoxPolygon(self.graphicElements.previewRectangle)
                    halfSizeZ = int(self.widgetImage.lineEditPreviewAxis.text())
                    z = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value() - halfSizeZ
                    z = max(0, z)
                    sizeZ = 2 * halfSizeZ + 1
                    z = min(image.getSizeZ() - sizeZ, z)
                outVariable = util.getROI3dImg(image, x, y, z, sizeX, sizeY, sizeZ)

        elif typeElem in WidgetTypes.comboBoxTypes:
            outVariable = self.widgetLabelValue.numIDToValue(numID, typeElem)
        return outVariable

    def addResult(self, ipsdkObject, outputDict, functionXmlElement=None,id=None):

        try:
            self.addingResult = True

            if outputDict["Type"] == WidgetTypes.InputType.IMAGE.value:
                label, name = self.widgetLabelImage.addNewImage(outputDict["Name"], ipsdkObject, functionXmlElement=functionXmlElement,id=id)
                if self.widgetImage.modeViewer == "2D":
                    self.changeCurrentXmlElement(label)
                    # self.displayButtonEye()
                # self.viewer3dSettingsWidget.loadSettings(label)
            elif (outputDict["Type"] == WidgetTypes.OutputType.SHAPES.value and ipsdkObject.objectType=="3D") or outputDict["Type"] == "Mesh":
                label, name = self.widgetLabelImage.addNewMesh(outputDict["Name"], ipsdkObject, functionXmlElement=functionXmlElement,id=id)
                # self.changeCurrentXmlElement(label)
            else:
                start = time.time()
                label, name = self.widgetLabelValue.addValue(outputDict, ipsdkObject, functionXmlElement=functionXmlElement,id=id)

            self.updateCurrentFunction()
        finally:
            self.addingResult = False

        return label, name

    def buttonCropImage(self):

        overlayLabel = self.widgetImage.imageOverlayLabel
        if overlayLabel is not None:
            self.cropImage(changeImage=False)
            currentLabel = self.labelCropped
            self.cropImage(currentLabel=overlayLabel,changeImage = False)
            self.changeCurrentXmlElement(currentLabel)

            for num in range(self.widgetImage.groupBoxOverlay.comboBoxOverlay.count()):
                if self.widgetImage.groupBoxOverlay.comboBoxOverlay.itemData(num) == self.labelCropped:
                    self.widgetImage.groupBoxOverlay.comboBoxOverlay.setCurrentIndex(num)
                self.widgetImage.groupBoxOverlay.checkBoxOverlay.setChecked(True)
            self.labelCropped = None

        else:
            self.cropImage()

    def cropImage(self, addImage=True,currentLabel=None, changeImage = True, currentPlanOnly = False):

        currentPlanOnly = False

        if currentLabel is None:
            currentLabel= self.currentLabel

        if currentLabel is not None:
            self.toggleGroupBoxProcessing(True)
            self.groupBoxProcessing.setText("Cropping image\n")
            self.groupBoxProcessing.buttonStop.setVisible(False)
            self.groupBoxProcessing.progressBar.setVisible(False)
            outImage = None
            try:
                # image = self.widgetImage.image
                image = currentLabel.image
                startTime = time.time()

                if self.graphicElements.selectionRectangle3D is not None:
                    if currentPlanOnly and image.getSizeZ() > 1:
                        image = fct.extractZPlan(image, self.widgetImage)

                    name = ""
                    functionXmlElement = xmlet.Element('FunctionCall')
                    Dfct.SubElement(functionXmlElement, 'Name').text = 'GetROI2dImg'
                    paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
                    paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
                    typeNode = Dfct.SubElement(paramNode0, 'Type')
                    typeNode.text = "Image"
                    valueNode = Dfct.SubElement(paramNode0, 'Value')
                    valueNode.text = Dfct.childText(currentLabel.xmlElement, 'ElementID')

                    valueNode.set('isElementID', str(True))

                    if image.getSizeZ() == 1:

                        minX, minY, maxX, maxY = None, None, None, None

                        allPointsElement = Dfct.SubElement(self.graphicElements.selectionRectangle3D, 'AllPoints')

                        valueX_min = round(float(Dfct.childText(allPointsElement, "X1")))
                        valueX_max = round(float(Dfct.childText(allPointsElement, "X2")))
                        valueY_min = round(float(Dfct.childText(allPointsElement, "Y1")))
                        valueY_max = round(float(Dfct.childText(allPointsElement, "Y2")))

                        #fix of crop with max values inferior to min values
                        if valueX_max < valueX_min:
                            tmp = valueX_min
                            valueX_min = valueX_max
                            valueX_max = tmp
                        # fix of crop with max values inferior to min values
                        if valueY_max < valueY_min:
                            tmp = valueY_min
                            valueY_min = valueY_max
                            valueY_max = tmp

                        if minX is None:
                            minX = valueX_min
                            minY = valueY_min
                            maxX = valueX_max
                            maxY = valueY_max
                        else:
                            minX = min(minX, valueX_min)
                            minY = min(minY, valueY_min)
                            maxX = max(maxX, valueX_max)
                            maxY = max(maxY, valueY_max)

                        if minX < maxX and minY < maxY:

                            # name = "Plan_" + Dfct.childText(self.currentXmlElement, "Name")

                            paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                            Dfct.SubElement(paramNode1, 'Type').text = "Scalar"
                            Dfct.SubElement(paramNode1, 'Value').text = str(minX)
                            paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
                            Dfct.SubElement(paramNode2, 'Type').text = "Scalar"
                            Dfct.SubElement(paramNode2, 'Value').text = str(minY)
                            paramNode3 = Dfct.SubElement(paramsNode, 'Parameter_3')
                            Dfct.SubElement(paramNode3, 'Type').text = "Scalar"
                            Dfct.SubElement(paramNode3, 'Value').text = str(maxX - minX)
                            paramNode4 = Dfct.SubElement(paramsNode, 'Parameter_4')
                            Dfct.SubElement(paramNode4, 'Type').text = "Scalar"
                            Dfct.SubElement(paramNode4, 'Value').text = str(maxY - minY)

                        outImage = util.getROI2dImg(image, minX, minY, maxX - minX, maxY - minY)

                    else:

                        Dfct.SubElement(functionXmlElement, 'Name').text = 'GetROI3dImg'
                        coord3DElement = Dfct.SubElement(self.graphicElements.selectionRectangle3D, 'AllPoints')
                        minX = int(float(Dfct.childText(coord3DElement,"X1")))
                        maxX = int(float(Dfct.childText(coord3DElement,"X2")))
                        minY = int(float(Dfct.childText(coord3DElement,"Y1")))
                        maxY = int(float(Dfct.childText(coord3DElement,"Y2")))
                        minZ = int(float(Dfct.childText(coord3DElement,"Z1")))
                        maxZ = int(float(Dfct.childText(coord3DElement,"Z2")))

                        # fix of crop with max values inferior to min values
                        if maxX < minX:
                            tmp = minX
                            minX = maxX
                            maxX = tmp
                        # fix of crop with max values inferior to min values
                        if maxY < minY:
                            tmp = minY
                            minY = maxY
                            maxY = tmp
                        # fix of crop with max values inferior to min values
                        if maxZ < minZ:
                            tmp = minZ
                            minZ = maxZ
                            maxZ = tmp

                        paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                        Dfct.SubElement(paramNode1, 'Type').text = "Scalar"
                        Dfct.SubElement(paramNode1, 'Value').text = str(minX)
                        paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
                        Dfct.SubElement(paramNode2, 'Type').text = "Scalar"
                        Dfct.SubElement(paramNode2, 'Value').text = str(minY)
                        paramNode3 = Dfct.SubElement(paramsNode, 'Parameter_3')
                        Dfct.SubElement(paramNode3, 'Type').text = "Scalar"
                        Dfct.SubElement(paramNode3, 'Value').text = str(minZ)
                        paramNode4 = Dfct.SubElement(paramsNode, 'Parameter_4')
                        Dfct.SubElement(paramNode4, 'Type').text = "Scalar"
                        Dfct.SubElement(paramNode4, 'Value').text = str(maxX-minX)
                        paramNode5 = Dfct.SubElement(paramsNode, 'Parameter_5')
                        Dfct.SubElement(paramNode5, 'Type').text = "Scalar"
                        Dfct.SubElement(paramNode5, 'Value').text = str(maxY-minY)
                        paramNode6 = Dfct.SubElement(paramsNode, 'Parameter_6')
                        Dfct.SubElement(paramNode6, 'Type').text = "Scalar"
                        Dfct.SubElement(paramNode6, 'Value').text = str(maxZ-minZ)

                        outImage = util.getROI3dImg(image, minX,minY,minZ,maxX-minX,maxY-minY,maxZ-minZ)

                    execTime = time.time() - startTime
                    Dfct.SubElement(functionXmlElement, 'ExecutionTime').text = str(execTime)
                    if addImage:
                        if outImage.isDiskImage() and self.diskImagesPreferencesWidget.checkBoxConvertAfterCrop.isChecked():
                            outImage = fct.convertToMemoryImage(outImage)
                        if outImage.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16,PyIPSDK.eIBT_Label32]:
                            outImage = itrans.compactIndexImg(outImage)
                        label, name = self.widgetLabelImage.addNewImage(name, outImage, functionXmlElement)
                        Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')
                        if changeImage:
                            self.changeCurrentXmlElement(label)
                        else:
                            self.labelCropped = label

                self.updateCurrentFunction()
            except:
                traceback.print_exc(file=sys.stderr)
                outImage = None

            self.graphicElements.selectionRectangle3D = None
            self.graphicElements.getRoiImage(changeRoiImage=False,transformImage=False)
            if self.viewer3dSettingsWidget.roi3D is not None:
                self.viewer3dSettingsWidget.roi3D.data = [[0, 0, 0], [0, 0, 0], [0, 0, 0], [0, 0, 0]]

            self.toggleGroupBoxProcessing(False)

            if addImage == False:
                return outImage

    def exportResultSmartSegmentation(self):

        if self.moduleRF_Segmentation.currentLabel is not None:

            self.toggleGroupBoxProcessing(True)
            self.groupBoxProcessing.setText('Exporting results\n')
            self.groupBoxProcessing.buttonStop.setVisible(False)
            self.groupBoxProcessing.progressBar.setVisible(False)
            qt.QApplication.processEvents()

            try:
                # image = self.widgetImage.image
                # image = self.currentLabel.image

                startTime = time.time()

                name = ""
                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'PixelClassificationImg'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
                paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
                typeNode = Dfct.SubElement(paramNode0, 'Type')
                typeNode.text = "Image"
                valueNode = Dfct.SubElement(paramNode0, 'Value')

                found=False
                for num in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        if label.name == self.moduleRF_Segmentation.currentLabel.name:
                            valueNode.text = Dfct.childText(label.xmlElement, 'ElementID')
                            valueNode.set('isElementID', str(True))
                            found = True

                if found is False:
                    valueNode.text = Dfct.childText(self.moduleRF_Segmentation.currentLabel.xmlElement, 'ElementID')

                nameModel = self.moduleRF_Segmentation.settingsWidget.lineEditModelName.text()
                if nameModel is None or nameModel == "":
                    nameModel = self.moduleRF_Segmentation.settingsWidget.lineEditModelName.placeholderText()

                paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                typeNode = Dfct.SubElement(paramNode1, 'Type')
                typeNode.text = 'String'
                valueNode = Dfct.SubElement(paramNode1, 'Value')
                valueNode.text = nameModel

                paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
                typeNode = Dfct.SubElement(paramNode2, 'Type')
                typeNode.text = 'Scalar'
                valueNode = Dfct.SubElement(paramNode2, 'Value')
                valueNode.text = "0.5"

                outImage = self.moduleRF_Segmentation.imageViewer.imageOverlay[0]

                execTime = time.time() - startTime
                Dfct.SubElement(functionXmlElement, 'ExecutionTime').text = str(execTime)

                label, name = self.widgetLabelImage.addNewImage(name, outImage, functionXmlElement)
                Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')

                self.changeCurrentXmlElement(label)

                self.updateCurrentFunction()
                self.toggleGroupBoxProcessing(False)
            except:
                traceback.print_exc(file=sys.stderr)
                self.toggleGroupBoxProcessing(False)

    def exportResultSuperPixelSegmentation(self):

        if self.moduleRF_SuperPixels.currentLabel is not None:

            self.toggleGroupBoxProcessing(True)
            self.groupBoxProcessing.setText('Exporting results\n')
            self.groupBoxProcessing.buttonStop.setVisible(False)
            self.groupBoxProcessing.progressBar.setVisible(False)
            qt.QApplication.processEvents()

            try:

                self.moduleRF_SuperPixels.updateLabelClasses()

                startTime = time.time()

                name = ""
                functionXmlElement = xmlet.Element('FunctionCall')
                Dfct.SubElement(functionXmlElement, 'Name').text = 'SuperPixelSegmentationImg'
                paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
                paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
                typeNode = Dfct.SubElement(paramNode0, 'Type')
                typeNode.text = "Image"
                valueNode = Dfct.SubElement(paramNode0, 'Value')

                found=False
                for num in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        if label.name == self.moduleRF_SuperPixels.currentLabel.name:
                            valueNode.text = Dfct.childText(label.xmlElement, 'ElementID')
                            valueNode.set('isElementID', str(True))
                            found = True

                if found is False:
                    valueNode.text = Dfct.childText(self.moduleRF_SuperPixels.currentLabel.xmlElement, 'ElementID')

                nameModel = self.moduleRF_SuperPixels.settingsWidget.lineEditModelName.text()
                if nameModel is None or nameModel == "":
                    nameModel = self.moduleRF_SuperPixels.settingsWidget.lineEditModelName.placeholderText()

                paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
                typeNode = Dfct.SubElement(paramNode1, 'Type')
                typeNode.text = 'String'
                valueNode = Dfct.SubElement(paramNode1, 'Value')
                valueNode.text = nameModel

                outImage = fctML.computeSuperPixelSegmentation(self.moduleRF_SuperPixels.currentLabel.image,self.moduleRF_SuperPixels.xmlElement,self.moduleRF_SuperPixels.model)

                execTime = time.time() - startTime
                Dfct.SubElement(functionXmlElement, 'ExecutionTime').text = str(execTime)

                label, name = self.widgetLabelImage.addNewImage(name, outImage, functionXmlElement)
                Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')

                self.changeCurrentXmlElement(label)

                self.updateCurrentFunction()

                self.toggleGroupBoxProcessing(False)
            except:
                traceback.print_exc(file=sys.stderr)
                self.toggleGroupBoxProcessing(False)

    def extractImage(self,imageViewerStandAlone):

        self.toggleGroupBoxProcessing(True)
        self.groupBoxProcessing.setText('Extracting image\n')
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)

        try:

            image = self.widgetImage.image
            startTime = time.time()
            # name = "Plan_"+Dfct.childText(self.currentXmlElement,"Name")
            name = ""
            functionXmlElement = xmlet.Element('FunctionCall')
            # Dfct.SubElement(functionXmlElement, 'Name').text = 'ExtractPlan'
            Dfct.SubElement(functionXmlElement, 'Name').text = 'ExtractImage'
            paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
            paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
            typeNode = Dfct.SubElement(paramNode0, 'Type')
            typeNode.text = "Image"
            valueNode = Dfct.SubElement(paramNode0, 'Value')
            valueNode.text = Dfct.childText(self.currentLabel.xmlElement, 'ElementID')
            valueNode.set('isElementID', str(True))
            paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
            paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
            paramNode3 = Dfct.SubElement(paramsNode, 'Parameter_3')

            if image.getSizeC() != 1:
                colorGeometryType = image.getColorGeometryType()
                colorGeometry = PyIPSDK.ColorGeometry()
                if colorGeometryType == PyIPSDK.eCGT_User:
                    colorGeometry.initUser(image.getSizeC())
                else:
                    colorGeometry.init(colorGeometryType)
                volumeGeometry = PyIPSDK.VolumeGeometry()
                volumeGeometry.init2d()
                temporalGeometry = PyIPSDK.TemporalGeometry()
                temporalGeometry.initSingle()

            if image.getSizeT() > 1:
                valueSequence = imageViewerStandAlone.sliderAxis.sliderSequence.slider.value()
                if image.getSizeZ() == 1:
                    if image.getSizeC() == 1:
                        imageProcess = PyIPSDK.extractPlan(0, 0, valueSequence, image)
                    else:
                        imageProcess = PyIPSDK.extractColor(0, valueSequence, image)
                else:
                    if image.getSizeC() == 1:
                        imageProcess = PyIPSDK.extractVolume(0, valueSequence, image)
                    else:
                        imageProcess = PyIPSDK.extractColorVolume(valueSequence, image)
                image = util.copyImg(imageProcess)
                Dfct.SubElement(paramNode3, 'Value').text = str(valueSequence)
            else:
                Dfct.SubElement(paramNode3, 'Value').text = "-1"

            if image.getSizeZ() > 1:
                if imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                    Dfct.SubElement(paramNode1, 'Value').text = "Z"
                    Dfct.SubElement(paramNode2, 'Value').text = str(imageViewerStandAlone.sliderAxis.sliderZ.slider.value())
                    if image.getSizeC() == 1:
                        outImage = PyIPSDK.extractPlan(imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), 0, 0, image)
                    else:
                        outImage = PyIPSDK.extractColor(imageViewerStandAlone.sliderAxis.sliderZ.slider.value(), 0, image)
                else:
                    if imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                        Dfct.SubElement(paramNode1, 'Value').text = "X"
                        Dfct.SubElement(paramNode2, 'Value').text = str(imageViewerStandAlone.sliderAxis.sliderX.slider.value())
                        if image.getSizeC() == 1:
                            planArray = np.ascontiguousarray(image.array[:, :, imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
                            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeY(), image.getSizeZ())
                        else:
                            planArray = np.ascontiguousarray(image.array[:, :, :, imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
                            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeY(), image.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)
                    if imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                        Dfct.SubElement(paramNode1, 'Value').text = "Y"
                        Dfct.SubElement(paramNode2, 'Value').text = str(imageViewerStandAlone.sliderAxis.sliderY.slider.value())
                        if image.getSizeC() == 1:
                            planArray = np.ascontiguousarray(image.array[:, imageViewerStandAlone.sliderAxis.sliderY.slider.value(), :])
                            geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeX(), image.getSizeZ())
                        else:
                            planArray = np.ascontiguousarray(image.array[:, :, imageViewerStandAlone.sliderAxis.sliderY.slider.value(), :])
                            geometry = PyIPSDK.geometry(image.getBufferType(), image.getSizeX(), image.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)
                    outImage = PyIPSDK.fromArray(planArray, geometry)
                outImage = util.copyImg(outImage)
            else:
                Dfct.SubElement(paramNode1, 'Value').text = "No_Axis"
                Dfct.SubElement(paramNode2, 'Value').text = "0"
                outImage = util.copyImg(image)
            execTime = time.time() - startTime
            Dfct.SubElement(functionXmlElement, 'ExecutionTime').text = str(execTime)

            if outImage.isDiskImage() and self.diskImagesPreferencesWidget.checkBoxConvertAfterExtract.isChecked():
                outImage = fct.convertToMemoryImage(outImage)

            label, name = self.widgetLabelImage.addNewImage(name, outImage, functionXmlElement)
            Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')
            self.changeCurrentXmlElement(label)

        except:
            traceback.print_exc(file=sys.stderr)

        self.updateCurrentFunction()
        self.toggleGroupBoxProcessing(False)

    def addLabelsFromUrls(self, urls, multi=False, sequence = False, disk = False):

        self.toggleGroupBoxProcessing(True)

        if multi == False:
            for i in range(len(urls)):
                try:
                    url = str(urls[i].toLocalFile())
                except:
                    url = urls[i]
                urlSplit = url.split('.')
                extension = urlSplit[len(urlSplit) - 1]
                if extension in vrb.extensionImages:
                    try:
                        label,image = self.urlToImage(url, multi=multi, disk = disk)
                    except:
                        traceback.print_exc(file=sys.stderr)
                        print("Error : could not load the image " + url)
                elif extension.lower() in ["xml","bin"]:
                    try:
                        label,objectValue = self.urlToObject(url)
                    except:
                        traceback.print_exc(file=sys.stderr)
                elif extension.lower() == "stl":
                    try:
                        label,objectValue = self.urlToMesh(url)
                    except:
                        traceback.print_exc(file=sys.stderr)
        else:
            try:
                label,image = self.urlToImage(urls, multi=multi, sequence = sequence,disk = disk)
            except:
                traceback.print_exc(file=sys.stderr)
                print("Error : could not load the image " + urls)

        self.updateCurrentFunction()
        self.toggleGroupBoxProcessing(False)

    def urlToImage(self, url, multi=False, geometry=None, offset = None , sequence = False, disk = False):

        name = os.path.basename(url)

        urlSplit = url.split('.')
        extension = urlSplit[len(urlSplit) - 1]
        self.groupBoxProcessing.setText('Adding image\n' + name)
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)
        qt.QApplication.processEvents()
        startTime = time.time()
        if geometry is None:
            image = fct.readImage(url, multi=multi,name=name, sequence = sequence,disk = disk)
        else:
            text = ""
            text += "geometry = " + geometry
            text += "offset = " + offset
            if disk:
                text += "image = PyIPSDK.openRawImageFile('" + url + "', geometry,offset)"
            else:
                text += "image = PyIPSDK.loadRawImageFile('" + url + "', geometry,offset)\n"
                text += "image = util.copyImg(image)"
            # text += "image = PyIPSDK.loadRawImageFile('" + url + "', geometry,256)"
            _locals = locals()
            exec(text, globals(), _locals)
            image = _locals["image"]
        execTime = time.time() - startTime
        functionXmlElement = xmlet.Element('FunctionCall')
        Dfct.SubElement(functionXmlElement, 'ExecutionTime').text = str(execTime)
        if geometry is None:
            Dfct.SubElement(functionXmlElement, 'Name').text = 'LoadImage'
            paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
            paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
            Dfct.SubElement(paramNode0, 'Value').text = Dfct.convertTextToAscii(url)
            paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
            Dfct.SubElement(paramNode1, 'Value').text = str(disk)
        else:
            Dfct.SubElement(functionXmlElement, 'Name').text = 'LoadImageRaw'
            paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
            paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
            Dfct.SubElement(paramNode0, 'Value').text = Dfct.convertTextToAscii(url)
            paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
            Dfct.SubElement(paramNode1, 'Value').text = geometry
            paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
            Dfct.SubElement(paramNode2, 'Value').text = offset
        label, name = self.widgetLabelImage.addNewImage(name, image, functionXmlElement)
        Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')
        self.changeCurrentXmlElement(label)

        return label,image

    def urlToObject(self,url):

        name = os.path.basename(url)

        urlSplit = url.split('.')
        extension = urlSplit[len(urlSplit) - 1]
        name = name.replace('.' + extension, '')
        self.groupBoxProcessing.setText('Adding object\n' + name)
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)
        qt.QApplication.processEvents()
        startTime = time.time()

        if extension.lower() == "xml":
            myObject = PyIPSDK.readFromXmlFile(url)
        elif extension.lower() == "bin":
            myObject = PyIPSDK.readFromBinaryFile(url)

        myObject = myObject[0]

        if type(myObject) == WidgetTypes.IPSDKType.HISTOGRAM.value:
            myType = "Histogram"
        elif type(myObject) == WidgetTypes.IPSDKType.SHAPEANALYSIS.value:
            myType = "ShapeAnalysis"
        elif type(myObject) == WidgetTypes.IPSDKType.SHAPEANALYSIS_MULTISLICE.value:
            myType = "ShapeAnalysis"
        elif type(myObject) == WidgetTypes.IPSDKType.SHAPESEGMENTATION_SHAPES_2D.value:
            myObject.objectType = "2D"
            myType = "Shapes"
        elif type(myObject) == WidgetTypes.IPSDKType.SHAPESEGMENTATION_SHAPES_3D.value:
            myObject.objectType = "3D"
            myType = "Shapes"
        else:
            print(type(myObject))

        outputDict = {}
        outputDict["Name"] = name
        outputDict["Type"] = myType

        execTime = time.time() - startTime
        functionXmlElement = xmlet.Element('FunctionCall')
        Dfct.SubElement(functionXmlElement, 'ExecutionTime').text = str(execTime)

        Dfct.SubElement(functionXmlElement, 'Name').text = 'LoadObject'
        paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
        paramNode = Dfct.SubElement(paramsNode, 'Parameter_0')
        Dfct.SubElement(paramNode, 'Value').text = Dfct.convertTextToAscii(url)

        if outputDict["Type"] == WidgetTypes.OutputType.SHAPES.value and myObject.objectType=="3D":
            label, name = self.widgetLabelImage.addNewMesh(outputDict["Name"], myObject, functionXmlElement=functionXmlElement)
            Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')
            self.changeCurrentXmlElement(label)
        else:
            label, name = self.widgetLabelValue.addValue(outputDict, myObject, functionXmlElement=functionXmlElement)
            Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')

        return label,myObject

    def urlToMesh(self,url):

        name = os.path.basename(url)

        urlSplit = url.split('.')
        extension = urlSplit[len(urlSplit) - 1]
        name = name.replace('.' + extension, '')
        self.groupBoxProcessing.setText('Adding mesh\n' + name)
        self.groupBoxProcessing.buttonStop.setVisible(False)
        self.groupBoxProcessing.progressBar.setVisible(False)
        qt.QApplication.processEvents()
        startTime = time.time()

        myObject = PyIPSDK.readStL(url)

        outputDict = {}
        outputDict["Name"] = name
        outputDict["Type"] = "Mesh"

        execTime = time.time() - startTime
        functionXmlElement = xmlet.Element('FunctionCall')
        Dfct.SubElement(functionXmlElement, 'ExecutionTime').text = str(execTime)

        Dfct.SubElement(functionXmlElement, 'Name').text = 'LoadStl'
        paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
        paramNode = Dfct.SubElement(paramsNode, 'Parameter_0')
        Dfct.SubElement(paramNode, 'Value').text = Dfct.convertTextToAscii(url)

        label, name = self.widgetLabelImage.addNewMesh(outputDict["Name"], myObject,functionXmlElement=functionXmlElement)
        Dfct.SubElement(label.xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')
        self.changeCurrentXmlElement(label)

        return label,myObject

    def changeCurrentXmlElementFromDoubleClick(self,label):

        self.changeCurrentXmlElement(label,verifModeViewer = False)

    def changeCurrentXmlElement(self, label, verifModeViewer = True,resetRectangle = True):

        if verifModeViewer == False or self.widgetImage.modeViewer == "2D" or self.widgetLabelImage.layout.count() <= 1:
            verif = True
        else:
            verif = False

        if verif:

            try:

                vrb.allowChangeRoiImage = False
                self.widgetImage.setImageThreshold(None)
                self.widgetImage.changeMode(self.widgetImage.mode)

                vrb.previousImages = []
                self.groupMenu.groupPostProcess.buttonBack.setEnabled(False)

                for widgetObject in self.widgetImage.elementIPSDK:
                    try:
                        currentWidget = widgetObject.currentWidget
                        currentWidget.labelButtonDisplay.setState(0)
                    except:
                        traceback.print_exc(file=sys.stderr)
                self.widgetImage.elementIPSDK = set()

                self.imageViewer.setToolTip("")
                if resetRectangle:
                    self.graphicElements.selectionRectangle3D = None
                    self.graphicElements.selectionRectangle = None
                    self.graphicElements.coord3DElement = None
                vrb.barycenterX = None
                vrb.barycenterY = None
                vrb.barycenterZ = None
                vrb.currentShapeAnalysisDisplayer = None
                # try:
                #     self.currentLabel.setStyleSelected(False)
                # except:
                #     pass
                self.currentXmlElement = label.xmlElement
                self.currentLabel = label

                if self.widgetImage.modeViewer != "2D":

                    if not label.hasNapari:
                        nbLayers = len(vrb.mainWindow.viewerNapari.layers)
                        if label.objectType == "Mesh" or (label.objectType == "Image" and self.currentLabel.buttonOrthoslices.activate):
                            label.addToNapari()
                        if nbLayers == 0:
                            label.setButtonEyeActivation(True)
                        # self.displayButtonEye()
                        # self.viewer3dSettingsWidget.resetThreshold()
                        # self.resetView()
                    self.viewer3dSettingsWidget.changeDisplayAxis()
                    self.viewer3dSettingsWidget.loadSettings(label=label)

                if label is not None:
                    self.parent.setWindowTitle('IPSDK Explorer - ' + str(Dfct.childText(label.xmlElement, "Name")))
                else:
                    self.parent.setWindowTitle('IPSDK Explorer')

                # self.currentLabel.setStyleSelected(True)

                self.widgetLabelImage.updateStyleSheet()

                if self.currentLabel.objectType == "Image":
                    self.widgetImage.setImage(self.currentLabel,changeRoi = False)

                    try:
                        if self.currentLabel.image.getSizeZ() > 1:
                            self.parent.menuBar.actionSaveAsMultiSlices.setEnabled(True)
                            self.groupMenu.groupCalibration.buttonCalibrationSettings.setEnabled(False)
                            self.groupMenu.groupCalibration.buttonApplyCalibrationSettings.setEnabled(False)
                        else:
                            self.parent.menuBar.actionSaveAsMultiSlices.setEnabled(False)
                            self.groupMenu.groupCalibration.buttonCalibrationSettings.setEnabled(True)
                            self.groupMenu.groupCalibration.buttonApplyCalibrationSettings.setEnabled(True)
                            self.imageViewer.parent.sliderAxis.radioButtonZ.setChecked(True)
                    except:
                        traceback.print_exc(file=sys.stderr)

                    # self.groupMenu.groupViewer.button3dMode.setEnabled(self.currentLabel.image.getSizeZ() > 1)
                    # self.groupMenu.groupViewer.button4ViewsMode.setEnabled(self.currentLabel.image.getSizeZ() > 1)
                    # if self.currentLabel.image.getSizeZ() == 1:
                    #     self.groupMenu.setModeViewer("2D")

                elif self.currentLabel.objectType == "Mesh":
                    self.resetViewer2D()

                self.updateOverlayComboBox()

                self.widgetImage.groupBoxOverlay.checkBoxOverlay.setChecked(False)

                self.setPostProcessVisible()

                if self.currentLabel.objectType == "Image":

                    if self.currentLabel.image is not None:
                        if self.currentLabel.image.hasGeometricCalibration():
                            calib = self.currentLabel.image.getGeometricCalibration()
                            if calib.getUnitStr() == "px" and calib.getXScale() == 1 and calib.getYScale() == 1 and calib.getZScale() == 1:
	
                                self.groupMenu.groupCalibration.applyDefaultCalibration()

                    self.groupMenu.groupCalibration.loadImageCalibration()
                    self.groupMenu.groupCalibration.imageToInterfaceCalibration()
                    self.graphicElements.stopCalibrationLine()
                    self.groupMenu.groupContrast.loadContrast()

                vrb.allowChangeRoiImage = True

                # self.imageViewer.getRoiImage()
                self.widgetImage.actualizeSceneChangeRoi()

                self.graphicElements.stopPreviewMode()

                # self.viewer3dSettingsWidget.loadSettings()
                # self.resetImageViewer()

                self.widgetImage.rangeSlider.isLockedMin = False
                self.widgetImage.rangeSlider.isLockedMax = False
                self.widgetImage.rangeSlider.groupSlider.groupBoxStart.setMaximumWidth(int(5000 * vrb.ratio))
                self.widgetImage.rangeSlider.groupSlider.groupBoxEnd.setMaximumWidth(int(5000 * vrb.ratio))

                # self.receivedSignalSelector(self.currentSelector, False, 0)

                self.cameraChanged()

                self.SignalCurrentElementChanged.emit()

            except:
                print ('error loading image')
                traceback.print_exc(file=sys.stderr)
                vrb.allowChangeRoiImage = True

    def setPostProcessVisible(self):

        if self.currentLabel is not None and self.currentLabel.objectType == "Image":
            if self.widgetImage.imageOverlayLabel is not None and self.widgetImage.imageOverlayLabel.image is not None:
                image = self.widgetImage.imageOverlayLabel.image
            else:
                try:
                    image = self.currentLabel.image
                except:
                    image = None

            if image is not None:
                if image.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:
                    self.groupMenu.groupPostProcess.setVisible(True)
                    self.groupMenu.groupPostProcess.buttonAddLabel.setVisible(image.getSizeZ() == 1 or vrb.polygonIn3D)
                    self.groupMenu.groupPostProcess.buttonSplitLabel.setVisible(image.getSizeZ() == 1)
                    self.groupMenu.groupPostProcess.buttonSplitLabel3D.setVisible(image.getSizeZ() > 1)
                    if image.getSizeZ() > 1:
                        if vrb.polygonIn3D:
                            self.groupMenu.groupPostProcess.setFixedWidth(int(210 * vrb.ratio + 3 * 6 * vrb.ratio + 8 * vrb.ratio))
                            if self.groupMenu.currentMode in ["SplitLabel"]:
                                self.groupMenu.setMode("Selection")
                        else:
                            self.groupMenu.groupPostProcess.setFixedWidth(int(180*vrb.ratio + 3 * 4*vrb.ratio + 8*vrb.ratio))
                            if self.groupMenu.currentMode in ["SplitLabel", "AddLabel"]:
                                self.groupMenu.setMode("Selection")
                    else:
                        self.groupMenu.groupPostProcess.setFixedWidth(int(210*vrb.ratio + 3 * 6*vrb.ratio + 8*vrb.ratio))
                else:
                    self.groupMenu.groupPostProcess.setVisible(False)
                    if self.groupMenu.currentMode in ["MergeLabel", "SplitLabel", "AddLabel", "DeleteLabel"]:
                        self.groupMenu.setMode("Selection")
            else:
                self.groupMenu.groupPostProcess.setVisible(False)
                if self.groupMenu.currentMode in ["MergeLabel", "SplitLabel", "AddLabel", "DeleteLabel"]:
                    self.groupMenu.setMode("Selection")
        else:
            self.groupMenu.groupPostProcess.setVisible(False)
            if self.groupMenu.currentMode in ["MergeLabel", "SplitLabel", "AddLabel", "DeleteLabel"]:
                self.groupMenu.setMode("Selection")

    def updateOverlayComboBox(self):
        self.widgetImage.groupBoxOverlay.comboBoxOverlay.clear()
        if self.currentLabel is not None and self.currentLabel.image is not None and self.currentLabel.objectType == "Image":
            currentSizeX, currentSizeY, currentSizeZ = self.currentLabel.image.getSizeX(), self.currentLabel.image.getSizeY(), self.currentLabel.image.getSizeZ()
            currentIndex = self.widgetImage.groupBoxOverlay.comboBoxOverlay.currentIndex()
            for num in range(self.widgetLabelImage.layout.count()):
                item = self.widgetLabelImage.layout.itemAt(num)
                if item is not None:
                    label = item.widget()
                    if label != self.currentLabel and label.objectType == "Image":
                        sizeX, sizeY, sizeZ = label.image.getSizeX(), label.image.getSizeY(), label.image.getSizeZ()
                        if sizeX == currentSizeX and sizeY == currentSizeY and sizeZ == currentSizeZ:
                            self.widgetImage.groupBoxOverlay.comboBoxOverlay.addItem(Dfct.childText(label.xmlElement, 'Name'), label)
            if currentIndex != -1 and currentIndex < self.widgetImage.groupBoxOverlay.comboBoxOverlay.count():
                self.widgetImage.groupBoxOverlay.comboBoxOverlay.setCurrentIndex(currentIndex)
            else:
                self.widgetImage.groupBoxOverlay.comboBoxOverlay.setCurrentIndex(0)

    def labelDeleted(self, position):

        try:
            self.parent.setWindowTitle('IPSDK Explorer')
            currentPosition = int(Dfct.childText(self.currentXmlElement, "Position"))

            if currentPosition == -1:
                item = self.widgetLabelImage.layout.itemAt(position)
                if item is not None:
                    self.changeCurrentXmlElement(item.widget(),verifModeViewer=False)
                else:
                    if position > 0:
                        item = self.widgetLabelImage.layout.itemAt(position - 1)
                        if item is not None:
                            self.changeCurrentXmlElement(item.widget(),verifModeViewer=False)
                        else:
                            self.resetScene()
                    else:
                        self.resetScene()
            self.updateCurrentFunction()
            self.updateOverlayComboBox()
            self.SignalCurrentElementChanged.emit()
        except:
            traceback.print_exc(file=sys.stderr)

    def clearAllImages(self):
        try:
            # vrb.mainWindow.viewer3dSettingsWidget.loadingSettings=False
            # self.viewerNapari.layers.clear()

            for i in range(self.widgetDeleteAll.layoutCheckBox.count()):
                item = self.widgetDeleteAll.layoutCheckBox.itemAt(i)
                if item is not None:
                    widget = item.widget()
                    if widget.isChecked():
                        for j in range(self.widgetLabelImage.layout.count()):
                            itemImage = self.widgetLabelImage.layout.itemAt(j)
                            if itemImage is not None and itemImage.widget() == widget.widget:
                                self.widgetLabelImage.deleteLabel(itemImage.widget())

            self.widgetDeleteAll.close()
        except:
            traceback.print_exc(file=sys.stderr)

    def resetViewer2D(self):

        for imageViewer in [self.widgetImage.imageViewerStandAloneNormal.imageViewer,self.widgetImage.imageViewerStandAloneX.imageViewer,
                            self.widgetImage.imageViewerStandAloneY.imageViewer,self.widgetImage.imageViewerStandAloneZ.imageViewer]:
            imageViewer.scene.clear()
            imageViewer.scene.clearSelection()
            imageViewer.scene.clearFocus()
        self.widgetImage.setImage(None)
        self.image = None
        self.setPostProcessVisible()

    def resetScene(self):

        self.currentLabel = None
        self.currentXmlElement = None
        self.resetViewer2D()


    # def toggleGroupBoxProcessing(self):
    #
    #     if self.isEnabled() and not self.groupBoxProcessing.isVisible():
    #         self.groupBoxProcessing.setVisible(True)
    #         # self.setEnabled(False)
    #         qt.QApplication.processEvents()
    #         qt.QApplication.processEvents()
    #     else:
    #         self.setEnabled(True)
    #         self.groupBoxProcessing.setVisible(False)

    def toggleGroupBoxProcessing(self, valueVisible = False):

        if valueVisible:
            self.groupBoxProcessing.setVisible(True)
            # self.setEnabled(False)
            qt.QApplication.processEvents()
            qt.QApplication.processEvents()
        else:
            self.setEnabled(True)
            self.groupBoxProcessing.setVisible(False)

    def loadStyleSheet(self):
        style = ""
        with open(vrb.folderStyles + '/dark.qss') as file:
            for line in file:
                style += line
        self.setStyleSheet(style)


if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook


    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook

    foo = MainWindow(app=app)

    style = fct.getStyleSheet()
    # app.setStyleSheet(style)
    foo.setStyleSheet(style)

    pixmap = QtGui.QPixmap(vrb.folderImages + '/Explorer_Logo_Bleu.png')
    pixmap = pixmap.scaled(20, 20, transformMode=Qt.SmoothTransformation)
    app.setWindowIcon(QtGui.QIcon(pixmap))

    foo.show()

    # foo.centralWidget.img0 = PyIPSDK.loadTiffImageFile("D:/ExampleImages/Concrete_Labeled_500.tif")
    # start = time.time()
    # foo.centralWidget.viewerNapari.add_labels(foo.centralWidget.img0.array, name="image")
    # print("Layers", foo.centralWidget.viewerNapari.layers, time.time() - start)

    app.exec_()