import sys, os, traceback
import re as regex
import xml.etree.ElementTree as xmlet

from PyQt5 import QtWidgets as qt, QtGui
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication

import DatabaseFunction as Dfct

from FunctionsDictionary import dictAllFunctions
import UsefullVariables as vrb
import UsefullWidgets as wgt
import UsefullFunctions as fct
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint,MachineLearningConstraint

from FunctionsDictionary import dictFolderNames

import ElementIDManager as Eidm

from TextEditor import TextEditor
from TextForMacroExamples import dictExamples
# from HighlightTextEditor import PythonHighlighter

def findFunctionsAndArguments(textScript):

    try:

        textSplit = textScript.split('\ndef ')
        functionsDict = {}
        if textSplit[0].startswith('def '):
            textSplit[0] = textSplit[0].replace('def ', '')
            functionHeader = textSplit[0].replace(' ', '').split('):\n')[0]
            functionSplit = functionHeader.split('(')
            functionName = functionSplit[0]
            args = functionSplit[1].split(',')
            functionsDict[functionName] = {}

            correctArgs = []
            for arg in args:
                newArg = arg.split("=")[0]
                correctArgs.append(newArg)

            functionsDict[functionName]["args"] = correctArgs

            returnSplit = textSplit[0]
            returnSplit = returnSplit.replace('    ','\t')
            returnSplit = returnSplit.split('\n\treturn')[1]
            returnSplit = returnSplit.split("\n")[0]
            returnSplit = returnSplit.split(",")
            functionsDict[functionName]["return"] = returnSplit

        for i in range(1, len(textSplit)):
            functionHeader = textSplit[i].replace(' ', '').split('):\n')[0]
            functionSplit = functionHeader.split('(')
            functionName = functionSplit[0]
            args = functionSplit[1].split(',')
            functionsDict[functionName] = {}

            correctArgs = []
            for arg in args:
                newArg = arg.split("=")[0]
                correctArgs.append(newArg)

            functionsDict[functionName]["args"] = correctArgs

            returnSplit = textSplit[i]
            returnSplit = returnSplit.replace('    ','\t')
            returnSplit = returnSplit.split('\n\treturn')[1]
            returnSplit = returnSplit.split("\n")[0]
            returnSplit = returnSplit.split(",")
            functionsDict[functionName]["return"] = returnSplit

    except:
        pass

    return functionsDict


class EditScriptWindow(qt.QWidget):
    SignalReloadFunctionsSpoiler = pyqtSignal()

    def __init__(self, xmlElement = None,allowImport=False):
        super(EditScriptWindow, self).__init__()
        self.xmlFunctionDescription = xmlElement
        self.allowImport = allowImport

        try:
            file = xmlet.parse(vrb.folderInformation + "/folderPythonScript.mho")
            self.folderPythonScriptElement = file.getroot()
        except:
            self.folderPythonScriptElement = xmlet.Element('folderPythonScript')
        #path = Dfct.childText(self.folderPythonScriptElement, "Path")

        self.textHasChanged = False

        self.buttonImport = wgt.PushButtonImage(vrb.folderImages + "/Edit_File.png", margins=2)
        self.buttonImport.setFixedSize(40 * vrb.ratio, 40 * vrb.ratio)

        # self.finderWidget = FinderWidget()

        self.textEditScript = TextEditor()
        # self.highlight = PythonHighlighter(self.textEditScript.document())
        # self.textEditScript.setReadOnly(False)

        self.groupParameters = GroupParameters(xmlElement=self.xmlFunctionDescription,scriptWindow=self)

        self.labelShow = wgt.LabelImage(vrb.folderImages + '/TriangleLeft.png')
        self.labelShow.setFixedSize(int(20 * vrb.ratio), int(20 * vrb.ratio))
        self.groupParametersHide = qt.QGroupBox(parent=self)
        # self.groupParametersHide = qt.QGroupBox()
        groupParametersHideLayout = qt.QGridLayout()
        groupParametersHideLayout.addWidget(self.labelShow, 0, 1,Qt.AlignRight | Qt.AlignTop)
        groupParametersHideLayout.setContentsMargins(0, 5, 5, 0)
        self.groupParametersHide.setLayout(groupParametersHideLayout)
        self.groupParametersHide.setVisible(False)

        # ###
        # font = QtGui.QFont()
        # # font.setFamily("Courier")
        # font.setStyleHint(QtGui.QFont.Monospace)
        # font.setFixedPitch(True)
        # font.setPointSize(10)
        # self.textEditScript.setFont(font)
        # metrics = QtGui.QFontMetrics(font)
        # self.textEditScript.setTabStopWidth(4*metrics.width(' '))
        # ###

        self.loadScriptText()
        self.groupParameters.createInterface()

        self.layout = qt.QGridLayout()
        #self.layout.addWidget(self.pushButtonSaveScript, 0, 0)
        if self.allowImport:
            self.layout.addWidget(self.buttonImport, 0, 0)
            # self.layout.addWidget(self.finderWidget, 0, 1,Qt.AlignRight | Qt.AlignBottom)
            self.layout.addWidget(self.textEditScript, 1, 0, 1 ,2)
            self.layout.addWidget(self.groupParameters, 0, 2,2,1)
        else:
            # self.layout.addWidget(self.finderWidget, 0, 0,Qt.AlignRight | Qt.AlignBottom)
            self.layout.addWidget(self.textEditScript, 1, 0)
            self.layout.addWidget(self.groupParameters, 0, 1,2 , 1)
            self.layout.addWidget(self.groupParametersHide, 0, 1,2 , 1)
        self.setLayout(self.layout)

        # self.textEditScript.textChanged.connect(self.textChanged)
        self.buttonImport.clicked.connect(self.importPythonFile)
        # self.finderWidget.SignalSearchWord.connect(self.textEditScript.searchWord)
        # self.textEditScript.SignalSearchWord.connect(self.searchWord)

        self.groupParameters.labelHide.mousePressEvent = self.hideRightPanel
        self.labelShow.mousePressEvent = self.showRightPanel

        self.setMinimumSize(684*vrb.ratio, 630*vrb.ratio)
        self.resize(1140*vrb.ratio, 1050*vrb.ratio)
        #self.setMinimumSize(600, 360)

        self.setWindowTitle("Macro")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.loadRightPanel()

    def resizeEvent(self, a0: QtGui.QResizeEvent):

        if self.rightPanelShown:
            if self.allowImport == False:
                self.textEditScript.setFixedSize(self.width()*53/100,max(1,self.height()*100/100-30))
            else:
                self.textEditScript.setFixedSize(self.width()*53/100,max(1,self.height()*100/100-90))
            self.groupParameters.setFixedSize(self.width()*45/100,max(1,self.height()*100/100-30))
        else:
            if self.allowImport == False:
                self.textEditScript.setFixedSize(self.width()- 50*vrb.ratio,max(1,self.height()*100/100-30))
            else:
                self.textEditScript.setFixedSize(self.width()- 50*vrb.ratio,max(1,self.height()*100/100-90))
            self.groupParameters.setFixedSize(30*vrb.ratio,max(1,self.height()*100/100-30))

    # def searchWord(self,word):
    #
    #     self.finderWidget.lineEditSearch.setText(word)
    #     self.finderWidget.lineEditSearch.setFocus()

    def loadRightPanel(self):

        if vrb.rightPanelMacroElement.text == "False":
            self.hideRightPanel(None)
        else:
            self.showRightPanel(None)

    def showRightPanel(self,event):

        self.groupParameters.setVisible(True)
        self.groupParametersHide.setVisible(False)
        self.rightPanelShown = True
        self.resizeEvent(None)

        vrb.rightPanelElement.text = "True"
        Dfct.saveXmlElement(vrb.rightPanelElement, vrb.folderInformation + "/RightPanelMacro.mho")

    def hideRightPanel(self,event):

        self.groupParameters.setVisible(False)
        self.groupParametersHide.setVisible(True)
        self.rightPanelShown = False
        self.resizeEvent(None)

        vrb.rightPanelElement.text = "False"
        Dfct.saveXmlElement(vrb.rightPanelElement, vrb.folderInformation + "/RightPanelMacro.mho")

    def importPythonFile(self):

        path = Dfct.childText(self.folderPythonScriptElement, "Path")
        if path is not None:
            defaultFolder = os.path.dirname(path)
        else:
            defaultFolder = "C:/Program Files/"
        filenameExe = qt.QFileDialog.getOpenFileName(self, "Select your python script", defaultFolder,"Script" + " (*.py *.pyw)")
        if filenameExe[0] != [] and filenameExe[0] != '' and filenameExe[0] != None:
            Dfct.SubElement(self.folderPythonScriptElement, "Path").text = filenameExe[0]
            Dfct.saveXmlElement(self.folderPythonScriptElement, vrb.folderInformation + "/folderPythonScript.mho")

            file = open(filenameExe[0], 'r')
            scriptText = file.read()

            self.textEditScript.setText(scriptText)
            self.groupParameters.actualizeInterface()
            self.textHasChanged = False

    def textChanged(self):
        self.textHasChanged = True

    def closeEvent(self, event: QtGui.QCloseEvent) -> None:

        if self.textHasChanged:
            messageBox = wgt.MessageBox('The script has been modified.', 'Do you still want to close the window?', icon=qt.QMessageBox.Warning)
            res = messageBox.exec()
            if res == qt.QMessageBox.Close:
                event.accept()
            else:
                event.ignore()
        else:
            event.accept()

    def loadScriptText(self):
        text = ''

        try:
            pythonPath = vrb.folderFunctions + '/' + Dfct.childText(self.xmlFunctionDescription, 'PythonName') + '.py'
            with open(pythonPath, 'r') as file:
                text = file.read()
        except Exception as e:
            print(e, file=sys.stderr)

        text = text.replace('    ','\t')

        self.textEditScript.setText(text)

class GroupParameters(qt.QGroupBox):
    SignalDoGenerateMacro = pyqtSignal(str)

    def __init__(self,xmlElement = None,scriptWindow=None):
        super(GroupParameters, self).__init__()

        self.xmlElement = xmlElement
        self.scriptWindow = scriptWindow

        self.labelTitle = qt.QLabel("Macro Editor")
        font = QtGui.QFont()
        font.setPixelSize(18*vrb.ratio)
        font.setBold(True)
        self.labelTitle.setFont(font)
        self.labelTitle.setStyleSheet("QLabel {; color : rgb(6, 115, 186); }")

        # self.emptyLabel = qt.QLabel()
        # self.emptyLabel.setFixedHeight(20*vrb.ratio)
        #
        # self.emptyLabel2 = qt.QLabel()
        # self.emptyLabel2.setFixedHeight(20*vrb.ratio)
        #
        # self.emptyLabel3 = qt.QLabel()
        # self.emptyLabel3.setFixedHeight(20*vrb.ratio)

        self.pushButtonEditMacro = wgt.PushButtonImage(vrb.folderImages + "/Add_Macro.png", margins=2)
        self.pushButtonEditMacro.setFixedSize(40 * vrb.ratio, 40 * vrb.ratio)
        self.pushButtonActualize = wgt.PushButtonImage(vrb.folderImages + "/Refresh.png", margins=2)
        self.pushButtonActualize.setFixedSize(40 * vrb.ratio, 40 * vrb.ratio)
        self.labelHide = wgt.LabelImage(vrb.folderImages + '/TriangleRight.png')
        self.labelHide.setFixedSize(int(20*vrb.ratio),int(20*vrb.ratio))

        font = QtGui.QFont()
        font.setPixelSize(11*vrb.ratio)

        self.labelModuleName = qt.QLabel("Module name")
        self.labelModuleName.setFixedSize(90*vrb.ratio,20*vrb.ratio)
        self.labelModuleName.setFont(font)
        self.labelModuleName.setStyleSheet("QLabel {; color : rgb(6, 115, 186); }")

        self.comboBoxModuleName = qt.QComboBox()
        for file in sorted(os.listdir(vrb.folderFunctions),key=str.casefold):
            self.comboBoxModuleName.addItem(file)
        self.comboBoxModuleName.setCurrentText("Macro")
        self.comboBoxModuleName.setFixedSize(140*vrb.ratio,20*vrb.ratio)
        # self.labeledComboBoxModuleName = wgt.LabeledWidget(self.comboBoxModuleName,title = "Module name")

        # self.comboBoxFunctionToCall = qt.QComboBox()
        # self.comboBoxFunctionToCall.setFixedSize(140*vrb.ratio,20*vrb.ratio)
        # self.labeledComboBoxFunctionToCall = wgt.LabeledWidget(self.comboBoxFunctionToCall,title = "Function name")

        self.labelExplorerName = qt.QLabel("Explorer name")
        self.labelExplorerName.setFixedSize(90*vrb.ratio,20*vrb.ratio)
        self.labelExplorerName.setFont(font)
        self.labelExplorerName.setStyleSheet("QLabel {; color : rgb(6, 115, 186); }")
        self.lineEditExplorerName = wgt.CustomLineEdit(mask=vrb.maskCharacters)
        self.lineEditExplorerName.setAlignment(Qt.AlignLeft)
        defaultName = "Macro_1"
        i=1
        while os.path.exists(vrb.folderFunctions+"/Macro/Macro_"+str(i)+".mho"):
            i+=1
            defaultName = "Macro_" + str(i)
        self.lineEditExplorerName.setPlaceholderText(defaultName)
        self.lineEditExplorerName.setFixedSize(140*vrb.ratio,20*vrb.ratio)
        # self.labeledLineEditExplorerName = wgt.LabeledWidget(self.lineEditExplorerName,title = "Explorer name")

        font = QtGui.QFont()
        font.setPixelSize(11*vrb.ratio)
        font.setBold(False)

        self.checkBoxFavorite = qt.QCheckBox("Favorite")
        self.checkBoxFavorite.setFixedWidth(140 * vrb.ratio)
        self.checkBoxFavorite.setChecked(True)
        self.checkBoxFavorite.setFont(font)

        self.checkBoxAdvanced = qt.QCheckBox("Advanced parameters")
        self.checkBoxAdvanced.setFixedWidth(140*vrb.ratio)
        self.checkBoxAdvanced.setFont(font)

        try:
            file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
            self.settingsElement = file.getroot()
        except:
            self.settingsElement = xmlet.Element('Settings')

        checkBoxAdvanced = Dfct.SubElement(self.settingsElement,"MacroAdvancedParams")
        if checkBoxAdvanced.text == "True":
            vrb.advancedParamMacro = True
        else:
            vrb.advancedParamMacro = False
        self.checkBoxAdvanced.setChecked(vrb.advancedParamMacro)

        self.labelInputs = qt.QLabel("Inputs")
        font = QtGui.QFont()
        font.setPixelSize(14*vrb.ratio)
        font.setBold(True)
        self.labelInputs.setFont(font)
        self.labelInputs.setStyleSheet("QLabel {; color : rgb(6, 115, 186); }")
        self.groupInputs = GroupInputs()

        self.labelOutputs = qt.QLabel("Outputs")
        self.labelOutputs.setFont(font)
        self.labelOutputs.setStyleSheet("QLabel {; color : rgb(6, 115, 186); }")
        self.groupOutputs = GroupOutputs()

        groupParameters = qt.QGroupBox()
        groupParameters.setStyleSheet("QGroupBox {border: 0px transparent; }")
        layoutParameters = qt.QGridLayout()
        layoutParameters.setAlignment(Qt.AlignLeft | Qt.AlignTop)
        layoutParameters.addWidget(self.checkBoxAdvanced)
        layoutParameters.addWidget(self.labelInputs,1,0)
        layoutParameters.addWidget(self.groupInputs,2,0)
        layoutParameters.addWidget(self.labelOutputs,3,0)
        layoutParameters.addWidget(self.groupOutputs,4,0)
        layoutParameters.setContentsMargins(20*vrb.ratio,10*vrb.ratio,20*vrb.ratio,10*vrb.ratio)
        layoutParameters.setVerticalSpacing(0)
        groupParameters.setLayout(layoutParameters)

        groupExamples = GroupBoxExamples()

        self.tabWidget = qt.QTabWidget()
        self.tabWidget.setStyleSheet('QTabWidget {border: 1px solid gray; }')

        self.tabWidget.addTab(groupParameters, 'Parameters')
        self.tabWidget.addTab(groupExamples, 'Examples')

        self.layout = qt.QGridLayout()
        self.layout.setAlignment(Qt.AlignLeft)

        self.layout.addWidget(self.labelTitle, 0, 0,1,2)
        self.layout.addWidget(self.pushButtonEditMacro, 0, 2)
        self.layout.addWidget(self.pushButtonActualize, 0, 3,Qt.AlignLeft)
        self.layout.addWidget(self.labelHide, 0, 4,Qt.AlignRight | Qt.AlignTop)
        # self.layout.addWidget(self.emptyLabel, 1, 0)
        self.layout.addWidget(self.labelModuleName, 1,0)
        self.layout.addWidget(self.comboBoxModuleName, 1,1, Qt.AlignLeft)
        # self.layout.addWidget(self.labeledComboBoxFunctionToCall, 2,0,Qt.AlignLeft)
        self.layout.addWidget(self.labelExplorerName, 2, 0)
        self.layout.addWidget(self.lineEditExplorerName, 2, 1,Qt.AlignLeft)
        self.layout.addWidget(self.checkBoxFavorite, 3, 0,Qt.AlignLeft)

        self.layout.addWidget(self.tabWidget, 4, 0,1,2,Qt.AlignLeft | Qt.AlignTop)

        # self.layout.addWidget(self.checkBoxAdvanced, 6, 0,Qt.AlignLeft)
        #
        # self.layout.addWidget(self.emptyLabel2,7,0)
        #
        # self.layout.addWidget(self.labelInputs,8,0)
        # self.layout.addWidget(self.groupInputs,9,0)
        #
        # self.layout.addWidget(self.emptyLabel3,10,0)
        #
        # self.layout.addWidget(self.labelOutputs,11,0)
        # self.layout.addWidget(self.groupOutputs,12,0)

        self.layout.setVerticalSpacing(10*vrb.ratio)

        self.setLayout(self.layout)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.pushButtonActualize.clicked.connect(self.actualizeInterface)
        # self.comboBoxFunctionToCall.currentIndexChanged.connect(self.applyFunctionParameters)
        self.checkBoxAdvanced.stateChanged.connect(self.changeVisibleWidgets)
        self.pushButtonEditMacro.clicked.connect(self.editMacro)

        self.changeVisibleWidgets()

    def resizeEvent(self, a0: QtGui.QResizeEvent):

        sizeTableWidget = max(1,(self.height()-150*vrb.ratio))
        sizeTableWidget = min(sizeTableWidget,670*vrb.ratio)

        self.tabWidget.setFixedSize(self.width()*98/100,sizeTableWidget)
        self.groupInputs.setFixedSize((self.width()-30*vrb.ratio)*98/100,(sizeTableWidget-115*vrb.ratio)*60/100)
        self.groupOutputs.setFixedSize((self.width()-30*vrb.ratio)*98/100,(sizeTableWidget-115*vrb.ratio)*40/100)

    def editMacro(self):

        try:
            stop = False
            self.actualizeInterface()
            name = Dfct.childText(self.xmlElement, "PythonName")

            pythonNameSplit = name.split("/")
            moduleName = pythonNameSplit[0]

            if os.path.exists(vrb.folderFunctions + "/" + name + ".mho"):
                file = xmlet.parse(vrb.folderFunctions + "/" + name + ".mho")
                element = file.getroot()
                if Dfct.childText(element, "FunctionName") != "MacroFunction":
                    messageBox = wgt.MessageBox("The name "+name+" is already used in IPSDK\nPlease select an other name for the macro", '', buttons=[qt.QMessageBox.Ok],
                                                icon=qt.QMessageBox.Warning, windowTitle="Error")
                    messageBox.exec()
                    stop = True

            if stop == False:

                name = vrb.folderFunctions + "/" + name
                try:
                    with open(name + '.py', 'r') as file:
                        textBefore = file.read()
                except:
                    textBefore = ""

                with open(name + '.py', 'w+') as file:
                    # textToSave = self.scriptWindow.textEditScript.toPlainText()
                    textToSave = self.scriptWindow.textEditScript.getText()
                    textToSave = textToSave.replace("    ","\t")
                    try:
                        if textToSave.endswith("\n"):
                            file.write(textToSave)
                        else:
                            file.write(textToSave + '\n')
                    except Exception as e:
                        traceback.print_exc(file=sys.stderr)
                        messageBox = wgt.MessageBox("Error during saving\n"+str(e), '', buttons=[qt.QMessageBox.Ok],
                                                    icon=qt.QMessageBox.Warning, windowTitle="Error")
                        messageBox.exec()
                        file.write(textBefore)

                        stop = True

                if stop == False:

                    Dfct.saveXmlElement(self.xmlElement, name+".mho")

                    vrb.mainWindow.reloadAllFunctionsSpoilers(moduleName)
                    self.scriptWindow.textHasChanged = False
                    # self.scriptWindow.close()

                    nameMacro = Dfct.childText(self.xmlElement, "Name")

                    for i in range(vrb.mainWindow.categorySpoilersContainer.layout.count() + 1):
                        item = vrb.mainWindow.categorySpoilersContainer.layout.itemAt(i)
                        if item is not None:
                            spoilerCategory = item.widget()
                            if spoilerCategory.isVisible():
                                nameFunction = fct.invertDictName(dictFolderNames, spoilerCategory.title)
                                if nameFunction is None:
                                    nameFunction = spoilerCategory.title
                                if nameFunction == moduleName:
                                    spoilerCategory.emitSignalSetSpoilerExpand(None)
                                    for j in range(spoilerCategory.widget.layout.count() + 1):
                                        itemChild = spoilerCategory.widget.layout.itemAt(j)
                                        if itemChild is not None:
                                            sploiler = itemChild.widget()
                                            if sploiler.title == nameMacro:
                                                sploiler.widget.initFunction()
                                                sploiler.widget.editScriptWindow = self.scriptWindow
                                                sploiler.emitSignalSetSpoilerExpand(None)
        except:
            traceback.print_exc(file=sys.stderr)

    def changeVisibleWidgets(self):

        checkBoxAdvanced = Dfct.SubElement(self.settingsElement, "MacroAdvancedParams")
        if self.checkBoxAdvanced.isChecked():
            checkBoxAdvanced.text = "True"
        else:
            checkBoxAdvanced.text = "False"

        Dfct.saveXmlElement(self.settingsElement, vrb.folderInformation + "/Settings.mho")
        vrb.advancedParamMacro = self.checkBoxAdvanced.isChecked()

        for num in range(self.groupInputs.layout.count()):
            item = self.groupInputs.layout.itemAt(num)
            if item is not None:
                paramWidget = item.widget()
                paramWidget.changeType()

        self.groupInputs.actualizeSize()

        for num in range(self.groupOutputs.layout.count()):
            item = self.groupOutputs.layout.itemAt(num)
            if item is not None:
                paramWidget = item.widget()
                paramWidget.changeType()

        self.groupOutputs.actualizeSize()

    def actualizeInterface(self):

        self.createXmlElement()
        self.createInterface()

    def createInterface(self):

        # text = self.scriptWindow.textEditScript.toPlainText()
        # text = self.scriptWindow.textEditScript.getText()

        try:
            pythonName = Dfct.childText(self.xmlElement,"PythonName")
            pythonNameSplit = pythonName.split("/")
            self.comboBoxModuleName.setCurrentText(pythonNameSplit[0])
        except:
            pass

        name = Dfct.childText(self.xmlElement, "Name")
        if name is not None and name != "":
            self.lineEditExplorerName.setPlaceholderText(name)

        self.applyFunctionParameters()

        self.loadXmlElements()

    def createXmlElement(self):

        xmlElement = xmlet.Element('Function')

        name = self.lineEditExplorerName.text()
        if name == "":
            name = self.lineEditExplorerName.placeholderText()


        Dfct.SubElement(xmlElement,"Name").text = name
        Dfct.SubElement(xmlElement,"FunctionName").text = "MacroFunction"
        Dfct.SubElement(xmlElement,"PythonName").text = self.comboBoxModuleName.currentText() + "/" + name
        text = self.scriptWindow.textEditScript.getText()
        dictFunctions = findFunctionsAndArguments(text)
        try:
            firstKey = next(iter(dictFunctions))
        except:
            firstKey = ""
        Dfct.SubElement(xmlElement, "ProcessName").text = firstKey

        if self.checkBoxFavorite.isChecked():
            Dfct.SubElement(xmlElement, 'Favorite').text = "True"
        else:
            Dfct.SubElement(xmlElement, 'Favorite').text = "False"

        parameterNum = 0
        parametersElement = Dfct.SubElement(xmlElement,"Parameters")
        for num in range(self.groupInputs.layout.count()):
            item = self.groupInputs.layout.itemAt(num)
            if item is not None:
                paramWidget = item.widget()
                parameterElement = Dfct.SubElement(parametersElement,"Parameter_"+str(parameterNum))
                paramWidget.createXmlElement(parameterElement)
                parameterNum += 1

        outputNum = 0
        outputsElement = Dfct.SubElement(xmlElement,"Outputs")
        for num in range(self.groupOutputs.layout.count()):
            item = self.groupOutputs.layout.itemAt(num)
            if item is not None:
                outputWidget = item.widget()
                outputElement = Dfct.SubElement(outputsElement,"Output_"+str(outputNum))
                outputWidget.createXmlElement(outputElement)
                outputNum += 1

        self.xmlElement = xmlElement

    def applyFunctionParameters(self):

        try:
            fct.clearLayout(self.groupInputs.layout)
            fct.clearLayout(self.groupOutputs.layout)

            text = self.scriptWindow.textEditScript.getText()
            dictFunctions = findFunctionsAndArguments(text)
            try:
                firstKey = next(iter(dictFunctions))
            except:
                firstKey = ""

            if firstKey != "":
                parameters = dictFunctions[firstKey]
            else:
                parameters = {'args':[], 'return':[]}

            print("parameters : ", parameters)

            # parameters = self.comboBoxFunctionToCall.currentData()
            for param in parameters["args"]:
                self.groupInputs.addParam(name = param)
            for param in parameters["return"]:
                self.groupOutputs.addParam(name = param)
        except:
            traceback.print_exc(file=sys.stderr)

    def loadXmlElements(self):

        if self.xmlElement is not None:
            noAssociatedWidget = []

            parametersElement = Dfct.SubElement(self.xmlElement,"Parameters")
            for i in range(len(parametersElement)):
                paramElement = Dfct.SubElement(parametersElement,"Parameter_"+str(i))
                loaded =False
                for num in range(self.groupInputs.layout.count()):
                    item = self.groupInputs.layout.itemAt(num)
                    if item is not None:
                        paramWidget = item.widget()
                        if paramWidget.name == Dfct.childText(paramElement,"PythonName"):
                            paramWidget.loadXmlElement(paramElement)
                            loaded = True
                if loaded == False:
                    noAssociatedWidget.append(paramElement)

            currentWidgetNum = 0
            for num in range(self.groupInputs.layout.count()):
                item = self.groupInputs.layout.itemAt(num)
                if item is not None:
                    paramWidget = item.widget()
                    if paramWidget.loaded == False:
                        try:
                            paramWidget.loadXmlElement(noAssociatedWidget[currentWidgetNum])
                            currentWidgetNum += 1
                        except:
                            pass

            noAssociatedWidget = []

            outputsElement = Dfct.SubElement(self.xmlElement,"Outputs")
            for i in range(len(outputsElement)):
                outputElement = Dfct.SubElement(outputsElement,"Output_"+str(i))
                loaded =False
                for num in range(self.groupOutputs.layout.count()):
                    item = self.groupOutputs.layout.itemAt(num)
                    if item is not None:
                        paramWidget = item.widget()
                        if paramWidget.name == Dfct.childText(outputElement,"PythonName"):
                            paramWidget.loadXmlElement(outputElement)
                            loaded = True
                if loaded == False:
                    noAssociatedWidget.append(outputElement)

            currentWidgetNum = 0
            for num in range(self.groupOutputs.layout.count()):
                item = self.groupOutputs.layout.itemAt(num)
                if item is not None:
                    paramWidget = item.widget()
                    if paramWidget.loaded == False:
                        try:
                            paramWidget.loadXmlElement(noAssociatedWidget[currentWidgetNum])
                            currentWidgetNum += 1
                        except:
                            pass

class GroupInputs(qt.QScrollArea):
    SignalDoGenerateMacro = pyqtSignal(str)

    def __init__(self):
        qt.QScrollArea.__init__(self)

        self.centralWidget = qt.QGroupBox()

        self.layout = qt.QHBoxLayout()
        self.layout.setAlignment(Qt.AlignTop)

        self.setWidget(self.centralWidget)

        self.layout.setContentsMargins(5*vrb.ratio,0,5*vrb.ratio,0)

        self.setStyleSheet('QScrollArea {border: 1px solid gray; }')

    def addParam(self,name="None"):

        param = BasicParam(name=name)
        self.layout.addWidget(param)

        self.centralWidget = qt.QWidget()
        self.centralWidget.setLayout(self.layout)
        self.setWidget(self.centralWidget)

    def actualizeSize(self):

        self.centralWidget = qt.QWidget()
        self.centralWidget.setLayout(self.layout)
        self.setWidget(self.centralWidget)

class GroupOutputs(qt.QScrollArea):
    SignalDoGenerateMacro = pyqtSignal(str)

    def __init__(self):
        qt.QScrollArea.__init__(self)

        self.centralWidget = qt.QGroupBox()

        self.layout = qt.QHBoxLayout()
        self.layout.setAlignment(Qt.AlignTop)

        self.setWidget(self.centralWidget)

        self.layout.setContentsMargins(5,5,5,5)

        self.setStyleSheet('QScrollArea {border: 1px solid gray; }')

    def addParam(self,name="None"):

        param = OutputParam(name=name)
        self.layout.addWidget(param)

        self.centralWidget = qt.QWidget()
        self.centralWidget.setLayout(self.layout)
        self.setWidget(self.centralWidget)

    def actualizeSize(self):

        self.centralWidget = qt.QWidget()
        self.centralWidget.setLayout(self.layout)
        self.setWidget(self.centralWidget)


class BasicParam(qt.QGroupBox):

    def __init__(self,name = "None"):
        super(BasicParam, self).__init__()

        self.loaded = False

        self.name = name
        self.labelName = qt.QLabel(self.name)
        self.labelName.setStyleSheet("QLabel {; color : #cbe6be; }")
        font = QtGui.QFont()
        font.setPixelSize(12*vrb.ratio)
        font.setBold(True)
        self.labelName.setMinimumHeight(20*vrb.ratio)
        self.labelName.setFont(font)

        self.checkBoxOptional =qt.QCheckBox("Optional")
        self.checkBoxOptional.setChecked(False)
        self.checkBoxOptional.setMinimumSize(70*vrb.ratio,20*vrb.ratio)
        font = QtGui.QFont()
        font.setPixelSize(10*vrb.ratio)
        font.setBold(False)
        self.checkBoxOptional.setFont(font)

        self.comboBoxType = qt.QComboBox()
        self.comboBoxType.setMinimumSize(80*vrb.ratio,20*vrb.ratio)
        self.comboBoxType.addItem("Image")
        self.comboBoxType.addItem("Scalar")
        self.comboBoxType.addItem("Model")
        self.comboBoxType.addItem("Enumerate")
        self.comboBoxType.addItem("Boolean")
        self.comboBoxType.addItem("String")
        self.comboBoxType.addItem("Folder/File")
        self.comboBoxType.addItem("Histogram")
        self.comboBoxType.addItem("Measure")
        self.labeledComboBoxType = wgt.LabeledWidget(self.comboBoxType,title = "Type")

        self.comboBoxImageSize = qt.QComboBox()
        self.comboBoxImageSize.setMinimumSize(80*vrb.ratio,20*vrb.ratio)
        self.comboBoxImageSize.addItem("Any")
        self.comboBoxImageSize.addItem("2D")
        self.comboBoxImageSize.addItem("3D")
        self.comboBoxImageSize.addItem("Seq")
        self.comboBoxImageSize.addItem("3D_Or_Seq")
        self.labeledComboBoxImageSize = wgt.LabeledWidget(self.comboBoxImageSize,title = "Dimension")
        self.labeledComboBoxImageSize.type = "Image"

        self.comboBoxImageBuffer = qt.QComboBox()
        self.comboBoxImageBuffer.setMinimumSize(80*vrb.ratio,20*vrb.ratio)
        self.comboBoxImageBuffer.addItem("Any")
        self.comboBoxImageBuffer.addItem("Binary")
        self.comboBoxImageBuffer.addItem("Label")
        self.comboBoxImageBuffer.addItem("Binary/Label")
        self.comboBoxImageBuffer.addItem("Real")
        self.labeledComboBoxImageBuffer = wgt.LabeledWidget(self.comboBoxImageBuffer,title = "Buffer")
        self.labeledComboBoxImageBuffer.type = "Image"

        self.comboBoxImageColor = qt.QComboBox()
        self.comboBoxImageColor.setMinimumSize(80*vrb.ratio,20*vrb.ratio)
        self.comboBoxImageColor.addItem("Any")
        self.comboBoxImageColor.addItem("Grey")
        self.comboBoxImageColor.addItem("Color")
        self.labeledComboBoxImageColor = wgt.LabeledWidget(self.comboBoxImageColor,title = "Color")
        self.labeledComboBoxImageColor.type = "Image"

        self.comboBoxScalarType = qt.QComboBox()
        self.comboBoxScalarType.setMinimumSize(80*vrb.ratio,20*vrb.ratio)
        self.comboBoxScalarType.addItem("Any")
        self.comboBoxScalarType.addItem("Natural")
        self.comboBoxScalarType.addItem("Relative")
        self.labeledComboBoxScalarType = wgt.LabeledWidget(self.comboBoxScalarType,title = "Scalar type")
        self.labeledComboBoxScalarType.type = "Scalar"

        self.lineEditDefaultScalar = qt.QLineEdit()
        self.lineEditDefaultScalar.setMinimumHeight(20*vrb.ratio)
        self.labeledLineEditDefaultScalar = wgt.LabeledWidget(self.lineEditDefaultScalar,title = "Default value")
        self.labeledLineEditDefaultScalar.type = "Scalar"

        self.comboBoxModelType = qt.QComboBox()
        self.comboBoxModelType.setMinimumSize(80*vrb.ratio,20*vrb.ratio)
        self.comboBoxModelType.addItem("Smart segmentation")
        self.comboBoxModelType.addItem("Smart classfication")
        self.comboBoxModelType.addItem("Smart super pixels")
        self.labeledComboBoxModelType = wgt.LabeledWidget(self.comboBoxModelType,title = "Model type")
        self.labeledComboBoxModelType.type = "Model"

        self.lineEditDefaultModel = qt.QLineEdit()
        self.lineEditDefaultModel.setMinimumHeight(20*vrb.ratio)
        self.labeledLineEditDefaultModel = wgt.LabeledWidget(self.lineEditDefaultModel,title = "Default value")
        self.labeledLineEditDefaultModel.type = "Model"

        self.lineEditEnumValue = qt.QLineEdit()
        self.lineEditEnumValue.setPlaceholderText("Enum1,Enum2,Enum3")
        self.lineEditEnumValue.setMinimumHeight(20*vrb.ratio)
        self.labeledLineEditEnumValue = wgt.LabeledWidget(self.lineEditEnumValue,title = "Value")
        self.labeledLineEditEnumValue.type = "Enumerate"

        self.lineEditDefaultEnum = qt.QLineEdit()
        self.lineEditDefaultEnum.setPlaceholderText("Enum1")
        self.lineEditDefaultEnum.setMinimumHeight(20*vrb.ratio)
        self.labeledLineEditDefaultEnum = wgt.LabeledWidget(self.lineEditDefaultEnum,title = "Default value")
        self.labeledLineEditDefaultEnum.type = "Enumerate"

        self.comboBoxDefaultBoolean = qt.QComboBox()
        self.comboBoxDefaultBoolean.addItem("True")
        self.comboBoxDefaultBoolean.addItem("False")
        self.comboBoxDefaultBoolean.setMinimumHeight(20*vrb.ratio)
        self.labeledComboBoxDefaultBoolean = wgt.LabeledWidget(self.comboBoxDefaultBoolean,title = "Default value")
        self.labeledComboBoxDefaultBoolean.type = "Boolean"

        self.lineEditDefaultString = qt.QLineEdit()
        self.lineEditDefaultString.setMinimumHeight(20*vrb.ratio)
        self.labeledLineEditDefaultString = wgt.LabeledWidget(self.lineEditDefaultString,title = "Default value")
        self.labeledLineEditDefaultString.type = "String"

        self.comboBoxFolderType = qt.QComboBox()
        self.comboBoxFolderType.setMinimumSize(80*vrb.ratio,20*vrb.ratio)
        self.comboBoxFolderType.addItem("Folder")
        self.comboBoxFolderType.addItem("File")
        self.labeledComboBoxFolderType = wgt.LabeledWidget(self.comboBoxFolderType,title = "Type")
        self.labeledComboBoxFolderType.type = "Folder/File"

        self.lineEditName = wgt.CustomLineEdit(mask=vrb.maskCharacters)
        self.lineEditName.setAlignment(Qt.AlignLeft)
        self.lineEditName.setMinimumHeight(20*vrb.ratio)
        self.lineEditName.setPlaceholderText(self.name)

        self.labeledLineEditName = wgt.LabeledWidget(self.lineEditName,title = "Name")

        self.allWidgets = [self.labeledComboBoxImageSize,self.labeledComboBoxImageBuffer,self.labeledComboBoxImageColor,
                           self.labeledComboBoxScalarType,self.labeledLineEditDefaultScalar,self.labeledComboBoxModelType,
                           self.labeledLineEditDefaultModel,self.labeledLineEditEnumValue,self.labeledLineEditDefaultEnum,
                           self.labeledComboBoxDefaultBoolean,self.labeledLineEditDefaultString,self.labeledComboBoxFolderType]

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.labelName, 0,0,Qt.AlignCenter)

        self.layout.addWidget(self.checkBoxOptional, 1,0,Qt.AlignLeft)
        self.layout.addWidget(self.labeledComboBoxType, 2,0)
        self.layout.addWidget(self.labeledLineEditName, 3,0,)

        self.layout.addWidget(self.labeledComboBoxImageSize, 4,0)
        self.layout.addWidget(self.labeledComboBoxImageBuffer, 5,0)
        self.layout.addWidget(self.labeledComboBoxImageColor, 6,0)

        self.layout.addWidget(self.labeledComboBoxScalarType, 4,0)
        self.layout.addWidget(self.labeledLineEditDefaultScalar, 5,0)

        self.layout.addWidget(self.labeledComboBoxModelType, 4,0)
        self.layout.addWidget(self.labeledLineEditDefaultModel, 5, 0)

        self.layout.addWidget(self.labeledLineEditEnumValue, 4, 0)
        self.layout.addWidget(self.labeledLineEditDefaultEnum, 5, 0)

        self.layout.addWidget(self.labeledComboBoxDefaultBoolean, 4,0)

        self.layout.addWidget(self.labeledLineEditDefaultString, 4, 0)

        self.layout.addWidget(self.labeledComboBoxFolderType, 4, 0)

        self.setLayout(self.layout)
        self.layout.setAlignment(Qt.AlignTop)

        self.comboBoxType.currentIndexChanged.connect(self.changeType)

        self.changeType()

    def changeType(self):

        for widget in self.allWidgets:
            widget.setVisible(widget.type==self.comboBoxType.currentText() and vrb.advancedParamMacro)
        # self.labelOptional.setVisible(vrb.advancedParamMacro)
        self.checkBoxOptional.setVisible(vrb.advancedParamMacro)

    def loadXmlElement(self,element):

        self.loaded = True

        name = Dfct.childText(element,"Name")
        if name is not None:
            self.lineEditName.setText(name)
        constraints = Dfct.childText(element, "Constraints")
        type = Dfct.childText(element,"Type")
        mandatory = Dfct.childText(element,"Mandatory")
        self.checkBoxOptional.setChecked(mandatory == "False")
        if type == "Enumerate" and constraints in [MachineLearningConstraint.SMART_SEGMENTATION.value,MachineLearningConstraint.SMART_CLASSIFICATION.value, MachineLearningConstraint.SMART_SUPER_PIXELS.value]:
            self.comboBoxType.setCurrentText("Model")
            if constraints == [MachineLearningConstraint.SMART_SEGMENTATION.value]:
                self.comboBoxModelType.setCurrentIndex(0)
            elif constraints == [MachineLearningConstraint.SMART_CLASSIFICATION.value]:
                self.comboBoxModelType.setCurrentIndex(1)
            elif constraints == [MachineLearningConstraint.SMART_SUPER_PIXELS.value]:
                self.comboBoxModelType.setCurrentIndex(2)
            defaultValue = Dfct.childText(element, "Default")
            if defaultValue is not None:
                self.lineEditDefaultModel.setText(defaultValue)
        else:
            if type is not None:
                if type == "Folder_File":
                    self.comboBoxType.setCurrentText("Folder/File")
                else:
                    self.comboBoxType.setCurrentText(type)
            if type == "Image":
                if constraints is not None:
                    constraints = constraints.split(",")
                    for constraint in constraints:
                        if constraint == ImageConstraint.TWO_DIMENSIONS.value:
                            self.comboBoxImageSize.setCurrentText("2D")
                        elif constraint == ImageConstraint.THREE_DIMENSIONS.value:
                            self.comboBoxImageSize.setCurrentText("3D")
                        elif constraint == ImageConstraint.SEQUENCE.value:
                            self.comboBoxImageSize.setCurrentText("Seq")
                        elif constraint == ImageConstraint.THREE_DIMENSIONS_OR_SEQUENCE.value:
                            self.comboBoxImageSize.setCurrentText("3D_Or_Seq")
                        elif constraint == ImageConstraint.BUFFER_TYPE_BINARY.value:
                            self.comboBoxImageBuffer.setCurrentText("Binary")
                        elif constraint == ImageConstraint.BUFFER_TYPE_LABEL.value:
                            self.comboBoxImageBuffer.setCurrentText("Label")
                        elif constraint == ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL.value:
                            self.comboBoxImageBuffer.setCurrentText("Binary/Label")
                        elif constraint == ImageConstraint.BUFFER_TYPE_REAL.value:
                            self.comboBoxImageBuffer.setCurrentText("Real")
                        elif constraint == ImageConstraint.COLOR.value:
                            self.comboBoxImageColor.setCurrentText("Color")
                        elif constraint == ImageConstraint.GREY.value:
                            self.comboBoxImageColor.setCurrentText("Grey")
            elif type == "Scalar":
                if constraints == ScalarConstraint.NATURAL.value:
                    self.comboBoxScalarType.setCurrentText("Natural")
                elif constraints == ScalarConstraint.RELATIVE.value:
                    self.comboBoxScalarType.setCurrentText("Relative")
                defaultValue = Dfct.childText(element,"Default")
                if defaultValue is not None:
                    self.lineEditDefaultScalar.setText(defaultValue)
            # elif type == "Model":

            elif type == "Enumerate":
                value = Dfct.childText(element,"List")
                self.lineEditEnumValue.setText(value)
                valueSplit = value.split(",")
                valueDefault = Dfct.childText(element,"Default")
                try:
                    default = valueSplit[int(valueDefault)]
                except:
                    default = valueSplit[0]
                self.lineEditDefaultEnum.setText(default)
            elif type == "Boolean":
                default = Dfct.childText(element,"Default")
                if default == "False":
                    self.comboBoxDefaultBoolean.setCurrentText("False")
            elif type == "Folder_File":
                if constraints == ["Folder"]:
                    self.comboBoxFolderType.setCurrentText("Folder")
                elif constraints == ["File"]:
                    self.comboBoxFolderType.setCurrentText("File")
            elif type == "String":
                defaultValue = Dfct.childText(element, "Default")
                if defaultValue is not None:
                    self.lineEditDefaultString.setText(defaultValue)

    def createXmlElement(self,element):

        Dfct.SubElement(element, "PythonName").text = self.name
        name = self.lineEditName.text()
        if name is None or name == "":
            name = self.lineEditName.placeholderText()
        Dfct.SubElement(element, "Name").text = name
        if self.comboBoxType.currentText() == "Model":
            Dfct.SubElement(element, "Type").text = "Enumerate"
            Dfct.SubElement(element, "List").text = "_"
            if self.comboBoxModelType.currentIndex()==0:
                Dfct.SubElement(element, "Constraints").text = "Smart_Segmentation"
            elif self.comboBoxModelType.currentIndex()==1:
                Dfct.SubElement(element, "Constraints").text = "Smart_Classification"
            elif self.comboBoxModelType.currentIndex()==2:
                Dfct.SubElement(element, "Constraints").text = "Smart_Super_Pixels"
            Dfct.SubElement(element, "Default").text = self.lineEditDefaultModel.text()
        else:
            if self.comboBoxType.currentText() == "Folder/File":
                Dfct.SubElement(element, "Type").text = "Folder_File"
            else:
                Dfct.SubElement(element, "Type").text = self.comboBoxType.currentText()
            if self.comboBoxType.currentText() == "Image":
                constraintText = ""
                if self.comboBoxImageSize.currentText() == "2D":
                    constraintText+="2D,"
                if self.comboBoxImageSize.currentText() == "3D":
                    constraintText+="3D,"
                if self.comboBoxImageSize.currentText() == "Seq":
                    constraintText+="Seq,"
                if self.comboBoxImageSize.currentText() == "3D_Or_Seq":
                    constraintText+="3D_Or_Seq,"
                if self.comboBoxImageBuffer.currentText() == "Binary":
                    constraintText+=ImageConstraint.BUFFER_TYPE_BINARY.value+","
                if self.comboBoxImageBuffer.currentText() == "Label":
                    constraintText+=ImageConstraint.BUFFER_TYPE_LABEL.value+","
                if self.comboBoxImageBuffer.currentText() == "Binary/Label":
                    constraintText+=ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL.value+","
                if self.comboBoxImageBuffer.currentText() == "Real":
                    constraintText+=ImageConstraint.BUFFER_TYPE_REAL.value+","
                if self.comboBoxImageColor.currentText() == "Color":
                    constraintText+="Color,"
                if self.comboBoxImageColor.currentText() == "Grey":
                    constraintText+="Grey,"
                if constraintText != "":
                    constraintText = constraintText[:-1]
                Dfct.SubElement(element, "Constraints").text = constraintText
            elif self.comboBoxType.currentText() == "Scalar":
                Dfct.SubElement(element, "Constraints").text = self.comboBoxScalarType.currentText()
                Dfct.SubElement(element, "Default").text = self.lineEditDefaultScalar.text()
            elif self.comboBoxType.currentText() == "Enumerate":
                Dfct.SubElement(element, "List").text = self.lineEditEnumValue.text()
                defaultValue = self.lineEditDefaultEnum.text()
                valueSplit = self.lineEditEnumValue.text().split(",")
                default = str(0)
                for i in range(len(valueSplit)):
                    if defaultValue == valueSplit[i]:
                        default = str(i)
                Dfct.SubElement(element, "Default").text = default
            elif self.comboBoxType.currentText() == "Boolean":
                Dfct.SubElement(element, "Default").text = self.comboBoxDefaultBoolean.currentText()
            elif self.comboBoxType.currentText() == "Folder/File":
                Dfct.SubElement(element, "Constraints").text = self.comboBoxFolderType.currentText()
            elif self.comboBoxType.currentText() == "String":
                Dfct.SubElement(element, "Default").text = self.lineEditDefaultString.text()
        if self.checkBoxOptional.isChecked():
            Dfct.SubElement(element, "Mandatory").text = "False"
        else:
            Dfct.SubElement(element, "Mandatory").text = "True"

class OutputParam(qt.QGroupBox):

    def __init__(self,name = "None"):
        super(OutputParam, self).__init__()

        self.loaded = False

        self.name = name
        self.labelName = qt.QLabel(self.name)
        self.labelName.setStyleSheet("QLabel {; color : #cbe6be; }")
        font = QtGui.QFont()
        font.setPixelSize(12*vrb.ratio)
        font.setBold(True)
        self.labelName.setMinimumHeight(20*vrb.ratio)
        self.labelName.setFont(font)

        self.comboBoxType = qt.QComboBox()
        self.comboBoxType.setMinimumSize(80*vrb.ratio, 20*vrb.ratio)
        self.comboBoxType.addItem("Image")
        self.comboBoxType.addItem("Measure")
        self.comboBoxType.addItem("Histogram")
        self.comboBoxType.addItem("HistogramMeasure")
        self.comboBoxType.addItem("Shape analysis")
        self.comboBoxType.addItem("Statistics")
        self.comboBoxType.addItem("Feature")
        self.labeledComboBoxType = wgt.LabeledWidget(self.comboBoxType,title = "Type")

        self.lineEditName = wgt.CustomLineEdit(mask=vrb.maskCharacters)
        self.lineEditName.setAlignment(Qt.AlignLeft)
        self.lineEditName.setMinimumHeight(20*vrb.ratio)
        self.lineEditName.setPlaceholderText(self.name)
        self.labeledLineEditName = wgt.LabeledWidget(self.lineEditName,title = "Name")

        self.lineEditDefaultName = wgt.CustomLineEdit(mask=vrb.maskCharacters)
        self.lineEditDefaultName.setAlignment(Qt.AlignLeft)
        self.lineEditDefaultName.setMinimumHeight(20*vrb.ratio)
        self.labeledLineEditDefaultName = wgt.LabeledWidget(self.lineEditDefaultName,title = "Default name")

        self.allWidgets = [self.labeledLineEditDefaultName]

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.labelName, 0, 0, Qt.AlignCenter)
        self.layout.addWidget(self.labeledComboBoxType, 1, 0)
        self.layout.addWidget(self.labeledLineEditName, 2, 0)
        self.layout.addWidget(self.labeledLineEditDefaultName, 3, 0)

        self.setLayout(self.layout)
        self.layout.setAlignment(Qt.AlignTop)

        self.changeType()

    def changeType(self):

        for widget in self.allWidgets:
            widget.setVisible(vrb.advancedParamMacro)

    def loadXmlElement(self,element):

        self.loaded = True

        name = Dfct.childText(element,"Name")
        if name is not None:
            self.lineEditName.setText(name)
        type = Dfct.childText(element,"Type")
        if type is not None:
            if type == "ShapeAnalysis":
                self.comboBoxType.setCurrentText("Shape analysis")
            else:
                self.comboBoxType.setCurrentText(type)
        default = Dfct.childText(element,"Default")
        if default is not None:
            self.lineEditDefaultName.setText(default)

    def createXmlElement(self,element):

        Dfct.SubElement(element, "PythonName").text = self.name
        name = self.lineEditName.text()
        if name is None or name == "":
            name = self.lineEditName.placeholderText()
        Dfct.SubElement(element, "Name").text = name
        if self.comboBoxType.currentText() == "Shape analysis":
            Dfct.SubElement(element, "Type").text = "ShapeAnalysis"
        else:
            Dfct.SubElement(element, "Type").text = self.comboBoxType.currentText()
        Dfct.SubElement(element, "Default").text = self.lineEditDefaultName.text()

# class FinderWidget(qt.QGroupBox):
#
#     SignalSearchWord = pyqtSignal(str,bool)
#
#     def __init__(self):
#         super(FinderWidget, self).__init__()
#
#         self.labelSearch = wgt.LabelImage(vrb.folderImages + '/Search.png')
#         # self.labelName.setStyleSheet("QLabel {; color : #cbe6be; }")
#         self.labelSearch.setFixedSize(20*vrb.ratio,20*vrb.ratio)
#
#         self.lineEditSearch = LineEditSearch()
#         self.lineEditSearch.setFixedSize(220*vrb.ratio,20*vrb.ratio)
#
#         self.layout = qt.QGridLayout()
#
#         self.layout.addWidget(self.labelSearch, 0, 0)
#         self.layout.addWidget(self.lineEditSearch, 0, 1)
#
#         self.layout.setSizeConstraint(1)
#         self.layout.setContentsMargins(0, 0, 0, 0)
#
#         self.setLayout(self.layout)
#         self.layout.setAlignment(Qt.AlignTop)
#
#         self.labelSearch.mousePressEvent = self.search
#         self.lineEditSearch.returnPressed.connect(self.search)
#         self.lineEditSearch.SignalSearchDown.connect(self.searchDown)
#
#     def search(self,_=None):
#
#         text = self.lineEditSearch.text()
#         if text is not None and text != "":
#             self.SignalSearchWord.emit(text,True)
#
#     def searchDown(self,down):
#
#         text = self.lineEditSearch.text()
#         if text is not None and text != "":
#             self.SignalSearchWord.emit(text,down)

class LineEditSearch(qt.QLineEdit):

    SignalSearchDown = pyqtSignal(bool)

    def __init__(self):
        super(qt.QLineEdit, self).__init__()

    def keyPressEvent(self, a0: QtGui.QKeyEvent):

        qt.QLineEdit.keyPressEvent(self,a0)

        if a0.key() == 16777235:
            self.SignalSearchDown.emit(False)
        if a0.key() == 16777237:
            self.SignalSearchDown.emit(True)

class GroupBoxExamples(qt.QGroupBox):

    def __init__(self):
        super(GroupBoxExamples, self).__init__()

        self.comboBoxScriptExample = qt.QComboBox()
        self.comboBoxScriptExample.setFixedSize(140*vrb.ratio,20*vrb.ratio)
        self.labeledComboBoxScriptExample = wgt.LabeledWidget(self.comboBoxScriptExample,title = "Script example")

        self.emptyLabel = qt.QLabel()
        self.emptyLabel.setFixedHeight(15*vrb.ratio)

        self.textEditExample = TextEditor()
        self.textEditExample.setReadOnly(True)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.labeledComboBoxScriptExample,0,0)
        self.layout.addWidget(self.emptyLabel,1,0)
        self.layout.addWidget(self.textEditExample,2,0)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(20*vrb.ratio,20*vrb.ratio,20*vrb.ratio,20*vrb.ratio)

        for example in dictExamples:
            self.comboBoxScriptExample.addItem(example)

        self.comboBoxScriptExample.currentIndexChanged.connect(self.showExample)

        self.showExample()

    def showExample(self):

        try:
            self.textEditExample.setText(dictExamples[self.comboBoxScriptExample.currentText()])

        except:
            self.textEditExample.setText("")
            traceback.print_exc(file=sys.stderr)

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook


    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)


    filename = vrb.folderFunctions + "/Macro/AA_Test_.mho"
    xmlFile = xmlet.parse(filename)
    xmlElement = xmlFile.getroot()

    sys.excepthook = exception_hook

    # foo = EditScriptWindow(xmlElement=None)
    foo = EditScriptWindow(xmlElement=xmlElement)

    # foo = GroupBoxExamples()

    # foo = BasicParam()

    foo.show()

    app.exec_()