from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5 import QtGui

import UsefullWidgets as wgt
import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct

import PyIPSDK
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr

import sys
import traceback

import numpy as np
import random
import xml.etree.ElementTree as xmlet

class HorizontalSpoiler(qt.QGroupBox):

    SignalStateChanged = pyqtSignal()

    def __init__(self, widget=None,standAlone = False):
        qt.QGroupBox.__init__(self)

        self.widget = widget
        self.standAlone = standAlone
        self.margins = 0
        self.spacing = 0

        # header
        self.labelHeader = qt.QLabel("◄")
        self.labelHeader.setFixedWidth(15*vrb.ratio)
        self.labelHeader.setAlignment(Qt.AlignTop)
        font = QtGui.QFont()
        font.setPointSize(12)
        self.labelHeader.setFont(font)
        self.labelHeader.setStyleSheet('QLabel {background:rgb(220, 220, 220)}')

        self.currentVisible = True

        # layout
        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.widget, 0, 0)
        self.layout.addWidget(self.labelHeader, 0, 1)
        #self.widget.setVisible(False)

        self.setLayout(self.layout)
        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(self.margins, self.margins, self.margins, self.margins)
        self.layout.setHorizontalSpacing(self.spacing)
        self.labelHeader.mousePressEvent = self.labelPressedEvent

        #self.setStyleSheet("QGroupBox {border: 0px transparent; }")
        self.setFixedWidth(self.widget.width()+self.labelHeader.width())

    def labelPressedEvent(self,event):

        self.currentVisible = not(self.currentVisible)
        if self.standAlone:
            self.expand(self.currentVisible)
        self.SignalStateChanged.emit()

    def expand(self,visible):

        if visible:
            self.labelHeader.setText("◄")
            self.widget.setVisible(True)
            self.setFixedWidth(self.widget.width() + self.labelHeader.width())
        else:
            self.labelHeader.setText("►")
            self.widget.setVisible(False)
            self.setFixedWidth(self.labelHeader.width())

class GroupBoxLut(qt.QWidget):

    SignalLutChanged = pyqtSignal()

    def __init__(self,labelImage = None,parent = None,customLut = None):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.labelImage = labelImage
        self.parent = parent

        self.randomLut = None
        self.currentLut = None
        self.lutArrayPreview = None

        self.checkBoxBackground = qt.QCheckBox("Ignore background")

        self.labelLut = wgt.LabelImage()

        self.comboBoxLut = qt.QComboBox()
        self.comboBoxLut.nbDefineLabel = 0

        # self.pushButtonCancel = qt.QPushButton("Cancel")
        self.pushButtonCancel = wgt.PushButtonImage(vrb.folderImages + "/Back.png", margins=0)
        self.pushButtonCancel.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)
        self.pushButtonCancel.setToolTip("Cancel")

        emptyLabel = qt.QLabel("")
        emptyLabel.setFixedWidth(5)

        self.pushButtonAdd = wgt.PushButtonImage(vrb.folderImages + "/Add_4.png", margins=0)
        self.pushButtonAdd.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        self.pushButtonAdd.setToolTip("Add a new LUT")

        emptyLabel2 = qt.QLabel("")
        emptyLabel2.setFixedWidth(5)

        # self.pushButtonValidate = qt.QPushButton("Validate")
        self.pushButtonValidate = wgt.PushButtonImage(vrb.folderImages + "/Validate.png", margins=0)
        self.pushButtonValidate.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)
        self.pushButtonValidate.setToolTip("Validate")

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.checkBoxBackground,0,0,1,5)
        self.layout.addWidget(self.labelLut,1,0,1,5,Qt.AlignHCenter)
        self.layout.addWidget(self.comboBoxLut,2,0,1,5)
        self.layout.addWidget(self.pushButtonCancel,3,0,Qt.AlignRight)
        self.layout.addWidget(emptyLabel,3,1)
        self.layout.addWidget(self.pushButtonAdd,3,2)
        self.layout.addWidget(emptyLabel,3,3)
        self.layout.addWidget(self.pushButtonValidate,3,4)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(5, 5, 5, 5)
        self.layout.setSizeConstraint(1)

        #self.setStyleSheet(' QGroupBox {border: 0px transparent}')

        self.setFixedSize(200*vrb.ratio,400*vrb.ratio)

        if labelImage is not None and labelImage.getBufferType() == PyIPSDK.eIBT_Binary:
            self.comboBoxLut.addItem(lutBinary['Name'], lutBinary)
            self.comboBoxLut.addItem(lutBinaryGrey['Name'], lutBinaryGrey)
            self.comboBoxLut.setCurrentIndex(0)
            self.checkBoxBackground.setChecked(True)
        else:
            self.randomLut = getLutArray(labelImage)
            if customLut is not None:
                self.comboBoxLut.addItem(customLut['Name'], customLut)
                self.checkBoxBackground.setChecked(True)
            else:
                self.comboBoxLut.addItem(lutClassic['Name'],lutClassic)
                self.comboBoxLut.addItem(lutRandom['Name'],lutRandom)
                self.comboBoxLut.addItem(lutMagma['Name'],lutMagma)
                self.comboBoxLut.addItem(lutProba['Name'],lutProba)
                self.comboBoxLut.addItem(lutJet['Name'],lutJet)
                self.comboBoxLut.addItem(lutExtrema['Name'],lutExtrema)
                self.comboBoxLut.addItem(lutInverted['Name'],lutInverted)
                self.comboBoxLut.addItem(lutBones['Name'],lutBones)
                if labelImage is not None and labelImage.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:
                    self.comboBoxLut.setCurrentIndex(1)
                    self.checkBoxBackground.setChecked(True)
                else:
                    self.comboBoxLut.setCurrentIndex(0)

        self.refCheck = self.checkBoxBackground.isChecked()
        self.relIndex = self.comboBoxLut.currentIndex()

        self.changeLutLabel()
        self.comboBoxLut.currentIndexChanged.connect(self.changeLutLabel)
        self.checkBoxBackground.stateChanged.connect(self.emitSignalLutChanged)
        self.pushButtonCancel.clicked.connect(self.cancelLut)
        self.pushButtonAdd.clicked.connect(self.addNewLut)
        self.pushButtonValidate.clicked.connect(self.validateLut)

        self.setWindowTitle("LUT")

        self.addCustomLuts()

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

    def resizeEvent(self,event):

        height = 0
        sizeButton = 20*vrb.ratio
        self.checkBoxBackground.setFixedSize(140*vrb.ratio,sizeButton)
        height += sizeButton
        # self.pushButtonCancel.setFixedSize(70*vrb.ratio, sizeButton)
        # self.pushButtonValidate.setFixedSize(70*vrb.ratio, sizeButton)
        height += sizeButton
        self.comboBoxLut.setFixedSize(self.width()-30*vrb.ratio,sizeButton)
        height += sizeButton
        self.labelLut.setFixedSize(self.width()*50/100, max(1,self.height()*100/100 - height - 35*vrb.ratio))

    def addNewLut(self):

        try:
            vrb.mainWindow.addNewLut()
        except:
            traceback.print_exc(file=sys.stderr)

    def addCustomLuts(self):

        if self.labelImage.getBufferType() != PyIPSDK.eIBT_Binary:

            currentIndex = self.comboBoxLut.currentIndex()

            while self.comboBoxLut.count() > 8:
                self.comboBoxLut.removeItem(self.comboBoxLut.count()-1)

            try:
                file = xmlet.parse(vrb.folderInformation + "/UserLut.mho")
                xmlElement = file.getroot()

                for child in xmlElement:
                    name = child.tag.replace("___"," ")

                    lut = {}
                    lut['Name'] = name
                    lut['Type'] = "Interp"
                    lut["Array"] = {}

                    nbSeeds = len(child)
                    maxi = 0
                    for i in range(nbSeeds):
                        childSeed = Dfct.SubElement(child, "Seed_" + str(i))
                        try:
                            maxi = max(maxi,float(Dfct.childText(childSeed, "Position")))
                        except:
                            pass
                    for i in range(nbSeeds):
                        try:
                            childSeed = Dfct.SubElement(child, "Seed_" + str(i))
                            position = maxi - float(Dfct.childText(childSeed, "Position"))
                            color = Dfct.childText(childSeed, "Color")
                            color = color.split(",")
                            for j in range(len(color)):
                                color[j] = float(color[j])

                            lut["Array"][position] = color
                        except:
                            pass

                    self.comboBoxLut.addItem(lut['Name'], lut)

            except:
                pass

            if currentIndex < self.comboBoxLut.count():
                self.comboBoxLut.setCurrentIndex(currentIndex)


    def validateLut(self):

        self.refCheck = self.checkBoxBackground.isChecked()
        self.relIndex = self.comboBoxLut.currentIndex()
        self.close()

    def cancelLut(self):

        self.checkBoxBackground.setChecked(self.refCheck)
        self.comboBoxLut.setCurrentIndex(self.relIndex)
        self.emitSignalLutChanged()
        self.close()

    def changeLutLabel(self):

        lut = self.comboBoxLut.currentData()
        array = lut["Array"]

        if lut["Type"] == "Interp":
            image = fct.lutImageFromArray(array)
            self.labelLut.smooth = True

        elif lut["Type"] == "Random":
            image = []
            keys = sorted(array.keys())
            for key in keys:
                image.append([[array[key][0],array[key][1],array[key][2]]])
            self.labelLut.smooth = False

        if lut["Name"] == "Random":
            self.currentLut = self.randomLut
        elif lut["Name"] == "Custom":
            self.currentLut = lutCustom(array)
        else:
            self.currentLut = lutFromVector(image)

        image = np.asarray(image, dtype=np.uint8)

        self.labelLut.image = image
        self.labelLut.resizeEvent(None)
        self.emitSignalLutChanged()

        # vrb.mainWindow.viewer3dSettingsWidget.updateVisualization()

    def emitSignalLutChanged(self):

        self.SignalLutChanged.emit()

class LutInformations(qt.QGroupBox):

    def __init__(self):
        qt.QGroupBox.__init__(self)

        self.labelMin = wgt.EditableLabel("0")
        # self.labelMin.label.setText("0")

        #self.labelMin = qt.QLabel("0")
        self.labelMin.setFixedSize(45 * vrb.ratio, 15 * vrb.ratio)
        self.labelMin.label.setAlignment(Qt.AlignRight)
        self.labelMin.lineEdit.setAlignment(Qt.AlignRight)

        self.labelLut = wgt.LabelImage()
        self.labelLut.smooth = True
        self.labelLut.setFixedSize(50 * vrb.ratio, 15 * vrb.ratio)

        self.labelMax = qt.QLabel("255")
        self.labelMax.setFixedSize(45 * vrb.ratio, 15 * vrb.ratio)
        self.labelMax.setAlignment(Qt.AlignLeft)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelMin,0,0)
        self.layout.addWidget(self.labelLut,0,1)
        self.layout.addWidget(self.labelMax,0,2)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setSizeConstraint(1)

    def resizeEvent(self,event):

        # self.labelLut.setFixedWidth(self.width()-110*vrb.ratio)
        self.labelLut.setFixedWidth(self.width()-self.labelMin.width()-self.labelMax.width()-20*vrb.ratio)

    def initLut(self,lut,vertical = True):

        image = fct.lutImageFromArray(lut,vertical = vertical)
        image = np.asarray(image, dtype=np.uint8)
        self.labelLut.image = image
        self.labelLut.resizeEvent(None)


class WidgetNewLut(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.labelName = qt.QLabel("Name")
        self.labelName.setFixedSize(40*vrb.ratio,20*vrb.ratio)

        self.lineEditName = qt.QLineEdit()
        self.lineEditName.setFixedSize(120*vrb.ratio,20*vrb.ratio)

        self.scrollAreaSeeds = ScrollAreaSeeds(parent=self)
        self.scrollAreaSeeds.setFixedSize(200*vrb.ratio,200*vrb.ratio)
        self.labelLut = wgt.LabelImage()
        self.labelLut.smooth = True
        self.labelLut.setFixedSize(80*vrb.ratio,200*vrb.ratio)

        self.buttonAdd = wgt.PushButtonImage(vrb.folderImages + "/Add_4.png", margins=0)
        self.buttonAdd.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        self.buttonAdd.setToolTip("Add a seed")

        self.buttonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=0)
        self.buttonSave.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)
        self.buttonSave.setToolTip("Save this LUT")

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelName,0,0)
        self.layout.addWidget(self.lineEditName,0,1,Qt.AlignLeft)
        self.layout.addWidget(self.scrollAreaSeeds,1,0,1,2)
        self.layout.addWidget(self.buttonAdd,2,0)
        self.layout.addWidget(self.labelLut,1,2)
        self.layout.addWidget(self.buttonSave,2,2,Qt.AlignRight)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(10*vrb.ratio, 10*vrb.ratio, 10*vrb.ratio, 10*vrb.ratio)
        self.layout.setSizeConstraint(1)

        # self.setStyleSheet(' QGroupBox {border: 0px transparent}')

        self.setFixedSize(300*vrb.ratio,320*vrb.ratio)
        self.setWindowTitle("LUT creator")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.lineEditName.textChanged.connect(self.nameChanged)
        self.buttonAdd.clicked.connect(self.scrollAreaSeeds.addSeed_)
        self.buttonSave.clicked.connect(self.saveXmlElement)

        self.actualizeLutImage()

    def closeEvent(self, a0: QtGui.QCloseEvent):

        try:
            vrb.mainWindow.currentLabel.groupBoxLut.changeLutLabel()
            vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)
        except:
            pass

    def nameChanged(self):

        self.buttonSave.setEnabled(True)

    def actualizeLutImage(self):

        try:
            lut = {}

            maxi = 0
            for i in range(self.scrollAreaSeeds.layout.count(), -1, -1):
                try:
                    item = self.scrollAreaSeeds.layout.itemAt(i)
                    if item is not None:
                        seed = item.widget()
                        maxi=max(maxi,float(seed.lineEditSeed.text()))
                except:
                    pass

            for i in range(self.scrollAreaSeeds.layout.count()):
                item = self.scrollAreaSeeds.layout.itemAt(i)
                if item is not None:
                    seed = item.widget()
                    seed.labelSeed.setText("Seed "+str(i+1))
                    try:
                        seedValue = float(seed.lineEditSeed.text())
                        if len(seed.color) != 0:
                            lut[maxi-seedValue] = seed.color
                    except:
                        pass

            image = fct.lutImageFromArray(lut)
            try:
                vrb.mainWindow.currentLabel.groupBoxLut.currentLut = lutFromVector(image)
                vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)
            except:
                pass


            image = np.asarray(image, dtype=np.uint8)
            self.labelLut.image = image
            self.labelLut.resizeEvent(None)

            self.buttonSave.setEnabled(True)

        except:
            pass

    def saveXmlElement(self):

        if self.lineEditName.text() == "":
            self.messageBox = wgt.MessageBox("You need to choose a name before saving this LUT", '', buttons=[qt.QMessageBox.Ok], icon=qt.QMessageBox.Warning, windowTitle="Error")
            self.messageBox.exec()

        else:
            try:
                file = xmlet.parse(vrb.folderInformation + "/UserLut.mho")
                xmlElement = file.getroot()
            except:
                xmlElement = xmlet.Element('UserLut')

            child = Dfct.SubElement(xmlElement, self.lineEditName.text().replace(" ","___"))

            for i in range(self.scrollAreaSeeds.layout.count()):
                item = self.scrollAreaSeeds.layout.itemAt(i)
                if item is not None:
                    seed = item.widget()
                    seedElement = Dfct.SubElement(child, "Seed_"+str(i))
                    position = Dfct.SubElement(seedElement, "Position")
                    position.text = seed.lineEditSeed.text()
                    color = Dfct.SubElement(seedElement, "Color")
                    try:
                        color.text = str(seed.color[0])+","+str(seed.color[1])+","+str(seed.color[2])
                    except:
                        pass

                Dfct.saveXmlElement(xmlElement, vrb.folderInformation + "/UserLut.mho")

                #self.close()

                try:
                    vrb.mainWindow.actualizeLuts()
                except:
                    pass

                try:
                    vrb.mainWindow.manageLut.loadLuts()
                except:
                    pass

            self.buttonSave.setEnabled(False)

    def loadXmlElement(self,element):

        self.scrollAreaSeeds.deleteAllSeeds()

        name = element.tag.replace("___"," ")
        self.lineEditName.setText(name)

        nbSeeds = len(element)

        for i in range(nbSeeds):
            child = Dfct.SubElement(element,"Seed_"+str(i))
            seed = GroupBoxSeed(allowDelete= i not in [0,nbSeeds-1])
            try:
                seed.lineEditSeed.setText(Dfct.childText(child,"Position"))
            except:
                pass
            try:
                color = Dfct.childText(child,"Color")
                color = color.split(",")
                for j in range(len(color)):
                    color[j]=float(color[j])
                seed.setColor(color)
            except:
                pass

            self.scrollAreaSeeds.addSeed(seed,position=i)


class ScrollAreaSeeds(qt.QScrollArea):

    def __init__(self,parent=None):
        qt.QScrollArea.__init__(self)

        self.parent = parent

        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)

        self.centralWidget = qt.QGroupBox()

        self.layout = qt.QVBoxLayout()
        self.layout.setAlignment(QtCore.Qt.AlignTop)

        self.centralWidget.setLayout(self.layout)
        self.centralWidget.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.setStyleSheet('QScrollArea {border: 1px solid white; }')

        self.setWidget(self.centralWidget)

        self.layout.setContentsMargins(5, 5, 20, 5)

        self.initSeeds()

    def initSeeds(self):

        self.deleteAllSeeds()

        seed0 = GroupBoxSeed(allowDelete=False)
        seed0.setColor([255,0,0])
        seed0.lineEditSeed.setText(str(100))
        seed1 = GroupBoxSeed()
        seed1.setColor([0,255,0])
        seed1.lineEditSeed.setText(str(50))
        seed2 = GroupBoxSeed(allowDelete=False)
        seed2.setColor([0,0,255])
        seed2.lineEditSeed.setText(str(0))

        self.layout.addWidget(seed0)
        # self.layout.addWidget(seed1)
        self.layout.addWidget(seed2)

        seed0.signalChange.connect(self.parent.actualizeLutImage)
        seed2.signalChange.connect(self.parent.actualizeLutImage)

        self.addSeed(seed=seed1)

    def addSeed_(self):

        self.addSeed()

    def addSeed(self,seed=None,position = None):

        if position is None:
            position = self.layout.count()-1

        if seed is None:
            seed = GroupBoxSeed()
        seed.signalDelete.connect(self.deleteSeed)
        seed.signalChange.connect(self.parent.actualizeLutImage)
        self.layout.insertWidget(position,seed)

        self.centralWidget2 = qt.QWidget()
        self.centralWidget2.setLayout(self.layout)
        self.setWidget(self.centralWidget2)

        self.parent.actualizeLutImage()

    def deleteSeed(self,seed):

        for i in range(self.layout.count()-1):
            item = self.layout.itemAt(i)
            if item is not None:
                if item.widget() == seed:
                    item.widget().deleteLater()
                    self.layout.removeItem(item)

        self.centralWidget2 = qt.QWidget()
        self.centralWidget2.setLayout(self.layout)
        self.setWidget(self.centralWidget2)

        self.parent.actualizeLutImage()

        self.parent.buttonSave.setEnabled(True)

    def deleteAllSeeds(self):

        while self.layout.count() != 0:
            item = self.layout.itemAt(0)
            if item is not None:
                item.widget().deleteLater()
                self.layout.removeItem(item)

        try:
            self.parent.buttonSave.setEnabled(True)
        except:
            pass

class GroupBoxSeed(qt.QGroupBox):

    signalDelete = pyqtSignal(qt.QGroupBox)
    signalChange = pyqtSignal()

    def __init__(self,allowDelete=True):
        qt.QGroupBox.__init__(self)

        self.color = []

        self.labelSeed = qt.QLabel("Seed")
        self.labelSeed.setFixedWidth(40*vrb.ratio)
        self.lineEditSeed = qt.QLineEdit()
        self.lineEditSeed.setFixedWidth(31*vrb.ratio)
        self.lineEditSeed.setEnabled(allowDelete)
        self.buttonColor = qt.QPushButton()
        self.buttonColor.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        self.buttonColor.setToolTip("Change the seed color")

        self.labelPercentage = qt.QLabel("%")
        self.labelPercentage.setContentsMargins(0,0,0,0)
        self.labelPercentage.setFixedWidth(15*vrb.ratio)

        self.labelDelete = wgt.LabelDelete()
        self.labelDelete.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        emptyLabel =qt.QLabel()
        emptyLabel.setFixedSize(25*vrb.ratio,25*vrb.ratio)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelSeed, 0, 0)
        self.layout.addWidget(self.lineEditSeed, 0, 1)
        self.layout.addWidget(self.labelPercentage, 0, 2)
        self.layout.addWidget(self.buttonColor, 0, 3)
        if allowDelete:
            self.layout.addWidget(self.labelDelete, 0, 4)
        else:
            self.layout.addWidget(emptyLabel, 0, 4)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(5, 5, 5, 5)
        self.layout.setSizeConstraint(1)

        self.setFixedSize(175*vrb.ratio, 30*vrb.ratio)

        self.buttonColor.clicked.connect(self.getColor)
        self.labelDelete.clicked.connect(self.emitSignalDelete)
        self.lineEditSeed.textChanged.connect(self.emitSignalChange)

    def getColor(self):

        vrb.mainWindow.widgetNewLut.close()

        # try:
        #     try:
        #         vrb.mainWindow.widgetNewLut.setWindowFlag(Qt.WindowStaysOnBottomHint)
        #     except:
        #         vrb.mainWindow.widgetNewLut.setWindowFlags(Qt.WindowStaysOnBottomHint)
        # except:
        #     pass

        # vrb.mainWindow.widgetNewLut.show()
        color = qt.QColorDialog.getColor()
        # try:
        #     try:
        #         #vrb.mainWindow.widgetNewLut.setWindowFlag(~Qt.WindowStaysOnBottomHint)
        #         vrb.mainWindow.widgetNewLut.setWindowFlag(Qt.WindowStaysOnBottomHint,False)
        #         vrb.mainWindow.widgetNewLut.setWindowFlag(Qt.WindowStaysOnTopHint,True)
        #         #vrb.mainWindow.widgetNewLut.setWindowFlag(Qt.WindowStaysOnBottomHint,True)
        #     except:
        #         vrb.mainWindow.widgetNewLut.setWindowFlag(Qt.WindowStaysOnBottomHint, False)
        #         vrb.mainWindow.widgetNewLut.setWindowFlags(Qt.WindowStaysOnTopHint)
        # except:
        #     pass

        vrb.mainWindow.widgetNewLut.show()

        if (color.isValid()):

            self.color = [color.red(),color.green(),color.blue()]
            self.buttonColor.setStyleSheet('QPushButton {background-color: rgb('+str(color.red())+','+str(color.green())+','+str(color.blue()) +');}')

        self.emitSignalChange()

    def setColor(self,color):

        self.color = color
        self.buttonColor.setStyleSheet('QPushButton {background-color: rgb(' + str(color[0]) + ',' + str(color[1]) + ',' + str(color[2]) + ');}')

    def emitSignalDelete(self):

        self.signalDelete.emit(self)

    def emitSignalChange(self):

        self.signalChange.emit()

class LutManager(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.xmlElement = None

        self.labelLut = qt.QLabel("LUT")
        self.labelLut.setFixedSize(30*vrb.ratio,20*vrb.ratio)

        self.comboBoxLut = qt.QComboBox()
        self.comboBoxLut.setFixedSize(120*vrb.ratio,20*vrb.ratio)

        self.buttonEdit = wgt.PushButtonImage(vrb.folderImages + "/Edit_3.png", margins=0)
        self.buttonEdit.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)
        self.buttonEdit.setToolTip("Edit this LUT")

        self.buttonDelete = wgt.PushButtonImage(vrb.folderImages + "/Delete.png", margins=0)
        self.buttonDelete.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)
        self.buttonDelete.setToolTip("Delete this LUT")

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelLut,0,0)
        self.layout.addWidget(self.comboBoxLut,0,1)
        self.layout.addWidget(self.buttonEdit,0,2)
        self.layout.addWidget(self.buttonDelete,0,3)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(10*vrb.ratio, 10*vrb.ratio, 10*vrb.ratio, 10*vrb.ratio)
        self.layout.setSizeConstraint(1)

        # self.setStyleSheet(' QGroupBox {border: 0px transparent}')

        self.setFixedSize(240*vrb.ratio,40*vrb.ratio)
        self.setWindowTitle("LUT")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.buttonEdit.clicked.connect(self.editLut)
        self.buttonDelete.clicked.connect(self.deleteLut)

    def loadLuts(self):

        currentIndex = self.comboBoxLut.currentIndex()
        self.comboBoxLut.clear()

        try:
            file = xmlet.parse(vrb.folderInformation + "/UserLut.mho")
            self.xmlElement = file.getroot()
            for child in self.xmlElement:
                self.comboBoxLut.addItem(child.tag.replace("___"," "),child)
        except:
            traceback.print_exc(file=sys.stderr)

        if currentIndex >= 0 and currentIndex < self.comboBoxLut.count():
            self.comboBoxLut.setCurrentIndex(currentIndex)

    def editLut(self):

        try:
            if self.comboBoxLut.currentData():
                vrb.mainWindow.widgetNewLut.loadXmlElement(self.comboBoxLut.currentData())
                vrb.mainWindow.widgetNewLut.show()
                self.close()
            else:
                vrb.mainWindow.addNewLut()
        except:
            pass

    def deleteLut(self):

        if self.xmlElement is not None:
            try:
                Dfct.removeElement(self.xmlElement,self.comboBoxLut.currentData())
                Dfct.saveXmlElement(self.xmlElement, vrb.folderInformation + "/UserLut.mho")
                self.loadLuts()
                try:
                    vrb.mainWindow.actualizeLuts()
                except:
                    pass
            except:
                traceback.print_exc(file=sys.stderr)

def lutCustom(array):

    lutArray = []
    lutArray.append([])
    lutArray.append([])
    lutArray.append([])
    for i in range(len(array)):
        lutArray[0].append(array[i][0])
        lutArray[1].append(array[i][1])
        lutArray[2].append(array[i][2])

    return lutArray


def lutFromVector(vector):
    lutArray = []
    lutArray.append([])
    lutArray.append([])
    lutArray.append([])
    for i in range(255, -1, -1):
        index = int(i * len(vector) / 256)
        lutArray[0].append(vector[index][0][0])
        lutArray[1].append(vector[index][0][1])
        lutArray[2].append(vector[index][0][2])

    return lutArray

def getLutArray(image):
    random.seed(5)

    # if image.getSizeT() > 1:
    #     _,nbLabels = fct.getMinMaxValue(image)
    # else:
    #     if image.getSizeZ() == 1:
    #         nbLabels = glbmsr.statsMsr2d(image).max
    #     else:
    #         nbLabels = glbmsr.statsMsr3d(image).max

    _,nbLabels = fct.getMinMaxValue(image)

    if image.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16,PyIPSDK.eIBT_Label32]:
        maxNumber = 10000000
    else:
        maxNumber = 10000
    nbLabels = min(nbLabels+1, maxNumber)
    lutArray = []
    lutArray.append([0])
    lutArray.append([0])
    lutArray.append([0])
    for i in range(1, int(nbLabels)+1):
        for c in range(3):
            if i <10:
                lutArray[c].append(vrb.dictColor[i][c])
            else:
                lutArray[c].append(random.randint(vrb.randomColorMin, vrb.randomColorMax))

    return lutArray

lutClassic = {}
lutClassic['Name'] = "Classic"
lutClassic['Type'] = "Interp"
lutClassic["Array"] = {}
lutClassic["Array"][0] = [255,255,255]
lutClassic["Array"][255] = [0,0,0]

lutRandom = {}
lutRandom['Name'] = "Random"
lutRandom['Type'] = "Random"
lutRandom["Array"] = {}
for i in range(100):
    lutRandom["Array"][i] = [random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax)]

lutBinary = {}
lutBinary['Name'] = "Binary"
lutBinary['Type'] = "Random"
lutBinary["Array"] = {}
lutBinary["Array"][0] = [0,0,200]
lutBinary["Array"][1] = [0,0,0]

lutBinaryGrey = {}
lutBinaryGrey['Name'] = "Binary Grey"
lutBinaryGrey['Type'] = "Random"
lutBinaryGrey["Array"] = {}
lutBinaryGrey["Array"][0] = [200,200,200]
lutBinaryGrey["Array"][1] = [0,0,0]

lutInverted = {}
lutInverted['Name'] = "Inverted"
lutInverted['Type'] = "Interp"
lutInverted["Array"] = {}
lutInverted["Array"][0] = [0,0,0]
lutInverted["Array"][255] = [255,255,255]

lutMagma = {}
lutMagma['Name'] = "Magma"
lutMagma['Type'] = "Interp"
lutMagma["Array"] = {}
lutMagma["Array"][10] = [0,0,255]
lutMagma["Array"][0] = [255,0,0]
lutMagma["Array"][5] = [0,255,0]

lutProba = {}
lutProba['Name'] = "Proba"
lutProba['Type'] = "Interp"
lutProba["Array"] = {}
lutProba["Array"][0] = [0,255,0]
lutProba["Array"][10] = [255,0,0]

lutJet = {}
lutJet['Name'] = "Jet"
lutJet['Type'] = "Interp"
lutJet["Array"] = {}
lutJet["Array"][0] = [255,0,0]
lutJet["Array"][1] = [255,128,0]
lutJet["Array"][2] = [255,255,0]
lutJet["Array"][3] = [128,255,0]
lutJet["Array"][4] = [0,255,0]
lutJet["Array"][5] = [0,255,128]
lutJet["Array"][6] = [0,255,255]
lutJet["Array"][7] = [0,128,255]
lutJet["Array"][8] = [0,0,255]
# lut4["Array"][9] = [128,0,255]
# lut4["Array"][10] = [255,0,255]
# lut4["Array"][11] = [255,0,128]
# lut4["Array"][12] = [255,0,0]

lutExtrema = {}
lutExtrema['Name'] = "Extrema"
lutExtrema['Type'] = "Interp"
lutExtrema["Array"] = {}
lutExtrema["Array"][0] = [255,0,0]
lutExtrema["Array"][1] = [0,0,255]
lutExtrema["Array"][2] = [255,0,0]


lutBones = {}
lutBones['Name'] = "Bones"
lutBones['Type'] = "Interp"
lutBones["Array"] = {}
lutBones["Array"][0] = [255,255,242]
lutBones["Array"][10] = [255,245,205]
lutBones["Array"][20] = [170,138,125]
lutBones["Array"][90] = [98,76,76]
lutBones["Array"][100] = [47,40,40]

# lut4['Name'] = "Random (12)"
# lut4['Type'] = "Random"
# lut4["Array"] = {}
# random.seed(12)
# for i in range(12):
#     lut4["Array"][i] = [random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax)]
# random.seed(12)
# for i in range(12):
#     lut4["Array"][i+12] = [random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax)]
# random.seed(12)
# for i in range(12):
#     lut4["Array"][i+24] = [random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax)]


lutBinaryRedVector = [[],[],[]]
for i in range(256):
    lutBinaryRedVector[0].append(200)
    lutBinaryRedVector[1].append(0)
    lutBinaryRedVector[2].append(0)


if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook

    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook


    labelImage = PyIPSDK.loadTiffImageFile("F:/ExampleImages/Lena_510x509_UInt8.tif")

    # foo = GroupBoxLut(labelImage=labelImage)
    foo = WidgetNewLut()
    # foo = ScrollAreaSeeds()
    # foo = LutManager()
    # foo.loadLuts()

    #spoiler.resize(200,800)

    # try:
    #     file = xmlet.parse(vrb.folderInformation + "/UserLut.mho")
    #     xmlElement = file.getroot()
    #
    #     child = Dfct.SubElement(xmlElement,"new___Lut")
    #     foo.loadXmlElement(child)
    # except:
    #     pass

    # foo.scrollAreaSeeds.deleteAllSeeds()

    #foo.show()
    foo.show()
    # foo.addLut(lut0)
    # foo.addLut(lut1)
    # foo.addLut(lut2)
    # foo.addLut(lut3)
    # foo.addLut(lut4)
    # foo.addLut(lut5)
    # foo.addLut(lut6)

    #foo.changeMode("overlay")

    app.exec_()