from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5 import QtGui

import UsefullWidgets as wgt
import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct

import PyIPSDK
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr

import sys

import numpy as np
import random
import xml.etree.ElementTree as xmlet

class WidgetLabels(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.scrollAreaLabels = ScrollAreaLabels(parent=self)
        self.scrollAreaLabels.setFixedSize(300*vrb.ratio,200*vrb.ratio)

        self.buttonAdd = wgt.PushButtonImage(vrb.folderImages + "/Add_4.png", margins=0)
        self.buttonAdd.setToolTip("Add a new label")
        self.buttonAdd.setFixedSize(25*vrb.ratio,25*vrb.ratio)

        self.buttonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=0)
        self.buttonSave.setToolTip("Save this configuration")
        self.buttonSave.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.scrollAreaLabels,0,0,1,2)
        self.layout.addWidget(self.buttonAdd,1,0)
        self.layout.addWidget(self.buttonSave,1,1,Qt.AlignRight)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(10*vrb.ratio, 10*vrb.ratio, 10*vrb.ratio, 0)
        self.layout.setSizeConstraint(1)

        # self.setStyleSheet(' QGroupBox {border: 0px transparent}')

        self.setFixedSize(360*vrb.ratio,280*vrb.ratio)
        self.setWindowTitle("Label manager")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.buttonAdd.clicked.connect(self.scrollAreaLabels.addLabel_)
        self.buttonSave.clicked.connect(self.saveXmlElement)

        self.actualizeNumLabels()
        self.loadXmlElement()

    def actualizeNumLabels(self):

        for i in range(self.scrollAreaLabels.layout.count()):
            item = self.scrollAreaLabels.layout.itemAt(i)
            if item is not None:
                label = item.widget()
                try:
                    label.labelLabel.setText("Label " + str(i))
                except:
                    pass

    def saveXmlElement(self):

        # try:
        #     file = xmlet.parse(vrb.folderInformation + "/UserLabels.mho")
        #     xmlElement = file.getroot()
        # except:
        #     xmlElement = xmlet.Element('UserLabels')
        xmlElement = xmlet.Element('UserLabels')

        for i in range(self.scrollAreaLabels.layout.count()):
            if i != 0:
                item = self.scrollAreaLabels.layout.itemAt(i)
                if item is not None:
                    label = item.widget()
                    labelElement = Dfct.SubElement(xmlElement, "Label_"+str(i))
                    name = Dfct.SubElement(labelElement, "Name")
                    name.text = label.lineEditLabel.text()
                    color = Dfct.SubElement(labelElement, "Color")
                    try:
                        color.text = str(label.color[0])+","+str(label.color[1])+","+str(label.color[2])
                    except:
                        pass

            Dfct.saveXmlElement(xmlElement, vrb.folderInformation + "/UserLabels.mho")

        try:
            sploiler = vrb.mainWindow.widgetLabelValue.centralWidget.spoilers["ShapeAnalysis"].widget
            for num in range(sploiler.layout.count()):
                try:
                    item = sploiler.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        label.objectDisplayer.tableWidget.loadDict()
                        label.objectDisplayer.tableWidget.setColumnWidth(1, 100 * vrb.ratio)
                except:
                    pass
        except:
            pass

        try:
            vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)
        except:
            pass

        try:
            for num in range(vrb.mainWindow.widgetLabelImage.layout.count()):
                try:
                    item = vrb.mainWindow.widgetLabelImage.layout.itemAt(num)
                    if item is not None:
                        label = item.widget()
                        if label.objectType == "Image":
                            label.groupBoxLut.changeLutLabel()
                        elif label.objectType == "Mesh":
                            if label.nbLabels > 1:
                                colormap = fct.createLabelLutNapari(label.nbLabels)
                                label.layer.colormap = colormap
                except:
                    pass
        except:
            pass

        self.buttonSave.setEnabled(False)

        # self.close()

    def loadXmlElement(self):

        try:
            file = xmlet.parse(vrb.folderInformation + "/UserLabels.mho")
            xmlElement = file.getroot()

            self.scrollAreaLabels.deleteAllLabels()

            title = GroupBoxTitle()

            self.scrollAreaLabels.layout.addWidget(title)

            nbLabels = len(xmlElement) + 1

            for i in range(1,nbLabels):
                child = Dfct.SubElement(xmlElement, "Label_" + str(i))
                label = GroupBoxLabel(parent=self)
                try:
                    label.lineEditLabel.setText(Dfct.childText(child, "Name"))
                except:
                    pass
                try:
                    color = Dfct.childText(child, "Color")
                    color = color.split(",")
                    for j in range(len(color)):
                        color[j] = float(color[j])
                    label.setColor(color)
                except:
                    pass

                self.scrollAreaLabels.addLabel(label)

        except:
            pass

class ScrollAreaLabels(qt.QScrollArea):

    def __init__(self,parent=None):
        qt.QScrollArea.__init__(self)

        self.parent = parent

        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)

        self.centralWidget = qt.QGroupBox()

        title = GroupBoxTitle()

        label0 = GroupBoxLabel(parent=parent)
        label0.setColor([255,0,0])

        self.layout = qt.QVBoxLayout()

        self.layout.addWidget(title)
        self.layout.addWidget(label0)
        self.layout.setAlignment(QtCore.Qt.AlignTop)

        self.centralWidget.setLayout(self.layout)
        self.centralWidget.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.setStyleSheet('QScrollArea {border: 1px solid white; }')

        self.setWidget(self.centralWidget)

        self.layout.setContentsMargins(5, 5, 20, 5)

        label0.signalDelete.connect(self.deleteLabel)

    def addLabel_(self):

        self.addLabel()

    def addLabel(self,label=None,position = None):

        if position is None:
            position = self.layout.count()

        if label is None:
            label = GroupBoxLabel(parent=self.parent)
        label.signalDelete.connect(self.deleteLabel)
        self.layout.insertWidget(position,label)

        self.centralWidget2 = qt.QWidget()
        self.centralWidget2.setLayout(self.layout)
        self.setWidget(self.centralWidget2)

        self.parent.actualizeNumLabels()

        self.parent.buttonSave.setEnabled(True)

    def deleteLabel(self,label):

        for i in range(self.layout.count()+1):
            item = self.layout.itemAt(i)
            if item is not None:
                if item.widget() == label:
                    item.widget().deleteLater()
                    self.layout.removeItem(item)

        self.centralWidget2 = qt.QWidget()
        self.centralWidget2.setLayout(self.layout)
        self.setWidget(self.centralWidget2)

        self.parent.actualizeNumLabels()

        self.parent.buttonSave.setEnabled(True)

    def deleteAllLabels(self):

        while self.layout.count() != 0:
            item = self.layout.itemAt(0)
            if item is not None:
                item.widget().deleteLater()
                self.layout.removeItem(item)

        try:
            self.parent.buttonSave.setEnabled(True)
        except:
            pass

class GroupBoxLabel(qt.QGroupBox):

    signalDelete = pyqtSignal(qt.QGroupBox)

    def __init__(self,parent=None):
        qt.QGroupBox.__init__(self)

        self.parent = parent

        self.color = []

        self.labelLabel = qt.QLabel("Label")
        self.labelLabel.setFixedWidth(45*vrb.ratio)
        self.lineEditLabel = qt.QLineEdit()
        self.lineEditLabel.setFixedWidth(131*vrb.ratio)
        # self.lineEditLabel.setPlaceholderText("Name")
        self.buttonColor = qt.QPushButton()
        self.buttonColor.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        self.buttonColor.setToolTip("Change label color")

        self.labelDelete = wgt.LabelDelete()
        self.labelDelete.setFixedSize(25*vrb.ratio,25*vrb.ratio)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelLabel, 0, 0)
        self.layout.addWidget(self.lineEditLabel, 0, 1)
        self.layout.addWidget(self.buttonColor, 0, 2)
        self.layout.addWidget(self.labelDelete, 0, 3)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(5, 5, 5, 5)
        self.layout.setSizeConstraint(1)

        self.setFixedSize(280*vrb.ratio, 32*vrb.ratio)

        self.buttonColor.clicked.connect(self.getColor)
        self.labelDelete.clicked.connect(self.emitSignalDelete)
        self.lineEditLabel.textChanged.connect(self.changeSave)

    def getColor(self):

        try:
            self.parent.setWindowFlag(self.parent.windowFlags() & ~Qt.WindowStaysOnTopHint)
        except:
            self.parent.setWindowFlags(self.parent.windowFlags() & ~Qt.WindowStaysOnTopHint)

        self.parent.show()

        colorDialogue = qt.QColorDialog()
        try:
            colorDialogue.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            colorDialogue.setWindowFlags(Qt.WindowStaysOnTopHint)

        color = colorDialogue.getColor()

        try:
            self.parent.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.parent.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.parent.show()

        if (color.isValid()):

            self.color = [color.red(),color.green(),color.blue()]
            self.buttonColor.setStyleSheet('QPushButton {background-color: rgb('+str(color.red())+','+str(color.green())+','+str(color.blue()) +');}')

        self.changeSave()

    def setColor(self,color):

        self.color = color
        self.buttonColor.setStyleSheet('QPushButton {background-color: rgb(' + str(color[0]) + ',' + str(color[1]) + ',' + str(color[2]) + ');}')

    def emitSignalDelete(self):

        self.signalDelete.emit(self)

    def changeSave(self):

        try:
            self.parent.buttonSave.setEnabled(True)
        except:
            pass

class GroupBoxTitle(qt.QGroupBox):

    def __init__(self):
        qt.QGroupBox.__init__(self)

        self.label1 = qt.QLabel("N°")
        self.label1.setFixedWidth(45*vrb.ratio)
        self.label1.setAlignment(Qt.AlignCenter)
        self.label2 = qt.QLabel("Name")
        self.label2.setFixedWidth(131 * vrb.ratio)
        self.label2.setAlignment(Qt.AlignCenter)
        self.label3 = qt.QLabel("Color")
        self.label3.setFixedWidth(35 * vrb.ratio)
        self.label3.setAlignment(Qt.AlignCenter)
        self.label4 = qt.QLabel("")
        self.label4.setFixedWidth(25 * vrb.ratio)
        self.label4.setAlignment(Qt.AlignCenter)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.label1, 0, 0)
        self.layout.addWidget(self.label2, 0, 1)
        self.layout.addWidget(self.label3, 0, 2)
        self.layout.addWidget(self.label4, 0, 3)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(5, 5, 5, 5)
        self.layout.setSizeConstraint(1)

        self.setFixedSize(280*vrb.ratio, 30*vrb.ratio)

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook

    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook

    # foo = GroupBoxLabel()
    # foo = ScrollAreaLabels()
    foo = WidgetLabels()

    foo.show()

    app.exec_()