import os
import sys
import traceback
import webbrowser
from shutil import copyfile

from PyQt5 import QtGui
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication
import PyQt5.QtWidgets as qt
from PyQt5.QtGui import QPainter, QPen, QColor

import xml.etree.ElementTree as xmlet
import DatabaseFunction as Dfct
import WidgetTypes

from SpoilerWidget import Spoiler, SpoilersContainer
from MacroWidgets import EditScriptWindow

import UsefullVariables as vrb
import UsefullFunctions as fct
import UsefullFunctionsForWidget as fctWidget
import UsefullWidgets as wgt
import UsefullTexts as txt

import SearchBox as searchBox


class HorizontalLine(qt.QWidget):
    def __init__(self, color="black", thickness=2):
        super().__init__()
        self.color = color
        self.thickness = thickness
        self.setFixedHeight(thickness)

    def paintEvent(self, event):
        painter = QPainter(self)
        painter.setPen(QPen(QColor(self.color), self.thickness))
        painter.drawLine(0, self.height() // 2, self.width(), self.height() // 2)

class FunctionWidget(qt.QWidget):

    SignalBatch = pyqtSignal(qt.QGroupBox)
    SignalProcess = pyqtSignal(qt.QGroupBox)
    SignalHeightChanged = pyqtSignal()
    SignalSelector = pyqtSignal(qt.QGroupBox, bool, int)
    SignalSelectionComboBoxChanged = pyqtSignal()
    SignalPreviewClicked = pyqtSignal()
    SignalPreviewRefresh = pyqtSignal()
    SignalReloadFunctionsSpoiler = pyqtSignal()

    def __init__(self, xmlFunctionDescription):
        qt.QWidget.__init__(self)

        self.xmlFunctionDescription = xmlFunctionDescription
        self.title = Dfct.childText(self.xmlFunctionDescription, 'Name')

        self.isInit = False

        # if self.title in ["Smart Segmentation","Smart Segmentation With Probabilities","Smart Classification","Super Pixel Segmentation","Label to Measure","Histogram of Measure","Shape filtering 2D", "Shape filtering 3D"]:
        if self.title in ["Label to Measure","Histogram of Measure","Shape filtering 2D", "Shape filtering 3D"]:
            self.initFunction()

    def initFunction(self):

        if self.isInit == False:
            self.isInit = True

            self.title = Dfct.childText(self.xmlFunctionDescription, 'Name')

            self.xmlFunctionDescription = self.xmlFunctionDescription  # description of the interface
            self.xmlParametersProcess = xmlet.Element('Function')  # recaps all parameters when calling the actual function (filled when start is pressed)

            self.editScriptWindow = None

            self.margins = 5
            self.spacing = 5
            self.sizeWidget = 25 * vrb.ratio
            self.sizeButtons = 25 * vrb.ratio

            self.parameters = {}
            paramsNode = Dfct.SubElement(self.xmlFunctionDescription, 'Parameters')
            for nb, paramNode in enumerate(paramsNode, 0):
                label, widget, constraints, type, defaultValue = fctWidget.generateParamWidget(paramNode)
                if widget is not None:
                    self.parameters[nb] = {}
                    self.parameters[nb]['Type'] = type
                    self.parameters[nb]['Label'] = label
                    self.parameters[nb]['Widget'] = widget
                    self.parameters[nb]['Constraints'] = constraints
                    self.parameters[nb]['DefaultValue'] = defaultValue
                    if Dfct.childText(paramNode, 'Mandatory') != 'True':
                        widget = widget.widget
                    if type == WidgetTypes.InputType.ADVANCED:
                        widget.SignalSelectionComboBoxChanged.connect(self.emitSignalSelectionComboBoxChanged)
                        widget.SignalHeightChanged.connect(self.changeHeight)
                    elif type == WidgetTypes.InputType.SELECTOR:
                        widget.SignalSelector.connect(self.emitSignalSelector)
                    elif type == WidgetTypes.InputType.IMAGE:
                        widget.currentIndexChanged.connect(self.emitSignalSelectionComboBoxChanged)

            oneOutputIsPreviewable = False
            self.outputs = {}
            outputsNode = Dfct.SubElement(self.xmlFunctionDescription, 'Outputs')
            for nb, outputNode in enumerate(outputsNode, 0):
                try:
                    label, widget, type = fctWidget.generateOutputWidget(outputNode)
                    if widget is not None:
                        self.outputs[nb] = {}
                        self.outputs[nb]['Label'] = label
                        self.outputs[nb]['Widget'] = widget
                        self.outputs[nb]['Type'] = type
                        if type == WidgetTypes.OutputType.IMAGE:
                            oneOutputIsPreviewable = True
                except:
                    pass
                    # traceback.print_exc(file=sys.stderr)

            if self.title in vrb.previewException:
                oneOutputIsPreviewable = False

            self.pushButtonBatch = wgt.PushButtonImage(vrb.folderImages + "/Batch.png", margins=2)
            self.pushButtonBatch.setFixedSize(self.sizeButtons,self.sizeButtons)
            self.pushButtonBatch.setToolTip("Batch")

            self.pushButtonStart = wgt.PushButtonImage(vrb.folderImages + "/Validate.png", margins=2)
            self.pushButtonStart.setFixedSize(self.sizeButtons,self.sizeButtons)
            self.pushButtonStart.setToolTip("Start")
            #self.pushButtonStart = qt.QPushButton("Start")
            #self.pushButtonStart.setFixedHeight(self.sizeWidget)

            self.pushButtonDocumentation = wgt.PushButtonImage(margins=1, filename=vrb.folderImages + '/Interrogation.png')
            self.pushButtonDocumentation.setStyleSheet("background-color : transparent; border :0px")
            self.pushButtonDocumentation.setFixedSize(20 * vrb.ratio, 20 * vrb.ratio)
            self.pushButtonDocumentation.setToolTip(txt.dictToolTips["Documentation"])

            self.pushButtonPreview = wgt.PushButtonDoubleImage(vrb.folderImages + "/eye_close.png", vrb.folderImages + "/eye_open.png")
            self.pushButtonPreview.setFixedSize(self.sizeButtons,self.sizeButtons)
            self.pushButtonPreview.setToolTip("Preview")
            #self.pushButtonPreview = qt.QPushButton('Preview')
            #self.pushButtonPreview.setFixedHeight(self.sizeWidget)
            #self.pushButtonPreview.setCheckable(True)
            self.pushButtonPreview.setEnabled(oneOutputIsPreviewable)

            self.pushButtonRefresh = wgt.PushButtonImage(vrb.folderImages + '/Refresh.png', margins=2)
            self.pushButtonRefresh.setFixedSize(self.sizeButtons,self.sizeButtons)
            self.pushButtonRefresh.setToolTip(txt.dictToolTips["RefreshPreview"])

            self.labelImageArrow = wgt.LabelImage(vrb.folderImages + "/Arrow_Down_With_Margins.png")
            self.labelImageArrow.setFixedSize(50 * vrb.ratio, 20 * vrb.ratio)

            self.separator = qt.QFrame()
            self.separator.setFrameShape(qt.QFrame.HLine)  # Ligne horizontale
            self.separator.setFrameShadow(qt.QFrame.Sunken)
            # self.separator.setStyleSheet("background-color: rgb(220,220,220);")  # Couleur personnalisée
            self.separator.setStyleSheet("""
                background: qlineargradient(
                    spread:pad, x1:0, y1:0, x2:0, y2:1,
                    stop:0 rgb(50, 50, 50),  /* Couleur claire en haut */
                    stop:0.5 rgb(220, 220, 220),      /* Couleur foncée au milieu */
                    stop:1 rgb(50, 50, 50)   /* Couleur claire en bas */
                );
            """)
            self.separator.setFixedSize(160 * vrb.ratio, 2)  # Épaisseur du trait

            # emptyLabel = qt.QLabel()

            # Layout
            self.layout = qt.QGridLayout()
            if self.isMacro() and vrb.isRunTime == False:
                layoutButtonsTop = qt.QGridLayout()
                layoutButtonsTop.setAlignment(Qt.AlignRight)
                self.pushButtonEditMacro = wgt.PushButtonImage(vrb.folderImages + '/Edit.png', margins=2)
                self.pushButtonEditMacro.setToolTip(txt.dictToolTips["EditMacro"])
                self.pushButtonEditMacro.setFixedSize(self.sizeWidget, self.sizeWidget)
                self.pushButtonEditMacro.clicked.connect(self.editMacro)

                self.pushButtonDeleteMacro = wgt.PushButtonImage(vrb.folderImages + '/Delete_Macro.png', margins=2)
                self.pushButtonDeleteMacro.setToolTip(txt.dictToolTips["DeleteMacro"])
                self.pushButtonDeleteMacro.setFixedSize(self.sizeWidget, self.sizeWidget)
                self.pushButtonDeleteMacro.clicked.connect(self.preDeleteMacro)

                self.pushButtonExportMacro = wgt.PushButtonImage(vrb.folderImages + '/Export_Macro.png', margins=2)
                self.pushButtonExportMacro.setToolTip(txt.dictToolTips["ExportMacro"])
                self.pushButtonExportMacro.setFixedSize(self.sizeWidget, self.sizeWidget)
                self.pushButtonExportMacro.clicked.connect(self.exportMacro)

                # layoutButtonsTop.addWidget(self.pushButtonEditMacro, 0, layoutButtonsTop.columnCount(), Qt.AlignRight)
                layoutButtonsTop.addWidget(self.pushButtonEditMacro, 0, layoutButtonsTop.columnCount())
                layoutButtonsTop.addWidget(self.pushButtonDeleteMacro, 0, layoutButtonsTop.columnCount())
                layoutButtonsTop.addWidget(self.pushButtonExportMacro, 0, layoutButtonsTop.columnCount(), Qt.AlignLeft)
                # layoutButtonsTop.addWidget(self.pushButtonExportMacro, 0, layoutButtonsTop.columnCount())
                layoutButtonsTop.addWidget(self.pushButtonDocumentation, 0, layoutButtonsTop.columnCount(),Qt.AlignRight)
                layoutButtonsTop.setHorizontalSpacing(5)
                self.layout.addLayout(layoutButtonsTop, 0, 0, 1, 3)
            else:
                self.layout.addWidget(self.pushButtonDocumentation, 0, 2, Qt.AlignRight)
            row = 1
            # font = QtGui.QFont()
            # font.setPixelSize(50 * vrb.ratio)
            # font.setBold(True)

            emptyLabel1 = qt.QLabel()
            emptyLabel1.setFixedWidth(40*vrb.ratio)
            emptyLabel2 = qt.QLabel()
            emptyLabel2.setFixedWidth(40*vrb.ratio)
            emptyLabel3 = qt.QLabel()
            emptyLabel3.setFixedWidth(40*vrb.ratio)

            for item in self.parameters.values():
                if item['Label'] is not None:
                    item['Label'].setStyleSheet("QLabel {color:rgb(200, 220, 240);}")
                    item['Label'].setFixedHeight(self.sizeWidget)
                    # item['Label'].setFont(font)
                    self.layout.addWidget(emptyLabel1, row, 0)
                    # self.layout.addWidget(item['Label'], row, 0, Qt.AlignHCenter)
                    self.layout.addWidget(item['Label'], row, 1, Qt.AlignLeft)
                    # self.layout.addWidget(item['Widget'], row, 1, Qt.AlignHCenter)
                    self.layout.addWidget(item['Widget'], row, 2, Qt.AlignLeft)
                else:
                    self.layout.addWidget(item['Widget'], row, 0, 1, 3, Qt.AlignHCenter)
                row += 1

            self.layout.setRowMinimumHeight(row, 15*vrb.ratio)  # Ajoute 20 pixels d'espace après la ligne
            row += 1
            # self.layout.addWidget(self.labelImageArrow, row, 0,Qt.AlignHCenter)
            self.layout.addWidget(emptyLabel2, row, 0)
            self.layout.addWidget(self.labelImageArrow, row, 1,Qt.AlignLeft)
            self.layout.addWidget(self.separator, row, 2,Qt.AlignLeft)
            row += 1
            self.layout.setRowMinimumHeight(row, 15*vrb.ratio)  # Ajoute 20 pixels d'espace après la ligne
            row += 1

            for item in self.outputs.values():
                # item['Label'].setStyleSheet("QLabel {color:rgb(240, 200, 200);}")
                item['Label'].setStyleSheet("QLabel {color:rgb(200, 240, 200);}")
                item['Label'].setFixedHeight(self.sizeWidget)
                # item['Label'].setFont(font)
                # self.layout.addWidget(item['Label'], row, 0, Qt.AlignHCenter)
                self.layout.addWidget(emptyLabel3, row, 0)
                self.layout.addWidget(item['Label'], row, 1, Qt.AlignLeft)
                # self.layout.addWidget(item['Widget'], row, 1, Qt.AlignHCenter)
                self.layout.addWidget(item['Widget'], row, 2, Qt.AlignLeft)
                row += 1

            layoutButtonsBottom = qt.QGridLayout()
            layoutButtonsBottom.setAlignment(Qt.AlignRight)
            layoutButtonsBottom.setHorizontalSpacing(20)
            layoutButtonsBottom.setContentsMargins(0,0,0,0)
            layoutButtonsBottom.addWidget(self.pushButtonBatch, 0, 0)
            layoutButtonsBottom.addWidget(self.pushButtonRefresh, 0, 1)
            layoutButtonsBottom.addWidget(self.pushButtonPreview, 0, 2)
            layoutButtonsBottom.addWidget(self.pushButtonStart, 0, 3)

            groupBoxButtonsBottom = qt.QGroupBox()
            groupBoxButtonsBottom.setLayout(layoutButtonsBottom)

            # self.layout.addLayout(layoutButtonsBottom, row, 0, 1, 2)
            self.layout.addWidget(groupBoxButtonsBottom, row, 1, 1, 2)
            self.setLayout(self.layout)
            self.pushButtonRefresh.setVisible(False)

            self.layout.setVerticalSpacing(self.spacing)
            self.layout.setContentsMargins(self.margins, self.margins, self.margins, self.margins)

            self.pushButtonBatch.clicked.connect(self.emitSignalBatch)
            self.pushButtonStart.clicked.connect(self.emitSignalProcess)
            self.pushButtonDocumentation.clicked.connect(self.showDocumentation)
            self.pushButtonPreview.clicked.connect(self.emitSignalPreviewClicked)
            self.pushButtonRefresh.clicked.connect(self.emitSignalPreviewRefresh)
            self.changeHeight()

            if self.title == "Label to Measure":
                self.parameters[2]['Widget'].clear()
                self.parameters[1]['Widget'].currentIndexChanged.connect(self.labelToMeasure)

            if self.title == "Histogram of Measure":
                self.parameters[1]['Widget'].clear()
                self.parameters[0]['Widget'].currentIndexChanged.connect(self.labelToMeasure)

            if self.title in ["Shape filtering 2D", "Shape filtering 3D"]:

                try:
                    comboBoxWidget = self.parameters[2]["Widget"].comboBoxEnum.itemData(0)["Parameters"][0]["Widget"]
                    comboBoxWidget.currentIndexChanged.connect(self.changeFilterEdit)
                    textEditWidget = self.parameters[2]["Widget"].comboBoxEnum.itemData(0)["Parameters"][1]["Widget"]
                    textEditWidget.setEnabled(False)
                except:
                    pass

                # self.parameters[1]['Widget'].currentIndexChanged.connect(self.labelToMeasure)

    def changeFilterEdit(self):

        try:
            comboBoxWidget = self.parameters[2]["Widget"].comboBoxEnum.itemData(0)["Parameters"][0]["Widget"]
            textEditWidget = self.parameters[2]["Widget"].comboBoxEnum.itemData(0)["Parameters"][1]["Widget"]
            formula = comboBoxWidget.itemData(comboBoxWidget.currentIndex())
            if formula is not None:
                textEditWidget.setText(formula)
            else:
                textEditWidget.setText("")

        except:
            pass

    def labelToMeasure(self):

        try:
            if self.title == "Label to Measure":
                measureElement = self.parameters[1]['Widget'].currentData()
                listName = self.parameters[2]['Widget']
            if self.title == "Histogram of Measure":
                measureElement = self.parameters[0]['Widget'].currentData()
                listName = self.parameters[1]['Widget']
            listName.clear()

            allMeasures = None
            parametersNode = Dfct.SubElement(Dfct.SubElement(measureElement, 'FunctionCall'), 'Parameters')
            for param in parametersNode:
                valueNode = Dfct.SubElement(param, 'Value')
                for elem in valueNode:
                    if elem.tag == 'AllMeasures':
                        allMeasures = elem

            if allMeasures is not None:
                for callName, userName in self.measureIterator(allMeasures):
                    #userName = Dfct.childText(measureNode, 'UserName')
                    listName.addItem(userName,callName)

            for index in range(listName.count()):
                if listName.itemData(index) == vrb.currentDataLabelToMeasure:
                    listName.setCurrentIndex(index)

        except:
            pass

    def measureIterator(self,xmlAllMeasures):
        # iterator through all checked measures
        for child in xmlAllMeasures:
            if child.tag == 'Custom':
                # Custom measures
                for child2 in child:
                    if child2.tag == 'Arithmetic':
                        prefix = "Custom_A_"
                    elif child2.tag == 'Logic':
                        prefix = "Custom_L_"
                    for measureNode in Dfct.childIterator(child2, 'Measure'):
                        if measureNode.get('CheckState') == '2':
                            ipsdkCallName = prefix + Dfct.childText(measureNode, 'UserName').replace(" ","")
                            userName = Dfct.childText(measureNode, 'UserName')

                            yield ipsdkCallName, userName
            else:
                # Classic measures
                for measureNode in Dfct.childIterator(child, 'Measure'):
                    if measureNode.get('CheckState') == '2':
                        ipsdkCallName = Dfct.childText(Dfct.SubElement(measureNode, "Object"), 'Name')
                        userName = Dfct.childText(measureNode, 'UserName')
                        yield ipsdkCallName, userName

    def editMacro(self):

        if self.editScriptWindow is None:
            self.editScriptWindow = EditScriptWindow(self.xmlFunctionDescription)

        self.editScriptWindow.SignalReloadFunctionsSpoiler.connect(self.emitSignalReloadFunctionsSpoiler)

        if Dfct.SubElement(self.xmlFunctionDescription, 'Favorite').text == "True":
            self.editScriptWindow.groupParameters.checkBoxFavorite.setChecked(True)
        else:
            self.editScriptWindow.groupParameters.checkBoxFavorite.setChecked(False)
        fct.showWidget(self.editScriptWindow)
        # self.editScriptWindow.show()

    def preDeleteMacro(self):

        messageBox = wgt.MessageBox('Are you sure you want to delete '+ Dfct.childText(self.xmlFunctionDescription, 'Name') +'?', '', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No], icon=qt.QMessageBox.Warning)
        res = messageBox.exec()
        if res == qt.QMessageBox.Yes:
            self.deleteMacro()

    def deleteMacro(self):
        try:
            self.spoiler.emitSignalSetSpoilerExpand(None)
            vrb.mainWindow.graphicElements.stopPreviewMode()
            functionPath = vrb.folderFunctions + '/' + Dfct.childText(self.xmlFunctionDescription, 'PythonName')

            pythonNameSplit = Dfct.childText(self.xmlFunctionDescription, 'PythonName').split("/")
            moduleName = pythonNameSplit[0]

            os.remove(functionPath+".py")
            os.remove(functionPath+".mho")
            vrb.mainWindow.reloadAllFunctionsSpoilers(moduleName)

        except:
            traceback.print_exc(file=sys.stderr)

    def exportMacro(self):

        try:
            try:
                file = xmlet.parse(vrb.folderInformation + "/folderMacroExport.mho")
                self.folderMacroExportElement = file.getroot()
            except:
                self.folderMacroExportElement = xmlet.Element('folderMacroExport')

            path = Dfct.childText(self.folderMacroExportElement, "Path")
            if path is not None:
                defaultFolder = path
            else:
                defaultFolder = "C:/"

            filenameExport = qt.QFileDialog.getExistingDirectory(self, "Select the folder to export your macro", defaultFolder)

            if filenameExport != '' and filenameExport != None:
                Dfct.SubElement(self.folderMacroExportElement, "Path").text = filenameExport
                Dfct.saveXmlElement(self.folderMacroExportElement, vrb.folderInformation + "/folderMacroExport.mho")

                functionPath = vrb.folderFunctions + '/' + Dfct.childText(self.xmlFunctionDescription, 'PythonName')
                basename = os.path.basename(functionPath)

                print('export macro',functionPath,basename)

                copyfile(functionPath+".py", filenameExport + "/" + basename + ".py")
                copyfile(functionPath+".mho", filenameExport + "/" + basename + ".mho")

        except:
            traceback.print_exc(file=sys.stderr)

    def emitSignalReloadFunctionsSpoiler(self):
        self.SignalReloadFunctionsSpoiler.emit()

    def emitSignalPreviewClicked(self):

        self.pushButtonPreview.changeActivation()

        #self.pushButtonRefresh.setVisible(self.pushButtonPreview.isChecked())
        self.pushButtonRefresh.setVisible(self.pushButtonPreview.activate)
        self.SignalPreviewClicked.emit()

    def emitSignalPreviewRefresh(self):
        self.SignalPreviewRefresh.emit()

    def changeHeight(self):
        totalHeight = 2 * self.margins + 80*vrb.ratio
        totalHeight += self.sizeWidget  # buttons at the bottom
        totalHeight += self.pushButtonDocumentation.height() + self.spacing
        for item in self.parameters.values():
            totalHeight += item['Widget'].height() + self.spacing

        for item in self.outputs.values():
            totalHeight += item['Widget'].height() + self.spacing

        self.setFixedHeight(totalHeight)
        self.SignalHeightChanged.emit()

    def loadXmlElements(self, xmlAllElements, positionSelectedLabel, listComboBoxesIndex):

        self.initFunction()

        fctWidget.loadXmlElements(self.parameters, xmlAllElements, positionSelectedLabel, listComboBoxesIndex)

    def emitSignalSelectionComboBoxChanged(self):
        self.SignalSelectionComboBoxChanged.emit()

    def isMacro(self):
        return Dfct.childText(self.xmlFunctionDescription, 'FunctionName') == 'MacroFunction'


    def createXmlElement(self):
        """
        fills its own attribute xmlParametersProcess with a FunctionCall
        It recaps every parameter in the interface
        """
        self.xmlParametersProcess = xmlet.Element('FunctionCall')
        Dfct.SubElement(self.xmlParametersProcess, 'Name').text = Dfct.childText(self.xmlFunctionDescription, 'FunctionName')
        Dfct.SubElement(self.xmlParametersProcess, 'PythonName').text = Dfct.childText(self.xmlFunctionDescription, 'PythonName')
        Dfct.SubElement(self.xmlParametersProcess, 'ProcessName').text = Dfct.childText(self.xmlFunctionDescription, 'ProcessName')
        # Parameters
        xmlParameters = Dfct.SubElement(self.xmlParametersProcess, 'Parameters')
        parametersDescription = Dfct.SubElement(self.xmlFunctionDescription, 'Parameters')
        for nb, param in enumerate(self.parameters.values(), 0):
            paramValueNode = param['Widget'].interfaceToXml(nb)
            if Dfct.childText(paramValueNode, 'Value') is None:
                paramDesc = Dfct.SubElement(parametersDescription, 'Parameter_' + str(nb))
                defaultValue = Dfct.childText(paramDesc, 'Default')
                if defaultValue is None:
                    defaultValue = 0
                if defaultValue is not None:
                    if param['Type'] == WidgetTypes.InputType.ENUM:
                        Dfct.SubElement(paramValueNode, 'Value').text = param['Widget'].widget.itemData(int(defaultValue))
                    else:
                        Dfct.SubElement(paramValueNode, 'Value').text = str(defaultValue)
            xmlParameters.append(paramValueNode)

        # Outputs
        xmlOutputs = Dfct.SubElement(self.xmlParametersProcess, 'Outputs')
        for nb, output in enumerate(self.outputs.values(), 0):
            outputValueNode = output['Widget'].interfaceToXml(nb)
            xmlOutputs.append(outputValueNode)

    def emitSignalProcess(self):
        self.SignalProcess.emit(self)

    def emitSignalBatch(self):
        self.SignalBatch.emit(self)

    def enableAllParameters(self):
        for param in self.parameters.values():
            param['Widget'].setEnabled(True)

    def showDocumentation(self):

        try:
            """
            Opens a tab on the default browser with the doc
            If the docPath has not been set, shows the module page
            """
            docTitle = Dfct.childText(self.xmlFunctionDescription, 'DocTitle')
            docPath = vrb.dictLinks[docTitle]

            nameFunction = Dfct.childText(self.xmlFunctionDescription, 'Name')

            docFound = False
            if docPath is not None:
                if nameFunction in ["Extract Channel","Extract Plan","Create Image"]:
                    pagePath = vrb.folderDocEssential + '/IPSDKCore_' + docPath
                else:
                    pagePath = vrb.folderDocEssential + '/' + docPath

                if os.path.exists(pagePath):
                    docFound=True
                    webbrowser.open_new_tab(pagePath)
            if docFound == False:
                print('Documentation not available, opening first doc page', file=sys.stderr)
                pagePath = vrb.folderDocEssential + '/algorithms.html'
                if os.path.exists(pagePath):
                    webbrowser.open_new_tab(pagePath)
                else:
                    print('Documentation not available, no page found', file=sys.stderr)

        except:
            traceback.print_exc(file=sys.stderr)

    # def showDocumentation(self):
    #     """
    #     Opens a tab on the default browser with the doc
    #     If the docPath has not been set, shows the module page
    #     """
    #     functionName = Dfct.childText(self.xmlFunctionDescription, 'FunctionName')
    #     docPath = Dfct.childText(vrb.docFunctionsElement, functionName)
    #
    #     # docPath = Dfct.childText(self.xmlFunctionDescription, 'DocPath')
    #
    #     nameFunction = Dfct.childText(self.xmlFunctionDescription, 'Name')
    #
    #     docFound = False
    #     if docPath is not None:
    #         if nameFunction in ["Extract Channel","Extract Plan","Create Image"]:
    #             pagePath = vrb.folderDocEssential + '/IPSDKCore_' + docPath
    #         else:
    #             pagePath = vrb.folderDocEssential + '/' + docPath
    #         if os.path.exists(pagePath):
    #             docFound=True
    #             webbrowser.open_new_tab(pagePath)
    #     if docFound == False:
    #         print('Documentation not available, opening first doc page', file=sys.stderr)
    #         pagePath = vrb.folderDocEssential + '/algorithms.html'
    #         if os.path.exists(pagePath):
    #             webbrowser.open_new_tab(pagePath)
    #         else:
    #             print('Documentation not available, no page found', file=sys.stderr)

    def emitSignalSelector(self, selector, start, validate):
        for param in self.parameters.values():
            if param['Widget'] != selector:
                param['Widget'].setEnabled(not start)
        self.SignalSelector.emit(selector, start, validate)

class FunctionSpoiler(Spoiler):

    def __init__(self, xmlFunctionDescription):

        self.xmlFunctionDescription = xmlFunctionDescription

        title = Dfct.childText(self.xmlFunctionDescription, 'Name')
        favorite = Dfct.childText(self.xmlFunctionDescription, 'Favorite') == "True"

        widget = FunctionWidget(self.xmlFunctionDescription)
        super().__init__(widget=widget, title=title, favorite=favorite)

        if favorite:
            self.doubleLabelHeader.buttonFavorite.setActivation(True)

        widget.SignalHeightChanged.connect(self.changeHeight)
        self.doubleLabelHeader.buttonFavorite.clicked.connect(self.changeFavorite)

    def changeFavorite(self):

        self.doubleLabelHeader.buttonFavorite.changeActivation()
        Dfct.SubElement(self.xmlFunctionDescription, 'Favorite').text = str(self.doubleLabelHeader.buttonFavorite.activate)
        try:
            savePath = Dfct.SubElement(self.xmlFunctionDescription, 'SavePath').text
            Dfct.saveXmlElement(self.xmlFunctionDescription,savePath)
        except:
            import traceback
            traceback.print_exc(file=sys.stderr)

class FunctionSpoilersContainer(SpoilersContainer):
    def __init__(self, folder, parent=None):
        super().__init__()
        self.folder = folder
        self.parent = parent  # parent is a CategorySpoiler
        self.initSpoiler()

    def initSpoiler(self):

        while self.layout.count() != 0:
            item = self.layout.itemAt(0)
            if item is not None:
                item.widget().deleteLater()
                self.layout.removeItem(item)

        listName = []
        dictXmlElement = {}

        for fileName in sorted(os.listdir(self.folder),key=str.casefold):
            filePath = self.folder + '/' + fileName
            if str.endswith(filePath, '.mho'):
                file = xmlet.parse(filePath)
                xmlFunctionDesc = file.getroot()
                Dfct.SubElement(xmlFunctionDesc, 'SavePath').text = filePath
                verif = True
                if Dfct.childText(xmlFunctionDesc,"FunctionName") == "MacroFunction":
                    favorite = Dfct.childText(xmlFunctionDesc, "Favorite")
                    if favorite != "False":
                        Dfct.SubElement(xmlFunctionDesc, "Favorite").text = "True"
                        Dfct.saveXmlElement(xmlFunctionDesc,filePath)

                    name,extension = os.path.splitext(fileName)
                    Dfct.SubElement(xmlFunctionDesc,"Name").text = name
                    Dfct.SubElement(xmlFunctionDesc,"PythonName").text = os.path.basename(self.folder) + "/" + name

                    verif = self.verifNameMacro(name)
                if verif:
                    name = Dfct.childText(xmlFunctionDesc,"Name")
                    listName.append(name)
                    dictXmlElement[name] = xmlFunctionDesc

        listName.sort()
        for name in listName:
            xmlFunctionDesc = dictXmlElement[name]
            spoiler = FunctionSpoiler(xmlFunctionDesc)
            if Dfct.childText(xmlFunctionDesc,"FunctionName") == "MacroFunction":
                vrb.dictMacros[Dfct.SubElement(xmlFunctionDesc,"PythonName").text] = spoiler
            self.addSpoiler(spoiler)
            self.addToDictCompleter(self.parent, spoiler, xmlFunctionDesc)

        self.changeHeight()

    def verifNameMacro(self,name):

        verif = True
        for fileName in sorted(os.listdir(self.folder),key=str.casefold):
            filePath = self.folder + '/' + fileName
            if str.endswith(filePath, '.mho'):
                file = xmlet.parse(filePath)
                xmlFunctionDesc = file.getroot()
                if Dfct.childText(xmlFunctionDesc, "FunctionName") != "MacroFunction":
                    if Dfct.childText(xmlFunctionDesc,"Name") == name:
                        verif=False

        return verif

    def addToDictCompleter(self, categorySpoiler, spoiler, xmlFunctionDesc):
        userName = None
        tags = None
        for child in xmlFunctionDesc:
            if child.tag == 'Name':
                userName = child.text
            elif child.tag == 'Tags':
                tags = child.text
        spoilersPath = [categorySpoiler, spoiler]

        if tags is not None:
            for tag in tags.split(','):
                searchBox.dictCompleter[tag] = spoilersPath
        elif userName is not None:
            searchBox.dictCompleter[userName] = spoilersPath
            for name in fct.createListNameForCompleter(userName):
                searchBox.dictCompleter[name] = spoilersPath
        else:
            print('ERROR: Failed to create a search shortcut for completer.', file=sys.stderr)

    def changeDisplayedFunctions(self):

        dimension = (WidgetTypes.FunctionDimension.TWO_DIMENSIONS, WidgetTypes.FunctionDimension.THREE_DIMENSIONS, WidgetTypes.FunctionDimension.BOTH)[vrb.mainWindow.groupBoxSelectionDimension.buttonGroup.checkedId()]
        favoriteChecked = vrb.mainWindow.checkBoxFavorite.isChecked()

        for nb in range(self.layout.count()):
            item = self.layout.itemAt(nb)
            if item is not None:
                spoiler = item.widget()  # spoiler
                functionWidget = spoiler.widget  # functionWidget
                xmlFunctionDesc = functionWidget.xmlFunctionDescription
                if dimension == WidgetTypes.FunctionDimension.BOTH:
                    if favoriteChecked and Dfct.childText(xmlFunctionDesc, 'Favorite') != "True"and not spoiler.widget.isVisible():
                        # if spoiler.widget.isVisible():
                        #     spoiler.emitSignalHeaderClicked(None)
                        spoiler.setVisible(False)
                        spoiler.shouldBeDisplayed = False
                    else:
                        spoiler.shouldBeDisplayed = True
                        spoiler.setVisible(True)
                        if (spoiler.widget.isVisible() or spoiler.isExpanded) and spoiler != self.currentWidget:
                            spoiler.expand(forceEvent="Close")
                    self.addToDictCompleter(self.parent, spoiler, xmlFunctionDesc)
                else:
                    macroVerifDimension = False
                    if xmlFunctionDesc.get('Dimension') is None:
                        macroVerifDimension = True
                        if (dimension.value == "2D" and ("3d" in spoiler.title or "3D" in spoiler.title)) or (dimension.value == "3D" and ("2d" in spoiler.title or "2D" in spoiler.title)):
                            macroVerifDimension = False

                    if xmlFunctionDesc.get('Dimension') == dimension.value or xmlFunctionDesc.get('Dimension') == WidgetTypes.FunctionDimension.BOTH.value or macroVerifDimension:
                        if favoriteChecked and Dfct.childText(xmlFunctionDesc, 'Favorite') != "True" and not spoiler.widget.isVisible():
                            # if spoiler.widget.isVisible():
                            #     spoiler.emitSignalHeaderClicked(None)
                            spoiler.setVisible(False)
                            spoiler.shouldBeDisplayed = False
                        else:
                            spoiler.shouldBeDisplayed = True
                            spoiler.setVisible(True)
                            if (spoiler.widget.isVisible() or spoiler.isExpanded) and spoiler != self.currentWidget:
                                spoiler.expand(forceEvent="Close")
                        self.addToDictCompleter(self.parent, spoiler, xmlFunctionDesc)
                    else:
                        if spoiler.widget.isVisible():
                            spoiler.emitSignalHeaderClicked(None)
                        spoiler.setVisible(False)
                        spoiler.shouldBeDisplayed = False
        self.changeHeight()



