import sys, traceback
import os

from PyQt5.QtCore import pyqtSignal, QPointF, Qt, QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import WidgetTypes

import xml.etree.ElementTree as xmlet

from SpoilerWidget import Spoiler, SpoilersContainer
from InterfaceFunction import FunctionSpoilersContainer
from FunctionsDictionary import dictFolderNames

import UsefullVariables as vrb
import DatabaseFunction as Dfct


class CategoryScrollArea(qt.QScrollArea):

    def __init__(self):
        qt.QScrollArea.__init__(self)

        self.setWidgetResizable(True)
        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)

        self.centralWidget = CategorySpoilersContainer(vrb.folderFunctions)

        self.setWidget(self.centralWidget)

class CategorySpoilersContainer(SpoilersContainer):

    SignalCurrentFunctionChanged = pyqtSignal()

    def __init__(self, folder):
        super().__init__()

        self.currentFunction = None

        # To have more folders, add a for loop here
        for fileName in sorted(os.listdir(folder),key=str.casefold):
            filePath = folder + '/' + fileName

            if vrb.isRunTime == False or fileName not in ["AdvMorphology","Arithmetic","BasicMorphology","Binarization","Classification","ColorOperation","FeatureDetection","Filtering","Geometric",
                "GlobalMeasure","IntensityTransformation","Logical","Registration","ShapeAnalysis","ShapeSegmentation","Statistics","Utility"]:
                if os.path.isdir(filePath):
                    spoiler = CategorySpoiler(filePath)
                    self.addSpoiler(spoiler)
                    spoiler.SignalWidgetChanged.connect(self.emitSignalCurrentFunctionChanged)
        self.SignalWidgetChanged.connect(self.emitSignalCurrentFunctionChanged)

        self.setStyleSheet('CategorySpoilersContainer {border: 0px transparent; }')

        self.changeHeight()

    def emitSignalCurrentFunctionChanged(self):

        self.SignalCurrentFunctionChanged.emit()

    def changeCurrentFunction(self):

        try:
            if self.currentWidget is None:
                self.currentFunction = None
            else:
                # currentFunction is of type FunctionWidget
                if self.currentWidget.widget.currentWidget is None:
                    self.currentFunction = None
                else:
                    try:
                        file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
                        settingsElement = file.getroot()
                    except:
                        settingsElement = xmlet.Element('Settings')
                    fontProcessFunctionsElement = Dfct.SubElement(settingsElement, "FontProcessFunctions")
                    font = QtGui.QFont()
                    try:
                        font.setPointSize(int(fontProcessFunctionsElement.text))
                    except:
                        font.setPointSize(10)

                    self.currentFunction = self.currentWidget.widget.currentWidget.widget
                    self.currentFunction.initFunction()
                    for param in self.currentFunction.parameters.values():
                        try:
                            if param["Type"] == WidgetTypes.InputType.SELECTOR:
                                param['Label'].setFont(font)
                                if param['Widget'].selectorNode == "SimpleRangeSelector":
                                    param['Widget'].groupBoxSelector.lineEdit.setFont(font)
                                if param['Widget'].selectorNode == "RangeSelector":
                                    param['Widget'].groupBoxSelector.checkBoxMin.setFont(font)
                                    param['Widget'].groupBoxSelector.lineEditMin.setFont(font)
                                    param['Widget'].groupBoxSelector.checkBoxMax.setFont(font)
                                    param['Widget'].groupBoxSelector.lineEditMax.setFont(font)

                            if param["Type"] != WidgetTypes.InputType.ADVANCED:
                                param['Label'].setFont(font)
                                param['Widget'].setFont(font)
                        except:
                            traceback.print_exc(file=sys.stderr)

                    for outputParam in self.currentFunction.outputs.values():
                        # Reset output names
                        outputParam['Widget'].setText('')
                        outputParam['Label'].setFont(font)
                        outputParam['Widget'].setFont(font)
        except:
            traceback.print_exc(file=sys.stderr)

    def changeDisplayedFunctions(self):

        for nb in range(self.layout.count()):
            item = self.layout.itemAt(nb)
            if item is not None:
                widget = item.widget()
                widget.widget.changeDisplayedFunctions()


class CategorySpoiler(Spoiler):

    SignalWidgetChanged = pyqtSignal()

    def __init__(self, folder):
        x = folder.split('/')
        title = x[len(x) - 1]
        if title in dictFolderNames:
            title = dictFolderNames[title]

        functionSpoilersContainer = FunctionSpoilersContainer(folder, self)

        super().__init__(widget=functionSpoilersContainer, title=title)
        self.margins = 0
        self.spacing = 0
        self.setContentsMargins(self.margins, self.margins, self.margins, self.margins)
        self.layout.setVerticalSpacing(self.spacing)
        functionSpoilersContainer.SignalWidgetChanged.connect(self.emitSignalWidgetChanged)
        font = self.doubleLabelHeader.label.font()
        font.setBold(True)
        # font.setPixelSize(10*vrb.ratio)
        self.doubleLabelHeader.label.setFont(font)
        self.doubleLabelHeader.labelCollapse.setFont(font)
        functionSpoilersContainer.SignalHeightChanged.connect(self.changeHeight)

    def emitSignalWidgetChanged(self):
        self.SignalWidgetChanged.emit()
