import os
import sys

from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal, QPointF, Qt, QCoreApplication

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans

import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLColor as colorIP
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLLogical as logic

import PyIPSDK.IPSDKUI as ui

import webbrowser

import numpy
import UsefullTexts as txt

import UsefullVariables as vrb
import UsefullWidgets as wgt
import UsefullFunctions as fct
import DatabaseFunction as Dfct

import napari
from napari.qt import QtViewer

import time
import traceback

from Sliders import SimpleHorizontalSliderLabel
from RangeSlider import RangeSlider
from LutsWidget import lutJet, lutProba, LutInformations,lutBinaryRedVector


class ImageViewer(qt.QGraphicsView):
    signalZoomFactorChanged = pyqtSignal()
    signalMouseMoved = pyqtSignal(float, float)
    signalNewImage = pyqtSignal(list)
    signalEmitMouse = pyqtSignal(dict,qt.QGraphicsView)
    signalEmitKey = pyqtSignal(int)

    def __init__(self, scene, widgetImage=None, parent=None):
        qt.QGraphicsView.__init__(self)

        self.widgetImage = widgetImage
        self.parent = parent
        self.index = None

        self.standAlone = False

        self.allowResize = True

        self.ctrlPressed = False

        self.currentButtonPressed = None

        self.setMouseTracking(True)
        self.setAcceptDrops(True)

        self.image = None
        self.imageOverlay = None
        self.imageDraw = None
        self.imageSuperPixels = None
        self.imageProbabilities = None
        self.imageThreshold = None
        self.zoomFactor = 1
        self.mousePressed = False
        self.minZoomFactor = 1
        self.maxZoomFactor = 100
        self.currentZoom = 1
        self.directionnalArrows = True

        self.realStartPointX = 0
        self.realStartPointY = 0
        self.refPosX = None
        self.refPosY = None
        self.roiImage = None
        self.roiImageToAdd = None

        self.minimumSize = 2000 * vrb.ratio

        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)

        self.scene = scene
        self.setScene(scene)

        self.setContentsMargins(0, 0, 0, 0)

    def resizeEvent(self, event):

        try:
            if self.image != None and self.image[0].isInit() and self.allowResize:
                self.correctRealStartPoint()
                self.getRoiImage()
        except:
            traceback.print_exc(file=sys.stderr)

    # 3 fonctions pour gérer le drag and drop
    def dragEnterEvent(self, event):

        if event.mimeData().hasUrls:
            event.accept()
        else:
            event.ignore()

    def dragMoveEvent(self, event):

        if event.mimeData().hasUrls:
            event.accept()
        else:
            event.ignore()

    def dropEvent(self, event):

        if event.mimeData().hasUrls:
            urls = event.mimeData().urls()
            self.signalNewImage.emit(urls)

    def wheelEvent(self, event, params=None):

        try:
            is3D = vrb.mainWindow.currentLabel.image.getSizeZ() > 1
        except:
            is3D = False
        # if (self.widgetImage.image.getSizeZ() > 1 or self.widgetImage.image.getSizeT() > 1) and self.ctrlPressed:
        if is3D and self.ctrlPressed:

            steps = event.angleDelta().y() / 120.0
            if self.widgetImage.image.getSizeZ() > 1:
                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                    self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.setValue(self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value() + steps)
                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                    self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.setValue(self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value() + steps)
                if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                    self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.setValue(self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value() + steps)
            elif self.widgetImage.image.getSizeT() > 1:
                self.widgetImage.imageViewerStandAlone.sliderAxis.sliderSequence.slider.setValue(self.widgetImage.imageViewerStandAlone.sliderAxis.sliderSequence.slider.value() + steps)

        else:
            lineSelected = False

            try:
                graphicXmlElement = Dfct.SubElement(vrb.mainWindow.currentXmlElement, "GraphicXmlElement")
                if graphicXmlElement is not None:
                    allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")
                    for child in allLineMeasuresElement:
                        if vrb.mainWindow.graphicElements.currentPolygonSelected == child:
                            lineSelected = True
                            currentLine = child
            except:
                pass

            if lineSelected:

                pointSize = int(Dfct.childText(currentLine, "PointSize"))

                steps = event.angleDelta().y() / 120.0
                pointSize += steps

                pointSize = max(0, pointSize)

                pointSize = min(pointSize, 300)

                pointSizeElement = Dfct.SubElement(currentLine, "PointSize")
                pointSizeElement.text = str(int(pointSize))

                self.getRoiImage(changeRoiImage=False)
                # vrb.mainWindow.graphicElements.applyGraphicElement(self)

            else:
                # Zoom avec la molette
                if params == None:
                    realPointX, realPointY = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
                    steps = event.angleDelta().y() / 120.0
                else:
                    realPointX, realPointY = params[0], params[1]
                    steps = params[2]

                roiSizeXBefore, roiSizeYBefore = self.getRoiSize()
                if steps > 0:
                    self.zoomFactor *= (1 + steps * 0.3)
                    self.zoomFactor = min(self.zoomFactor, self.maxZoomFactor)
                if steps < 0:
                    self.zoomFactor /= (1 - steps * 0.3)
                    self.zoomFactor = max(self.zoomFactor, self.minZoomFactor)

                roiSizeX, roiSizeY = self.getRoiSize()

                self.realStartPointX = realPointX - ((roiSizeX) * (realPointX - self.realStartPointX) / roiSizeXBefore)
                self.realStartPointY = realPointY - ((roiSizeY) * (realPointY - self.realStartPointY) / roiSizeYBefore)
                self.correctRealStartPoint()

                self.getRoiImage()

        # except:
        #    traceback.print_exc(file=sys.stderr)

    # Gestion des signaux de la souris
    def mousePressEvent(self, event):

        self.currentButtonPressed = event.button()

        # self.viewport().setCursor(Qt.ClosedHandCursor)

        self.mousePressed = True
        self.refPosX = event.pos().x()
        self.refPosY = event.pos().y()

        ddict = {}
        ddict["CursorPosition"] = event.pos()
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "MousePressed"

        self.signalEmitMouse.emit(ddict, self)

    def mouseReleaseEvent(self, event):

        self.currentButtonPressed = None

        self.mousePressed = False
        self.viewport().setCursor(Qt.ArrowCursor)
        self.refPosX = None
        self.refPosY = None

        ddict = {}
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "Release"

        self.signalEmitMouse.emit(ddict, self)

    def mouseMoveEvent(self, event):

        if self.mousePressed and self.currentButtonPressed == 1 and self.standAlone:

            if self.refPosX != None and self.refPosY != None:
                roiSizeX, roiSizeY = self.getRoiSize()
                usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

                deltaX = event.pos().x() - self.refPosX
                deltaY = event.pos().y() - self.refPosY

                deltaX = deltaX * round(roiSizeX) / usefulSizeX
                deltaY = deltaY * round(roiSizeY) / usefulSizeY

                self.realStartPointX = self.realStartPointX - deltaX
                self.realStartPointY = self.realStartPointY - deltaY

                self.correctRealStartPoint()
                self.getRoiImage()

            self.refPosX = event.pos().x()
            self.refPosY = event.pos().y()

        realPointX, realPointY = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        self.signalMouseMoved.emit(realPointX, realPointY)

        ddict = {}
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "Move"

        self.signalEmitMouse.emit(ddict, self)

    def mouseDoubleClickEvent(self, event):

        ddict = {}
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "DoubleClick"

        self.signalEmitMouse.emit(ddict,self)

    # Gestion des touches du clavier
    def keyPressEvent(self, event):

        key = event.key()
        roiSizeX, roiSizeY = self.getRoiSize()

        # Ctrl
        if key == 16777249:
            self.ctrlPressed = True

        # Ctrl + c
        if key == 67:
            if self.ctrlPressed:

                vrb.mainWindow.copyToClipBoard()

                # pixmap = QtGui.QImage(self.scene.width(), self.scene.height(), QtGui.QImage.Format_ARGB32_Premultiplied)
                # painter = QtGui.QPainter()
                # painter.begin(pixmap)
                # # painter.setRenderHint(QtGui.QPainter.Antialiasing, True)
                # self.scene.render(painter)
                # painter.end()
                #
                # if self.parent != None:
                #     try:
                #         vrb.mainWindow.parent.clipboard.setImage(pixmap)
                #     except:
                #         traceback.print_exc(file=sys.stderr)

        # Ctrl + r
        if key == 82:
            try:
                vrb.mainWindow.buttonCropImage()
            except:
                pass

        if key == 90:
            if self.ctrlPressed:
                try:
                    vrb.mainWindow.beforeProcess()
                except:
                    pass

        if self.directionnalArrows:
            # 4 flèches directionnelles
            if key == 16777234:
                self.realStartPointX -= roiSizeX * 10 / 100
                self.getRoiImage()

            if key == 16777235:
                self.realStartPointY -= roiSizeY * 10 / 100
                self.getRoiImage()

            if key == 16777236:
                self.realStartPointX += roiSizeX * 10 / 100
                self.getRoiImage()

            if key == 16777237:
                self.realStartPointY += roiSizeY * 10 / 100
                self.getRoiImage()

        self.signalEmitKey.emit(key)

    def keyReleaseEvent(self, event):

        key = event.key()

        if key == 16777249:
            self.ctrlPressed = False

    def scenePointToRealPoint(self, pointX, pointY):

        # Passage des coordonnées dans la scène aux coordonnées réelles dans l'image

        roiSizeX, roiSizeY = self.getRoiSize()
        usefulSizeX, usefulSizeY = self.getUsefulSizeScene()
        uselessSizeX, uselessSizeY = self.getUselessSize()

        realPointX = round(self.realStartPointX) + (pointX * round(roiSizeX) / usefulSizeX) - uselessSizeX
        realPointY = round(self.realStartPointY) + (pointY * round(roiSizeY) / usefulSizeY) - uselessSizeY

        if self.image != None and self.image[0].isInit():
            realPointX = max(0, realPointX)
            realPointX = min(realPointX, self.image[0].getSizeX())
            realPointY = max(0, realPointY)
            realPointY = min(realPointY, self.image[0].getSizeY())

        return realPointX, realPointY

    def realPointToScene(self, pointX, pointY):

        # Passage des coordonnées réelles aux coordonnées dans la scène

        roiSizeX, roiSizeY = self.getRoiSize()
        usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

        # scenePointX = (pointX - self.realStartPointX) * usefulSizeX / round(roiSizeX)
        # scenePointY = (pointY - self.realStartPointY) * usefulSizeY / round(roiSizeY)

        scenePointX = (pointX - round(self.realStartPointX)) * usefulSizeX / round(roiSizeX)
        scenePointY = (pointY - round(self.realStartPointY)) * usefulSizeY / round(roiSizeY)

        return scenePointX, scenePointY

    def correctRealStartPoint(self):

        # Correction pour ne pas sortir de l'image

        roiSizeX, roiSizeY = self.getRoiSize()

        self.realStartPointX = max(0, self.realStartPointX)
        self.realStartPointY = max(0, self.realStartPointY)

        if self.image != None and self.image[0].isInit():
            self.realStartPointX = min(self.image[0].getSizeX() - round(roiSizeX), self.realStartPointX)
            self.realStartPointY = min(self.image[0].getSizeY() - round(roiSizeY), self.realStartPointY)

    def getRoiSize(self):

        try:
            # Calcul de la ROI à récupérer dans l'image
            if self.image != None and self.image[0].isInit() and self.width() != 0 and self.height() != 0:

                maxRatio = max(self.image[0].getSizeX() / self.width(), self.image[0].getSizeY() / self.height())
                ratioSizeX = maxRatio / (self.image[0].getSizeX() / self.width())
                ratioSizeY = maxRatio / (self.image[0].getSizeY() / self.height())

                roiSizeX = min(self.image[0].getSizeX(), (self.image[0].getSizeX() * ratioSizeX / self.zoomFactor))
                roiSizeY = min(self.image[0].getSizeY(), (self.image[0].getSizeY() * ratioSizeY / self.zoomFactor))
            else:
                roiSizeX = 1
                roiSizeY = 1

            return roiSizeX, roiSizeY
        except:
            traceback.print_exc(file=sys.stderr)

    def getUsefulSizeScene(self):

        # Calcul de la taille utile dans la QGraphicScene

        roiSizeX, roiSizeY = self.getRoiSize()
        maxConversionFactor = min(self.width() / roiSizeX, self.height() / roiSizeY)
        conversionFactorX = (self.width() / roiSizeX) / maxConversionFactor
        conversionFactorY = (self.height() / roiSizeY) / maxConversionFactor

        usefulSizeX = self.width() / conversionFactorX
        usefulSizeY = self.height() / conversionFactorY

        return usefulSizeX, usefulSizeY

    def getUselessSize(self):

        # Calcul de la taille inutile dans la QGraphicScene

        roiSizeX, roiSizeY = self.getRoiSize()
        usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

        uselessSizeX = ((self.width() - usefulSizeX) / 2)
        uselessSizeY = ((self.height() - usefulSizeY) / 2)
        uselessSizeX = uselessSizeX * round(roiSizeX) / usefulSizeX
        uselessSizeY = uselessSizeY * round(roiSizeY) / usefulSizeY

        return uselessSizeX, uselessSizeY

    def getRoiImage(self, changeRoiImage=True,transformImage = True):

        if vrb.allowChangeRoiImage:

            # Récupéreration de la ROI à visualiser dans l'image
            # Intéraction avec le widget parent (overlay, contraste...)
            # Passage à une QImage
            try:
                if self.image != None and self.image[0].isInit():
                    self.correctRealStartPoint()
                    roiSizeX, roiSizeY = self.getRoiSize()
                    usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

                    if changeRoiImage or self.roiImage is None or self.roiImageOverlay is None:

                        self.roiImage = fct.getRoiImage(self.image, roiSizeX, roiSizeY, usefulSizeX, usefulSizeY, self.realStartPointX, self.realStartPointY)
                        self.roiImageOverlay = fct.getRoiImage(self.imageOverlay, roiSizeX, roiSizeY, usefulSizeX, usefulSizeY, self.realStartPointX, self.realStartPointY)
                        self.roiImageDraw = fct.getRoiImage(self.imageDraw, roiSizeX, roiSizeY, usefulSizeX, usefulSizeY, self.realStartPointX, self.realStartPointY)
                        self.roiImageSuperPixels = fct.getRoiImage(self.imageSuperPixels, roiSizeX, roiSizeY, usefulSizeX, usefulSizeY, self.realStartPointX, self.realStartPointY)
                        try:
                            self.roiImageProbabilities = fct.getRoiImage(self.imageProbabilities, roiSizeX, roiSizeY, usefulSizeX, usefulSizeY, self.realStartPointX, self.realStartPointY)
                        except:
                            self.roiImageProbabilities = None
                        try:
                            self.roiImageThreshold = fct.getRoiImage(self.imageThreshold, roiSizeX, roiSizeY, usefulSizeX, usefulSizeY, self.realStartPointX, self.realStartPointY)
                        except:
                            self.roiImageThreshold = None


                    if self.widgetImage != None and transformImage:
                        try:

                            self.roiImageToAdd = self.widgetImage.transformImage(self.roiImage, imageOverlay=self.roiImageOverlay, imageDraw=self.roiImageDraw, imageProbabilities=self.roiImageProbabilities,
                                                                            imageThreshold=self.roiImageThreshold, imageSuperPixels=self.roiImageSuperPixels)
                            roiImageToAdd = util.copyImg(self.roiImageToAdd)

                        except:
                            print(traceback.format_exc())
                            try:
                                nbMaxThread = PyIPSDK.getDefaultNbMaxThreads()
                                PyIPSDK.setNbMaxThreads(nbMaxThread)
                            except:
                                pass
                            roiImageToAdd = util.copyImg(self.roiImage)

                    else:
                        if self.roiImageToAdd is not None:
                            roiImageToAdd = util.copyImg(self.roiImageToAdd)
                        else:
                            roiImageToAdd = util.copyImg(self.roiImage)

                    if roiImageToAdd.getSizeC() == 1:
                        imgFormat = QtGui.QImage.Format_Grayscale8
                        qimg = QtGui.QImage(roiImageToAdd.array, roiImageToAdd.getSizeX(), roiImageToAdd.getSizeY(), roiImageToAdd.getSizeX(), imgFormat)

                    if roiImageToAdd.getSizeC() == 3:
                        imgFormat = QtGui.QImage.Format_RGB888
                        qimg = QtGui.QImage(roiImageToAdd.getSizeX(), roiImageToAdd.getSizeY(), imgFormat)
                        for v in range(roiImageToAdd.getSizeY()):
                            ptr = qimg.scanLine(v)
                            ptr.setsize(qimg.bytesPerLine())
                            lineArr = numpy.asarray(ptr)
                            for c in range(3):
                                lineArr[c::3][:roiImageToAdd.getSizeX()] = roiImageToAdd.array[c][v][0:roiImageToAdd.getSizeX()]

                    imageToAdd = QtGui.QPixmap.fromImage(qimg)

                    self.scene.clear()
                    self.scene.clearSelection()
                    self.scene.clearFocus()

                    self.scene.setSceneRect(0, 0, roiImageToAdd.getSizeX(), roiImageToAdd.getSizeY())
                    self.scene.addPixmap(imageToAdd)

                    if self.widgetImage != None:
                        try:
                            self.widgetImage.parent.graphicElements.applyGraphicElement(self)
                            if vrb.applyGraphicElement is not None:
                                vrb.applyGraphicElement(self)
                        except:
                            pass
                            # traceback.print_exc(file=sys.stderr)

                    self.signalZoomFactorChanged.emit()

            except:
                traceback.print_exc(file=sys.stderr)

    def changeZoneImage(self, pointX, pointY):

        # Déplacement de l'image dans une zone centrée en pointX, pointY

        roiSizeX, roiSizeY = self.getRoiSize()

        self.realStartPointX = round(pointX - roiSizeX / 2)
        self.realStartPointY = round(pointY - roiSizeY / 2)

        self.correctRealStartPoint()
        self.getRoiImage()

    def resetZoom(self):

        # Retour à l'image en full résolution
        self.realStartPointX = 0
        self.realStartPointY = 0
        self.zoomFactor = 1
        self.getRoiImage()

    def setImage(self, image):

        # Application d'une nouvelle image IPSDK
        self.image = image
        self.correctRealStartPoint()
        # self.getRoiImage()

    def setImageOverlay(self, imageOverlay):
        # Application d'une nouvelle image overlay IPSDK
        self.imageOverlay = imageOverlay

        if self.widgetImage.moduleType == "Pixel Classification":
            if imageOverlay is not None:
                self.widgetImage.sliderOpacity.setVisible(True)
                self.widgetImage.groupBoxProbabilities.setVisible(True)
            else:
                self.widgetImage.sliderOpacity.setVisible(False)
                self.widgetImage.groupBoxProbabilities.setVisible(False)

    def setImageDraw(self, imageDraw):

        self.imageDraw = imageDraw
        # self.getRoiImage()

    def setImageSuperPixels(self, imageSuperPixels):

        self.imageSuperPixels = imageSuperPixels

    def setImageProbabilities(self, imageProbabilities):

        self.imageProbabilities = imageProbabilities
        self.getRoiImage()

    def setImageThreshold(self, imageThreshold):

        self.imageThreshold = imageThreshold
        # self.getRoiImage()


class WidgetInfo(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        self.labelTypeSize = qt.QLabel()
        self.labelZoom = qt.QLabel()
        self.labelPosition = qt.QLabel()
        self.labelExecTime = qt.QLabel()

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.labelTypeSize, 0, 0)
        self.layout.addWidget(self.labelZoom, 0, 1)
        self.layout.addWidget(self.labelPosition, 0, 2)
        self.layout.addWidget(self.labelExecTime, 0, 3)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)

    def resizeEvent(self, event):
        self.labelTypeSize.setFixedSize(self.width() * 25 / 100, self.height() * 100 / 100)
        self.labelZoom.setFixedSize(self.width() * 13 / 100, self.height() * 100 / 100)
        self.labelPosition.setFixedSize(self.width() * 39 / 100, self.height() * 100 / 100)
        self.labelExecTime.setFixedSize(self.width() * 15 / 100, self.height() * 100 / 100)


class SliderAxis(qt.QWidget):

    def __init__(self,modeViewer = "Normal"):
        qt.QWidget.__init__(self)

        self.modeViewer = modeViewer

        self.buttonExtractPlan = wgt.PushButtonImage(vrb.folderImages + "/ExtractPlan.png", margins=1)
        self.buttonExtractPlan.setFixedSize(20 * vrb.ratio, 20 * vrb.ratio)
        self.buttonExtractPlan.setToolTip(txt.dictToolTips["ExtractPlan"])

        self.sliderX = SimpleHorizontalSliderLabel(label="x = ", minimum=0, maximum=1, defaultValue=0, ratio=1, titleSize=25 * vrb.ratio)
        self.sliderX.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.sliderX.setVisible(False)
        self.sliderY = SimpleHorizontalSliderLabel(label="y = ", minimum=0, maximum=1, defaultValue=0, ratio=1, titleSize=25 * vrb.ratio)
        self.sliderY.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.sliderY.setVisible(False)
        self.sliderZ = SimpleHorizontalSliderLabel(label="z = ", minimum=0, maximum=1, defaultValue=0, ratio=1, titleSize=25 * vrb.ratio)
        self.sliderZ.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.sliderZ.setVisible(False)

        self.radioButtonX = qt.QRadioButton("X")
        self.radioButtonX.setFixedWidth(40 * vrb.ratio)
        self.radioButtonY = qt.QRadioButton("Y")
        self.radioButtonY.setFixedWidth(40 * vrb.ratio)
        self.radioButtonZ = qt.QRadioButton("Z")
        self.radioButtonZ.setFixedWidth(40 * vrb.ratio)

        self.sliderSequence = SimpleHorizontalSliderLabel(label="t = ", minimum=0, maximum=1, defaultValue=0, ratio=1, titleSize=25 * vrb.ratio)
        self.sliderSequence.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.buttonEye = wgt.PushButtonDoubleImage(vrb.folderImages + "/eye_open.png",
                                                   vrb.folderImages + "/eye_close.png")
        self.buttonEye.setFixedSize(15*vrb.ratio, 15*vrb.ratio)
        self.buttonEye.setActivation(True)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonExtractPlan, 0, 0, 2, 1)
        self.layout.addWidget(self.sliderX, 0, 1)
        self.layout.addWidget(self.sliderY, 0, 1)
        self.layout.addWidget(self.sliderZ, 0, 1)
        self.layout.addWidget(self.buttonEye, 0, 2)
        self.layout.addWidget(self.radioButtonX, 0, 2)
        self.layout.addWidget(self.radioButtonY, 0, 3)
        self.layout.addWidget(self.radioButtonZ, 0, 4)
        self.layout.addWidget(self.sliderSequence, 1, 1)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)

        if self.modeViewer == "Normal":
            self.radioButtonZ.setChecked(True)
            self.sliderZ.setVisible(True)
            self.buttonEye.setVisible(False)
        else:
            self.radioButtonX.setVisible(False)
            self.radioButtonY.setVisible(False)
            self.radioButtonZ.setVisible(False)
            self.buttonEye.setVisible(True)
            if self.modeViewer == "X":
                self.radioButtonX.setChecked(True)
                self.sliderX.setVisible(True)
            if self.modeViewer == "Y":
                self.radioButtonY.setChecked(True)
                self.sliderY.setVisible(True)
            if self.modeViewer == "Z":
                self.radioButtonZ.setChecked(True)
                self.sliderZ.setVisible(True)

        self.radioButtonX.clicked.connect(self.radioButtonPressed)
        self.radioButtonY.clicked.connect(self.radioButtonPressed)
        self.radioButtonZ.clicked.connect(self.radioButtonPressed)

    def radioButtonPressed(self):
        if self.radioButtonX.isChecked():
            self.sliderX.setVisible(True)
            self.sliderY.setVisible(False)
            self.sliderZ.setVisible(False)
        if self.radioButtonY.isChecked():
            self.sliderX.setVisible(False)
            self.sliderY.setVisible(True)
            self.sliderZ.setVisible(False)
        if self.radioButtonZ.isChecked():
            self.sliderX.setVisible(False)
            self.sliderY.setVisible(False)
            self.sliderZ.setVisible(True)

    def resizeEvent(self, event):

        if self.modeViewer == "Normal":
            self.sliderX.setFixedWidth(self.width()-195*vrb.ratio)
            self.sliderY.setFixedWidth(self.width()-195*vrb.ratio)
            self.sliderZ.setFixedWidth(self.width()-195*vrb.ratio)
            self.sliderSequence.setFixedWidth(self.width()-95*vrb.ratio)
        else:
            self.sliderX.setFixedWidth(self.width()-70*vrb.ratio)
            self.sliderY.setFixedWidth(self.width()-70*vrb.ratio)
            self.sliderZ.setFixedWidth(self.width()-70*vrb.ratio)
            self.sliderSequence.setFixedWidth(self.width()-30*vrb.ratio)

class ThresholdWidget(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        self.rangeSlider = RangeSlider()
        self.radioButtonFull = qt.QRadioButton("Full")
        self.radioButtonFull.setFixedWidth(90 * vrb.ratio)
        self.radioButtonFull.setChecked(True)
        self.radioButtonBorder = qt.QRadioButton("Border")
        self.radioButtonBorder.setFixedWidth(90 * vrb.ratio)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.rangeSlider, 0, 0, 3, 1)
        self.layout.addWidget(self.radioButtonFull, 0, 1)
        self.layout.addWidget(self.radioButtonBorder, 1, 1)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)
        self.layout.setSizeConstraint(1)

    def resizeEvent(self, event):
        self.rangeSlider.setFixedSize(max(1, self.width() - 110 * vrb.ratio), self.height() * 100 / 100)


class ImageViewerWithScrollBar(qt.QWidget):
    def __init__(self, scene, widgetImage=None, parent=None,sizeScrollBar = 18*vrb.ratio ):
        qt.QWidget.__init__(self)

        self.sizeScrollBar = sizeScrollBar
        pageStep = 250
        self.scrollBarChanging = False
        self.imageViewerChanging = False

        self.imageViewer = ImageViewer(scene, widgetImage=widgetImage, parent=parent)

        self.HScrollBar = qt.QScrollBar()
        self.HScrollBar.setOrientation(QtCore.Qt.Horizontal)
        self.HScrollBar.setPageStep(pageStep)
        self.HScrollBar.setRange(0, 0)
        self.HScrollBar.setEnabled(False)

        self.VScrollBar = qt.QScrollBar()
        self.VScrollBar.setOrientation(QtCore.Qt.Vertical)
        self.VScrollBar.setPageStep(pageStep)
        self.VScrollBar.setRange(0, 0)
        self.VScrollBar.setEnabled(False)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.imageViewer, 0, 0, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)
        self.layout.addWidget(self.HScrollBar, 1, 0, QtCore.Qt.AlignTop)
        self.layout.addWidget(self.VScrollBar, 0, 1, QtCore.Qt.AlignLeft)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)
        self.layout.setSpacing(0)
        self.layout.setSizeConstraint(1)

        self.imageViewer.signalZoomFactorChanged.connect(self.changeScrollBars)
        self.HScrollBar.valueChanged.connect(self.changeImageViewer)
        self.VScrollBar.valueChanged.connect(self.changeImageViewer)

        self.HScrollBar.setVisible(False)
        self.VScrollBar.setVisible(False)

    # def resizeEvent(self, event):
    #
    #     if self.imageViewer.zoomFactor != 1:
    #         self.HScrollBar.setFixedSize(max(1, self.width() - 18 * vrb.ratio), 18 * vrb.ratio)
    #         self.VScrollBar.setFixedSize(18 * vrb.ratio, max(1, self.height() - 18 * vrb.ratio))
    #         self.imageViewer.setFixedSize(self.width() - 18 * vrb.ratio, self.height() - 18 * vrb.ratio)
    #     else:
    #         self.imageViewer.setFixedSize(self.width(), self.height())

    def resizeEvent(self, event):

        if self.imageViewer.zoomFactor != 1:
            self.HScrollBar.setFixedSize(max(1, self.width() - self.sizeScrollBar), self.sizeScrollBar)
            self.VScrollBar.setFixedSize(self.sizeScrollBar, max(1, self.height() - self.sizeScrollBar))
            self.imageViewer.setFixedSize(self.width() -self.sizeScrollBar, self.height() -self.sizeScrollBar)
        else:
            self.imageViewer.setFixedSize(self.width(), self.height())

    def changeScrollBars(self):

        self.HScrollBar.setVisible(self.imageViewer.zoomFactor != 1)
        self.VScrollBar.setVisible(self.imageViewer.zoomFactor != 1)

        if self.imageViewerChanging == False:

            self.scrollBarChanging = True

            if self.imageViewer.image is not None:

                roiSizeX, roiSizeY = self.imageViewer.getRoiSize()
                nbStepX = (self.imageViewer.image[0].getSizeX() - roiSizeX) / (roiSizeX / 20)
                if int(nbStepX) == 0:
                    self.HScrollBar.setEnabled(False)
                else:
                    self.HScrollBar.setEnabled(True)
                self.HScrollBar.setRange(0, nbStepX)
                if nbStepX > 0:
                    valueX = int(self.imageViewer.realStartPointX * nbStepX / (self.imageViewer.image[0].getSizeX() - roiSizeX))
                    self.HScrollBar.setValue(valueX)

                nbStepY = (self.imageViewer.image[0].getSizeY() - roiSizeY) / (roiSizeY / 20)
                if int(nbStepY) == 0:
                    self.VScrollBar.setEnabled(False)
                else:
                    self.VScrollBar.setEnabled(True)
                self.VScrollBar.setRange(0, nbStepY)
                if nbStepY > 0:
                    valueY = int(self.imageViewer.realStartPointY * nbStepY / (self.imageViewer.image[0].getSizeY() - roiSizeY))
                    self.VScrollBar.setValue(valueY)

            self.scrollBarChanging = False

        self.resizeEvent(None)

    def changeImageViewer(self):

        if self.scrollBarChanging == False:

            self.imageViewerChanging = True

            if self.imageViewer.image is not None:

                roiSizeX, roiSizeY = self.imageViewer.getRoiSize()
                nbStepX = self.HScrollBar.maximum()
                if nbStepX != 0:
                    self.imageViewer.realStartPointX = self.HScrollBar.value() * (self.imageViewer.image[0].getSizeX() - roiSizeX) / nbStepX
                nbStepY = self.VScrollBar.maximum()
                if nbStepY != 0:
                    self.imageViewer.realStartPointY = self.VScrollBar.value() * (self.imageViewer.image[0].getSizeY() - roiSizeY) / nbStepY

                self.imageViewer.getRoiImage()

            self.imageViewerChanging = False


class GroupBoxOverlay(qt.QWidget):
    SignalOverlayChanged = pyqtSignal()

    def __init__(self):
        qt.QWidget.__init__(self)

        self.checkBoxOverlay = qt.QCheckBox("Image in overlay")
        self.checkBoxOverlay.setFixedHeight(30 * vrb.ratio)

        self.comboBoxOverlay = qt.QComboBox()
        self.comboBoxOverlay.setFixedSize(130 * vrb.ratio, 25 * vrb.ratio)
        # self.comboBoxOverlay.lineEdit().setAlignment(Qt.AlignCenter)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.checkBoxOverlay, 0, 0)
        self.layout.addWidget(self.comboBoxOverlay, 0, 1)
        self.layout.setAlignment(Qt.AlignLeft)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(5, 0, 5, 0)
        self.layout.setSizeConstraint(1)

        self.checkBoxOverlay.stateChanged.connect(self.emitSignalOverlayChanged)
        self.comboBoxOverlay.currentIndexChanged.connect(self.emitSignalOverlayChanged)

    def emitSignalOverlayChanged(self):
        vrb.previousImages = []
        vrb.mainWindow.groupMenu.groupPostProcess.buttonBack.setEnabled(False)

        self.SignalOverlayChanged.emit()


class GroupBoxProbabilites(qt.QWidget):
    SignalProbabilitiesChanged = pyqtSignal()

    def __init__(self):
        qt.QWidget.__init__(self)

        self.checkBoxProbabilities = qt.QCheckBox("probabilities")
        self.checkBoxProbabilities.setChecked(False)

        self.labelLutProbabilities = qt.QLabel("LUT")
        self.labelLutProbabilities.setVisible(False)

        self.comboBoxLutProbabilities = qt.QComboBox()
        self.comboBoxLutProbabilities.addItem("Proba")
        self.comboBoxLutProbabilities.addItem("Jet")
        self.comboBoxLutProbabilities.addItem("Grey")
        self.comboBoxLutProbabilities.addItem("Mixed")
        self.comboBoxLutProbabilities.setFixedSize(65 * vrb.ratio, 30 * vrb.ratio)
        self.comboBoxLutProbabilities.setVisible(False)

        self.lutInformations = LutInformations()
        self.lutInformations.setVisible(False)
        self.lutInformations.labelMin.label.setText("0")
        self.lutInformations.labelMin.setFixedWidth(30 * vrb.ratio)
        self.lutInformations.labelMax.setText("1")
        self.lutInformations.labelMax.setFixedWidth(10 * vrb.ratio)
        self.lutInformations.setFixedWidth(120 * vrb.ratio)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.checkBoxProbabilities, 0, 0, Qt.AlignLeft)
        self.layout.addWidget(self.labelLutProbabilities, 0, 1, Qt.AlignRight)
        self.layout.addWidget(self.comboBoxLutProbabilities, 0, 2)
        self.layout.addWidget(self.lutInformations, 0, 3)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(10 * vrb.ratio, 0, 0, 0)
        self.layout.setSizeConstraint(1)
        # self.layout.setHorizontalSpacing(4*vrb.ratio)

        self.checkBoxProbabilities.stateChanged.connect(self.actualizeVisible)
        self.comboBoxLutProbabilities.currentIndexChanged.connect(self.actualizeVisible)
        self.lutInformations.labelMin.SignalLabelTextChanged.connect(self.emitSignalProbabilitiesChanged)
        self.lutInformations.labelMin.mouseDoubleClickEvent = self.changeName

    def actualizeVisible(self):

        self.labelLutProbabilities.setVisible(self.checkBoxProbabilities.isChecked())
        self.comboBoxLutProbabilities.setVisible(self.checkBoxProbabilities.isChecked())

        if self.checkBoxProbabilities.isChecked() and self.comboBoxLutProbabilities.currentText() == "Proba":
            self.lutInformations.setVisible(True)
            self.lutInformations.initLut(lutProba["Array"], vertical=False)
        elif self.checkBoxProbabilities.isChecked() and self.comboBoxLutProbabilities.currentText() == "Jet":
            self.lutInformations.setVisible(True)
            self.lutInformations.initLut(lutJet["Array"], vertical=False)
        else:
            self.lutInformations.setVisible(False)

        self.emitSignalProbabilitiesChanged()

    def changeName(self, event):

        self.lutInformations.labelMin.switchVisibleWidget()

    def emitSignalProbabilitiesChanged(self):

        self.SignalProbabilitiesChanged.emit()

class ImageViewerStandAlone(qt.QWidget):

    SignalExtractImage = pyqtSignal(qt.QWidget)

    def __init__(self, parent=None, modeViewer = "Normal"):
        qt.QWidget.__init__(self)

        self.parent = parent
        self.modeViewer = modeViewer

        self.imageVisualization = None
        self.imageVisualizationOverlay = None
        self.imageVisualizationDraw = None
        self.imageVisualizationSuperPixels = None
        self.imageVisualizationThreshold = None

        self.scene = qt.QGraphicsScene()
        self.scene.setBackgroundBrush(QtGui.QBrush(QtGui.QColor(26, 26, 26), Qt.Dense2Pattern))

        if self.modeViewer == "Normal":
            self.imageViewerWithScrollBar = ImageViewerWithScrollBar(self.scene, widgetImage=self.parent, parent=self,sizeScrollBar=18*vrb.ratio)
        else:
            self.imageViewerWithScrollBar = ImageViewerWithScrollBar(self.scene, widgetImage=self.parent, parent=self,sizeScrollBar=7*vrb.ratio)
        self.imageViewer = self.imageViewerWithScrollBar.imageViewer

        self.widgetInfo = WidgetInfo()

        self.sliderAxis = SliderAxis(modeViewer = self.modeViewer)
        self.sliderAxis.setVisible(False)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.imageViewerWithScrollBar, 0, 0,)
        self.layout.addWidget(self.widgetInfo, 1, 0)
        self.layout.addWidget(self.sliderAxis, 2, 0)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 5)
        self.layout.setSizeConstraint(1)

        self.sliderAxis.radioButtonX.clicked.connect(self.axisChanged)
        self.sliderAxis.radioButtonY.clicked.connect(self.axisChanged)
        self.sliderAxis.radioButtonZ.clicked.connect(self.axisChanged)
        self.sliderAxis.sliderX.slider.valueChanged.connect(self.updateImageViewer)
        self.sliderAxis.sliderY.slider.valueChanged.connect(self.updateImageViewer)
        self.sliderAxis.sliderZ.slider.valueChanged.connect(self.updateImageViewer)
        self.sliderAxis.sliderSequence.slider.valueChanged.connect(self.updateImageViewer)
        self.sliderAxis.sliderX.slider.sliderReleased.connect(self.parent.emitSignalRefreshPreview)
        self.sliderAxis.sliderY.slider.sliderReleased.connect(self.parent.emitSignalRefreshPreview)
        self.sliderAxis.sliderZ.slider.sliderReleased.connect(self.parent.emitSignalRefreshPreview)
        self.sliderAxis.sliderSequence.slider.sliderReleased.connect(self.parent.emitSignalRefreshPreview)
        self.sliderAxis.buttonExtractPlan.clicked.connect(self.emitSignalExtractImage)

        self.imageViewer.signalZoomFactorChanged.connect(self.changeInfoZoom)
        self.imageViewer.signalMouseMoved.connect(self.changeLabelPosition)

    def resizeEvent(self, event):

        heightWidgets = 0

        heightWidgetInfo = 20 * vrb.ratio
        self.widgetInfo.setFixedSize(self.width() * 100 / 100, heightWidgetInfo)
        heightWidgets += heightWidgetInfo

        if self.sliderAxis.isVisible():
            heightSliderAxis = 30 * vrb.ratio
            self.sliderAxis.setFixedSize(self.width() * 100 / 100, heightSliderAxis)
            heightWidgets += heightSliderAxis

        self.imageViewerWithScrollBar.setFixedSize(self.width() * 100 / 100, max(1, self.height() * 100 / 100 - 15 * vrb.ratio - heightWidgets))

    def emitSignalExtractImage(self):

        #self.SignalExtractImage.emit(self.sliderAxis)
        self.SignalExtractImage.emit(self)

    def getRoiImage(self, changeRoiImage=True):

        self.imageViewer.getRoiImage(changeRoiImage=changeRoiImage)

    def changeInfoZoom(self):

        if self.imageViewer.image != None:
            roiSizeX, roiSizeY = self.imageViewer.getRoiSize()
            usefulSizeX, usefulSizeY = self.imageViewer.getUsefulSizeScene()

            ratio = (roiSizeX / usefulSizeX + roiSizeY / usefulSizeY) / 2
            zoom = 1 / ratio
            self.imageViewer.currentZoom = zoom
            zoom = round(zoom * 10000) / 100

            self.widgetInfo.labelZoom.setText("Zoom : " + str(zoom) + " %")

            try:
                functionCall = Dfct.SubElement(self.parent.imageLabel.xmlElement, "FunctionCall")
                execTime = Dfct.childText(functionCall, "ExecutionTime")
                self.widgetInfo.labelExecTime.setText("Exec time : " + str(fct.numberToScientific(float(execTime)) + 's'))
            except:
                self.widgetInfo.labelExecTime.setText("")

    def changeLabelPosition(self, posX, posY):

        try:

            if self.parent.image is not None and self.imageVisualization is not None:

                posX = int(posX)
                posY = int(posY)

                if posX >= 0 and posX < self.imageVisualization[0].getSizeX() and posY >= 0 and posY < self.imageVisualization[0].getSizeY():

                    if self.parent.image.getSizeZ() == 1:
                        text = "x=" + str(int(posX)) + ", y=" + str(int(posY))
                    else:
                        if self.sliderAxis.radioButtonX.isChecked():
                            text = "x=" + str(self.sliderAxis.sliderX.slider.value()) + ", y=" + str(int(posX)) + ", z=" + str(int(posY))
                        if self.sliderAxis.radioButtonY.isChecked():
                            text = "x=" + str(int(posX)) + ", y=" + str(self.sliderAxis.sliderY.slider.value()) + ", z=" + str(int(posY))
                        if self.sliderAxis.radioButtonZ.isChecked():
                            text = "x=" + str(int(posX)) + ", y=" + str(int(posY)) + ", z=" + str(self.sliderAxis.sliderZ.slider.value())

                    if self.parent.image.getSizeT() > 1:
                        text += ", t=" + str(self.sliderAxis.sliderSequence.slider.value())

                    if self.parent.moduleType == "Label Classification" and self.parent.module.settingsWidget.buttonViewFeatures.activate:
                        text += ", " + "value" + " = "
                    else:
                        if self.imageVisualization[0].getBufferType() in [PyIPSDK.eImageBufferType.eIBT_Label8, PyIPSDK.eImageBufferType.eIBT_Label16, PyIPSDK.eImageBufferType.eIBT_Label32]:
                            text += ", " + "label" + " = "
                        else:
                            text += ", " + "value" + " = "

                    try:
                        if self.parent.moduleType == "Label Classification" and self.parent.module.settingsWidget.buttonViewFeatures.activate:
                            # labelValue = self.imageVisualization[0].array[posY][posX]
                            labelValue = fct.getPixelValue(self.imageVisualization[0], posX, posY)
                            index = self.parent.imageLabel.currentFeaturesIndex
                            measure = self.parent.imageLabel.features[index]
                            text += fct.numberCalibration(measure[labelValue])

                        elif self.parent.checkBoxProbabilities.isChecked() and self.parent.moduleType == "Pixel Classification":
                            # text += str(int(self.imageViewer.imageProbabilities[0].array[posY][posX]*100))+" %"
                            text += str(int(fct.getPixelValue(self.imageViewer.imageProbabilities[0], posX, posY) * 100)) + " %"

                        elif self.parent.checkBoxProbabilities.isChecked() and self.parent.moduleType == "Super Pixel Classification":
                            try:
                                # labelSuperPixelValue = self.imageViewer.imageSuperPixels[0].array[posY][posX]
                                labelSuperPixelValue = fct.getPixelValue(self.imageViewer.imageSuperPixels[0], posX, posY)
                                probaValue = self.parent.imageLabel.probabilitiesVector[int(labelSuperPixelValue)][int(self.parent.imageLabel.resultVector[int(labelSuperPixelValue)])]
                                text += str(int(probaValue * 100)) + " %"
                            except:
                                pass

                        else:
                            if self.imageVisualization[0].getBufferType() == PyIPSDK.eImageBufferType.eIBT_Binary:
                                # if self.imageVisualization[0].array[posY][posX] == 0:
                                if fct.getPixelValue(self.imageVisualization[0], posX, posY) == 0:
                                    text += "False"
                                else:
                                    text += "True"
                            else:
                                if self.imageVisualization[0].getSizeC() == 1:
                                    if self.imageVisualization[0].isDiskImage() or (self.imageVisualization[0].getSizeX() == self.imageVisualization[0].array.shape[1] and self.imageVisualization[0].getSizeY()
                                                                                    == self.imageVisualization[0].array.shape[0]):
                                        # text += str(self.imageVisualization[0].array[posY][posX])
                                        text += str(fct.getPixelValue(self.imageVisualization[0], posX, posY))
                                    else:
                                        # text += str(self.imageVisualization[0].array[0][posY][posX])
                                        text += str(fct.getPixelValue(self.imageVisualization[0], posX, posY, cValue=0))

                                else:
                                    text += "("
                                    for cValue in range(self.imageVisualization[0].getSizeC()):
                                        if cValue != self.imageVisualization[0].getSizeC() - 1:
                                            # text+= str(self.imageVisualization[0].array[cValue][posY][posX]) + ", "
                                            text += str(fct.getPixelValue(self.imageVisualization[0], posX, posY, cValue=cValue)) + ", "
                                        else:
                                            # text += str(self.imageVisualization[0].array[cValue][posY][posX]) + ")"
                                            text += str(fct.getPixelValue(self.imageVisualization[0], posX, posY, cValue=cValue)) + ")"

                                # if self.imageVisualization[0].getSizeC() == 3:
                                #     text += "( " + str(self.imageVisualization[0].array[0][posY][posX]) + ", " + str(self.imageVisualization[0].array[1][posY][posX]) + ", " + str(
                                #         self.imageVisualization[0].array[2][posY][posX]) + " )"
                    except:
                        traceback.print_exc(file=sys.stderr)

                    if self.parent.mode == "overlay" or self.parent.mode == "threshold":
                        try:
                            if self.imageVisualizationOverlay is not None:
                                text += " overlay = "
                                if self.imageVisualizationOverlay[0].getBufferType() == PyIPSDK.eImageBufferType.eIBT_Binary:
                                    # if self.imageVisualizationOverlay[0].array[posY][posX] == 0:
                                    if fct.getPixelValue(self.imageVisualizationOverlay[0], posX, posY) == 0:
                                        text += "False"
                                    else:
                                        text += "True"
                                else:
                                    if self.imageVisualizationOverlay[0].getSizeC() == 1:
                                        if self.imageVisualizationOverlay[0].isDiskImage() or (
                                                self.imageVisualizationOverlay[0].getSizeX() == self.imageVisualizationOverlay[0].array.shape[1] and self.imageVisualizationOverlay[0].getSizeY() == \
                                                self.imageVisualizationOverlay[0].array.shape[0]):
                                            # text += str(self.imageVisualizationOverlay[0].array[posY][posX])
                                            text += str(fct.getPixelValue(self.imageVisualizationOverlay[0], posX, posY))
                                        else:
                                            # text += str(self.imageVisualizationOverlay[0].array[0][posY][posX])
                                            text += str(fct.getPixelValue(self.imageVisualizationOverlay[0], posX, posY, cValue=0))

                                    else:
                                        text += "("
                                        for cValue in range(self.imageVisualizationOverlay[0].getSizeC()):
                                            if cValue != self.imageVisualizationOverlay[0].getSizeC() - 1:
                                                # text += str(self.imageVisualizationOverlay[0].array[cValue][posY][posX]) + ", "
                                                text += str(fct.getPixelValue(self.imageVisualizationOverlay[0], posX, posY, cValue=cValue)) + ", "
                                            else:
                                                # text += str(self.imageVisualizationOverlay[0].array[cValue][posY][posX]) + ")"
                                                text += str(fct.getPixelValue(self.imageVisualizationOverlay[0], posX, posY, cValue=cValue)) + ")"
                                    # if self.imageVisualizationOverlay[0].getSizeC() == 3:
                                    #     text += "( " + str(self.imageVisualizationOverlay[0].array[0][posY][posX]) + ", " + str(self.imageVisualizationOverlay[0].array[1][posY][posX]) + ", " + str(
                                    #         self.imageVisualizationOverlay[0].array[2][posY][posX]) + " )"
                        except:
                            pass
                else:
                    text = ""

            self.widgetInfo.labelPosition.setText(text)

        except:
            pass
            # traceback.print_exc(file=sys.stderr)

    def getImageVisualization(self, image):

        self.sliderAxis.setVisible(True)
        if image.isDiskImage():
            self.sliderAxis.radioButtonZ.setChecked(True)
            self.sliderAxis.radioButtonX.setEnabled(False)
            self.sliderAxis.radioButtonY.setEnabled(False)
        else:
            self.sliderAxis.radioButtonX.setEnabled(True)
            self.sliderAxis.radioButtonY.setEnabled(True)

        if self.modeViewer == "Normal":
            if image.getSizeZ() == 1:
                self.sliderAxis.sliderX.setVisible(False)
                self.sliderAxis.sliderY.setVisible(False)
                self.sliderAxis.sliderZ.setVisible(False)
            else:
                if self.sliderAxis.radioButtonX.isChecked():
                    self.sliderAxis.sliderX.setVisible(True)
                if self.sliderAxis.radioButtonY.isChecked():
                    self.sliderAxis.sliderY.setVisible(True)
                if self.sliderAxis.radioButtonZ.isChecked():
                    self.sliderAxis.sliderZ.setVisible(True)

            self.sliderAxis.radioButtonX.setVisible(image.getSizeZ() > 1)
            self.sliderAxis.radioButtonY.setVisible(image.getSizeZ() > 1)
            self.sliderAxis.radioButtonZ.setVisible(image.getSizeZ() > 1)

        if image.getSizeT() > 1:
            self.sliderAxis.sliderSequence.setVisible(True)
            if image.getSizeZ() == 1:
                self.sliderAxis.layout.addWidget(self.sliderAxis.sliderSequence, 0, 1)
            else:
                self.sliderAxis.layout.addWidget(self.sliderAxis.sliderSequence, 1, 1)
        else:
            self.sliderAxis.sliderSequence.setVisible(False)

        if image.getSizeZ() > 1:
            self.sliderAxis.sliderX.slider.setMaximum(image.getSizeX() - 1)
            self.sliderAxis.sliderY.slider.setMaximum(image.getSizeY() - 1)
            self.sliderAxis.sliderZ.slider.setMaximum(image.getSizeZ() - 1)

            if vrb.has3DImage == False:
                self.sliderAxis.sliderZ.slider.setValue(int((image.getSizeZ() - 1) / 2))
                vrb.has3DImage = True

        if image.getSizeT() > 1:
            self.sliderAxis.sliderSequence.slider.setMaximum(image.getSizeT() - 1)
            if vrb.hasSequenceImage == False:
                self.sliderAxis.sliderSequence.slider.setValue(int((image.getSizeT() - 1) / 2))
                vrb.hasSequenceImage = True

        # self.resizeEvent(None)

        imageVisualization = self.getImagePlan(image)

        return imageVisualization

    def getImagePlan(self, image, middleValue=False):

        if image.isDiskImage():
            valueSequence = self.sliderAxis.sliderSequence.slider.value()
            if middleValue:
                z = self.sliderAxis.sliderZ.slider.value() - int(self.parent.lineEditPreviewAxis.text())
                z = max(0, z)
                valueZ = int(self.sliderAxis.sliderZ.slider.value()) - z
            else:
                valueZ = self.sliderAxis.sliderZ.slider.value()

            imageVisualization = fct.loadPlanImageDisk(image, image.getSizeX(), image.getSizeY(), 0, 0, 1, 1, zValue=valueZ, cValue=None, tValue=valueSequence)

        else:
            if image.getSizeC() != 1:
                colorGeometryType = image.getColorGeometryType()
                colorGeometry = PyIPSDK.ColorGeometry()
                if colorGeometryType == PyIPSDK.eCGT_User:
                    colorGeometry.initUser(image.getSizeC())
                else:
                    colorGeometry.init(colorGeometryType)
                volumeGeometry = PyIPSDK.VolumeGeometry()
                volumeGeometry.init2d()
                temporalGeometry = PyIPSDK.TemporalGeometry()
                temporalGeometry.initSingle()

            if image.getSizeT() > 1:
                valueSequence = self.sliderAxis.sliderSequence.slider.value()
                if image.getSizeZ() == 1:
                    if image.getSizeC() == 1:
                        imageProcess = PyIPSDK.extractPlan(0, 0, valueSequence, image)
                    else:
                        imageProcess = PyIPSDK.extractColor(0, valueSequence, image)
                else:
                    if image.getSizeC() == 1:
                        imageProcess = PyIPSDK.extractVolume(0, valueSequence, image)
                    else:
                        imageProcess = PyIPSDK.extractColorVolume(valueSequence, image)

                imageProcess = util.copyImg(imageProcess)
            else:
                imageProcess = image

            if imageProcess.getSizeZ() > 1:
                if self.sliderAxis.radioButtonX.isChecked():
                    if middleValue:
                        x = self.sliderAxis.sliderX.slider.value() - int(self.parent.lineEditPreviewAxis.text())
                        x = max(0, x)
                        value = int(self.sliderAxis.sliderX.slider.value()) - x
                    else:
                        value = self.sliderAxis.sliderX.slider.value()
                    if imageProcess.getSizeC() == 1:
                        planArray = numpy.ascontiguousarray(imageProcess.array[:, :, value])
                        geometry = PyIPSDK.geometry2d(imageProcess.getBufferType(), imageProcess.getSizeY(), imageProcess.getSizeZ())
                    else:
                        planArray = numpy.ascontiguousarray(imageProcess.array[:, :, :, value])
                        geometry = PyIPSDK.geometry(imageProcess.getBufferType(), imageProcess.getSizeY(), imageProcess.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)

                if self.sliderAxis.radioButtonY.isChecked():
                    if middleValue:
                        y = self.sliderAxis.sliderY.slider.value() - int(self.parent.lineEditPreviewAxis.text())
                        y = max(0, y)
                        value = int(self.sliderAxis.sliderY.slider.value()) - y
                    else:
                        value = self.sliderAxis.sliderY.slider.value()
                    if imageProcess.getSizeC() == 1:
                        planArray = numpy.ascontiguousarray(imageProcess.array[:, value, :])
                        geometry = PyIPSDK.geometry2d(imageProcess.getBufferType(), imageProcess.getSizeX(), imageProcess.getSizeZ())
                    else:
                        planArray = numpy.ascontiguousarray(imageProcess.array[:, :, value, :])
                        geometry = PyIPSDK.geometry(imageProcess.getBufferType(), imageProcess.getSizeX(), imageProcess.getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)

                if self.sliderAxis.radioButtonZ.isChecked():
                    if middleValue:
                        z = self.sliderAxis.sliderZ.slider.value() - int(self.parent.lineEditPreviewAxis.text())
                        z = max(0, z)
                        value = int(self.sliderAxis.sliderZ.slider.value()) - z
                    else:
                        value = self.sliderAxis.sliderZ.slider.value()
                    if imageProcess.getSizeC() == 1:
                        planArray = numpy.ascontiguousarray(imageProcess.array[value, :, :])
                        geometry = PyIPSDK.geometry2d(imageProcess.getBufferType(), imageProcess.getSizeX(), imageProcess.getSizeY())
                    else:
                        planArray = numpy.ascontiguousarray(imageProcess.array[:, value, :, :])
                        geometry = PyIPSDK.geometry(imageProcess.getBufferType(), imageProcess.getSizeX(), imageProcess.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)

                imageVisualization = PyIPSDK.fromArray(planArray, geometry)
            else:
                imageVisualization = imageProcess

        imageVisualization = util.copyImg(imageVisualization)

        return imageVisualization

    def setImageViewer(self):

        try:
            self.imageViewer.allowResize = False
            self.imageVisualization = None
            if self.parent.image is not None:
                if self.parent.image.getSizeZ() > 1 or self.parent.image.getSizeT() > 1:

                    self.imageVisualization = self.getImageVisualization( self.parent.image)

                    if self.parent.moduleType == "Classic":
                        try:
                            vrb.mainWindow.currentLabel.labelImageMiniature.image = util.copyImg(self.imageVisualization)
                            vrb.mainWindow.currentLabel.labelImageMiniature.changeImage()
                        except:
                            try:
                                self.parent.module.currentLabel.labelImageMiniature.image = util.copyImg(self.imageVisualization)
                                self.parent.module.currentLabel.labelImageMiniature.changeImage()
                            except:
                                pass

                    self.imageVisualization = fct.getMultiResolutionImage(self.imageVisualization)

                else:
                    self.sliderAxis.setVisible(False)
                    try:
                        self.imageVisualization = self.parent.imageLabel.multiRes
                    except:
                        self.imageVisualization = fct.getMultiResolutionImage(self.parent.imageLabel)
        except:
            traceback.print_exc(file=sys.stderr)

        self.imageViewer.setImage(self.imageVisualization)
        self.imageViewer.allowResize = True

        self.resizeEvent(None)

        # self.checkNewMode()

    def setImageViewerOverlay(self):

        try:
            self.imageVisualizationOverlay = None
            if self.parent.imageOverlay is not None:
                if self.parent.imageOverlay.getSizeZ() > 1 or self.parent.imageOverlay.getSizeT() > 1:
                    self.imageVisualizationOverlay = self.getImageVisualization(self.parent.imageOverlay)

                    try:
                        self.parent.imageOverlayLabel.labelImageMiniature.image = util.copyImg(self.imageVisualizationOverlay)
                        self.parent.imageOverlayLabel.labelImageMiniature.changeImage()
                    except:
                        pass

                    self.imageVisualizationOverlay = fct.getMultiResolutionImage(self.imageVisualizationOverlay)
                else:
                    try:
                        self.imageVisualizationOverlay = self.parent.imageOverlayLabel.multiRes
                    except:
                        self.imageVisualizationOverlay = fct.getMultiResolutionImage(self.parent.imageOverlayLabel)

            self.imageViewer.setImageOverlay(self.imageVisualizationOverlay)

        except:
            traceback.print_exc(file=sys.stderr)

    def setImageViewerDraw(self):

        self.imageVisualizationDraw = None
        if self.parent.imageDraw is not None:
            if self.parent.imageDraw.getSizeZ() > 1 or self.parent.imageDraw.getSizeT() > 1:
                self.imageVisualizationDraw = self.getImageVisualization(self.parent.imageDraw)
                self.imageVisualizationDraw = fct.getMultiResolutionImage(self.imageVisualizationDraw)
            else:
                self.imageVisualizationDraw = fct.getMultiResolutionImage(self.parent.imageDraw)

        self.imageViewer.setImageDraw(self.imageVisualizationDraw)

    def setImageViewerSuperPixels(self):

        self.imageVisualizationSuperPixels = None
        if self.parent.imageSuperPixels is not None:
            if self.parent.imageSuperPixels.getSizeZ() > 1 or self.parent.imageSuperPixels.getSizeT() > 1:
                self.imageVisualizationSuperPixels = self.getImageVisualization(self.parent.imageSuperPixels)
                self.imageVisualizationSuperPixels = fct.getMultiResolutionImage(self.imageVisualizationSuperPixels)
            else:
                self.imageVisualizationSuperPixels = fct.getMultiResolutionImage(self.parent.imageSuperPixels)

        self.imageViewer.setImageSuperPixels(self.imageVisualizationSuperPixels)

    def setImageViewerThreshold(self):

        self.imageVisualizationThreshold = None
        if self.parent.imageThreshold is not None:
            if self.parent.imageThreshold.getSizeZ() > 1 or self.parent.imageThreshold.getSizeT() > 1:
                self.imageVisualizationThreshold = self.parent.getImageVisualization(self.parent.imageThreshold)
                self.imageVisualizationThreshold = fct.getMultiResolutionImage(self.imageVisualizationThreshold)
            else:
                self.imageVisualizationThreshold = fct.getMultiResolutionImage(self.parent.imageThreshold)

        self.imageViewer.setImageThreshold(self.imageVisualizationThreshold)

    def axisChanged(self):

        if self.sliderAxis.radioButtonX.isChecked():
            self.parent.labelPreviewAxis.setText("Half size X")
        if self.sliderAxis.radioButtonY.isChecked():
            self.parent.labelPreviewAxis.setText("Half size Y")
        if self.sliderAxis.radioButtonZ.isChecked():
            self.parent.labelPreviewAxis.setText("Half size Z")

        self.imageViewer.resetZoom()
        self.updateImageViewer()
        self.parent.emitSignalRefreshPreview()
        self.parent.SignalPlanChanged.emit()

    def updateImageViewer(self):

        vrb.currentHarrisCorner2d = None

        self.setImageViewer()
        self.setImageViewerOverlay()
        self.setImageViewerDraw()
        self.setImageViewerThreshold()
        self.setImageViewerSuperPixels()
        self.parent.SignalPlanChanged.emit()

        self.parent.getRoiImage(changeRoiImage = True)

        sender = self.sender()
        try:
            if not sender.mousePressed:
                self.parent.emitSignalRefreshPreview()
        except:
            pass

        # self.imageViewer.getRoiImage()

class WidgetImage(qt.QWidget):
    SignalRefreshPreview = pyqtSignal()
    SignalPlanChanged = pyqtSignal()
    SignalOverlayChanged = pyqtSignal()

    def __init__(self, parent=None, standAlone=False, module=None,with3D = False):
        qt.QWidget.__init__(self)

        self.with3D = with3D
        self.module = module
        if module is not None:
            self.moduleType = module.moduleType
        else:
            self.moduleType = "Classic"

        self.parent = parent

        self.modeViewer = "2D"

        self.previewMinX, self.previewMinY, self.previewSizeX, self.previewSizeY = None, None, None, None

        self.elementIPSDK = set()

        self.figureVpl = None

        self.image = None
        self.imageLabel = None
        self.mode = "classic"
        self.thresholdMode = "classic"
        # self.imageVisualization = None
        # self.imageVisualizationOverlay = None

        self.imageOverlay = None
        self.imageDraw = None
        self.imageSuperPixels = None
        self.imageThreshold = None
        self.imageOverlayLabel = None

        self.scene = qt.QGraphicsScene()

        self.scene.setBackgroundBrush(QtGui.QBrush(QtGui.QColor(26, 26, 26), Qt.Dense2Pattern))

        # self.imageViewerWithScrollBar = ImageViewerWithScrollBar(self.scene, widgetImage=self, parent=parent)
        # self.imageViewer = self.imageViewerWithScrollBar.imageViewer
        # # self.imageViewer = ImageViewer(self.scene,widgetImage = self,parent=parent)
        #
        # self.widgetInfo = WidgetInfo()
        #
        # self.sliderAxis = SliderAxis()
        # self.sliderAxis.setVisible(False)

        if self.with3D:
            self.imageViewer3D = QtViewer(vrb.mainWindow.viewerNapari)
            # self.imageViewer3D.keyPressEvent = self.keyEventNapari

        self.imageViewerStandAloneNormal = ImageViewerStandAlone(parent=self,modeViewer = "Normal")
        self.imageViewerStandAloneX = ImageViewerStandAlone(parent=self, modeViewer = "X")
        self.imageViewerStandAloneY = ImageViewerStandAlone(parent=self, modeViewer = "Y")
        self.imageViewerStandAloneZ = ImageViewerStandAlone(parent=self, modeViewer = "Z")

        self.listImageViewerStandAlone = [self.imageViewerStandAloneNormal]

        # if self.moduleType == "Classic":
        #     self.listImageViewerStandAlone = [self.imageViewerStandAloneX,self.imageViewerStandAloneY,self.imageViewerStandAloneZ,self.imageViewerStandAloneNormal]
        # else:
        #     self.listImageViewerStandAlone = [self.imageViewerStandAloneNormal]

        self.imageViewerStandAlone = self.imageViewerStandAloneNormal
        self.imageViewer = self.imageViewerStandAlone.imageViewer

        # self.imageViewerWithScrollBar = self.imageViewerStandAlone.imageViewerWithScrollBar
        # self.imageViewer = self.imageViewerStandAlone.imageViewer
        # self.widgetInfo = self.imageViewerStandAlone.widgetInfo
        # self.sliderAxis = self.imageViewerStandAlone.sliderAxis

        self.sliderOpacity = SimpleHorizontalSliderLabel(label="Overlay opacity = ", minimum=0, maximum=100, defaultValue=0, ratio=100,titleSize=100*vrb.ratio)
        self.sliderOpacity.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.sliderOpacity.slider.setValue(50)
        self.sliderOpacity.setVisible(False)

        self.checkBoxContour = qt.QCheckBox("Contour")
        self.checkBoxContour.setVisible(False)

        self.thresholWidget = ThresholdWidget()
        self.rangeSlider = self.thresholWidget.rangeSlider
        self.thresholWidget.setVisible(False)

        self.groupBoxOverlay = GroupBoxOverlay()

        self.pushButtonDocumentation = wgt.PushButtonImage(margins=1, filename=vrb.folderImages + '/Interrogation.png')
        self.pushButtonDocumentation.setStyleSheet("background-color : transparent; border :0px")
        self.pushButtonDocumentation.setFixedSize(20 * vrb.ratio, 20 * vrb.ratio)
        self.pushButtonDocumentation.setToolTip(txt.dictToolTips["Documentation"])
        self.pushButtonDocumentation.setVisible(False)

        self.labelPreviewAxis = qt.QLabel("Half size Z")
        self.labelPreviewAxis.setVisible(False)
        self.labelPreviewAxis.setFixedWidth(70 * vrb.ratio)
        self.lineEditPreviewAxis = qt.QLineEdit("4")
        self.lineEditPreviewAxis.setFixedWidth(30 * vrb.ratio)
        self.lineEditPreviewAxis.setVisible(False)
        self.emptyLabel = qt.QLabel("")
        self.emptyLabel.setFixedSize(30 * vrb.ratio, 15 * vrb.ratio)

        self.checkBoxMask = qt.QCheckBox("Display learning mask")
        self.checkBoxMask.setChecked(True)

        self.checkBoxSuperPixels = qt.QCheckBox("Super Pixels")
        self.checkBoxSuperPixels.setChecked(True)

        self.checkBoxLearningMask = qt.QCheckBox("Learning mask")
        self.checkBoxLearningMask.setChecked(True)

        self.groupBoxProbabilities = GroupBoxProbabilites()
        self.groupBoxProbabilities.setVisible(False)
        self.checkBoxProbabilities = self.groupBoxProbabilities.checkBoxProbabilities

        self.checkBoxResult = qt.QCheckBox("Display result")
        self.checkBoxResult.setChecked(True)

        self.lutInformations = LutInformations()
        self.lutInformations.setVisible(False)

        self.layout = qt.QGridLayout()

        self.groupViewerZone = qt.QGroupBox()
        self.layoutViewerZone = qt.QGridLayout()
        if self.with3D:
            self.layoutViewerZone.addWidget(self.imageViewer3D,0,0)
        self.layoutViewerZone.addWidget(self.imageViewerStandAloneNormal,0,0)
        self.layoutViewerZone.addWidget(self.imageViewerStandAloneX,0,1)
        self.layoutViewerZone.addWidget(self.imageViewerStandAloneY,1,0)
        self.layoutViewerZone.addWidget(self.imageViewerStandAloneZ,1,1)
        self.groupViewerZone.setLayout(self.layoutViewerZone)
        self.layoutViewerZone.setContentsMargins(0, 0, 0, 0)
        self.layoutViewerZone.setSizeConstraint(1)

        if standAlone == False:
            self.layout.addWidget(self.groupBoxOverlay, 0, 0)
            self.layout.addWidget(self.sliderOpacity, 0, 1)
            self.layout.addWidget(self.checkBoxContour, 0, 2, Qt.AlignLeft)
            self.layout.addWidget(self.labelPreviewAxis, 0, 2, Qt.AlignRight)
            self.layout.addWidget(self.lineEditPreviewAxis, 0, 3)
            self.layout.addWidget(self.pushButtonDocumentation, 0, 4, Qt.AlignRight)
            self.layout.addWidget(self.groupViewerZone,  1, 0, 1, 4)
            self.layout.addWidget(self.thresholWidget, 2, 0, 1, 4)

        elif self.moduleType in ["Pixel Classification", "Label Classification", "Super Pixel Classification"]:
            self.layout.addWidget(self.sliderOpacity, 0, 0)
            if self.moduleType == "Pixel Classification":
                self.layout.addWidget(self.checkBoxMask, 0, 1)
                self.layout.addWidget(self.groupBoxProbabilities, 0, 2, Qt.AlignRight)
            elif self.moduleType == "Label Classification":
                self.layout.addWidget(self.emptyLabel, 0, 0)
                self.layout.addWidget(self.checkBoxResult, 0, 1, Qt.AlignLeft)
                self.layout.addWidget(self.lutInformations, 0, 3, Qt.AlignRight)
            elif self.moduleType == "Super Pixel Classification":
                self.layout.addWidget(self.checkBoxSuperPixels, 0, 1)
                self.layout.addWidget(self.checkBoxLearningMask, 0, 2)
                self.layout.addWidget(self.groupBoxProbabilities, 0, 3, Qt.AlignRight)
            self.layout.addWidget(self.imageViewerStandAlone,  1, 0, 1, 4)
            self.imageViewerStandAlone.sliderAxis.buttonExtractPlan.setVisible(False)
        else:
            self.layout.addWidget(self.sliderOpacity, 0, 0)
            self.layout.addWidget(self.imageViewerStandAlone, 1, 0)
            self.imageViewerStandAlone.sliderAxis.buttonExtractPlan.setVisible(False)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 5)
        # self.layout.setHorizontalSpacing(0)
        self.layout.setSizeConstraint(1)

        self.pushButtonDocumentation.clicked.connect(self.showDocViewer3D)
        self.sliderOpacity.slider.valueChanged.connect(self.actualizeScene)
        self.checkBoxContour.stateChanged.connect(self.actualizeScene)
        self.rangeSlider.signalValueChanged.connect(self.actualizeScene)
        self.thresholWidget.radioButtonFull.clicked.connect(self.actualizeScene)
        self.thresholWidget.radioButtonBorder.clicked.connect(self.actualizeScene)

        # self.imageViewer.signalZoomFactorChanged.connect(self.changeInfoZoom)
        #self.imageViewer.signalMouseMoved.connect(self.changeLabelPosition)

        self.groupBoxOverlay.SignalOverlayChanged.connect(self.checkNewMode)

        self.checkBoxMask.stateChanged.connect(self.actualizeScene)
        self.checkBoxSuperPixels.stateChanged.connect(self.actualizeScene)
        self.checkBoxLearningMask.stateChanged.connect(self.actualizeScene)
        self.groupBoxProbabilities.SignalProbabilitiesChanged.connect(self.actualizeScene)
        self.checkBoxResult.stateChanged.connect(self.actualizeScene)

    # def keyEventNapari(self,event):
    #
    #     key = event.key()
    #
    #     # Ctrl
    #     if key == 16777249:
    #         self.ctrlPressed = True
    #
    #     self.imageViewer3D.canvas._backend._keyEvent(self.canvas.events.key_press, event)
    #     event.accept()

    def resizeEvent(self, event):

        heightWidgets = 0
        heightGroupBoxOverlay = 25 * vrb.ratio
        self.groupBoxOverlay.setFixedSize(260 * vrb.ratio, heightGroupBoxOverlay)
        heightWidgets += heightGroupBoxOverlay
        if self.mode == "overlay":
            heightSliderOpacity = 15 * vrb.ratio
            widthSliderOpacity = 200 * vrb.ratio
            # widthSliderOpacity = min(200*vrb.ratio,self.width() * 40 / 100)
            # widthSliderOpacity = max(widthSliderOpacity,150*vrb.ratio)
            self.sliderOpacity.setFixedSize(widthSliderOpacity, heightSliderOpacity)
            heightCheckBoxContour = 15 * vrb.ratio
            self.checkBoxContour.setFixedSize(70 * vrb.ratio, heightCheckBoxContour)
            # heightWidgets += heightSliderOpacity
        if self.mode == "threshold":
            heightSliderThreshold = 53 * vrb.ratio
            self.thresholWidget.setFixedSize(self.width() * 100 / 100, heightSliderThreshold)
            heightWidgets += heightSliderThreshold
        if self.moduleType in ["Pixel Classification", "Label Classification", "Super Pixel Classification"]:
            heightSliderOpacity = 15 * vrb.ratio
            widthSliderOpacity = max(200 * vrb.ratio, self.width() * 40 / 100)
            widthSliderOpacity = min(widthSliderOpacity, 400 * vrb.ratio)
            self.sliderOpacity.setFixedSize(widthSliderOpacity, heightSliderOpacity)
            self.emptyLabel.setFixedSize(widthSliderOpacity, heightSliderOpacity)

            # spaceRemaining = (self.width()-735*vrb.ratio)*0.5
            # spaceRemaining = max(0,spaceRemaining)
            # spaceRemaining = min(spaceRemaining,120*vrb.ratio)
            # self.groupBoxProbabilities.lutInformations.setFixedWidth(80*vrb.ratio+spaceRemaining)

            if self.moduleType == "Label Classification":
                heightLutInformations = 15 * vrb.ratio
                widthLutInformations = max(200 * vrb.ratio, self.width() * 40 / 100)
                widthLutInformations = min(widthLutInformations, 400 * vrb.ratio)
                self.lutInformations.setFixedSize(widthLutInformations, heightLutInformations)

        widthGroupViewer = self.width() * 100 / 100
        heightGroupViewer = max(1, self.height() * 100 / 100 - 15 * vrb.ratio - heightWidgets)
        self.groupViewerZone.setFixedSize(widthGroupViewer, heightGroupViewer)
        if self.modeViewer == "2D":
            self.imageViewerStandAloneNormal.setFixedSize(widthGroupViewer, heightGroupViewer)
        elif self.modeViewer == "3D":
            if self.with3D:
                self.imageViewer3D.setFixedSize(widthGroupViewer, heightGroupViewer)
                self.imageViewer3D.setFixedSize(widthGroupViewer-30, heightGroupViewer-30)
                self.imageViewer3D.setFixedSize(widthGroupViewer, heightGroupViewer)
        else:
            if self.with3D:
                self.imageViewer3D.setFixedSize(widthGroupViewer/2, heightGroupViewer/2)
                self.imageViewer3D.setFixedSize(widthGroupViewer/2-30, heightGroupViewer/2-30)
                self.imageViewer3D.setFixedSize(widthGroupViewer/2, heightGroupViewer/2)
            self.imageViewerStandAloneX.setFixedSize(widthGroupViewer/2, heightGroupViewer/2)
            self.imageViewerStandAloneY.setFixedSize(widthGroupViewer/2, heightGroupViewer/2)
            self.imageViewerStandAloneZ.setFixedSize(widthGroupViewer/2, heightGroupViewer/2)

        if self.figureVpl is not None:
            self.figureVpl.setFixedSize(self.width() * 100 / 100, max(1, self.height() * 100 / 100 - 15 * vrb.ratio))

    def showDocViewer3D(self):

        if vrb.mainWindow.groupMenu.buttonMovieMaker.activate:
            webbrowser.open_new_tab(vrb.folderDocEssential + "/moviemaker.html")
        else:
            webbrowser.open_new_tab(vrb.folderDocEssential + "/viewerdesc.html")


    def updateImageViewer(self):

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.updateImageViewer()

    def emitSignalRefreshPreview(self):

        self.SignalRefreshPreview.emit()

    def getRoiImage(self,changeRoiImage = False):

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.imageViewer.getRoiImage(changeRoiImage=changeRoiImage)

    def actualizeScene(self):

        if self.modeViewer != "2D":
            try:
                vrb.mainWindow.viewer3dSettingsWidget.updateVisualization()
            except:
                pass

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.getRoiImage(changeRoiImage=False)


    def actualizeSceneChangeRoi(self):

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.getRoiImage(changeRoiImage=True)

    def changeModeViewer(self,modeViewer):

        self.modeViewer = modeViewer

        vrb.mainWindow.changeModeViewer()
        self.resizeEvent(None)

        if modeViewer == "2D":
            self.groupBoxOverlay.setVisible(True)
            self.imageViewerStandAloneNormal.setVisible(True)
            self.imageViewer3D.setVisible(False)
            self.imageViewerStandAloneX.setVisible(False)
            self.imageViewerStandAloneY.setVisible(False)
            self.imageViewerStandAloneZ.setVisible(False)
            self.groupBoxOverlay.setVisible(True)
            self.pushButtonDocumentation.setVisible(False)

            self.listImageViewerStandAlone = [self.imageViewerStandAloneNormal]

        elif modeViewer == "3D":
            self.groupBoxOverlay.setVisible(False)
            self.imageViewerStandAloneNormal.setVisible(False)
            perspective = vrb.mainWindow.viewerNapari.camera.perspective
            self.imageViewer3D.setVisible(True)
            if vrb.mainWindow.viewerNapari.camera.perspective != perspective:
                vrb.mainWindow.viewerNapari.camera.perspective = perspective
                #zoom = vrb.mainWindow.viewerNapari.camera.zoom*0.5
                #vrb.mainWindow.viewerNapari.camera.zoom = zoom
            self.imageViewerStandAloneX.setVisible(False)
            self.imageViewerStandAloneY.setVisible(False)
            self.imageViewerStandAloneZ.setVisible(False)

            self.groupBoxOverlay.setVisible(False)
            self.groupBoxOverlay.checkBoxOverlay.setChecked(False)
            self.pushButtonDocumentation.setVisible(True)

            #vrb.mainWindow.viewer3dSettingsWidget.clippingSettings.sliderClipX.refreshValues()
            #vrb.mainWindow.viewer3dSettingsWidget.clippingSettings.sliderClipY.refreshValues()
            #vrb.mainWindow.viewer3dSettingsWidget.clippingSettings.sliderClipZ.refreshValues()
            # vrb.mainWindow.viewer3dSettingsWidget.thresholdSettings.thresholdSlider.refreshValues()

            self.listImageViewerStandAlone = [self.imageViewerStandAloneNormal]
            vrb.mainWindow.viewer3dSettingsWidget.loadSettings()
            vrb.mainWindow.resetView()
        else:
            self.groupBoxOverlay.setVisible(False)
            self.imageViewerStandAloneNormal.setVisible(False)
            perspective = vrb.mainWindow.viewerNapari.camera.perspective
            self.imageViewer3D.setVisible(True)
            if vrb.mainWindow.viewerNapari.camera.perspective != perspective:
                vrb.mainWindow.viewerNapari.camera.perspective = perspective
                #zoom = vrb.mainWindow.viewerNapari.camera.zoom*0.5
                #vrb.mainWindow.viewerNapari.camera.zoom = zoom
            self.imageViewerStandAloneX.setVisible(True)
            self.imageViewerStandAloneY.setVisible(True)
            self.imageViewerStandAloneZ.setVisible(True)

            self.groupBoxOverlay.setVisible(False)
            self.groupBoxOverlay.checkBoxOverlay.setChecked(False)
            self.pushButtonDocumentation.setVisible(True)

            vrb.mainWindow.viewer3dSettingsWidget.clippingSettings.sliderClipX.refreshValues()
            vrb.mainWindow.viewer3dSettingsWidget.clippingSettings.sliderClipY.refreshValues()
            vrb.mainWindow.viewer3dSettingsWidget.clippingSettings.sliderClipZ.refreshValues()
            # vrb.mainWindow.viewer3dSettingsWidget.thresholdSettings.thresholdSlider.refreshValues()

            self.listImageViewerStandAlone = [self.imageViewerStandAloneX,self.imageViewerStandAloneY,self.imageViewerStandAloneZ,self.imageViewerStandAloneNormal]

            vrb.mainWindow.viewer3dSettingsWidget.loadSettings()

        self.resizeEvent(None)

        if vrb.mainWindow.currentLabel is not None:
            vrb.mainWindow.changeCurrentXmlElement(vrb.mainWindow.currentLabel, verifModeViewer=False,resetRectangle=False)

    def setImage(self, imageLabel, changeRoi=True):

        try:
            self.imageLabel.groupBoxLut.lutArrayPreview = None
        except:
            pass

        try:
            self.imageLabel.groupBoxLut.SignalLutChanged.disconnect(self.actualizeScene)
        except:
            pass

        self.imageLabel = imageLabel
        try:
            self.imageLabel.groupBoxLut.SignalLutChanged.connect(self.actualizeScene)
        except:
            pass

        if imageLabel != None:
            try:
                self.image = imageLabel.image
            except:
                self.image = imageLabel
            self.infoTypeSize()
        else:
            self.image = None

        self.setImageViewer(changeRoi = changeRoi)

    def setImageOverlay(self, imageOverlayLabel, changeRoi=True):

        try:
            self.imageOverlayLabel.groupBoxLut.lutArrayPreview = None
        except:
            pass

        try:
            self.imageOverlayLabel.groupBoxLut.SignalLutChanged.disconnect(self.actualizeScene)
        except:
            pass

        self.imageOverlayLabel = imageOverlayLabel
        try:
            self.imageOverlayLabel.groupBoxLut.SignalLutChanged.connect(self.actualizeScene)
        except:
            pass
        if imageOverlayLabel != None:
            try:
                self.imageOverlay = imageOverlayLabel.image
            except:
                self.imageOverlay = imageOverlayLabel
        else:
            self.imageOverlay = None

        self.setImageViewerOverlay(changeRoi = changeRoi)

    def setImageDraw(self, imageDraw):

        self.imageDraw = imageDraw
        self.setImageViewerDraw()

    def setImageSuperPixels(self, imageSuperPixels):

        self.imageSuperPixels = imageSuperPixels
        self.setImageViewerSuperPixels()

    def setImageThreshold(self, imageThreshold):

        self.imageThreshold = imageThreshold
        self.setImageViewerThreshold()

    def setImageViewer(self,changeRoi = True):

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.setImageViewer()
            imageViewerStandAlone.changeInfoZoom()
            if changeRoi:
                imageViewerStandAlone.getRoiImage()

    def setImageViewerOverlay(self,changeRoi = True):

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.setImageViewerOverlay()
            if changeRoi:
                imageViewerStandAlone.getRoiImage()

    def setImageViewerDraw(self):

        start = time.time()

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.setImageViewerDraw()
            imageViewerStandAlone.getRoiImage()

    def setImageViewerSuperPixels(self):

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.setImageViewerSuperPixels()
            imageViewerStandAlone.getRoiImage()

    def setImageViewerThreshold(self):

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.setImageViewerThreshold()
            imageViewerStandAlone.getRoiImage()

    def changeMode(self, mode, acutalize=True):

        if mode != self.mode:
            self.mode = mode
            if mode == "classic":
                self.sliderOpacity.setVisible(False)
                self.checkBoxContour.setVisible(False)
                self.thresholWidget.setVisible(False)
                if self.moduleType == "Label Classification":
                    self.emptyLabel.setVisible(True)

                # if self.modeViewer != "2D":
                #     vrb.mainWindow.viewer3dSettingsWidget.updateThreshold()

            elif mode == "overlay":
                self.sliderOpacity.setVisible(True)
                self.emptyLabel.setVisible(False)
                if self.moduleType == "Classic":
                    self.checkBoxContour.setVisible(True)
                self.thresholWidget.setVisible(False)
            elif mode == "threshold":
                self.sliderOpacity.setVisible(False)
                self.checkBoxContour.setVisible(False)
                self.thresholWidget.setVisible(True)

            self.resizeEvent(None)
            if acutalize:
                for imageViewerStandAlone in self.listImageViewerStandAlone:
                    imageViewerStandAlone.getRoiImage(changeRoiImage=False)

    def checkNewMode(self):

        vrb.barycenterX = None
        vrb.barycenterY = None
        vrb.barycenterZ = None
        vrb.currentShapeAnalysisDisplayer = None
        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.getRoiImage(changeRoiImage=False)

        if self.groupBoxOverlay.checkBoxOverlay.isChecked():
            imageOverlay = self.groupBoxOverlay.comboBoxOverlay.currentData()
        else:
            imageOverlay = None
        self.setImageOverlay(imageOverlay)

        if self.mode != "threshold":
            if self.groupBoxOverlay.checkBoxOverlay.isChecked() and self.groupBoxOverlay.comboBoxOverlay.currentIndex() != -1:
                self.changeMode("overlay")
            else:
                self.changeMode("classic")

        self.SignalOverlayChanged.emit()

    def infoTypeSize(self):

        text = ""
        if self.image.getSizeZ() == 1:
            text += "2D "
        else:
            text += "3D "
        if self.image.getSizeT() > 1:
            text += "Sequence (" + str(self.image.getSizeT()) + ") "
        if self.image.getSizeC() == 1:
            text += "Grey "
        else:
            text += "Color "
        text += str(self.image.getSizeX()) + " x " + str(self.image.getSizeY())
        if self.image.getSizeZ() > 1:
            text += " x " + str(self.image.getSizeZ())
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Binary:
            text += " Binary"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Int8:
            text += " Int8"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_UInt8:
            text += " UInt8"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Int16:
            text += " Int16"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_UInt16:
            text += " UInt16"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Int32:
            text += " Int32"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_UInt32:
            text += " UInt32"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Label8:
            text += " Label8"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Label16:
            text += " Label16"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Label32:
            text += " Label32"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Real32:
            text += " Real32"

        for imageViewerStandAlone in self.listImageViewerStandAlone:
            imageViewerStandAlone.widgetInfo.labelTypeSize.setText(text)

    def transformImage(self, image, imageOverlay=None, imageDraw=None, imageProbabilities=None, imageThreshold=None, imageSuperPixels=None, noPreview=False, extractImage=False):

        PyIPSDK.setNbMaxThreads(1)

        bufferRef = image.getBufferType()

        if self.moduleType == "Classic":
            try:
                if self.parent is None or (self.parent.graphicElements is None or self.parent.graphicElements.previewMode == False) or noPreview:
                    if self.mode == "threshold":

                        if imageThreshold is None:
                            imageThreshold = util.copyImg(image)
                        if imageThreshold.getSizeC() == 3:
                            imageThreshold = colorIP.lightnessImg(imageThreshold)

                        if self.thresholdMode in ["classic","topHat"]:
                            imageThreshold = bin.thresholdImg(imageThreshold, self.rangeSlider.currentValueMin, self.rangeSlider.currentValueMax)
                        elif self.thresholdMode == "hysteresisLight":
                            imageThreshold = bin.lightHysteresisThreshold2dImg(imageThreshold,self.rangeSlider.currentValueMax,self.rangeSlider.currentValueMin)
                        elif self.thresholdMode == "hysteresisDark":
                            imageThreshold = bin.darkHysteresisThreshold2dImg(imageThreshold,self.rangeSlider.currentValueMin,self.rangeSlider.currentValueMax)

                        if self.thresholWidget.radioButtonBorder.isChecked():
                            inSE = PyIPSDK.circularSEXYInfo(2)
                            maskErode = morpho.erode2dImg(imageThreshold, inSE)
                            imageThreshold = arithm.subtractImgImg(imageThreshold, maskErode)
                            imageThreshold = util.convertImg(imageThreshold, PyIPSDK.eIBT_Binary)
                        imageOverlay = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, imageThreshold.getSizeX(), imageThreshold.getSizeY())
                        util.eraseImg(imageOverlay, 0)
                        redPlan = util.convertImg(imageThreshold, PyIPSDK.eIBT_UInt8)
                        redPlan = arithm.multiplyScalarImg(redPlan, 200)
                        redPlan = util.convertImg(redPlan, PyIPSDK.eIBT_UInt8)
                        redPlanOverlay = PyIPSDK.extractPlan(0, 0, 0, imageOverlay)
                        util.copyImg(redPlan, redPlanOverlay)

                        if self.imageLabel.valueMax - self.imageLabel.valueMin != 0:
                            image = util.convertImg(image, PyIPSDK.eIBT_Real32)
                            image = arithm.addScalarImg(image, -self.imageLabel.valueMin)
                            image = arithm.multiplyScalarImg(image, 255 / (self.imageLabel.valueMax - self.imageLabel.valueMin))
                        else:
                            image = util.copyImg(image)
                        image = util.convertImg(image, PyIPSDK.eIBT_UInt8)

                        outImage = customBlending(imageOverlay, image, 1, refImage=imageThreshold)

                    else:

                        if self.parent is not None:
                            try:
                                image = fct.imageToDisplay(image, self.imageLabel, mode=self.parent.groupContrast.currentModeScale, widgetContrast=self.parent.widgetContrast)
                            except:
                                image = fct.imageToDisplay(image, self.imageLabel)
                        else:
                            image = fct.imageToDisplay(image, self.imageLabel)

                        if self.mode == "overlay" and self.imageOverlayLabel is not None:

                            buffer = imageOverlay.getBufferType()

                            if self.checkBoxContour.isChecked() and self.imageOverlay.getBufferType() in [PyIPSDK.eIBT_Binary, PyIPSDK.eIBT_Label8, PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:
                                if image.getSizeZ() == 1:
                                    if extractImage:
                                        inSE = PyIPSDK.rectangularSEXYInfo(1, 1)
                                    else:
                                        inSE = PyIPSDK.rectangularSEXYInfo(3, 3)
                                    maskErode = morpho.erode2dImg(imageOverlay, inSE)
                                else:
                                    inSE = PyIPSDK.rectangularSEXYZInfo(1, 1, 1)
                                    maskErode = morpho.erode3dImg(imageOverlay, inSE)
                                imageOverlay = arithm.subtractImgImg(imageOverlay, maskErode)
                                if buffer == PyIPSDK.eIBT_Binary:
                                    imageOverlay = util.convertImg(imageOverlay, buffer)
                                else:
                                    imageOverlay = bin.lightThresholdImg(imageOverlay, 1)

                            try:
                                checkBackground = self.imageOverlayLabel.groupBoxLut.checkBoxBackground.isChecked()
                            except:
                                checkBackground = True
                            if imageOverlay.getSizeC() == 1 and (checkBackground or vrb.ignoreBackgroundOverlay):
                                if imageOverlay.getBufferType() == PyIPSDK.eIBT_Binary:
                                    mask = util.copyImg(imageOverlay)
                                else:
                                    if self.imageOverlayLabel.valueMax > 0:
                                        if self.imageOverlayLabel.valueMinMask is None:
                                            self.imageOverlayLabel.valueMinMask = fct.getValueMinMask(self.imageOverlay)
                                        mask = bin.lightThresholdImg(imageOverlay, self.imageOverlayLabel.valueMinMask)
                                    else:
                                        mask = PyIPSDK.createImage(imageOverlay, PyIPSDK.eIBT_Binary)
                                        util.eraseImg(mask, 0)
                            else:
                                mask = None
                            if self.parent is not None:

                                if bufferRef == PyIPSDK.eIBT_Binary and buffer == PyIPSDK.eIBT_Binary:
                                    lutToApply = lutBinaryRedVector
                                else:
                                    lutToApply = None

                                imageOverlay = fct.imageToDisplay(imageOverlay, self.imageOverlayLabel, mode=self.parent.groupContrast.currentModeScale, widgetContrast=self.parent.widgetContrast,lutToApply = lutToApply)
                            else:
                                imageOverlay = fct.imageToDisplay(imageOverlay, self.imageOverlayLabel)

                            if (self.imageOverlay.getBufferType() in [PyIPSDK.eIBT_Label8, PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]) and self.imageOverlayLabel.groupBoxLut.lutArrayPreview is not None:
                                plan = PyIPSDK.extractPlan(0, 0, 0, imageOverlay)
                                mask = bin.thresholdImg(plan, 40, 210)

                            outImage = customBlending(imageOverlay, image, self.sliderOpacity.slider.value() / 100, refImage=mask)
                        else:
                            outImage = image

                else:
                    try:
                        outImage = self.applyPreview(image)
                        if vrb.previewError == False:
                            self.parent.graphicElements.previewColor = vrb.dictColor[2]
                        else:
                            self.parent.graphicElements.previewColor = vrb.dictColor[3]
                    except Exception as e:
                        print(traceback.format_exc())
                        self.parent.graphicElements.previewColor = vrb.dictColor[3]
                        outImage = self.transformImage(image, imageOverlay=imageOverlay, imageDraw=imageDraw, imageThreshold=imageThreshold, noPreview=True)
                        # outImage = util.copyImg(image)

            except Exception as e:

                # print(traceback.format_exc())
                outImage = util.copyImg(image)

            outImage = util.convertImg(outImage, PyIPSDK.eIBT_UInt8)

        elif self.moduleType == "Pixel Classification":

            try:
                outImage = fct.imageToDisplay(image, self.imageLabel, mode=self.module.groupContrast.currentModeScale, widgetContrast=self.module.widgetContrast)
            except:
                outImage = fct.imageToDisplay(image, self.imageLabel)

            if imageOverlay is not None:

                mask = PyIPSDK.createImage(PyIPSDK.eIBT_Binary, imageOverlay.getSizeX(), imageOverlay.getSizeY())
                util.eraseImg(mask, 0)

                # mask = bin.lightThresholdImg(imageOverlay, 1)

                nbLabels = self.module.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()
                for numLabel in range(nbLabels):
                    labelItem = self.module.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
                    if labelItem is not None:
                        labelWidget = labelItem.widget()
                        value = labelWidget.value
                        if value >= 1 and labelWidget.buttonViewLabel.activate:
                            try:
                                maskCurrent = bin.thresholdImg(imageOverlay, value, value)
                                mask = logic.bitwiseOrImgImg(mask, maskCurrent)
                            except:
                                pass

                imageOverlay = fct.applyLut(imageOverlay, self.module.customLutOverlay)

                if self.checkBoxProbabilities.isChecked() and imageProbabilities is not None:

                    if self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Mixed":

                        imageOverlay = util.convertImg(imageOverlay, PyIPSDK.eIBT_Real32)
                        imageOverlay = arithm.genericMultiplyImgImg(imageOverlay, imageProbabilities)
                        imageOverlay = util.convertImg(imageOverlay, PyIPSDK.eIBT_UInt8)

                        outImage = customBlending(imageOverlay, outImage, self.sliderOpacity.slider.value() / 100)

                    elif self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Grey":
                        imageOverlay = arithm.multiplyScalarImg(imageProbabilities, 255)
                        imageOverlay = util.convertImg(imageOverlay, PyIPSDK.eIBT_UInt8)
                        outImage = customBlending(imageOverlay, outImage, self.sliderOpacity.slider.value() / 100)
                    elif self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() in ["Proba", "Jet"]:

                        try:
                            valueMin = float(self.groupBoxProbabilities.lutInformations.labelMin.label.text())
                            if valueMin < 0:
                                valueMin = 0
                                self.groupBoxProbabilities.lutInformations.labelMin.label.setText("0")
                            if valueMin >= 1:
                                valueMin = 0
                                self.groupBoxProbabilities.lutInformations.labelMin.label.setText("0")
                        except:
                            valueMin = 0
                            self.groupBoxProbabilities.lutInformations.labelMin.label.setText("0")

                        imageOverlay = arithm.addScalarImg(imageProbabilities, -valueMin)
                        imageOverlay = arithm.multiplyScalarImg(imageOverlay, 255 / (1 - valueMin))
                        imageOverlay = util.convertImg(imageOverlay, PyIPSDK.eIBT_UInt8)
                        if self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Proba":
                            imageLut = fct.lutImageFromArray(lutProba["Array"])
                        elif self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Jet":
                            imageLut = fct.lutImageFromArray(lutJet["Array"])
                        currentLut = lutFromVector(imageLut)
                        imageOverlay = fct.applyLut(imageOverlay, currentLut)
                        outImage = customBlending(imageOverlay, outImage, self.sliderOpacity.slider.value() / 100)

                else:
                    outImage = customBlending(imageOverlay, outImage, self.sliderOpacity.slider.value() / 100, refImage=mask)

            if imageDraw is not None and self.checkBoxMask.isChecked():

                mask = bin.thresholdImg(imageDraw, 0, 0)
                nbLabels = self.module.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()
                for numLabel in range(nbLabels):
                    labelItem = self.module.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
                    if labelItem is not None:
                        labelWidget = labelItem.widget()
                        if not labelWidget.buttonViewLabel.activate:
                            maskCurrent = bin.thresholdImg(imageDraw, numLabel + 1, numLabel + 1)
                            mask = logic.bitwiseOrImgImg(mask, maskCurrent)
                notMask = bin.thresholdImg(mask, 0, 0)

                if outImage.getSizeC() == 1:
                    outImage = greyToColor(outImage)
                imageDraw = fct.applyLut(imageDraw, self.module.customLutDraw)
                imageDraw = arithm.genericMultiplyImgImg(imageDraw, notMask)
                outImage = arithm.genericMultiplyImgImg(outImage, mask)
                outImage = arithm.addImgImg(outImage, imageDraw)

        elif self.moduleType == "Label Classification":

            mask = None
            imageRef = util.copyImg(image)
            if self.module.settingsWidget.buttonViewFeatures.activate:

                mask = bin.lightThresholdImg(image, 1)
                index = self.imageLabel.currentFeaturesIndex

                measure = self.imageLabel.features[index]
                lut = PyIPSDK.createIntensityLUT(0, 1, measure)

                imageMeasure = util.convertImg(image, PyIPSDK.eIBT_Real32)
                itrans.lutTransform2dImg(image, lut, imageMeasure)

                minMeasure, maxMeasure = min(measure[1:]), max(measure[1:])

                imageMeasure = arithm.addScalarImg(imageMeasure, -minMeasure)
                if maxMeasure != minMeasure:
                    imageMeasure = arithm.multiplyScalarImg(imageMeasure, 255 / (maxMeasure - minMeasure))
                imageMeasure = util.convertImg(imageMeasure, PyIPSDK.eIBT_UInt8)

                imageLut = fct.lutImageFromArray(lutJet["Array"])
                currentLut = lutFromVector(imageLut)
                imageLabeled = fct.applyLut(imageMeasure, currentLut)

                imageLabeled = arithm.genericMultiplyImgImg(imageLabeled, mask)

            else:
                if self.checkBoxResult.isChecked() and self.imageLabel.vectorPrediction is not None:
                    lut = PyIPSDK.createIntensityLUT(0, 1, self.imageLabel.vectorPrediction)
                    image = itrans.lutTransform2dImg(image, lut)

                    customLutOverlay = self.module.labelScrollArea.getCustomLutOverlay()
                    imageLabeled = fct.applyLut(image, customLutOverlay)

                else:
                    imageLabeled = fct.imageToDisplay(image, self.imageLabel)

            if self.mode == 'classic':
                outImage = imageLabeled
            else:
                if mask is None:
                    mask = bin.lightThresholdImg(image, 1)

                if imageOverlay.getSizeC() > 1:
                    outImage = fct.convertToRgbImage(imageOverlay, self.imageLabel)
                else:
                    outImage = imageOverlay
                # outImage = fct.imageToDisplay(imageOverlay,self.imageLabel)
                outImage = util.convertImg(outImage, PyIPSDK.eIBT_Real32)
                outImage = arithm.addScalarImg(outImage, -self.imageLabel.valueMinGrey)
                outImage = arithm.multiplyScalarImg(outImage, 255 / (self.imageLabel.valueMaxGrey - self.imageLabel.valueMinGrey))
                outImage = util.convertImg(outImage, PyIPSDK.eIBT_UInt8)

                outImage = customBlending(imageLabeled, outImage, self.sliderOpacity.slider.value() / 100, refImage=mask)

            try:
                markedElement = []
                lutMarkedElement = [0]
                graphicElement = Dfct.SubElement(self.imageLabel.xmlElement, "GraphicElement")
                for child in graphicElement:
                    markedElement.append(int(Dfct.childText(child, 'LabelValue')))
                for i in range(1, int(self.imageLabel.valueMax)):
                    if i in markedElement:
                        lutMarkedElement.append(255)
                    else:
                        lutMarkedElement.append(0)

                lut = PyIPSDK.createIntensityLUT(0, 1, lutMarkedElement)
                imageMarked = itrans.lutTransform2dImg(imageRef, lut)
                imageMarked = util.convertImg(imageMarked, PyIPSDK.eIBT_UInt8)

                inSE = PyIPSDK.circularSEXYInfo(2)
                imageMarkedContour = morpho.erode2dImg(imageMarked, inSE)
                imageMarkedContour = arithm.subtractImgImg(imageMarked, imageMarkedContour)
                imageMarkedContour = util.convertImg(imageMarkedContour, PyIPSDK.eIBT_UInt8)

                for c in range(0, 3):
                    plan = PyIPSDK.extractPlan(0, c, 0, outImage)
                    resultPlan = arithm.formula2dImg("if (I2==0,I1,I2)", InOptImg1=plan, InOptImg2=imageMarkedContour)
                    resultPlan = util.convertImg(resultPlan, PyIPSDK.eIBT_UInt8)
                    util.copyImg(resultPlan, plan)

            except:
                print(traceback.format_exc())

        elif self.moduleType == "Super Pixel Classification":

            try:
                outImage = fct.imageToDisplay(image, self.imageLabel, mode=self.module.groupContrast.currentModeScale, widgetContrast=self.module.widgetContrast)
            except:
                outImage = fct.imageToDisplay(image, self.imageLabel)

            labelActivated = []
            colorVector = []
            nbLabels = self.module.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()
            for numLabel in range(nbLabels):
                labelItem = self.module.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
                if labelItem is not None:
                    labelWidget = labelItem.widget()
                    value = labelWidget.value
                    if labelWidget.buttonViewLabel.activate:
                        labelActivated.append(value)
                    colorVector.append(labelWidget.color)

            if self.module.model is not None:

                if len(self.imageLabel.resultVector) != 0 and self.checkBoxProbabilities.isChecked() == False:

                    resultVector = self.imageLabel.resultVector
                    resultMaskVector = []
                    for i in range(len(resultVector)):
                        if resultVector[i] > 0 and resultVector[i] in labelActivated:
                            resultMaskVector.append(1)
                        else:
                            resultMaskVector.append(0)

                    lutMask = PyIPSDK.createIntensityLUT(0, 1, resultMaskVector)
                    imageResultMask = itrans.lutTransform2dImg(imageSuperPixels, lutMask)
                    imageResultMask = util.convertImg(imageResultMask, PyIPSDK.eIBT_Binary)

                    arrayColor = [[], [], []]
                    for i in range(len(resultVector)):
                        for c in range(3):
                            arrayColor[c].append(colorVector[int(resultVector[i])][c])

                    imageOverlay = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
                    util.eraseImg(imageOverlay, 0)
                    for c in range(3):
                        lut = PyIPSDK.createIntensityLUT(0, 1, arrayColor[c])
                        plan = itrans.lutTransform2dImg(imageSuperPixels, lut)
                        plan = util.convertImg(plan, PyIPSDK.eIBT_UInt8)

                        planOverlay = PyIPSDK.extractPlan(0, c, 0, imageOverlay)
                        util.copyImg(plan, planOverlay)

                    outImage = customBlending(imageOverlay, outImage, self.sliderOpacity.slider.value() / 100, refImage=imageResultMask)

                if len(self.imageLabel.probabilitiesVector) != 0 and self.checkBoxProbabilities.isChecked():

                    resultVector = self.imageLabel.resultVector
                    probabilitiesVector = self.imageLabel.probabilitiesVector

                    lutVector = [[], [], []]

                    jetArray = lutJet["Array"]

                    for i in range(len(resultVector)):

                        classValue = resultVector[i]
                        probaValue = probabilitiesVector[i][int(classValue)]

                        if self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Proba":
                            lutVector[0].append((1 - probaValue) * 255)
                            lutVector[1].append(probaValue * 255)
                            lutVector[2].append(0)
                        elif self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Jet":
                            if probaValue == 0:
                                lutVector[0].append(0)
                                lutVector[1].append(0)
                                lutVector[2].append(255)
                            else:
                                probaValue = 1 - probaValue
                                seed = int(probaValue * 8)
                                for c in range(3):
                                    lutValue = jetArray[seed + 1][c] * (probaValue * 8 - seed) + jetArray[seed][c] * (1 - probaValue * 8 + seed)
                                    lutVector[c].append(lutValue)
                        elif self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Grey":
                            lutVector[0].append(probaValue * 255)
                            lutVector[1].append(probaValue * 255)
                            lutVector[2].append(probaValue * 255)
                        elif self.groupBoxProbabilities.comboBoxLutProbabilities.currentText() == "Mixed":
                            for c in range(3):
                                lutVector[c].append(probaValue * colorVector[int(classValue)][c])

                    imageOverlay = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
                    util.eraseImg(imageOverlay, 0)
                    for c in range(3):
                        lut = PyIPSDK.createIntensityLUT(0, 1, lutVector[c])
                        plan = itrans.lutTransform2dImg(imageSuperPixels, lut)
                        plan = util.convertImg(plan, PyIPSDK.eIBT_UInt8)
                        planOverlay = PyIPSDK.extractPlan(0, c, 0, imageOverlay)
                        util.copyImg(plan, planOverlay)

                    outImage = customBlending(imageOverlay, outImage, self.sliderOpacity.slider.value() / 100)

            if imageSuperPixels is not None and self.checkBoxSuperPixels.isChecked():

                inSE = PyIPSDK.rectangularSEXYInfo(1, 1)
                maskErode = morpho.erode2dImg(imageSuperPixels, inSE)
                maskDilate = morpho.dilate2dImg(imageSuperPixels, inSE)
                imageMask = arithm.subtractImgImg(maskDilate, maskErode)
                imageMask = bin.lightThresholdImg(imageMask, 1)

                imageOverlay = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
                util.eraseImg(imageOverlay, 0)
                bluePlan = util.convertImg(imageMask, PyIPSDK.eIBT_UInt8)
                bluePlan = arithm.multiplyScalarImg(bluePlan, 200)
                bluePlan = util.convertImg(bluePlan, PyIPSDK.eIBT_UInt8)
                bluePlanOverlay = PyIPSDK.extractPlan(0, 2, 0, imageOverlay)
                util.copyImg(bluePlan, bluePlanOverlay)

                outImage = customBlending(imageOverlay, outImage, 1, refImage=imageMask)

                try:

                    if self.checkBoxLearningMask.isChecked():

                        allSuperPixelsElement = Dfct.SubElement(self.imageLabel.xmlElement, "AllSuperPixels")
                        arraySelectedColorMask = numpy.zeros((int(self.imageLabel.nbSuperPixels + 1)))
                        arraySelectedColor = []
                        for c in range(3):
                            arraySelectedColor.append(numpy.zeros((int(self.imageLabel.nbSuperPixels + 1))))

                        for child in allSuperPixelsElement:
                            labelValue = int(Dfct.childText(child, "LabelValue"))
                            numClass = int(Dfct.childText(child, "Class"))
                            if numClass in labelActivated:
                                arraySelectedColorMask[labelValue] = 1
                                for c in range(3):
                                    arraySelectedColor[c][labelValue] = colorVector[numClass][c] * 0.7

                        lut = PyIPSDK.createIntensityLUT(0, 1, arraySelectedColorMask)
                        imageSuperPixelsColorSelectedMask = itrans.lutTransform2dImg(imageSuperPixels, lut)
                        imageSuperPixelsColorSelectedMask = util.convertImg(imageSuperPixelsColorSelectedMask, PyIPSDK.eIBT_Binary)

                        imageOverlay = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
                        util.eraseImg(imageOverlay, 0)
                        for c in range(3):
                            lut = PyIPSDK.createIntensityLUT(0, 1, arraySelectedColor[c])
                            plan = itrans.lutTransform2dImg(imageSuperPixels, lut)
                            plan = util.convertImg(plan, PyIPSDK.eIBT_UInt8)
                            planOverlay = PyIPSDK.extractPlan(0, c, 0, imageOverlay)
                            util.copyImg(plan, planOverlay)

                        outImage = customBlending(imageOverlay, outImage, 1, refImage=imageSuperPixelsColorSelectedMask)

                    allSuperPixelsElement = Dfct.SubElement(self.imageLabel.xmlElement, "AllSuperPixels")
                    arraySelected = numpy.zeros((int(self.imageLabel.nbSuperPixels + 1)))
                    for child in allSuperPixelsElement:
                        labelValue = int(Dfct.childText(child, "LabelValue"))
                        arraySelected[labelValue] = 1

                    # Selected SuperPixels in White

                    lut = PyIPSDK.createIntensityLUT(0, 1, arraySelected)
                    imageSuperPixelsSelectedMask = itrans.lutTransform2dImg(imageSuperPixels, lut)

                    imageSuperPixelsSelectedMask = util.convertImg(imageSuperPixelsSelectedMask, PyIPSDK.eIBT_Binary)
                    imageSuperPixelsSelected = logic.maskImg(imageSuperPixels, imageSuperPixelsSelectedMask)

                    inSE = PyIPSDK.rectangularSEXYInfo(1, 1)
                    maskErode = morpho.erode2dImg(imageSuperPixelsSelected, inSE)
                    maskDilate = morpho.dilate2dImg(imageSuperPixelsSelected, inSE)
                    imageMask = arithm.subtractImgImg(maskDilate, maskErode)
                    imageMask = bin.lightThresholdImg(imageMask, 1)

                    imageOverlay = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
                    util.eraseImg(imageOverlay, 0)
                    for c in range(3):
                        plan = util.convertImg(imageMask, PyIPSDK.eIBT_UInt8)
                        plan = arithm.multiplyScalarImg(plan, 255)
                        plan = util.convertImg(plan, PyIPSDK.eIBT_UInt8)
                        planOverlay = PyIPSDK.extractPlan(0, c, 0, imageOverlay)
                        util.copyImg(plan, planOverlay)

                    outImage = customBlending(imageOverlay, outImage, 1, refImage=imageMask)

                except:
                    traceback.print_exc(file=sys.stderr)

        try:
            nbMaxThread = PyIPSDK.getDefaultNbMaxThreads()
            PyIPSDK.setNbMaxThreads(nbMaxThread)
        except:
            pass

        return outImage

    def applyPreview(self, image):

        if self.parent.imagePreview is not None:
            imagePreview = self.parent.imagePreview
            if self.imageLabel.valueMax - self.imageLabel.valueMin != 0:
                image = util.convertImg(image, PyIPSDK.eIBT_Real32)
                image = arithm.addScalarImg(image, -self.imageLabel.valueMin)
                image = arithm.multiplyScalarImg(image, 255 / (self.imageLabel.valueMax - self.imageLabel.valueMin))
            else:
                image = util.copyImg(image)
            image = util.convertImg(image, PyIPSDK.eIBT_UInt8)

            roiSizeX, roiSizeY = self.imageViewer.getRoiSize()
            usefulSizeX, usefulSizeY = self.imageViewer.getUsefulSizeScene()
            ratio = (roiSizeX / usefulSizeX + roiSizeY / usefulSizeY) / 2
            currentZoom = 1 / ratio

            pStartX, pStartY, pEndX, pEndY = 0, 0, self.previewSizeX, self.previewSizeY
            iStartX, iStartY = self.imageViewer.realStartPointX - self.previewMinX, self.imageViewer.realStartPointY - self.previewMinY
            iEndX, iEndY = iStartX + roiSizeX, iStartY + roiSizeY

            startX = max(pStartX, iStartX)
            startY = max(pStartY, iStartY)
            endX = min(pEndX, iEndX)
            endY = min(pEndY, iEndY)

            if startX < endX and startY < endY:
                roiImage = util.getROI2dImg(imagePreview, round(startX), round(startY), round(endX - startX), round(endY - startY))
                startX = round((startX + self.previewMinX - self.imageViewer.realStartPointX) * currentZoom)
                startY = round((startY + self.previewMinY - self.imageViewer.realStartPointY) * currentZoom)

                endX = (endX + self.previewMinX - self.imageViewer.realStartPointX) * currentZoom
                endY = (endY + self.previewMinY - self.imageViewer.realStartPointY) * currentZoom
                endX = min(endX, image.getSizeX())
                endY = min(endY, image.getSizeY())
                sizeX = round(endX - startX)
                sizeY = round(endY - startY)

                if sizeX > 0 and sizeY > 0:
                    # outGeometry = PyIPSDK.geometry2d(roiImage.getBufferType(), sizeX, sizeY)
                    if roiImage.getSizeC() == 1:
                        roiResized = PyIPSDK.createImage(roiImage.getBufferType(), sizeX, sizeY)
                    else:
                        roiResized = PyIPSDK.createImageRgb(roiImage.getBufferType(), sizeX, sizeY)

                    interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
                    gtrans.zoom2dImg(roiImage, interp, roiResized)
                    roiImage = roiResized

                    if imagePreview.getBufferType() == PyIPSDK.eIBT_Binary:
                        roiImage = util.convertImg(roiImage, PyIPSDK.eIBT_UInt8)
                        roiImage = arithm.multiplyScalarImg(roiImage, 255)
                    elif imagePreview.getBufferType() in [PyIPSDK.eIBT_Label8, PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:
                        if imagePreview.valueMax != 0:
                            roiImage = util.convertImg(roiImage, PyIPSDK.eIBT_Real32)
                            roiImage = arithm.multiplyScalarImg(roiImage, 255 / imagePreview.valueMax)
                    else:
                        if self.image.getBufferType() in [PyIPSDK.eIBT_Binary, PyIPSDK.eIBT_Label8, PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:
                            valueMin, valueMax = imagePreview.valueMin, imagePreview.valueMax
                        else:
                            valueMin, valueMax = self.imageLabel.valueMin, self.imageLabel.valueMax
                        if valueMax - valueMin != 0:
                            roiImage = util.convertImg(roiImage, PyIPSDK.eIBT_Real32)
                            roiImage = arithm.addScalarImg(roiImage, -valueMin)
                            roiImage = arithm.multiplyScalarImg(roiImage, 255 / (valueMax - valueMin))
                    roiImage = util.convertImg(roiImage, PyIPSDK.eIBT_UInt8)

                    outImage = util.copyImg(image)

                    if outImage.getSizeC() == 1 and roiImage.getSizeC() == 3:
                        outImage = greyToColor(outImage)
                    if outImage.getSizeC() == 3 and roiImage.getSizeC() == 1:
                        roiImage = greyToColor(roiImage)

                    util.putROI2dImg(outImage, roiImage, round(startX), round(startY), outImage)
                else:
                    outImage = util.copyImg(image)

        else:
            outImage = util.copyImg(image)

        return outImage


def lutFromVector(vector):
    lutArray = []
    lutArray.append([])
    lutArray.append([])
    lutArray.append([])
    for i in range(255, -1, -1):
        index = int(i * len(vector) / 256)
        lutArray[0].append(vector[index][0][0])
        lutArray[1].append(vector[index][0][1])
        lutArray[2].append(vector[index][0][2])

    return lutArray


# bufferList = [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32, PyIPSDK.eIBT_Binary]


def customBlending(imageOverlay, image, value, refImage=None):
    if imageOverlay.getSizeC() == image.getSizeC():
        imageAdd = arithm.blendImgImg(imageOverlay, image, value)
    else:
        img1 = arithm.multiplyScalarImg(imageOverlay, value)
        img2 = arithm.multiplyScalarImg(image, 1 - value)
        if imageOverlay.getSizeC() > image.getSizeC():
            imageAdd = arithm.genericAddImgImg(img1, img2)
        else:
            imageAdd = arithm.genericAddImgImg(img2, img1)

    if refImage is None:
        outImage = imageAdd
    else:
        imageMask = logic.reverseMaskImg(image, refImage)
        imageAdd = logic.maskImg(imageAdd, refImage)
        if imageMask.getSizeC() == imageAdd.getSizeC():
            outImage = arithm.addImgImg(imageMask, imageAdd)
        elif imageMask.getSizeC() > imageAdd.getSizeC():
            outImage = arithm.genericAddImgImg(imageMask, imageAdd)
        else:
            outImage = arithm.genericAddImgImg(imageAdd, imageMask)

    if outImage.getBufferType() != PyIPSDK.eIBT_UInt8:
        outImage = util.convertImg(outImage, PyIPSDK.eIBT_UInt8)

    return outImage


def greyToColor(imageProcess, bufferType=PyIPSDK.eImageBufferType.eIBT_UInt8):
    colorGeometry = PyIPSDK.ColorGeometry()
    colorGeometry.initRgb()
    volumeGeometry = PyIPSDK.VolumeGeometry()
    if imageProcess.getSizeZ() == 1:
        volumeGeometry.init2d()
    else:
        volumeGeometry.init3d(imageProcess.getSizeZ())
    temporalGeometry = PyIPSDK.TemporalGeometry()
    temporalGeometry.initSingle()
    geometry = PyIPSDK.geometry(bufferType, imageProcess.getSizeX(), imageProcess.getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)
    outImage = PyIPSDK.createImage(geometry)
    # outImage = PyIPSDK.createImageRgb(bufferType, imageProcess.getSizeX(), imageProcess.getSizeY())

    for c in range(0, 3):
        if imageProcess.getSizeZ() == 1:
            plan = PyIPSDK.extractPlan(0, c, 0, outImage)
            util.copyImg(imageProcess, plan)
        else:
            volume = PyIPSDK.extractVolume(c, 0, outImage)
            util.copyImg(imageProcess, volume)

    return outImage


if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook


    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)


    img = PyIPSDK.loadTiffImageFile("imageFilename")

    img.valueMin, img.valueMax = fct.getMinMaxValue(img)
    img.valueMinMask = None

    sys.excepthook = exception_hook

    foo = WidgetImage()
    foo.setImage(img)

    foo.resize(800, 800)
    foo.show()

    app.exec_()