import sys
import os
import traceback

from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import xml.etree.ElementTree as xmlet

import UsefullWidgets as wgt
import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct
import UsefullTexts as txt

import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK

from GroupCalibration import GroupBoxCalibration
from GroupColorCalibration import GroupColorCalibration
from RangeSlider import RangeSlider

import numpy as np

class GroupBoxContrast(qt.QGroupBox):

    def __init__(self,parentWidget = None):
        qt.QGroupBox.__init__(self)

        self.allowContrastChanging = True

        self.parentWidget = parentWidget

        self.currentModeScale = "Linear"

        totalWidth = 0

        self.buttonAuto = wgt.PushButtonImage(vrb.folderImages + "/Auto_Min_Max.png")
        self.buttonAuto.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonAuto.setToolTip(txt.dictToolTips["MinMaxContrastArea"])
        totalWidth+=30*vrb.ratio

        self.buttonLock = wgt.PushButtonDoubleImage(vrb.folderImages + "/Lock.png",vrb.folderImages + "/Lock_pressed.png")
        self.buttonLock.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonLock.setToolTip(txt.dictToolTips["LockContrast"])
        totalWidth+=30*vrb.ratio

        font = QtGui.QFont()
        font.setPixelSize(10*vrb.ratio)
        font.setBold(True)

        self.labelMin = qt.QLabel("Min")
        self.labelMin.setFont(font)
        self.labelMin.setFixedSize(35*vrb.ratio,17*vrb.ratio)
        self.labelMin.setAlignment(Qt.AlignRight | Qt.AlignVCenter)
        totalWidth+=35*vrb.ratio

        self.lineEditMin = qt.QLineEdit()
        self.lineEditMin.setFixedSize(70*vrb.ratio,17*vrb.ratio)
        self.lineEditMin.setAlignment(Qt.AlignRight | Qt.AlignVCenter)
        self.lineEditMin.setFont(font)
        totalWidth+=70*vrb.ratio

        self.labelMax = qt.QLabel("Max")
        self.labelMax.setFont(font)
        self.labelMax.setFixedSize(35*vrb.ratio, 17*vrb.ratio)
        self.labelMax.setAlignment(Qt.AlignRight | Qt.AlignVCenter)
        totalWidth += 35*vrb.ratio

        self.lineEditMax = qt.QLineEdit()
        self.lineEditMax.setFixedSize(70*vrb.ratio, 17*vrb.ratio)
        self.lineEditMax.setAlignment(Qt.AlignRight | Qt.AlignVCenter)
        self.lineEditMax.setFont(font)
        totalWidth+=70*vrb.ratio

        # self.rangeSlider = RangeSlider()
        fontSize = 10
        self.rangeSlider = RangeSlider(fontSize=fontSize,customResize=[0,100], transparency=50)
        self.rangeSlider.setFixedHeight(12*vrb.ratio)
        self.rangeSlider.currentValueMin = 0
        self.rangeSlider.currentValueMax = 255
        self.rangeSlider.setValues(0,255)
        self.rangeSlider.groupLabelValue.setVisible(False)

        self.rangeSlider.groupSlider.labelBackground.image = None
        self.rangeSlider.groupSlider.labelBackground.filename = vrb.folderImages+"/Grey.png"
        self.rangeSlider.groupSlider.labelBackground.resizeEvent(None)

        groupBoxMinMaxContrast = qt.QGroupBox()
        layoutGroupBoxMinMax = qt.QGridLayout()
        groupBoxMinMaxContrast.setLayout(layoutGroupBoxMinMax)
        layoutGroupBoxMinMax.setContentsMargins(2*vrb.ratio,2*vrb.ratio,2*vrb.ratio,2*vrb.ratio)
        groupBoxMinMaxContrast.setStyleSheet('QGroupBox {border: 0px transparent; }')

        layoutGroupBoxMinMax.addWidget(self.labelMin,0,0)
        layoutGroupBoxMinMax.addWidget(self.lineEditMin,0,1)
        layoutGroupBoxMinMax.addWidget(self.labelMax,0,2)
        layoutGroupBoxMinMax.addWidget(self.lineEditMax,0,3)
        layoutGroupBoxMinMax.addWidget(self.rangeSlider,1,0,1,4)

        self.buttonValidate = wgt.PushButtonImage(vrb.folderImages + "/Validate.png")
        self.buttonValidate.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonValidate.setToolTip(txt.dictToolTips["Apply"])
        totalWidth += 30*vrb.ratio

        self.emptyLabel = qt.QLabel()
        self.emptyLabel.setFixedSize(10*vrb.ratio,30*vrb.ratio)
        totalWidth+=10*vrb.ratio

        scalingModesImages = [vrb.folderImages + "/Linear_Pressed.png", vrb.folderImages + "/Exponential_Pressed.png",
                  vrb.folderImages + "/Logarithm_Pressed.png", vrb.folderImages + "/Inverted_Pressed.png"]

        self.scaleModes = ["Linear", "Exponential", "Logarithm", "Inverted"]

        self.comboboxScaleMode = wgt.ComboBoxImages(scalingModesImages, margins=5*vrb.ratio)
        self.comboboxScaleMode.setFixedSize(40*vrb.ratio, 30*vrb.ratio)
        arrowSize = int(30*vrb.ratio)
        self.comboboxScaleMode.setStyleSheet(f"""
                    QComboBox::down-arrow {{
                        width: {arrowSize}px;
                        height: {arrowSize}px;
                    }}
                """)

        model = self.comboboxScaleMode.model()
        for i in range(self.comboboxScaleMode.count()):
            model.item(i).setToolTip(self.scaleModes[i])

        # self.buttonsWithModeScale = [self.buttonLinear,self.buttonExponential,self.buttonLogarithm, self.buttonInverted]

        self.emptyLabel2 = qt.QLabel()
        self.emptyLabel.setFixedSize(10*vrb.ratio,30*vrb.ratio)
        totalWidth+=10*vrb.ratio

        self.buttonBrigthness = wgt.PushButtonImage(vrb.folderImages + "/Contrast.png",margins=10)
        self.buttonBrigthness.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonBrigthness.setToolTip(txt.dictToolTips["ContrastAndBrightness"])
        totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonAuto, 0, 0)
        self.layout.addWidget(self.buttonLock, 0, 1)
        self.layout.addWidget(groupBoxMinMaxContrast, 0, 3)
        self.layout.addWidget(self.buttonValidate, 0, 5)
        self.layout.addWidget(self.emptyLabel, 0, 6)
        self.layout.addWidget(self.comboboxScaleMode, 0, 7)
        self.layout.addWidget(self.emptyLabel2, 0, 8)
        self.layout.addWidget(self.buttonBrigthness, 0, 9)


        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignVCenter)

        totalWidth += 95*vrb.ratio

        self.setFixedSize(totalWidth,40*vrb.ratio)

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        # for button in self.buttonsWithModeScale:
        #     button.clicked.connect(self.changeModeScale)

        self.comboboxScaleMode.currentIndexChanged.connect(self.changeModeScale)
        try:
            self.setModeScale("Linear")
        except:
            pass
        self.lineEditMin.returnPressed.connect(self.validateContrast)
        self.lineEditMax.returnPressed.connect(self.validateContrast)
        self.rangeSlider.signalValueChanged.connect(self.sliderChanged)
        self.buttonLock.clicked.connect(self.lockContrast)
        self.buttonValidate.clicked.connect(self.validateContrast)
        self.buttonAuto.clicked.connect(self.applyAutoContrast)
        # self.buttonLinear.clicked.connect(self.changePressedButton)
        # self.buttonExponential.clicked.connect(self.changePressedButton)
        # self.buttonLogarithm.clicked.connect(self.changePressedButton)
        # self.buttonInverted.clicked.connect(self.changePressedButton)

    def changePressedButton(self):

        sender = self.sender()
        for button in [self.buttonLinear,self.buttonExponential,self.buttonLogarithm, self.buttonInverted]:
            button.setChecked(button==sender)

    def lockContrast(self):

        self.buttonLock.changeActivation()
        if self.buttonLock.activate:
            self.changeCurrentContrast()

    def sliderChanged(self):

        try:
            if self.allowSliders:
                self.lineEditMin.setText(str(self.rangeSlider.currentValueMin))
                self.lineEditMax.setText(str(self.rangeSlider.currentValueMax))
                self.changeCurrentContrast()
        except:
            pass

    def validateContrast(self):

        widget = self.parentWidget.currentLabel
        valueMin = self.lineEditMin.text()
        if valueMin == "":
            valueMin = str(float(widget.valueMinRef))
        valueMax = self.lineEditMax.text()
        if valueMax == "":
            valueMax = str(float(widget.valueMinRef))

        valueMin = float(valueMin)
        valueMax = float(valueMax)

        self.rangeSlider.isFixedMin = True
        self.rangeSlider.currentValueMin = valueMin
        self.rangeSlider.setValueMin(valueMin)

        self.rangeSlider.isFixedMax = True
        self.rangeSlider.currentValueMax = valueMax
        self.rangeSlider.setValueMax(valueMax)

        self.rangeSlider.setValues(self.rangeSlider.currentValueMin, self.rangeSlider.currentValueMax)

    def changeCurrentContrast(self):

        try:
            if self.allowContrastChanging:
                widget = self.parentWidget.currentLabel
                valueMin = self.lineEditMin.text()
                if valueMin == "":
                    valueMin = str(float(widget.valueMinRef))
                widget.valueMin = float(valueMin)
                self.lineEditMin.setText(str(fct.numberCalibration(valueMin)))

                valueMax = self.lineEditMax.text()
                if valueMax == "":
                    valueMax = str(float(widget.valueMaxRef))
                widget.valueMax = float(valueMax)
                self.lineEditMax.setText(str(fct.numberCalibration(valueMax)))

                self.parentWidget.widgetImage.actualizeScene()
                # vrb.mainWindow.viewer3dSettingsWidget.updateVisualization()
                vrb.mainWindow.viewer3dSettingsWidget.sliderIntensitiesChanged([valueMin, valueMax])
        except:
            traceback.print_exc(file=sys.stderr)

    def loadContrast(self):
        try:
            self.allowSliders = False
            widget = self.parentWidget.currentLabel
            self.rangeSlider.type = widget.image.getBufferType()
            if self.buttonLock.activate:
                valueMin = self.lineEditMin.text()
                if valueMin == "":
                    valueMin = str(float(widget.valueMinRef))
                widget.valueMin = float(valueMin)

                valueMax = self.lineEditMax.text()
                if valueMax == "":
                    valueMax = str(float(widget.valueMinRef))
                widget.valueMax = float(valueMax)
            else:
                if widget.valueMin == None or widget.valueMin == "":
                    widget.valueMin = widget.valueMinRef
                if widget.valueMax == None or widget.valueMax == "":
                    widget.valueMax = widget.valueMaxRef

            self.rangeSlider.setMinMaxValues(widget.valueMinRef,widget.valueMaxRef)
            self.rangeSlider.currentValueMin = widget.valueMin
            self.rangeSlider.currentValueMax = widget.valueMax

            #A reprendre, sans appeller 2 fois la fonction, le slider ne s'actualise pas quand on passe d'une image [0;1] vers une image [0;255]
            self.rangeSlider.setValues(widget.valueMin, widget.valueMax)
            self.rangeSlider.setValues(widget.valueMin, widget.valueMax)

            self.lineEditMin.setText(str(fct.numberCalibration(widget.valueMin)))
            self.lineEditMax.setText(str(fct.numberCalibration(widget.valueMax)))

            self.changeCurrentContrast()

            self.allowSliders = True
        except:
            traceback.print_exc(file=sys.stderr)
            self.allowSliders = True

    def applyAutoContrast(self):

        try:
            widget = self.parentWidget.currentLabel
            try:
                cropImage = self.parentWidget.cropImage(addImage=False,currentPlanOnly=True)
                if cropImage is not None:
                    valueMin, valueMax = fct.getMinMaxValue(cropImage)
                    self.lineEditMin.setText(str(fct.numberCalibration(valueMin)))
                    self.lineEditMax.setText(str(fct.numberCalibration(valueMax)))
                    self.validateContrast()
                    # self.changeCurrentContrast()
                else:
                    self.lineEditMin.setText(str(fct.numberCalibration(widget.valueMinRef)))
                    self.lineEditMax.setText(str(fct.numberCalibration(widget.valueMaxRef)))
                    #self.changeCurrentContrast()
                    self.validateContrast()

            except:
                traceback.print_exc(file=sys.stderr)

                self.lineEditMin.setText(str(fct.numberCalibration(widget.valueMinRef)))
                self.lineEditMax.setText(str(fct.numberCalibration(widget.valueMaxRef)))
                #self.changeCurrentContrast()
                self.validateContrast()
        except:
            traceback.print_exc(file=sys.stderr)

    def changeModeScale(self):

        # sender = self.sender()

        # for button in self.buttonsWithModeScale:
        #     button.setActivation(button == sender)
        #     if button == sender:
        #         self.currentModeScale = button.mode

        self.currentModeScale = self.scaleModes[self.comboboxScaleMode.currentIndex()]

        self.parentWidget.widgetImage.actualizeScene()

    def setModeScale(self, mode):

        # for button in self.buttonsWithModeScale:
        #     button.setActivation(button.mode == mode)
        #     self.currentModeScale = mode

        self.currentModeScale = self.scaleModes[self.comboboxScaleMode.currentIndex()]

        if self.parentWidget is not None:
            self.parentWidget.widgetImage.actualizeScene()

class GroupBoxUser(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.buttonOpen = wgt.PushButtonImage(vrb.folderImages + "/Folder.png")
        self.buttonOpen.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonOpen.setToolTip(txt.dictToolTips["Open"])
        totalWidth += 30*vrb.ratio

        self.buttonOpen_Raw = wgt.PushButtonImage(vrb.folderImages + "/Folder_Raw.png")
        self.buttonOpen_Raw.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonOpen_Raw.setToolTip(txt.dictToolTips["OpenRaw"])
        totalWidth += 30*vrb.ratio

        self.buttonOpen_Disk_Image = wgt.PushButtonImage(vrb.folderImages + "/Folder_Disk_Image.png")
        self.buttonOpen_Disk_Image.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonOpen_Disk_Image.setToolTip(txt.dictToolTips["OpenDiskImage"])
        totalWidth += 30*vrb.ratio

        emptyLabel1 = qt.QLabel("")
        emptyLabel1.setFixedWidth(8*vrb.ratio)

        self.buttonOpen_Multi = wgt.PushButtonImage(vrb.folderImages + "/Folder_Multi.png")
        self.buttonOpen_Multi.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonOpen_Multi.setToolTip(txt.dictToolTips["OpenMulti"])
        totalWidth += 30*vrb.ratio

        self.buttonOpen_Multi_Disk = wgt.PushButtonImage(vrb.folderImages + "/Folder_Multi_Disk.png")
        self.buttonOpen_Multi_Disk.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonOpen_Multi_Disk.setToolTip(txt.dictToolTips["OpenMulti"])
        totalWidth += 30*vrb.ratio

        emptyLabel2 = qt.QLabel("")
        emptyLabel2.setFixedWidth(8*vrb.ratio)

        self.buttonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png")
        self.buttonSave.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonSave.setToolTip(txt.dictToolTips["Save"])
        totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonOpen, 0, 0)
        self.layout.addWidget(self.buttonOpen_Raw, 0, 1)
        self.layout.addWidget(self.buttonOpen_Disk_Image, 0, 2)
        self.layout.addWidget(emptyLabel1, 0, 3)
        self.layout.addWidget(self.buttonOpen_Multi, 0, 4)
        self.layout.addWidget(self.buttonOpen_Multi_Disk, 0, 5)
        self.layout.addWidget(emptyLabel2, 0, 6)
        self.layout.addWidget(self.buttonSave, 0, 7)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignVCenter)

        # totalWidth += 17*vrb.ratio
        totalWidth += 35*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)

class GroupBoxMeasure(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.buttonSelection = wgt.PushButtonDoubleImage(vrb.folderImages + "/Selection.png", vrb.folderImages + "/Selection_Pressed.png")
        self.buttonSelection.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonSelection.setToolTip(txt.dictToolTips["Selection"])
        self.buttonSelection.mode = "Selection"

        totalWidth += 30*vrb.ratio

        self.buttonMeasures = wgt.PushButtonDoubleImage(vrb.folderImages + "/Measures.png", vrb.folderImages + "/Measures_Pressed.png")
        self.buttonMeasures.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonMeasures.setToolTip(txt.dictToolTips["Measure"])
        self.buttonMeasures.mode = "MeasureLine"

        totalWidth += 30*vrb.ratio


        self.buttonMeasuresTable = wgt.PushButtonImage(vrb.folderImages + "/measure_table.png")
        self.buttonMeasuresTable.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
        self.buttonMeasuresTable.setToolTip(txt.dictToolTips["MeasureTable"])

        totalWidth += 30 * vrb.ratio

        self.buttonAngles = wgt.PushButtonDoubleImage(vrb.folderImages + "/Angle.png", vrb.folderImages + "/Angle_Pressed.png")
        self.buttonAngles.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonAngles.setToolTip(txt.dictToolTips["Angle"])
        self.buttonAngles.mode = "Angle"

        totalWidth += 30*vrb.ratio

        self.buttonRoi = wgt.PushButtonDoubleImage(vrb.folderImages + "/Roi.png", vrb.folderImages + "/Roi_Pressed.png")
        self.buttonRoi.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonRoi.setToolTip(txt.dictToolTips["Roi"])
        self.buttonRoi.mode = "Roi"

        totalWidth += 30*vrb.ratio

        self.buttonDelete = wgt.PushButtonImage(vrb.folderImages + "/Delete.png",margins=2)
        self.buttonDelete.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonDelete.setToolTip(txt.dictToolTips["DeleteMeasure"])
        totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonSelection, 0, 0)
        self.layout.addWidget(self.buttonMeasures, 0, 1)
        self.layout.addWidget(self.buttonMeasuresTable, 0, 2)
        self.layout.addWidget(self.buttonAngles, 0, 3)
        self.layout.addWidget(self.buttonRoi, 0, 4)
        self.layout.addWidget(self.buttonDelete, 0, 5)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignCenter)

        totalWidth += 26*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)

class GroupBoxMove(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.buttonZoomZone = wgt.PushButtonDoubleImage(vrb.folderImages + "/Zoom_Zone.png", vrb.folderImages + "/Zoom_Zone_Pressed.png")
        self.buttonZoomZone.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonZoomZone.setToolTip(txt.dictToolTips["ZoomZone"])
        self.buttonZoomZone.mode = "ZoomZone"

        totalWidth += 30*vrb.ratio

        self.buttonZoomPlus = wgt.PushButtonDoubleImage(vrb.folderImages + "/Zoom_Plus.png", vrb.folderImages + "/Zoom_Plus_Pressed.png")
        self.buttonZoomPlus.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonZoomPlus.mode = "ZoomPlus"
        self.buttonZoomPlus.setToolTip(txt.dictToolTips["ZoomPlus"])
        totalWidth += 30*vrb.ratio

        self.buttonZoomMinus = wgt.PushButtonDoubleImage(vrb.folderImages + "/Zoom_Minus.png", vrb.folderImages + "/Zoom_Minus_Pressed.png")
        self.buttonZoomMinus.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonZoomMinus.mode = "ZoomMinus"
        self.buttonZoomMinus.setToolTip(txt.dictToolTips["ZoomMinus"])
        totalWidth += 30*vrb.ratio

        self.buttonHand = wgt.PushButtonDoubleImage(vrb.folderImages + "/Hand.png", vrb.folderImages + "/Hand_Pressed.png")
        self.buttonHand.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonHand.mode = "Hand"
        self.buttonHand.setToolTip(txt.dictToolTips["Hand"])
        totalWidth += 30*vrb.ratio

        self.buttonHome = wgt.PushButtonImage(vrb.folderImages + "/Home.png",margins=2)
        self.buttonHome.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonHome.setToolTip(txt.dictToolTips["Home"])
        totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonZoomZone, 0, 0)
        self.layout.addWidget(self.buttonZoomPlus, 0, 1)
        self.layout.addWidget(self.buttonZoomMinus, 0, 2)
        self.layout.addWidget(self.buttonHand, 0, 3)
        self.layout.addWidget(self.buttonHome, 0, 4)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignCenter)

        totalWidth +=28*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)

class GroupBoxZone(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.buttonZone = wgt.PushButtonDoubleImage(vrb.folderImages + "/Zone.png", vrb.folderImages + "/Zone_Pressed.png")
        self.buttonZone.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonZone.setToolTip(txt.dictToolTips["ZoneSelection"])
        self.buttonZone.mode = "Zone"
        totalWidth += 30*vrb.ratio

        self.buttonScissors = wgt.PushButtonImage(vrb.folderImages + "/Scissors.png")
        self.buttonScissors.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonScissors.setToolTip(txt.dictToolTips["Crop"])
        totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonZone, 0, 0)
        self.layout.addWidget(self.buttonScissors, 0, 1)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignCenter)

        totalWidth += 18*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)

class GroupBoxCamera(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.buttonLive = wgt.PushButtonImage(vrb.folderImages + "/Live.png")
        self.buttonLive.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
        self.buttonLive.setToolTip(txt.dictToolTips["Live"])
        totalWidth += 30*vrb.ratio

        self.buttonCamera = wgt.PushButtonImage(vrb.folderImages + "/Camera.png")
        self.buttonCamera.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
        self.buttonCamera.setToolTip(txt.dictToolTips["Camera"])
        totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonLive, 0, 0)
        self.layout.addWidget(self.buttonCamera, 0, 1)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignCenter)

        totalWidth += 15*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)

class GroupBoxPostProcess(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.buttonMergeLabel = wgt.PushButtonDoubleImage(vrb.folderImages + "/MergeLabel.png", vrb.folderImages + "/MergeLabel_Pressed.png")
        self.buttonMergeLabel.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonMergeLabel.mode = "MergeLabel"
        self.buttonMergeLabel.setToolTip(txt.dictToolTips["MergeLabels"])
        totalWidth += 30*vrb.ratio

        self.buttonSplitLabel = wgt.PushButtonDoubleImage(vrb.folderImages + "/SplitLabel.png", vrb.folderImages + "/SplitLabel_Pressed.png")
        self.buttonSplitLabel.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonSplitLabel.mode = "SplitLabel"
        self.buttonSplitLabel.setToolTip(txt.dictToolTips["SplitLabels"])

        totalWidth += 30*vrb.ratio

        self.buttonSplitLabel3D = wgt.PushButtonDoubleImage(vrb.folderImages + "/SplitLabel3D.png", vrb.folderImages + "/SplitLabel3D_Pressed.png")
        self.buttonSplitLabel3D.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonSplitLabel3D.mode = "SplitLabel3D"
        self.buttonSplitLabel3D.setToolTip(txt.dictToolTips["SplitLabels"])
        self.buttonSplitLabel3D.setVisible(False)

        self.buttonAddLabel = wgt.PushButtonDoubleImage(vrb.folderImages + "/AddLabel.png", vrb.folderImages + "/AddLabel_Pressed.png")
        self.buttonAddLabel.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonAddLabel.mode = "AddLabel"
        self.buttonAddLabel.setToolTip(txt.dictToolTips["AddLabels"])
        totalWidth += 30*vrb.ratio

        self.buttonDeleteLabel = wgt.PushButtonDoubleImage(vrb.folderImages + "/DeleteLabel.png", vrb.folderImages + "/DeleteLabel_Pressed.png")
        self.buttonDeleteLabel.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonDeleteLabel.mode = "DeleteLabel"
        self.buttonDeleteLabel.setToolTip(txt.dictToolTips["DeleteLabels"])
        totalWidth += 30*vrb.ratio

        self.buttonKeepLabel = wgt.PushButtonDoubleImage(vrb.folderImages + "/KeepLabel.png", vrb.folderImages + "/KeepLabel_Pressed.png")
        self.buttonKeepLabel.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonKeepLabel.mode = "KeepLabel"
        self.buttonKeepLabel.setToolTip(txt.dictToolTips["KeepLabels"])
        totalWidth += 30*vrb.ratio

        self.buttonRefresh = wgt.PushButtonImage(vrb.folderImages + "/Refresh.png",margins=2)
        self.buttonRefresh.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonRefresh.setToolTip(txt.dictToolTips["ApplyLabels"])
        totalWidth += 30*vrb.ratio

        self.buttonBack = wgt.PushButtonImage(vrb.folderImages + "/Back.png",margins=2)
        self.buttonBack.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonBack.setToolTip(txt.dictToolTips["Undo"])
        self.buttonBack.setEnabled(False)
        totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonBack, 0, 0)
        self.layout.addWidget(self.buttonMergeLabel, 0, 1)
        self.layout.addWidget(self.buttonSplitLabel, 0, 2)
        self.layout.addWidget(self.buttonSplitLabel3D, 0, 3)
        self.layout.addWidget(self.buttonAddLabel, 0, 4)
        self.layout.addWidget(self.buttonDeleteLabel, 0, 5)
        self.layout.addWidget(self.buttonKeepLabel, 0, 6)
        self.layout.addWidget(self.buttonRefresh, 0, 7)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignCenter)

        totalWidth += 32*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)

class GroupViewer(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.button2dMode = wgt.PushButtonDoubleImage(vrb.folderImages + "/2D_Mode.png", vrb.folderImages + "/2D_Mode_Pressed.png")
        self.button2dMode.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
        self.button2dMode.modeViewer = "2D"
        totalWidth += 30 * vrb.ratio

        self.button3dMode = wgt.PushButtonDoubleImage(vrb.folderImages + "/3D_Mode.png", vrb.folderImages + "/3D_Mode_Pressed.png")
        self.button3dMode.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
        self.button3dMode.modeViewer = "3D"
        totalWidth += 30 * vrb.ratio

        self.button4ViewsMode = wgt.PushButtonDoubleImage(vrb.folderImages + "/4Views_Mode.png", vrb.folderImages + "/4Views_Mode_Pressed.png")
        self.button4ViewsMode.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
        self.button4ViewsMode.modeViewer = "4Views"
        totalWidth += 30 * vrb.ratio

        self.buttonMovieMaker = wgt.PushButtonDoubleImage(vrb.folderImages + "/Scenario.png",vrb.folderImages + "/Scenario_Pressed.png")
        self.buttonMovieMaker.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonMovieMaker.setToolTip(txt.dictToolTips["Movie_Maker"])
        self.buttonMovieMaker.setEnabled(False)
        if vrb.isRunTime == False:
            totalWidth += 30*vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.button2dMode, 0, 0)
        self.layout.addWidget(self.button3dMode, 0, 1)
        self.layout.addWidget(self.button4ViewsMode, 0, 2)
        self.layout.addWidget(self.buttonMovieMaker, 0, 3)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignCenter)

        totalWidth += 25*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)


class GroupSpecialButtons(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        totalWidth = 0

        self.buttonScreen = wgt.PushButtonImage(vrb.folderImages + "/Screen.png")
        self.buttonScreen.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonScreen.setToolTip(txt.dictToolTips["Screen"])

        totalWidth += 30*vrb.ratio


        self.buttonDisplayStats = wgt.PushButtonDoubleImage(vrb.folderImages + "/Display_Stats.png", vrb.folderImages + "/Display_Stats_Pressed.png")
        self.buttonDisplayStats.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonDisplayStats.mode = "Display_Stats"
        self.buttonDisplayStats.setToolTip(txt.dictToolTips["Display_Stats"])

        totalWidth += 30*vrb.ratio

        self.buttonEditMacro = wgt.PushButtonImage(vrb.folderImages + "/Edit.png")
        self.buttonEditMacro.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonEditMacro.setToolTip(txt.dictToolTips["New_Macro"])
        if vrb.isRunTime == False:
            totalWidth += 30*vrb.ratio

        self.buttonMachineLearning = wgt.PushButtonImage(vrb.folderImages + "/Machinelearning.png")
        self.buttonMachineLearning.setFixedSize(30*vrb.ratio, 30*vrb.ratio)
        self.buttonMachineLearning.setToolTip(txt.dictToolTips["Machine_Learning"])
        if vrb.isRunTime == False:
            totalWidth += 30*vrb.ratio

        # self.button3DViewer = wgt.PushButtonImage(vrb.folderImages + "/Viewer3D.png")
        # self.button3DViewer.setFixedSize(30 * vrb.ratio, 30 * vrb.ratio)
        # self.button3DViewer.setToolTip(txt.dictToolTips["Viewer3D"])
        # if vrb.isORS == False and vrb.isDigisens == False and PyIPSDK.are3dProcessesSupported():
        #     totalWidth += 30 * vrb.ratio

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonScreen, 0, 0)
        self.layout.addWidget(self.buttonDisplayStats, 0, 1)
        # num = 2
        # if vrb.isORS == False and vrb.isDigisens == False and PyIPSDK.are3dProcessesSupported():
        #     self.layout.addWidget(self.button3DViewer, 0, num)
        #     num += 1
        if vrb.isRunTime == False:
            self.layout.addWidget(self.buttonEditMacro, 0, 3)
            self.layout.addWidget(self.buttonMachineLearning, 0, 4)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(5*vrb.ratio, 0, 5*vrb.ratio, 0)
        self.layout.setHorizontalSpacing(3*vrb.ratio)
        self.layout.setAlignment(Qt.AlignCenter)

        totalWidth += 25*vrb.ratio

        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

        self.setFixedSize(totalWidth, 40*vrb.ratio)


class GroupMenu(qt.QGroupBox):

    def __init__(self, mainWindow=None):
        qt.QGroupBox.__init__(self)

        self.mainWindow = mainWindow

        self.currentMode = "Zone"
        self.currentModeViewer = "2D"

        self.bar1 = qt.QGroupBox()
        self.layoutBar1 = qt.QGridLayout()
        self.bar1.setLayout(self.layoutBar1)
        self.layoutBar1.setSizeConstraint(1)
        self.layoutBar1.setContentsMargins(10*vrb.ratio, 0, 10*vrb.ratio, 0)
        self.layoutBar1.setHorizontalSpacing(20*vrb.ratio)
        self.layoutBar1.setAlignment(Qt.AlignLeft)
        self.bar1.setStyleSheet("QGroupBox {border: 0px transparent; }")

        self.bar2 = qt.QGroupBox()
        self.layoutBar2 = qt.QGridLayout()
        self.bar2.setLayout(self.layoutBar2)
        self.layoutBar2.setSizeConstraint(1)
        self.layoutBar2.setContentsMargins(10*vrb.ratio, 0, 10*vrb.ratio, 0)
        self.layoutBar2.setHorizontalSpacing(20*vrb.ratio)
        self.layoutBar2.setAlignment(Qt.AlignLeft)
        self.bar2.setStyleSheet("QGroupBox {border: 0px transparent; }")

        self.groupUser = GroupBoxUser()
        self.groupContrast = GroupBoxContrast(parentWidget=mainWindow)
        self.groupBoxZone = GroupBoxZone()
        self.groupMeasure = GroupBoxMeasure()
        self.groupMove = GroupBoxMove()
        self.groupCalibration = GroupBoxCalibration(mainWindow=mainWindow,parent=self)
        self.groupColorCalibration = GroupColorCalibration()
        self.groupPostProcess = GroupBoxPostProcess()
        self.groupPostProcess.setVisible(False)
        self.groupSpecialButtons = GroupSpecialButtons()
        self.groupViewer = GroupViewer()
        self.groupBoxCamera = GroupBoxCamera()

        self.buttonScreen = self.groupSpecialButtons.buttonScreen
        self.buttonDisplayStats = self.groupSpecialButtons.buttonDisplayStats
        self.buttonEditMacro = self.groupSpecialButtons.buttonEditMacro
        self.buttonMachineLearning = self.groupSpecialButtons.buttonMachineLearning
        self.buttonMovieMaker = self.groupViewer.buttonMovieMaker
        # self.button3DViewer = self.groupSpecialButtons.button3DViewer

        self.buttonsWithMode = [self.groupBoxZone.buttonZone,self.groupMeasure.buttonSelection,self.groupMeasure.buttonMeasures,self.groupMeasure.buttonAngles,self.groupMeasure.buttonRoi,
                                self.groupMove.buttonZoomZone, self.groupMove.buttonZoomPlus, self.groupMove.buttonZoomMinus,self.groupMove.buttonHand,
                                self.groupPostProcess.buttonMergeLabel,self.groupPostProcess.buttonSplitLabel,self.groupPostProcess.buttonSplitLabel3D,self.groupPostProcess.buttonAddLabel,
                                self.groupPostProcess.buttonDeleteLabel,self.groupPostProcess.buttonKeepLabel,self.buttonDisplayStats]

        self.buttonsWithModeViewer = [self.groupViewer.button2dMode,self.groupViewer.button3dMode,self.groupViewer.button4ViewsMode]

        self.layoutBar1.addWidget(self.groupUser,0,0,Qt.AlignVCenter)
        self.layoutBar1.addWidget(self.groupContrast,0,1,Qt.AlignVCenter)
        self.layoutBar1.addWidget(self.groupSpecialButtons,0,2,Qt.AlignVCenter)
        self.layoutBar1.addWidget(self.groupViewer,0,3,Qt.AlignVCenter)

        num = 4

        # if vrb.hasIDS or vrb.hasCamera:
        #     self.layoutBar1.addWidget(self.groupBoxCamera, 0, num)
        #     num+=1

        if vrb.nbCameras > 0:
            self.layoutBar1.addWidget(self.groupBoxCamera, 0, num)
            num+=1

        vrb.numMacro = num

        self.layoutBar2.addWidget(self.groupBoxZone,0,0,Qt.AlignVCenter)
        self.layoutBar2.addWidget(self.groupMeasure,0,1,Qt.AlignVCenter)
        self.layoutBar2.addWidget(self.groupMove,0,2,Qt.AlignVCenter)
        self.layoutBar2.addWidget(self.groupCalibration,0,3,Qt.AlignVCenter)
        self.layoutBar2.addWidget(self.groupColorCalibration,0,4,Qt.AlignVCenter)
        self.layoutBar2.addWidget(self.groupPostProcess,0,5,Qt.AlignVCenter)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.bar1, 0, 0)
        self.layout.addWidget(self.bar2, 1, 0)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(3*vrb.ratio, 3*vrb.ratio, 3*vrb.ratio, 3*vrb.ratio)
        self.layout.setVerticalSpacing(10*vrb.ratio)
        self.layout.setAlignment(Qt.AlignVCenter)

        self.bar1.setFixedSize(1600*vrb.ratio,50*vrb.ratio)
        self.bar2.setFixedSize(1600*vrb.ratio,50*vrb.ratio)
        self.setFixedHeight(110*vrb.ratio)

        for button in self.buttonsWithMode:
            button.clicked.connect(self.changeMode)
        self.setMode("Zone")

        for button in self.buttonsWithModeViewer:
            button.clicked.connect(self.changeModeViewer)
        self.setModeViewer("2D")

        #self.setStyleSheet("GroupMenu {background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #565656, stop: 0.1 #525252, stop: 0.5 #4e4e4e, stop: 0.9 #4a4a4a, stop: 1 #464646);}")
        self.setStyleSheet("GroupMenu {background-color: #404040;}")

    # def resizeEvent(self,event):
    #
    #     self.bar1.setFixedSize(self.width(),50*vrb.ratio)
    #     self.bar2.setFixedSize(self.width(),50*vrb.ratio)

    def changeMode(self):

        try:
            self.mainWindow.imageViewer.setToolTip("")
        except:
            pass

        sender = self.sender()
        for button in self.buttonsWithMode:
            button.setActivation(button==sender)
            if button == sender:
                self.currentMode = button.mode
                vrb.graphicUserMode = False
                try:
                    vrb.currentUserButtonMode.setActivation(False)
                except:
                    pass

    def setMode(self,mode):

        for button in self.buttonsWithMode:
            button.setActivation(button.mode==mode)
            self.currentMode = mode

    def changeModeViewer(self):

        sender = self.sender()
        for button in self.buttonsWithModeViewer:
            button.setActivation(button==sender)
            if button == sender:
                self.currentModeViewer = button.modeViewer

        try:
            vrb.mainWindow.tabWidgetLeft.currentWidget().actualizePosition()
            vrb.mainWindow.widgetImage.changeModeViewer(self.currentModeViewer)
            vrb.mainWindow.widgetImage.actualizeSceneChangeRoi() #used to fix bug where the informations of image at the bottom of viewer appears in the viewer
        except:
            pass

    def setModeViewer(self,modeViewer):

        for button in self.buttonsWithModeViewer:
            button.setActivation(button.modeViewer==modeViewer)
            self.currentModeViewer = modeViewer

        vrb.mainWindow.widgetImage.changeModeViewer(self.currentModeViewer)

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook

    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook

    #foo = GroupBoxContrast()
    #foo = GroupBoxUser()
    foo = GroupMenu()

    style = fct.getStyleSheet()
    # app.setStyleSheet(style)
    foo.setStyleSheet(style)

    foo.show()

    app.exec_()


