import os
import sys, traceback
import time

import matplotlib
matplotlib.use('QT5Agg')
import matplotlib.pylab as plt
from matplotlib.backends.qt_compat import QtCore, QtWidgets#, is_pyqt5
from matplotlib.backends.backend_qt5agg import FigureCanvas,     NavigationToolbar2QT as NavigationToolbar
from matplotlib.figure import Figure

import numpy as np
from pylab import *

from PyQt5.QtCore import Qt,QCoreApplication
from PyQt5 import QtGui,QtCore
import PyQt5.QtWidgets as qt
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import PyIPSDK
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLUtility as util

import DrawFunctions as DWfct
import DatabaseFunction as Dfct
import UsefullVariables as vrb
import UsefullWidgets as wgt
import UsefullFunctions as fct
import UsefullDisplay as display

import xml.etree.ElementTree as xmlet

from DictionaryCustomObject import dictCustomObject
from UsefullWidgets import Measure

from PIL import Image, ImageDraw

from ShapeAnalysisDisplayer import measureIterator

class GraphicElements(QtCore.QObject):
    SignalComputePreview = pyqtSignal()

    def __init__(self, mainWindow=None):
        super(GraphicElements, self).__init__()

        self.dictGraphicFunctions = {}
        self.dictGraphicFunctions["Selection"] = self.selection
        self.dictGraphicFunctions["MeasureLine"] = self.addMearsureLine
        self.dictGraphicFunctions["Angle"] = self.addAngle
        self.dictGraphicFunctions["Zone"] = self.zoneSelection
        self.dictGraphicFunctions["ZoomZone"] = self.zoomZone
        self.dictGraphicFunctions["AddLabel"] = self.addLabel
        self.dictGraphicFunctions["MergeLabel"] = self.mergeLabel
        self.dictGraphicFunctions["SplitLabel"] = self.splitLabel
        self.dictGraphicFunctions["SplitLabel3D"] = self.splitLabel3D
        self.dictGraphicFunctions["KeepLabel"] = self.keepLabel
        self.dictGraphicFunctions["DeleteLabel"] = self.deleteLabel
        self.dictGraphicFunctions["Hand"] = self.moveImage
        self.dictGraphicFunctions["ZoomPlus"] = self.zoomPlus
        self.dictGraphicFunctions["ZoomMinus"] = self.zoomMinus
        self.dictGraphicFunctions["Roi"] = self.addRoi
        self.dictGraphicFunctions["Display_Stats"] = self.displayStats
        self.dictGraphicFunctions["Labeling"] = self.addLabeling

        self.mainWindow = mainWindow
        self.imageViewer = mainWindow.imageViewer

        self.previewMode = False
        self.minSizePreview = 20
        self.maxSizePreview = 1500
        self.defaultRatioPreview = 0.2
        self.previewColor = vrb.dictColor[2]

        self.distMinSelection = 10

        self.currentPointSelected = None
        self.currentPolygonSelected = None

        self.currentLineMeasure = None
        self.currentAngle = None
        self.currentAddLabel = None
        self.currentSplitLabel = None
        self.drawing = False
        self.hasMoving = False

        self.calibrationLine = None
        self.previewRectangle = xmlet.Element('Preview')

        self.selectionRectangle3D = None

        self.zoomZoneRectangle = None
        self.refPosX = None
        self.refPosY = None

        self.allLineProfiles = []

        # for imageViewerStandAlone in self.mainWindow.widgetImage.listImageViewerStandAlone:
        #     imageViewerStandAlone.imageViewer.signalEmitMouse.connect(self.createSceneElement)

        self.mainWindow.widgetImage.imageViewerStandAloneNormal.imageViewer.signalEmitMouse.connect(self.createSceneElement)
        self.mainWindow.widgetImage.imageViewerStandAloneX.imageViewer.signalEmitMouse.connect(self.createSceneElement)
        self.mainWindow.widgetImage.imageViewerStandAloneY.imageViewer.signalEmitMouse.connect(self.createSceneElement)
        self.mainWindow.widgetImage.imageViewerStandAloneZ.imageViewer.signalEmitMouse.connect(self.createSceneElement)

        self.imageViewer.signalEmitKey.connect(self.suppressElement)

    def getRoiImage(self,changeRoiImage = False,transformImage = False):

        if self.mainWindow.groupMenu.currentModeViewer == "2D":
            self.mainWindow.widgetImage.imageViewerStandAloneNormal.imageViewer.getRoiImage(changeRoiImage=changeRoiImage,transformImage = transformImage)
        if self.mainWindow.groupMenu.currentModeViewer == "4Views":
            for imageViewerStandAlone in [self.mainWindow.widgetImage.imageViewerStandAloneX,self.mainWindow.widgetImage.imageViewerStandAloneY,self.mainWindow.widgetImage.imageViewerStandAloneZ]:
                imageViewerStandAlone.imageViewer.getRoiImage(changeRoiImage=changeRoiImage,transformImage = transformImage)

    def setPreviewMode(self):

        try:
            if not self.previewMode:
                self.previewMode = True
                if self.imageViewer.widgetImage.image.getSizeZ() > 1:
                    self.imageViewer.widgetImage.labelPreviewAxis.setVisible(True)
                    self.imageViewer.widgetImage.lineEditPreviewAxis.setVisible(True)
                    # self.imageViewer.widgetImage.emptyLabel.setEnabled(False)
                sizeX, sizeY = self.imageViewer.image[0].getSizeX(), self.imageViewer.image[0].getSizeY()
                centerX, centerY = sizeX/2, sizeY/2
                sizeX = max(min(sizeX * self.defaultRatioPreview, self.maxSizePreview), self.minSizePreview)
                sizeY = max(min(sizeY * self.defaultRatioPreview, self.maxSizePreview), self.minSizePreview)
                DWfct.addPointToPolygon(self.previewRectangle, QtCore.QPointF(centerX-sizeX/2, centerY-sizeY/2))
                DWfct.addPointToPolygon(self.previewRectangle, QtCore.QPointF(centerX+sizeX/2, centerY-sizeY/2))
                DWfct.addPointToPolygon(self.previewRectangle, QtCore.QPointF(centerX+sizeX/2, centerY+sizeY/2))
                DWfct.addPointToPolygon(self.previewRectangle, QtCore.QPointF(centerX-sizeX/2, centerY+sizeY/2))
                self.mainWindow.groupMenu.setMode("Selection")
                widgetImage = self.mainWindow.widgetImage
                widgetImage.previewMinX, widgetImage.previewMinY, widgetImage.previewSizeX, widgetImage.previewSizeY = DWfct.boundingBoxPolygon(self.previewRectangle)
                self.SignalComputePreview.emit()
            else:
                self.stopPreviewMode()
        except:
            pass

    def stopPreviewMode(self):

        isChanged = self.previewMode == True

        self.imageViewer.widgetImage.labelPreviewAxis.setVisible(False)
        self.imageViewer.widgetImage.lineEditPreviewAxis.setVisible(False)
        # self.imageViewer.widgetImage.emptyLabel.setEnabled(True)
        allPointsElement = Dfct.SubElement(self.previewRectangle, "AllPoints")
        Dfct.clearElement(allPointsElement)
        self.previewMode = False
        if isChanged:
            self.getRoiImage(changeRoiImage=False)
        if self.mainWindow.categorySpoilersContainer is not None and self.mainWindow.categorySpoilersContainer.currentFunction is not None:
            try:
                #self.mainWindow.categorySpoilersContainer.currentFunction.pushButtonPreview.setChecked(False)
                self.mainWindow.categorySpoilersContainer.currentFunction.pushButtonPreview.setActivation(False)
                self.mainWindow.categorySpoilersContainer.currentFunction.pushButtonRefresh.setVisible(False)
            except:
                pass

    def setCalibrationLine(self):

        self.calibrationLine = xmlet.Element('Calibration')
        sizeX, sizeY = self.imageViewer.image[0].getSizeX(), self.imageViewer.image[0].getSizeY()
        DWfct.addPointToPolygon(self.calibrationLine, QtCore.QPointF(sizeX*80/100,sizeY*90/100))
        DWfct.addPointToPolygon(self.calibrationLine, QtCore.QPointF(sizeX*90/100,sizeY*90/100))
        self.fillCalibrationLineEdit()
        self.mainWindow.groupMenu.setMode("Selection")
        self.getRoiImage(changeRoiImage=False)

    def stopCalibrationLine(self):

        self.calibrationLine = None
        self.getRoiImage(changeRoiImage=False)

    def createSceneElement(self, ddict, imageViewer):

        self.imageViewer = imageViewer

        if vrb.graphicUserMode == False:
            if self.imageViewer.image is not None:
                if ddict["Button"] == 2:
                    self.rightClickFunction(ddict)
                else:
                    if ddict["Button"] == 1 and ddict["Event"] == "DoubleClick" and vrb.mainWindow.widgetImage.modeViewer == "4Views":
                        self.changeViewMode(imageViewer)
                    else:
                        mode = self.mainWindow.groupMenu.currentMode
                        if mode in self.dictGraphicFunctions:
                            if mode != "Zone":
                                self.selectionRectangle3D = None
                            try:
                                self.dictGraphicFunctions[mode](ddict)
                            except:
                                pass
                                # traceback.print_exc(file=sys.stderr)
        else:
            try:
                vrb.graphicUserFunction(ddict)
            except:
                traceback.print_exc(file=sys.stderr)

    def changeViewMode(self,imageViewer):

        if imageViewer == vrb.mainWindow.widgetImage.imageViewerStandAloneX.imageViewer:
            vrb.mainWindow.groupMenu.setModeViewer("2D")
            vrb.mainWindow.widgetImage.imageViewerStandAloneNormal.sliderAxis.radioButtonX.setChecked(True)
        elif imageViewer == vrb.mainWindow.widgetImage.imageViewerStandAloneY.imageViewer:
            vrb.mainWindow.groupMenu.setModeViewer("2D")
            vrb.mainWindow.widgetImage.imageViewerStandAloneNormal.sliderAxis.radioButtonY.setChecked(True)
        elif imageViewer == vrb.mainWindow.widgetImage.imageViewerStandAloneZ.imageViewer:
            vrb.mainWindow.groupMenu.setModeViewer("2D")
            vrb.mainWindow.widgetImage.imageViewerStandAloneNormal.sliderAxis.radioButtonZ.setChecked(True)


    # def sanitize_tangents(self, polygon):
    #     '''Checks tangents of ROI 3D to avoid bad polygons'''
    #     polygon = np.array(polygon)
    #     tangents = np.diff(polygon, axis=0)
    #     mags = np.linalg.norm(tangents, axis=1)
    #
    #     # deletes null tangents
    #     if np.any(mags == 0):
    #         # print("Zero tangent detected, polygon ignored: " , polygon)
    #         return None
    #     return polygon

    def applyGraphicElement(self, imageViewer):

        if self.mainWindow.currentLabel is not None and self.mainWindow.currentLabel.objectType == "Image" and imageViewer.image is not None:
            if self.mainWindow.currentLabel.image.hasGeometricCalibration():
                calibration = self.mainWindow.currentLabel.image.getGeometricCalibration()
            else:
                calibration = None
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentLabel.xmlElement, "GraphicXmlElement")

            if Dfct.childText(self.mainWindow.currentLabel.xmlElement,"Z") !="1":
                lineXY = xmlet.Element('LineXY')
                DWfct.addPointToPolygon(lineXY, QtCore.QPointF(self.mainWindow.widgetImage.imageViewerStandAloneY.sliderAxis.sliderY.slider.value(),0))
                DWfct.addPointToPolygon(lineXY, QtCore.QPointF(self.mainWindow.widgetImage.imageViewerStandAloneY.sliderAxis.sliderY.slider.value(),float(Dfct.childText(self.mainWindow.currentLabel.xmlElement,"Z"))))
                DWfct.addPolygonToScene(self.mainWindow.widgetImage.imageViewerStandAloneX.imageViewer, lineXY, color=[0,255,255], showPoints=False, lineSize=2, pointMode="bar", lineMeasure=False, mainWindow=self.mainWindow)
                lineXZ = xmlet.Element('LineXZ')
                DWfct.addPointToPolygon(lineXZ, QtCore.QPointF(0, self.mainWindow.widgetImage.imageViewerStandAloneZ.sliderAxis.sliderZ.slider.value()))
                DWfct.addPointToPolygon(lineXZ, QtCore.QPointF(float(Dfct.childText(self.mainWindow.currentLabel.xmlElement,"Y")), self.mainWindow.widgetImage.imageViewerStandAloneZ.sliderAxis.sliderZ.slider.value()))
                DWfct.addPolygonToScene(self.mainWindow.widgetImage.imageViewerStandAloneX.imageViewer, lineXZ, color=[255,0,255], showPoints=False, lineSize=2, pointMode="bar", lineMeasure=False, mainWindow=self.mainWindow)

                lineYX = xmlet.Element('LineYX')
                DWfct.addPointToPolygon(lineYX, QtCore.QPointF(self.mainWindow.widgetImage.imageViewerStandAloneX.sliderAxis.sliderX.slider.value(),0))
                DWfct.addPointToPolygon(lineYX, QtCore.QPointF(self.mainWindow.widgetImage.imageViewerStandAloneX.sliderAxis.sliderX.slider.value(),float(Dfct.childText(self.mainWindow.currentLabel.xmlElement,"Z"))))
                DWfct.addPolygonToScene(self.mainWindow.widgetImage.imageViewerStandAloneY.imageViewer, lineYX, color=[255,255,0], showPoints=False, lineSize=2, pointMode="bar", lineMeasure=False, mainWindow=self.mainWindow)
                lineYZ = xmlet.Element('LineYZ')
                DWfct.addPointToPolygon(lineYZ, QtCore.QPointF(0, self.mainWindow.widgetImage.imageViewerStandAloneZ.sliderAxis.sliderZ.slider.value()))
                DWfct.addPointToPolygon(lineYZ, QtCore.QPointF(float(Dfct.childText(self.mainWindow.currentLabel.xmlElement,"X")), self.mainWindow.widgetImage.imageViewerStandAloneZ.sliderAxis.sliderZ.slider.value()))
                DWfct.addPolygonToScene(self.mainWindow.widgetImage.imageViewerStandAloneY.imageViewer, lineYZ, color=[255,0,255], showPoints=False, lineSize=2, pointMode="bar", lineMeasure=False, mainWindow=self.mainWindow)

                lineZX = xmlet.Element('LineZX')
                DWfct.addPointToPolygon(lineZX, QtCore.QPointF(self.mainWindow.widgetImage.imageViewerStandAloneX.sliderAxis.sliderX.slider.value(),0))
                DWfct.addPointToPolygon(lineZX, QtCore.QPointF(self.mainWindow.widgetImage.imageViewerStandAloneX.sliderAxis.sliderX.slider.value(),float(Dfct.childText(self.mainWindow.currentLabel.xmlElement,"Y"))))
                DWfct.addPolygonToScene(self.mainWindow.widgetImage.imageViewerStandAloneZ.imageViewer, lineZX, color=[255,255,0], showPoints=False, lineSize=2, pointMode="bar", lineMeasure=False, mainWindow=self.mainWindow)
                lineZY = xmlet.Element('LineZY')
                DWfct.addPointToPolygon(lineZY, QtCore.QPointF(0, self.mainWindow.widgetImage.imageViewerStandAloneY.sliderAxis.sliderY.slider.value()))
                DWfct.addPointToPolygon(lineZY, QtCore.QPointF(float(Dfct.childText(self.mainWindow.currentLabel.xmlElement,"X")), self.mainWindow.widgetImage.imageViewerStandAloneY.sliderAxis.sliderY.slider.value()))
                DWfct.addPolygonToScene(self.mainWindow.widgetImage.imageViewerStandAloneZ.imageViewer, lineZY, color=[0,255,255], showPoints=False, lineSize=2, pointMode="bar", lineMeasure=False, mainWindow=self.mainWindow)

            try:
                crossPolygon = DWfct.createCrossPolygon()
                if crossPolygon is not None:
                    DWfct.addPolygonToScene(imageViewer, crossPolygon[0], color=[200,0,0], showPoints=False, lineSize=2)
                    DWfct.addPolygonToScene(imageViewer, crossPolygon[1], color=[200,0,0], showPoints=False, lineSize=2)
            except:
                pass

            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")
            DWfct.addPolygonToScene(imageViewer, roiElement, color=[float(vrb.polygonColor[0]), float(vrb.polygonColor[1]), float(vrb.polygonColor[2])], showPoints=True, lineSize=2, pointMode="circle", pointSize=6)

            allLabelingElement = Dfct.SubElement(graphicXmlElement, "AllLabeling")
            for child in allLabelingElement:
                DWfct.addLabelingToScene(imageViewer, child)

            allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")
            for child in allLineMeasuresElement:
                color = [float(vrb.lineMeasureColor[0]), float(vrb.lineMeasureColor[1]), float(vrb.lineMeasureColor[2])]
                colorLineMeasureElement = Dfct.SubElement(child, "ColorLineMeasure")
                if colorLineMeasureElement.text is not None:
                    color = colorLineMeasureElement.text
                    color = color.split(",")
                    color = [int(color[0]), int(color[1]), int(color[2])]

                pointSize = Dfct.childText(child, "PointSize")
                axis = Dfct.childText(child, "Axis")
                axisValue = Dfct.childText(child, "AxisValue")

                if axisValue is None:
                    axisValue = 0
                if (imageViewer.parent.sliderAxis.radioButtonX.isChecked() and axis == "X" and imageViewer.parent.sliderAxis.sliderX.slider.value() == int(axisValue)) or\
                    (imageViewer.parent.sliderAxis.radioButtonY.isChecked() and axis == "Y" and imageViewer.parent.sliderAxis.sliderY.slider.value() == int(axisValue)) or\
                    (imageViewer.parent.sliderAxis.radioButtonZ.isChecked() and axis == "Z" and imageViewer.parent.sliderAxis.sliderZ.slider.value() == int(axisValue)) or\
                    Dfct.childText(self.mainWindow.currentLabel.xmlElement,"Z")=="1":

                    if pointSize is not None:
                        # DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.lineMeasureColor[0]),float(vrb.lineMeasureColor[1]),float(vrb.lineMeasureColor[2])], showPoints=True, lineSize=2, pointMode="bar",pointSize=int(pointSize),lineMeasure=True,calibration=calibration,mainWindow=self.mainWindow)
                        DWfct.addPolygonToScene(imageViewer, child, color=color, showPoints=True, lineSize=2, pointMode="bar",pointSize=int(pointSize),lineMeasure=True,calibration=calibration,mainWindow=self.mainWindow)
                    else:
                        # DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.lineMeasureColor[0]),float(vrb.lineMeasureColor[1]),float(vrb.lineMeasureColor[2])], showPoints=True, lineSize=2, pointMode="bar",pointSize=6,lineMeasure=True,calibration=calibration,mainWindow=self.mainWindow)
                        DWfct.addPolygonToScene(imageViewer, child, color=color, showPoints=True, lineSize=2, pointMode="bar",pointSize=6,lineMeasure=True,calibration=calibration,mainWindow=self.mainWindow)

            allAnglesElement = Dfct.SubElement(graphicXmlElement, "AllAngles")
            for child in allAnglesElement:
                DWfct.addAngleToScene(imageViewer, child)

            allAddLabelsElement = Dfct.SubElement(graphicXmlElement, "AllAddLabels")
            for child in allAddLabelsElement:
                DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.addColor[0]),float(vrb.addColor[1]),float(vrb.addColor[2])], showPoints=True, lineSize=2, pointMode="circle", pointSize=3)
            allMergeLabelsElement = Dfct.SubElement(graphicXmlElement, "AllMergeLabels")
            for child in allMergeLabelsElement:
                DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.mergeColor[0]),float(vrb.mergeColor[1]),float(vrb.mergeColor[2])], showPoints=True, pointMode="circle", pointSize=5)
            allSplitLabelsElement = Dfct.SubElement(graphicXmlElement, "AllSplitLabels")
            for child in allSplitLabelsElement:
                DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.split2DColor[0]),float(vrb.split2DColor[1]),float(vrb.split2DColor[2])], showPoints=True, pointMode="circle", pointSize=3,lineSize=2,closed=False)
            allSplitLabels3DElement = Dfct.SubElement(graphicXmlElement, "AllSplitLabels3D")
            for child in allSplitLabels3DElement:
                DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.split3DColor[0]),float(vrb.split3DColor[1]),float(vrb.split3DColor[2])], showPoints=True, pointMode="circle", pointSize=5)
            allDeleteLabelsElement = Dfct.SubElement(graphicXmlElement, "AllDeleteLabels")
            for child in allDeleteLabelsElement:
                DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.deleteColor[0]),float(vrb.deleteColor[1]),float(vrb.deleteColor[2])], showPoints=True, pointMode="cross", pointSize=5)
            allKeepLabelsElement = Dfct.SubElement(graphicXmlElement, "AllKeepLabels")
            for child in allKeepLabelsElement:
                DWfct.addPolygonToScene(imageViewer, child, color=[float(vrb.keepColor[0]),float(vrb.keepColor[1]),float(vrb.keepColor[2])], showPoints=True, pointMode="crossVertical", pointSize=5)

            if self.calibrationLine is not None:
                DWfct.addPolygonToScene(imageViewer, self.calibrationLine, color=[255, 0, 0], showPoints=True, lineSize=2, pointMode="bar", pointSize=6, lineMeasure=True, calibration=None, mainWindow=self.mainWindow,roundValue = True)

            if self.previewRectangle is not None:
                DWfct.addPolygonToScene(imageViewer, self.previewRectangle, color=self.previewColor, showPoints=True, lineSize=2, closed="True", pointMode="circle")

            if self.selectionRectangle3D is not None:

                for imageViewerStandAlone in self.mainWindow.widgetImage.listImageViewerStandAlone:
                    toDisplay = self.verifDisplayZoneRectangle(imageViewerStandAlone)
                    if toDisplay in ["In", "Equal"]:
                        DWfct.addPolygonToScene(imageViewerStandAlone.imageViewer, self.selectionRectangle3D, color=[255, 255, 255], showPoints=True, lineSize=2, closed="True")
                        DWfct.addPolygonToScene(imageViewerStandAlone.imageViewer, self.selectionRectangle3D,  color=[6, 115, 186], dashLines=True, showPoints=True, lineSize=2, closed="True", pointMode="circle", pointSize=1)
                    if toDisplay == "Equal":
                        DWfct.addPolygonToScene(imageViewerStandAlone.imageViewer, self.selectionRectangle3D, color=[127, 127, 127], opacity=0.7, lineSize=0, closed="True")

                # Creation of a 3D ROI inside the 3d viewer when selecting an area in the 2D viewers of the 4 views mode
                if vrb.mainWindow.widgetImage.modeViewer == "4Views":

                    np.seterr(divide='ignore', invalid='ignore')  # used to ignore warnings from vispy

                    # get the points of the selection rectangle
                    allPointsElement = Dfct.SubElement(self.selectionRectangle3D, "AllPoints")

                    rectangle1 = [["X1", "Y1", "Z1"], ["X2", "Y1", "Z1"], ["X2", "Y2", "Z1"],
                                  ["X1", "Y2", "Z1"]]
                    rectangle2 = [["X1", "Y1", "Z1"], ["X1", "Y1", "Z2"], ["X1", "Y2", "Z2"], ["X1", "Y2", "Z1"]]
                    rectangle3 = [["X1", "Y1", "Z2"], ["X2", "Y1", "Z2"], ["X2", "Y2", "Z2"], ["X1", "Y2", "Z2"]]
                    rectangle4 = [["X2", "Y1", "Z2"], ["X2", "Y1", "Z1"], ["X2", "Y2", "Z1"], ["X2", "Y2", "Z2"]]
                    rectangle5 = [["X2", "Y2", "Z2"], ["X1", "Y2", "Z2"], ["X1", "Y2", "Z1"], ["X2", "Y2", "Z1"]]
                    rectangle6 = [["X2", "Y1", "Z2"], ["X1", "Y1", "Z2"], ["X1", "Y1", "Z1"], ["X2", "Y1", "Z1"]]
                    rectangles = [rectangle1, rectangle2, rectangle3, rectangle4, rectangle5, rectangle6]

                    # get calibration origin to calibrate the ROI
                    curLabel = self.mainWindow.currentLabel
                    curLayer = self.mainWindow.currentLabel.layer
                    if curLabel.image.hasGeometricCalibration():
                        calibration = self.mainWindow.currentLabel.image.getGeometricCalibration()
                    else:
                        calibration = PyIPSDK.createGeometricCalibration(1,1,1,"px")
                    originX = calibration.getXOriginUncalibrated()
                    originY = calibration.getYOriginUncalibrated()
                    originZ = calibration.getZOriginUncalibrated()



                    # create an array with all the points that form the selection rectangle
                    shapes = []
                    for shape in rectangles:
                        vertices = []
                        for point in shape:
                            x = float(Dfct.childText(allPointsElement, point[0]))+originX
                            y = float(Dfct.childText(allPointsElement, point[1]))+originY
                            z = float(Dfct.childText(allPointsElement, point[2]))+originZ
                            vertices.append([z, y, x])
                        shapes.append(np.asarray(vertices))

                    # create or update the datas of the roi3D
                    if self.mainWindow.viewer3dSettingsWidget.roi3D is None:

                        # self.mainWindow.viewer3dSettingsWidget.roi3D = self.mainWindow.viewerNapari.add_surface((vertices,faces), colormap=[118/255,235/255,181/255], opacity=0.5, blending="additive")
                        # self.mainWindow.viewer3dSettingsWidget.roi3D = self.mainWindow.viewerNapari.add_shapes(shapes,
                        self.mainWindow.viewer3dSettingsWidget.roi3D = self.mainWindow.viewerNapari.add_shapes(shapes,
                                                                                                               face_color=[
                                                                                                                   12 / 255,
                                                                                                                   73 / 255,
                                                                                                                   45 / 255],
                                                                                                               edge_color=[
                                                                                                                   12 / 255,
                                                                                                                   73 / 255,
                                                                                                                   45 / 255],
                                                                                                               opacity=0.4,
                                                                                                               shape_type='rectangle',
                                                                                                               blending="additive")
                        #put the roi3D layer after all the layers
                        vrb.mainWindow.viewer3dSettingsWidget.reorderLayers()
                    else:

                        self.mainWindow.viewer3dSettingsWidget.roi3D.data = shapes
                        self.mainWindow.viewer3dSettingsWidget.roi3D.scale = vrb.mainWindow.currentLabel.layer.scale

                        vrb.mainWindow.viewer3dSettingsWidget.reorderLayers()

            np.seterr(divide='warn', invalid='warn') # sets the warnings back

            if self.zoomZoneRectangle is not None:
                DWfct.addPolygonToScene(imageViewer, self.zoomZoneRectangle, color=[255,255,255],lineSize=2,showPoints=False, closed="True")

            # for object in self.imageViewer.widgetImage.elementIPSDK:
            for widgetObject in self.imageViewer.widgetImage.elementIPSDK:
                object = widgetObject.object
                if PyIPSDK.Shape2dColl == type(object):
                    DWfct.addShapesToScene(self.imageViewer, object)
                elif PyIPSDK.Pixels2d == type(object):
                    objectSettings = dictCustomObject[object.subType]
                    DWfct.addPointsToScene(self.imageViewer, object, pointMode=objectSettings['PointMode'], color=objectSettings['Color'],harrisCorner = True)
                elif PyIPSDK.PlanIndexedPixels2d == type(object):
                    if self.imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                        objectSettings = dictCustomObject[object.subType]
                        objectToDisplay = object.getValue(self.imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value())
                        DWfct.addPointsToScene(self.imageViewer, objectToDisplay, pointMode=objectSettings['PointMode'], color=objectSettings['Color'],harrisCorner = True)
                elif PyIPSDK.Voxels3d == type(object):
                    objectSettings = dictCustomObject[object.subType]
                    DWfct.addPoints3dToScene(self.imageViewer, object, pointMode=objectSettings['PointMode'], color=objectSettings['Color'])
                elif isinstance(object, Measure):
                    if object.subType == 'HoughCircles2d':
                        objectSettings = dictCustomObject[object.subType]
                        DWfct.addCirclesToScene(self.imageViewer, object.value, color=objectSettings['Color'],houghCircle=True)
                    if object.subType == 'HoughSpheres3d':
                        objectSettings = dictCustomObject[object.subType]
                        # DWfct.addSpheresToScene(self.imageViewer, object.value, color=objectSettings['Color'],houghSphere=True)
                        DWfct.addSpheresToScene(imageViewer, object.value, color=objectSettings['Color'],houghSphere=True)
                    elif object.subType == 'HoughLines':
                        objectSettings = dictCustomObject[object.subType]
                        DWfct.addLinesToScene(self.imageViewer, object.value, color=objectSettings['Color'],houghLine=True)
                    elif object.subType == 'VectorialField':
                        try:
                            DWfct.addVectorialFieldToScene(self.imageViewer, object.value)
                        except:
                            traceback.print_exc(file=sys.stderr)

            if vrb.linePoint is not None:
                DWfct.addPointsToScene(imageViewer, vrb.linePoint, color=QtGui.QColor(255,0,0),pointMode="cross",formSize=5,resizeFactor=2)

    def rightClickFunction(self,ddict):

        try:
            distMoveRef = self.distMinSelection
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")

            if ddict["Button"] == 2 and ddict["Event"] == "MousePressed":

                self.resetCurrentPolygonSelected()

                roiElement = Dfct.SubElement(graphicXmlElement, "Roi")
                polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), roiElement, distMin=self.distMinSelection)
                if distMove < distMoveRef:
                    self.currentPolygonSelected = roiElement
                    distMoveRef = distMove

                allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")
                for child in allLineMeasuresElement:
                    if child.tag == "LineMeasure":
                        polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), child, distMin=self.distMinSelection)
                        if distMove < distMoveRef:
                            self.currentPolygonSelected = child
                            distMoveRef = distMove

                if self.currentPolygonSelected != None:
                    selectionElement = Dfct.SubElement(self.currentPolygonSelected, "Selection")
                    selectionElement.text = "True"
                    self.mainWindow.groupMenu.setMode("Selection")

                    self.getRoiImage(changeRoiImage=False)

                    if self.currentPolygonSelected.tag == "LineMeasure":
                        contextMenu = qt.QMenu()
                        contextMenu.addAction('Profile', self.addLineProfile)
                        contextMenu.addAction('Change color', self.getColor)
                        #contextMenu.addAction('Change size', self.changeLineMeasureSize)
                        #contextMenu.addAction('Add title', self.addTitle)
                        #contextMenu.addAction('Save profile', self.saveLineProfile)
                        contextMenu.exec(self.imageViewer.mapToGlobal(ddict["CursorPosition"]))
                    elif self.currentPolygonSelected.tag == "Roi":
                        contextMenu = qt.QMenu()
                        contextMenu.addAction('Create mask', self.createMaskFromRoi)
                        if self.mainWindow.currentLabel is not None and self.mainWindow.imageViewer.image is not None:
                            if self.mainWindow.widgetImage.imageOverlayLabel is not None and self.mainWindow.widgetImage.imageOverlayLabel.image is not None:
                                if self.mainWindow.widgetImage.imageOverlayLabel.image.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16,PyIPSDK.eIBT_Label32]:
                                    image = self.mainWindow.widgetImage.imageOverlayLabel.image
                                else:
                                    image = self.mainWindow.currentLabel.image
                            else:
                                image = self.mainWindow.currentLabel.image
                            if image.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16,PyIPSDK.eIBT_Label32]:
                                menuCreateMaskedImage = contextMenu.addMenu('Create masked image')
                                menuCreateMaskedImage.addAction('Without border', self.maskedImageWithoutBorder)
                                menuCreateMaskedImage.addAction('With border', self.maskedImageWithBorder)
                            else:
                                contextMenu.addAction('Create masked image', self.maskedImageWithBorder)
                            if image.getSizeZ() == 1:
                                contextMenu.addAction('Create label image', self.createLabelImage)
                        contextMenu.exec(self.imageViewer.mapToGlobal(ddict["CursorPosition"]))
        except:
            traceback.print_exc(file=sys.stderr)
    def getColor(self):

        color = qt.QColorDialog.getColor()

        colorLineMeasureElement = Dfct.SubElement(self.currentPolygonSelected, "ColorLineMeasure")

        if (color.isValid()):
            colorLineMeasureElement.text = str(color.red()) + "," + str(color.green()) + "," + str(color.blue())

            self.applyGraphicElement(self.imageViewer)

    def createLabelImage(self):

        if self.mainWindow.currentLabel is not None and self.mainWindow.imageViewer.image is not None:

            currentLabel = self.mainWindow.currentLabel

            image = self.mainWindow.currentLabel.image

            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")

            imagePolygon, polygon = fct.createPolygonImage(roiElement, image)
            imagePolygon = util.convertImg(imagePolygon,PyIPSDK.eIBT_Label16)

            outputDict = {}
            outputDict["Name"] = ""
            outputDict["Type"] = "Image"

            functionXmlElement = xmlet.Element('FunctionCall')
            Dfct.SubElement(functionXmlElement, 'Name').text = 'CreateLabelImageFromPolygon'
            paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
            paramNode = Dfct.SubElement(paramsNode, 'Parameter_0')
            Dfct.SubElement(paramNode, 'Value').text = str(polygon)

            label, realOutputName = self.mainWindow.addResult(imagePolygon, outputDict, functionXmlElement)

            xmlElement = label.xmlElement
            Dfct.SubElement(xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')

            self.resetCurrentPolygonSelected()

            Dfct.clearElement(roiElement)

            self.mainWindow.changeCurrentXmlElement(currentLabel)
            self.mainWindow.widgetImage.groupBoxOverlay.checkBoxOverlay.setChecked(True)
            self.mainWindow.widgetImage.groupBoxOverlay.comboBoxOverlay.setCurrentText(realOutputName)

    def displayStats(self,ddict):

        if ddict["Button"] == 0 and ddict["Event"] == "Move":

            text = ""

            posX = ddict["Position"][0]
            posY = ddict["Position"][1]

            try:
                try:
                    infoSet = self.mainWindow.widgetImage.imageOverlayLabel.image.infoSet
                    image = self.mainWindow.imageViewer.imageOverlay[0]
                except:
                    infoSet = self.mainWindow.currentLabel.image.infoSet
                    image = self.mainWindow.imageViewer.image[0]

                if infoSet is not None:

                    label = image.array[int(posY)][int(posX)]

                    if label > 0:
                        text += "Label : " + str(label) + "\n"

                        if infoSet.xmlElement is not None:
                            allMeasures = measureIterator(infoSet.xmlElement)
                        else:
                            allMeasures = []
                            for msr in infoSet.getMeasureInfoSet().getMeasureInfoColl():
                                key = msr.key()
                                userName, isFound = fct.findUserName(key)
                                if "->" not in userName and "___" not in userName and userName not in ["Ref_Barycenter_X","Ref_Barycenter_Y","Ref_Barycenter_Z"]:
                                    allMeasures.append((key, userName))

                        # for callName, userName in measureIterator(infoSet.xmlElement):
                        for callName, userName in allMeasures:
                            try:
                                values = infoSet.getMeasure(callName).getMeasureResult().getColl(0)
                                #userName = Dfct.childText(measureNode, 'UserName')
                                if infoSet.getMeasure(callName).getMsrUnitStr() != "" and infoSet.getMeasure(callName).getMsrUnitStr() is not None:
                                    userName += " (" + infoSet.getMeasure(callName).getMsrUnitStr() + ")"
                                value = values[int(label)]
                                if isinstance(value, type(True)):
                                    value = str(value)
                                else:
                                    value = fct.numberCalibration(value)
                                text += userName + " : " + value + "\n"
                            except:
                                traceback.print_exc(file=sys.stderr)
                                pass

                        text = text.replace('^2', '²')
                        text = text.replace('^3', '³')

                    else:
                        text = ""
                else:
                    text =""
            except:
                # traceback.print_exc(file=sys.stderr)
                text = ""

            if text == "":
                stop = False
                for widgetObject in self.imageViewer.widgetImage.elementIPSDK:
                    object = widgetObject.object
                    distMin = 2
                    if object.subType == 'HoughCircles' and stop == False:
                        stop = True
                        for circle in object.value:
                            distance = abs(np.sqrt((posX-circle["X"])**2+(posY-circle["Y"])**2) - circle["Radius"])
                            if distance <= distMin:
                                distMin = distance
                                text = "Center X : "+str(circle["X"]) + "\n" + "Center Y : "+str(circle["Y"]) + "\n" + "Radius : "+str(circle["Radius"]) + "\n" + "Accumulated intensity : "+str(circle["AccumIntensity"]) + "\n"

            self.mainWindow.imageViewer.setToolTip(text)


    def maskedImageWithoutBorder(self):

        self.maskedImage(border = False)

    def maskedImageWithBorder(self):

        self.maskedImage(border=True)

    def maskedImage(self,border = True):

        if self.mainWindow.currentLabel is not None and self.mainWindow.imageViewer.image is not None:
            if self.mainWindow.widgetImage.imageOverlayLabel is not None and self.mainWindow.widgetImage.imageOverlayLabel.image is not None:
                if self.mainWindow.widgetImage.imageOverlayLabel.image.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16, PyIPSDK.eIBT_Label32]:
                    image = self.mainWindow.widgetImage.imageOverlayLabel.image
                else:
                    image = self.mainWindow.currentLabel.image
            else:
                image = self.mainWindow.currentLabel.image

            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")

            imagePolygon, polygon = fct.createPolygonImage(roiElement, image)
            if image.getSizeC() == 1 and image.getSizeZ() == 1:
                outImage = logic.maskImg(image, imagePolygon)
            else:
                outImage = PyIPSDK.createImage(image)
                arithm.genericMultiplyImgImg(image,imagePolygon,outImage)

            if border == False:
                if image.getSizeZ() == 1:
                    outImage = shapeanalysis.shapeFiltering2dImg(image, outImage, "MinMsr > 0")
                else:
                    outImage = shapeanalysis.shapeFiltering3dImg(image, outImage, "MinMsr > 0")


            outputDict = {}
            outputDict["Name"] = ""
            outputDict["Type"] = "Image"

            functionXmlElement = xmlet.Element('FunctionCall')
            Dfct.SubElement(functionXmlElement, 'Name').text = 'CreateMaskedImageFromPolygon'
            paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
            paramNode = Dfct.SubElement(paramsNode, 'Parameter_0')
            Dfct.SubElement(paramNode, 'Value').text = str(polygon)

            label, realOutputName = self.mainWindow.addResult(outImage, outputDict, functionXmlElement)

            xmlElement = label.xmlElement
            Dfct.SubElement(xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')

            self.resetCurrentPolygonSelected()

    def createMaskFromRoi(self):

        if self.mainWindow.currentLabel is not None and self.mainWindow.imageViewer.image is not None:
            image = self.mainWindow.currentLabel.image
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")

            imagePolygon,polygon = fct.createPolygonImage(roiElement,image)

            outputDict = {}
            outputDict["Name"] = ""
            outputDict["Type"] = "Image"

            functionXmlElement = xmlet.Element('FunctionCall')
            Dfct.SubElement(functionXmlElement, 'Name').text = 'CreateMaskFromPolygon'
            paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
            paramNode = Dfct.SubElement(paramsNode, 'Parameter_0')
            Dfct.SubElement(paramNode, 'Value').text = str(polygon)

            label, realOutputName = self.mainWindow.addResult(imagePolygon, outputDict, functionXmlElement)

            xmlElement = label.xmlElement
            Dfct.SubElement(xmlElement, 'AssociatedID').text = Dfct.childText(label.xmlElement, 'ElementID')

            self.resetCurrentPolygonSelected()

    def addLineProfile(self):

        existAlready = False
        for profile in self.allLineProfiles:
            if profile.lineElement == self.currentPolygonSelected:
                profile.show()
                existAlready = True

        if existAlready == False:

            lineProfile = display.CustomLineWidget()
            lineProfile.signalDelete.connect(self.removeLineProfile)

            # fig = Figure()
            # lineProfile.fig = fig
            lineProfile.lineElement = self.currentPolygonSelected
            lineProfile.widget = self.mainWindow.currentLabel

            try:
                self.drawLineProfile(lineProfile)
                self.allLineProfiles.append(lineProfile)
                lineProfile.show()

            except:
                traceback.print_exc(file=sys.stderr)
                pass

    def drawLineProfile(self,lineProfile):

        image = lineProfile.widget.image

        minX, minY, sizeX, sizeY = DWfct.boundingBoxPolygon(lineProfile.lineElement,precise=True)

        lenLine = (sizeX ** 2 + sizeY ** 2) ** 0.5

        minX = int(minX)
        minY = int(minY)
        sizeX = int(sizeX)
        sizeY = int(sizeY)
        lenLine = int(lenLine)

        maxX = minX+sizeX
        maxY = minY+sizeY

        minX = min(minX,image.getSizeX()-1)
        maxX = min(maxX,image.getSizeX()-1)
        minY = min(minY,image.getSizeY()-1)
        maxY = min(maxY,image.getSizeY()-1)

        x, y = np.linspace(minX,maxX, lenLine), np.linspace(minY, maxY, lenLine)

        if image.getSizeT() > 1:
            valueSequence = self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderSequence.slider.value()
            if image.getSizeZ()==1:
                if image.getSizeC()==1:
                    imageProcess = PyIPSDK.extractPlan(0, 0, valueSequence, image)
                else:
                    imageProcess = PyIPSDK.extractColor(0, valueSequence, image)
            else:
                if image.getSizeC()==1:
                    imageProcess = PyIPSDK.extractVolume(0, valueSequence, image)
                else:
                    imageProcess = PyIPSDK.extractColorVolume(valueSequence, image)
            image = util.copyImg(imageProcess)

        plan = "XY"
        if image.getSizeZ() > 1:
            if self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                plan = "YZ"
                if image.getSizeC() == 1:
                    imageArray = np.ascontiguousarray(image.array[:, :, self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
                else:
                    imageArray = np.ascontiguousarray(image.array[:, :, :, self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()])
            if self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                plan = "XZ"
                if image.getSizeC() == 1:
                    imageArray = np.ascontiguousarray(image.array[:, self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(),:])
                else:
                    imageArray = np.ascontiguousarray(image.array[:, :, self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value(),:])
            if self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                plan = "XY"
                if image.getSizeC() == 1:
                    imageArray = np.ascontiguousarray(image.array[self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(),:,:])
                else:
                    imageArray = np.ascontiguousarray(image.array[:,self.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value(),:,:])
        else:
            imageArray = image.array

        if lineProfile.widget.image.hasGeometricCalibration():
            calibration = lineProfile.widget.image.getGeometricCalibration()
            if plan == "YZ":
                xCoeff = calibration.getYScale()
                yCoeff = calibration.getZScale()
            if plan == "XZ":
                xCoeff = calibration.getXScale()
                yCoeff = calibration.getZScale()
            if plan == "XY":
                xCoeff = calibration.getXScale()
                yCoeff = calibration.getYScale()
            try:
                unit = calibration.getUnitStr()
            except:
                unit = "um"
        else:
            xCoeff = 1
            yCoeff = 1
            unit = "px"

        lineProfile.xCoeff = xCoeff
        lineProfile.yCoeff = yCoeff

        legendX = np.sqrt(np.square((x-minX)*xCoeff) + np.square((y-minY)*yCoeff))

        lineProfile.setWindowTitle(lineProfile.widget.name)

        if len(imageArray.shape) == 2:
            values = [imageArray[y.astype(np.int32), x.astype(np.int32)]]
            lineProfile.fig.clf()
            axes = lineProfile.fig.add_subplot(111)
            line = axes.plot(legendX, values[0],color="blue")
        elif len(imageArray.shape) == 3:
            colors = ["Red","Green","Blue"]
            values =  imageArray[:,y.astype(np.int32), x.astype(np.int32)]
            lineProfile.fig.clf()
            axes = lineProfile.fig.add_subplot(111)
            if len(values) == 3:
                for c in range(3):
                    line = axes.plot(legendX, values[c],color = colors[c])
            else:
                for c in range(len(values)):
                    line = axes.plot(legendX, values[c],label = "Channel "+str(c))
                axes.legend(loc=1, prop={'size': 10})

        lineProfile.xValue = x
        lineProfile.yValue = y
        lineProfile.legendX = legendX
        lineProfile.values = values

        axes.set_xlabel("Distance ("+unit+")")
        axes.set_ylabel("Image intensity")
        axes.set_title('Intensity profile')

        lineProfile.plotWidget.draw()

        _ = lineProfile.fig.canvas.mpl_connect('motion_notify_event', lineProfile.figureMouseMoveEvent)
        _ = lineProfile.fig.canvas.mpl_connect('figure_leave_event', lineProfile.figureMouseLeaveEvent)

    def removeLineProfile(self,lineProfile):

        try:
            self.allLineProfiles.remove(lineProfile)
        except:
            pass

    def addRoi(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

                closedElement = Dfct.SubElement(roiElement, "Closed")
                if closedElement.text != "True":
                    self.refPosX = ddict["Position"][0]
                    self.refPosY = ddict["Position"][1]
                    DWfct.addPointToPolygon(roiElement, QtCore.QPointF(self.refPosX, self.refPosY))
                    self.getRoiImage(changeRoiImage=False)

            if ddict["Button"] == 1 and ddict["Event"] == "DoubleClick":

                closedElement = Dfct.SubElement(roiElement, "Closed")
                closedElement.text = "True"
                self.getRoiImage(changeRoiImage=False)

    def addLabel(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allAddLabelsElement = Dfct.SubElement(graphicXmlElement, "AllAddLabels")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

                if self.currentAddLabel == None:
                    self.currentAddLabel = xmlet.SubElement(allAddLabelsElement, "Label")
                    self.refPosX = ddict["Position"][0]
                    self.refPosY = ddict["Position"][1]
                    DWfct.addPointToPolygon(self.currentAddLabel, QtCore.QPointF(self.refPosX, self.refPosY))
                else:
                    DWfct.addPointToPolygon(self.currentAddLabel, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]))

                self.getRoiImage(changeRoiImage=False)

            if ddict["Button"] == 1 and ddict["Event"] == "DoubleClick":

                if self.currentAddLabel != None:
                    closedElement = Dfct.SubElement(self.currentAddLabel, "Closed")
                    closedElement.text = "True"

                self.currentAddLabel = None
                self.getRoiImage(changeRoiImage=False)

    def splitLabel(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allSplitLabelsElement = Dfct.SubElement(graphicXmlElement, "AllSplitLabels")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

                if self.currentSplitLabel == None:
                    self.currentSplitLabel = xmlet.SubElement(allSplitLabelsElement, "Label")
                    self.refPosX = ddict["Position"][0]
                    self.refPosY = ddict["Position"][1]
                    DWfct.addPointToPolygon(self.currentSplitLabel, QtCore.QPointF(self.refPosX, self.refPosY))
                else:
                    DWfct.addPointToPolygon(self.currentSplitLabel, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]))

                self.getRoiImage(changeRoiImage=False)

            if ddict["Button"] == 1 and ddict["Event"] == "DoubleClick":
                self.currentSplitLabel = None
                self.getRoiImage(changeRoiImage=False)

    def splitLabel3D(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allSplitLabels3DElement = Dfct.SubElement(graphicXmlElement, "AllSplitLabels3D")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":
                splitLabels3DElement = xmlet.SubElement(allSplitLabels3DElement, "Label")
                maxSizeElement = Dfct.SubElement(splitLabels3DElement, "MaxSize")
                maxSizeElement.text = str(1)
                self.refPosX = ddict["Position"][0]
                self.refPosY = ddict["Position"][1]
                DWfct.addPointToPolygon(splitLabels3DElement, QtCore.QPointF(self.refPosX, self.refPosY))

                self.getRoiImage(changeRoiImage=False)

    def mergeLabel(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allMergeLabelsElement = Dfct.SubElement(graphicXmlElement, "AllMergeLabels")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":
                mergeLabelElement = xmlet.SubElement(allMergeLabelsElement, "Label")
                maxSizeElement = Dfct.SubElement(mergeLabelElement, "MaxSize")
                maxSizeElement.text = str(1)
                self.refPosX = ddict["Position"][0]
                self.refPosY = ddict["Position"][1]
                DWfct.addPointToPolygon(mergeLabelElement, QtCore.QPointF(self.refPosX, self.refPosY))

                self.getRoiImage(changeRoiImage=False)

    def keepLabel(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allKeepLabelsElement = Dfct.SubElement(graphicXmlElement, "AllKeepLabels")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":
                keepLabelElement = xmlet.SubElement(allKeepLabelsElement, "Label")
                maxSizeElement = Dfct.SubElement(keepLabelElement, "MaxSize")
                maxSizeElement.text = str(1)
                self.refPosX = ddict["Position"][0]
                self.refPosY = ddict["Position"][1]
                DWfct.addPointToPolygon(keepLabelElement, QtCore.QPointF(self.refPosX, self.refPosY))

                self.getRoiImage(changeRoiImage=False)


    def deleteLabel(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allDeleteLabelsElement = Dfct.SubElement(graphicXmlElement, "AllDeleteLabels")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":
                deleteLabelElement = xmlet.SubElement(allDeleteLabelsElement, "Label")
                maxSizeElement = Dfct.SubElement(deleteLabelElement, "MaxSize")
                maxSizeElement.text = str(1)
                self.refPosX = ddict["Position"][0]
                self.refPosY = ddict["Position"][1]
                DWfct.addPointToPolygon(deleteLabelElement, QtCore.QPointF(self.refPosX, self.refPosY))

                self.getRoiImage(changeRoiImage=False)

    def addLabeling(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allLabelingElement = Dfct.SubElement(graphicXmlElement, "AllLabeling")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

                image = self.mainWindow.imageViewer.image[0]

                if image.getSizeC() == 1:
                    labelingElement = xmlet.SubElement(allLabelingElement, "Labeling")
                    valueElement = Dfct.SubElement(labelingElement, "Value")
                    value = image.array[int(ddict["Position"][0])][int(ddict["Position"][1])]
                    valueElement.text = str(value)
                    pointXElement = Dfct.SubElement(labelingElement, "PointX")
                    pointXElement.text = str(ddict["Position"][0])
                    pointYElement = Dfct.SubElement(labelingElement, "PointY")
                    pointYElement.text = str(ddict["Position"][1])

                self.getRoiImage(changeRoiImage=False)


    def addMearsureLine(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

                if self.currentLineMeasure == None:
                    self.currentLineMeasure = xmlet.SubElement(allLineMeasuresElement, "LineMeasure")
                    maxSizeElement = Dfct.SubElement(self.currentLineMeasure, "MaxSize")
                    maxSizeElement.text = str(2)
                    axisElement = Dfct.SubElement(self.currentLineMeasure, "Axis")
                    axisValueElement = Dfct.SubElement(self.currentLineMeasure, "AxisValue")
                    if self.imageViewer.parent.sliderAxis.radioButtonX.isChecked():
                        axisElement.text = "X"
                        axisValueElement.text = str(self.imageViewer.parent.sliderAxis.sliderX.slider.value())
                    if self.imageViewer.parent.sliderAxis.radioButtonY.isChecked():
                        axisElement.text = "Y"
                        axisValueElement.text = str(self.imageViewer.parent.sliderAxis.sliderY.slider.value())
                    if self.imageViewer.parent.sliderAxis.radioButtonZ.isChecked():
                        axisElement.text = "Z"
                        axisValueElement.text = str(self.imageViewer.parent.sliderAxis.sliderZ.slider.value())

                    self.refPosX = ddict["Position"][0]
                    self.refPosY = ddict["Position"][1]
                    DWfct.addPointToPolygon(self.currentLineMeasure, QtCore.QPointF(self.refPosX, self.refPosY))

                else:
                    DWfct.addPointToPolygon(self.currentLineMeasure, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]))

                self.getRoiImage(changeRoiImage=False)
                self.drawing = True

            if ddict["Button"] == 0 and ddict["Event"] == "Move":

                if self.refPosX != None and self.refPosY != None and self.currentLineMeasure != None and self.drawing:
                    Dfct.clearElement(self.currentLineMeasure)

                    maxSizeElement = Dfct.SubElement(self.currentLineMeasure, "MaxSize")
                    maxSizeElement.text = str(2)
                    axisElement = Dfct.SubElement(self.currentLineMeasure, "Axis")
                    axisValueElement = Dfct.SubElement(self.currentLineMeasure, "AxisValue")
                    if self.imageViewer.parent.sliderAxis.radioButtonX.isChecked():
                        axisElement.text = "X"
                        axisValueElement.text = str(self.imageViewer.parent.sliderAxis.sliderX.slider.value())
                    if self.imageViewer.parent.sliderAxis.radioButtonY.isChecked():
                        axisElement.text = "Y"
                        axisValueElement.text = str(self.imageViewer.parent.sliderAxis.sliderY.slider.value())
                    if self.imageViewer.parent.sliderAxis.radioButtonZ.isChecked():
                        axisElement.text = "Z"
                        axisValueElement.text = str(self.imageViewer.parent.sliderAxis.sliderZ.slider.value())

                    DWfct.addPointToPolygon(self.currentLineMeasure, QtCore.QPointF(self.refPosX, self.refPosY))
                    DWfct.addPointToPolygon(self.currentLineMeasure, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]))

                    self.getRoiImage(changeRoiImage=False)

            if ddict["Button"] == 1 and ddict["Event"] == "Release":

                nbPoints = 0
                if self.currentLineMeasure != None:
                    allPointsElement = Dfct.SubElement(self.currentLineMeasure, "AllPoints")
                    for child in allPointsElement:
                        if child.tag == "Point":
                            nbPoints += 1
                    if nbPoints == 2:
                        self.currentLineMeasure = None
                        self.refPosX = None
                        self.refPosY = None

                        if self.mainWindow.colorWidget.checkboxSwitchMeasuresMode.isChecked():
                            self.mainWindow.groupMenu.setMode("Selection")
                        else:
                            self.mainWindow.groupMenu.setMode("MeasureLine")

                self.drawing = False

    def addAngle(self,ddict):

        if self.mainWindow.currentLabel is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            allAnglesElement = Dfct.SubElement(graphicXmlElement, "AllAngles")

            if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

                if self.currentAngle == None:

                    self.currentAngle = xmlet.SubElement(allAnglesElement, "Angle")
                    DWfct.addPointToPolygon(self.currentAngle, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]))
                    Dfct.SubElement(self.currentAngle, 'NbPoints').text = "1"

                elif Dfct.childText(self.currentAngle, 'NbPoints') != "3":
                    DWfct.addPointToPolygon(self.currentAngle, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]))
                    Dfct.SubElement(self.currentAngle, 'NbPoints').text = str(int(Dfct.SubElement(self.currentAngle, 'NbPoints').text)+1)

                self.getRoiImage(changeRoiImage=False)
                self.drawing = True

        if ddict["Button"] == 1 and ddict["Event"] == "Release":

            if Dfct.childText(self.currentAngle, 'NbPoints') == "3":
                self.currentAngle = None
                self.refPosX = None
                self.refPosY = None
                self.mainWindow.groupMenu.setMode("Selection")

            self.drawing = False

    def zoneSelection(self,ddict):

        image = vrb.mainWindow.currentLabel.image

        if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

            self.resetCurrentPolygonSelected()
            self.currentPointSelected = None
            self.currentPolygonSelected = None

            self.refPosX = ddict["Position"][0]
            self.refPosY = ddict["Position"][1]

            if self.selectionRectangle3D is None:
                self.initSelectionRectangle3D(ddict,image)
            else:
                allPointsElement = Dfct.SubElement(self.selectionRectangle3D, "AllPoints")
                Dfct.SubElement(self.selectionRectangle3D, "Type").text = "Rectangle3D"
                if self.imageViewer.parent.sliderAxis.radioButtonX.isChecked():
                    ptX1 = Dfct.SubElement(allPointsElement, "Y1")
                    ptX2 = Dfct.SubElement(allPointsElement, "Y2")
                    ptY1 = Dfct.SubElement(allPointsElement, "Z1")
                    ptY2 = Dfct.SubElement(allPointsElement, "Z2")
                if self.imageViewer.parent.sliderAxis.radioButtonY.isChecked():
                    ptX1 = Dfct.SubElement(allPointsElement, "X1")
                    ptX2 = Dfct.SubElement(allPointsElement, "X2")
                    ptY1 = Dfct.SubElement(allPointsElement, "Z1")
                    ptY2 = Dfct.SubElement(allPointsElement, "Z2")
                if self.imageViewer.parent.sliderAxis.radioButtonZ.isChecked():
                    ptX1 = Dfct.SubElement(allPointsElement, "X1")
                    ptX2 = Dfct.SubElement(allPointsElement, "X2")
                    ptY1 = Dfct.SubElement(allPointsElement, "Y1")
                    ptY2 = Dfct.SubElement(allPointsElement, "Y2")

                maxX = self.imageViewer.image[0].getSizeX()
                maxY = self.imageViewer.image[0].getSizeY()

                # allPoints = [self.imageViewer.realPointToScene(float(ptX1),float(ptY1)),self.imageViewer.realPointToScene(float(ptX1),float(ptY2)),
                #              self.imageViewer.realPointToScene(float(ptX2),float(ptY2)),self.imageViewer.realPointToScene(float(ptX2),float(ptY1))]
                allPoints = [[ptX1,ptY1],[ptX1,ptY2],[ptX2,ptY2],[ptX2,ptY1]]
                pointRef =self.imageViewer.realPointToScene(self.refPosX,self.refPosY)

                self.currentPointSelected = None
                self.currentPolygonSelected = None

                distMoveRef = self.distMinSelection
                for point in allPoints:
                    distMove = DWfct.distancePointPoint(pointRef,self.imageViewer.realPointToScene(float(point[0].text),float(point[1].text)))
                    if distMove < distMoveRef:
                        self.currentPointSelected = point
                if self.currentPointSelected is None:
                    for i in range(4):
                        distMove = DWfct.distancePointSegment(pointRef,self.imageViewer.realPointToScene(float(allPoints[i][0].text),float(allPoints[i][1].text)),
                                                              self.imageViewer.realPointToScene(float(allPoints[(i+1)%4][0].text),float(allPoints[(i+1)%4][1].text)))
                        if distMove < distMoveRef:
                            self.currentPolygonSelected = [ptX1,ptY1,ptX2,ptY2,maxX,maxY]

                if self.currentPointSelected is not None or self.currentPolygonSelected is not None:
                    self.refPosX = ddict["Position"][0]
                    self.refPosY = ddict["Position"][1]
                    self.hasMoving = True

                else:
                    self.initSelectionRectangle3D(ddict, image)

            selectionElement = Dfct.SubElement(self.selectionRectangle3D, "Selection")
            selectionElement.text = "True"
            self.drawing = True
            # self.getRoiImage(changeRoiImage=False)

        if ddict["Button"] == 0 and ddict["Event"] == "Move":

            if self.drawing and self.currentPointSelected is not None:
                self.hasMoving = True
                self.currentPointSelected[0].text = str(ddict["Position"][0])
                self.currentPointSelected[1].text = str(ddict["Position"][1])
            elif self.drawing and self.currentPolygonSelected is not None:

                maxX = self.currentPolygonSelected[4]
                maxY = self.currentPolygonSelected[5]

                deltaX = ddict["Position"][0] - self.refPosX
                deltaX = max(deltaX, -float(self.currentPolygonSelected[0].text))
                deltaX = min(deltaX, maxX - float(self.currentPolygonSelected[0].text))
                deltaX = max(deltaX, -float(self.currentPolygonSelected[2].text))
                deltaX = min(deltaX, maxX - float(self.currentPolygonSelected[2].text))
                deltaY = ddict["Position"][1] - self.refPosY
                deltaY = max(deltaY, -float(self.currentPolygonSelected[1].text))
                deltaY = min(deltaY, maxY - float(self.currentPolygonSelected[1].text))
                deltaY = max(deltaY, -float(self.currentPolygonSelected[3].text))
                deltaY = min(deltaY, maxY - float(self.currentPolygonSelected[3].text))

                self.currentPolygonSelected[0].text = float(self.currentPolygonSelected[0].text) + deltaX
                self.currentPolygonSelected[1].text = float(self.currentPolygonSelected[1].text) + deltaY
                self.currentPolygonSelected[2].text = float(self.currentPolygonSelected[2].text) + deltaX
                self.currentPolygonSelected[3].text = float(self.currentPolygonSelected[3].text) + deltaY

                self.refPosX = ddict["Position"][0]
                self.refPosY = ddict["Position"][1]

        if ddict["Button"] == 1 and ddict["Event"] == "Release":
            # self.currentPointSelected = None
            # self.currentPolygonSelected = None

            self.currentSelectionPoint = None
            self.currentPolygonSelected = None

            self.refPosX = None
            self.refPosY = None
            self.drawing = False
            if self.hasMoving == False:
                self.selectionRectangle3D = None
                # self.getRoiImage(changeRoiImage=False)

        try:
            self.getRoiImage(changeRoiImage=False,transformImage=False)
        except:
            traceback.print_exc(file=sys.stderr)

    def initSelectionRectangle3D(self,ddict,image):

        self.selectionRectangle3D = xmlet.Element('Selection')
        allPointsElement = Dfct.SubElement(self.selectionRectangle3D, "AllPoints")
        Dfct.SubElement(self.selectionRectangle3D, "Type").text = "Rectangle3D"

        if self.imageViewer.parent.sliderAxis.radioButtonX.isChecked():
            Dfct.SubElement(allPointsElement, "X1").text = "0"
            Dfct.SubElement(allPointsElement, "X2").text = str(image.getSizeX())
            Dfct.SubElement(allPointsElement, "Y1").text = str(self.refPosX)
            Dfct.SubElement(allPointsElement, "Y2").text = str(self.refPosX)
            Dfct.SubElement(allPointsElement, "Z1").text = str(self.refPosY)
            Dfct.SubElement(allPointsElement, "Z2").text = str(self.refPosY)
            self.currentPointSelected = [Dfct.SubElement(allPointsElement, "Y2"), Dfct.SubElement(allPointsElement, "Z2")]
            self.currentPolygonSelected = None

        if self.imageViewer.parent.sliderAxis.radioButtonY.isChecked():
            Dfct.SubElement(allPointsElement, "X1").text = str(self.refPosX)
            Dfct.SubElement(allPointsElement, "X2").text = str(self.refPosX)
            Dfct.SubElement(allPointsElement, "Y1").text = "0"
            Dfct.SubElement(allPointsElement, "Y2").text = str(image.getSizeY())
            Dfct.SubElement(allPointsElement, "Z1").text = str(self.refPosY)
            Dfct.SubElement(allPointsElement, "Z2").text = str(self.refPosY)
            self.currentPointSelected = [Dfct.SubElement(allPointsElement, "X2"), Dfct.SubElement(allPointsElement, "Z2")]
            self.currentPolygonSelected = None

        if self.imageViewer.parent.sliderAxis.radioButtonZ.isChecked():
            Dfct.SubElement(allPointsElement, "X1").text = str(self.refPosX)
            Dfct.SubElement(allPointsElement, "X2").text = str(self.refPosX)
            Dfct.SubElement(allPointsElement, "Y1").text = str(self.refPosY)
            Dfct.SubElement(allPointsElement, "Y2").text = str(self.refPosY)
            Dfct.SubElement(allPointsElement, "Z1").text = "0"
            Dfct.SubElement(allPointsElement, "Z2").text = str(image.getSizeZ())
            self.currentPointSelected = [Dfct.SubElement(allPointsElement, "X2"), Dfct.SubElement(allPointsElement, "Y2")]
            self.currentPolygonSelected = None

        self.hasMoving = False

    def verifDisplayZoneRectangle(self,imageViewerStandAlone):

        try:
            if vrb.mainWindow.currentLabel.image.getSizeZ() == 1:
                result = "In"
            else:
                result = "Out"
                sliderAxis = imageViewerStandAlone.sliderAxis
                allPointsElement = Dfct.SubElement(self.selectionRectangle3D, "AllPoints")
                if imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                    value = sliderAxis.sliderX.slider.value()
                    minValue = min(int(float(Dfct.childText(allPointsElement,"X1"))),int(float(Dfct.childText(allPointsElement,"X2"))))
                    maxValue = max(int(float(Dfct.childText(allPointsElement,"X1"))),int(float(Dfct.childText(allPointsElement,"X2"))))
                elif imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                    value = sliderAxis.sliderY.slider.value()
                    minValue = min(int(float(Dfct.childText(allPointsElement,"Y1"))),int(float(Dfct.childText(allPointsElement,"Y2"))))
                    maxValue = max(int(float(Dfct.childText(allPointsElement,"Y1"))),int(float(Dfct.childText(allPointsElement,"Y2"))))
                elif imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                    value = sliderAxis.sliderZ.slider.value()
                    minValue = min(int(float(Dfct.childText(allPointsElement,"Z1"))),int(float(Dfct.childText(allPointsElement,"Z2"))))
                    maxValue = max(int(float(Dfct.childText(allPointsElement,"Z1"))),int(float(Dfct.childText(allPointsElement,"Z2"))))

                if value == minValue or value == maxValue:
                    result = "Equal"
                elif value > minValue and value < maxValue:
                    result = "In"

        except:
            traceback.print_exc(file=sys.stderr)
            result = "Out"

        return result

    def zoomZone(self,ddict):

        if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

            self.resetCurrentPolygonSelected()

            self.zoomZoneRectangle = xmlet.Element('ZoomZone')
            self.refPosX = ddict["Position"][0]
            self.refPosY = ddict["Position"][1]
            DWfct.addPointToPolygon(self.zoomZoneRectangle, QtCore.QPointF(self.refPosX, self.refPosY),allowSamePoint = True)
            DWfct.addPointToPolygon(self.zoomZoneRectangle, QtCore.QPointF(self.refPosX, self.refPosY),allowSamePoint = True)
            DWfct.addPointToPolygon(self.zoomZoneRectangle, QtCore.QPointF(self.refPosX, self.refPosY),allowSamePoint = True)
            modif,point = DWfct.addPointToPolygon(self.zoomZoneRectangle, QtCore.QPointF(self.refPosX, self.refPosY),returnPointElement=True,allowSamePoint = True)
            self.currentPointSelected = point

            self.drawing = True
            self.getRoiImage(changeRoiImage=False)

        if ddict["Button"] == 0 and ddict["Event"] == "Move":

            if self.drawing and self.zoomZoneRectangle is not None:
                if self.currentPointSelected is not None:
                    # Moving this point
                    pointXElement = Dfct.SubElement(self.currentPointSelected, "PointX")
                    pointXElement.text = str(ddict["Position"][0])
                    pointYElement = Dfct.SubElement(self.currentPointSelected, "PointY")
                    pointYElement.text = str(ddict["Position"][1])

                    # In case of the selection, the polygon is a rectangle, so moving a point moves 2 other points
                    numPointSelected = int(Dfct.childText(self.currentPointSelected, 'Num'))
                    for point in Dfct.SubElement(self.zoomZoneRectangle, 'AllPoints'):
                        if int(Dfct.childText(point, 'Num')) == (numPointSelected + 1) % 4:
                            if numPointSelected % 2 == 1:
                                pointXElement = Dfct.SubElement(point, "PointX")
                                pointXElement.text = str(ddict["Position"][0])
                            else:
                                pointYElement = Dfct.SubElement(point, "PointY")
                                pointYElement.text = str(ddict["Position"][1])
                        if int(Dfct.childText(point, 'Num')) == (numPointSelected - 1) % 4:
                            if numPointSelected % 2 == 0:
                                pointXElement = Dfct.SubElement(point, "PointX")
                                pointXElement.text = str(ddict["Position"][0])
                            else:
                                pointYElement = Dfct.SubElement(point, "PointY")
                                pointYElement.text = str(ddict["Position"][1])
                    self.getRoiImage(changeRoiImage=False)

        if ddict["Button"] == 1 and ddict["Event"] == "Release":

            minX, minY, sizeX, sizeY = DWfct.boundingBoxPolygon(self.zoomZoneRectangle)

            if sizeX >10 and sizeY > 10:

                zoomFactor = min(self.mainWindow.currentLabel.image.getSizeX() / max(1, (sizeX)), self.mainWindow.currentLabel.image.getSizeY() / (max(1, sizeY)))
                zoomFactor = min(zoomFactor, self.imageViewer.maxZoomFactor)

                outSizeX = (self.mainWindow.currentLabel.image.getSizeX() / zoomFactor) - sizeX
                outSizeY = (self.mainWindow.currentLabel.image.getSizeY() / zoomFactor) - sizeY

                self.imageViewer.realStartPointX = minX - outSizeX / 2
                self.imageViewer.realStartPointY = minY - outSizeY / 2
                self.imageViewer.zoomFactor = zoomFactor

            self.currentPointSelected = None
            self.currentPolygonSelected = None
            self.refPosX = None
            self.refPosY = None
            self.drawing = False
            self.zoomZoneRectangle = None
            self.getRoiImage()

    def selection(self, ddict):

        distMoveRef = self.distMinSelection
        graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")

        if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

            self.resetCurrentPolygonSelected()

            point, distMove = DWfct.selectPointPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), self.previewRectangle, distMin=self.distMinSelection)
            if distMove < distMoveRef:
                self.currentPointSelected = point
                self.currentPolygonSelected = self.previewRectangle
                distMoveRef = distMove

            if self.calibrationLine is not None:
                point, distMove = DWfct.selectPointPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), self.calibrationLine, distMin=self.distMinSelection)
                if distMove < distMoveRef:
                    self.currentPointSelected = point
                    self.currentPolygonSelected = self.calibrationLine
                    distMoveRef = distMove

            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")
            point, distMove = DWfct.selectPointPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), roiElement, distMin=self.distMinSelection)
            if distMove < distMoveRef:
                self.currentPointSelected = point
                self.currentPolygonSelected = roiElement
                distMoveRef = distMove

            allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")
            for child in allLineMeasuresElement:
                if child.tag == "LineMeasure":
                    point, distMove = DWfct.selectPointPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), child, distMin=self.distMinSelection)
                    if distMove < distMoveRef:
                        self.currentPointSelected = point
                        self.currentPolygonSelected = child
                        distMoveRef = distMove

            allAngleElement = Dfct.SubElement(graphicXmlElement, "AllAngles")
            for child in allAngleElement:
                if child.tag == "Angle":
                    point, distMove = DWfct.selectPointPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), child, distMin=self.distMinSelection)
                    if distMove < distMoveRef:
                        self.currentPointSelected = point
                        self.currentPolygonSelected = child
                        distMoveRef = distMove

            elements = [Dfct.SubElement(graphicXmlElement, "AllAddLabels"),Dfct.SubElement(graphicXmlElement, "AllSplitLabels"),
                        Dfct.SubElement(graphicXmlElement, "AllMergeLabels"),Dfct.SubElement(graphicXmlElement, "AllDeleteLabels"),
                        Dfct.SubElement(graphicXmlElement, "AllKeepLabels"),Dfct.SubElement(graphicXmlElement, "AllSplitLabels3D")]
            for element in elements:
                for child in element:
                    if child.tag == "Label":
                        point, distMove = DWfct.selectPointPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), child, distMin=self.distMinSelection)
                        if distMove < distMoveRef:
                            self.currentPointSelected = point
                            self.currentPolygonSelected = child
                            distMoveRef = distMove

            if self.currentPointSelected is None:
                polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), self.previewRectangle, distMin=self.distMinSelection)
                if distMove < distMoveRef:
                    self.currentPolygonSelected = polygon
                    distMoveRef = distMove

                if self.calibrationLine is not None:
                    polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), self.calibrationLine, distMin=self.distMinSelection)
                    if distMove < distMoveRef:
                        self.currentPolygonSelected = polygon
                        distMoveRef = distMove

                roiElement = Dfct.SubElement(graphicXmlElement, "Roi")
                polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), roiElement, distMin=self.distMinSelection)
                if distMove < distMoveRef:
                    self.currentPolygonSelected = polygon
                    distMoveRef = distMove

                allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")
                for child in allLineMeasuresElement:
                    if child.tag == "LineMeasure":
                        polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), child, distMin=self.distMinSelection)
                        if distMove < distMoveRef:
                            self.currentPolygonSelected = child
                            distMoveRef = distMove

                allAnglesElement = Dfct.SubElement(graphicXmlElement, "AllAngles")
                for child in allAnglesElement:
                    if child.tag == "Angle":
                        polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), child, distMin=self.distMinSelection)
                        if distMove < distMoveRef:
                            self.currentPolygonSelected = child
                            distMoveRef = distMove


                elements = [Dfct.SubElement(graphicXmlElement, "AllAddLabels"), Dfct.SubElement(graphicXmlElement, "AllSplitLabels"),
                            Dfct.SubElement(graphicXmlElement, "AllMergeLabels"), Dfct.SubElement(graphicXmlElement, "AllDeleteLabels"),
                            Dfct.SubElement(graphicXmlElement, "AllKeepLabels"),Dfct.SubElement(graphicXmlElement, "AllSplitLabels3D")]
                for element in elements:
                    for child in element:
                        if child.tag == "Label":
                            polygon, distMove = DWfct.selectPolygon(self.imageViewer, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]), child, distMin=self.distMinSelection)
                            if distMove < distMoveRef:
                                self.currentPolygonSelected = child
                                distMoveRef = distMove

            if self.currentPolygonSelected != None:
                self.refPosX = ddict["Position"][0]
                self.refPosY = ddict["Position"][1]
                selectionElement = Dfct.SubElement(self.currentPolygonSelected, "Selection")
                selectionElement.text = "True"
            else:
                self.imageViewer.standAlone = True
                self.imageViewer.viewport().setCursor(Qt.ClosedHandCursor)

            self.getRoiImage(changeRoiImage=False)

        if ddict["Button"] == 0 and ddict["Event"] == "Move":

            if self.currentPointSelected is not None:
                # Moving this point
                pointXElement = Dfct.SubElement(self.currentPointSelected, "PointX")
                pointXElement.text = str(ddict["Position"][0])
                pointYElement = Dfct.SubElement(self.currentPointSelected, "PointY")
                pointYElement.text = str(ddict["Position"][1])

                if self.currentPolygonSelected == self.previewRectangle:
                    # In case of the preview, the polygon is a rectangle, so moving a point moves 2 other points
                    numPointSelected = int(Dfct.childText(self.currentPointSelected, 'Num'))
                    for point in Dfct.SubElement(self.previewRectangle, 'AllPoints'):
                        if int(Dfct.childText(point, 'Num')) == (numPointSelected + 1) % 4:
                            if numPointSelected % 2 == 1:
                                pointXElement = Dfct.SubElement(point, "PointX")
                                pointXElement.text = str(ddict["Position"][0])
                            else:
                                pointYElement = Dfct.SubElement(point, "PointY")
                                pointYElement.text = str(ddict["Position"][1])
                        if int(Dfct.childText(point, 'Num')) == (numPointSelected - 1) % 4:
                            if numPointSelected % 2 == 0:
                                pointXElement = Dfct.SubElement(point, "PointX")
                                pointXElement.text = str(ddict["Position"][0])
                            else:
                                pointYElement = Dfct.SubElement(point, "PointY")
                                pointYElement.text = str(ddict["Position"][1])
                if self.currentPolygonSelected == self.calibrationLine:
                    self.fillCalibrationLineEdit()

                self.getRoiImage(changeRoiImage=False)

            else:
                # Not moving a point
                if self.currentPolygonSelected is not None and self.refPosX is not None and self.refPosY is not None:
                    # moving a rectangle
                    deltaX = ddict["Position"][0] - self.refPosX
                    deltaY = ddict["Position"][1] - self.refPosY
                    allPointsElement = Dfct.SubElement(self.currentPolygonSelected, "AllPoints")
                    for child in allPointsElement:
                        if child.tag == "Point":
                            pointXElement = Dfct.SubElement(child, "PointX")
                            deltaX = min(deltaX, self.imageViewer.image[0].getSizeX() - float(pointXElement.text))
                            deltaX = max(deltaX, -float(pointXElement.text))
                            pointYElement = Dfct.SubElement(child, "PointY")
                            deltaY = min(deltaY, self.imageViewer.image[0].getSizeY() - float(pointYElement.text))
                            deltaY = max(deltaY, -float(pointYElement.text))

                    for child in allPointsElement:
                        if child.tag == "Point":
                            pointXElement = Dfct.SubElement(child, "PointX")
                            pointXElement.text = str(float(pointXElement.text) + deltaX)
                            pointYElement = Dfct.SubElement(child, "PointY")
                            pointYElement.text = str(float(pointYElement.text) + deltaY)
                    self.refPosX = ddict["Position"][0]
                    self.refPosY = ddict["Position"][1]

                    self.getRoiImage(changeRoiImage=False)

            if self.currentPolygonSelected is not None and self.refPosX is not None and self.refPosY is not None:
                for lineProfile in self.allLineProfiles:
                    if lineProfile.lineElement == self.currentPolygonSelected:
                        self.drawLineProfile(lineProfile)

        if ddict["Button"] == 1 and ddict["Event"] == "Release":
            self.currentPointSelected = None
            #self.currentPolygonSelected = None
            self.refPosX = None
            self.refPosY = None
            self.imageViewer.standAlone = False
            if self.previewMode:
                self.SignalComputePreview.emit()

    def moveImage(self, ddict):

        if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

            self.imageViewer.standAlone = True
            self.imageViewer.viewport().setCursor(Qt.ClosedHandCursor)

        if ddict["Button"] == 1 and ddict["Event"] == "Release":

            self.imageViewer.standAlone = False

    def zoomPlus(self,ddict):

        if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

            self.imageViewer.wheelEvent(None,params=[ddict["Position"][0],ddict["Position"][1],1])

    def zoomMinus(self, ddict):

        if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

            self.imageViewer.wheelEvent(None, params=[ddict["Position"][0], ddict["Position"][1], -1])


    def fillCalibrationLineEdit(self):

        allPointsElement = Dfct.SubElement(self.calibrationLine, "AllPoints")
        for child in allPointsElement:
            if child.tag == "Point":
                if Dfct.childText(child, "Num") == str(0):
                    p1x, p1y = float(Dfct.childText(child, "PointX")), float(Dfct.childText(child, "PointY"))
                if Dfct.childText(child, "Num") == str(1):
                    p2x, p2y = float(Dfct.childText(child, "PointX")), float(Dfct.childText(child, "PointY"))
        try:
            distance = ((p1x - p2x) ** 2 + (p1y - p2y) ** 2) ** 0.5
        except:
            distance = 1
        distance = str(int(round(distance)))
        self.mainWindow.groupMenu.groupCalibration.widgetCalibration.tabWidgetCalibration.currentWidget().groupBoxDefineCalibration.groupBoxSquarePixels.lineEditSquarePixels.setText(distance)

    def resetCurrentPolygonSelected(self):
        if self.currentPolygonSelected != None:
            selectionElement = Dfct.SubElement(self.currentPolygonSelected, "Selection")
            selectionElement.text = "False"
            self.currentPolygonSelected = None

    def suppressElement(self,keyValue):

        if keyValue == 16777223:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")
            if self.currentPolygonSelected == roiElement:
                graphicXmlElement.remove(roiElement)
            allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")
            for child in allLineMeasuresElement:
                if self.currentPolygonSelected == child:
                    allLineMeasuresElement.remove(child)
            allAnglesElement = Dfct.SubElement(graphicXmlElement, "AllAngles")
            for child in allAnglesElement:
                if self.currentPolygonSelected == child:
                    allAnglesElement.remove(child)
            elements = [Dfct.SubElement(graphicXmlElement, "AllAddLabels"), Dfct.SubElement(graphicXmlElement, "AllSplitLabels"),
                        Dfct.SubElement(graphicXmlElement, "AllMergeLabels"), Dfct.SubElement(graphicXmlElement, "AllDeleteLabels"),
                        Dfct.SubElement(graphicXmlElement, "AllKeepLabels"), Dfct.SubElement(graphicXmlElement, "AllSplitLabels3D")]
            for element in elements:
                for child in element:
                    if self.currentPolygonSelected == child:
                        element.remove(child)

            self.getRoiImage(changeRoiImage=False)

            self.currentPointSelected = None
            self.currentPolygonSelected = None
            self.currentLineMeasure = None
            self.drawing = False
            self.refPosX = None
            self.refPosY = None

    def deleteAllLineMeasure(self):

        if self.mainWindow.currentXmlElement is not None:
            graphicXmlElement = Dfct.SubElement(self.mainWindow.currentXmlElement, "GraphicXmlElement")
            roiElement = Dfct.SubElement(graphicXmlElement, "Roi")
            graphicXmlElement.remove(roiElement)
            allLineMeasuresElement = Dfct.SubElement(graphicXmlElement, "AllLineMeasures")
            Dfct.clearElement(allLineMeasuresElement)
            allAnglesElement = Dfct.SubElement(graphicXmlElement, "AllAngles")
            Dfct.clearElement(allAnglesElement)

            elements = [Dfct.SubElement(graphicXmlElement, "AllAddLabels"), Dfct.SubElement(graphicXmlElement, "AllSplitLabels"),
                        Dfct.SubElement(graphicXmlElement, "AllMergeLabels"), Dfct.SubElement(graphicXmlElement, "AllDeleteLabels"),
                        Dfct.SubElement(graphicXmlElement, "AllKeepLabels"), Dfct.SubElement(graphicXmlElement, "AllSplitLabels3D")]
            for element in elements:
                Dfct.clearElement(element)

            self.getRoiImage(changeRoiImage=False)

            self.currentPointSelected = None
            self.currentPolygonSelected = None
            self.currentLineMeasure = None
            self.drawing = False
            self.refPosX = None
            self.refPosY = None