import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util

import processFunction.AdvancedMorphology as PfctAdvMorpho
import processFunction.Arithmetic as PfctArithm
import processFunction.BasicMorphology as PfctBasicMorpho
import processFunction.Binarization as PfctBin
import processFunction.Classification as PfctClassif
import processFunction.ColorOperations as PfctColor
import processFunction.FeatureDetection as PfctFeatureDetection
import processFunction.Filtering as PfctFiltering
import processFunction.GeometricTransformation as PfctGeom
import processFunction.GlobalMeasure as PfctGlbmsr
import processFunction.IntensityTransformation as PfctIntensity
import processFunction.ShapeAnalysis as PfctShapeAnalysis
import processFunction.ShapeSegmentation as PfctShapeSegmentation
import processFunction.Utility as PfctUtil
import processFunction.LogicalOperations as PfctLogic
import processFunction.Statistics as PfctStats
import processFunction.MachineLearning as PfctMachineLearning
import processFunction.Registration as PfctRegistration
import processFunction._ProcessFunction as PfctPfct

dictFolderNames = {}
dictFolderNames['AdvMorphology'] = 'Advanced Morphology'
dictFolderNames['BasicMorphology'] = 'Basic Morphology'
dictFolderNames['ColorOperation'] = 'Color Operation'
dictFolderNames['FeatureDetection'] = 'Feature Detection'
dictFolderNames['Geometric'] = 'Geometric Transformation'
dictFolderNames['GlobalMeasure'] = 'Global Measure'
dictFolderNames['IntensityTransformation'] = 'Intensity Transformation'
dictFolderNames['MachineLearning'] = 'Machine Learning'
dictFolderNames['Registration'] = 'Registration'
dictFolderNames['ShapeAnalysis'] = 'Shape Analysis'
dictFolderNames['ShapeSegmentation'] = 'Shape Segmentation'

nativeModules = ['Advanced Morphology','Arithmetic','Basic Morphology','Binarization','Classification','Color Operation','Feature Detection','Filtering',
                 'Geometric Transformation','Global Measure','Intensity Transformation','Logical','Macro','Machine Learning', 'Registration', 'Shape Analysis','Shape Segmentation','Statistics','Utility']

# Dictionary doing the link between the name in MHO and the actual function to call
dictAllFunctions = {}

##################
# Adv Morphology #
##################
dictAllFunctions['BinaryReconstruction2dImg'] = PfctAdvMorpho.binaryReconstruction2dImg
dictAllFunctions['BinaryReconstruction3dImg'] = PfctAdvMorpho.binaryReconstruction3dImg
dictAllFunctions['ConnectedComponent2dImg'] = PfctAdvMorpho.connectedComponent2dImg
dictAllFunctions['ConnectedComponent3dImg'] = PfctAdvMorpho.connectedComponent3dImg
dictAllFunctions['DilateLocalExtrema2dImg'] = PfctAdvMorpho.dilateLocalExtrema2dImg
dictAllFunctions['DilateLocalExtrema3dImg'] = PfctAdvMorpho.dilateLocalExtrema3dImg
dictAllFunctions['FillHole2dImg'] = PfctAdvMorpho.fillHole2dImg
dictAllFunctions['FillHole3dImg'] = PfctAdvMorpho.fillHole3dImg
dictAllFunctions['GenericSeededDistanceMap2dImg'] = PfctAdvMorpho.genericSeededDistanceMap2dImg
dictAllFunctions['GenericSeededDistanceMap3dImg'] = PfctAdvMorpho.genericSeededDistanceMap3dImg
dictAllFunctions['GreyReconstruction2dImg'] = PfctAdvMorpho.greyReconstruction2dImg
dictAllFunctions['GreyReconstruction3dImg'] = PfctAdvMorpho.greyReconstruction3dImg
dictAllFunctions['KeepBigShape2dImg'] = PfctAdvMorpho.keepBigShape2dImg
dictAllFunctions['KeepBigShape3dImg'] = PfctAdvMorpho.keepBigShape3dImg
dictAllFunctions['LocalExtrema2dImg'] = PfctAdvMorpho.localExtrema2dImg
dictAllFunctions['LocalExtrema3dImg'] = PfctAdvMorpho.localExtrema3dImg
dictAllFunctions['ExtremaPropagation2dImg'] = PfctAdvMorpho.extremaPropagation2dImg
dictAllFunctions['ExtremaPropagation3dImg'] = PfctAdvMorpho.extremaPropagation3dImg
dictAllFunctions['RemoveBorder2dImg'] = PfctAdvMorpho.removeBorder2dImg
dictAllFunctions['RemoveBorder3dImg'] = PfctAdvMorpho.removeBorder3dImg
dictAllFunctions['RemoveSmallShape2dImg'] = PfctAdvMorpho.removeSmallShape2dImg
dictAllFunctions['RemoveSmallShape3dImg'] = PfctAdvMorpho.removeSmallShape3dImg
dictAllFunctions['SeededDistanceMap2dImg'] = PfctAdvMorpho.seededDistanceMap2dImg
dictAllFunctions['SeededDistanceMap3dImg'] = PfctAdvMorpho.seededDistanceMap3dImg
dictAllFunctions['SeededWatershed2dImg'] = PfctAdvMorpho.seededWatershed2dImg
dictAllFunctions['SeededWatershed3dImg'] = PfctAdvMorpho.seededWatershed3dImg
dictAllFunctions['WatershedBinarySeparation2dImg'] = PfctAdvMorpho.watershedBinarySeparation2dImg
dictAllFunctions['WatershedBinarySeparation3dImg'] = PfctAdvMorpho.watershedBinarySeparation3dImg
dictAllFunctions['AdaptiveBinaryWatershed2dImg'] = PfctAdvMorpho.adaptiveBinaryWatershed2dImg
dictAllFunctions['AdaptiveBinaryWatershed3dImg'] = PfctAdvMorpho.adaptiveBinaryWatershed3dImg
dictAllFunctions['WatershedGreySeparation2dImg'] = PfctAdvMorpho.watershedGreySeparation2dImg
dictAllFunctions['WatershedGreySeparation3dImg'] = PfctAdvMorpho.watershedGreySeparation3dImg
dictAllFunctions['RidgeLine2dImg'] = PfctAdvMorpho.ridgeLine2dImg
dictAllFunctions['RidgeLine3dImg'] = PfctAdvMorpho.ridgeLine3dImg
dictAllFunctions['SuperPixels2dImg'] = PfctAdvMorpho.superPixels2dImg
dictAllFunctions['SuperVoxels3dImg'] = PfctAdvMorpho.superVoxels3dImg
dictAllFunctions['DilateLabel2dImg'] = PfctAdvMorpho.dilateLabel2dImg
dictAllFunctions['DilateLabel3dImg'] = PfctAdvMorpho.dilateLabel3dImg


##################
#   Arithmetic   #
##################
dictAllFunctions['AbsImg'] = PfctArithm.absImg
dictAllFunctions['AddImgImg'] = PfctArithm.addImgImg
dictAllFunctions['AddScalarImg'] = PfctArithm.addScalarImg
dictAllFunctions['BlendImgImg'] = PfctArithm.blendImgImg
dictAllFunctions['BoundImg'] = PfctArithm.boundImg
dictAllFunctions['CartesianToPolarImg'] = PfctArithm.cartesianToPolarImg
dictAllFunctions['DivideImgImg'] = PfctArithm.divideImgImg
dictAllFunctions['Formula2dImg'] = PfctArithm.formula2dImg
dictAllFunctions['Formula3dImg'] = PfctArithm.formula3dImg
dictAllFunctions['GenericAddImgImg'] = PfctArithm.genericAddImgImg
dictAllFunctions['GenericMultiplyImgImg'] = PfctArithm.genericMultiplyImgImg
dictAllFunctions['GenericDivideImgImg'] = PfctArithm.genericDivideImgImg
dictAllFunctions['GenericSubtractImgImg'] = PfctArithm.genericSubtractImgImg
dictAllFunctions['L1Norm'] = PfctArithm.l1Norm
dictAllFunctions['L2Norm'] = PfctArithm.l2Norm
dictAllFunctions['LinearCombineImgImg'] = PfctArithm.linearCombineImgImg
dictAllFunctions['MaxImgImg'] = PfctArithm.maxImgImg
dictAllFunctions['MinImgImg'] = PfctArithm.minImgImg
dictAllFunctions['MultiplyAddScalarImg'] = PfctArithm.multiplyAddScalarImg
dictAllFunctions['MultiplyImgImg'] = PfctArithm.multiplyImgImg
dictAllFunctions['MultiplyScalarImg'] = PfctArithm.multiplyScalarImg
dictAllFunctions['PolarToCartesianImg'] = PfctArithm.polarToCartesianImg
dictAllFunctions['RoundImg'] = PfctArithm.roundImg
dictAllFunctions['SqrtImg'] = PfctArithm.sqrtImg
dictAllFunctions['SquareImg'] = PfctArithm.squareImg
dictAllFunctions['SubtractImgImg'] = PfctArithm.subtractImgImg
dictAllFunctions['SubtractScalarImg'] = PfctArithm.subtractScalarImg


##################
#  Binarization  #
##################
dictAllFunctions['AdaptiveThreshold2dImg'] = PfctBin.adaptiveThreshold2dImg
dictAllFunctions['AdaptiveThreshold3dImg'] = PfctBin.adaptiveThreshold3dImg
dictAllFunctions['AdaptiveThresholdMean2dImg'] = PfctBin.adaptiveThresholdMean2dImg
dictAllFunctions['AdaptiveThresholdMean3dImg'] = PfctBin.adaptiveThresholdMean3dImg
dictAllFunctions['HysteresisThreshold2dImg'] = PfctBin.hysteresisThreshold2dImg
dictAllFunctions['HysteresisThreshold3dImg'] = PfctBin.hysteresisThreshold3dImg
# dictAllFunctions['IsoDataThreshold'] = PfctBin.isoDataThreshold
dictAllFunctions['IsoDataThresholdImg'] = PfctBin.isoDataThresholdImg
# dictAllFunctions['KapurThreshold'] = PfctBin.kapurThreshold
dictAllFunctions['KapurThresholdImg'] = PfctBin.kapurThresholdImg
# dictAllFunctions['KittlerThreshold'] = PfctBin.kittlerThreshold
dictAllFunctions['KittlerThresholdImg'] = PfctBin.kittlerThresholdImg
# dictAllFunctions['OtsuThreshold'] = PfctBin.otsuThreshold
dictAllFunctions['OtsuThresholdImg'] = PfctBin.otsuThresholdImg
dictAllFunctions['ThresholdImg'] = PfctBin.thresholdImg
dictAllFunctions['TopHat2d'] = PfctBin.topHat2d
dictAllFunctions['TopHat3d'] = PfctBin.topHat3d


####################
#  Classification  #
####################
dictAllFunctions['KernelKMeansImg'] = PfctClassif.kernelKMeansImg
dictAllFunctions['KernelKMeansAssignImg'] = PfctClassif.kernelKMeansAssignImg
dictAllFunctions['KMeansImg'] = PfctClassif.kMeansImg
dictAllFunctions['KMeansAssignImg'] = PfctClassif.kMeansAssignImg
dictAllFunctions['KMeansComputeCenters'] = PfctClassif.kMeansComputeCenters
dictAllFunctions['KMeansPosterizeImg'] = PfctClassif.kMeansPosterizeImg

##################
#    Color OP    #
##################
dictAllFunctions['LightnessImg'] = PfctColor.lightnessImg
dictAllFunctions['ColorConvertImg'] = PfctColor.colorConvertImg
dictAllFunctions['SplitChannelsImg'] = PfctColor.splitChannelsImg
dictAllFunctions['MergeChannelsImg'] = PfctColor.mergeChannelsImg
dictAllFunctions['SplitByPCAImg'] = PfctColor.splitByPCAImg
dictAllFunctions['AppendColorChannelImg'] = PfctColor.appendColorChannelImg
dictAllFunctions['ExtractChannel'] = PfctColor.extractChannel

#####################
# Feature Detection #
#####################
dictAllFunctions['CannyEdges2dImg'] = PfctFeatureDetection.cannyEdges2dImg
dictAllFunctions['CannySurfaces3dImg'] = PfctFeatureDetection.cannySurfaces3dImg
dictAllFunctions['ExtractLocalExtrema2d'] = PfctFeatureDetection.extractLocalExtrema2d
dictAllFunctions['ExtractLocalExtrema3d'] = PfctFeatureDetection.extractLocalExtrema3d
dictAllFunctions['HarrisCorner2d'] = PfctFeatureDetection.harrisCorner2d
dictAllFunctions['HarrisCorner3d'] = PfctFeatureDetection.harrisCorner3d
dictAllFunctions['HarrisCorner2dImg'] = PfctFeatureDetection.harrisCorner2dImg
dictAllFunctions['HarrisCorner3dImg'] = PfctFeatureDetection.harrisCorner3dImg
dictAllFunctions['HoughCircles2d'] = PfctFeatureDetection.houghCircles2d
dictAllFunctions['HoughSpheres3d'] = PfctFeatureDetection.houghSpheres3d
dictAllFunctions['HoughSpheres3dLabelImg'] = PfctFeatureDetection.houghSpheres3dLabelImg
# dictAllFunctions['HoughCircles2dImg'] = PfctFeatureDetection.houghCircles2dImg
# dictAllFunctions['HoughCircles2dImg'] = PfctFeatureDetection.houghCircles2dImg
# dictAllFunctions['HoughCirclesPhaseCoded2dImg'] = PfctFeatureDetection.houghCirclesPhaseCoded2dImg
dictAllFunctions['HoughLines2d'] = PfctFeatureDetection.houghLines2d
dictAllFunctions['HoughLines2dImg'] = PfctFeatureDetection.houghLines2dImg

##################
#    Filtering   #
##################
dictAllFunctions['AnisotropicDiffusion2dImg'] = PfctFiltering.anisotropicDiffusion2dImg
dictAllFunctions['AnisotropicDiffusion3dImg'] = PfctFiltering.anisotropicDiffusion3dImg
dictAllFunctions['Bilateral2dImg'] = PfctFiltering.bilateral2dImg
dictAllFunctions['Bilateral3dImg'] = PfctFiltering.bilateral3dImg
dictAllFunctions['Convolution2dImg'] = PfctFiltering.convolution2dImg
dictAllFunctions['DespeckleFilter2dImg'] = PfctFiltering.despeckleFilter2dImg
dictAllFunctions['FrequencyFiltering2dImg'] = PfctFiltering.frequencyFiltering2dImg
dictAllFunctions['FrequencyFiltering3dImg'] = PfctFiltering.frequencyFiltering3dImg
dictAllFunctions['GaussianGradient2dImg'] = PfctFiltering.gaussianGradient2dImg
dictAllFunctions['GaussianGradient3dImg'] = PfctFiltering.gaussianGradient3dImg
dictAllFunctions['GaussianHessian2dImg'] = PfctFiltering.gaussianHessian2dImg
dictAllFunctions['GaussianHessian3dImg'] = PfctFiltering.gaussianHessian3dImg
dictAllFunctions['GaussianSmoothing2dImg'] = PfctFiltering.gaussianSmoothing2dImg
dictAllFunctions['GaussianSmoothing3dImg'] = PfctFiltering.gaussianSmoothing3dImg
dictAllFunctions['HighPass2dImg'] = PfctFiltering.highPass2dImg
dictAllFunctions['HighPass3dImg'] = PfctFiltering.highPass3dImg
dictAllFunctions['LaplacianDoG2dImg'] = PfctFiltering.laplacianDoG2dImg
dictAllFunctions['LaplacianDoG3dImg'] = PfctFiltering.laplacianDoG3dImg
dictAllFunctions['LaplacianDoGDeblur2dImg'] = PfctFiltering.laplacianDoGDeblur2dImg
dictAllFunctions['LaplacianDoGDeblur3dImg'] = PfctFiltering.laplacianDoGDeblur3dImg
dictAllFunctions['MeanSmoothing2dImg'] = PfctFiltering.meanSmoothing2dImg
dictAllFunctions['MeanSmoothing3dImg'] = PfctFiltering.meanSmoothing3dImg
dictAllFunctions['Median2dImg'] = PfctFiltering.median2dImg
dictAllFunctions['Median3dImg'] = PfctFiltering.median3dImg
# dictAllFunctions['MultiscaleVesselEnhancement2dImg'] = PfctFiltering.multiscaleVesselEnhancement2dImg
# dictAllFunctions['MultiscaleVesselEnhancement3dImg'] = PfctFiltering.multiscaleVesselEnhancement3dImg
dictAllFunctions['NormalizedCrossCorrelation2dImg'] = PfctFiltering.normalizedCrossCorrelation2dImg
dictAllFunctions['NormalizedCrossCorrelation3dImg'] = PfctFiltering.normalizedCrossCorrelation3dImg
dictAllFunctions['PatchBasedBilateral2dImg'] = PfctFiltering.patchBasedBilateral2dImg
dictAllFunctions['PatchBasedBilateral3dImg'] = PfctFiltering.patchBasedBilateral3dImg
dictAllFunctions['PearsonColocalization2dImg'] = PfctFiltering.pearsonColocalization2dImg
dictAllFunctions['PearsonColocalization3dImg'] = PfctFiltering.pearsonColocalization3dImg
dictAllFunctions['RichardsonLucyDeblur2dImg'] = PfctFiltering.richardsonLucyDeblur2dImg
dictAllFunctions['RichardsonLucyDeblur3dImg'] = PfctFiltering.richardsonLucyDeblur3dImg
dictAllFunctions['SeparatedBilateral2dImg'] = PfctFiltering.separatedBilateral2dImg
dictAllFunctions['SeparatedBilateral3dImg'] = PfctFiltering.separatedBilateral3dImg
dictAllFunctions['SobelGradient2dImg'] = PfctFiltering.sobelGradient2dImg
dictAllFunctions['SobelGradient3dImg'] = PfctFiltering.sobelGradient3dImg
dictAllFunctions['UnsharpMask2dImg'] = PfctFiltering.unsharpMask2dImg
dictAllFunctions['UnsharpMask3dImg'] = PfctFiltering.unsharpMask3dImg
dictAllFunctions['ZStackFocusMaximumImg'] = PfctFiltering.zStackFocusMaximumImg
dictAllFunctions['ZStackFocusPonderationImg'] = PfctFiltering.zStackFocusPonderationImg
dictAllFunctions['FastCrossCorrelation2dImg'] = PfctFiltering.fastCrossCorrelation2dImg
dictAllFunctions['FastCrossCorrelation3dImg'] = PfctFiltering.fastCrossCorrelation3dImg
dictAllFunctions['DicIntegration2dImg'] = PfctFiltering.dicIntegration2dImg
dictAllFunctions['DicPhaseRetrieval2dImg'] = PfctFiltering.dicPhaseRetrieval2dImg
dictAllFunctions['VSNR2dImg'] = PfctFiltering.vsnr2dImg

######################
#  Basic Morphology  #
######################
dictAllFunctions['Boundary2dImg'] = PfctBasicMorpho.boundary2dImg
dictAllFunctions['Boundary3dImg'] = PfctBasicMorpho.boundary3dImg
dictAllFunctions['Closing2dImg'] = PfctBasicMorpho.closing2dImg
dictAllFunctions['Closing3dImg'] = PfctBasicMorpho.closing3dImg
dictAllFunctions['Dilate2dImg'] = PfctBasicMorpho.dilate2dImg
dictAllFunctions['Dilate3dImg'] = PfctBasicMorpho.dilate3dImg
dictAllFunctions['DistanceMap2dImg'] = PfctBasicMorpho.distanceMap2dImg
dictAllFunctions['DistanceMap3dImg'] = PfctBasicMorpho.distanceMap3dImg
dictAllFunctions['Erode2dImg'] = PfctBasicMorpho.erode2dImg
dictAllFunctions['Erode3dImg'] = PfctBasicMorpho.erode3dImg
dictAllFunctions['MorphoGradient2dImg'] = PfctBasicMorpho.morphoGradient2dImg
dictAllFunctions['MorphoGradient3dImg'] = PfctBasicMorpho.morphoGradient3dImg
dictAllFunctions['Opening2dImg'] = PfctBasicMorpho.opening2dImg
dictAllFunctions['Opening3dImg'] = PfctBasicMorpho.opening3dImg
dictAllFunctions['UnionLinearClosing2dImg'] = PfctBasicMorpho.unionLinearClosing2dImg
dictAllFunctions['UnionLinearClosing3dImg'] = PfctBasicMorpho.unionLinearClosing3dImg
dictAllFunctions['UnionLinearOpening2dImg'] = PfctBasicMorpho.unionLinearOpening2dImg
dictAllFunctions['UnionLinearOpening3dImg'] = PfctBasicMorpho.unionLinearOpening3dImg
dictAllFunctions['Skeleton2dImg'] = PfctBasicMorpho.skeleton2dImg
dictAllFunctions['Skeleton3dImg'] = PfctBasicMorpho.skeleton3dImg
dictAllFunctions['Pruning2dImg'] = PfctBasicMorpho.pruning2dImg
dictAllFunctions['Pruning3dImg'] = PfctBasicMorpho.pruning3dImg
dictAllFunctions['AddMarkerImg'] = PfctBasicMorpho.addMarkerImg
dictAllFunctions['CheckMultiphasedNeighourhood2dImg'] = PfctBasicMorpho.checkMultiphasedNeighourhood2dImg
dictAllFunctions['CheckMultiphasedNeighourhood3dImg'] = PfctBasicMorpho.checkMultiphasedNeighourhood3dImg

###################
#    Geometric    #
###################
dictAllFunctions['Zoom2dImg'] = PfctGeom.zoom2dImg
dictAllFunctions['Zoom3dImg'] = PfctGeom.zoom3dImg
dictAllFunctions['FlipXImg'] = PfctGeom.flipXImg
dictAllFunctions['FlipYImg'] = PfctGeom.flipYImg
dictAllFunctions['FlipZImg'] = PfctGeom.flipZImg
dictAllFunctions['Translation2dImg'] = PfctGeom.translation2dImg
dictAllFunctions['Translation3dImg'] = PfctGeom.translation3dImg
dictAllFunctions['Rotation2dImg'] = PfctGeom.rotation2dImg
dictAllFunctions['Rotation3dImg'] = PfctGeom.rotation3dImg
dictAllFunctions['UnrollRingImg'] = PfctGeom.unrollRingImg
dictAllFunctions['UnrollCylinderImg'] = PfctGeom.unrollCylinderImg
dictAllFunctions['ElasticWarp2dImg'] = PfctGeom.elasticWarp2dImg
dictAllFunctions['Warp2dImg'] = PfctGeom.warp2dImg


###################
#  Global Measure #
###################
dictAllFunctions['GaussianNoiseMsr'] = PfctGlbmsr.gaussianNoiseMsr
dictAllFunctions['GlobalEntropyMsr2d'] = PfctGlbmsr.globalEntropyMsr2d
dictAllFunctions['HistogramMsr2d'] = PfctGlbmsr.histogramMsr2d
dictAllFunctions['HistogramMsr3d'] = PfctGlbmsr.histogramMsr3d
dictAllFunctions['HistogramMaskMsr2d'] = PfctGlbmsr.histogramMaskMsr2d
dictAllFunctions['HistogramMaskMsr3d'] = PfctGlbmsr.histogramMaskMsr3d
dictAllFunctions['ParaboloidImgFit2d'] = PfctGlbmsr.paraboloidImgFit2d
dictAllFunctions['PearsonCorrelationCoefficient2d'] = PfctGlbmsr.pearsonCorrelationCoefficient2d
dictAllFunctions['PearsonCorrelationCoefficient3d'] = PfctGlbmsr.pearsonCorrelationCoefficient3d
dictAllFunctions['SimilarityMsr'] = PfctGlbmsr.similarityMsr
dictAllFunctions['StatsMsr2d'] = PfctGlbmsr.statsMsr2d
dictAllFunctions['StatsMsr3d'] = PfctGlbmsr.statsMsr3d
dictAllFunctions['StatsMaskMsr2d'] = PfctGlbmsr.statsMaskMsr2d
dictAllFunctions['StatsMaskMsr3d'] = PfctGlbmsr.statsMaskMsr3d
dictAllFunctions['XProjection2d'] = PfctGlbmsr.xProjection2d
dictAllFunctions['YProjection2d'] = PfctGlbmsr.yProjection2d
dictAllFunctions['ZProjectionImg'] = PfctGlbmsr.zProjectionImg
dictAllFunctions['LocatePixels2d'] = PfctGlbmsr.locatePixels2d
dictAllFunctions['LocateVoxels3d'] = PfctGlbmsr.locateVoxels3d
dictAllFunctions['LabelHistogram2d'] = PfctGlbmsr.labelHistogram2d
dictAllFunctions['LabelHistogram3d'] = PfctGlbmsr.labelHistogram3d
dictAllFunctions['NormalizedCrossCorrelationMsr2d'] = PfctGlbmsr.normalizedCrossCorrelationMsr2d
dictAllFunctions['NormalizedCrossCorrelationMsr3d'] = PfctGlbmsr.normalizedCrossCorrelationMsr3d
dictAllFunctions['AreaPercent2dMsr'] = PfctGlbmsr.areaPercent2dMsr
dictAllFunctions['VolumePercent3dMsr'] = PfctGlbmsr.volumePercent3dMsr
dictAllFunctions['Counting2dMsr'] = PfctGlbmsr.counting2dMsr
dictAllFunctions['Counting3dMsr'] = PfctGlbmsr.counting3dMsr


###################
#  Intensity Transformation #
###################
dictAllFunctions['BackwardDiscreteFourierTransform2dImg'] = PfctIntensity.backwardDiscreteFourierTransform2dImg
dictAllFunctions['BackwardDiscreteFourierTransform3dImg'] = PfctIntensity.backwardDiscreteFourierTransform3dImg
dictAllFunctions['CompactIndexImg'] = PfctIntensity.compactIndexImg
dictAllFunctions['Equalize2dImg'] = PfctIntensity.equalize2dImg
dictAllFunctions['Equalize3dImg'] = PfctIntensity.equalize3dImg
dictAllFunctions['ForwardDiscreteFourierTransform2dImg'] = PfctIntensity.forwardDiscreteFourierTransform2dImg
dictAllFunctions['ForwardDiscreteFourierTransform3dImg'] = PfctIntensity.forwardDiscreteFourierTransform3dImg
dictAllFunctions['Invert2dImg'] = PfctIntensity.invert2dImg
dictAllFunctions['Invert3dImg'] = PfctIntensity.invert3dImg
dictAllFunctions['MatchHistograms2dImg'] = PfctIntensity.matchHistograms2dImg
dictAllFunctions['MatchHistograms3dImg'] = PfctIntensity.matchHistograms3dImg
dictAllFunctions['MatchStatsImg'] = PfctIntensity.matchStatsImg
dictAllFunctions['NormalizeImg'] = PfctIntensity.normalizeImg
dictAllFunctions['ParaboloidShadingCorrection2dImg'] = PfctIntensity.paraboloidShadingCorrection2dImg
dictAllFunctions['ShadingCorrectionImg'] = PfctIntensity.shadingCorrectionImg
dictAllFunctions['SigmoidNormalizeImg'] = PfctIntensity.sigmoidNormalizeImg
dictAllFunctions['SmartParaboloidShadingCorrection2dImg'] = PfctIntensity.smartParaboloidShadingCorrection2dImg
dictAllFunctions['SmartShadingCorrectionImg'] = PfctIntensity.smartShadingCorrectionImg
dictAllFunctions['StandardizeImg'] = PfctIntensity.standardizeImg
dictAllFunctions['AdaptiveContrastEnhancement2dImg'] = PfctIntensity.adaptiveContrastEnhancement2dImg
dictAllFunctions['AdaptiveContrastEnhancement3dImg'] = PfctIntensity.adaptiveContrastEnhancement3dImg

###################
#  Logical Operations #
###################
dictAllFunctions['BitwiseAndImgImg'] = PfctLogic.bitwiseAndImgImg
dictAllFunctions['BitwiseNandImgImg'] = PfctLogic.bitwiseNandImgImg
dictAllFunctions['BitwiseNorImgImg'] = PfctLogic.bitwiseNorImgImg
dictAllFunctions['LogicalNotImg'] = PfctLogic.logicalNotImg
dictAllFunctions['BitwiseNxorImgImg'] = PfctLogic.bitwiseNxorImgImg
dictAllFunctions['BitwiseOrImgImg'] = PfctLogic.bitwiseOrImgImg
dictAllFunctions['BitwiseExclusiveOrImgImg'] = PfctLogic.bitwiseExclusiveOrImgImg
dictAllFunctions['DifferenceImgImg'] = PfctLogic.differenceImgImg
# dictAllFunctions['BitwiseNot'] = PfctIntensity.bitwiseNot
dictAllFunctions['MaskImg'] = PfctLogic.maskImg
dictAllFunctions['MaskImgImg'] = PfctLogic.maskImgImg

###################
#  Registration   #
###################
dictAllFunctions['DeepFlow2dImg'] = PfctRegistration.deepFlow2dImg
dictAllFunctions['ExtractVectorialField2d'] = PfctRegistration.extractVectorialField2d
dictAllFunctions['GreySignedFeatures2dRegistrationImg'] = PfctRegistration.greySignedFeatures2dRegistrationImg
dictAllFunctions['StackRegistrationImg'] = PfctRegistration.stackRegistrationImg
dictAllFunctions['StackRegistrationFromTransformationImg'] = PfctRegistration.stackRegistrationFromTransformationImg

#####################
#  Statistics #
#####################
dictAllFunctions['Kurtosis2dImg'] = PfctStats.kurtosis2dImg
dictAllFunctions['Kurtosis3dImg'] = PfctStats.kurtosis3dImg
dictAllFunctions['LocalEnergy2dImg'] = PfctStats.localEnergy2dImg
dictAllFunctions['LocalEnergy3dImg'] = PfctStats.localEnergy3dImg
dictAllFunctions['LocalEntropy2dImg'] = PfctStats.localEntropy2dImg
dictAllFunctions['LocalEntropy3dImg'] = PfctStats.localEntropy3dImg
dictAllFunctions['LocalHistogramModule2dImg'] = PfctStats.localHistogramModule2dImg
dictAllFunctions['LocalHistogramModule3dImg'] = PfctStats.localHistogramModule3dImg
dictAllFunctions['Skewness2dImg'] = PfctStats.skewness2dImg
dictAllFunctions['Skewness3dImg'] = PfctStats.skewness3dImg
dictAllFunctions['Variance2dImg'] = PfctStats.variance2dImg
dictAllFunctions['Variance3dImg'] = PfctStats.variance3dImg


###################
#  Shape analysis #
###################
dictAllFunctions['LabelAnalysis2d'] = PfctShapeAnalysis.labelAnalysis2d
dictAllFunctions['LabelAnalysis3d'] = PfctShapeAnalysis.labelAnalysis3d
dictAllFunctions['ShapeAnalysis2d'] = PfctShapeAnalysis.shapeAnalysis2d
dictAllFunctions['ShapeAnalysis3d'] = PfctShapeAnalysis.shapeAnalysis3d
dictAllFunctions['ShapeFiltering2dImg'] = PfctShapeAnalysis.shapeFiltering2dImg
dictAllFunctions['ShapeFiltering3dImg'] = PfctShapeAnalysis.shapeFiltering3dImg
dictAllFunctions['LabelToMeasureImg'] = PfctShapeAnalysis.labelToMeasureImg
dictAllFunctions['HistogramOfMeasure'] = PfctShapeAnalysis.histogramOfMeasure
dictAllFunctions['HistogramOfMeasureMultiSlice'] = PfctShapeAnalysis.histogramOfMeasureMultiSlice
dictAllFunctions['HistogramOfMeasureFromList'] = PfctShapeAnalysis.histogramOfMeasureFromList

#####################
#  Shape extraction #
#####################
dictAllFunctions['LabelShapeExtraction2d'] = PfctShapeSegmentation.labelShapeExtraction2d
dictAllFunctions['LabelShapeExtraction3d'] = PfctShapeSegmentation.labelShapeExtraction3d
dictAllFunctions['ShapeToLabel2dImg'] = PfctShapeSegmentation.shapeToLabel2dImg
dictAllFunctions['ShapeToLabel3dImg'] = PfctShapeSegmentation.shapeToLabel3dImg


#################
#    Utility    #
#################
dictAllFunctions['AppendSeqImg'] = PfctUtil.appendSeqImg
dictAllFunctions['BuildLines2dImg'] = PfctUtil.buildLines2dImg
dictAllFunctions['BuildLines3dImg'] = PfctUtil.buildLines3dImg
dictAllFunctions['ConvertImg'] = PfctUtil.convertImg
dictAllFunctions['GetROI2dImg'] = PfctUtil.getROI2dImg
dictAllFunctions['GetROI3dImg'] = PfctUtil.getROI3dImg
dictAllFunctions['CopyImg'] = PfctUtil.copyImg
dictAllFunctions['EraseImg'] = PfctUtil.eraseImg
dictAllFunctions['GaussianRandomImg'] = PfctUtil.gaussianRandomImg
dictAllFunctions['PutROI2dImg'] = PfctUtil.putROI2dImg
dictAllFunctions['PutROI3dImg'] = PfctUtil.putROI3dImg
dictAllFunctions['RandomImg'] = PfctUtil.randomImg
dictAllFunctions['ExtractPlan'] = PfctUtil.extractPlan
dictAllFunctions['CreateImage'] = PfctUtil.createImage
dictAllFunctions['PutSlice3dImg'] = PfctUtil.putSlice3dImg
dictAllFunctions['GetSlice3dImg'] = PfctUtil.getSlice3dImg
dictAllFunctions['ReinterpretGeometry'] = PfctUtil.reinterpretGeometry
dictAllFunctions['LabelToColorImg'] = PfctUtil.labelToColorImg

#########################
#    Other functions    #
#########################

dictAllFunctions['CopyImageOnScreen'] = PfctPfct.copyImageOnScreen
dictAllFunctions['GenerateImageCalibration'] = PfctPfct.generateImageCalibration
dictAllFunctions['InteractiveZStack'] = PfctPfct.interactiveZStack
dictAllFunctions['CreateMaskFromPolygon'] = PfctPfct.createMaskFromPolygon
dictAllFunctions['CreateColorCalibrationImage'] = PfctPfct.createColorCalibrationImage
dictAllFunctions['CreateMaskedImageFromPolygon'] = PfctPfct.createMaskedImageFromPolygon
dictAllFunctions['CreateLabelImageFromPolygon'] = PfctPfct.createLabelImageFromPolygon
dictAllFunctions['LoadImage'] = PfctPfct.loadImage
dictAllFunctions['LoadImageRaw'] = PfctPfct.loadImageRaw
dictAllFunctions['LoadObject'] = PfctPfct.loadObject
dictAllFunctions['ExtractImage'] = PfctPfct.extractImage
dictAllFunctions['ExportImage'] = PfctPfct.exportImage
dictAllFunctions['MergeChannelsImage'] = PfctPfct.mergeChannelsImage
dictAllFunctions['CreateSequenceImage'] = PfctPfct.createSequenceImage

#########################
#    Machine Learning   #
########################
dictAllFunctions['PixelClassificationImg'] = PfctMachineLearning.pixelClassificationImg
dictAllFunctions['PixelClassificationWithProbabilitiesImg'] = PfctMachineLearning.pixelClassificationWithProbabilitiesImg
dictAllFunctions['ShapeClassificationImg'] = PfctMachineLearning.shapeClassificationImg
dictAllFunctions['SuperPixelSegmentationImg'] = PfctMachineLearning.superPixelSegmentationImg


################
#    Macro    #
###############
dictAllFunctions['MacroFunction'] = PfctPfct.macroFunction

