import sys
import os
import traceback

from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import xml.etree.ElementTree as xmlet

import UsefullWidgets as wgt
import UsefullVariables as vrb
import DatabaseFunction as Dfct
import UsefullFunctions as fct
import UsefullTexts as txt

from RangeSlider import RangeSlider

import PyIPSDK
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLFeatureDetection as fd
import PyIPSDK.IPSDKIPLStats as stats
import PyIPSDK.IPSDKIPLClassification as classif

import numpy as np

class FilterWidget(qt.QWidget):

    def __init__(self, infoSet=None):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.infoSet = infoSet

        self.currentIndex = 0
        self.alreadyFalse = False

        try:
            file = xmlet.parse(vrb.folderInformation + "/UserFilters.mho")
            self.xmlElement = file.getroot()
        except:
            self.xmlElement = xmlet.Element('UserFilters')

        # try:
        #     self.setWindowFlag(Qt.WindowStaysOnTopHint)
        # except:
        #     self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.layout = qt.QGridLayout()

        self.filterSelection = FilterSelection(parent=self)
        self.measureSelection = MeasureSelection(infoSet = self.infoSet,parent = self)

        self.layout.addWidget(self.filterSelection, 0, 0)
        self.layout.addWidget(self.measureSelection, 1, 0)
        # self.layout.addWidget(self.buttonCalibration, 0, 1)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        # self.layout.setContentsMargins(10, 10, 10, 10)
        self.layout.setContentsMargins(10,10,10,0)
        self.layout.setHorizontalSpacing(3)

        self.setWindowTitle("Filter selection")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.setFixedSize(700*vrb.ratio, 350*vrb.ratio)

        self.loadXmlElement()

        self.filterSelection.comboBoxSelection.currentIndexChanged.connect(self.changeFilter)
        self.measureSelection.groupComputation.buttonPreview.clicked.connect(self.previewImage)
        self.measureSelection.groupComputation.buttonCompute.clicked.connect(self.applyProcess)

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None:

        try:
            vrb.mainWindow.currentLabel.groupBoxLut.lutArrayPreview = None
        except:
            pass
        try:
            vrb.mainWindow.widgetImage.imageOverlayLabel.groupBoxLut.lutArrayPreview = None
        except:
            pass

        vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)

    def loadXmlElement(self):

        for child in self.xmlElement:
            name = Dfct.childText(child,"Name")
            self.filterSelection.comboBoxSelection.addItem(name,child)
            if self.filterSelection.comboBoxSelection.count() > 1:
                self.filterSelection.buttonDelete.setEnabled(True)

        self.addElement()

    def addElement(self):

        newName = "New filter"
        num = 1
        while self.filterSelection.comboBoxSelection.findText(newName) != -1:
            num+=1
            newName = "New filter " + str(num)

        child = xmlet.SubElement(self.xmlElement, "Filter")
        nameElement = Dfct.SubElement(child, "Name")
        nameElement.text = newName

        for i in range(self.measureSelection.listWidget.count()):

            item = self.measureSelection.listWidget.item(i)

            try:
                item.values
                measureElement = Dfct.SubElement(child,item.text().replace(" ","_"))
                Dfct.SubElement(measureElement,"ipsdkName").text = item.ipsdkName
                Dfct.SubElement(measureElement,"isChecked").text = str(i==0)
                Dfct.SubElement(measureElement,"Min").text = str(np.min(item.values))
                Dfct.SubElement(measureElement,"Max").text = str((np.min(item.values)+np.max(item.values))/2)
                Dfct.SubElement(measureElement,"Exclusive").text = "False"
            except:
                pass

        self.filterSelection.comboBoxSelection.insertItem(0,newName, child)
        self.filterSelection.comboBoxSelection.setCurrentIndex(0)

        self.changeFilter()

    def saveXmlElement(self):

        Dfct.saveXmlElement(self.xmlElement,vrb.folderInformation + "/UserFilters.mho")
        try:
            vrb.mainWindow.actualizeFunctionFilter()
        except:
            pass

        self.filterSelection.buttonSave.setEnabled(False)

    def changeFilter(self):

        self.filterSelection.buttonDelete.setEnabled(self.filterSelection.comboBoxSelection.count()>1)

        element = self.filterSelection.comboBoxSelection.currentData()

        allFounded = True
        missingMeasures = []
        for child in element:
            found = False
            if child.tag not in ["Name","Formula","Editable","TextFilter"]:
                for i in range(self.measureSelection.listWidget.count()):
                    item = self.measureSelection.listWidget.item(i)
                    name = item.text().replace(" ", "_")
                    if name == child.tag:
                        found = True
                if found == False:
                    missingMeasures.append(child.tag)
                    allFounded = False

        if allFounded == False:

            text = "Some measures are missing :\n"
            for msr in missingMeasures:
                text+=msr.replace("_"," ")+"\n"

            self.messageBox = wgt.MessageBox(text, '', buttons=[qt.QMessageBox.Ok], icon=qt.QMessageBox.Warning,windowTitle="Error")
            self.messageBox.exec()

        isEditable = Dfct.childText(element,"Editable") == "True"

        # for i in range(self.measureSelection.listWidget.count()):
        for i in range(self.measureSelection.listWidget.count()-1,-1,-1):
            item = self.measureSelection.listWidget.item(i)

            if item is not None:

                try:
                    item.values
                    if isEditable:
                        item.setFlags(item.flags() ^ QtCore.Qt.ItemIsUserCheckable)
                    else:
                        item.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled)

                    measureElement = Dfct.SubElement(element, item.text().replace(" ", "_"))

                    if Dfct.SubElement(measureElement, "isChecked").text == "True":
                        item.setCheckState(Qt.Checked)
                    else:
                        item.setCheckState(Qt.Unchecked)
                except:
                    # self.measureSelection.listWidget.removeItemWidget(item)
                    self.measureSelection.listWidget.takeItem(self.measureSelection.listWidget.row(item))

        for measure in missingMeasures:
            newItem = qt.QListWidgetItem()
            newItem.setText(measure)
            newItem.setFlags(newItem.flags() ^ QtCore.Qt.ItemIsSelectable)
            self.measureSelection.listWidget.addItem(newItem)

        self.measureSelection.filterFormulaSelection.connectEditable = False
        self.measureSelection.filterFormulaSelection.checkBoxEditable.setChecked(isEditable)
        self.measureSelection.filterFormulaSelection.connectEditable = True
        self.measureSelection.filterFormulaSelection.changeEditable(verif=False)

        self.measureSelection.loadCurrentItem()
        self.measureSelection.createText()

    def previewImage(self):

        self.measureSelection.groupComputation.buttonPreview.setEnabled(False)
        self.measureSelection.groupComputation.buttonCompute.setEnabled(False)
        qt.QApplication.processEvents()

        import time
        start = time.time()

        try:
            try:
                imageLabel = self.infoSet.imageLabel
                if self.infoSet.imageGrey is not None:
                    imageGrey = self.infoSet.imageGrey
                else:
                    imageGrey = self.infoSet.imageLabel
                if self.infoSet.imageLabel == vrb.mainWindow.currentLabel.image:
                    currentLabel = vrb.mainWindow.currentLabel
                else:
                    if self.infoSet.imageGrey is None:
                        currentLabel = vrb.mainWindow.currentLabel
                        for num in range(vrb.mainWindow.widgetLabelImage.layout.count()):
                            try:
                                item = vrb.mainWindow.widgetLabelImage.layout.itemAt(num)
                                if item is not None:
                                    label = item.widget()
                                    if label.image == self.infoSet.imageLabel:
                                        if label != vrb.mainWindow.widgetImage.imageOverlayLabel:
                                            if label != vrb.mainWindow.currentLabel:
                                                vrb.mainWindow.changeCurrentXmlElement(label)
                                            currentLabel = vrb.mainWindow.currentLabel
                                        else:
                                            currentLabel = vrb.mainWindow.widgetImage.imageOverlayLabel
                            except:
                                pass
                        #currentLabel = vrb.mainWindow.currentLabel
                    else:
                        for num in range(vrb.mainWindow.widgetLabelImage.layout.count()):
                            try:
                                item = vrb.mainWindow.widgetLabelImage.layout.itemAt(num)
                                if item is not None:
                                    label = item.widget()
                                    if label.image == self.infoSet.imageGrey:
                                        if label != vrb.mainWindow.currentLabel:
                                            vrb.mainWindow.changeCurrentXmlElement(label)
                            except:
                                pass
                        for num in range(vrb.mainWindow.widgetImage.groupBoxOverlay.comboBoxOverlay.count()):
                            if vrb.mainWindow.widgetImage.groupBoxOverlay.comboBoxOverlay.itemData(num).image == self.infoSet.imageLabel:
                                vrb.mainWindow.widgetImage.groupBoxOverlay.comboBoxOverlay.setCurrentIndex(num)
                        vrb.mainWindow.widgetImage.groupBoxOverlay.checkBoxOverlay.setChecked(True)
                        currentLabel = vrb.mainWindow.widgetImage.imageOverlayLabel
            except:
                traceback.print_exc(file=sys.stderr)
                if vrb.mainWindow.widgetImage.imageOverlayLabel is not None and vrb.mainWindow.widgetImage.imageOverlayLabel.image is not None:
                    imageLabel = vrb.mainWindow.widgetImage.imageOverlayLabel.image
                    currentLabel = vrb.mainWindow.widgetImage.imageOverlayLabel
                else:
                    imageLabel = vrb.mainWindow.currentLabel.image
                    currentLabel = vrb.mainWindow.currentLabel
                imageGrey = vrb.mainWindow.currentLabel.image

            formula = self.measureSelection.filterFormulaSelection.textEditFilter.toPlainText()

            if imageLabel.hasGeometricCalibration():
                calibration = imageLabel.getGeometricCalibration()
            else:
                calibration = PyIPSDK.createGeometricCalibration2d(1, 1, 'px')
            if imageLabel.getSizeZ() == 1:
                inMeasureInfoSet = PyIPSDK.createMeasureInfoSet2d(calibration)
                PyIPSDK.createMeasureInfo(inMeasureInfoSet, "Custom_Measure", "LogicFormulaMsr", shapeanalysis.createLogicFormulaMsrParams(formula))
                start2 = time.time()
                output = shapeanalysis.labelAnalysis2d(imageGrey, imageLabel, inMeasureInfoSet)
                values = output.getMeasure("Custom_Measure").getMeasureResult().getColl(0)
            else:
                inMeasureInfoSet = PyIPSDK.createMeasureInfoSet3d(calibration)
                PyIPSDK.createMeasureInfo(inMeasureInfoSet, "Custom_Measure", "LogicFormulaMsr", shapeanalysis.createLogicFormulaMsrParams(formula))
                output = shapeanalysis.labelAnalysis3d(imageGrey, imageLabel, inMeasureInfoSet)
                values = output.getMeasure("Custom_Measure").getMeasureResult().getColl(0)

            currentLut = currentLabel.groupBoxLut.currentLut
            currentLabel.groupBoxLut.lutArrayPreview = [[0],[0],[0]]
            for i in range(1,len(values)):
                for c in range(3):
                    if values[i] == 0:
                        currentLabel.groupBoxLut.lutArrayPreview[c].append(255)
                        # currentLabel.groupBoxLut.lutArrayPreview[c].append(0)
                    else:
                        currentLabel.groupBoxLut.lutArrayPreview[c].append(currentLut[c][i+1])

            # outImage = shapeanalysis.shapeFiltering2dImg(imageLabel, imageGrey, formula)
            # maskOut = bin.lightThresholdImg(outImage,1)
            # maskIn = bin.lightThresholdImg(imageLabel,1)
            # mask = arithm.subtractImgImg(maskIn,maskOut)
            # mask = util.convertImg(mask,PyIPSDK.eIBT_UInt8)
            # vrb.maskPreview = arithm.multiplyScalarImg(mask,255)

            vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)

        except:
            traceback.print_exc(file=sys.stderr)

        self.measureSelection.groupComputation.buttonPreview.setEnabled(True)
        self.measureSelection.groupComputation.buttonCompute.setEnabled(True)

    def applyProcess(self):

        self.measureSelection.groupComputation.buttonPreview.setEnabled(False)
        self.measureSelection.groupComputation.buttonCompute.setEnabled(False)
        qt.QApplication.processEvents()

        try:
            currentLabelGrey = None
            try:
                imageLabel = self.infoSet.imageLabel
                for num in range(vrb.mainWindow.widgetLabelImage.layout.count()):
                    try:
                        item = vrb.mainWindow.widgetLabelImage.layout.itemAt(num)
                        if item is not None:
                            label = item.widget()
                            if label.image == self.infoSet.imageLabel:
                                currentLabel = label
                            if label.image == self.infoSet.imageGrey:
                                currentLabelGrey = label
                    except:
                        pass

            except:
                if vrb.mainWindow.widgetImage.imageOverlayLabel is not None and vrb.mainWindow.widgetImage.imageOverlayLabel.image is not None:
                    imageLabel = vrb.mainWindow.widgetImage.imageOverlayLabel.image
                    currentLabel = vrb.mainWindow.widgetImage.imageOverlayLabel
                else:
                    imageLabel = vrb.mainWindow.currentLabel.image
                    currentLabel = vrb.mainWindow.currentLabel

            formula = self.measureSelection.filterFormulaSelection.textEditFilter.toPlainText()

            name = ""
            functionXmlElement = xmlet.Element('FunctionCall')
            if imageLabel.getSizeZ() == 1:
                Dfct.SubElement(functionXmlElement, 'Name').text = 'ShapeFiltering2dImg'
            else:
                Dfct.SubElement(functionXmlElement, 'Name').text = 'ShapeFiltering3dImg'
            paramsNode = Dfct.SubElement(functionXmlElement, 'Parameters')
            paramNode0 = Dfct.SubElement(paramsNode, 'Parameter_0')
            typeNode = Dfct.SubElement(paramNode0, 'Type')
            typeNode.text = "Image"
            valueNode = Dfct.SubElement(paramNode0, 'Value')
            valueNode.text = Dfct.childText(currentLabel.xmlElement, 'ElementID')
            valueNode.set('isElementID', str(True))

            paramNode1 = Dfct.SubElement(paramsNode, 'Parameter_1')
            typeNode = Dfct.SubElement(paramNode1, 'Type')
            typeNode.text = "Image"
            valueNode = Dfct.SubElement(paramNode1, 'Value')
            if currentLabelGrey is not None:
                valueNode.text = Dfct.childText(currentLabelGrey.xmlElement, 'ElementID')
                name = Dfct.childText(currentLabelGrey.xmlElement, 'Name')
            else:
                valueNode.text = Dfct.childText(currentLabel.xmlElement, 'ElementID')
                name = Dfct.childText(currentLabel.xmlElement, 'Name')

            valueNode.set('isElementID', str(True))
            valueNode.set('Checked', str(True))

            paramNode2 = Dfct.SubElement(paramsNode, 'Parameter_2')
            typeNode = Dfct.SubElement(paramNode2, 'Type')
            typeNode.text = "Advanced"
            choiceNode = Dfct.SubElement(paramNode2, 'Choice')
            choiceNode.text = "Formula"
            valuesNode = Dfct.SubElement(paramNode2, 'Values')

            _paramNode0 = Dfct.SubElement(valuesNode, 'Parameter_0')
            _typeNode = Dfct.SubElement(_paramNode0, 'Type')
            _typeNode.text = "String"
            _valueNode = Dfct.SubElement(_paramNode0, 'Value')
            _valueNode.text = formula

            valueNode = Dfct.SubElement(paramNode2, 'Value')
            valueNode.text = str(0)

            outputsNode = Dfct.SubElement(functionXmlElement, 'Outputs')
            outputNode0 = Dfct.SubElement(outputsNode, 'Output_0')
            typeNode = Dfct.SubElement(outputNode0, 'Type')
            typeNode.text = "Image"
            if vrb.shapeFilteringMode == "Replace_Image":
                valueNode = Dfct.SubElement(outputNode0, 'Value')
                valueNode.text = name

            vrb.mainWindow.applyProcessAsync(None,xmlFunctionCall = functionXmlElement,widgetFilter=self.measureSelection.groupComputation)

        except:
            traceback.print_exc(file=sys.stderr)

        # self.measureSelection.groupComputation.buttonPreview.setEnabled(True)
        # self.measureSelection.groupComputation.buttonCompute.setEnabled(True)

class NameFilterWidget(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.layout = qt.QGridLayout()

        self.labelName = qt.QLabel("Name filter")
        self.labelName.setFixedSize(100*vrb.ratio,30*vrb.ratio)
        self.lineEditName = qt.QLineEdit()
        self.lineEditName.setFixedSize(160*vrb.ratio,30*vrb.ratio)
        self.buttonValidate = wgt.PushButtonImage(vrb.folderImages + "/Validate.png", margins=2)
        self.buttonValidate.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonValidate.setToolTip("Validate")

        self.layout.addWidget(self.labelName, 0, 0)
        self.layout.addWidget(self.lineEditName, 0, 1)
        self.layout.addWidget(self.buttonValidate, 0, 2)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(3, 0, 3, 0)
        self.layout.setHorizontalSpacing(3)

        self.setWindowTitle("Name filter")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

class FilterSelection(qt.QGroupBox):

    def __init__(self,parent = None):
        qt.QGroupBox.__init__(self)

        self.parent = parent

        self.layout = qt.QGridLayout()

        self.namefilterWidget = NameFilterWidget()

        self.labelSelection = qt.QLabel("Select your filter")
        self.labelSelection.setFixedSize(110*vrb.ratio,30*vrb.ratio)
        self.comboBoxSelection = qt.QComboBox()
        self.comboBoxSelection.setFixedSize(140*vrb.ratio,30*vrb.ratio)
        self.buttonAdd = wgt.PushButtonImage(vrb.folderImages + "/Add_4.png", margins=2)
        self.buttonAdd.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonAdd.setToolTip("Add a new filter")
        self.buttonEdit = wgt.PushButtonImage(vrb.folderImages + "/Edit_3.png", margins=2)
        self.buttonEdit.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonEdit.setToolTip("Change the name of the filter")
        self.buttonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=2)
        self.buttonSave.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonSave.setToolTip("Save this filter")
        self.buttonDelete = wgt.PushButtonImage(vrb.folderImages + "/Delete.png", margins=2)
        self.buttonDelete.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonDelete.setToolTip("Delete this filter")
        self.buttonDelete.setEnabled(False)

        self.layout.addWidget(self.labelSelection, 0, 0)
        self.layout.addWidget(self.comboBoxSelection, 0, 1)
        self.layout.addWidget(self.buttonAdd, 0, 2)
        self.layout.addWidget(self.buttonEdit, 0, 3)
        self.layout.addWidget(self.buttonSave, 0, 4)
        self.layout.addWidget(self.buttonDelete, 0, 5)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(3, 0, 3, 0)
        self.layout.setHorizontalSpacing(3)

        self.setStyleSheet("QGroupBox {border: 0px solid gray; }")

        self.setFixedSize(400*vrb.ratio, 36*vrb.ratio)

        self.buttonAdd.clicked.connect(self.parent.addElement)
        self.buttonEdit.clicked.connect(self.editElement)
        self.buttonSave.clicked.connect(self.parent.saveXmlElement)
        self.buttonDelete.clicked.connect(self.deleteElement)

        self.namefilterWidget.buttonValidate.clicked.connect(self.validateName)

    def editElement(self):

        self.namefilterWidget.lineEditName.setText(self.comboBoxSelection.currentText())

        self.namefilterWidget.showNormal()
        self.namefilterWidget.window().raise_()
        self.namefilterWidget.window().activateWindow()
        # self.namefilterWidget.show()

    def validateName(self):

        self.namefilterWidget.close()
        self.comboBoxSelection.setItemText(self.comboBoxSelection.currentIndex(),self.namefilterWidget.lineEditName.text())
        element = self.comboBoxSelection.currentData()
        Dfct.SubElement(element,"Name").text = self.namefilterWidget.lineEditName.text()
        #self.parent.saveXmlElement()

    # def saveElement(self):
    #
    #     self.comboBoxSelection.setItemData(self.comboBoxSelection.currentIndex(),self.parent.measureSelection.filterFormulaSelection.textEditFilter.toPlainText())
    #     self.parent.saveXmlElement()

    def deleteElement(self):

        element = self.comboBoxSelection.currentData()
        self.comboBoxSelection.removeItem(self.comboBoxSelection.currentIndex())
        Dfct.removeElement(self.parent.xmlElement,element)
        self.parent.saveXmlElement()

class MeasureSelection(qt.QGroupBox):

    signalMeasureChanging = pyqtSignal()

    def __init__(self,infoSet = None,parent = None):
        qt.QGroupBox.__init__(self)

        self.dictMinMax = {}

        self.parent = parent
        self.allowChange = True
        self.allowExclusive = True

        self.posX = None
        self.posY = None

        self.infoSet = infoSet

        self.layout = qt.QGridLayout()

        self.labelMeasure = qt.QLabel("Measure")
        self.labelMeasure.setFixedSize(50*vrb.ratio,30*vrb.ratio)

        self.listWidget = qt.QListWidget()
        self.listWidget.setFixedSize(140*vrb.ratio,100*vrb.ratio)

        self.rangeSlider = RangeSlider()
        self.rangeSlider.type = PyIPSDK.eIBT_Real32
        self.rangeSlider.setFixedSize(400*vrb.ratio,100*vrb.ratio)

        self.infoGroupBox = InfoGroupBox()
        self.infoGroupBox.setFixedSize(100*vrb.ratio,100*vrb.ratio)
        self.checkBoxExclusive = self.infoGroupBox.checkBoxExclusive
        self.minLabel = self.infoGroupBox.minLabel
        self.minLineEdit = self.infoGroupBox.minLineEdit
        self.maxLabel = self.infoGroupBox.maxLabel
        self.maxLineEdit = self.infoGroupBox.maxLineEdit

        self.filterFormulaSelection = FilterFormulaSelection(parent=parent)

        self.groupComputation = GroupComputation()

        self.layout.addWidget(self.labelMeasure,0,0)
        self.layout.addWidget(self.listWidget,1,0)
        self.layout.addWidget(self.infoGroupBox,0,1,2,1)
        self.layout.addWidget(self.rangeSlider,0,2,2,1,Qt.AlignCenter)
        self.layout.addWidget(self.filterFormulaSelection,3,0,1,3)
        self.layout.addWidget(self.groupComputation,4,0,1,3)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(10, 10, 10, 10)
        self.layout.setHorizontalSpacing(3)

        self.setStyleSheet("QGroupBox {border: 0px solid gray; }")

        self.loadMeasureFromInfoset()

        self.listWidget.itemClicked.connect(self.listWidgetItemClicked)
        self.listWidget.itemDoubleClicked.connect(self.listWidgetItemDoubleClicked)
        self.listWidget.itemSelectionChanged.connect(self.loadCurrentItem)
        self.checkBoxExclusive.stateChanged.connect(self.changeExclusive)
        self.rangeSlider.signalValueChanged.connect(self.rangeSliderChanged)
        self.minLineEdit.textChanged.connect(self.changeMinSliderValue)
        self.maxLineEdit.textChanged.connect(self.changeMaxSliderValue)

        # self.loadCurrentItem()

    def listWidgetItemClicked(self,clickedItem):

        self.listWidget.setCurrentItem(clickedItem)

        self.loadCurrentItem()

        self.createText()

    def listWidgetItemDoubleClicked(self,clickedItem):

        if self.filterFormulaSelection.checkBoxEditable.isChecked():
            text = self.filterFormulaSelection.textEditFilter.toPlainText() + " " + clickedItem.ipsdkName
            self.filterFormulaSelection.textEditFilter.setText(text)
            self.filterFormulaSelection.textEditFilter.setAlignment(Qt.AlignCenter)

    def changeMinSliderValue(self):

        try:
            if self.allowChange:
                self.allowChange = False
                minValue = float(self.minLineEdit.text())
                if int(minValue)==minValue:
                    minValue = int(minValue)
                newMinValue = max(minValue,self.rangeSlider.minValue)
                newMinValue = min(newMinValue,self.rangeSlider.currentValueMax)
                if newMinValue != minValue:
                    minValue = newMinValue
                    self.minLineEdit.setText(fct.numberCalibration(minValue,3))
                self.rangeSlider.isFixedMin = True
                self.rangeSlider.currentValueMin = minValue
                self.rangeSlider.setValueMin(minValue)

                self.allowChange = True
                self.createText()
        except:
            pass

    def changeMaxSliderValue(self):

        try:
            if self.allowChange:
                self.allowChange = False
                maxValue = float(self.maxLineEdit.text())
                if int(maxValue)==maxValue:
                    maxValue = int(maxValue)
                newMaxValue = min(maxValue,self.rangeSlider.maxValue)
                newMaxValue = max(newMaxValue,self.rangeSlider.currentValueMin)
                if newMaxValue != maxValue:
                    maxValue = newMaxValue
                    # self.maxLineEdit.setText(str(maxValue))

                self.rangeSlider.isFixedMax = True
                self.rangeSlider.currentValueMax = maxValue
                self.rangeSlider.setValueMax(maxValue)

                self.allowChange = True
                self.createText()
        except:
            pass

    def loadMeasureFromInfoset(self):

        self.listWidget.clear()

        allMeasures = []
        nbItem = 0
        for msr in self.infoSet.getMeasureInfoSet().getMeasureInfoColl():
            key = msr.key()
            userName,isFound = fct.findUserName(key)

            # if isFound and userName not in ["Barycenter X","Barycenter Y","Barycenter Z"]:
            if isFound:

                newItem = qt.QListWidgetItem()
                newItem.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled)
                if nbItem == 0:
                    newItem.setCheckState(Qt.Checked)
                else:
                    newItem.setCheckState(Qt.Unchecked)

                newItem.setText(userName)

                newItem.ipsdkName = key
                values = self.infoSet.getMeasure(key).getMeasureResult().getColl(0)

                histogram = fct.listToHistogram(values, nbValues=50)

                if key not in self.dictMinMax:
                    self.dictMinMax[key] = {}
                self.dictMinMax[key]["Min"] = float(fct.numberCalibration(histogram["Min"], 3))
                self.dictMinMax[key]["Max"] = float(fct.numberCalibration(histogram["Max"], 3))

                newItem.values = values

                self.listWidget.addItem(newItem)
                allMeasures.append((key,userName))
                if nbItem == 0:
                    self.listWidget.setCurrentItem(newItem)
                nbItem+=1

        self.loadCurrentItem()

    def rangeSliderChanged(self,minValue,maxValue):

        if self.allowChange:
            self.allowChange = False

            self.minLineEdit.setText(fct.numberCalibration(minValue,3))
            self.maxLineEdit.setText(fct.numberCalibration(maxValue,3))

            self.allowChange = True

            self.createText()

    def changeExclusive(self):

        if self.allowExclusive:

            self.rangeSlider.groupSlider.applyExclusive(self.checkBoxExclusive.isChecked())
            self.createText()

    def loadCurrentItem(self):

        try:

            self.listWidget.currentItem().values

            self.rangeSlider.isFixedMin = False
            self.rangeSlider.isFixedMax = False

            for i in range(self.listWidget.count()):
                item = self.listWidget.item(i)
                if item == self.listWidget.currentItem():
                    item.setForeground(QtGui.QColor(0,20, 255))
                else:
                    try:
                        item.values
                        item.setForeground(QtGui.QColor(255, 255, 255))
                    except:
                        item.setForeground(QtGui.QColor(170, 170, 170))

            try:
                element = self.parent.filterSelection.comboBoxSelection.currentData()

                currentItem = self.listWidget.currentItem()

                child = Dfct.SubElement(element,currentItem.text().replace(" ","_"))
                minValue = float(Dfct.childText(child,"Min"))
                maxValue = float(Dfct.childText(child,"Max"))

                exclusive = Dfct.childText(child, "Exclusive")

                histogram = fct.listToHistogram(currentItem.values, nbValues=50)

            except:

                #traceback.print_exc(file=sys.stderr)

                exclusive = "False"

                if self.posX is None:
                    self.posX = 0
                    self.posY = 0.5
                else:
                    self.posX = (self.rangeSlider.currentValueMin-self.rangeSlider.minValue)/(self.rangeSlider.maxValue-self.rangeSlider.minValue)
                    self.posY = (self.rangeSlider.currentValueMax-self.rangeSlider.minValue)/(self.rangeSlider.maxValue-self.rangeSlider.minValue)

                currentItem = self.listWidget.currentItem()

                histogram = fct.listToHistogram(currentItem.values, nbValues=50)

                minValue = histogram["Min"] + (histogram["Max"]-histogram["Min"])*self.posX
                maxValue = histogram["Min"] + (histogram["Max"]-histogram["Min"])*self.posY

            self.rangeSlider.groupSlider.getHistogram(histogram["Frequencies"])
            self.rangeSlider.setMinMaxValues(histogram["Min"],histogram["Max"])

            # self.rangeSlider.setValues(minValue,maxValue)

            self.allowChange = False

            self.rangeSlider.currentValueMin = minValue
            self.rangeSlider.currentValueMax = maxValue

            self.allowExclusive = False
            self.checkBoxExclusive.setChecked(exclusive == "True")
            self.allowExclusive = True

            self.minLineEdit.setText(fct.numberCalibration(minValue,3))
            self.maxLineEdit.setText(fct.numberCalibration(maxValue,3))

            self.allowChange = True

            qt.QApplication.processEvents()

            self.changeMinSliderValue()
            self.changeMaxSliderValue()
            self.rangeSlider.groupSlider.applyExclusive(self.checkBoxExclusive.isChecked())

        except:

            pass

    def changeEditable(self):

        if self.filterFormulaSelection.checkBoxEditable.isChecked() == False:
            self.layout.addWidget(self.labelMeasure, 0, 0)
            self.layout.addWidget(self.listWidget, 1, 0)
            self.layout.addWidget(self.infoGroupBox, 0, 1, 2, 1)
            self.layout.addWidget(self.rangeSlider, 0, 2, 2, 1, Qt.AlignCenter)
            self.layout.addWidget(self.groupComputation, 3, 0, 1, 3)
            self.layout.addWidget(self.filterFormulaSelection, 4, 0, 1, 3)
        else:
            self.layout.addWidget(self.labelMeasure,0,0)
            self.layout.addWidget(self.listWidget,1,0)
            self.layout.addWidget(self.infoGroupBox,0,1,2,1)
            self.layout.addWidget(self.rangeSlider,0,2,2,1,Qt.AlignCenter)
            self.layout.addWidget(self.filterFormulaSelection,3,0,1,3)
            self.layout.addWidget(self.groupComputation,4,0,1,3)

        self.infoGroupBox.checkBoxExclusive.setEnabled(not(self.filterFormulaSelection.checkBoxEditable.isChecked()))
        self.infoGroupBox.minLineEdit.setEnabled(not(self.filterFormulaSelection.checkBoxEditable.isChecked()))
        self.infoGroupBox.maxLineEdit.setEnabled(not(self.filterFormulaSelection.checkBoxEditable.isChecked()))

    def createText(self):

        self.parent.filterSelection.buttonSave.setEnabled(True)

        self.changeEditable()

        #nameMeasure = self.listWidget.currentItem().ipsdkName

        if self.listWidget.currentItem() is not None:

            name = self.listWidget.currentItem().text()

            minValue = self.minLineEdit.text()
            maxValue = self.maxLineEdit.text()

            element = self.parent.filterSelection.comboBoxSelection.currentData()
            if element is not None:
                measureElement = Dfct.SubElement(element,name.replace(" ","_"))
                Dfct.SubElement(measureElement,"Min").text = minValue
                Dfct.SubElement(measureElement,"Max").text = maxValue
                Dfct.SubElement(measureElement,"Exclusive").text = str(self.checkBoxExclusive.isChecked())

            for i in range(self.listWidget.count()):
                item = self.listWidget.item(i)
                name = item.text()
                measureElement = Dfct.SubElement(element, name.replace(" ", "_"))
                if item.checkState() == 2:
                    Dfct.SubElement(measureElement, "isChecked").text = "True"
                else:
                    Dfct.SubElement(measureElement, "isChecked").text = "False"

            if self.filterFormulaSelection.checkBoxEditable.isChecked()==False:

                text = ""

                for child in element:
                    try:
                        if Dfct.childText(child,"isChecked") == "True":
                            currentName = Dfct.childText(child,"ipsdkName")
                            if text !="":
                                text+=" && "
                            minValue = Dfct.childText(child,"Min")
                            maxValue = Dfct.childText(child,"Max")
                            if Dfct.childText(child,"Exclusive") == "True":
                                text += "(" + currentName + "<=" + minValue + " || " + currentName + ">=" + maxValue + ")"
                            else:
                                if float(minValue) == self.dictMinMax[currentName]["Min"] and float(maxValue) == self.dictMinMax[currentName]["Max"]:
                                    text += ""
                                    if text != "":
                                        text = text[:-3]
                                elif float(minValue) == self.dictMinMax[currentName]["Min"] and float(maxValue) != self.dictMinMax[currentName]["Max"]:
                                    text += "("+currentName + "<=" + maxValue+")"
                                elif float(minValue) != self.dictMinMax[currentName]["Min"] and float(maxValue) == self.dictMinMax[currentName]["Max"]:
                                    text += "("+currentName + ">=" + minValue+")"
                                else:
                                    text += "(" + currentName + ">=" + minValue + " && " + currentName + "<=" + maxValue + ")"
                    except:
                        pass

                self.filterFormulaSelection.textEditFilter.setText(text)
                self.filterFormulaSelection.textEditFilter.setAlignment(Qt.AlignCenter)

                #Dfct.saveXmlElement(self.parent.xmlElement, vrb.folderInformation + "/UserFilters.mho")

class InfoGroupBox(qt.QGroupBox):

    def __init__(self,infoSet = None):
        qt.QGroupBox.__init__(self)

        self.layout = qt.QGridLayout()

        self.checkBoxExclusive = qt.QCheckBox("Exclusive")
        self.minLabel = qt.QLabel("Min")
        self.minLineEdit = qt.QLineEdit()
        self.maxLabel = qt.QLabel("Max")
        self.maxLineEdit = qt.QLineEdit()

        self.layout.addWidget(self.checkBoxExclusive,0,0,1,2)
        self.layout.addWidget(self.minLabel,1,0)
        self.layout.addWidget(self.minLineEdit,1,1)
        self.layout.addWidget(self.maxLabel,2,0)
        self.layout.addWidget(self.maxLineEdit,2,1)
        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(3, 0, 3, 0)
        self.layout.setHorizontalSpacing(3)

class FilterFormulaSelection(qt.QGroupBox):

    def __init__(self,parent=None):
        qt.QGroupBox.__init__(self)

        self.connectEditable = True

        self.parent = parent

        self.layout = qt.QGridLayout()

        self.labelFilter = qt.QLabel("Filter formula")
        self.labelFilter.setFixedSize(100 * vrb.ratio, 30 * vrb.ratio)
        # self.labelFilter.setStyleSheet("QTextEdit {background:red;border:0px }")
        self.textEditFilter = qt.QTextEdit()
        self.textEditFilter.setEnabled(False)
        # self.textEditFilter.setStyleSheet("QTextEdit {background:transparent;border:1px }")
        self.textEditFilter.setStyleSheet("QTextEdit{background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #3d3d3d, stop: 0 #343434,"
                                          " stop: 1 #3d3d3d);padding: 1px;border-style: solid; border: 1px solid #1e1e1e;}")
        self.textEditFilter.setAlignment(Qt.AlignCenter)
        self.textEditFilter.setFixedSize(450*vrb.ratio,60*vrb.ratio)

        font = QtGui.QFont()
        font.setPointSize(10)
        self.textEditFilter.setFont(font)

        self.buttonOr = qt.QPushButton("OR")
        self.buttonOr.setFixedSize(35 * vrb.ratio, 30 * vrb.ratio)
        self.buttonOr.setVisible(False)
        self.buttonAnd = qt.QPushButton("AND")
        self.buttonAnd.setFixedSize(40 * vrb.ratio, 30 * vrb.ratio)
        self.buttonAnd.setVisible(False)

        self.checkBoxEditable = qt.QCheckBox("Editable")
        self.checkBoxEditable.setFixedSize(100 * vrb.ratio, 30 * vrb.ratio)

        groupBox = qt.QGroupBox()
        groupBox.setFixedSize(100 * vrb.ratio,60*vrb.ratio)
        layoutGroupBox = qt.QVBoxLayout()
        layoutGroupBox.addWidget(self.labelFilter)
        layoutGroupBox.addWidget(self.checkBoxEditable)
        layoutGroupBox.setSizeConstraint(1)
        layoutGroupBox.setContentsMargins(0, 0, 0, 0)
        layoutGroupBox.setSpacing(0)
        groupBox.setLayout(layoutGroupBox)

        # self.layout.addWidget(self.labelFilter, 0, 0)
        # self.layout.addWidget(self.checkBoxEditable, 1, 0,Qt.AlignLeft)
        self.layout.addWidget(groupBox, 0,0)
        self.layout.addWidget(self.textEditFilter, 0, 1,Qt.AlignLeft)
        self.layout.addWidget(self.buttonOr, 0, 2)
        self.layout.addWidget(self.buttonAnd, 0, 3)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(3, 0, 3, 0)
        self.layout.setHorizontalSpacing(3)

        self.setStyleSheet("QGroupBox {border: 0px solid gray; }")

        self.checkBoxEditable.clicked.connect(self.changeEditable_)
        self.textEditFilter.textChanged.connect(self.changeFormula)
        self.buttonOr.clicked.connect(self.addOr)
        self.buttonAnd.clicked.connect(self.addAnd)
        # self.checkBoxEditable.stateChanged.connect(self.changeEditable)

    def changeFormula(self):

        item = self.parent.filterSelection.comboBoxSelection.currentData()
        Dfct.SubElement(item, "Formula").text = str(self.textEditFilter.toPlainText())

    def addOr(self):

        text = self.textEditFilter.toPlainText() + " || "
        self.textEditFilter.setText(text)
        self.textEditFilter.setAlignment(Qt.AlignCenter)

    def addAnd(self):

        text = self.textEditFilter.toPlainText() + " && "
        self.textEditFilter.setText(text)
        self.textEditFilter.setAlignment(Qt.AlignCenter)

    def changeEditable_(self):

        if self.connectEditable:
            self.changeEditable()

    def changeEditable(self,verif=True):

        item = self.parent.filterSelection.comboBoxSelection.currentData()
        Dfct.SubElement(item,"Editable").text = str(self.checkBoxEditable.isChecked())

        if self.checkBoxEditable.isChecked():
            self.textEditFilter.setEnabled(True)
            self.textEditFilter.setStyleSheet("QTextEdit{background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #4d4d4d, stop: 0 #646464,"
                                              " stop: 1 #5d5d5d);padding: 1px;border-style: solid; border: 1px solid #1e1e1e;}")
            self.buttonOr.setVisible(True)
            self.buttonAnd.setVisible(True)
        else:
            if verif:
                messageBox = wgt.MessageBox('If you leave this mode, you will lose all your modifications.\nDo you want to continue ?', '', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No], icon=qt.QMessageBox.Warning)
                res = messageBox.exec()
                if res == qt.QMessageBox.Yes:
                    self.textEditFilter.setEnabled(False)
                    self.textEditFilter.setStyleSheet("QTextEdit{background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #3d3d3d, stop: 0 #343434,"
                                                      " stop: 1 #3d3d3d);padding: 1px;border-style: solid; border: 1px solid #1e1e1e;}")
                    self.buttonOr.setVisible(False)
                    self.buttonAnd.setVisible(False)
                else:
                    # app.processEvents()
                    self.checkBoxEditable.setChecked(True)
            else:
                self.textEditFilter.setEnabled(False)
                self.textEditFilter.setStyleSheet("QTextEdit{background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #3d3d3d, stop: 0 #343434,"
                                                  " stop: 1 #3d3d3d);padding: 1px;border-style: solid; border: 1px solid #1e1e1e;}")
                self.buttonOr.setVisible(False)
                self.buttonAnd.setVisible(False)

        if verif:
            self.parent.measureSelection.createText()
            self.parent.changeFilter()

class GroupComputation(qt.QGroupBox):

    def __init__(self):
        qt.QGroupBox.__init__(self)

        self.layout = qt.QGridLayout()

        self.buttonPreview = wgt.PushButtonImage(vrb.folderImages + "/eye_open.png", margins=2)
        self.buttonPreview.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonPreview.setToolTip("Preview")
        self.buttonCompute = wgt.PushButtonImage(vrb.folderImages + "/Validate.png", margins=2)
        self.buttonCompute.setFixedSize(30*vrb.ratio,30*vrb.ratio)
        self.buttonCompute.setToolTip("Apply on the current image")

        self.layout.addWidget(self.buttonPreview, 0, 0,Qt.AlignRight)
        self.layout.addWidget(self.buttonCompute, 0, 1)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(3, 0, 3, 0)
        self.layout.setHorizontalSpacing(3)

        self.setStyleSheet("QGroupBox {border: 0px solid gray; }")

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook

    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook

    inImage = PyIPSDK.loadTiffImageFile("D:/ExampleImages/ImageLabel.tif")

    if inImage.hasGeometricCalibration():
        calibration = inImage.getGeometricCalibration()
    else:
        calibration = PyIPSDK.createGeometricCalibration2d(1, 1, 'px')
    inMeasureInfoSet2d = PyIPSDK.createMeasureInfoSet2d(calibration)
    # PyIPSDK.createMeasureInfo(inMeasureInfoSet2d, "Area2dMsr", shapeanalysis.createHolesBasicPolicyMsrParams(False))
    PyIPSDK.createMeasureInfo(inMeasureInfoSet2d, "Perimeter2dMsr", shapeanalysis.createHolesBasicPolicyMsrParams(False))
    PyIPSDK.createMeasureInfo(inMeasureInfoSet2d, "Circularity2dMsr", shapeanalysis.createHolesBasicPolicyMsrParams(False))
    # PyIPSDK.createMeasureInfo(inMeasureInfoSet2d, "EquivalentRayMsr")
    # PyIPSDK.createMeasureInfo(inMeasureInfoSet2d, "AspectRatioMsr")

    infoSet = shapeanalysis.labelAnalysis2d(inImage, inImage, inMeasureInfoSet2d)

    foo = FilterWidget(infoSet=infoSet)
    # foo = MeasureSelection()

    foo.show()

    foo.measureSelection.rangeSlider.setValues(foo.measureSelection.rangeSlider.currentValueMin,foo.measureSelection.rangeSlider.currentValueMax)

    foo.measureSelection.loadCurrentItem()

    app.exec_()