import sys, traceback
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation

import sys

from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
import UsefullWidgets as wgt
from RangeSlider import RangeSlider

import DatabaseFunction as Dfct

import UsefullFunctions as fct

import PyIPSDK
import UsefullVariables as vrb


import PyIPSDK
import UsefullVariables as vrb
import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from ConversionIPSDK import dictConversion


class FeatureDisplayer:
    def __init__(self, xmlElement, object, valueSpoiler, mainWindow,currentWidget):
        super(FeatureDisplayer, self).__init__()

        self.xmlElement = xmlElement
        self.object = object
        self.valueSpoiler = valueSpoiler
        self.mainWindow = mainWindow
        self.currentWidget = currentWidget

    def display(self, xmlElement, boolShow=True):
        widgetImage = self.mainWindow.widgetImage
        widgetImage.elementIPSDK.add(self)
        widgetImage.actualizeScene()

    def stopDisplay(self):
        widgetImage = self.mainWindow.widgetImage
        if self in widgetImage.elementIPSDK:
            widgetImage.elementIPSDK.remove(self)
        widgetImage.actualizeScene()

    def close(self):
        self.stopDisplay()


class FeatureTableDisplayer(qt.QWidget):
    def __init__(self, xmlElement, object, valueSpoiler, mainWindow):
        super(FeatureTableDisplayer, self).__init__()

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.xmlElement = xmlElement
        self.object = object
        self.valueSpoiler = valueSpoiler
        self.mainWindow = mainWindow

        self.displayObject = None

        self.buttonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=2)
        self.buttonSave.setFixedSize(30, 30)

        font = QtGui.QFont()
        font.setPixelSize(14*vrb.ratio)
        self.labelNumberElement = qt.QLabel()
        self.labelNumberElement.setFont(font)
        self.labelNumberElement.setFixedWidth(200*vrb.ratio)

        self.tableWidget = qt.QTableWidget()
        self.tableWidget.setAlternatingRowColors(True)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.buttonSave, 0, 0)
        self.layout.addWidget(self.labelNumberElement, 0, 1)
        self.layout.addWidget(self.tableWidget, 1, 0,1,2)
        self.setLayout(self.layout)

        self.initDisplayer()
        self.fillTable()

        self.setMinimumSize(250*vrb.ratio, 500*vrb.ratio)
        self.resize(500*vrb.ratio, 750*vrb.ratio)

        self.buttonSave.clicked.connect(self.saveFileResult)
        self.tableWidget.itemSelectionChanged.connect(self.currentCellChanged)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

    def resizeEvent(self, a0: QtGui.QResizeEvent):

        self.tableWidget.setFixedWidth(max(1,self.width()*100/100 - 20))

    # def setHeaders(self,attributeNames):
    #
    #     header_item = qt.QTableWidgetItem("Number of elements")
    #     self.tableWidget.setHorizontalHeaderItem(len(attributeNames), header_item)
    #     header_item = qt.QTableWidgetItem("")
    #     self.tableWidget.setHorizontalHeaderItem(len(attributeNames) + 1, header_item)
    #     header_item = qt.QTableWidgetItem("")
    #     self.tableWidget.setHorizontalHeaderItem(len(attributeNames) + 2, header_item)
    #     header_item = qt.QTableWidgetItem("")
    #     self.tableWidget.setHorizontalHeaderItem(len(attributeNames) + 3, header_item)

    def initDisplayer(self):

        attributeNames = None
        try:
            if PyIPSDK.Shape2dColl == type(self.object):
                pass
            elif PyIPSDK.Pixels2d == type(self.object):
                pixels = PyIPSDK.toPyDict(self.object)['Coll']
                self.tableWidget.setRowCount(len(pixels))
                if len(pixels) > 0:
                    attributeNames = pixels[0].keys()
                    self.tableWidget.setColumnCount(len(attributeNames))
                    self.tableWidget.setColumnWidth(len(attributeNames),150*vrb.ratio)
                    self.tableWidget.setHorizontalHeaderLabels(attributeNames)
                    #self.setHeaders(attributeNames)
                self.displayObject = [pixels, attributeNames]
            elif PyIPSDK.PlanIndexedPixels2d == type(self.object):
                self.sliderAxis = wgt.SliderShowingValue(1,prefix="Plan X = ")
                self.sliderAxis.slider.setRange(0, self.object.getNbPlans()-1)
                self.sliderAxis.slider.setValue(0)
                self.layout.addWidget(self.sliderAxis, 2, 0)

                pixels = PyIPSDK.toPyDict(self.object.getValue(0))['Coll']
                if len(pixels) > 0:
                    attributeNames = pixels[0].keys()
                    self.tableWidget.setColumnCount(len(attributeNames))
                    self.tableWidget.setColumnWidth(len(attributeNames), 150 * vrb.ratio)
                    self.tableWidget.setHorizontalHeaderLabels(attributeNames)
                    #self.setHeaders(attributeNames)
                self.displayObject = [attributeNames]
                self.sliderAxis.SignalSliderChangedValue.connect(self.fillTable)
            elif PyIPSDK.Voxels3d == type(self.object):
                voxels = PyIPSDK.toPyDict(self.object)['Coll']
                self.tableWidget.setRowCount(len(voxels))
                if len(voxels) > 0:
                    attributeNames = voxels[0].keys()
                    self.tableWidget.setColumnCount(len(attributeNames))
                    self.tableWidget.setColumnWidth(len(attributeNames), 150 * vrb.ratio)
                    self.tableWidget.setHorizontalHeaderLabels(attributeNames)
                    #self.setHeaders(attributeNames)
                self.displayObject = [voxels, attributeNames]
            elif isinstance(self.object, wgt.Measure):
                if self.object.subType in ['HoughLines', 'HoughCircles2d','HoughSpheres3d']:
                    featureList = self.object.value
                    if self.object.subType == 'HoughSpheres3d':
                        featureList = PyIPSDK.toPyDict(featureList)["Coll"]
                    self.tableWidget.setRowCount(len(featureList))
                    if len(featureList) > 0:
                        attributeNames = featureList[0].keys()
                        self.tableWidget.setColumnCount(len(attributeNames))
                        self.tableWidget.setColumnWidth(len(attributeNames), 150 * vrb.ratio)
                        self.tableWidget.setHorizontalHeaderLabels(attributeNames)
                        #self.setHeaders(attributeNames)
                    self.displayObject = [featureList, attributeNames]

        except:
            traceback.print_exc(file=sys.stderr)
            print('ERROR: Could not initialize the display of a feature.')

    def fillTable(self):

        nothingToShow = False
        try:
            if PyIPSDK.Shape2dColl == type(self.object):
                pass
            elif PyIPSDK.Pixels2d == type(self.object):
                pixels = self.displayObject[0]
                attributeNames = self.displayObject[1]
                if len(pixels) > 0:
                    for row, pixel in enumerate(pixels, 0):
                        for nb, key in enumerate(attributeNames, 0):
                            cell = qt.QTableWidgetItem(fct.numberToScientific(pixel[key], 5))
                            self.tableWidget.setItem(row, nb, cell)
                else:
                    nothingToShow = True
            elif PyIPSDK.PlanIndexedPixels2d == type(self.object):
                attributeNames = self.displayObject[0]
                pixels = PyIPSDK.toPyDict(self.object.getValue(self.sliderAxis.getValue()))['Coll']
                if len(pixels) > 0:
                    self.tableWidget.setRowCount(len(pixels))
                    for row, pixel in enumerate(pixels, 0):
                        for nb, key in enumerate(attributeNames, 0):
                            cell = qt.QTableWidgetItem(fct.numberToScientific(pixel[key], 5))
                            self.tableWidget.setItem(row, nb, cell)
                else:
                    nothingToShow = True
            elif PyIPSDK.Voxels3d == type(self.object):
                voxels = self.displayObject[0]
                attributeNames = self.displayObject[1]
                if len(voxels) > 0:
                    for row, voxel in enumerate(voxels, 0):
                        for nb, key in enumerate(attributeNames, 0):
                            cell = qt.QTableWidgetItem(fct.numberToScientific(voxel[key], 5))
                            #fct.numberToScientific()
                            self.tableWidget.setItem(row, nb, cell)
                else:
                    nothingToShow = True
            elif isinstance(self.object, wgt.Measure):
                if self.object.subType in ['HoughLines', 'HoughCircles2d','HoughSpheres3d']:
                    circles = self.displayObject[0]
                    attributeNames = self.displayObject[1]
                    if len(circles) > 0:
                        for row, circle in enumerate(circles, 0):
                            for nb, key in enumerate(attributeNames, 0):
                                cell = qt.QTableWidgetItem(fct.numberToScientific(circle[key], 5))
                                self.tableWidget.setItem(row, nb, cell)
                    else:
                        nothingToShow = True

            try:
                self.labelNumberElement.setText("Number of elements : "+str(row+1))
            except:
                self.labelNumberElement.setText("")

            # try:
            #     cell = qt.QTableWidgetItem(str(row+1))
            #     self.tableWidget.setItem(0, nb+1, cell)
            # except:
            #     pass

        except:
            traceback.print_exc(file=sys.stderr)
            print('ERROR: Could not fill the table to display a feature.')

        if nothingToShow:
            self.tableWidget.setColumnCount(max(1, self.tableWidget.columnCount()))
            self.tableWidget.setRowCount(max(1, self.tableWidget.rowCount()))
            cell = qt.QTableWidgetItem('No value to display')
            self.tableWidget.setItem(0, 0, cell)


    def currentCellChanged(self):

        if PyIPSDK.Pixels2d == type(self.object):
            vrb.currentHarrisCorner2d = self.tableWidget.currentRow()
        if PyIPSDK.PlanIndexedPixels2d == type(self.object):
            zValue = self.sliderAxis.slider.value()
            try:
                vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.setChecked(True)
                vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.setValue(zValue)
            except:
                pass
            vrb.currentHarrisCorner2d = self.tableWidget.currentRow()

        if PyIPSDK.Voxels3d == type(self.object):
            vrb.currentHarrisCorner3d = self.tableWidget.currentRow()

            try:
                voxel = PyIPSDK.toPyDict(self.object)['Coll'][self.tableWidget.currentRow()]
                if vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                    vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.setValue(voxel["X"])
                if vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                    vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.setValue(voxel["Y"])
                if vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                    vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.setValue(voxel["Z"])
            except:
                pass



        if isinstance(self.object, wgt.Measure):
            if self.object.subType == 'HoughLines':
                vrb.currentHoughLine = self.tableWidget.currentRow()
            if self.object.subType == 'HoughCircles2d':
                vrb.currentHoughCircle = self.tableWidget.currentRow()
            if self.object.subType == 'HoughSpheres3d':
                vrb.currentHoughSphere = self.tableWidget.currentRow()

        vrb.mainWindow.imageViewer.getRoiImage(changeRoiImage=False)

    def display(self, xmlElement=None, boolShow=True):
        self.setWindowTitle(Dfct.childText(xmlElement, 'Name'))
        if boolShow:
            if self.isMaximized():
                self.showMaximized()
            else:
                self.showNormal()
            self.window().raise_()
            self.window().activateWindow()

    def stopDisplay(self):
        self.close()

    def saveFileResult(self):

        filename = qt.QFileDialog.getSaveFileName(self, "Save file as", "","(*.xls);;(*.csv)")
        if filename[1] == "(*.xls)":
            fct.convertToXlsFile(self.tableWidget,filename[0])
        if filename[1] == "(*.csv)":
            fct.convertToCsvFile(self.tableWidget,filename[0])



















