import sys
import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet
import UsefullVariables as vrb

# def maxElementID(xmlAllElements):
#     """
#     Returns the greatest ElementID
#     :param xmlAllElements: XML element containing all Elements
#     :return: greatest ElementID (-1 if None)
#     """
#     maxi = -1
#     for elemXml in xmlAllElements:
#         elementIDText = Dfct.childText(elemXml, 'ElementID')
#         if elementIDText is not None:
#             elementID = int(elementIDText)
#             maxi = max(elementID, maxi)
#     return maxi


# def actualizeElementIDs(xmlAllElements, xmlElementToDelete):
#     """
#     Updates the ElementIDs of xmlAllElements if necessary
#     This will check if the elementToDelete is useful somewhere or not
#     :param xmlAllElements: xml containing all elements
#     :param xmlElementToDelete: the element to delete
#     """
#     toDeleteID = int(Dfct.childText(xmlElementToDelete, 'ElementID'))
#     if Dfct.childText(xmlElementToDelete, 'Position') == '-1':
#         if isUseless(xmlAllElements, toDeleteID):
#             # Delete him + parents if they are useless and their pos is -1
#             remove(xmlAllElements, xmlElementToDelete)


# def remove(xmlAllElements, xmlElementToRemove):
#     """
#     Removes an element from xmlAllElements and reduce the ElementID of all greater elements
#     Also reduce it in parameters
#     :param xmlAllElements: xml containing all elements
#     :param xmlElementToRemove:
#     """
#     maxi = maxElementID(xmlAllElements)
#     toRemoveID = int(Dfct.childText(xmlElementToRemove, 'ElementID'))
#     xmlAllElements.remove(xmlElementToRemove)
#     for id in range(toRemoveID + 1, maxi + 1):
#         # reduce the ID of all greater elements
#         greaterElementXml = getElementWithID(xmlAllElements, id)
#         greaterElementElementID = Dfct.SubElement(greaterElementXml, 'ElementID')
#         greaterElementElementID.text = str(int(greaterElementElementID.text) - 1)
#         # reduce the ID of all parameters of this greater element
#         functionCallXml = Dfct.SubElement(greaterElementXml, 'FunctionCall')
#         parametersXml = Dfct.SubElement(functionCallXml, 'Parameters')
#         reduceParameters(parametersXml, toRemoveID)
#     for elemNode in xmlAllElements:
#         associatedIDnode = Dfct.SubElement(elemNode, 'AssociatedID')
#         reduceAssociatedID(associatedIDnode, toRemoveID)


def parametersIterator(parametersXml):
    """
    Iterates through the parameters to yield each value
    :param parametersXml: xmlElement of a list of Parameter_
    :return: the value of the parameter (and the values of the parameter's parameter)
    """
    for elem in parametersXml:
        if 'Parameter_' in elem.tag:
            # Look in all parameters
            for paramArgs in elem:
                if paramArgs.tag == 'Value':
                    # If the parameter has a simple value
                    yield paramArgs
                elif paramArgs.tag == 'Values':
                    # If the parameter contains its own parameters
                    for param in parametersIterator(paramArgs):
                        yield param


# def reduceParameters(parametersXml, id):
#     """
#     Reduce the ElementID of the parameters if they are greater than id
#     :param parametersXml: parameters where to look for
#     :param id: threshold, greater ElementID will be decreased
#     """
#     for paramArgs in parametersIterator(parametersXml):
#         if paramArgs.get('isElementID') == 'True':
#             # and this value is an elementID
#             try:
#                 if int(paramArgs.text) > id:
#                     paramArgs.text = str(int(paramArgs.text) - 1)
#             except:
#                 pass


# def reduceAssociatedID(xmlAssociatedID, id):
#     """
#     Reduce the ElementID of each AssociatedID if they are greater than id
#     :param xmlElement: elements where to look for
#     :param id: threshold, greater ElementID will be decreased
#     """
#     if xmlAssociatedID.text is not None:
#         associatedIDs = xmlAssociatedID.text.split(',')
#         textAsso = ''
#         for assoID in associatedIDs:
#             assoIDint = int(assoID)
#             if assoIDint >= id:
#                 textAsso += str(assoIDint-1)
#             else:
#                 textAsso += assoID
#             textAsso += ','
#         xmlAssociatedID.text = textAsso[:-1]


# def isUseless(xmlAllElements, elementID):
#     """
#     Returns True if an element is useless for the others
#     :param xmlAllElements: xmlAllElement where to search
#     :param elementID: id of the element we want to know this usefulness
#     :return: True if the element is useless
#     """
#     maxi = maxElementID(xmlAllElements)
#     for id in range(elementID+1, maxi+1):
#         # For each element with a greater ID, we look if currentID is useful
#         elem = getElementWithID(xmlAllElements, id)
#         if elem is None:
#             print('ERROR: xmlAllElements has a hole in ElementID', file=sys.stderr)
#         else:
#             functionCallXml = Dfct.SubElement(elem, 'FunctionCall')
#             parametersXml = Dfct.SubElement(functionCallXml, 'Parameters')
#             if appearsInParameters(elementID, parametersXml):
#                 return False
#     for id in range(maxi + 1):
#         elem = getElementWithID(xmlAllElements, id)
#         if id != elementID:
#             associatedID = Dfct.childText(elem, 'AssociatedID')
#             if associatedID is not None:
#                 associatedID = associatedID.split(',')
#                 if str(elementID) in associatedID:
#                     return False
#                     return False
#     return True


# def appearsInParameters(elementId, parametersXml):
#     """
#     Returns True if the elementID appears in the parameters
#     :param elementId: id we want to know if it appears
#     :param parametersXml: parameter where to search
#     :return: True if the element appears in the parameters
#     """
#     for paramArgs in parametersIterator(parametersXml):
#         if paramArgs.get('isElementID') == 'True':
#             # and this value is an elementID
#             try:
#                 if int(paramArgs.text) == elementId:
#                     return True
#             except:
#                 pass
#     return False


def findParentIDs(xmlElement):
    """
    Gives the ElementIDs of the parent of xmlElement
    :param xmlElement: xmlElement we want the parents
    :return: set of ID corresponding to the parents
    """
    parentIDs = set()
    functionCallXml = Dfct.SubElement(xmlElement, 'FunctionCall')
    parametersXml = Dfct.SubElement(functionCallXml, 'Parameters')
    for paramArgs in parametersIterator(parametersXml):
        if paramArgs.get('isElementID') == 'True':
            parentIDs.add(paramArgs)
    return parentIDs


def getElementWithID(xmlAllElements, id):
    """
    Returns the xmlElement corresponding to the ID
    :param xmlAllElements: where to look for the ID
    :param id: ElementID to look for
    :return: xmlElement corresponding to the ID, None otherwise
    """
    for elem in xmlAllElements:
        elementIDText = Dfct.childText(elem, 'ElementID')
        if elementIDText is not None:
            if elementIDText == id:
                return elem
    return None


# def actualizeAllElements(xmlAllElements):
#     """
#     Cleans the xmlAllElements, removes the useless ones
#     :param xmlAllElements: elmeent to clear
#     """
#     maxId = maxElementID(xmlAllElements)
#     for id in range(maxId, -1, -1):
#         element = getElementWithID(xmlAllElements, id)
#         actualizeElementIDs(xmlAllElements, element)