import os
import sys
import traceback

from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans

import numpy as np

import UsefullVariables as vrb
import DatabaseFunction as Dfct
import UsefullFunctions as fct
import xml.etree.ElementTree as xmlet

from DictionaryCustomObject import dictCustomObject

import LutsWidget

def createCrossPolygon():

    try:
        image = vrb.mainWindow.currentLabel.image
        if image.getSizeZ() == 1:
            centerX = vrb.barycenterX
            maxX = image.getSizeX()
            centerY = vrb.barycenterY
            maxY = image.getSizeY()
        else:
            if vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                centerX = vrb.barycenterY
                maxX = image.getSizeY()
                centerY = vrb.barycenterZ
                maxY = image.getSizeZ()
            elif vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                centerX = vrb.barycenterX
                maxX = image.getSizeX()
                centerY = vrb.barycenterZ
                maxY = image.getSizeZ()
            elif vrb.mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                centerX = vrb.barycenterX
                maxX = image.getSizeX()
                centerY = vrb.barycenterY
                maxY = image.getSizeY()

        polygonX = xmlet.Element('CrossPolygonX')
        allPointsElement = Dfct.SubElement(polygonX, "AllPoints")
        pointElement = xmlet.SubElement(allPointsElement, "Point")
        numElement = Dfct.SubElement(pointElement, "Num")
        numElement.text = str(0)
        pointXElement = Dfct.SubElement(pointElement, "PointX")
        pointXElement.text = str(centerX)
        pointYElement = Dfct.SubElement(pointElement, "PointY")
        pointYElement.text = str(0)
        pointElement = xmlet.SubElement(allPointsElement, "Point")
        numElement = Dfct.SubElement(pointElement, "Num")
        numElement.text = str(1)
        pointXElement = Dfct.SubElement(pointElement, "PointX")
        pointXElement.text = str(centerX)
        pointYElement = Dfct.SubElement(pointElement, "PointY")
        pointYElement.text = str(maxY)

        polygonY = xmlet.Element('CrossPolygonY')
        allPointsElement = Dfct.SubElement(polygonY, "AllPoints")
        pointElement = xmlet.SubElement(allPointsElement, "Point")
        numElement = Dfct.SubElement(pointElement, "Num")
        numElement.text = str(0)
        pointXElement = Dfct.SubElement(pointElement, "PointX")
        pointXElement.text = str(0)
        pointYElement = Dfct.SubElement(pointElement, "PointY")
        pointYElement.text = str(centerY)
        pointElement = xmlet.SubElement(allPointsElement, "Point")
        numElement = Dfct.SubElement(pointElement, "Num")
        numElement.text = str(1)
        pointXElement = Dfct.SubElement(pointElement, "PointX")
        pointXElement.text = str(maxX)
        pointYElement = Dfct.SubElement(pointElement, "PointY")
        pointYElement.text = str(centerY)

        return [polygonX,polygonY]

    except:
        traceback.print_exc(file=sys.stderr)
        return None

def addPointToPolygon(polygon,point,returnPointElement = False,allowSamePoint = False):

    modif = False
    stop = False
    maxSizeElement = Dfct.childText(polygon,"MaxSize")
    nbPoints = 0
    allPointsElement = Dfct.SubElement(polygon,"AllPoints")
    for child in allPointsElement:
        if child.tag == "Point":
            if str(Dfct.childText(child,"PointX"))!= str(point.x()) or str(Dfct.childText(child,"PointY"))!= str(point.y()) or allowSamePoint:
                nbPoints += 1
            else:
                stop = True

    if (maxSizeElement is None or maxSizeElement == '' or nbPoints < int(maxSizeElement)) and stop == False:
        pointElement = xmlet.SubElement(allPointsElement,"Point")
        numElement = Dfct.SubElement(pointElement, "Num")
        numElement.text = str(nbPoints)
        pointXElement = Dfct.SubElement(pointElement,"PointX")
        pointXElement.text = str(point.x())
        pointYElement = Dfct.SubElement(pointElement,"PointY")
        pointYElement.text = str(point.y())
        modif = True

    if returnPointElement:
        return modif,pointElement
    else:
        return modif

def addLabelingToScene(imageViewer,element,color = [255,255,255],lineSize=2,pointSize = 2,color2 = [0,0,255]):

    usefulSizeX, usefulSizeY = imageViewer.getUsefulSizeScene()

    color = [0,0,0]

    size = 100
    # angle = -135
    angle = 45
    value = Dfct.childText(element, "Value")

    graphicText = qt.QGraphicsTextItem()
    graphicText.setPlainText(value)
    rectWidth = graphicText.boundingRect().width()
    rectHeight = graphicText.boundingRect().height()

    QColor = QtGui.QColor(color[0], color[1], color[2])

    penPolygon = QtGui.QPen(QColor, lineSize)

    relativePolygon = []
    relativePointRef = imageViewer.realPointToScene(float(Dfct.childText(element, "PointX")), float(Dfct.childText(element, "PointY")))
    relativeQPointRef = QtCore.QPointF(relativePointRef[0], relativePointRef[1])
    relativePolygon.append(relativeQPointRef)

    pointX = relativePointRef[0] + size *np.cos(angle*np.pi/180)
    if (pointX < rectWidth and np.cos(angle*np.pi/180) < 0) or (pointX >usefulSizeX - rectWidth and np.cos(angle*np.pi/180) > 0):
        pointX = relativePointRef[0] - size *np.cos(angle*np.pi/180)
    pointY = relativePointRef[1] + size *np.sin(angle*np.pi/180)
    if (pointY < rectWidth and np.sin(angle * np.pi / 180) < 0) or (pointY > usefulSizeY - rectWidth and np.sin(angle * np.pi / 180) > 0):
        pointY = relativePointRef[1] - size *np.sin(angle*np.pi/180)

    relativeQPoint = QtCore.QPointF(pointX,pointY)
    relativePolygon.append(relativeQPoint)

    QLine = QtCore.QLineF(relativePolygon[0], relativePolygon[1])
    imageViewer.scene.addLine(QLine, penPolygon)

    if pointX<relativePointRef[0]:
        graphicText.setPos(pointX-rectWidth,pointY-rectHeight)
    else:
        graphicText.setPos(pointX, pointY - rectHeight)
    font = QtGui.QFont()
    font.setPointSize(12)
    graphicText.setFont(font)
    graphicText.setDefaultTextColor(QColor)
    imageViewer.scene.addItem(graphicText)

    # penRect = QtGui.QPen(QColor2, 2)
    # for i in range(-pointSize, pointSize + 1):
    #     rect = QtCore.QRectF(QtCore.QPointF(round(relativePointRef[0] + i), round(relativePointRef[1] + i)), QtCore.QSizeF(1, 1))
    #     imageViewer.scene.addRect(rect, penRect)
    #     rect = QtCore.QRectF(QtCore.QPointF(round(relativePointRef[0] - i), round(relativePointRef[1] + i)), QtCore.QSizeF(1, 1))
    #     imageViewer.scene.addRect(rect, penRect)

def addAngleToScene(imageViewer,angle, color = [255,0,0],lineSize=2,pointSize=3,textSize=12, boldValue = True,):


    try:

        selected = Dfct.childText(angle, "Selection")

        QColor = QtGui.QColor(color[0], color[1], color[2])
        pen = QtGui.QPen(QColor, lineSize)
        penRect = QtGui.QPen(QColor, 1)

        allPointsElement = Dfct.SubElement(angle, "AllPoints")
        for child in allPointsElement:
            if child.tag == "Point":
                if Dfct.childText(child, "Num") == "0":
                    relativePoint1 = imageViewer.realPointToScene(float(Dfct.childText(child, 'PointX')),float(Dfct.childText(child, 'PointY')))

        if selected == "True":
            for i in range(1, 6):
                if i != 5:
                    penRectSquare = QtGui.QPen(QtGui.QColor(255, 255, 255), 1)
                if i == 5:
                    penRectSquare = QtGui.QPen(QtGui.QColor(0, 0, 0), 1)
                square = QtCore.QRectF(QtCore.QPointF(relativePoint1[0] - int(i / 2), relativePoint1[1] - int(i / 2)),
                                       QtCore.QSizeF(i, i))
                imageViewer.scene.addRect(square, penRectSquare)
        else:
            rect = QtCore.QRectF(QtCore.QPointF(relativePoint1[0], relativePoint1[1] - pointSize),QtCore.QSizeF(pointSize, pointSize))
            imageViewer.scene.addRect(rect, penRect)

        if Dfct.childText(angle, 'NbPoints') in ["2","3"]:

            for child in allPointsElement:
                if child.tag == "Point":
                    if Dfct.childText(child, "Num") == "1":
                        relativeRef = imageViewer.realPointToScene(float(Dfct.childText(child, 'PointX')), float(Dfct.childText(child, 'PointY')))
            if selected == "True":
                for i in range(1, 6):
                    if i != 5:
                        penRectSquare = QtGui.QPen(QtGui.QColor(255, 255, 255), 1)
                    if i == 5:
                        penRectSquare = QtGui.QPen(QtGui.QColor(0, 0, 0), 1)
                    square = QtCore.QRectF(
                        QtCore.QPointF(relativeRef[0] - int(i / 2), relativeRef[1] - int(i / 2)),
                        QtCore.QSizeF(i, i))
                    imageViewer.scene.addRect(square, penRectSquare)
            else:
                rect = QtCore.QRectF(QtCore.QPointF(relativeRef[0], relativeRef[1] - pointSize),QtCore.QSizeF(pointSize, pointSize))
                imageViewer.scene.addRect(rect, penRect)

            QLine = QtCore.QLineF(QtCore.QPointF(relativePoint1[0], relativePoint1[1]),QtCore.QPointF(relativeRef[0], relativeRef[1]))
            imageViewer.scene.addLine(QLine, pen)

            if Dfct.childText(angle, 'NbPoints') == "3":

                for child in allPointsElement:
                    if child.tag == "Point":
                        if Dfct.childText(child, "Num") == "2":
                            relativePoint2 = imageViewer.realPointToScene(float(Dfct.childText(child, 'PointX')),float(Dfct.childText(child, 'PointY')))
                if selected == "True":
                    for i in range(1, 6):
                        if i != 5:
                            penRectSquare = QtGui.QPen(QtGui.QColor(255, 255, 255), 1)
                        if i == 5:
                            penRectSquare = QtGui.QPen(QtGui.QColor(0, 0, 0), 1)
                        square = QtCore.QRectF(
                            QtCore.QPointF(relativePoint2[0] - int(i / 2), relativePoint2[1] - int(i / 2)),
                            QtCore.QSizeF(i, i))
                        imageViewer.scene.addRect(square, penRectSquare)
                else:
                    rect = QtCore.QRectF(QtCore.QPointF(relativePoint2[0], relativePoint2[1] - pointSize),QtCore.QSizeF(pointSize, pointSize))
                    imageViewer.scene.addRect(rect, penRect)

                QLine = QtCore.QLineF(QtCore.QPointF(relativePoint2[0], relativePoint2[1]),QtCore.QPointF(relativeRef[0], relativeRef[1]))
                imageViewer.scene.addLine(QLine, pen)

                angle1 = -np.arctan2(relativePoint1[1]-relativeRef[1],relativePoint1[0]-relativeRef[0])
                angle2 = -np.arctan2(relativePoint2[1]-relativeRef[1],relativePoint2[0]-relativeRef[0])


                if abs(angle1-angle2) > np.pi:
                    if angle1<0:
                        angle1 += 2*np.pi
                    else:
                        angle2 += 2*np.pi

                lengthEllipse = min(np.sqrt((relativePoint1[0]-relativeRef[0])**2+(relativePoint1[1]-relativeRef[1])**2),
                                    np.sqrt((relativePoint2[0]-relativeRef[0])**2+(relativePoint2[1]-relativeRef[1])**2))

                ellipse = qt.QGraphicsEllipseItem(relativeRef[0]-(lengthEllipse/2),relativeRef[1]-(lengthEllipse/2),lengthEllipse,lengthEllipse)
                ellipse.setStartAngle(angle1*180*16/np.pi)
                ellipse.setSpanAngle((angle2-angle1)*180*16/np.pi)
                ellipse.setPen(pen)

                imageViewer.scene.addItem(ellipse)

                angleValue = abs(angle2-angle1)*180/np.pi

                angleMean = (angle1 + angle2)/2

                graphicText = imageViewer.scene.addText(str(int(angleValue*10)/10) + "°")
                font = QtGui.QFont()
                font.setPointSize(textSize)
                font.setBold(boldValue)
                graphicText.setFont(font)
                graphicText.setDefaultTextColor(QColor)

                posX = relativeRef[0] + lengthEllipse*np.cos(-angleMean)
                posY = relativeRef[1] + lengthEllipse*np.sin(-angleMean)
                graphicText.setPos(posX,posY)

    except:

        traceback.print_exc(file=sys.stderr)


# polygon is an xmlelement
def addPolygonToScene(imageViewer,polygon, color = [255,255,255], opacity=0, showPoints=True, dashLines=False, lineSize=2,
                      textSize = 12 , boldValue = True, pointMode = "bar", pointSize = 3,closed = None,lineMeasure = False,
                      calibration=None,mainWindow = None,nbSignificative = 3,roundValue = False):

    QColor = QtGui.QColor(color[0], color[1], color[2])
    if dashLines:
        penPolygon = QtGui.QPen(QColor, lineSize, QtCore.Qt.DashLine)
    else:
        penPolygon = QtGui.QPen(QColor, lineSize)
    allPointsElement = Dfct.SubElement(polygon, "AllPoints")
    selectedPolygon = Dfct.childText(polygon, "Selection")
    if closed is None:
        closed = Dfct.childText(polygon, "Closed")
    typePolygon = Dfct.SubElement(polygon, "Type").text
    relativePolygon = []
    realPolygon = []
    nbPoints = 0
    if typePolygon == "Rectangle3D":
        if imageViewer.parent.sliderAxis.radioButtonX.isChecked():
            allPoints = [["Y1","Z1"],["Y1","Z2"],["Y2","Z2"],["Y2","Z1"]]
        if imageViewer.parent.sliderAxis.radioButtonY.isChecked():
            allPoints = [["X1","Z1"],["X1","Z2"],["X2","Z2"],["X2","Z1"]]
        if imageViewer.parent.sliderAxis.radioButtonZ.isChecked():
            allPoints = [["X1","Y1"],["X1","Y2"],["X2","Y2"],["X2","Y1"]]
        for point in allPoints:
            relativePoint = imageViewer.realPointToScene(float(Dfct.childText(allPointsElement, point[0])), float(Dfct.childText(allPointsElement, point[1])))
            relativeQPoint = QtCore.QPointF(relativePoint[0], relativePoint[1])
            relativePolygon.append(relativeQPoint)
            nbPoints += 1
    else:
        for numChild in allPointsElement:
            for child in allPointsElement:
                if child.tag == "Point":
                    if Dfct.childText(child,"Num") == str(nbPoints):
                        realPolygon.append([float(Dfct.childText(child,"PointX")),float(Dfct.childText(child,"PointY"))])
                        relativePoint = imageViewer.realPointToScene(float(Dfct.childText(child,"PointX")),float(Dfct.childText(child,"PointY")))
                        relativeQPoint = QtCore.QPointF(relativePoint[0], relativePoint[1])
                        relativePolygon.append(relativeQPoint)
                        nbPoints+=1

    if closed == "True":
        QPolygon = QtGui.QPolygonF(relativePolygon)
        if opacity == 0:
            imageViewer.scene.addPolygon(QPolygon, penPolygon)
        else:
            brush = QtGui.QBrush(QColor)
            polygonOnScene = imageViewer.scene.addPolygon(QPolygon, pen=penPolygon, brush=brush)
            polygonOnScene.setOpacity(opacity)
    else:
        for i in range(len(relativePolygon)-1):
            QLine = QtCore.QLineF(relativePolygon[i],relativePolygon[i+1])
            imageViewer.scene.addLine(QLine, penPolygon)

    if showPoints:
        if nbPoints == 2:

            if (relativePolygon[0].y() - relativePolygon[1].y())==0:
                vectorDirector = [0,1]
            else:
                vectorDirector = [1,-(relativePolygon[0].x()-relativePolygon[1].x()) / (relativePolygon[0].y() - relativePolygon[1].y())]
                vectorDirector = [vectorDirector[0]/((vectorDirector[0]**2+vectorDirector[1]**2)**0.5),vectorDirector[1]/((vectorDirector[0]**2+vectorDirector[1]**2)**0.5)]

            vectorDirectorXElement = Dfct.SubElement(polygon, "VectorDirectorX")
            vectorDirectorXElement.text = str(vectorDirector[0])
            vectorDirectorYElement = Dfct.SubElement(polygon, "VectorDirectorY")
            vectorDirectorYElement.text = str(vectorDirector[1])
            pointSizeElement = Dfct.SubElement(polygon, "PointSize")
            pointSizeElement.text = str(pointSize)
            lineSizeElement = Dfct.SubElement(polygon, "LineSize")
            lineSizeElement.text = str(lineSize)
        for point in relativePolygon:
            if pointMode == "bar":
                penRect = QtGui.QPen(QColor, 1)
                if nbPoints != 2:
                    rect = QtCore.QRectF(QtCore.QPointF(point.x(),point.y()-pointSize ), QtCore.QSizeF(1, 2*pointSize))
                    imageViewer.scene.addRect(rect, penRect)
                if nbPoints == 2:
                    for i in range(-pointSize,pointSize+1):
                        rect = QtCore.QRectF(QtCore.QPointF((round(point.x() + i*vectorDirector[0])-2), (round(point.y()-1 + i*vectorDirector[1]))-2), QtCore.QSizeF(lineSize, lineSize))
                        #rect = QtCore.QRectF(QtCore.QPointF(round(point.x() + i*vectorDirector[0]), round(point.y() + i*vectorDirector[1])), QtCore.QSizeF(1, 1))
                        imageViewer.scene.addRect(rect, penRect)
                        
                    # write position points of the bar ends (short ruler) #used for the getImageOnScreen() function#

                    barPointElement = xmlet.SubElement(polygon, "BarPoint")
                    startBarPointX, startBarPointY = imageViewer.scenePointToRealPoint(round(point.x() + (-pointSize)*vectorDirector[0]), round(point.y() + (-pointSize)*vectorDirector[1]))
                    startBarPointXElement = Dfct.SubElement(barPointElement, "StartBarPointX")
                    startBarPointXElement.text = str(startBarPointX)
                    startBarPointYElement = Dfct.SubElement(barPointElement, "StartBarPointY")
                    startBarPointYElement.text = str(startBarPointY)
                    endBarPointX, endBarPointY = imageViewer.scenePointToRealPoint(round(point.x() + (pointSize+1)*vectorDirector[0]), round(point.y() + (pointSize+1)*vectorDirector[1]))
                    endBarPointXElement = Dfct.SubElement(barPointElement, "EndBarPointX")
                    endBarPointXElement.text = str(endBarPointX)
                    endBarPointYElement = Dfct.SubElement(barPointElement, "EndBarPointY")
                    endBarPointYElement.text = str(endBarPointY)
                    
            if pointMode == "circle":
                penRect = QtGui.QPen(QColor, pointSize)
                rect = QtCore.QRectF(QtCore.QPointF(point.x(), point.y()), QtCore.QSizeF(1, 1))
                imageViewer.scene.addRect(rect, penRect)
            if pointMode == "cross":
                penRect = QtGui.QPen(QColor, 1)
                for i in range(-pointSize, pointSize + 1):
                    rect = QtCore.QRectF(QtCore.QPointF(round(point.x() + i), round(point.y() + i)), QtCore.QSizeF(1, 1))
                    imageViewer.scene.addRect(rect, penRect)
                    rect = QtCore.QRectF(QtCore.QPointF(round(point.x() - i), round(point.y() + i)), QtCore.QSizeF(1, 1))
                    imageViewer.scene.addRect(rect, penRect)
            if pointMode == "crossVertical":
                penRect = QtGui.QPen(QColor, 1)
                for i in range(-pointSize, pointSize + 1):
                    rect = QtCore.QRectF(QtCore.QPointF(round(point.x()), round(point.y() + i)), QtCore.QSizeF(1, 1))
                    imageViewer.scene.addRect(rect, penRect)
                    rect = QtCore.QRectF(QtCore.QPointF(round(point.x() + i), round(point.y())), QtCore.QSizeF(1, 1))
                    imageViewer.scene.addRect(rect, penRect)

    if selectedPolygon == "True":
        for point in relativePolygon:
            for i in range(1,6):
                if i != 5:
                    penRectSquare = QtGui.QPen(QtGui.QColor(255,255,255), 1)
                if i == 5:
                    penRectSquare = QtGui.QPen(QtGui.QColor(0, 0, 0), 1)
                square = QtCore.QRectF(QtCore.QPointF(point.x()-int(i/2), point.y()-int(i/2)), QtCore.QSizeF(i, i))
                imageViewer.scene.addRect(square, penRectSquare)

    if lineMeasure:
        if len(realPolygon) == 2:
            if calibration is not None:
                if mainWindow.currentLabel.image.getVolumeGeometryType() == PyIPSDK.eVGT_2d:
                    xScale = calibration.getXScale()
                    yScale = calibration.getYScale()
                else:
                    if mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                        xScale = calibration.getYScale()
                        yScale = calibration.getZScale()
                    if mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                        xScale = calibration.getXScale()
                        yScale = calibration.getZScale()
                    if mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                        xScale = calibration.getXScale()
                        yScale = calibration.getYScale()
                try:
                    unit = calibration.getUnitStr()
                except:
                    unit = "um"
            else:
                xScale = 1
                yScale = 1
                unit = "px"

            sx = (realPolygon[0][0] - realPolygon[1][0])*xScale
            sy = (realPolygon[0][1] - realPolygon[1][1])*yScale
            dist = np.sqrt(sx*sx+sy*sy)

            if roundValue:
                text = str(int(round(dist))) + unit
            else:
                text = fct.numberCalibration(dist,nbSignificative) + unit

            graphicText = imageViewer.scene.addText(text)
            font = QtGui.QFont()
            font.setPointSize(textSize)
            font.setBold(boldValue)
            graphicText.setFont(font)
            graphicText.setDefaultTextColor(QColor)
            if realPolygon[0][0] > realPolygon[1][0]:
                relativePoint = imageViewer.realPointToScene(realPolygon[0][0],realPolygon[0][1])
            else:
                relativePoint = imageViewer.realPointToScene(realPolygon[1][0], realPolygon[1][1])

            if mainWindow.currentLabel.image.getVolumeGeometryType() == PyIPSDK.eVGT_2d:
                sizeX = mainWindow.currentLabel.image.getSizeX()
                sizeY = mainWindow.currentLabel.image.getSizeY()
            else:
                if mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                    sizeX = mainWindow.currentLabel.image.getSizeY()
                    sizeY = mainWindow.currentLabel.image.getSizeZ()
                if mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                    sizeX = mainWindow.currentLabel.image.getSizeX()
                    sizeY = mainWindow.currentLabel.image.getSizeZ()
                if mainWindow.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                    sizeX = mainWindow.currentLabel.image.getSizeX()
                    sizeY = mainWindow.currentLabel.image.getSizeY()
            maxPoint = imageViewer.realPointToScene(sizeX,sizeY)
            posX = min(relativePoint[0],maxPoint[0] - 125)
            posY = min(relativePoint[1],maxPoint[1] - 30)
            graphicText.setPos(posX,posY)
            
            uselessSizeX, uselessSizeY = imageViewer.getUselessSize()
            
            #write text position information in mho for getImageOnScreen function
            textPosX, textPosY = imageViewer.scenePointToRealPoint(posX+uselessSizeX, posY+uselessSizeY)

            # allPointsElement = Dfct.SubElement(polygon, "AllPoints")
            textPosXElement = Dfct.SubElement(polygon, "TextMeasurePosX")
            textPosXElement.text = str(textPosX)
            textPosYElement = Dfct.SubElement(polygon, "TextMeasurePosY")
            textPosYElement.text = str(textPosY)
            textElement = Dfct.SubElement(polygon, "TextMeasure")
            textElement.text = str(text)

def selectPointPolygon(imageViewer,point,polygon,distMin = 20):

    d1x,d1y = point.x(), point.y()
    (dx, dy) = imageViewer.realPointToScene(point.x(), point.y())
    distMove = distMin
    closestPoint = None
    if polygon != None:
        allPointsElement = Dfct.SubElement(polygon, "AllPoints")
        for child in allPointsElement:
            if child.tag == "Point":
                (px, py) = imageViewer.realPointToScene(float(Dfct.childText(child, "PointX")), float(Dfct.childText(child, "PointY")))
                p1x, p1y = float(Dfct.childText(child, "PointX")), float(Dfct.childText(child, "PointY"))
                if distMove >= ((px - dx) ** 2 + (py - dy) ** 2) ** 0.5:
                    distMove = ((px - dx) ** 2 + (py - dy) ** 2) ** 0.5
                    closestPoint = child
                if distMove >= (((p1x - d1x) ** 2 + (p1y - d1y) ** 2) ** 0.5)*3:
                    distMove = (((p1x - d1x) ** 2 + (p1y - d1y) ** 2) ** 0.5)*3
                    closestPoint = child

    return closestPoint, distMove

def selectPolygon(imageViewer,point,polygon,distMin = 20):

    pointRef = imageViewer.realPointToScene(point.x(), point.y())
    distMove = distMin
    returnPolygon = None
    nbPoints = 0
    allPointsElement = Dfct.SubElement(polygon, "AllPoints")
    for child in allPointsElement:
        if child.tag == "Point":
            if str(Dfct.childText(child, "PointX")) != str(point.x()) or str(Dfct.childText(child, "PointY")) != str(point.y()):
                nbPoints += 1
    if nbPoints > 1:
        i = 0
        point1, point2 = None, None
        for numChild in allPointsElement:
            for child in allPointsElement:
                if child.tag == "Point":
                    if Dfct.childText(child, "Num") == str(i%nbPoints):
                        point1 = imageViewer.realPointToScene(float(Dfct.childText(child, "PointX")), float(Dfct.childText(child, "PointY")))
            for child in allPointsElement:
                if child.tag == "Point":
                    if Dfct.childText(child, "Num") == str((i+1) % nbPoints):
                        point2 = imageViewer.realPointToScene(float(Dfct.childText(child, "PointX")), float(Dfct.childText(child, "PointY")))
            if point1 != None and point2 != None:
                distance = distancePointSegment(pointRef,point1,point2)
                if distance <= distMove:
                    returnPolygon = polygon
                    distMove = distance
                point1, point2 = None, None
                i+=1

    return returnPolygon,distMove

def distancePointPoint(pointRef,point1):

    px,py = pointRef[0],pointRef[1]
    px1,py1 = point1[0],point1[1]

    dist = ((px - px1) ** 2 + (py - py1) ** 2) ** 0.5

    return dist

def distancePointSegment(pointRef,point1,point2):

    px,py = pointRef[0],pointRef[1]
    px1,py1 = point1[0],point1[1]
    px2,py2 = point2[0],point2[1]

    try:
        pxH = px1 + (((px-px1)*(px1-px2) + (py-py1)*(py1-py2))*(px1-px2) / ((px1-px2)**2 + (py1-py2)**2))
        pyH = py1 + (((px-px1)*(px1-px2) + (py-py1)*(py1-py2))*(py1-py2) / ((px1-px2)**2 + (py1-py2)**2))

        if ((pxH >= px1 and pxH <= px2) or (pxH <= px1 and pxH >= px2)) and ((pyH >= py1 and pyH <= py2) or (pyH <= py1 and pyH >= py2)):
            distMove = ((px - pxH) ** 2 + (py - pyH) ** 2) ** 0.5
        else:
            distMove = min(((px - px1) ** 2 + (py - py1) ** 2) ** 0.5 , ((px - px2) ** 2 + (py - py2) ** 2) ** 0.5)
    except:
        distMove = min(((px - px1) ** 2 + (py - py1) ** 2) ** 0.5, ((px - px2) ** 2 + (py - py2) ** 2) ** 0.5)

    return distMove

def boundingBoxPolygon(polygon,precise=False):
    minX, maxX, minY, maxY = None, None, None, None
    for point in Dfct.SubElement(polygon, 'AllPoints'):
        if minX is None:
            minX = float(Dfct.childText(point, 'PointX'))
            maxX = float(Dfct.childText(point, 'PointX'))
            minY = float(Dfct.childText(point, 'PointY'))
            maxY = float(Dfct.childText(point, 'PointY'))
        else:
            minX = min(minX, float(Dfct.childText(point, 'PointX')))
            maxX = max(maxX, float(Dfct.childText(point, 'PointX')))
            minY = min(minY, float(Dfct.childText(point, 'PointY')))
            maxY = max(maxY, float(Dfct.childText(point, 'PointY')))

    if precise == False:
        return int(minX), int(minY), int(maxX - minX), int(maxY - minY)
    else:
        for point in Dfct.SubElement(polygon, 'AllPoints'):
            if float(Dfct.childText(point, 'PointX')) == minX:
                refMinY = float(Dfct.childText(point, 'PointY'))
            if float(Dfct.childText(point, 'PointX')) == maxX:
                refMaxY = float(Dfct.childText(point, 'PointY'))
        if refMinY > refMaxY:
            # return maxX, minY, minX - maxX, maxY - minY
            return minX, maxY, maxX - minX, minY - maxY
        else:
            return minX, minY, maxX - minX, maxY - minY

def barycenterPolygon(polygon):
    barycenterX = 0
    barycenterY = 0
    nbPoints = 0
    for point in Dfct.SubElement(polygon, 'AllPoints'):
            barycenterX += float(Dfct.childText(point, 'PointX'))
            barycenterY += float(Dfct.childText(point, 'PointY'))
            nbPoints += 1

    barycenterX = barycenterX/nbPoints
    barycenterY = barycenterY/nbPoints

    return barycenterX,barycenterY

def centerListPolygon(listPolygon):
    minX, maxX, minY, maxY = None, None, None, None
    for polygon in listPolygon:
        minXPolygon,minYPolygon,sizeX,sizeY = boundingBoxPolygon(polygon)
        maxXPolygon = minXPolygon + sizeX
        maxYPolygon = minYPolygon + sizeY
        if minX is None:
            minX = minXPolygon
            minY = minYPolygon
            maxX = maxXPolygon
            maxY = maxYPolygon
        else:
            minX = min(minX,minXPolygon)
            minY = min(minY,minYPolygon)
            maxX = max(maxX,maxXPolygon)
            maxY = max(maxY,maxYPolygon)

    centerX = (minX+maxX)/2
    centerY = (minY+maxY)/2

    return centerX,centerY

def polygonIterator(elementPolygon,level):

    for polyWithHoles in elementPolygon:
        if polyWithHoles.hasHoles():
            yield polyWithHoles.getExteriorPolygon(), level
            yield from polygonIterator(polyWithHoles.getPolygonHoles(), level + 1)
        else:
            yield polyWithHoles.getExteriorPolygon(), level

def addShapesToScene(imageViewer,shapes,lineSize=2,pointMode ="circle",pointSize = 3):

    QColor = QtGui.QColor(200,100,0)
    penPolygon = QtGui.QPen(QColor, lineSize)

    coll = shapes.getColl()
    for label in range(1,len(coll)):
        try:
            elementPolygon = coll[label]
            elementPolygon = elementPolygon.getPolygonWithHolesColl()
            for polygon,level in polygonIterator(elementPolygon,0):
                relativePolygon = []
                nbPoints = 0
                points = polygon.getPointColl()
                for point in points:
                    relativePoint = imageViewer.realPointToScene(point.x,point.y)
                    relativeQPoint = QtCore.QPointF(relativePoint[0], relativePoint[1])
                    relativePolygon.append(relativeQPoint)
                    nbPoints += 1

                QPolygon = QtGui.QPolygonF(relativePolygon)
                imageViewer.scene.addPolygon(QPolygon, penPolygon)
        except:
            pass

            # for point in relativePolygon:
            #     if pointMode == "circle":
            #         penRect = QtGui.QPen(QColor, 5)
            #         rect = QtCore.QRectF(QtCore.QPointF(point.x(), point.y()), QtCore.QSizeF(2, 2))
            #         imageViewer.scene.addRect(rect, penRect)

# def addShapesToScene(imageViewer,shapes,lineSize=2,pointMode ="circle",pointSize = 3):
#
#     QColor = QtGui.QColor(200,100,0)
#     penPolygon = QtGui.QPen(QColor, lineSize)
#
#     coll = shapes.getColl()
#     # for label in range(1,len(coll)):
#     for label in range(1,len(coll)):
#         try:
#             elementPolygon = coll[label]
#             elementPolygon = elementPolygon.getPolygonWithHolesColl()
#             for polygon,level in polygonIterator(elementPolygon,0):
#
#                 relativePolygon = []
#                 nbPoints = 0
#                 points = polygon.getPointColl()
#                 for point in points:
#                     relativePoint = imageViewer.realPointToScene(point.x,point.y)
#                     relativeQPoint = QtCore.QPointF(relativePoint[0], relativePoint[1])
#                     relativePolygon.append(relativeQPoint)
#                     nbPoints += 1
#
#             QPolygon = QtGui.QPolygonF(relativePolygon)
#             imageViewer.scene.addPolygon(QPolygon, penPolygon)
#
#         except:
#             pass
#
#             # for point in relativePolygon:
#             #     if pointMode == "circle":
#             #         penRect = QtGui.QPen(QColor, 5)
#             #         rect = QtCore.QRectF(QtCore.QPointF(point.x(), point.y()), QtCore.QSizeF(2, 2))
#             #         imageViewer.scene.addRect(rect, penRect)


def drawPoint(imageViewer, relativePoint, pointMode, pen, formSize=None, resizeFactor=1):
    if pointMode == "cross":
        if formSize is None:
            formSize = 3
        line = QtCore.QLineF(relativePoint[0] - formSize * resizeFactor, relativePoint[1], relativePoint[0] + formSize * resizeFactor, relativePoint[1])
        imageViewer.scene.addLine(line, pen)
        line = QtCore.QLineF(relativePoint[0], relativePoint[1] - formSize * resizeFactor, relativePoint[0], relativePoint[1] + formSize * resizeFactor)
        imageViewer.scene.addLine(line, pen)
    elif pointMode == 'rectangle':
        if formSize is None:
            formSize = 1
        rect = QtCore.QRectF(QtCore.QPointF(relativePoint[0], relativePoint[1]), QtCore.QSizeF(formSize * resizeFactor * 2, formSize * resizeFactor * 2))
        imageViewer.scene.addRect(rect, pen)
    elif pointMode == 'pixel':
        rect = QtCore.QRectF(QtCore.QPointF(relativePoint[0], relativePoint[1]), QtCore.QSizeF(1, 1))
        imageViewer.scene.addRect(rect, pen)
    elif pointMode == 'circle':
        if formSize is None:
            formSize = 2
        circleRect = QtCore.QRectF(QtCore.QPointF(relativePoint[0] - formSize * resizeFactor, relativePoint[1] - formSize * resizeFactor),
                                   QtCore.QPointF(relativePoint[0] + formSize * resizeFactor, relativePoint[1] + formSize * resizeFactor))
        imageViewer.scene.addEllipse(circleRect, pen)

def addPointsToScene(imageViewer, pixels, color=QtGui.QColor(255, 0, 0), pointMode='cross',formSize=None,resizeFactor = None,harrisCorner = False):

    roiSizeX, roiSizeY = imageViewer.getRoiSize()
    usefulSizeX, usefulSizeY = imageViewer.getUsefulSizeScene()
    ratio = (roiSizeX / usefulSizeX + roiSizeY / usefulSizeY) / 2

    if resizeFactor is None:
        resizeFactor = max(1, 1 / ratio)

    pen = QtGui.QPen(color, resizeFactor)

    if harrisCorner:
        # penSelected = QtGui.QPen(QtGui.QColor(255, 130, 0), 2.5 * resizeFactor)
        penSelected = QtGui.QPen(QtGui.QColor(0,0,255), 2.5 * resizeFactor)

    try:
        pixels = PyIPSDK.toPyDict(pixels)['Coll']
    except:
        pass
    numPoint = 0
    for pixel in pixels:
        posX, posY = pixel['X'], pixel['Y']
        relativePoint = imageViewer.realPointToScene(float(posX), float(posY))
        if harrisCorner and numPoint == vrb.currentHarrisCorner2d:
            drawPoint(imageViewer, relativePoint, pointMode, penSelected, resizeFactor=resizeFactor, formSize=formSize)
        else:
            drawPoint(imageViewer, relativePoint, pointMode, pen, resizeFactor=resizeFactor,formSize=formSize)
        numPoint+=1


def addPoints3dToScene(imageViewer, voxels, color=QtGui.QColor(255, 0, 0), pointMode='cross'):
    if imageViewer.widgetImage.image.getSizeZ() > 1:
        roiSizeX, roiSizeY = imageViewer.getRoiSize()
        usefulSizeX, usefulSizeY = imageViewer.getUsefulSizeScene()
        ratio = (roiSizeX / usefulSizeX + roiSizeY / usefulSizeY) / 2
        resizeFactor = max(1, 1 / ratio)

        pen = QtGui.QPen(color, resizeFactor)

        penSelected = QtGui.QPen(QtGui.QColor(0,0,255), 2.5 * resizeFactor)

        voxels = PyIPSDK.toPyDict(voxels)['Coll']
        numVoxel = 0
        for voxel in voxels:
            relativePoint = None
            if imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked() and voxel["X"] == imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value():
                relativePoint = imageViewer.realPointToScene(float(voxel["Y"]), float(voxel["Z"]))
            elif imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked() and voxel["Y"] == imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value():
                relativePoint = imageViewer.realPointToScene(float(voxel["X"]), float(voxel["Z"]))
            elif imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked() and voxel["Z"] == imageViewer.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value():
                relativePoint = imageViewer.realPointToScene(float(voxel["X"]), float(voxel["Y"]))
            if relativePoint is not None:
                if numVoxel == vrb.currentHarrisCorner3d:
                    drawPoint(imageViewer, relativePoint, pointMode, penSelected, resizeFactor=resizeFactor)
                else:
                    drawPoint(imageViewer, relativePoint, pointMode, pen, resizeFactor=resizeFactor)
            numVoxel += 1


def addCirclesToScene(imageViewer, circles, color=QtGui.QColor(255, 0, 0),houghCircle=False):
    roiSizeX, roiSizeY = imageViewer.getRoiSize()
    usefulSizeX, usefulSizeY = imageViewer.getUsefulSizeScene()
    ratio = (roiSizeX / usefulSizeX + roiSizeY / usefulSizeY) / 2
    resizeFactor = 1 / ratio

    pen = QtGui.QPen(color, resizeFactor)

    if houghCircle:
        penSelected = QtGui.QPen(QtGui.QColor(0, 255, 0), 2.5*resizeFactor)

    numCircle = 0

    for circle in circles:
        relativePoint = imageViewer.realPointToScene(float(circle["X"]), float(circle["Y"]))

        if houghCircle and numCircle == vrb.currentHoughCircle:
            drawPoint(imageViewer, relativePoint, 'circle', formSize=circle['Radius'], pen=penSelected, resizeFactor=resizeFactor)
        else:
            drawPoint(imageViewer, relativePoint, 'circle', formSize=circle['Radius'], pen=pen, resizeFactor=resizeFactor)

        numCircle+=1

def addSpheresToScene(imageViewer, spheres, color=QtGui.QColor(255, 0, 0),houghSphere=False):

    roiSizeX, roiSizeY = imageViewer.getRoiSize()
    usefulSizeX, usefulSizeY = imageViewer.getUsefulSizeScene()
    ratio = (roiSizeX / usefulSizeX + roiSizeY / usefulSizeY) / 2
    resizeFactor = 1 / ratio
    pen = QtGui.QPen(color, resizeFactor)
    if houghSphere:
        penSelected = QtGui.QPen(QtGui.QColor(0, 255, 0), 2.5*resizeFactor)

    numSphere = 0

    spheres = PyIPSDK.toPyDict(spheres)["Coll"]

    for sphere in spheres:
        sliderAxis = imageViewer.parent.sliderAxis
        if sliderAxis.radioButtonX.isChecked():
            centerX = float(sphere["Y"])
            centerY = float(sphere["Z"])
            radius = sphere['Radius']**2 - (float(sphere["X"])-sliderAxis.sliderX.slider.value())**2
        elif sliderAxis.radioButtonY.isChecked():
            centerX = float(sphere["X"])
            centerY = float(sphere["Z"])
            radius = sphere['Radius']**2 - (float(sphere["Y"])-sliderAxis.sliderY.slider.value())**2
        elif sliderAxis.radioButtonZ.isChecked():
            centerX = float(sphere["X"])
            centerY = float(sphere["Y"])
            radius = sphere['Radius']**2 - (float(sphere["Z"])-sliderAxis.sliderZ.slider.value())**2

        if radius > 0:
            relativePoint = imageViewer.realPointToScene(centerX, centerY)
            if houghSphere and numSphere == vrb.currentHoughSphere:
                drawPoint(imageViewer, relativePoint, 'circle', formSize=np.sqrt(radius), pen=penSelected, resizeFactor=resizeFactor)
            else:
                drawPoint(imageViewer, relativePoint, 'circle', formSize=np.sqrt(radius), pen=pen, resizeFactor=resizeFactor)

        numSphere += 1

def addLinesToScene(imageViewer, lines, color=QtGui.QColor(255, 0, 0),houghLine=False):
    roiSizeX, roiSizeY = imageViewer.getRoiSize()
    usefulSizeX, usefulSizeY = imageViewer.getUsefulSizeScene()
    ratio = (roiSizeX / usefulSizeX + roiSizeY / usefulSizeY) / 2
    resizeFactor = max(1, 1 / ratio)

    sizeX, sizeY = imageViewer.widgetImage.image.getSizeX(), imageViewer.widgetImage.image.getSizeY()

    pen = QtGui.QPen(color, resizeFactor)

    if houghLine:
        penSelected = QtGui.QPen(QtGui.QColor(0, 255, 0), 2.5*resizeFactor)

    numLine = 0

    for line in lines:
        rho, theta = line['Rho'], line['Theta']
        points = segmentFromLine(rho, theta, sizeX, sizeY)
        if len(points) == 2:
            relativePoint1 = imageViewer.realPointToScene(points[0][0], points[0][1])
            relativePoint2 = imageViewer.realPointToScene(points[1][0], points[1][1])
            line = QtCore.QLineF(relativePoint1[0], relativePoint1[1], relativePoint2[0], relativePoint2[1])
            if houghLine and numLine == vrb.currentHoughLine:
                imageViewer.scene.addLine(line, penSelected)
            else:
                imageViewer.scene.addLine(line, pen)

        numLine+=1

def segmentFromLine(rho, theta, sizeX, sizeY):
    sizeX = sizeX-1
    sizeY = sizeY-1
    cosT, sinT = np.cos(theta), np.sin(theta)
    outPoints = []
    if cosT == 0:
        outPoints.append([0, rho/sinT])
        outPoints.append([sizeX, rho/sinT])
    elif sinT == 0:
        outPoints.append([rho/cosT, 0])
        outPoints.append([rho/cosT, sizeY])
    else:
        # x = (rho - y * sinT) / cosT
        # y = (rho - x * cosT) / sinT
        # point1 = [0, round(rho/sinT)]
        # point2 = [sizeX, round((rho-sizeX*cosT)/sinT)]
        # point3 = [round(rho/cosT), 0]
        # point4 = [round((rho-sizeY*sinT)/cosT), sizeY]
        point1 = [0, (rho/sinT)]
        point2 = [sizeX, ((rho-sizeX*cosT)/sinT)]
        point3 = [(rho/cosT), 0]
        point4 = [((rho-sizeY*sinT)/cosT), sizeY]
        for point in [point1, point2, point3, point4]:
            if 0 <= point[0] <= sizeX and 0 <= point[1] <= sizeY:
                pointAlreadyIn = False
                for outPoint in outPoints:
                    if point[0] == outPoint[0] and point[1] == outPoint[1]:
                        pointAlreadyIn = True
                if not pointAlreadyIn:
                    outPoints.append(point)
    return outPoints

def addVectorialFieldToScene(imageViewer,vectorialFiled):

    maxValue = 0

    for x in vectorialFiled:
        for y in vectorialFiled[x]:
            maxValue = max(maxValue,np.sqrt(vectorialFiled[x][y][0]**2 + vectorialFiled[x][y][1]**2))

    for x in vectorialFiled:
        for y in vectorialFiled[x]:

            dx = vectorialFiled[x][y][0]
            dy = vectorialFiled[x][y][1]

            colorRatio = np.sqrt(dx ** 2 + dy ** 2) / maxValue
            r,g,b = fct.getColorFromLut(LutsWidget.lutMagma, colorRatio)

            color = QtGui.QColor(r, g, b)

            pt1x,pt1y,pt2x,pt2y = calculateArrowHead(x, y, dx, dy)

            relativePointStart = imageViewer.realPointToScene(x, y)
            relativePointEnd = imageViewer.realPointToScene(x+dx, y+dy)
            relativePoint1 = imageViewer.realPointToScene(pt1x, pt1y)
            relativePoint2 = imageViewer.realPointToScene(pt2x, pt2y)

            line = QtCore.QLineF(relativePointStart[0], relativePointStart[1], relativePointEnd[0], relativePointEnd[1])
            line1 = QtCore.QLineF(relativePointEnd[0], relativePointEnd[1], relativePoint1[0], relativePoint1[1])
            line2 = QtCore.QLineF(relativePointEnd[0], relativePointEnd[1], relativePoint2[0], relativePoint2[1])

            pen = QtGui.QPen(color, 1)

            imageViewer.scene.addLine(line, pen)
            imageViewer.scene.addLine(line1, pen)
            imageViewer.scene.addLine(line2, pen)

    # print(vectorialFiled)

def calculateArrowHead(x, y, dx, dy):
    endX = x + dx
    endY = y + dy

    angle = np.arctan2(dy, dx)
    arrowLength = np.hypot(dx, dy) * 0.2

    point1X = endX - arrowLength * np.cos(angle - np.pi / 4)
    point1Y = endY - arrowLength * np.sin(angle - np.pi / 4)

    point2X = endX - arrowLength * np.cos(angle + np.pi / 4)
    point2Y = endY - arrowLength * np.sin(angle + np.pi / 4)

    return point1X, point1Y, point2X, point2Y

def addArrowForVectorialField(imageViewer,x,y,dx,dy,maxValue):

    colorRatio = np.sqrt(dx**2+dy**2)/maxValue
    color = fct.getColorFromLut(LutsWidget.lutJet,colorRatio)

    start = QPointF(x, y)
    end = QPointF(x + dx, y + dy)

    # Ajouter la ligne principale de la flèche
    line = qt.QGraphicsLineItem(start.x(), start.y(), end.x(), end.y())
    pen = QtGui.QPen()
    pen.setWidth(2)
    pen.setColor(color)
    line.setPen(pen)
    imageViewer.scene.addItem(line)

    # Calcul de la taille proportionnelle de la tête de la flèche
    arrowLength = np.hypot(dx, dy) * 0.1
    angle = np.arctan2(dy, dx)

    # Points de la tête de la flèche
    arrowP1 = QPointF(
        end.x() - arrowLength * np.cos(angle - np.pi / 6),
        end.y() - arrowLength * np.sin(angle - np.pi / 6),
    )
    arrowP2 = QPointF(
        end.x() - arrowLength * np.cos(angle + np.pi / 6),
        end.y() - arrowLength * np.sin(angle + np.pi / 6),
    )

    arrowHead = QtGui.QPolygonF([end, arrowP1, arrowP2])
    imageViewer.scene.addPolygon(arrowHead, pen, pen.brush())

