import sys
import random
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet
import UsefullFunctions as fct

import PyIPSDK

import UsefullVariables as vrb

import UsefullDisplay as display

class CentroidDisplayer(display.TableWidgetWindow):

    def __init__(self, centroids):
        super().__init__()

        self.centroids = centroids

        ddict = {}

        for i in range(len(self.centroids.coll)):
            if type(self.centroids) == PyIPSDK.ClustersCenters:
                centers = self.centroids.coll[i].elements
            elif type(self.centroids) == PyIPSDK.KKMeansCentroids:
                centers = self.centroids.coll[i].dictionary

            for j in range(len(centers)+1):
                if j == 0:
                    name = "Centroid"
                else:
                    if len(centers) == 1:
                        name = "Value"
                    else:
                        name = "Channel " + str(i - 1)

                if name not in ddict:
                    ddict[name] = []
                if j == 0:
                    ddict[name].append(i+1)
                else:
                    ddict[name].append(fct.numberCalibration(centers[j-1]))

        self.tableWidget.ddict = ddict
        self.tableWidget.loadDictionary()
        self.resize(400*vrb.ratio,200*vrb.ratio)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)


