import os

import xml.etree.ElementTree as xmlet
from xml.dom import minidom

import UsefullVariables as vrb

import numpy as np

import PyIPSDK

def prettify(elem):

    rough_string = xmlet.tostring(elem, 'utf-8')
    reparsed = minidom.parseString(rough_string)
    return reparsed.toprettyxml(indent="  ")

def SubElement(element,text):

    toReturn=None
    for child in element:
        if child.tag==text:
            toReturn=child
    if toReturn is None:
        toReturn = xmlet.SubElement(element, text)
    return toReturn

def containsTag(element,tag):

    isFound = False
    for child in element:
        if child.tag == tag:
            isFound = True
    return isFound

def removeElement(xmlParent, xmlToRemove):
    for childNode in xmlParent:
        if childNode == xmlToRemove:
            xmlParent.remove(xmlToRemove)
            return xmlParent
        else:
            res = removeElement(childNode, xmlToRemove)
            if res is not None:
                return res
    return None


def childIterator(xmlNode, tag):
    for child in xmlNode:
        if child.tag == tag:
            yield child
        else:
            for subChild in childIterator(child, tag):
                yield subChild


def contains(xmlParent, xmlToFind):
    res = False
    for child in xmlParent:
        if child == xmlToFind:
            return True
        else:
            res = res or contains(child, xmlToFind)
    return res

def childText(element,tag):

    text=None
    if element != None:
        for child in element:
            if child.tag==tag:
                text=child.text
                try:
                    if child.get('ASCII') == str(True):
                        text = convertTextFromAscii(text)
                except:
                    pass
    return text

def clearElement(element):

    while len(element)>=1:
        element.remove(element[0])

def copySubElement(parent,element):

    if element != None:
        elementCopy = xmlet.SubElement(parent,element.tag)
        elementCopy.text=element.text
        for child in element:
            copySubElement(elementCopy,child)

def copyXmlElement(element):
    strElement = xmlet.tostring(element)
    return xmlet.fromstring(strElement)
    # elementCopy=xmlet.Element(element.tag)
    # elementCopy.text = element.text
    # for child in element:
    #     copySubElement(elementCopy,child)
    #
    # return (elementCopy)

def createSubElementLineEdit(element,lineEdit,tag):

    lineEditElement = SubElement(element,tag)
    valueElement = SubElement(lineEditElement,"Value")
    valueElement.text = lineEdit.text()
    placeHolderElement = SubElement(lineEditElement,"PlaceHolder")
    placeHolderElement.text = lineEdit.placeholderText()

def readElementLineEdit(element,lineEdit,tag):

    lineEditElement = SubElement(element, tag)
    try:
        lineEdit.setText(childText(lineEditElement,"Value"))
        # lineEdit.setPlacerholderText(childText(lineEditElement,"PlaceHolder"))
    except:
        pass

def getValueElementLineEdit(element,tag,typeValue="int"):

    lineEditElement = SubElement(element,tag)
    value = childText(lineEditElement, "Value")
    if value is None or value == "":
        value = childText(lineEditElement, "PlaceHolder")

    if value is not None and value != "":
        if typeValue == "int":
            value = int(float(value))
        elif typeValue == "float":
            value = float(value)

    return value

def createSubElementCheckBox(element,checkBox,tag):

    checkBoxElement = SubElement(element, tag)
    if checkBox.isChecked():
        checkBoxElement.text = "True"
    else:
        checkBoxElement.text = "False"

def readElementCheckBox(element,checkBox,tag):

    checkBoxElement = SubElement(element, tag)
    checkBox.setChecked(checkBoxElement.text == "True")

def getValueElementCheckBox(element, tag):

    checkBoxElement = SubElement(element, tag)
    if checkBoxElement.text == "True":
        value = True
    else:
        value = False

    return value

def createSubElementComboBox(element,comboBox,tag):

    comboBoxElement = SubElement(element, tag)
    comboBoxElement.text = str(comboBox.currentIndex())

def readElementComboBox(element,comboBox,tag):

    comboBoxElement = SubElement(element, tag)
    if comboBoxElement.text is not None and comboBoxElement.text != "":
        comboBox.setCurrentIndex(int(comboBoxElement.text))

def getValueElementComboBox(element, tag):
    comboBoxElement = SubElement(element, tag)
    if comboBoxElement.text is not None and comboBoxElement.text != "":
        value = int(comboBoxElement.text)
    else:
        value = 0

    return value

def createSubElementComboBoxText(element,comboBox,tag):

    comboBoxElement = SubElement(element, tag)
    comboBoxElement.text = comboBox.currentText()

def readElementComboBoxText(element,comboBox,tag):

    comboBoxElement = SubElement(element, tag)
    if comboBoxElement.text is not None and comboBoxElement.text != "":
        comboBox.setCurrentText(comboBoxElement.text)
    if comboBox.currentIndex() == -1:
        comboBox.setCurrentIndex(0)

def getValueElementComboBoxText(element, tag):
    comboBoxElement = SubElement(element, tag)
    if comboBoxElement.text is not None and comboBoxElement.text != "":
        value = comboBoxElement.text
    else:
        value = ""

    return value

def cleanDirectory(filename):

    for file in os.listdir(filename):

        url = filename + "/" + file
        try:
            os.remove(url)
        except:
            pass

def updateInfosetXmlElement(element,elementRef):

    verif = False

    if element.tag == elementRef.tag and element.tag != "Custom":
        if element.tag == "Measure":
            if childText(element, "UserName") == childText(elementRef, "UserName"):
                verif = True
        else:
            verif = True

    if verif:

        if elementRef.text != "" and elementRef.text is not None:
            element.text = elementRef.text
        try:
            infoCheckState = elementRef.get('CheckState')
            if infoCheckState != "" and infoCheckState is not None:
                element.set('CheckState', infoCheckState)
        except:
            pass

        if childText(element, "UserName") != "Relative Size":
            for child in element:
                for childRef in elementRef:
                    if child.tag == childRef.tag:
                        if child.tag == "Measure":
                            if childText(child,"UserName") == childText(childRef,"UserName"):
                                updateInfosetXmlElement(child,childRef)
                        else:
                            updateInfosetXmlElement(child, childRef)

def convertTextToAscii(text):

    newText = ''
    if text != None:
        for char in text:
            newText += str(ord(char)) + '.'

        if newText != '':
            newText = newText[:-1]

    return newText

def convertTextFromAscii(text):

    newText = ''
    if text != '' and text != None:
        textSplit = text.split('.')
        for number in textSplit:
            char = chr(int(number))
            newText += char

    return newText

def getRatioConversion(xmlElement):

    pixels = 1
    measure = 1
    unit = "px"

    if childText(xmlElement,"Pixels") != None and childText(xmlElement,"Pixels") != '':
        pixels = float(childText(xmlElement,"Pixels"))
    if childText(xmlElement,"Measure") != None and childText(xmlElement,"Measure") != '':
        measure = float(childText(xmlElement,"Measure"))
    if childText(xmlElement,"Unit") != None:
        unit = childText(xmlElement,"Unit")

    if unit == "m":
        factor = 1000000
    if unit == "cm":
        factor = 10000
    if unit == "mm":
        factor = 1000
    if unit == "um":
        factor = 1
    if unit == "nm":
        factor = 0.001
    if unit == "px":
        factor = 1

    ratioConversion = np.power(measure*factor/pixels,2)

    return ratioConversion

def saveXmlElement(xmlElement, fileName, forceSave=True):

    if vrb.debugMode or forceSave:
        for elem in xmlElement.iter('*'):
            if elem.text is not None:
                elem.text = elem.text.strip()
            if elem.tail is not None:
                elem.tail = elem.tail.strip()
        elem = prettify(xmlElement)
        try:
            os.makedirs(os.path.dirname(fileName), exist_ok=True)
            filexml = open(fileName, 'w')
            filexml.write(elem)
            filexml.close()
        except Exception as e:
            print('ERROR: could not save the MHO file: ' + fileName)

def adjustCheckStateInfoset(xmlElement,returnElement = False):

    allTrue = True
    allFalse = True
    oneElement = False
    for child in xmlElement:
        if child.tag != "Measure":
            allTrueChild,allFalseChild,oneElementChild = adjustCheckStateInfoset(child)
            if allTrueChild == False:
                allTrue = False
            if allFalseChild == False:
                allFalse = False
            if oneElementChild == True:
                oneElement = True
        else:
            oneElement = True
            checkState = child.get('CheckState')
            if checkState != '2':
                allTrue = False
            if checkState == '2':
                allFalse = False

    if oneElement == False:
        xmlElement.set('CheckState', '0')
    else:
        if allTrue:
            xmlElement.set('CheckState', '2')
        elif allTrue == False and allFalse == False:
            xmlElement.set('CheckState', '1')
        else:
            xmlElement.set('CheckState', '0')

    if returnElement == False:
        return allTrue,allFalse,oneElement
    else:
        return xmlElement

def xmlToStructuringElement(xmlElement):

    type = SubElement(xmlElement, 'Type').get("Special")
    if type == "StructuringElement2D":
        choice = childText(xmlElement,"Choice")
        elementValues = SubElement(xmlElement, 'Values')
        if choice == "Circular":
            param0 = SubElement(elementValues,"Parameter_0")
            output = PyIPSDK.circularSEXYInfo(int(childText(param0,"Value")))
        if choice == "Linear":
            param0 = SubElement(elementValues,"Parameter_0")
            param1 = SubElement(elementValues,"Parameter_1")
            output = PyIPSDK.linearSEXYInfo(float(childText(param0,"Value"))*np.pi/180,int(childText(param1,"Value")))
        if choice == "SemiLinear":
            param0 = SubElement(elementValues,"Parameter_0")
            param1 = SubElement(elementValues,"Parameter_1")
            output = PyIPSDK.halfLinearSEXYInfo(float(childText(param0,"Value"))*np.pi/180,int(childText(param1,"Value")))
        if choice == "Rectangular":
            param0 = SubElement(elementValues,"Parameter_0")
            param1 = SubElement(elementValues,"Parameter_1")
            output = PyIPSDK.rectangularSEXYInfo(int(childText(param0,"Value")),int(childText(param1,"Value")))
        if choice == "Square":
            param0 = SubElement(elementValues,"Parameter_0")
            output = PyIPSDK.squareSEXYInfo(int(childText(param0,"Value")))
    if type == "StructuringElement3D":
        choice = childText(xmlElement,"Choice")
        elementValues = SubElement(xmlElement, 'Values')
        if choice == "Spherical":
            param0 = SubElement(elementValues,"Parameter_0")
            output = PyIPSDK.sphericalSEXYZInfo(int(childText(param0,"Value")))
        if choice == "Linear":
            param0 = SubElement(elementValues,"Parameter_0")
            param1 = SubElement(elementValues,"Parameter_1")
            param2 = SubElement(elementValues,"Parameter_2")
            output = PyIPSDK.linearSEXYZInfo(float(childText(param0,"Value"))*np.pi/180,float(childText(param1,"Value"))*np.pi/180,int(childText(param2,"Value")))
        if choice == "Half-Linear":
            param0 = SubElement(elementValues,"Parameter_0")
            param1 = SubElement(elementValues,"Parameter_1")
            param2 = SubElement(elementValues,"Parameter_2")
            output = PyIPSDK.halfLinearSEXYZInfo(float(childText(param0,"Value"))*np.pi/180,float(childText(param1,"Value"))*np.pi/180,int(childText(param2,"Value")))
        if choice == "Rectangular":
            param0 = SubElement(elementValues,"Parameter_0")
            param1 = SubElement(elementValues,"Parameter_1")
            param2 = SubElement(elementValues,"Parameter_2")
            output = PyIPSDK.rectangularSEXYZInfo(int(childText(param0,"Value")),int(childText(param1,"Value")),int(childText(param2,"Value")))
        if choice == "Cubic":
            param0 = SubElement(elementValues,"Parameter_0")
            output = PyIPSDK.cubicSEXYZInfo(int(childText(param0,"Value")))

    return output

def createInfosetXmlElement(dimension):

    xmlElement = xmlet.Element('AllMeasures')
    xmlElement.set('Dimension', str(dimension))
    folder = vrb.folderShapeAnalysis

    createInfosetMeasureXmlElement(folder, xmlElement, dimension)

    return xmlElement

def createInfosetMeasureXmlElement(folder,xmlElement,dimension):

    for fileName in sorted(os.listdir(folder), key=str.casefold):
        filePath = folder + '/' + fileName
        if os.path.isdir(filePath):
            while fileName[0] in vrb.maskNumbers:
                fileName = fileName[1:]
            fileName = fileName.split('_')
            if len(fileName) == 1 or fileName[1] == dimension:
                # Exception !!
                if dimension != "3D" or fileName[0] not in ["Angularity", "Matching", "Skeleton"]:
                    xmlCategory = SubElement(xmlElement, fileName[0])
                    createInfosetMeasureXmlElement(filePath, xmlCategory,dimension)
        elif filePath.endswith('.mho'):
            try:
                xmlMeasure = xmlet.parse(filePath).getroot()
                objectElement = SubElement(xmlMeasure, "Object")
                nameMeasure = childText(objectElement, "Name")
                # 2D/3D
                if (childText(xmlMeasure, 'Dimension') == dimension or childText(xmlMeasure, 'Dimension') == 'Both') and nameMeasure != None and nameMeasure != "":
                    xmlElement.append(xmlMeasure)
            except:
                pass

def createAllLinks():

    allLinksElement = xmlet.Element('AllLinks')

    for file in os.listdir(vrb.folderExplorer + "/Functions"):
        for fileFunction in os.listdir(vrb.folderExplorer + "/Functions/"+file):
            # print(vrb.folderExplorer + "/Functions/"+file + "/" + fileFunction)
            try:
                fileFunctionElement = xmlet.parse(vrb.folderExplorer + "/Functions/"+file + "/" + fileFunction)
                xmlElement = fileFunctionElement.getroot()
                if childText(xmlElement,'DocPath') is not None:
                    name = childText(xmlElement,'FunctionName')
                    SubElement(allLinksElement,name).text = childText(xmlElement,'DocPath')
            except:
                pass

    saveXmlElement(allLinksElement,vrb.folderExplorer + "/Information/DocFunctions.mho")

def readElementFromSettings(tag,defaultValue = "True"):

    try:
        file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
        settingsElement = file.getroot()
        element = SubElement(settingsElement, tag)
        value = element.text
        if value is None:
            value = defaultValue
    except:
        value = defaultValue

    return value


if __name__ == '__main__':

    file = xmlet.parse(vrb.folderUserData+"/Infoset/DefaultName_2D.mho")
    infosetElement = file.getroot()
    xmlElement = adjustCheckStateInfoset(infosetElement,returnElement=True)

    #saveXmlElement(xmlElement,"F:/infoset.mho")