import sys,traceback
import os

from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication, QStringListModel
import PyQt5.QtWidgets as qt

import WidgetTypes
from UsefullWidgets import NumberLineEdit,PushButtonImage

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from ConversionIPSDK import dictConversion

import UsefullVariables as vrb


class MyComboBoxObject(qt.QComboBox):
    SignalIndexChanged = pyqtSignal(qt.QComboBox)

    def __init__(self, xmlElement, type):
        if type not in WidgetTypes.comboBoxTypes:
            print('ERROR : InputType does not match', file=sys.stderr)
        super().__init__()
        self.type = type
        self.setFixedHeight(vrb.DEFAULT_SIZE)
        self.setMinimumWidth(130*vrb.ratio)

    def interfaceToXml(self, number):
        """
        Returns an XmlElement corresponding to a param in a FunctionCall Xml
        :param number: number of the parameter in the list of parameters
        :return: XmlElement parameter for a FunctionCall
        """
        paramNode = xmlet.Element('Parameter_' + str(number))
        Dfct.SubElement(paramNode, 'Type').text = self.type.value
        value = Dfct.childText(self.currentData(), 'ElementID')
        valueNode = Dfct.SubElement(paramNode, 'Value')
        valueNode.text = str(value)
        valueNode.set('isElementID', str(True))
        return paramNode

    @staticmethod
    def xmlToValue(xmlElement):
        """
        Takes a FunctionCall parameter and returns its value
        :param xmlElement: xmlAllValues of a FunctionCall parameter
        :return: its value
        """
        valueParam = Dfct.childText(xmlElement, 'Value')
        valueType = Dfct.childText(xmlElement, 'Type')

        verifListBatchImage = False
        try:
            if vrb.batch and valueType == "Image" and vrb.listBatchImages[vrb.batchNumImage-1]:
                verifListBatchImage = True
        except:
            pass

        if vrb.batch and valueType == "Image" and (vrb.batchNumImage == 0 or verifListBatchImage) :
            valueText = 'ID_ImageBatch_' + str(vrb.batchNumImage) + '_ID'
            vrb.batchNumImage +=1
        else:
            if valueParam == '' or valueParam is None or valueParam == "None":
                valueText = None
            else:
                valueText = 'ID_' + valueType + '_' + valueParam + '_ID'
            if vrb.batch and valueType == "Image":
                vrb.batchNumImage += 1

        return valueText

class MyLineEdit(NumberLineEdit):

    def __init__(self, xmlElement, type):

        self.choice = None

        self.constraint = Dfct.childText(xmlElement, 'Constraints')
        super(MyLineEdit, self).__init__(constraint=self.constraint)
        self.valueType = None

        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is None:
            if type != WidgetTypes.InputType.SCALAR_CHOICE:
                defaultValue = Dfct.childText(xmlElement, 'Default')
                if defaultValue is not None:
                    #self.setText(str(defaultValue))
                    self.setPlaceholderText(str(defaultValue))
                    Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)
        else:
            self.setText(str(userValue))
        self.setFixedHeight(vrb.DEFAULT_SIZE)

    # def resetValueInterface(self, xmlElement):
    #     defaultValue = Dfct.childText(xmlElement, 'Default')
    #     if defaultValue is not None:
    #         self.setText(str(defaultValue))
    #         Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)

    def userValueToInterface(self, xmlElement):
        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is not None:
            self.setText(str(userValue))

    def interfaceToXml(self, number):

        paramNode = xmlet.Element('Parameter_' + str(number))
        if self.valueType is not None:
            Dfct.SubElement(paramNode, 'Type').text = self.valueType
        text = self.text()
        if text == '':
            text = self.placeholderText()
        if text != '':
            try:
                if self.constraint == WidgetTypes.ScalarConstraint.REAL.value:
                    value = float(text)
                else:
                    value = int(text)
            except:
                value = str(text)
            Dfct.SubElement(paramNode, 'Value').text = str(value)

        if self.choice is not None:
            Dfct.SubElement(paramNode, 'Choice').text = str(self.choice.currentIndex())

        return paramNode

    @staticmethod
    def xmlToValue(xmlElement):

        valueParam = Dfct.childText(xmlElement, 'Value')

        try:
            if valueParam == '' or valueParam is None:
                value = None
            else:
                if '.' in valueParam:
                    value = float(valueParam)
                else:
                    value = int(valueParam)
        except:
            value = '"'+str(valueParam)+'"'
        choiceParam = Dfct.childText(xmlElement, 'Choice')
        if choiceParam == '' or choiceParam is not None:
            choice = int(choiceParam)
            return [value,choice]
        else:
            return value

    def changeChoiceValue(self):
        #Specific for choice scalar

        value = self.choice.currentData()
        self.setPlaceholderText(value[0])
        if value[1] is not None:
            self.setText(str(value[1]))

    def updateValues(self):
        #Specific for choice scalar

        value = self.choice.currentData()
        self.choice.setItemData(self.choice.currentIndex(),[value[0],self.text()])

class MyFileSelector(qt.QGroupBox):
    def __init__(self, xmlElement, type):
        self.constraint = Dfct.childText(xmlElement, 'Constraints')
        super(MyFileSelector, self).__init__()

        self.lineEdit = MyLineEdit(xmlElement,"String")
        self.lineEdit.valueType = "String"
        self.lineEdit.constraint = "any"

        self.buttonFolder = PushButtonImage(vrb.folderImages + "/Folder.png", margins=2)
        self.buttonFolder.setFixedSize(20*vrb.ratio,20*vrb.ratio)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.lineEdit,0,0)
        self.layout.addWidget(self.buttonFolder,0,1)

        self.layout.setContentsMargins(0,0,0,0)
        self.setLayout(self.layout)

        self.setStyleSheet("QGroupBox {background-color: transparent;border: 0px transparent; }")

        self.setFixedHeight(vrb.DEFAULT_SIZE)

        self.buttonFolder.clicked.connect(self.loadQDialog)

    def interfaceToXml(self, text):

        paramNode = self.lineEdit.interfaceToXml(text)

        return paramNode

    def loadQDialog(self):

        if self.constraint == "File":
            if os.path.exists(vrb.folderInformation + "/folderMacroParameterFile.mho"):
                file = xmlet.parse(vrb.folderInformation + "/folderMacroParameterFile.mho")
                element = file.getroot()
                path = Dfct.childText(element, "Path")
                if path is None:
                    path = xmlet.Element('folderMacroParameterFile')
                    defaultFolder = "C:/"
            else:
                element = xmlet.Element('folderMacroParameterFile')
                path = "C:/"
            filename = qt.QFileDialog.getOpenFileName(self, "Select your file", path)
            filename = filename[0]

            if filename != [] and filename != '' and filename != None:
                self.lineEdit.setText(filename)
                Dfct.SubElement(element, "Path").text = filename
                Dfct.saveXmlElement(element, vrb.folderInformation + "/folderMacroParameterFile.mho")

        if self.constraint == "Folder":
            if os.path.exists(vrb.folderInformation + "/folderMacroParameterFolder.mho"):
                file = xmlet.parse(vrb.folderInformation + "/folderMacroParameterFolder.mho")
                element = file.getroot()
                path = Dfct.childText(element, "Path")
                if path is None:
                    element = xmlet.Element('folderMacroParameterFolder')
                    path = "C:/"
            else:
                element = xmlet.Element('folderMacroParameterFolder')
                path = "C:/"
            filename = qt.QFileDialog.getExistingDirectory(self, "Select your folder", path)

            if filename != '' and filename != None:
                self.lineEdit.setText(filename)
                Dfct.SubElement(element, "Path").text = filename
                Dfct.saveXmlElement(element, vrb.folderInformation + "/folderMacroParameterFolder.mho")


class MyTextEdit(qt.QTextEdit):

    def __init__(self, xmlElement, type):
        self.constraint = Dfct.childText(xmlElement, 'Constraints')
        super(MyTextEdit, self).__init__()

        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is None:
            defaultValue = Dfct.childText(xmlElement, 'Default')
            if defaultValue is not None:
                #self.setText(str(defaultValue))
                self.setPlaceholderText(str(defaultValue))
                Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)
        else:
            self.setText(str(userValue))
        self.setFixedHeight(vrb.DEFAULT_SIZE)

    # def resetValueInterface(self, xmlElement):
    #     defaultValue = Dfct.childText(xmlElement, 'Default')
    #     if defaultValue is not None:
    #         self.setText(str(defaultValue))
    #         Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)

    def userValueToInterface(self, xmlElement):
        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is not None:
            self.setText(str(userValue))

    def interfaceToXml(self, number):
        paramNode = xmlet.Element('Parameter_' + str(number))
        Dfct.SubElement(paramNode, 'Type').text = WidgetTypes.InputType.SCALAR.value
        text = self.toPlainText()
        if text == '':
            text = self.placeholderText()
        if text != '':
            try:
                if self.constraint == WidgetTypes.ScalarConstraint.REAL.value:
                    value = float(text)
                else:
                    value = int(text)
            except:
                value = str(text)
            Dfct.SubElement(paramNode, 'Value').text = str(value)
        return paramNode

    @staticmethod
    def xmlToValue(xmlElement):
        valueParam = Dfct.childText(xmlElement, 'Value')
        try:
            if valueParam == '' or valueParam is None:
                value = None
            else:
                if '.' in valueParam:
                    value = float(valueParam)
                else:
                    value = int(valueParam)
        except:
            value = str(valueParam)
        return value

class MyCheckBox(qt.QCheckBox):

    def __init__(self, xmlElement, type):
        super().__init__()
        if type != WidgetTypes.InputType.BOOLEAN:
            print('ERROR : InputType does not match', file=sys.stderr)
        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is None:
            defaultValue = Dfct.childText(xmlElement, 'Default')
            if defaultValue is not None:
                self.setChecked((False, True)[defaultValue == 'True'])
                Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)
        else:
            self.setChecked((False, True)[userValue == 'True'])
        self.setFixedHeight(vrb.DEFAULT_SIZE)

    # def resetValueInterface(self, xmlElement):
    #     defaultValue = Dfct.childText(xmlElement, 'Default')
    #     if defaultValue is not None:
    #         self.setChecked((False, True)[defaultValue == 'True'])
    #         Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)

    def userValueToInterface(self, xmlElement):
        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is not None:
            self.setChecked((False, True)[userValue == 'True'])

    def interfaceToXml(self, number):
        paramNode = xmlet.Element('Parameter_' + str(number))
        Dfct.SubElement(paramNode, 'Type').text = WidgetTypes.InputType.BOOLEAN.value
        value = self.isChecked()
        Dfct.SubElement(paramNode, 'Value').text = str(value)
        return paramNode

    @staticmethod
    def xmlToValue(xmlElement):
        valueParam = Dfct.childText(xmlElement, 'Value')
        if valueParam == '':
            value = None
        else:
            value = (False, True)[valueParam == 'True']
        return value


class MyComboBoxEnum(qt.QComboBox):
    def __init__(self, xmlElement, type):
        if type != WidgetTypes.InputType.ENUM:
            print('ERROR : InputType does not match', file=sys.stderr)
        super().__init__()
        listEnum = Dfct.childText(xmlElement, 'List')

        for elem in listEnum.split(','):
            try:
                value = dictConversion[elem]['UserName']
            except:
                value = elem
            self.addItem(value, elem)

        userValue = Dfct.childText(xmlElement, 'Value')

        if userValue is None:
            defaultValue = Dfct.childText(xmlElement, 'Default')
            if defaultValue is not None:
                try:
                    self.setCurrentIndex(int(defaultValue))
                except:
                    try:
                        self.setCurrentText(dictConversion[defaultValue]["UserName"])
                    except:
                        pass
                Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)
        else:
            try:
                self.setCurrentIndex(int(userValue))
            except:
                try:
                    self.setCurrentText(dictConversion[userValue]["UserName"])
                except:
                    pass
        self.setFixedHeight(vrb.DEFAULT_SIZE)
        self.setMinimumWidth(130*vrb.ratio)

    # def resetValueInterface(self, xmlElement):
    #     defaultValue = Dfct.childText(xmlElement, 'Default')
    #     if defaultValue is not None:
    #         self.setCurrentIndex(int(defaultValue))
    #         Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)

    def userValueToInterface(self, xmlElement):
        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is not None:
            self.setCurrentIndex(int(userValue))

    def interfaceToXml(self, number):
        paramNode = xmlet.Element('Parameter_' + str(number))
        Dfct.SubElement(paramNode, 'Type').text = WidgetTypes.InputType.ENUM.value
        value = self.currentData()
        Dfct.SubElement(paramNode, 'Value').text = str(value)
        return paramNode

    @staticmethod
    def xmlToValue(xmlElement):

        valueParam = Dfct.childText(xmlElement, 'Value')

        if valueParam == '':
            value = None
        else:
            try:
                value = dictConversion[valueParam]['IPSDK']
            except:
                if valueParam is not None:
                    if vrb.paramMacro:
                        value = '"'+str(valueParam)+'"'
                    else:
                        value = str(valueParam)
                else:
                    value = valueParam

        return value

class CheckableWidget(qt.QWidget):
    def __init__(self, widget):
        super(CheckableWidget, self).__init__()
        self.checkBox = qt.QCheckBox()
        self.widget = widget
        self.widget.setEnabled(self.checkBox.isChecked())

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.checkBox, 0, 0)
        self.layout.addWidget(self.widget, 0, 1)
        self.setLayout(self.layout)
        self.layout.setContentsMargins(0, 0, 0, 0)
        self.setFixedHeight(self.widget.height())

        self.checkBox.stateChanged.connect(self.checkBoxChanged)

    def checkBoxChanged(self, _):
        self.widget.setEnabled(self.checkBox.isChecked())

    def interfaceToXml(self, number):
        paramNode = self.widget.interfaceToXml(number)
        Dfct.SubElement(paramNode, 'Type').set('Option', str(True))
        if self.checkBox.isChecked():
            Dfct.SubElement(paramNode, 'Value').set('Checked', str(True))
        else:
            Dfct.SubElement(paramNode, 'Value').text = ""
        self.widget.xmlToValue(paramNode)
        return paramNode

    @staticmethod
    def xmlToValue(xmlElement):
        print('ERROR: xmlToValue of CheckableWidget should never be called (not an InputType)', file=sys.stderr)


class MyCompleter(qt.QLineEdit):
    def __init__(self, wordList):
        super().__init__()

        self.listModel = QStringListModel()
        self.listModel.setStringList(wordList)
        self.completer = qt.QCompleter()
        self.completer.setModel(self.listModel)

        self.completer.setCaseSensitivity(Qt.CaseInsensitive)
        # self.completer.setCompletionMode(qt.QCompleter.PopupCompletion)
        self.setCompleter(self.completer)
        # self.completer.setCompletionMode(2)

    def setWordList(self, wordList):
        self.listModel.setStringList(wordList)

#
# class MyCompleterCombo(qt.QComboBox):
#     def __init__(self, wordList):
#         super().__init__()
#
#         self.listModel = QStringListModel()
#         self.listModel.setStringList(wordList)
#         self.completer = qt.QCompleter()
#         self.completer.setModel(self.listModel)
#
#         self.completer.setCaseSensitivity(Qt.CaseInsensitive)
#         # self.completer.setCompletionMode(qt.QCompleter.PopupCompletion)
#         self.setCompleter(self.completer)
#
#         for word in wordList:
#             self.addItem(word)
#
#     def setWordList(self, wordList):
#         self.listModel.setStringList(wordList)
#         self.clear()
#         for word in wordList:
#             self.addItem(word)
#

wordList = ['salut', 'bonjour', 'coucou', 'salutations', 'bonne nuit', 'couverture']
def addWord():
    wordList.append('salut les amis')
    completer.setWordList(wordList)
if __name__ == '__main__':
    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    completer = MyCompleter(wordList)
    foo = completer

    foo.show()
    app.exec_()

