import sys
import os

from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication
import PyQt5.QtWidgets as qt
from PyQt5 import QtGui

import WidgetTypes
import UsefullWidgets as wgt
import UsefullVariables as vrb
import UsefullFunctionsForWidget as fctWidget

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

class CustomShapeAnalysisWidget(qt.QGroupBox):
    def __init__(self, xmlMeasure=None):
        super().__init__()
        self.xmlMeasure = xmlMeasure

        self.formulaPanel = FormulaPanel()

        self.variablePanel = VariablePanel()

        self.descriptionPanel = DescriptionPanel()

        self.pushButtonValidate = wgt.PushButtonImage(vrb.folderImages + "/Validate.png", margins=2)
        self.pushButtonValidate.setFixedSize(20*vrb.ratio,20*vrb.ratio)
        self.pushButtonValidate.setToolTip("Validate")
        self.pushButtonCancel = wgt.PushButtonImage(vrb.folderImages + "/Back.png", margins=2)
        self.pushButtonCancel.setFixedSize(20*vrb.ratio,20*vrb.ratio)
        self.pushButtonCancel.setToolTip("Cancel")

        self.groupBoxButtons = qt.QGroupBox()
        self.layoutButtons = qt.QGridLayout()
        self.layoutButtons.setAlignment(Qt.AlignRight)
        self.layoutButtons.addWidget(self.pushButtonCancel, 0, 0)
        self.layoutButtons.addWidget(self.pushButtonValidate, 0, 1)
        self.layoutButtons.setContentsMargins(0,0,0,0)
        self.groupBoxButtons.setLayout(self.layoutButtons)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.formulaPanel, 0, 0)
        self.layout.addWidget(self.variablePanel, 1, 0)
        self.layout.addWidget(self.descriptionPanel, 2, 0)
        self.layout.addWidget(self.groupBoxButtons, 3, 0, 1, 2)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(5*vrb.ratio,5*vrb.ratio,5*vrb.ratio,5*vrb.ratio)
        self.layout.setSizeConstraint(1)

        self.variablePanel.variablesContainer.SignalVariableDeleted.connect(self.deleteVariableFromXml)

        self.formulaPanel.setStyleSheet("QGroupBox {border: 0px transparent; }")
        self.descriptionPanel.setStyleSheet("QGroupBox {border: 0px transparent; }")
        self.groupBoxButtons.setStyleSheet("QGroupBox {border: 0px transparent; }")
        self.setStyleSheet("QGroupBox {border: 1px solid gray; }")

    def resizeEvent(self, event):

        self.formulaPanel.setFixedSize(self.width()-30*vrb.ratio,100*vrb.ratio)
        self.descriptionPanel.setFixedSize(self.width()-30*vrb.ratio,50*vrb.ratio)
        self.variablePanel.setFixedSize(self.width()-30*vrb.ratio,self.height()-190*vrb.ratio)

    def createDefaultXml(self, xmlParent, dim):
        self.xmlMeasure = xmlet.Element('Measure')
        self.xmlMeasure.set('CheckState', '0')
        self.xmlMeasure.set('isCustom', str(True))
        xmlParent.append(self.xmlMeasure)
        Dfct.SubElement(self.xmlMeasure, 'Dimension').text = dim
        Dfct.SubElement(self.xmlMeasure, 'UserName').text = ''
        Dfct.SubElement(self.xmlMeasure, 'Description').text = ''
        objNode = Dfct.SubElement(self.xmlMeasure, 'Object')
        Dfct.SubElement(objNode, 'Name').text = xmlParent.tag + 'FormulaMsr'
        Dfct.SubElement(objNode, 'Formula').text = ''
        Dfct.SubElement(objNode, 'Variables')
        self.loadXml(self.xmlMeasure)

    def loadXml(self, xmlMeasure):
        self.xmlMeasure = xmlMeasure
        self.formulaPanel.loadXmlMeasure(self.xmlMeasure)
        self.descriptionPanel.loadXmlMeasure(self.xmlMeasure)
        self.variablePanel.loadXmlMeasureVariables(Dfct.SubElement(Dfct.SubElement(self.xmlMeasure, 'Object'), 'Variables'))

    def addVariable(self, xmlMeasure):
        xmlMeasure = Dfct.copyXmlElement(xmlMeasure)
        varsNode = Dfct.SubElement(Dfct.SubElement(self.xmlMeasure, 'Object'), 'Variables')
        varNode = xmlet.SubElement(varsNode, 'Variable')
        Dfct.SubElement(varNode, 'ShortName').text = ''
        varNode.append(xmlMeasure)
        self.variablePanel.addVariable(varNode)

    def saveCustomMeasure(self, parentXml):
        oldName = Dfct.childText(self.xmlMeasure, 'UserName')
        self.formulaPanel.saveElements(self.xmlMeasure)
        self.descriptionPanel.saveElements(self.xmlMeasure)
        self.variablePanel.saveVariables()
        newName = Dfct.childText(self.xmlMeasure, 'UserName')
        potentialName = newName
        i = 2
        while self.numberInXML(potentialName, parentXml) >= 2:
            potentialName = newName + '_' + str(i)
            Dfct.SubElement(self.xmlMeasure, 'UserName').text = potentialName
            i += 1
        newName = potentialName
        if oldName != newName:
            try:
                os.remove(vrb.folderShapeAnalysis + '/3Custom/' + parentXml.tag + '/' + oldName + '.mho')
            except:
                pass
        fileName = newName + '.mho'
        Dfct.saveXmlElement(self.xmlMeasure, vrb.folderShapeAnalysis + '/3Custom/' + parentXml.tag + '/' + fileName)

    def numberInXML(self, name, xmlParent):
        nb = 0
        for childNode in xmlParent:
            if childNode.tag == 'Measure':
                if Dfct.childText(childNode, 'UserName') == name:
                    nb += 1
        return nb

    def deleteVariableFromXml(self, xmlVariable):
        Dfct.SubElement(Dfct.SubElement(self.xmlMeasure, 'Object'), 'Variables').remove(xmlVariable)


class FormulaPanel(qt.QGroupBox):
    def __init__(self):
        super(FormulaPanel, self).__init__()
        self.labelName = qt.QLabel('Measure name')
        # self.lineEditName = qt.QLineEdit()
        self.lineEditName = wgt.CustomLineEdit(mask=vrb.maskCharacters,align=Qt.AlignLeft)

        self.labelFormula = qt.QLabel('Formula')
        self.textEditFormula = qt.QTextEdit()
        self.textEditFormula.setMaximumHeight(40*vrb.ratio)
        font = self.textEditFormula.font()
        font.setPixelSize(14*vrb.ratio)
        self.textEditFormula.setFont(font)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelName, 0, 0)
        self.layout.addWidget(self.lineEditName, 0, 1)

        self.layout.addWidget(self.labelFormula, 1, 0)
        self.layout.addWidget(self.textEditFormula, 2, 0, 1, 2)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setSizeConstraint(1)

    def resizeEvent(self,event):

        self.textEditFormula.setFixedHeight(self.height()-40*vrb.ratio)

    def loadXmlMeasure(self, xmlMeasure):
        self.lineEditName.setText(Dfct.childText(xmlMeasure, 'UserName'))
        self.textEditFormula.setText(Dfct.childText(Dfct.SubElement(xmlMeasure, 'Object'), 'Formula'))

    def saveElements(self, xmlMeasure):
        Dfct.SubElement(xmlMeasure, 'UserName').text = Dfct.convertTextToAscii(self.lineEditName.text())
        Dfct.SubElement(xmlMeasure, 'UserName').set('ASCII', str(True))

        Dfct.SubElement(Dfct.SubElement(xmlMeasure, 'Object'), 'Formula').text = self.textEditFormula.toPlainText()

class DescriptionPanel(qt.QGroupBox):
    def __init__(self):
        super(DescriptionPanel, self).__init__()

        self.labelDescription = qt.QLabel('Description')
        self.textEditDescription = qt.QTextEdit()
        self.textEditDescription.setMaximumHeight(30 * vrb.ratio)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelDescription, 0, 0)
        self.layout.addWidget(self.textEditDescription, 1, 0)
        self.setLayout(self.layout)

        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setSizeConstraint(1)

    def resizeEvent(self, event):
        self.textEditDescription.setFixedHeight(self.height()-20*vrb.ratio)

    def loadXmlMeasure(self,xmlMeasure):

        self.textEditDescription.setText(Dfct.childText(xmlMeasure, 'Description'))

    def saveElements(self, xmlMeasure):

        Dfct.SubElement(xmlMeasure, 'Description').text = self.textEditDescription.toPlainText()

class VariablePanel(qt.QGroupBox):
    def __init__(self):
        super(VariablePanel, self).__init__()
        self.setTitle('Variables')

        self.variablesContainer = VariablesContainer()
        self.scrollAreaVariables = qt.QScrollArea()
        self.scrollAreaVariables.setWidget(self.variablesContainer)
        self.scrollAreaVariables.setWidgetResizable(True)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.scrollAreaVariables, 0, 0)
        self.setLayout(self.layout)

        self.setStyleSheet('QScrollArea:title {left: 20px ;padding-left: 10px;padding-right: 10px; padding-top: -12px}  QScrollArea {font: bold; border: 1px solid gray; margin-top: 12 px} QGroupBox {border: 0px transparent; }')

    def addVariable(self, xmlVariable):
        self.variablesContainer.addVariable(xmlVariable)

    def loadXmlMeasureVariables(self, xmlVariables):
        for nb in range(self.variablesContainer.layout.count()):
            # Clear the variable container
            item = self.variablesContainer.layout.itemAt(0)
            self.variablesContainer.deleteVariableWidget(item.widget(), False)
        for xmlVar in xmlVariables:
            self.addVariable(xmlVar)

    def saveVariables(self):
        for nb in range(self.variablesContainer.layout.count()):
            item = self.variablesContainer.layout.itemAt(nb)
            varWidget = item.widget()
            varWidget.saveVariable()


class VariablesContainer(qt.QGroupBox):
    SignalVariableDeleted = pyqtSignal(xmlet.Element)

    def __init__(self):
        super(VariablesContainer, self).__init__()
        self.layout = qt.QVBoxLayout()
        self.setLayout(self.layout)
        self.layout.setAlignment(Qt.AlignTop)

    def addVariable(self, xmlVariable):
        varWidget = VariableWidget(xmlVariable)
        self.layout.addWidget(varWidget)
        varWidget.SignalDeleteVariable.connect(self.deleteVariableWidget)

    def deleteVariableWidget(self, variableWidget, andInXML=True):
        xmlVariable = variableWidget.xmlVariable
        if andInXML:
            self.SignalVariableDeleted.emit(xmlVariable)
        self.layout.removeWidget(variableWidget)
        variableWidget.deleteLater()


class VariableWidget(qt.QGroupBox):
    SignalDeleteVariable = pyqtSignal(qt.QGroupBox)

    def __init__(self, xmlVariable):
        from ShapeAnalysisWidget import ParametersGroupBox
        super(VariableWidget, self).__init__()
        self.xmlVariable = xmlVariable

        shortName = Dfct.childText(xmlVariable, 'ShortName')
        xmlMeasure = Dfct.SubElement(xmlVariable, 'Measure')

        self.lineEditName = qt.QLineEdit(shortName)
        self.lineEditName.setFixedWidth(50*vrb.ratio)
        name = Dfct.childText(Dfct.SubElement(xmlMeasure, 'Object'), 'Name')
        self.labelFunctionName = qt.QLabel("= "+name)

        self.parametersWidget = ParametersGroupBox(xmlMeasure)
        self.parametersWidget.setStyleSheet('ParametersGroupBox {border: 0px transparent; }')

        # self.labelButtonDelete = wgt.LabelDelete('X')
        # self.labelButtonDelete.setFixedSize(10, 10)
        self.labelButtonDelete = wgt.PushButtonImage(vrb.folderImages + "/Delete.png", margins=1)
        self.labelButtonDelete.setFixedSize(10, 10)
        self.labelButtonDelete.setStyleSheet('PushButtonImage {background-color: transparent;border: 0px transparent;}')
        self.labelButtonDelete.setToolTip("Delete this measure")

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.lineEditName, 0, 0)
        self.layout.addWidget(self.labelFunctionName, 0, 1, Qt.AlignLeft)
        self.layout.addWidget(self.labelButtonDelete, 0, 2, Qt.AlignRight)
        self.layout.addWidget(self.parametersWidget, 1, 0, 1, 3)
        self.setLayout(self.layout)
        self.parametersWidget.setVisible(self.parametersWidget.groupBoxLayout.count() != 0)

        self.layout.setContentsMargins(5, 5, 5, 5)
        # self.setStyleSheet('VariableWidget {background:rgb(220, 220, 220); border: 0px transparent; }')
        self.setStyleSheet('VariableWidget {border: 1px solid gray}')
        # self.setStyleSheet('QGroupBox {color: white}')

        self.labelButtonDelete.clicked.connect(self.emitSignalDeleteVariable)

    def emitSignalDeleteVariable(self):
        self.SignalDeleteVariable.emit(self)

    def saveVariable(self):
        Dfct.SubElement(self.xmlVariable, 'ShortName').text = self.lineEditName.text()
        xmlMeasure = Dfct.SubElement(self.xmlVariable, 'Measure')
        self.parametersWidget.saveMeasureParameters(xmlMeasure)

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    foo = CustomShapeAnalysisWidget()
    foo.show()

    app.exec_()