import PyIPSDK
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis

dictConversion = {}

# Hough circles type
dictConversion['eCIT_BrightCircles'] = {}
dictConversion['eCIT_BrightCircles']['UserName'] = 'Bright'
dictConversion['eCIT_BrightCircles']['IPSDK'] = 'PyIPSDK.eCIT_BrightCircles '

dictConversion['eCIT_DarkCircles'] = {}
dictConversion['eCIT_DarkCircles']['UserName'] = 'Dark'
dictConversion['eCIT_DarkCircles']['IPSDK'] = 'PyIPSDK.eCIT_DarkCircles '

dictConversion['eCIT_Both'] = {}
dictConversion['eCIT_Both']['UserName'] = 'Both'
dictConversion['eCIT_Both']['IPSDK'] = 'PyIPSDK.eCIT_Both '

# lightness method
dictConversion['eLT_Average'] = {}
dictConversion['eLT_Average']['UserName'] = 'Average'
dictConversion['eLT_Average']['IPSDK'] = 'PyIPSDK.eLT_Average'

dictConversion['eLT_Lightness'] = {}
dictConversion['eLT_Lightness']['UserName'] = 'Lightness'
dictConversion['eLT_Lightness']['IPSDK'] = 'PyIPSDK.eLT_Lightness'

dictConversion['eLT_Luminosity'] = {}
dictConversion['eLT_Luminosity']['UserName'] = 'Luminosity'
dictConversion['eLT_Luminosity']['IPSDK'] = 'PyIPSDK.eLT_Luminosity'

# eSuperPixelsType
dictConversion['eSPT_Number'] = {}
dictConversion['eSPT_Number']['UserName'] = 'Number'
dictConversion['eSPT_Number']['IPSDK'] = 'PyIPSDK.eSPT_Number'

dictConversion['eSPT_Size'] = {}
dictConversion['eSPT_Size']['UserName'] = 'Size'
dictConversion['eSPT_Size']['IPSDK'] = 'PyIPSDK.eSPT_Size'

# eRidgeLinePropagationMode
dictConversion['ePA_X'] = {}
dictConversion['ePA_X']['UserName'] = 'X'
dictConversion['ePA_X']['IPSDK'] = 'PyIPSDK.ePA_X'

dictConversion['ePA_Y'] = {}
dictConversion['ePA_Y']['UserName'] = 'Y'
dictConversion['ePA_Y']['IPSDK'] = 'PyIPSDK.ePA_Y'

dictConversion['ePA_Z'] = {}
dictConversion['ePA_Z']['UserName'] = 'Z'
dictConversion['ePA_Z']['IPSDK'] = 'PyIPSDK.ePA_Z'

dictConversion['ePD_Direct'] = {}
dictConversion['ePD_Direct']['UserName'] = 'Direct'
dictConversion['ePD_Direct']['IPSDK'] = 'PyIPSDK.ePD_Direct'

dictConversion['ePD_Reverse'] = {}
dictConversion['ePD_Reverse']['UserName'] = 'Reverse'
dictConversion['ePD_Reverse']['IPSDK'] = 'PyIPSDK.ePD_Reverse'

# eWatershedSeparationMode
dictConversion['eSAT_Default'] = {}
dictConversion['eSAT_Default']['UserName'] = 'Default'
dictConversion['eSAT_Default']['IPSDK'] = 'PyIPSDK.eSkeletonAlgoType.eSAT_Default'

dictConversion['eSAT_Smooth'] = {}
dictConversion['eSAT_Smooth']['UserName'] = 'Smooth'
dictConversion['eSAT_Smooth']['IPSDK'] = 'PyIPSDK.eSkeletonAlgoType.eSAT_Smooth'

# eWatershedSeparationMode
dictConversion['eWSM_Split_Binary'] = {}
dictConversion['eWSM_Split_Binary']['UserName'] = 'Split binary'
dictConversion['eWSM_Split_Binary']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Split'

dictConversion['eWSM_Split'] = {}
dictConversion['eWSM_Split']['UserName'] = 'Split'
dictConversion['eWSM_Split']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Split'

dictConversion['eWSM_Split_Label'] = {}
dictConversion['eWSM_Split_Label']['UserName'] = 'Split label'
dictConversion['eWSM_Split_Label']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_SplitLabel'

dictConversion['eWSM_Lines'] = {}
dictConversion['eWSM_Lines']['UserName'] = 'Lines'
dictConversion['eWSM_Lines']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Lines'

dictConversion['eWSM_Basins'] = {}
dictConversion['eWSM_Basins']['UserName'] = 'Basins'
dictConversion['eWSM_Basins']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Basins'

# eWatershedProcessingMode
dictConversion['eWPM_Repeatable'] = {}
dictConversion['eWPM_Repeatable']['UserName'] = 'Repeatable'
dictConversion['eWPM_Repeatable']['IPSDK'] = 'PyIPSDK.eWatershedProcessingMode.eWPM_Repeatable '

dictConversion['eWPM_OptimizeSpeed'] = {}
dictConversion['eWPM_OptimizeSpeed']['UserName'] = 'Optimize speed'
dictConversion['eWPM_OptimizeSpeed']['IPSDK'] = 'PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed'

# eWatershedOutputMode
dictConversion['eWOM_Lines'] = {}
dictConversion['eWOM_Lines']['UserName'] = 'Lines'
dictConversion['eWOM_Lines']['IPSDK'] = 'PyIPSDK.eWatershedOutputMode.eWOM_Lines'

dictConversion['eWOM_Basins'] = {}
dictConversion['eWOM_Basins']['UserName'] = 'Bassins'
dictConversion['eWOM_Basins']['IPSDK'] = 'PyIPSDK.eWatershedOutputMode.eWOM_Basins'

# eShapeGreyscaleType
dictConversion['eSGT_Dark'] = {}
dictConversion['eSGT_Dark']['UserName'] = 'Dark'
dictConversion['eSGT_Dark']['IPSDK'] = 'PyIPSDK.eShapeGreyscaleType.eSGT_Dark'

dictConversion['eSGT_Light'] = {}
dictConversion['eSGT_Light']['UserName'] = 'Light'
dictConversion['eSGT_Light']['IPSDK'] = 'PyIPSDK.eShapeGreyscaleType.eSGT_Light'


# eNeighborhood2dType
dictConversion['eN2T_8Connexity'] = {}
dictConversion['eN2T_8Connexity']['UserName'] = 'Connexity 8'
dictConversion['eN2T_8Connexity']['IPSDK'] = 'PyIPSDK.eNeighborhood2dType.eN2T_8Connexity'

dictConversion['eN2T_4Connexity'] = {}
dictConversion['eN2T_4Connexity']['UserName'] = 'Connexity 4'
dictConversion['eN2T_4Connexity']['IPSDK'] = "PyIPSDK.eNeighborhood2dType.eN2T_4Connexity"

# eNeighborhood3dType
dictConversion['eN3T_6Connexity'] = {'UserName': 'Connexity 6', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_6Connexity'}
dictConversion['eN3T_18Connexity'] = {'UserName': 'Connexity 18', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_18Connexity'}
dictConversion['eN3T_26Connexity'] = {'UserName': 'Connexity 26', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_26Connexity'}

# eProcessingOptimizationPolicy
dictConversion['ePOP_MinimizeMemory'] = {}
dictConversion['ePOP_MinimizeMemory']['UserName'] = 'Minimiser Mémoire'
dictConversion['ePOP_MinimizeMemory']['IPSDK'] = 'PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory'

dictConversion['ePOP_MaximizeSpeed'] = {}
dictConversion['ePOP_MaximizeSpeed']['UserName'] = 'Maximize Speed'
dictConversion['ePOP_MaximizeSpeed']['IPSDK'] = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"

# eZoomInterpolationMethod
dictConversion['eZIM_NearestNeighbour'] = {}
dictConversion['eZIM_NearestNeighbour']['UserName'] = 'Nearest Neighbour'
dictConversion['eZIM_NearestNeighbour']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour'

dictConversion['eZIM_Linear'] = {}
dictConversion['eZIM_Linear']['UserName'] = 'Linear'
dictConversion['eZIM_Linear']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_Linear'

dictConversion['eZIM_Cubic'] = {}
dictConversion['eZIM_Cubic']['UserName'] = 'Cubic'
dictConversion['eZIM_Cubic']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_Cubic'

dictConversion['eZIM_VolumeWeightedMean'] = {}
dictConversion['eZIM_VolumeWeightedMean']['UserName'] = 'Volume Weighted Mean'
dictConversion['eZIM_VolumeWeightedMean']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_VolumeWeightedMean'

# Unrolling InterpolationMethod
dictConversion['eIP_NearestNeighbour'] = {}
dictConversion['eIP_NearestNeighbour']['UserName'] = 'Nearest Neighbour'
dictConversion['eIP_NearestNeighbour']['IPSDK'] = 'PyIPSDK.eIP_NearestNeighbour'

dictConversion['eIP_Linear'] = {}
dictConversion['eIP_Linear']['UserName'] = 'Linear'
dictConversion['eIP_Linear']['IPSDK'] = 'PyIPSDK.eIP_Linear'

dictConversion['eIP_Cubic'] = {}
dictConversion['eIP_Cubic']['UserName'] = 'Cubic'
dictConversion['eIP_Cubic']['IPSDK'] = 'PyIPSDK.eIP_Cubic'

# Unrolling InterpolationMethod
dictConversion['eRMM2d_Translation'] = {}
dictConversion['eRMM2d_Translation']['UserName'] = 'Translation'
dictConversion['eRMM2d_Translation']['IPSDK'] = 'PyIPSDK.eRMM2d_Translation'

dictConversion['eRMM2d_Rigid'] = {}
dictConversion['eRMM2d_Rigid']['UserName'] = 'Rigid'
dictConversion['eRMM2d_Rigid']['IPSDK'] = 'PyIPSDK.eRMM2d_Rigid'

dictConversion['eRMM2d_Similarity'] = {}
dictConversion['eRMM2d_Similarity']['UserName'] = 'Similarity'
dictConversion['eRMM2d_Similarity']['IPSDK'] = 'PyIPSDK.eRMM2d_Similarity'

dictConversion['eRMM2d_Homography'] = {}
dictConversion['eRMM2d_Homography']['UserName'] = 'Homography'
dictConversion['eRMM2d_Homography']['IPSDK'] = 'PyIPSDK.eRMM2d_Homography'

# Intergration Type
dictConversion['eCUIT_Max'] = {}
dictConversion['eCUIT_Max']['UserName'] = 'Max'
dictConversion['eCUIT_Max']['IPSDK'] = 'PyIPSDK.eCUIT_Max'

dictConversion['eCUIT_Mean'] = {}
dictConversion['eCUIT_Mean']['UserName'] = 'Mean'
dictConversion['eCUIT_Mean']['IPSDK'] = 'PyIPSDK.eCUIT_Mean'

dictConversion['eCUIT_Min'] = {}
dictConversion['eCUIT_Min']['UserName'] = 'Min'
dictConversion['eCUIT_Min']['IPSDK'] = 'PyIPSDK.eCUIT_Min'

# eImageBufferType
dictConversion['eIBT_None'] = {}
dictConversion['eIBT_None']['UserName'] = 'Empty buffer type'
dictConversion['eIBT_None']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_None'

dictConversion['eIBT_Int8'] = {}
dictConversion['eIBT_Int8']['UserName'] = 'Int 8'
dictConversion['eIBT_Int8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int8'

dictConversion['eIBT_UInt8'] = {}
dictConversion['eIBT_UInt8']['UserName'] = 'UInt 8'
dictConversion['eIBT_UInt8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt8'

dictConversion['eIBT_Int16'] = {}
dictConversion['eIBT_Int16']['UserName'] = 'Int 16'
dictConversion['eIBT_Int16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int16'

dictConversion['eIBT_UInt16'] = {}
dictConversion['eIBT_UInt16']['UserName'] = 'UInt 16'
dictConversion['eIBT_UInt16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt16'

dictConversion['eIBT_Int32'] = {}
dictConversion['eIBT_Int32']['UserName'] = 'Int 32'
dictConversion['eIBT_Int32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int32'

dictConversion['eIBT_UInt32'] = {}
dictConversion['eIBT_UInt32']['UserName'] = 'Uint 32'
dictConversion['eIBT_UInt32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt32'

dictConversion['eIBT_Real32'] = {}
dictConversion['eIBT_Real32']['UserName'] = 'Float 32'
dictConversion['eIBT_Real32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Real32'

dictConversion['eIBT_Binary'] = {}
dictConversion['eIBT_Binary']['UserName'] = 'Binary'
dictConversion['eIBT_Binary']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Binary'

dictConversion['eIBT_Label8'] = {}
dictConversion['eIBT_Label8']['UserName'] = 'Label on 8 bits'
dictConversion['eIBT_Label8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label8'

dictConversion['eIBT_Label16'] = {}
dictConversion['eIBT_Label16']['UserName'] = 'Label on 16 bits'
dictConversion['eIBT_Label16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label16'

dictConversion['eIBT_Label32'] = {}
dictConversion['eIBT_Label32']['UserName'] = 'Label on 32 bits'
dictConversion['eIBT_Label32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label32'

# eFrequencyBandPassFilterType
dictConversion['eFBPFT_Gaussian'] = {}
dictConversion['eFBPFT_Gaussian']['UserName'] = 'Gaussian'
dictConversion['eFBPFT_Gaussian']['IPSDK'] = 'PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_Gaussian'

dictConversion['eFBPFT_LogGabor'] = {}
dictConversion['eFBPFT_LogGabor']['UserName'] = 'Log Gabor'
dictConversion['eFBPFT_LogGabor']['IPSDK'] = 'PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_LogGabor'

# eProjStatType
dictConversion['ePST_Max'] = {}
dictConversion['ePST_Max']['UserName'] = 'Max'
dictConversion['ePST_Max']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Max'

dictConversion['ePST_Mean'] = {}
dictConversion['ePST_Mean']['UserName'] = 'Mean'
dictConversion['ePST_Mean']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Mean'

dictConversion['ePST_Median'] = {}
dictConversion['ePST_Median']['UserName'] = 'Median'
dictConversion['ePST_Median']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Median'

dictConversion['ePST_Min'] = {}
dictConversion['ePST_Min']['UserName'] = 'Min'
dictConversion['ePST_Min']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Min'

dictConversion['ePST_StdDev'] = {}
dictConversion['ePST_StdDev']['UserName'] = 'Standard Deviation'
dictConversion['ePST_StdDev']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_StdDev'

dictConversion['ePST_Sum'] = {}
dictConversion['ePST_Sum']['UserName'] = 'Sum'
dictConversion['ePST_Sum']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Sum'

dictConversion['ePST_Variance'] = {}
dictConversion['ePST_Variance']['UserName'] = 'Variance'
dictConversion['ePST_Variance']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Variance'

# eSobelKernelType
dictConversion['eSKT_ScharrHalfKnlSz1'] = {}
dictConversion['eSKT_ScharrHalfKnlSz1']['UserName'] = 'Scharr 3'
dictConversion['eSKT_ScharrHalfKnlSz1']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_ScharrHalfKnlSz1'

dictConversion['eSKT_SobelHalfKnlSz1'] = {}
dictConversion['eSKT_SobelHalfKnlSz1']['UserName'] = 'Sobel 3'
dictConversion['eSKT_SobelHalfKnlSz1']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz1'

dictConversion['eSKT_SobelHalfKnlSz2'] = {}
dictConversion['eSKT_SobelHalfKnlSz2']['UserName'] = 'Sobel 5'
dictConversion['eSKT_SobelHalfKnlSz2']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz2'

dictConversion['eSKT_SobelHalfKnlSz3'] = {}
dictConversion['eSKT_SobelHalfKnlSz3']['UserName'] = 'Sobel 7'
dictConversion['eSKT_SobelHalfKnlSz3']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz3'

# eLocalExtremumType
dictConversion['eLET_Max'] = {}
dictConversion['eLET_Max']['UserName'] = 'Maximum'
dictConversion['eLET_Max']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_Max'

dictConversion['eLET_Min'] = {}
dictConversion['eLET_Min']['UserName'] = 'Minimum'
dictConversion['eLET_Min']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_Min'

dictConversion['eLET_StrictMax'] = {}
dictConversion['eLET_StrictMax']['UserName'] = 'Maximum without plateau'
dictConversion['eLET_StrictMax']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_StrictMax'

dictConversion['eLET_StrictMin'] = {}
dictConversion['eLET_StrictMin']['UserName'] = 'Minimum without plateau'
dictConversion['eLET_StrictMin']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_StrictMin'

#Fourier Transform
dictConversion['eDFTC_Cartesian'] = {}
dictConversion['eDFTC_Cartesian']['UserName'] = 'Cartesian'
dictConversion['eDFTC_Cartesian']['IPSDK'] = 'PyIPSDK.eDFTCoordinates.eDFTC_Cartesian'

dictConversion['eDFTC_Polar'] = {}
dictConversion['eDFTC_Polar']['UserName'] = 'Polar'
dictConversion['eDFTC_Polar']['IPSDK'] = 'PyIPSDK.eDFTCoordinates.eDFTC_Polar'

dictConversion['eDFTQP_Centered'] = {}
dictConversion['eDFTQP_Centered']['UserName'] = 'Centered'
dictConversion['eDFTQP_Centered']['IPSDK'] = 'PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Centered'

dictConversion['eDFTQP_Native'] = {}
dictConversion['eDFTQP_Native']['UserName'] = 'Native'
dictConversion['eDFTQP_Native']['IPSDK'] = 'PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native'

# Statistical match
dictConversion['eMinMax'] = {}
dictConversion['eMinMax']['UserName'] = 'Min and Max'
dictConversion['eMinMax']['IPSDK'] = 'PyIPSDK.eMinMax'

dictConversion['eMeanStdDev'] = {}
dictConversion['eMeanStdDev']['UserName'] = 'Mean and Standard deviation'
dictConversion['eMeanStdDev']['IPSDK'] = 'PyIPSDK.eMeanStdDev'

dictConversion['eHistogram'] = {}
dictConversion['eHistogram']['UserName'] = 'Histogram'
dictConversion['eHistogram']['IPSDK'] = 'PyIPSDK.eHistogram'

# eColorGeometryType
dictConversion['eCGT_Grey'] = {'UserName': 'Grey', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Grey'}
dictConversion['eCGT_Rgb'] = {'UserName': 'RGB', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Rgb'}
dictConversion['eCGT_Rgba'] = {'UserName': 'RGBa', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Rgba'}
dictConversion['eCGT_XYZ'] = {'UserName': 'XYZ', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_XYZ'}
dictConversion['eCGT_YPbPr'] = {'UserName': 'YPbPr', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_YPbPr'}
dictConversion['eCGT_YCbCr'] = {'UserName': 'YCbCr', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_YCbCr'}
dictConversion['eCGT_CieLab'] = {'UserName': 'CieLab', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_CieLab'}
dictConversion['eCGT_CieLuv'] = {'UserName': 'CieLuv', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_CieLuv'}
dictConversion['eCGT_HLS'] = {'UserName': 'HLS', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_HLS'}
dictConversion['eCGT_HSV'] = {'UserName': 'HSV', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_HSV'}

dictConversion['eRSP_Min'] = {}
dictConversion['eRSP_Min']['UserName'] = 'Min'
dictConversion['eRSP_Min']['IPSDK'] = 'shapeanalysis.eRSP_Min'

dictConversion['eRSP_Max'] = {}
dictConversion['eRSP_Max']['UserName'] = 'Max'
dictConversion['eRSP_Max']['IPSDK'] = 'shapeanalysis.eRSP_Max'

dictConversion['eSCP_SegCenter'] = {}
dictConversion['eSCP_SegCenter']['UserName'] = 'Center'
dictConversion['eSCP_SegCenter']['IPSDK'] = 'PyIPSDK.eSCP_SegCenter'

dictConversion['eSCP_SegEnds'] = {}
dictConversion['eSCP_SegEnds']['UserName'] = 'End'
dictConversion['eSCP_SegEnds']['IPSDK'] = 'PyIPSDK.eSCP_SegEnds'

dictConversion['eSCP_SegClosestPoint'] = {}
dictConversion['eSCP_SegClosestPoint']['UserName'] = 'Closest Point'
dictConversion['eSCP_SegClosestPoint']['IPSDK'] = 'PyIPSDK.eSCP_SegClosestPoint'

dictConversion['eSHP_Ignored'] = {}
dictConversion['eSHP_Ignored']['UserName'] = 'Ignored'
dictConversion['eSHP_Ignored']['IPSDK'] = 'PyIPSDK.eSHP_Ignored'

dictConversion['eSHP_ExtractedButNotAnalyzed'] = {}
dictConversion['eSHP_ExtractedButNotAnalyzed']['UserName'] = 'Extracted but not analysed'
dictConversion['eSHP_ExtractedButNotAnalyzed']['IPSDK'] = 'PyIPSDK.eSHP_ExtractedButNotAnalyzed'

dictConversion['eSHP_ExtractedAndAnalyzed'] = {}
dictConversion['eSHP_ExtractedAndAnalyzed']['UserName'] = 'Extracted and analysed'
dictConversion['eSHP_ExtractedAndAnalyzed']['IPSDK'] = 'PyIPSDK.eSHP_ExtractedAndAnalyzed'

dictConversion['eSEC_Leaf'] = {}
dictConversion['eSEC_Leaf']['UserName'] = 'Leaf'
dictConversion['eSEC_Leaf']['IPSDK'] = 'PyIPSDK.eSEC_Leaf'

dictConversion['eSEC_Branch'] = {}
dictConversion['eSEC_Branch']['UserName'] = 'Branch'
dictConversion['eSEC_Branch']['IPSDK'] = 'PyIPSDK.eSEC_Branch'

dictConversion['eSEC_All'] = {}
dictConversion['eSEC_All']['UserName'] = 'All'
dictConversion['eSEC_All']['IPSDK'] = 'PyIPSDK.eSEC_All'

dictConversion['eSVC_Internal'] = {}
dictConversion['eSVC_Internal']['UserName'] = 'Internal'
dictConversion['eSVC_Internal']['IPSDK'] = 'PyIPSDK.eSVC_Internal'

dictConversion['eSVC_Junction'] = {}
dictConversion['eSVC_Junction']['UserName'] = 'Junction'
dictConversion['eSVC_Junction']['IPSDK'] = 'PyIPSDK.eSVC_Junction'

dictConversion['eSVC_Slab'] = {}
dictConversion['eSVC_Slab']['UserName'] = 'Slab'
dictConversion['eSVC_Slab']['IPSDK'] = 'PyIPSDK.eSVC_Slab'

dictConversion['eSVC_EndPoint'] = {}
dictConversion['eSVC_EndPoint']['UserName'] = 'End Point'
dictConversion['eSVC_EndPoint']['IPSDK'] = 'PyIPSDK.eSVC_EndPoint'

dictConversion['eSVC_All'] = {}
dictConversion['eSVC_All']['UserName'] = 'All'
dictConversion['eSVC_All']['IPSDK'] = 'PyIPSDK.eSVC_All'

#######################
# Info Set Parameters #
#######################

dictConversion['ProcessHoles'] = {}
dictConversion['ProcessHoles']['UserName'] = 'Process Holes'
dictConversion['ProcessHoles']['IPSDK'] = 'shapeanalysis.createHolesBasicPolicyMsrParams'

dictConversion['NbOrientations'] = {}
dictConversion['NbOrientations']['UserName'] = 'Number of orientation?'
dictConversion['NbOrientations']['IPSDK'] = 'shapeanalysis.createAspectRatioMsrParams'

dictConversion['Orientation2D'] = {}
dictConversion['Orientation2D']['UserName'] = 'Orientation'
dictConversion['Orientation2D']['IPSDK'] = 'shapeanalysis.createFeretDiameter2dMsrParams'

dictConversion['Orientation3D'] = {}
dictConversion['Orientation3D']['UserName'] = ['Phi','Theta']
dictConversion['Orientation3D']['IPSDK'] = 'shapeanalysis.createFeretDiameter3dMsrParams'

dictConversion['OutlineSlopeAngularity2dMsrParams'] = {}
dictConversion['OutlineSlopeAngularity2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['OutlineSlopeAngularity2dMsrParams']['IPSDK'] = 'shapeanalysis.createOutlineSlopeAngularity2dMsrParams'

dictConversion['MaxFeretDiameterMsrParams'] = {}
dictConversion['MaxFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretDiameterMsrParams'

dictConversion['MaxFeretOrientation2dMsrParams'] = {}
dictConversion['MaxFeretOrientation2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientation2dMsrParams'

dictConversion['MeanFeretDiameterMsrParams'] = {}
dictConversion['MeanFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MeanFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMeanFeretDiameterMsrParams'

dictConversion['MinFeretDiameterMsrParams'] = {}
dictConversion['MinFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretDiameterMsrParams'

dictConversion['MinFeretOrientation2dMsrParams'] = {}
dictConversion['MinFeretOrientation2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientation2dMsrParams'

dictConversion['MaxFeretOrientationPhi3dMsrParams'] = {}
dictConversion['MaxFeretOrientationPhi3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientationPhi3dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientationPhi3dMsrParams'

dictConversion['MaxFeretOrientationTheta3dMsrParams'] = {}
dictConversion['MaxFeretOrientationTheta3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientationTheta3dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientationTheta3dMsrParams'

dictConversion['MinFeretOrientationPhi3dMsrParams'] = {}
dictConversion['MinFeretOrientationPhi3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientationPhi3dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientationPhi3dMsrParams'

dictConversion['MinFeretOrientationTheta3dMsrParams'] = {}
dictConversion['MinFeretOrientationTheta3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientationTheta3dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientationTheta3dMsrParams'

for extremum in ["Min","Max"]:
    for num in ["0","1"]:
        for letter in ["X","Y","Z"]:
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams'] = {}
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams']['UserName'] = 'Number of orientation'
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams']['IPSDK'] = 'shapeanalysis.create'+extremum+'FeretPt'+num+letter+'MsrParams'


dictConversion['OrientedExtentMsrParams'] = {}
dictConversion['OrientedExtentMsrParams']['UserName'] = ['Process Holes','Number of orientation']
dictConversion['OrientedExtentMsrParams']['IPSDK'] = 'shapeanalysis.createOrientedExtentMsrParams'

dictConversion['RelativeSizeMsrParams'] = {}
dictConversion['RelativeSizeMsrParams']['UserName'] = ['Process Holes','Size Policy']
dictConversion['RelativeSizeMsrParams']['IPSDK'] = 'shapeanalysis.createRelativeSizeMsrParams'

dictConversion['Roughness2dMsrParams'] = {}
dictConversion['Roughness2dMsrParams']['UserName'] = ['Process Holes','Max Distance']
dictConversion['Roughness2dMsrParams']['IPSDK'] = 'shapeanalysis.createRoughness2dMsrParams'

dictConversion['LengthOfContact2dMsrParams'] = {}
dictConversion['LengthOfContact2dMsrParams']['UserName'] = ['Contact distance','Segment contact Policy','Process Holes']
dictConversion['LengthOfContact2dMsrParams']['IPSDK'] = 'shapeanalysis.createLengthOfContact2dMsrParams'

dictConversion['NeighborsDistanceMsrParams'] = {}
dictConversion['NeighborsDistanceMsrParams']['UserName'] = ['Max distance','Process Holes']
dictConversion['NeighborsDistanceMsrParams']['IPSDK'] = 'shapeanalysis.createNeighborsDistanceMsrParams'

dictConversion['SurfaceOfContact3dMsrParams'] = {}
dictConversion['SurfaceOfContact3dMsrParams']['UserName'] = ['Contact distance','Process Holes']
dictConversion['SurfaceOfContact3dMsrParams']['IPSDK'] = 'shapeanalysis.createSurfaceOfContact3dMsrParams'

dictConversion['OBBCenterXMsrParams'] = {}
dictConversion['OBBCenterXMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterXMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterXMsrParams'

dictConversion['OBBCenterYMsrParams'] = {}
dictConversion['OBBCenterYMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterYMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterYMsrParams'

dictConversion['OBBCenterZMsrParams'] = {}
dictConversion['OBBCenterZMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterZMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterZMsrParams'

dictConversion['OBBWidthMsrParams'] = {}
dictConversion['OBBWidthMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBWidthMsrParams']['IPSDK'] = 'shapeanalysis.createOBBWidthMsrParams'

dictConversion['OBBLengthMsrParams'] = {}
dictConversion['OBBLengthMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBLengthMsrParams']['IPSDK'] = 'shapeanalysis.createOBBLengthMsrParams'

dictConversion['OBBHeightMsrParams'] = {}
dictConversion['OBBHeightMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBHeightMsrParams']['IPSDK'] = 'shapeanalysis.createOBBHeightMsrParams'

dictConversion['OBBOrientation2dMsrParams'] = {}
dictConversion['OBBOrientation2dMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientation2dMsrParams'

dictConversion['OBBOrientationAlphaMsrParams'] = {}
dictConversion['OBBOrientationAlphaMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationAlphaMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationAlphaMsrParams'

dictConversion['OBBOrientationBetaMsrParams'] = {}
dictConversion['OBBOrientationBetaMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationBetaMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationBetaMsrParams'

dictConversion['OBBOrientationChiMsrParams'] = {}
dictConversion['OBBOrientationChiMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationChiMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationChiMsrParams'

dictConversion['Skeleton2dDiameterLengthMsrParams'] = {}
dictConversion['Skeleton2dDiameterLengthMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterLengthMsrParams'

dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams'] = {}
dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterMeanCurvatureMsrParams'

dictConversion['Skeleton2dDiameterTortuosityMsrParams'] = {}
dictConversion['Skeleton2dDiameterTortuosityMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterTortuosityMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterTortuosityMsrParams'

dictConversion['Skeleton2dLengthMsrParams'] = {}
dictConversion['Skeleton2dLengthMsrParams']['UserName'] = ['Holes Policy','Edge Catagory']
dictConversion['Skeleton2dLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dLengthMsrParams'

dictConversion['Skeleton2dMaxThicknessMsrParams'] = {}
dictConversion['Skeleton2dMaxThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMaxThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMaxThicknessMsrParams'

dictConversion['Skeleton2dMeanEdgeLengthMsrParams'] = {}
dictConversion['Skeleton2dMeanEdgeLengthMsrParams']['UserName'] = ['Holes Policy','Edge Catagory']
dictConversion['Skeleton2dMeanEdgeLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMeanEdgeLengthMsrParams'

dictConversion['Skeleton2dMeanThicknessMsrParams'] = {}
dictConversion['Skeleton2dMeanThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMeanThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMeanThicknessMsrParams'

dictConversion['Skeleton2dMinThicknessMsrParams'] = {}
dictConversion['Skeleton2dMinThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMinThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMinThicknessMsrParams'

dictConversion['Skeleton2dNbVertexMsrParams'] = {}
dictConversion['Skeleton2dNbVertexMsrParams']['UserName'] = ['Holes Policy','Vertex Catagory']
dictConversion['Skeleton2dNbVertexMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dNbVertexMsrParams'

dictConversion['HistogramMostPopulatedGLMsrParams'] = {}
dictConversion['HistogramMostPopulatedGLMsrParams']['UserName'] = ['Bin','Min','Max']
dictConversion['HistogramMostPopulatedGLMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramMostPopulatedGLMsrParamsBinWidth'

dictConversion['HistogramPopulationMaxMsrParams'] = {}
dictConversion['HistogramPopulationMaxMsrParams']['UserName'] = ['Bin','Min','Max']
dictConversion['HistogramPopulationMaxMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramPopulationMaxMsrParamsBinWidth'

dictConversion['HistogramQuantileMsrParams'] = {}
dictConversion['HistogramQuantileMsrParams']['UserName'] = ['Bin','Min','Max','Quantile']
dictConversion['HistogramQuantileMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramQuantileMsrParamsBinWidth'

# eDilateLabelMode
dictConversion['eDLM_Basins'] = {}
dictConversion['eDLM_Basins']['UserName'] = 'Basins'
dictConversion['eDLM_Basins']['IPSDK'] = 'PyIPSDK.eDilateLabelMode.eDLM_Basins'
dictConversion['eDLM_Split'] = {}
dictConversion['eDLM_Split']['UserName'] = 'Split'
dictConversion['eDLM_Split']['IPSDK'] = 'PyIPSDK.eDilateLabelMode.eDLM_Split'

# eAxis
dictConversion['eA_X'] = {}
dictConversion['eA_X']['UserName'] = 'X'
dictConversion['eA_X']['IPSDK'] = 'PyIPSDK.eAxis.eA_X'
dictConversion['eA_Y'] = {}
dictConversion['eA_Y']['UserName'] = 'Y'
dictConversion['eA_Y']['IPSDK'] = 'PyIPSDK.eAxis.eA_Y'
dictConversion['eA_Z'] = {}
dictConversion['eA_Z']['UserName'] = 'Z'
dictConversion['eA_Z']['IPSDK'] = 'PyIPSDK.eAxis.eA_Z'

####################
# Info Set Measure #
####################

# dictConversion["Geometry"] = {}
# dictConversion['Geometry']['UserName'] = 'Geometry'
# dictConversion['Geometry']['Description'] = 'Geometric measures'