import sys
import os
import traceback

import platform

import time

from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication
from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore

import xml.etree.ElementTree as xmlet

import UsefullWidgets as wgt
import UsefullVariables as vrb
import DatabaseFunction as Dfct
import UsefullFunctions as fct
import UsefullTexts as txt

from RangeSlider import RangeSlider

import PyIPSDK
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLFeatureDetection as fd
import PyIPSDK.IPSDKIPLStats as stats
import PyIPSDK.IPSDKIPLClassification as classif

import PyIPSDK.IPSDKUI as ui

import numpy as np

import subprocess

import matplotlib
matplotlib.use('QT5Agg')
import matplotlib.pylab as plt
from matplotlib.backends.qt_compat import QtCore, QtWidgets#, is_pyqt5
from matplotlib.backends.backend_qt5agg import FigureCanvas
from matplotlib.backends.backend_qt5agg import NavigationToolbar2QT as NavigationToolbar
from matplotlib.figure import Figure

try:
    allow3d = PyIPSDK.are3dProcessesSupported()
except:
    allow3d = True

#####

#Images for toolbar buttons are at ./Miniconda/Lib/site-packages/matplotlib/mpl-data/images

#####

try:
    import cv2
except:
    pass

try:
    vrb.versionItk = fct.getItkVersion()
    import itk
    hasItk = True
except:
    hasItk = False
    #traceback.print_exc(file=sys.stderr)

convertSize = 1000000

# from skimage import io
# from skimage.morphology import dilation,disk

class BenchmarkWidget(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        self.groupFunction = GroupFunction(parent=self)

        self.fig = Figure()

        font = QtGui.QFont()
        font.setPixelSize(14*vrb.ratio)

        self.checkBoxLog = qt.QCheckBox("Log scale")
        self.checkBoxLog.setFont(font)
        self.checkBoxLog.setFixedWidth(100*vrb.ratio)

        self.checkBoxOpenCV = qt.QCheckBox("Open CV")
        self.checkBoxOpenCV.setFont(font)
        self.checkBoxOpenCV.setChecked(True)
        self.checkBoxOpenCV.setFixedWidth(84*vrb.ratio)

        # self.labelVersionOpenCV = qt.QLabel(cv2.__version__)
        # self.labelVersionOpenCV.setFont(font)

        emptyLabel1 = qt.QLabel()
        emptyLabel1.setFixedWidth(30*vrb.ratio)

        emptyLabel2 = qt.QLabel()
        emptyLabel2.setFixedWidth(30*vrb.ratio)

        self.checkBoxItk = qt.QCheckBox("ITK")
        self.checkBoxItk.setChecked(hasItk)
        self.checkBoxItk.setFont(font)
        self.checkBoxItk.setFixedWidth(40 * vrb.ratio)

        if hasItk:
            # self.labelVersionItk = qt.QLabel(itk.__version__)
            self.labelVersionItk = qt.QLabel()
            # self.labelVersionItk = qt.QLabel(versionItk)
            self.labelVersionItk.setFont(font)
            self.labelVersionItk.setFixedWidth(0)
        else:

            fontItk = QtGui.QFont()
            fontItk.setPixelSize(14 * vrb.ratio)
            fontItk.setUnderline(True)

            self.checkBoxItk.setEnabled(False)
            self.checkBoxItk.setStyleSheet("QCheckBox {; color : rgb(150, 150, 150); }")
            self.labelVersionItk = qt.QLabel("not installed")
            self.labelVersionItk.setFont(fontItk)
            self.labelVersionItk.setStyleSheet("QLabel {; color : rgb(6, 115, 186); }")

            text = "To install itk, please launch the following command on your terminal : \n"
            text += "(Administration right might be required)\n\n"
            text += '"'+os.path.dirname(vrb.folderExplorer) + '\\Miniconda\\Scripts\\pip.exe" install itk\n\n'
            text += "Then restart the application"

            self.messageBox = wgt.MessageBox(text, '', buttons=[qt.QMessageBox.Ok], windowTitle="Install ITK")
            self.messageBox.setTextInteractionFlags(Qt.TextSelectableByMouse)
            # self.messageBox.setFixedSize(500*vrb.ratio,70*vrb.ratio)

        # font.setPixelSize(17 * vrb.ratio)
        #
        # self.labelInitialize = qt.QLabel("Initializing libraries")
        # self.labelInitialize.setFixedSize(140*vrb.ratio, 30*vrb.ratio)
        # self.labelInitialize.setFont(font)
        # self.labelInitialize.setStyleSheet("QLabel {; color : rgb(6, 115, 186); }")
        # self.labelInitialize.setVisible(False)

        self.checkBoxImageJ = qt.QCheckBox("Image J")
        self.checkBoxImageJ.setChecked(False)
        self.checkBoxImageJ.setEnabled(False)
        self.checkBoxImageJ.setStyleSheet("QCheckBox {; color : rgb(150, 150, 150); }")
        self.checkBoxImageJ.setFont(font)
        self.checkBoxImageJ.setFixedWidth(78 * vrb.ratio)

        self.buttonPathImageJ = qt.QPushButton("...")
        self.buttonPathImageJ.setFixedWidth(25*vrb.ratio)

        groupBoxLib = qt.QGroupBox()
        layoutLib = qt.QHBoxLayout()
        layoutLib.setSpacing(0)
        groupBoxLib.setLayout(layoutLib)
        layoutLib.setContentsMargins(0,0,0,0)
        layoutLib.addWidget(self.checkBoxOpenCV)
        layoutLib.addWidget(emptyLabel1)
        layoutLib.addWidget(self.checkBoxItk)
        layoutLib.addWidget(self.labelVersionItk)
        layoutLib.addWidget(emptyLabel2)
        layoutLib.addWidget(self.checkBoxImageJ)
        layoutLib.addWidget(self.buttonPathImageJ)
        groupBoxLib.setFixedWidth(350*vrb.ratio)
        groupBoxLib.setAlignment(Qt.AlignLeft)

        self.plotWidget = FigureCanvas(self.fig)
        self.toolbar = wgt.NavigationToolbarWidget(self.plotWidget,self)
        self.toolbar.setFixedWidth(400*vrb.ratio)

        self.groupBoxProcessing = GroupBoxProcessing()
        self.groupBoxProcessing.setVisible(False)

        self.groupBoxProcessingInit = wgt.GroupBoxProcessing()
        self.groupBoxProcessingInit.setText("Initializing libraries")
        self.groupBoxProcessingInit.setVisible(False)

        self.groupBoxInit = qt.QGroupBox()
        self.groupBoxInit.setStyleSheet("QWidget {background-color: rgb(255,255,255);border: 0px transparent}")

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.groupFunction, 0, 0,1,4)
        self.layout.addWidget(self.toolbar, 1, 0,Qt.AlignLeft)
        self.layout.addWidget(self.checkBoxLog, 1, 1,Qt.AlignCenter)
        self.layout.addWidget(self.groupBoxProcessing, 1, 2,Qt.AlignCenter)
        self.layout.addWidget(groupBoxLib,1,3)

        self.layout.addWidget(self.plotWidget, 2, 0,1,4)
        self.layout.addWidget(self.groupBoxInit, 2, 0,1,4)
        self.layout.addWidget(self.groupBoxProcessingInit, 2, 0,1,4)
        # self.layout.addWidget(self.buttonCalibration, 0, 1)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        # self.layout.setContentsMargins(10, 10, 10, 10)
        self.layout.setContentsMargins(10,10,10,0)
        self.layout.setHorizontalSpacing(3)

        self.labelVersionItk.mousePressEvent = self.showInstallItk
        self.buttonPathImageJ.clicked.connect(self.pathToImageJ)
        self.checkBoxLog.stateChanged.connect(self.logChanged)

        self.setWindowTitle("Benchmark")

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        #self.verifImageJ()

        self.setMinimumSize(1060*vrb.ratio, 650*vrb.ratio)

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:

        self.plotWidget.setFixedSize(max(1,self.width()-20*vrb.ratio),max(1,self.height()-140*vrb.ratio))
        self.groupBoxInit.setFixedSize(max(1,self.width()-20*vrb.ratio),max(1,self.height()-140*vrb.ratio))

    def pathToImageJ(self):

        try:
            file = xmlet.parse(vrb.folderBenchmark + "/imageJ.mho")
            imageJElement = file.getroot()
        except:
            imageJElement = xmlet.Element('imageJ')

        path = Dfct.childText(imageJElement, "Path")
        if path is not None:
            defaultFolder = os.path.dirname(path)
        else:
            defaultFolder = "C:/Program Files/"
        filenameExe = qt.QFileDialog.getOpenFileName(self, "Select your Image J executable", defaultFolder,"(*.exe)")
        if filenameExe[0] != [] and filenameExe[0] != '' and filenameExe[0] != None:
            Dfct.SubElement(imageJElement, "Path").text = filenameExe[0]
            Dfct.saveXmlElement(imageJElement, vrb.folderBenchmark + "/imageJ.mho")

            self.verifImageJ()

    def verifImageJ(self):

        # self.groupBoxProcessing.progressBar.setVisible(False)
        # self.labelInitialize.setVisible(True)

        self.plotWidget.setVisible(False)
        self.groupBoxInit.setVisible(True)
        self.groupBoxProcessingInit.setVisible(True)
        self.layout.addWidget(self.groupBoxProcessingInit, 2, 0, 1, 4)
        qt.QApplication.processEvents()

        try:
            try:
                file = xmlet.parse(vrb.folderBenchmark + "/imageJ.mho")
                imageJElement = file.getroot()
            except:
                imageJElement = xmlet.Element('imageJ')

            path = Dfct.childText(imageJElement, "Path")
            if path is not None:
                try:
                    os.remove(vrb.folderBenchmark + "/ImageJ_Verif.txt")
                except:
                    pass
                file = open(vrb.folderBenchmark + "/ImageJ_Verif.py", 'r')
                text = file.read()
                text = text.replace("__pathToVerifImageJ__",vrb.folderBenchmark + "/ImageJ_Verif.txt")

                file = open(vrb.folderBenchmark + "/currentScriptVerif.py", "w")
                file.write(text)
                file.close()

                # subprocess.Popen(path + ' --ij2 --headless --console --run "'+vrb.folderBenchmark + '/currentScriptVerif.py"')
                # subprocess.check_call(path + ' --ij2 --headless --console --run "'+vrb.folderBenchmark + '/currentScriptVerif.py"')
                # fct.launchWithoutConsole(path + ' --ij2 --headless --console --run "'+vrb.folderBenchmark + '/currentScriptVerif.py"')
                subprocess.check_call(path + ' --ij2 --headless --run "'+vrb.folderBenchmark + '/currentScriptVerif.py"')

                fileVerif = open(vrb.folderBenchmark + "/ImageJ_Verif.txt", "r")
                textVerif = fileVerif.read()

                if textVerif == "Has ImageJ":
                    self.checkBoxImageJ.setChecked(True)
                    self.checkBoxImageJ.setEnabled(True)
                    self.checkBoxImageJ.setStyleSheet("QCheckBox {; color : rgb(255, 255, 255); }")

            else:
                self.checkBoxImageJ.setChecked(False)
                self.checkBoxImageJ.setEnabled(False)
                self.checkBoxImageJ.setStyleSheet("QCheckBox {; color : rgb(150, 150, 150); }")

        except Exception as e:

            self.checkBoxImageJ.setChecked(False)
            self.checkBoxImageJ.setEnabled(False)
            self.checkBoxImageJ.setStyleSheet("QCheckBox {; color : rgb(150, 150, 150); }")

        self.plotWidget.setVisible(True)
        self.groupBoxInit.setVisible(False)
        self.groupBoxProcessingInit.setVisible(False)
        qt.QApplication.processEvents()
        # self.labelInitialize.setVisible(False)

        vrb.imageJVersion = fct.getImageJVersion()

    def showInstallItk(self,_=None):

        self.messageBox.exec()

    def logChanged(self):

        self.displayResults()

    def displayResults(self,ddict = None):

        try:

            if ddict is None:
                ddict = self.ddict
            else:
                self.ddict = ddict

            legendX = ddict["Size"]

            self.fig.clf()
            axes = self.fig.add_subplot(111)

            line = axes.plot(legendX, ddict["IPSDK"],color="blue",linestyle ='solid',marker='o')
            if self.groupFunction.comboBoxFunctions.currentText() in ["Adaptive Contrast Enhancement 2D","Convolution 2D"]:
                line = axes.plot(legendX, ddict["IPSDK GPU"],color="cyan",linestyle ='solid',marker='o')
            # line = axes.plot(legendX, ddict["IPSDK"],color="blue",)
            if self.checkBoxOpenCV.isChecked() and self.groupFunction.comboBoxFunctions.currentText() in ["Dilation 2D","Mean Smoothing 2D","Median Filter 2D"]:
                line = axes.plot(legendX, ddict["Cv2"], color="green",linestyle ='solid',marker='o')
            if self.checkBoxItk.isChecked() and self.groupFunction.comboBoxFunctions.currentText() not in ["Adaptive Contrast Enhancement 2D","Convolution 2D"]:
                line = axes.plot(legendX, ddict["Itk"], color="red",linestyle ='solid',marker='o')
            if self.checkBoxImageJ.isChecked() and len(ddict["ImageJ"]) != 0 and self.groupFunction.comboBoxFunctions.currentText() not in ["Adaptive Contrast Enhancement 2D","Convolution 2D"]:
                line = axes.plot(legendX, ddict["ImageJ"], color="orange",linestyle ='solid',marker='o')
            # line = axes.plot(legendX, ddict["Skimage"], color="purple")

            axes.set_xlabel("Size (Mo)")
            axes.set_ylabel("Processing time (s)")

            if self.checkBoxLog.isChecked():
                axes.set_yscale("log")

            size = str(int(2*float(self.groupFunction.lineEditElementSize.text())+1))

            title = ""
            if self.groupFunction.comboBoxFunctions.currentText() == "Dilation 2D":
                title = "Benchmark dilation "+size + "x"+size
            if self.groupFunction.comboBoxFunctions.currentText() == "Mean Smoothing 2D":
                title = "Benchmark mean smoothing "+size + "x"+size
            if self.groupFunction.comboBoxFunctions.currentText() == "Median Filter 2D":
                title = "Benchmark median filter "+size + "x"+size
            if self.groupFunction.comboBoxFunctions.currentText() == "Adaptive Contrast Enhancement 2D":
                title = "Adaptive Contrast Enhancement "+size + "x"+size
            if self.groupFunction.comboBoxFunctions.currentText() == "Convolution 2D":
                title = "Convolution "+size + "x"+size
            if self.groupFunction.comboBoxFunctions.currentText() == "Dilation 3D":
                title = "Benchmark dilation "+size + "x"+size+ "x"+size
            if self.groupFunction.comboBoxFunctions.currentText() == "Mean Smoothing 3D":
                title = "Benchmark mean smoothing "+size + "x"+size+ "x"+size
            if self.groupFunction.comboBoxFunctions.currentText() == "Median Filter 3D":
                title = "Benchmark median filter "+size + "x"+size+ "x"+size

            axes.set_title(title)

            legend = ["IPSDK "+vrb.currentVersion]

            if self.groupFunction.comboBoxFunctions.currentText() in ["Adaptive Contrast Enhancement 2D","Convolution 2D"]:
                legend.append("IPSDK GPU")

            if self.checkBoxOpenCV.isChecked() and self.groupFunction.comboBoxFunctions.currentText() in ["Dilation 2D","Mean Smoothing 2D","Median Filter 2D"]:
                legend.append("Open CV "+ cv2.__version__)
            if self.checkBoxItk.isChecked():
                legend.append("ITK " + vrb.versionItk)
            if self.checkBoxImageJ.isChecked() and len(ddict["ImageJ"]) != 0:
                if vrb.hasPluginInra:
                    legend.append("Image J " + vrb.imageJVersion + " (MorphoLibJ)")
                else:
                    legend.append("Image J " + vrb.imageJVersion)

            axes.legend(legend)

            self.plotWidget.draw()

            qt.QApplication.processEvents()

        except:
            pass

class GroupDoubleWidget(qt.QGroupBox):

    def __init__(self, widget1,widget2,margins = 2):
        qt.QGroupBox.__init__(self)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(widget1, 0, 0)
        self.layout.addWidget(widget2, 0, 1,Qt.AlignLeft)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(margins,0,margins,0)

class GroupFunction(qt.QGroupBox):

    def __init__(self, parent=None):
        qt.QGroupBox.__init__(self)

        self.parent = parent
        self.stop = False

        self.labelFunction = qt.QLabel("Function")
        self.labelFunction.setFixedSize(50*vrb.ratio,30*vrb.ratio)
        self.comboBoxFunctions = qt.QComboBox()
        self.comboBoxFunctions.setFixedSize(150*vrb.ratio,30*vrb.ratio)

        group1 = GroupDoubleWidget(self.labelFunction,self.comboBoxFunctions)
        group1.setFixedSize(236*vrb.ratio,30*vrb.ratio)

        self.labelElementSize = qt.QLabel("Element half size")
        self.labelElementSize.setFixedSize(94*vrb.ratio, 30*vrb.ratio)
        self.lineEditElementSize = qt.QLineEdit()
        self.lineEditElementSize.setFixedSize(40*vrb.ratio, 30*vrb.ratio)
        self.lineEditElementSize.setText(str(3))
        self.lineEditElementSize.setPlaceholderText(str(3))

        group2 = GroupDoubleWidget(self.labelElementSize, self.lineEditElementSize)
        group2.setFixedSize(170 * vrb.ratio, 30 * vrb.ratio)

        self.comboBoxFunctions.addItem("Dilation 2D")
        self.comboBoxFunctions.addItem("Mean Smoothing 2D")
        self.comboBoxFunctions.addItem("Median Filter 2D")
        self.comboBoxFunctions.addItem("Adaptive Contrast Enhancement 2D")
        self.comboBoxFunctions.addItem("Convolution 2D")
        if allow3d:
            self.comboBoxFunctions.addItem("Dilation 3D")
            self.comboBoxFunctions.addItem("Mean Smoothing 3D")
            self.comboBoxFunctions.addItem("Median Filter 3D")

        self.labelMin = qt.QLabel("Min size (Mo)")
        self.labelMin.setFixedSize(78*vrb.ratio, 30*vrb.ratio)
        self.lineEditMin = qt.QLineEdit()
        self.lineEditMin.setFixedSize(55*vrb.ratio, 30*vrb.ratio)
        self.lineEditMin.setText(str(10))
        self.lineEditMin.setPlaceholderText(str(10))

        group3 = GroupDoubleWidget(self.labelMin, self.lineEditMin)
        group3.setFixedSize(171 * vrb.ratio, 30 * vrb.ratio)

        self.labelMax = qt.QLabel("Max size (Mo)")
        self.labelMax.setFixedSize(78 * vrb.ratio, 30 * vrb.ratio)
        self.lineEditMax = qt.QLineEdit()
        self.lineEditMax.setFixedSize(55*vrb.ratio, 30*vrb.ratio)
        self.lineEditMax.setText(str(100))
        self.lineEditMax.setPlaceholderText(str(100))

        group4 = GroupDoubleWidget(self.labelMax, self.lineEditMax)
        group4.setFixedSize(171 * vrb.ratio, 30 * vrb.ratio)

        self.labelNumberPoints = qt.QLabel("Number points")
        self.labelNumberPoints.setFixedSize(78 * vrb.ratio, 30 * vrb.ratio)
        self.lineEditNumberPoints = qt.QLineEdit()
        self.lineEditNumberPoints.setFixedSize(40* vrb.ratio, 30* vrb.ratio)
        self.lineEditNumberPoints.setText(str(10))
        self.lineEditNumberPoints.setPlaceholderText(str(10))

        group5 = GroupDoubleWidget(self.labelNumberPoints, self.lineEditNumberPoints)
        group5.setFixedSize(166 * vrb.ratio, 30 * vrb.ratio)

        # self.buttonStart = wgt.PushButtonImage(vrb.folderImages + "/Validate.png", margins=2)
        self.buttonStart = wgt.PushButtonDoubleImage(vrb.folderImages + "/Validate.png",vrb.folderImages + "/Delete2.png")
        self.buttonStart.setFixedSize(30* vrb.ratio,30* vrb.ratio)

        emptyLabel = qt.QLabel("")
        emptyLabel.setFixedWidth(10*vrb.ratio)

        self.benchmarkTable = BanchmarkTable()

        self.buttonTable = wgt.PushButtonImage(vrb.folderImages + "/tableau.png")
        self.buttonTable.setFixedSize(30* vrb.ratio,30* vrb.ratio)
        self.buttonTable.setVisible(False)

        self.layout = qt.QGridLayout()

        self.layout.setAlignment(Qt.AlignLeft)

        self.layout.addWidget(group1, 0, 0)
        self.layout.addWidget(group2, 0, 1)
        self.layout.addWidget(group3, 0, 2)
        self.layout.addWidget(group4, 0, 3)
        self.layout.addWidget(group5, 0, 4)
        self.layout.addWidget(self.buttonStart, 0, 6)
        self.layout.addWidget(emptyLabel, 0, 7)
        self.layout.addWidget(self.buttonTable, 0, 8)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        # self.layout.setContentsMargins(10, 10, 10, 10)
        self.layout.setContentsMargins(10,10,10,10)
        # self.layout.setHorizontalSpacing(10)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.setFixedSize(1100*vrb.ratio, 40*vrb.ratio)

        self.buttonStart.clicked.connect(self.startBenchmark)
        self.buttonTable.clicked.connect(self.showBenchmarkTable)
        self.comboBoxFunctions.currentIndexChanged.connect(self.functionChanged)

    def showBenchmarkTable(self):

        self.benchmarkTable.fillTable(self.ddict)
        # self.benchmarkTable.show()

    def functionChanged(self):

        boolValue = self.comboBoxFunctions.currentText() in ["Dilation 2D","Mean Smoothing 2D","Median Filter 2D"]
        self.parent.checkBoxOpenCV.setVisible(boolValue)
        # self.parent.labelVersionOpenCV.setVisible(boolValue)

    def startBenchmark(self):

        if self.buttonStart.activate:

            self.stop = True

        else:
            self.buttonStart.changeActivation()
            vrb.hasPluginInra = True

            self.parent.groupBoxProcessing.labelLeft.setText("Loading...")
            qt.QApplication.processEvents()

            is2D = self.comboBoxFunctions.currentText() in ["Dilation 2D","Mean Smoothing 2D","Median Filter 2D","Adaptive Contrast Enhancement 2D","Convolution 2D"]

            self.parent.groupBoxProcessing.progressBar.setValue(0)
            self.parent.groupBoxProcessing.setVisible(True)
            qt.QApplication.processEvents()

            self.ddict = {}
            self.ddict["Size"] = []
            self.ddict["IPSDK"] = []
            self.ddict["IPSDK GPU"] = []
            self.ddict["Cv2"] = []
            self.ddict["Itk"] = []
            self.ddict["ImageJ"] = []
            # ddict["Skimage"] = []

            try:
                minSize = float(self.lineEditMin.text())*convertSize
            except:
                minSize = float(10*convertSize)

            try:
                maxSize = float(self.lineEditMax.text())*convertSize
            except:
                maxSize = float(100*convertSize)

            try:
                nbPoints = int(self.lineEditNumberPoints.text())
            except:
                nbPoints = 10

            try:
                elementSize = int(self.lineEditElementSize.text())
            except:
                elementSize = int(3)

            if self.parent.checkBoxItk.isChecked():
                PixelType = itk.UC
                if is2D:
                    Dimension = 2
                else:
                    Dimension = 3
                ImageType = itk.Image[PixelType, Dimension]

            if self.parent.checkBoxImageJ.isChecked():
                try:
                    file = xmlet.parse(vrb.folderBenchmark + "/imageJ.mho")
                    imageJElement = file.getroot()
                except:
                    imageJElement = xmlet.Element('imageJ')

                pathImageJ = Dfct.childText(imageJElement, "Path")

            allSizes = []

            for i in range(nbPoints):
                allSizes.append(minSize + (i / (nbPoints - 1)) * (maxSize - minSize))

            if self.comboBoxFunctions.currentText() in ["Dilation 2D", "Dilation 3D"]:
                if self.comboBoxFunctions.currentText() == "Dilation 2D":
                    strel = PyIPSDK.circularSEXYInfo(elementSize)
                    kernel = cv2.getStructuringElement(cv2.MORPH_ELLIPSE, (2 * elementSize + 1, 2 * elementSize + 1))

                if self.comboBoxFunctions.currentText() == "Dilation 3D":
                    strel = PyIPSDK.sphericalSEXYZInfo(elementSize)

                if self.parent.checkBoxItk.isChecked():
                    StructuringElementType = itk.FlatStructuringElement[Dimension]
                    structuringElement = StructuringElementType.Ball(elementSize)

            if self.parent.checkBoxImageJ.isChecked() and self.comboBoxFunctions.currentText() not in ["Adaptive Contrast Enhancement 2D","Convolution 2D"]:

                nameScriptImageJ_Bis = ""

                if self.comboBoxFunctions.currentText() == "Dilation 2D":

                    nameScriptImageJ = "ImageJ_Dilation2D_Inra.py"
                    nameScriptImageJ_Bis = "ImageJ_Dilation2D.py"

                if self.comboBoxFunctions.currentText() == "Dilation 3D":

                    nameScriptImageJ = "ImageJ_Dilation3D_Inra.py"

                if self.comboBoxFunctions.currentText() == "Mean Smoothing 2D":

                    nameScriptImageJ = "ImageJ_Mean2D.py"
                    vrb.hasPluginInra = False

                if self.comboBoxFunctions.currentText() == "Mean Smoothing 3D":

                    nameScriptImageJ = "ImageJ_Mean3D.py"
                    vrb.hasPluginInra = False

                if self.comboBoxFunctions.currentText() == "Median Filter 2D":

                    nameScriptImageJ = "ImageJ_Median2D.py"
                    vrb.hasPluginInra = False

                if self.comboBoxFunctions.currentText() == "Median Filter 3D":

                    nameScriptImageJ = "ImageJ_Median3D.py"
                    vrb.hasPluginInra = False

                file = open(vrb.folderBenchmark + "/" + nameScriptImageJ, 'r')
                text = file.read()
                text = text.replace("__PathToImage__", vrb.folderBenchmark + "/currentImage.tif")
                text = text.replace("__PathToResult__", vrb.folderBenchmark + "/currentTime.txt")
                text = text.replace("__HalfSize__", str(elementSize))
                file = open(vrb.folderBenchmark + "/currentScript.py", "w")

                file.write(text)
                file.close()

                if nameScriptImageJ_Bis != "":
                    file = open(vrb.folderBenchmark + "/" + nameScriptImageJ_Bis, 'r')
                    text = file.read()
                    text = text.replace("__PathToImage__", vrb.folderBenchmark + "/currentImage.tif")
                    text = text.replace("__PathToResult__", vrb.folderBenchmark + "/currentTime.txt")
                    text = text.replace("__HalfSize__", str(elementSize))
                    file = open(vrb.folderBenchmark + "/currentScript_Bis.py", "w")
                    file.write(text)
                    file.close()


            nbImages = 1
            if self.parent.checkBoxOpenCV.isChecked() and is2D:
                nbImages+= 1
            if self.parent.checkBoxItk.isChecked():
                nbImages += 1
            if self.parent.checkBoxImageJ.isChecked():
                nbImages += 1
            nbImages*=nbPoints
            currentImage = 0

            self.parent.groupBoxProcessing.labelLeft.setText("Processing...")
            qt.QApplication.processEvents()

            try:

                for size in allSizes:

                    if self.stop == False:

                        self.ddict["Size"].append(int(size/convertSize))

                        if is2D:
                            imageSize = int(np.sqrt(size))
                        else:
                            imageSize = int(size**(1/3))

                        #################
                        #IPSDK
                        ################

                        if is2D:
                            image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize)
                            gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                            util.gaussianRandomImg(gaussianParameter, image1)
                        else:
                            image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize,imageSize)
                            gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                            util.gaussianRandomImg(gaussianParameter, image1)

                        if self.comboBoxFunctions.currentText() == "Dilation 2D":

                            start = time.time()
                            outImage = morpho.dilate2dImg(image1, strel)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                        elif self.comboBoxFunctions.currentText() == "Mean Smoothing 2D":

                            start = time.time()
                            outImage = filtering.meanSmoothing2dImg(image1, elementSize,elementSize)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                        elif self.comboBoxFunctions.currentText() == "Median Filter 2D":

                            start = time.time()
                            outImage = filtering.median2dImg(image1, elementSize,elementSize)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                        elif self.comboBoxFunctions.currentText() == "Dilation 3D":

                            start = time.time()
                            outImage = morpho.dilate3dImg(image1, strel)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                        elif self.comboBoxFunctions.currentText() == "Mean Smoothing 3D":

                            start = time.time()
                            outImage = filtering.meanSmoothing3dImg(image1, elementSize,elementSize,elementSize)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                        elif self.comboBoxFunctions.currentText() == "Median Filter 3D":

                            start = time.time()
                            outImage = filtering.median3dImg(image1, elementSize,elementSize,elementSize)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                        elif self.comboBoxFunctions.currentText() == "Adaptive Contrast Enhancement 2D":

                            start = time.time()
                            outImage = itrans.adaptiveContrastEnhancement2dImg(image1, elementSize, elementSize, 10.0, 0.5)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                            image1_GPU = image1.toGPU()
                            start = time.time()
                            outImageGPU = itrans.adaptiveContrastEnhancement2dImg(image1_GPU, elementSize, elementSize, 10.0, 0.5)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK GPU"].append(timeCompute)

                        elif self.comboBoxFunctions.currentText() == "Convolution 2D":

                            vector = []
                            for i in range((2*elementSize +1)**2):
                                vector.append(1)
                            kernel = PyIPSDK.rectangularKernelXY(elementSize, elementSize, vector)

                            start = time.time()
                            outImage = filtering.convolution2dImg(image1, kernel, True)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK"].append(timeCompute)

                            image1_GPU = image1.toGPU()
                            start = time.time()
                            outImageGPU = filtering.convolution2dImg(image1_GPU, kernel, True)
                            timeCompute = time.time()-start

                            self.ddict["IPSDK GPU"].append(timeCompute)

                        currentImage += 1
                        self.parent.groupBoxProcessing.progressBar.setValue(100*currentImage/nbImages)
                        qt.QApplication.processEvents()

                        if self.parent.checkBoxOpenCV.isChecked() and is2D and self.comboBoxFunctions.currentText() not in ["Adaptive Contrast Enhancement 2D","Convolution 2D"]:

                            #################
                            #Open CV
                            ################

                            if is2D:
                                image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize)
                                gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                                util.gaussianRandomImg(gaussianParameter, image1)
                            else:
                                image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize, imageSize)
                                gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                                util.gaussianRandomImg(gaussianParameter, image1)

                            if self.comboBoxFunctions.currentText() == "Dilation 2D":

                                array = image1.array

                                start = time.time()
                                dilatedImage = cv2.dilate(array, kernel, iterations=1)
                                timeCompute = time.time() - start

                                self.ddict["Cv2"].append(timeCompute)

                                #outImage = PyIPSDK.fromArray(dilatedImage)

                            elif self.comboBoxFunctions.currentText() == "Mean Smoothing 2D":

                                array = image1.array

                                start = time.time()
                                meanImage = cv2.blur(array, (2*elementSize+1,2*elementSize+1))
                                timeCompute = time.time() - start

                                self.ddict["Cv2"].append(timeCompute)

                                # outImage = PyIPSDK.fromArray(meanImage)
                                # ui.displayImg(outImage, "cv2",pause=False)

                            elif self.comboBoxFunctions.currentText() == "Median Filter 2D":

                                array = image1.array

                                start = time.time()
                                medianImage = cv2.medianBlur(array,2*elementSize+1)
                                timeCompute = time.time() - start

                                self.ddict["Cv2"].append(timeCompute)

                            currentImage += 1
                            self.parent.groupBoxProcessing.progressBar.setValue(100 * currentImage / nbImages)
                            qt.QApplication.processEvents()

                        if self.parent.checkBoxItk.isChecked() and self.comboBoxFunctions.currentText() not in ["Adaptive Contrast Enhancement 2D","Convolution 2D"]:

                            # #################
                            #ITK
                            ################

                            if is2D:
                                image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize)
                                gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                                util.gaussianRandomImg(gaussianParameter, image1)
                            else:
                                image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize, imageSize)
                                gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                                util.gaussianRandomImg(gaussianParameter, image1)

                            if self.comboBoxFunctions.currentText() in ["Dilation 2D","Dilation 3D"]:

                                array = image1.array
                                imageItk = itk.GetImageFromArray(array)

                                grayscaleFilter = itk.GrayscaleDilateImageFilter[ImageType, ImageType, StructuringElementType].New()
                                grayscaleFilter.SetInput(imageItk)
                                grayscaleFilter.SetKernel(structuringElement)

                                dilatedImage = grayscaleFilter.GetOutput()

                                start = time.time()
                                array = itk.GetArrayFromImage(dilatedImage)
                                timeCompute = time.time() - start

                                self.ddict["Itk"].append(timeCompute)

                                outImage = PyIPSDK.fromArray(array)
                                # ui.displayImg(outImage, "itk",pause=False)

                            if self.comboBoxFunctions.currentText() in ["Mean Smoothing 2D","Mean Smoothing 3D"]:

                                array = image1.array
                                imageItk = itk.GetImageFromArray(array)

                                meanFilter = itk.MeanImageFilter[ImageType, ImageType].New()
                                meanFilter.SetInput(imageItk)
                                meanFilter.SetRadius(elementSize)

                                meanImage = meanFilter.GetOutput()

                                start = time.time()
                                array = itk.GetArrayFromImage(meanImage)
                                timeCompute = time.time() - start

                                self.ddict["Itk"].append(timeCompute)

                                outImage = PyIPSDK.fromArray(array)
                                # ui.displayImg(outImage, "itk",pause=False)

                            if self.comboBoxFunctions.currentText() in ["Median Filter 2D","Median Filter 3D"]:

                                array = image1.array
                                imageItk = itk.GetImageFromArray(array)

                                medianFilter = itk.MedianImageFilter[ImageType, ImageType].New()
                                medianFilter.SetInput(imageItk)
                                medianFilter.SetRadius(elementSize)

                                medianImage = medianFilter.GetOutput()

                                start = time.time()
                                array = itk.GetArrayFromImage(medianImage)
                                timeCompute = time.time() - start

                                self.ddict["Itk"].append(timeCompute)

                                outImage = PyIPSDK.fromArray(array)
                                # ui.displayImg(outImage, "itk",pause=False)

                            currentImage += 1
                            self.parent.groupBoxProcessing.progressBar.setValue(100 * currentImage / nbImages)
                            qt.QApplication.processEvents()

                        if self.parent.checkBoxImageJ.isChecked() and pathImageJ is not None:

                            try:

                                #################
                                #Image J
                                ################

                                if is2D:
                                    image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize)
                                    gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                                    util.gaussianRandomImg(gaussianParameter, image1)
                                    PyIPSDK.saveTiffImageFile(vrb.folderBenchmark + "/currentImage.tif", image1)
                                else:
                                    image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize, imageSize)
                                    gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                                    util.gaussianRandomImg(gaussianParameter, image1)
                                    PyIPSDK.saveTiffImageFile(vrb.folderBenchmark + "/currentImage.tif", image1)

                                try:
                                    os.remove(vrb.folderBenchmark + "/currentTime.txt")
                                except:
                                    pass

                                if vrb.hasPluginInra or self.comboBoxFunctions.currentText() not in ["Dilation 2D","Dilation 3D"]:
                                    subprocess.check_call(pathImageJ + ' --ij2 --headless --run "' + vrb.folderBenchmark + '/currentScript.py"')

                                try:
                                    fileTime = open(vrb.folderBenchmark + "/currentTime.txt", "r")
                                    textTime = fileTime.read()
                                    self.ddict["ImageJ"].append(float(textTime))
                                    fileTime.close()
                                except:
                                    #traceback.print_exc(file=sys.stderr)
                                    vrb.hasPluginInra = False
                                    if is2D:
                                        try:
                                            subprocess.check_call(pathImageJ + ' --ij2 --headless --run "' + vrb.folderBenchmark + '/currentScript_Bis.py"')
                                        except:
                                            pass
                                        try:
                                            fileTime = open(vrb.folderBenchmark + "/currentTime.txt", "r")
                                            textTime = fileTime.read()
                                            self.ddict["ImageJ"].append(float(textTime))
                                            fileTime.close()
                                        except:
                                            pass
                                    pass

                            except:
                                pass

                            currentImage += 1
                            self.parent.groupBoxProcessing.progressBar.setValue(100 * currentImage / nbImages)
                            qt.QApplication.processEvents()

                        # #################
                        # #skimage
                        # ################
                        #
                        # image1 = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_UInt8, imageSize, imageSize)
                        # gaussianParameter = PyIPSDK.createGaussianParameter(100.0, 25.0)
                        # util.gaussianRandomImg(gaussianParameter, image1)
                        #
                        # if self.comboBoxFunctions.currentText() == "Dilation":
                        #
                        #     array = image1.array
                        #
                        #     start = time.time()
                        #     dilatedImage = dilation(array,skStrel)
                        #     timeCompute = time.time() - start
                        #
                        #     ddict["Skimage"].append(timeCompute)
                        #
                        #     outImage = PyIPSDK.fromArray(dilatedImage)
                        #
                        #     # ui.displayImg(outImage, "Skimage",pause=False)

                        self.parent.displayResults(self.ddict)

                self.stop = False
                self.buttonTable.setVisible(True)
                #self.buttonStart.setActivation(False)
                self.parent.groupBoxProcessing.setVisible(False)

                # self.buttonStart.setEnabled(True)

            except:
                traceback.print_exc(file=sys.stderr)
                self.stop = False
                self.buttonStart.setActivation(False)
                self.parent.groupBoxProcessing.setVisible(False)

                # self.buttonStart.setEnabled(True)

            self.buttonStart.changeActivation()
            qt.QApplication.processEvents()


class GroupBoxProcessing(qt.QGroupBox):
    def __init__(self):
        super(GroupBoxProcessing, self).__init__()

        self.innerGroupBox = qt.QGroupBox()

        self.labelLeft = qt.QLabel('Processing...')
        self.labelLeft.setFixedSize(70*vrb.ratio, 30*vrb.ratio)
        self.progressBar = qt.QProgressBar()
        self.progressBar.setAlignment(Qt.AlignCenter)
        self.progressBar.setRange(0, 100)
        self.progressBar.setValue(0)
        self.progressBar.setFixedSize(200*vrb.ratio, 30*vrb.ratio)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelLeft, 0, 0)
        self.layout.addWidget(self.progressBar, 0, 1,Qt.AlignLeft)
        self.setLayout(self.layout)

        self.setFixedSize(500*vrb.ratio,40*vrb.ratio)

class BanchmarkTable(qt.QWidget):
    def __init__(self):
        super(BanchmarkTable, self).__init__()

        self.buttonSave = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=2)
        self.buttonSave.setFixedSize(30, 30)

        self.tableWidget = qt.QTableWidget()
        self.tableWidget.setAlternatingRowColors(True)

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.buttonSave, 0, 0)
        self.layout.addWidget(self.tableWidget, 1, 0)
        self.setLayout(self.layout)

        self.setMinimumSize(800*vrb.ratio, 450*vrb.ratio)
        self.resize(1000*vrb.ratio, 450*vrb.ratio)

        self.buttonSave.clicked.connect(self.saveFileResult)
        # self.tableWidget.itemSelectionChanged.connect(self.currentCellChanged)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

    def fillTable(self,ddict):

        try:

            self.tableWidget.clear()
            nbRow = len(ddict["Size"])

            self.tableWidget.setColumnCount(8)
            self.tableWidget.setRowCount(max(10,nbRow+2))

            cell = qt.QTableWidgetItem("Size (Mo) ")
            self.tableWidget.setItem(0, 0, cell)
            for i in range(len(ddict["Size"])):
                cell = qt.QTableWidgetItem(fct.numberCalibration(ddict["Size"][i]))
                self.tableWidget.setItem(i+1, 0, cell)

            cell = qt.QTableWidgetItem("IPSDK " + vrb.currentVersion + " (s)")
            self.tableWidget.setItem(0, 1, cell)
            for i in range(len(ddict["IPSDK"])):
                cell = qt.QTableWidgetItem(fct.numberCalibration(ddict["IPSDK"][i]))
                self.tableWidget.setItem(i+1, 1, cell)

            numColumn = 1
            if "Cv2" in ddict and len(ddict["Cv2"])>=1:
                numColumn += 1
                cell = qt.QTableWidgetItem("Open CV "+ cv2.__version__ + " (s)")
                self.tableWidget.setItem(0, numColumn, cell)
                for i in range(len(ddict["Cv2"])):
                    cell = qt.QTableWidgetItem(fct.numberCalibration(ddict["Cv2"][i]))
                    self.tableWidget.setItem(i + 1, numColumn, cell)
            if "Itk" in ddict and len(ddict["Itk"])>=1:
                numColumn += 1
                cell = qt.QTableWidgetItem("ITK "+ vrb.versionItk +" (s)")
                self.tableWidget.setItem(0, numColumn, cell)
                for i in range(len(ddict["Itk"])):
                    cell = qt.QTableWidgetItem(fct.numberCalibration(ddict["Itk"][i]))
                    self.tableWidget.setItem(i + 1, numColumn, cell)
            if "ImageJ" in ddict and len(ddict["ImageJ"])>=1:
                numColumn += 1
                cell = qt.QTableWidgetItem("ImageJ "+ vrb.imageJVersion +" (s)")
                self.tableWidget.setItem(0, numColumn, cell)
                for i in range(len(ddict["ImageJ"])):
                    cell = qt.QTableWidgetItem(fct.numberCalibration(ddict["ImageJ"][i]))
                    self.tableWidget.setItem(i + 1, numColumn, cell)

            numColumn += 2

            numRow = 1
            # cell = qt.QTableWidgetItem("Configuration")
            # self.tableWidget.setItem(numRow, numColumn, cell)
            #numRow+=1

            cell = qt.QTableWidgetItem("System")
            self.tableWidget.setItem(numRow, numColumn, cell)

            try:
                uname = platform.uname()
                systemName = uname.system + " " + uname.release
            except:
                systemName = ""
            cell = qt.QTableWidgetItem(systemName)
            self.tableWidget.setItem(numRow, numColumn + 1, cell)
            numRow += 1

            cell = qt.QTableWidgetItem("Processor")
            self.tableWidget.setItem(numRow, numColumn, cell)

            try:
                from win32com.client import GetObject
                root_winmgmts = GetObject("winmgmts:root\cimv2")
                cpus = root_winmgmts.ExecQuery("Select * from Win32_Processor")
                procName = cpus[0].Name
            except:
                procName =""

            cell = qt.QTableWidgetItem(procName)
            self.tableWidget.setItem(numRow, numColumn+1, cell)
            numRow += 1
            self.tableWidget.setColumnWidth(numColumn,250*vrb.ratio)

            cell = qt.QTableWidgetItem("Number of physical core/logical core")
            self.tableWidget.setItem(numRow, numColumn, cell)
            try:
                lcd = PyIPSDK.getLocalComputerDescription()
                cell = qt.QTableWidgetItem(str(lcd.getCpuDescription().getNbPhysicalCores())+"/"+str(lcd.getCpuDescription().getNbLogicalCores()))
                self.tableWidget.setItem(numRow, numColumn + 1, cell)
            except:
                pass
            numRow += 1
            self.tableWidget.setColumnWidth(numColumn + 1, 250 * vrb.ratio)

            cell = qt.QTableWidgetItem("RAM")
            self.tableWidget.setItem(numRow, numColumn, cell)

            try:
                import psutil
                svmem = psutil.virtual_memory()
                ramValue = str(fct.get_size(svmem.total))
            except:
                ramValue = ""
            cell = qt.QTableWidgetItem(ramValue)
            self.tableWidget.setItem(numRow, numColumn+1, cell)
            numRow += 1

            cell = qt.QTableWidgetItem("Accelerations available")
            self.tableWidget.setItem(numRow, numColumn, cell)
            try:
                textAccelerations = ""
                if PyIPSDK.isAvailable(PyIPSDK.eInstructionSet.eIS_Sse2):
                    textAccelerations += "SSE2/"
                if PyIPSDK.isAvailable(PyIPSDK.eInstructionSet.eIS_Avx):
                    textAccelerations += "AVX/"
                if PyIPSDK.isAvailable(PyIPSDK.eInstructionSet.eIS_Avx2):
                    textAccelerations += "AVX2/"
                if PyIPSDK.isAvailable(PyIPSDK.eInstructionSet.eIS_Avx512):
                    textAccelerations += "AVX512/"
                if textAccelerations != "":
                    textAccelerations = textAccelerations[:-1]
                cell = qt.QTableWidgetItem(textAccelerations)
                self.tableWidget.setItem(numRow, numColumn + 1, cell)
                numRow += 1
            except:
                pass
            self.tableWidget.setColumnWidth(numColumn + 1, 250 * vrb.ratio)

            cell = qt.QTableWidgetItem("RAM")
            self.tableWidget.setItem(numRow, numColumn, cell)

            cell = qt.QTableWidgetItem("Graphics Card")
            self.tableWidget.setItem(numRow, numColumn, cell)

            try:
                import wmi
                computer = wmi.WMI()
                gpu_info = computer.Win32_VideoController()[0]
                graphicCardName = gpu_info.Name
            except:
                graphicCardName = ""
            cell = qt.QTableWidgetItem(graphicCardName)
            self.tableWidget.setItem(numRow, numColumn + 1, cell)
            numRow += 1

        except:
            pass

        if self.isMaximized():
            self.showMaximized()
        else:
            self.showNormal()
        self.window().raise_()
        self.window().activateWindow()

        # try:
        #     self.tableWidget.setColumnWidth(1,100*vrb.ratio)
        # except:
        #     pass

    def saveFileResult(self):

        filename = qt.QFileDialog.getSaveFileName(self, "Save file as", "","(*.xls);;(*.csv)")
        if filename[1] == "(*.xls)":
            fct.convertToXlsFile(self.tableWidget,filename[0])
        if filename[1] == "(*.csv)":
            fct.convertToCsvFile(self.tableWidget,filename[0])

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook

    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook

    # inImage = PyIPSDK.loadTiffImageFile("D:/ExampleImages/ImageLabel.tif")

    # foo = GroupFunction()
    foo = BenchmarkWidget()

    foo.show()
    foo.verifImageJ()

    pixmap = QtGui.QPixmap(vrb.folderImages + '/Explorer_Logo_Bleu.png')
    pixmap = pixmap.scaled(20, 20, transformMode=Qt.SmoothTransformation)
    app.setWindowIcon(QtGui.QIcon(pixmap))

    app.exec_()