import sys

from PyQt5.QtCore import pyqtSignal, Qt,QCoreApplication
import PyQt5.QtWidgets as qt
from PyQt5 import QtGui

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet
import UsefullFunctionsForWidget as fctWidget

from SpecialToScriptDictionary import dictSpecialToScript

import UsefullVariables as vrb
import WidgetTypes
from CustomWidgets import MyTextEdit

class AdvancedWidget(qt.QGroupBox):
    """
    Widget containing a comboBox. It will show other widgets depending on the comboBox choice
    """
    SignalHeightChanged = pyqtSignal()
    SignalSelectionComboBoxChanged = pyqtSignal()

    def __init__(self, xmlElement, type):
        if type != WidgetTypes.InputType.ADVANCED:
            print('ERROR : InputType does not match', file=sys.stderr)
        super().__init__()

        self.advancedNode = Dfct.SubElement(xmlElement, 'AdvancedEnum')

        self.margins = 4*vrb.ratio
        self.spacing = 4*vrb.ratio
        self.sizeWidget = 20*vrb.ratio
        self.titleTopPadding = int(10*vrb.ratio)
        self.titleTopSpacing = 3
        self.comboBoxEnum = qt.QComboBox(self)
        self.comboBoxEnum.setFixedHeight(self.sizeWidget)

        self.layout = qt.QGridLayout()
        self.layout.setContentsMargins(self.margins, self.margins, self.margins, self.margins)
        self.layout.setVerticalSpacing(self.spacing)

        for nbEnum, enumNode in enumerate(self.advancedNode, 0):
            parameters = {}
            groupBoxParams = qt.QGroupBox()
            layoutEnum = qt.QGridLayout()
            layoutEnum.setContentsMargins(0, 0, 0, 0)
            layoutEnum.setVerticalSpacing(self.spacing)
            sumSizeGroupBox = 0
            for nbParam, paramNode in enumerate(enumNode, 0):
                label, widget, constraints, type,defaultValue = fctWidget.generateParamWidget(paramNode)
                if widget is not None:
                    parameters[nbParam] = {}
                    parameters[nbParam]['Type'] = type
                    parameters[nbParam]['Label'] = label
                    parameters[nbParam]['Widget'] = widget

                    if type == WidgetTypes.InputType.STRING_EDIT:
                        widget.setFixedHeight(55)

                    # widget.setFixedHeight(self.sizeWidget)

                    sumSizeGroupBox += widget.height() + self.spacing
                    parameters[nbParam]['Constraints'] = constraints
                    if parameters[nbParam]['Label'] is not None:
                        layoutEnum.addWidget(parameters[nbParam]['Label'], nbParam, 0, Qt.AlignHCenter)
                        layoutEnum.addWidget(parameters[nbParam]['Widget'], nbParam, 1, Qt.AlignHCenter)
                    else:
                        layoutEnum.addWidget(parameters[nbParam]['Widget'], nbParam, 0, 1, 2, Qt.AlignHCenter)
                    if type == WidgetTypes.InputType.IMAGE:
                        widget.currentIndexChanged.connect(self.emitSignalSelectionComboBoxChanged)
                    try:
                        # Connect other advanced widgets
                        widget.SignalHeightChanged.connect(self.changeHeight)
                    except:
                        pass
            sumSizeGroupBox += -self.spacing
            sumSizeGroupBox = max(1,sumSizeGroupBox)
            groupBoxParams.setLayout(layoutEnum)
            groupBoxParams.setFixedHeight(sumSizeGroupBox)
            groupBoxParams.setStyleSheet("QGroupBox {border: 0px transparent; }")
            self.comboBoxEnum.addItem(enumNode.get('UserName'), {'GroupBox': groupBoxParams, 'Parameters': parameters, 'Name': enumNode.get('Name')})
            self.layout.addWidget(groupBoxParams, 1, 0)

        self.layout.addWidget(self.comboBoxEnum, 0, 0)

        self.setLayout(self.layout)
        self.setStyleSheet('.AdvancedWidget:title {left: '+str(int(4*vrb.ratio))+'px;padding-left: '+str(int(4*vrb.ratio))+'px;padding-right: '+str(int(4*vrb.ratio))+'px;padding-top: -' + str(self.titleTopPadding) + 'px; color:rgb(6, 115, 186)}  AdvancedWidget{font: bold;border: 1px solid gray; margin-top: '+str(int(4*vrb.ratio))+'px; padding-top:' + str(self.titleTopSpacing) + 'px }')

        self.comboBoxEnum.currentIndexChanged.connect(self.comboBoxIndexChanged)
        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is None:
            defaultValue = Dfct.childText(xmlElement, 'Default')
            if defaultValue is not None:
                self.comboBoxEnum.setCurrentIndex(int(defaultValue))
                Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)
        else:
            self.comboBoxEnum.setCurrentIndex(int(userValue))
        self.comboBoxIndexChanged()

    # def resetValueInterface(self, xmlElement):
    #     defaultValue = Dfct.childText(xmlElement, 'Default')
    #     if defaultValue is not None:
    #         self.comboBoxEnum.setCurrentIndex(int(defaultValue))
    #         Dfct.SubElement(xmlElement, 'Value').text = str(defaultValue)

    def userValueToInterface(self, xmlElement):
        userValue = Dfct.childText(xmlElement, 'Value')
        if userValue is not None:
            self.comboBoxEnum.setCurrentIndex(int(userValue))

    def emitSignalSelectionComboBoxChanged(self):
        self.SignalSelectionComboBoxChanged.emit()

    def comboBoxIndexChanged(self):
        index = self.comboBoxEnum.currentIndex()
        for nb in range(self.comboBoxEnum.count()):
            self.comboBoxEnum.itemData(nb)['GroupBox'].setVisible(nb == index)

            try:
                file = xmlet.parse(vrb.folderInformation + "/Settings.mho")
                settingsElement = file.getroot()
            except:
                settingsElement = xmlet.Element('Settings')

            fontProcessFunctionsElement = Dfct.SubElement(settingsElement, "FontProcessFunctions")
            font = QtGui.QFont()
            try:
                font.setPointSize(int(fontProcessFunctionsElement.text))
            except:
                font.setPointSize(10)
            for param in self.comboBoxEnum.currentData()['Parameters'].values():
                try:
                    param['Label'].setFont(font)
                    param['Widget'].setFont(font)
                except:
                    pass

        self.changeHeight()

    def interfaceToXml(self, number):
        paramNode = xmlet.Element('Parameter_' + str(number))
        typeNode = Dfct.SubElement(paramNode, 'Type')
        typeNode.text = WidgetTypes.InputType.ADVANCED.value
        typeOfAdvanced = self.advancedNode.get('Special')
        if typeOfAdvanced is not None and typeOfAdvanced != '':
            typeNode.set('Special', typeOfAdvanced)
        Dfct.SubElement(paramNode, 'Choice').text = self.comboBoxEnum.currentData()['Name']
        valuesNode = Dfct.SubElement(paramNode, 'Values')
        for nb, param in enumerate(self.comboBoxEnum.currentData()['Parameters'].values(), 0):
            valuesNode.append(param['Widget'].interfaceToXml(nb))
        return paramNode

    @staticmethod
    def xmlToValue(xmlElement, paramName=None, process=True):
        values = [Dfct.childText(xmlElement, 'Choice')]
        for valueNode in Dfct.SubElement(xmlElement, 'Values'):
            typeParam = WidgetTypes.InputType.stringToType(Dfct.childText(valueNode, 'Type'))
            values.append(WidgetTypes.InputType.typeToClass(typeParam).xmlToValue(valueNode))

        type = Dfct.SubElement(xmlElement, 'Type').get("Special")
        if type in dictSpecialToScript:
            values = dictSpecialToScript[type](values, paramName=paramName, process=process)
        return values

    def changeHeight(self):
        totalHeight = 2 * self.margins + 1 * self.spacing + self.titleTopPadding + self.titleTopSpacing
        totalHeight += self.sizeWidget
        totalGroupBox = 0
        for param in self.comboBoxEnum.currentData()['Parameters'].values():
            # Sum of widget size
            totalGroupBox += param['Widget'].height() + self.spacing
        totalGroupBox += -self.spacing
        totalGroupBox = max(1,totalGroupBox)
        self.comboBoxEnum.currentData()['GroupBox'].setFixedHeight(totalGroupBox)
        totalHeight += totalGroupBox
        self.setFixedHeight(totalHeight)
        self.SignalHeightChanged.emit()

    def loadXmlElements(self, xmlAllElements, positionSelectedLabel, listComboBoxesIndex):
        for num in range(self.comboBoxEnum.count()):
            fctWidget.loadXmlElements(self.comboBoxEnum.itemData(num)['Parameters'], xmlAllElements, positionSelectedLabel, listComboBoxesIndex)
        # fctWidget.loadXmlElements(self.comboBoxEnum.currentData()['Parameters'], xmlAllElements, positionSelectedLabel, listComboBoxesIndex)


