import sys
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import UsefullVariables as vrb
import UsefullTexts as txt
import UsefullWidgets as wgt

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

import WidgetTypes

import os
import subprocess
import fnmatch

from StartWindow import findRegisterLicenceExe
from StartWindow import findReleaseDir

import PyIPSDK

# def findRegisterLicenceExe(inPath):
#     pattern = "RegisterIPSDKLicense_*"
#     result = []
#     for root, dirs, files in os.walk(inPath):
#         for name in files:
#             if fnmatch.fnmatch(name, pattern):
#                 result.append(os.path.join(root, name))
#     return result

class AboutWidget(qt.QWidget):
    """
    Interactive code editor
    Has a quick guide
    """
    def __init__(self):
        super().__init__()

        pixmap = QtGui.QPixmap(vrb.folderImages + '/Explorer_Logo_Bleu.png')
        # pixmap = pixmap.scaled(591, 368, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
        pixmap = pixmap.scaled(300, 187, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
        self.labelImage = qt.QLabel()
        self.labelImage.setPixmap(pixmap)

        self.labelAdress = qt.QTextBrowser()
        self.labelAdress.setLineWrapMode(False)
        self.labelAdress.setAlignment(Qt.AlignCenter)
        self.labelAdress.setStyleSheet('QTextBrowser {background-color: transparent;}')

        self.buttonActivate = qt.QPushButton("Activate")
        self.buttonActivate.setFixedWidth(70 * vrb.ratio)
        self.buttonActivate.setStyleSheet("""QPushButton
        {
            color: #ffffff;
            background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #565656, stop: 0.1 #525252, stop: 0.5 #4e4e4e, stop: 0.9 #4a4a4a, stop: 1 #464646);
            border-width: 1px;
            border-color: #1e1e1e;
            border-style: solid;
            padding: 3px;
            padding-left: 5px;
            padding-right: 5px;
        }""")

        self.buttonClose = qt.QPushButton("Close")
        self.buttonClose.setFixedWidth(50*vrb.ratio)
        self.buttonClose.setStyleSheet("""QPushButton
{
    color: #ffffff;
    background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #565656, stop: 0.1 #525252, stop: 0.5 #4e4e4e, stop: 0.9 #4a4a4a, stop: 1 #464646);
    border-width: 1px;
    border-color: #1e1e1e;
    border-style: solid;
    padding: 3px;
    padding-left: 5px;
    padding-right: 5px;
}""")

        self.layout = qt.QGridLayout()
        self.layout.addWidget(self.labelImage, 0, 0,1,2)
        self.layout.addWidget(self.labelAdress, 1, 0,1,2)
        self.layout.addWidget(self.buttonActivate, 2, 0)
        self.layout.addWidget(self.buttonClose, 2, 1,Qt.AlignLeft)

        self.layout.setAlignment(Qt.AlignTop)

        self.setLayout(self.layout)

        text = self.getMainText()
        self.labelAdress.setHtml(text)

        self.layout.setContentsMargins(10,10,10,10)
        self.setFixedSize(320*vrb.ratio,555*vrb.ratio)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.setWindowTitle("About Explorer")
        self.setStyleSheet('QWidget {background-color: rgb(70,70,70);}')

        self.buttonClose.clicked.connect(self.closeWidget)
        self.buttonActivate.clicked.connect(self.activateLicense)

    def getMainText(self,activate = False):

        try:
            style = f'h1{{color:rgb(220,220,220);font-size:{20*vrb.ratio}px;}}\n'
            style += f'.h2{{color:rgb(220,220,220);font-size:{14*vrb.ratio}px}}\n'

            text = '<head>\n'
            text += '<style>\n'
            text += style
            text += '</style>\n'
            text += '</head>\n'
            text += '<body>\n'
            text += '\n'
            text += "<h1>Reactiv'IP</h1><br/>\n"
            text += '<span class="h2">82 cours Berriat</span>' + '\n<br/>'
            text += '<span class="h2">38000 Grenoble</span>' + '<br/>'
            text += '<span class="h2">France</span>' + '\n<br/>'
            text += '<br/>'
            text += '<span class="h2">Phone: +33 (0)4 58 00 38 85</span>' + '\n<br/>'
            text += '<span class="h2">Fax: +33 (0)9 55 55 16 48</span>' + '\n<br/>'
            text += '<br/>'
            text += '<span class="h2">E-mail: info@reactivip.com</span>' + '\n<br/>'
            text += '<span class="h2">Website: https://reactivip.com  </span>' + '\n<br/>'
            text += '<br/>'
            text += '<span class="h2">Version: ' + vrb.currentVersion + '</span>' + '\n<br/>'

            if PyIPSDK.areModulesHiddenInExplorer() == False:
                if PyIPSDK.are3dProcessesSupported():
                    text += '<span class="h2">Modules: 2D/3D</span>' + '\n<br/>'
                else:
                    text += '<span class="h2">Modules: 2D</span>' + '\n<br/>'

            if PyIPSDK.isPartnerLicense():
                textType = "Partner "
            if PyIPSDK.isToolKitLicense():
                textType = "ToolKit "
            if PyIPSDK.isRunTimeLicense():
                textType = "RunTime "
            text += '<span class="h2">Type: ' + textType + '</span>' + '\n<br/>'

            if activate == False or (os.path.exists(PyIPSDK.getIPSDKDefaultDirectory(PyIPSDK.eDefaultExternalDirectory.eDED_CommonConfig)+"/ipsdk.rlf")==False and
                                     os.path.exists(PyIPSDK.getIPSDKDefaultDirectory(PyIPSDK.eDefaultExternalDirectory.eDED_UserConfig) + "/ipsdk.rlf")==False):

                if PyIPSDK.isFreeTrial():
                    textLicense = "Free trial ("+str(PyIPSDK.getNbDaysForFreeTrialExpiration())+" days remaining)"
                    self.buttonActivate.setVisible(True)
                    self.layout.addWidget(self.buttonActivate, 2, 0)
                    self.layout.addWidget(self.buttonClose, 2, 1, Qt.AlignLeft)
                elif PyIPSDK.isLicenseExpiryDateDefined():
                    textLicense = "Provisory (" + str(PyIPSDK.nbDaysToExpiration()) + " days remaining)"
                    self.buttonActivate.setVisible(True)
                    self.layout.addWidget(self.buttonActivate, 2, 0)
                    self.layout.addWidget(self.buttonClose, 2, 1, Qt.AlignLeft)
                else:
                    textLicense = "Definitive"
                    self.buttonActivate.setVisible(False)
                    self.layout.addWidget(self.buttonClose, 2, 0, Qt.AlignLeft)
            else:
                textLicense = "Restart Explorer to actualize"
                self.buttonActivate.setVisible(False)
                self.layout.addWidget(self.buttonClose, 2, 0, Qt.AlignLeft)

            text += '<br/>'
            text += '<span class="h2">License: ' + textLicense + '</span>' + '\n<br/>'

        except:
            text = ""

        return text

    def activateLicense(self):

        try:
            self.setWindowFlag(self.windowFlags() & ~Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(self.windowFlags() & ~Qt.WindowStaysOnTopHint)

        self.show()
        qt.QApplication.processEvents()

        folderParent = os.path.dirname(vrb.folderExplorer)
        releasePath = findReleaseDir(folderParent + "/bin")

        registerLicenceExePath = findRegisterLicenceExe(releasePath)
        #registerLicenceExePath = findRegisterLicenceExe(folderParent + "/Output/Release_msvc15_x64")
        subprocess.check_call(registerLicenceExePath)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.show()

        text = self.getMainText(activate=True)
        self.labelAdress.setText(text)

    def closeWidget(self):

        self.close()

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook


    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)


    sys.excepthook = exception_hook


    # foo = LineEditIf()
    # foo.layout.setContentsMargins(5, 5, 5, 5)

    foo = AboutWidget()
    import UsefullFunctions as fct
    # style = fct.getStyleSheet()
    # foo.setStyleSheet(style)
    foo.show()

    app.exec_()