import PyIPSDK
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKUI as ui

def My_function( inImg, minValue, maxValue):

	img1 = filtering.gaussianSmoothing2dImg(inImg, 2.0)
	res = ui.interactiveThreshold(img1,minValue=minValue,maxValue=maxValue,title = "Interactive threshold")
		
	if res.bValidated:

		img2 = res.thresholdedImg	
		if inImg.getSizeZ() == 1:
			img3 = advmorpho.watershedBinarySeparation2dImg(img2, 4, PyIPSDK.eWatershedSeparationMode.eWSM_SplitLabel)
		else:
			img3 = advmorpho.watershedBinarySeparation3dImg(img2, 4, PyIPSDK.eWatershedSeparationMode.eWSM_SplitLabel)
	
	else:
		img3 = None	
	
	return img3










































