import PyIPSDK
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans

def processFiltering(inImg_, nbIter_, sigmaX_, sigmaY_,alpha_,gpu):

	# gabor image function generation
	def generateGaborImg(inImg, sigmaX, sigmaY):
		width = inImg.getSizeX()
		height = inImg.getSizeY()
		cx = int(width / 2) + 1
		cy = int(height / 2) + 1
		sigmaX2 = sigmaX * sigmaX
		sigmaY2 = sigmaY * sigmaY
		xStr = "(" + str(cx) + "-x)"
		x2Str = xStr + "*" + xStr
		yStr = "(" + str(cy) + "-y)"
		y2Str = yStr + "*" + yStr
		formulaStr = "exp(-0.5 * (" + x2Str + "/" + str(sigmaX2) + " + " + y2Str + "/" + str(sigmaY2) + "))"
		gaborImg = arithm.formula2dImg(formulaStr, InOptImg1=inImg)

		return gaborImg

	def processFilteringPlan(inImg_, nbIter_, sigmaX_, sigmaY_,alpha_):

		# filtering function

		if gpu:
			refSizeX,refSizeY = None,None
			sizeX_padded, sizeY_padded, sizeZ_padded = PyIPSDK.computePaddedImageSize(inImg_.getSizeX(), inImg_.getSizeY(), 1)
			if sizeY_padded != inImg_.getSizeX() or sizeY_padded != inImg_.getSizeY():
				refSizeX,refSizeY = inImg_.getSizeX(),inImg_.getSizeY()
				imagePadded = PyIPSDK.createImage(inImg_.getBufferType(), sizeX_padded, sizeY_padded)
				util.eraseImg(imagePadded, 0)
				util.putROI2dImg(imagePadded,inImg_,0,0,imagePadded)
				inImg_ = imagePadded

		wk1RImg = generateGaborImg(inImg_, sigmaX_, sigmaY_)
		nbRows = inImg_.getSizeY()
		nbCols = inImg_.getSizeX()

		if gpu:
			inImg_ = inImg_.toGPU()
			wk1RImg = wk1RImg.toGPU()

		dftConfig = PyIPSDK.createDFTConfig(PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native, PyIPSDK.eDFTCoordinates.eDFTC_Cartesian, PyIPSDK.eDFTScalePolicy.eDFTSP_Default)

		wk2RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		util.eraseImg(wk2RImg,0)
		wk2RImg.array[0, 0] = 1
		wk2RImg.array[nbRows - 1, 0] = -1
		if gpu:
			wk2RImg = wk2RImg.toGPU()

		wk3RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		util.eraseImg(wk3RImg,0)
		wk3RImg.array[0, 0] = 1
		wk3RImg.array[0, nbCols - 1] = -1
		if gpu:
			wk3RImg = wk3RImg.toGPU()

		wk4RImg,wk5RImg = itrans.forwardDiscreteFourierTransform2dImg(wk2RImg, dftConfig)
		wk6RImg, wk7RImg = itrans.forwardDiscreteFourierTransform2dImg(wk3RImg, dftConfig)
		itrans.forwardDiscreteFourierTransform2dImg(inImg_, dftConfig,wk2RImg,wk3RImg)
		wk8RImg,wk9RImg = itrans.forwardDiscreteFourierTransform2dImg(wk1RImg, dftConfig)

		arithm.squareImg(wk8RImg,wk8RImg)
		arithm.squareImg(wk9RImg,wk9RImg)
		arithm.addImgImg(wk8RImg, wk9RImg,wk8RImg)

		arithm.multiplyImgImg(wk4RImg, wk2RImg, wk9RImg)
		wk10RImg = arithm.multiplyImgImg(wk5RImg, wk3RImg)
		arithm.subtractImgImg(wk9RImg, wk10RImg,wk9RImg)
		arithm.multiplyImgImg(wk5RImg, wk2RImg,wk10RImg)
		wk11RImg = arithm.multiplyImgImg(wk4RImg, wk3RImg)
		arithm.addImgImg(wk10RImg, wk11RImg, wk10RImg)

		itrans.backwardDiscreteFourierTransform2dImg(wk9RImg, wk10RImg, dftConfig,wk9RImg)

		arithm.multiplyImgImg(wk6RImg, wk2RImg, wk10RImg)
		arithm.multiplyImgImg(wk7RImg, wk3RImg,wk11RImg)
		arithm.subtractImgImg(wk10RImg, wk11RImg,wk10RImg)
		arithm.multiplyImgImg(wk7RImg, wk2RImg,wk2RImg)
		arithm.multiplyImgImg(wk6RImg, wk3RImg,wk3RImg)
		arithm.addImgImg(wk2RImg, wk3RImg, wk2RImg)

		wk2RImg = itrans.backwardDiscreteFourierTransform2dImg(wk10RImg, wk2RImg, dftConfig)

		arithm.squareImg(wk4RImg,wk3RImg)
		arithm.squareImg(wk5RImg,wk10RImg)
		arithm.addImgImg(wk3RImg, wk10RImg,wk3RImg)

		arithm.squareImg(wk6RImg,wk10RImg)
		arithm.squareImg(wk7RImg,wk11RImg)
		arithm.addImgImg(wk10RImg, wk11RImg,wk10RImg)

		arithm.addImgImg(wk3RImg, wk10RImg, wk3RImg)

		arithm.multiplyImgImg(wk3RImg, wk8RImg, wk3RImg)
		if gpu:
			cpuImg = wk3RImg.toCPU()
			maxValue = glbmsr.statsMsr2d(cpuImg).max
			cpuImg = None
		else:
			maxValue = glbmsr.statsMsr2d(wk3RImg).max
		#L = (2 / alpha_) * maxValue
		L = 2 * maxValue

		util.eraseImg(wk3RImg,0)
		util.eraseImg(wk10RImg, 0)
		util.eraseImg(wk11RImg, 0)
		wk12RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		if gpu:
			wk12RImg = wk12RImg.toGPU()
		util.eraseImg(wk12RImg, 0)

		wk13RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		wk14RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		wk15RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		wk16RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		wk17RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		wk18RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		wk19RImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Real32, nbCols, nbRows)
		wk1BImg = PyIPSDK.createImage(PyIPSDK.eImageBufferType.eIBT_Binary, nbCols, nbRows)
		if gpu:
			wk13RImg = wk13RImg.toGPU()
			wk14RImg = wk14RImg.toGPU()
			wk15RImg = wk15RImg.toGPU()
			wk16RImg = wk16RImg.toGPU()
			wk17RImg = wk17RImg.toGPU()
			wk18RImg = wk18RImg.toGPU()
			wk19RImg = wk19RImg.toGPU()
			wk1BImg = wk1BImg.toGPU()

		for iter in range(0, nbIter_):

			itrans.forwardDiscreteFourierTransform2dImg(wk3RImg, dftConfig,wk13RImg, wk14RImg)
			itrans.forwardDiscreteFourierTransform2dImg(wk10RImg, dftConfig,wk15RImg, wk16RImg)

			arithm.multiplyScalarImg(wk5RImg, -1,wk17RImg)

			arithm.multiplyImgImg(wk4RImg, wk13RImg, wk18RImg)
			arithm.multiplyImgImg(wk17RImg, wk14RImg, wk19RImg)
			arithm.subtractImgImg(wk18RImg, wk19RImg, wk18RImg)
			arithm.multiplyImgImg(wk17RImg, wk13RImg, wk13RImg)
			arithm.multiplyImgImg(wk4RImg, wk14RImg, wk14RImg)
			arithm.addImgImg(wk13RImg, wk14RImg, wk13RImg)

			arithm.multiplyScalarImg(wk7RImg, -1,wk14RImg)

			arithm.multiplyImgImg(wk6RImg, wk15RImg, wk17RImg)
			arithm.multiplyImgImg(wk14RImg, wk16RImg, wk19RImg)
			arithm.subtractImgImg(wk17RImg, wk19RImg, wk17RImg)
			arithm.multiplyImgImg(wk14RImg, wk15RImg, wk14RImg)
			arithm.multiplyImgImg(wk6RImg, wk16RImg, wk15RImg)
			arithm.addImgImg(wk14RImg, wk15RImg, wk14RImg)

			arithm.addImgImg(wk18RImg,wk17RImg,wk17RImg)
			arithm.addImgImg(wk13RImg,wk14RImg,wk13RImg)

			arithm.multiplyImgImg(wk17RImg,wk8RImg,wk14RImg)
			arithm.multiplyImgImg(wk13RImg, wk8RImg,wk13RImg)

			arithm.multiplyScalarImg(wk14RImg,1/2,wk14RImg)
			arithm.multiplyScalarImg(wk13RImg,1/2,wk13RImg)

			util.copyImg(wk11RImg,wk15RImg)
			util.copyImg(wk12RImg,wk16RImg)

			arithm.multiplyImgImg(wk14RImg, wk4RImg, wk17RImg)
			arithm.multiplyImgImg(wk13RImg, wk5RImg, wk18RImg)
			arithm.subtractImgImg(wk17RImg, wk18RImg, wk17RImg)
			arithm.multiplyImgImg(wk13RImg, wk4RImg, wk18RImg)
			arithm.multiplyImgImg(wk14RImg, wk5RImg, wk19RImg)
			arithm.addImgImg(wk18RImg, wk19RImg, wk18RImg)

			itrans.backwardDiscreteFourierTransform2dImg(wk17RImg, wk18RImg, dftConfig,wk17RImg)
			arithm.subtractImgImg(wk9RImg, wk17RImg,wk11RImg)

			arithm.multiplyImgImg(wk14RImg, wk6RImg, wk17RImg)
			arithm.multiplyImgImg(wk13RImg, wk7RImg, wk18RImg)
			arithm.subtractImgImg(wk17RImg, wk18RImg, wk17RImg)
			arithm.multiplyImgImg(wk13RImg, wk6RImg, wk18RImg)
			arithm.multiplyImgImg(wk14RImg, wk7RImg, wk19RImg)
			arithm.addImgImg(wk18RImg, wk19RImg, wk18RImg)

			itrans.backwardDiscreteFourierTransform2dImg(wk17RImg, wk18RImg, dftConfig,wk17RImg)

			arithm.subtractImgImg(wk2RImg, wk17RImg,wk12RImg)

			arithm.multiplyScalarImg(wk11RImg, 1 / L,wk11RImg)
			arithm.addImgImg(wk3RImg, wk11RImg,wk11RImg)
			arithm.multiplyScalarImg(wk12RImg, 1 / L,wk12RImg)
			arithm.addImgImg(wk10RImg, wk12RImg,wk12RImg)

			arithm.l2Norm2Img(wk11RImg, wk12RImg,wk17RImg)

			bin.thresholdImg(wk17RImg, 1,PyIPSDK.getMaxValue(PyIPSDK.eImageBufferType.eIBT_Real32),wk1BImg)
			arithm.divideImgImg(wk11RImg, wk17RImg,wk18RImg)
			logic.maskImgImg(wk18RImg, wk11RImg, wk1BImg,wk11RImg)
			arithm.divideImgImg(wk12RImg, wk17RImg,wk18RImg)

			logic.maskImgImg(wk18RImg, wk12RImg, wk1BImg,wk12RImg)

			factor = iter / (iter + 3.0)
			arithm.subtractImgImg(wk11RImg, wk15RImg,wk3RImg)
			arithm.multiplyScalarImg(wk3RImg, factor,wk3RImg)
			arithm.addImgImg(wk3RImg, wk11RImg,wk3RImg)

			arithm.subtractImgImg(wk12RImg, wk16RImg, wk10RImg)
			arithm.multiplyScalarImg(wk10RImg, factor, wk10RImg)
			arithm.addImgImg(wk10RImg, wk12RImg, wk10RImg)

		itrans.backwardDiscreteFourierTransform2dImg(wk14RImg, wk13RImg, dftConfig,wk15RImg)
		fayImg_F = None
		noiseImg = arithm.multiplyScalarImg(wk15RImg, alpha_)
		fayImg = None
		filteredImg = arithm.subtractImgImg(inImg_, noiseImg)

		noiseImg = util.convertImg(noiseImg,inImg_.getBufferType())
		filteredImg = util.convertImg(filteredImg,inImg_.getBufferType())

		if gpu:
			filteredImg = filteredImg.toCPU()
			filteredImg = util.copyImg(filteredImg)
			noiseImg = noiseImg.toCPU()
			noiseImg = util.copyImg(noiseImg)

			if refSizeX is not None:
				filteredImg = util.getROI2dImg(filteredImg,0,0,refSizeX,refSizeY)
				noiseImg = util.getROI2dImg(noiseImg,0,0,refSizeX,refSizeY)

		return filteredImg, noiseImg

	if inImg_.getSizeZ() == 1:
		filteredImg, noiseImg = processFilteringPlan(inImg_, nbIter_, sigmaX_, sigmaY_,alpha_)
	else:
		filteredImg = PyIPSDK.createImage(inImg_)
		noiseImg = PyIPSDK.createImage(inImg_)

		for i in range(inImg_.getSizeZ()):
			plan = PyIPSDK.extractPlan(i,0,0,inImg_)
			plan = util.copyImg(plan)
			filteredOutPlan, noiseOutPlan = processFilteringPlan(plan, nbIter_, sigmaX_, sigmaY_,alpha_)

			filteredPlan = PyIPSDK.extractPlan(i,0,0,filteredImg)
			noisePlan = PyIPSDK.extractPlan(i,0,0,noiseImg)

			util.copyImg(filteredOutPlan,filteredPlan)
			util.copyImg(noiseOutPlan,noisePlan)

	return filteredImg, noiseImg















