import PyIPSDK
import PyIPSDK.IPSDKIPLMorphology as morpho
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLFiltering as filtering
import numpy as np
from UsefullWidgets import Measure


def my_function(imageLabel):

	kernels = []
	sum = 0
	output = []
	
	myMsr = glbmsr.statsMsr2d(imageLabel)
	nbLabels = myMsr.max

	if imageLabel.hasGeometricCalibration():
		calibration = imageLabel.getGeometricCalibration()
	else:
		calibration = PyIPSDK.createGeometricCalibration2d(1,1,'px')

	unit = calibration.getUnitStr()
	xScale = calibration.getXScale()
	yScale = calibration.getYScale()

	factor = 1
	if unit == "m":
		factor = 1000000
	if unit == "cm":
		factor = 10000
	if unit == "mm":
		factor = 1000
	if unit == "um":
		factor = 1
	if unit == "nm":
		factor = 0.001
	if unit == "px":
		factor = 1

	ratioConversion = np.power(factor,2)

	imageBinaryNot = bin.thresholdImg(imageLabel, 0, 0)
	imageBinary = bin.thresholdImg(imageLabel, 1, nbLabels)
	logic.logicalNotImg(imageBinary, imageBinary)

	inSE = PyIPSDK.circularSEXYInfo(1)
	imageBinary = morpho.closing2dImg(imageBinary, inSE)

	size = glbmsr.statsMsr2d(imageBinary).sum

	pixelsFactor = (2*np.sqrt(ratioConversion) + 2*np.sqrt(2)*np.sqrt(ratioConversion))/1000

	valueColl = [0, 0, 0, 0, 2, -1, 0, 0, 0]
	kernels.append(PyIPSDK.rectangularKernelXY(1, 1, valueColl))
	valueColl = [0, 0, 0, 0, 2, 0, -1, 0, 0]
	kernels.append(PyIPSDK.rectangularKernelXY(1, 1, valueColl))
	valueColl = [0, 0, 0, 0, 2, 0, 0, -1, 0]
	kernels.append(PyIPSDK.rectangularKernelXY(1, 1, valueColl))
	valueColl = [0, 0, 0, 0, 2, 0, 0, 0, -1]
	kernels.append(PyIPSDK.rectangularKernelXY(1, 1, valueColl))

	for kernel in kernels:
		outImg = filtering.convolution2dImg(imageBinaryNot, kernel, False)
		outImg = bin.thresholdImg(outImg,2,2)

		sum += glbmsr.statsMsr2d(outImg).sum

	if size != 0:
		interceptValue = sum / (size*pixelsFactor)
	else:
		interceptValue = 0

	if interceptValue > 0:
		interceptValue = -3.2877 + 6.6439 * np.log10(interceptValue)
	else:
		interceptValue = 0

	ddict = {}
	ddict["Name"] = imageLabel.name
	ddict["Surface ("+unit+")"] = str(float("{:.2f}".format(size*xScale*yScale)))

	ddict["Intercept"] = str(float("{:.2f}".format(interceptValue)))

	measure = Measure()
	measure.subType = "Dict"

	measure.value = ddict
	return measure
